/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Binding;
import com.icl.saxon.Context;
import com.icl.saxon.Mode;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.RuleManager;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.style.Procedure;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.TemplateExpander;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.trace.TraceListener;
import org.xml.sax.SAXException;

public class XSLTemplate
extends StyleElement {
    protected String modeName = null;
    protected String templateName;
    protected Pattern match;
    protected boolean prioritySpecified;
    protected double priority;
    protected Procedure procedure = new Procedure();

    public String getTemplateName() {
        return this.templateName;
    }

    public int getMinImportPrecedence() throws SAXException {
        return ((XSLStyleSheet)this.getDocumentElement()).getMinImportPrecedence();
    }

    public void prepareAttributes() throws SAXException {
        String string;
        Object object;
        Object object2;
        this.checkAllowedAttributes();
        String string2 = this.getAttributeValue("mode");
        if (string2 != null) {
            object2 = new Name(string2, this, false);
            this.modeName = ((Name)object2).getAbsoluteName();
        }
        if ((object2 = this.getAttributeValue("name")) != null) {
            object = new Name((String)object2, this, false);
            this.templateName = ((Name)object).getAbsoluteName();
        }
        boolean bl = this.prioritySpecified = (object = this.getAttributeValue("priority")) != null;
        if (this.prioritySpecified) {
            try {
                this.priority = new Double(((String)object).trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw this.styleError("Invalid numeric value for priority (" + this.priority + ")");
            }
        }
        if ((string = this.getAttributeValue("match")) != null) {
            this.match = Pattern.make(string, this);
        }
        if (this.match == null && object2 == null) {
            throw this.styleError("xsl:template must have a a name or match attribute (or both)");
        }
    }

    protected void checkAllowedAttributes() throws SAXException {
        String[] stringArray = new String[]{"name", "mode", "match", "priority"};
        this.allowAttributes(stringArray);
    }

    public void validate() throws SAXException {
        this.checkTopLevel();
        if (this.templateName != null) {
            NodeInfo nodeInfo = (NodeInfo)this.getPreviousSibling();
            while (nodeInfo != null) {
                XSLTemplate xSLTemplate;
                if (nodeInfo instanceof XSLTemplate && (xSLTemplate = (XSLTemplate)nodeInfo).getTemplateName() == this.getTemplateName() && xSLTemplate.getPrecedence() == this.getPrecedence()) {
                    throw this.styleError("There is another template with the same name and precedence");
                }
                nodeInfo = (NodeInfo)nodeInfo.getPreviousSibling();
            }
        }
    }

    public void preprocess() throws SAXException {
        TemplateExpander templateExpander = new TemplateExpander(this);
        RuleManager ruleManager = this.getPrincipalStyleSheet().getRuleManager();
        Mode mode = ruleManager.getMode(this.modeName);
        if (this.match != null) {
            if (this.prioritySpecified) {
                ruleManager.setHandler(this.match, templateExpander, mode, this.getPrecedence(), this.priority);
            } else {
                ruleManager.setHandler(this.match, templateExpander, mode, this.getPrecedence());
            }
        }
        this.getPrincipalStyleSheet().allocateLocalSlots(this.procedure.getNumberOfVariables());
    }

    public void process(Context context) throws SAXException {
    }

    public void expand(Context context) throws SAXException {
        if (context.getController().isTracing()) {
            TraceListener traceListener = context.getController().getTraceListener();
            traceListener.enter(this, context);
            this.realExpand(context);
            traceListener.leave(this, context);
        } else {
            this.realExpand(context);
        }
    }

    private void realExpand(Context context) throws SAXException {
        ParameterSet parameterSet = null;
        do {
            context.setTailRecursion(null);
            this.processChildren(context);
            parameterSet = context.getTailRecursion();
            if (parameterSet == null) continue;
            context.getBindery().closeStackFrame();
            context.getBindery().openStackFrame(parameterSet);
        } while (parameterSet != null);
    }

    public Binding bindVariable(String string) throws SAXException {
        throw this.styleError("The match pattern in xsl:template may not contain references to variables");
    }

    public Procedure getProcedure() {
        return this.procedure;
    }
}

