/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.Context;
import com.icl.saxon.Version;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.TextInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tree.DOMExceptionImpl;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

class TextImpl
extends NodeImpl
implements TextInfo,
Text {
    private int start;
    private int length;
    private DocumentImpl root;

    public TextImpl(DocumentImpl documentImpl, int n, int n2) {
        this.root = documentImpl;
        this.start = n;
        this.length = n2;
    }

    public DocumentInfo getDocumentRoot() {
        return this.root;
    }

    public String getValue() {
        if (Version.isPreJDK12()) {
            char[] cArray = new char[this.length];
            this.root.getCharacterBuffer().getChars(this.start, this.start + this.length, cArray, 0);
            return new String(cArray, 0, this.length);
        }
        return this.root.getCharacterBuffer().substring(this.start, this.start + this.length);
    }

    public void appendValue(StringBuffer stringBuffer) {
        char[] cArray = new char[this.length];
        this.root.getCharacterBuffer().getChars(this.start, this.start + this.length, cArray, 0);
        stringBuffer.append(cArray, 0, this.length);
    }

    public final short getNodeType() {
        return 3;
    }

    public final Name getExpandedName() {
        return null;
    }

    public final String getNodeName() {
        return "#text";
    }

    public void copy(Outputter outputter) throws SAXException {
        outputter.writeContent(this.root.getCharacterBuffer(), this.start, this.length);
    }

    public void copyStringValue(Outputter outputter) throws SAXException {
        outputter.writeContent(this.root.getCharacterBuffer(), this.start, this.length);
    }

    public void defaultAction(Context context) throws SAXException {
        context.getOutputter().writeContent(this.root.getCharacterBuffer(), this.start, this.length);
    }

    public boolean isWhite() {
        StringBuffer stringBuffer = this.root.getCharacterBuffer();
        int n = 0;
        while (n < this.length) {
            char c = stringBuffer.charAt(this.start + n);
            if (c > ' ') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int getStartPosition() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    public String getPath() {
        String string = ((NodeInfo)this.getParentNode()).getPath();
        return (string.equals("/") ? "" : string) + "/text()[" + this.getNumberSimple() + "]";
    }

    public String toString() {
        try {
            String string = this.parent.getDisplayName();
            String string2 = this.getValue();
            if (string2.length() > 40) {
                string2 = string2.substring(0, 40) + " ...";
            }
            return "<" + string + ">" + string2 + "</" + string + ">";
        }
        catch (Exception exception) {
            return "#text";
        }
    }

    public void increaseLength(int n) {
        this.length += n;
    }

    public void truncateToStart() {
        this.root.getCharacterBuffer().setLength(this.start);
    }

    public String getData() {
        return this.getValue();
    }

    public void setData(String string) throws DOMException {
        this.disallowUpdate();
    }

    public String substringData(int n, int n2) throws DOMException {
        try {
            return this.getValue().substring(n, n + n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, "substringData: index out of bounds");
        }
    }

    public void appendData(String string) throws DOMException {
        this.disallowUpdate();
    }

    public void insertData(int n, String string) throws DOMException {
        this.disallowUpdate();
    }

    public void deleteData(int n, int n2) throws DOMException {
        this.disallowUpdate();
    }

    public void replaceData(int n, int n2, String string) throws DOMException {
        this.disallowUpdate();
    }

    public Text splitText(int n) throws DOMException {
        this.disallowUpdate();
        return null;
    }
}

