.TH XLOADIMAGE 1 "8 May 1991"
.SH NAME
xloadimage, xsetbg, xview \- load images into an X11 window or onto
the root window
.SH SYNOPSIS
\fIxloadimage\fR [global_options] {[image_options] image ...}
.br
\fIxloadimage\fR [global_options] [image_options] stdin < image
.SH DESCRIPTION
\fIXloadimage\fR displays images in an X11 window, loads them onto the
root window, or writes them into a file.  Many image types are
recognized; use the \fI-supported\fR option to list them.
.PP
If the filename \fIstdin\fR is given, xloadimage will read the image
from standard input if this capability is supported by the loader for
that image type (most types do support reading from stdin).
.PP
If the destination display cannot support the number of colors in the
image, the image will be dithered (monochrome destination) or have its
colormap reduced (color destination) as appropriate.  This can also be
done forcibly with the \fI-halftone\fR, \fI-dither\fR, and
\fI-colors\fR options.
.PP
A variety of image manipulations can be specified, including gamma
correction, brightening, clipping, dithering, depth-reduction,
rotation, and zooming.  Most of these manipulations have simple
implementations; speed was opted for above accuracy.
.PP
If you are viewing a large image in a window, the initial window will
be at most 90% of the size of the display unless the window manager
does not correctly handle window size requests or if you've used the
\fI-fullscreen\fR option.  You may move the image around in the window
by dragging with the first mouse button.  The cursor will indicate
which directions you may drag, if any.  You may exit the window by
typing 'q' or '^C' when the keyboard focus is on the window.
.PP
If more than one image file is specified on the command line, each
image will be shown in order (except if \fI-merge\fR or \fI-goto\fR
are being used).
.PP
A wide variety of common image manipulations can be done by mixing and
matching the available options.  See the section entitled \fIHINTS FOR
GOOD IMAGE DISPLAYS\fR for some ideas.
.PP
The \fI-dump\fR option causes an image to be written to a file rather
than displayed after processing.  This allows you to read an image,
perform a number of processing operations on it, and save the
resultant image.  This also allows translation from any of the
recognized image types into any of the formats that support dumping.
.PP
\fIXsetbg\fR is equivalent to \fIxloadimage -onroot -quiet\fR and
\fIxview\fR is equivalent to \fIxloadimage -view -verbose\fR.
.SH RESOURCE CLASS
\fIXloadimage\fR uses the resource class name \fIXloadimage\fR for
window managers which need this resource set.  This name changed
in version 2.00 and 2.01; some previous versions used the name
\fIXLoadImage\fR (which was difficult to predict) or \fIxloadimage\fR
(which conflicted with class naming conventions).
.SH GLOBAL OPTIONS
The following options affect the global operation of \fIxloadimage\fR.
They may be specified anywhere on the command line.  Additionally the
\fI-global\fR option can be used to force an image option to apply to
all images.
.TP 8
-border \fIcolor\fR
This sets the background portion of the window which is not covered by
any images to be \fIcolor\fR.
.TP
-configuration
Displays the image path, image suffixes, and supported filters which
will be used when looking for and reading images.  These are loaded
from ~/.xloadimagerc and optionally from a systemwide file (normally
/usr/lib/xloadimagerc).  This replaces the -path option.
.TP
-default
Use the default root weave as the image.  This option forces
\fI-onroot\fR.  If \fI-default\fR is used alone, it is the same as
\fIxsetroot\fR with no arguments.  If used in conjunction with
\fI-tile\fR this option can be used to place images on the default
root weave (see \fBEXAMPLES\fR below).
.TP
-debug
Talk to the X server in synchronous mode.  This is useful for
debugging.  If an X error is seen while in this mode, a core will be
dumped.
.TP
-delay \fIsecs\fR
Automatically advance to the next image after \fIsecs\fR seconds.
.TP
-display \fIdisplay_name\fR
X11 display name to send the image(s) to.
.TP
-dump \fIimage_type[,option[=value]]\fR \fIdump_file\fR
Rather than displaying the loaded and processed image, dump it into an
image file of the specified type.  For a list of image types that can
be dumped, use the \fI-supported\fR option.  Some image types have
options that affect the format of the file that's created.  See
\fBDUMP OPTIONS\fR below.  An image can be dumped in any supported
dump format regardless of the original image type, so image file type
translation is possible using this option.
.TP
-fit
Force image to use the default visual and colormap.  This is useful if
you do not want technicolor effects when the colormap focus is inside
the image window, but it may reduce the quality of the displayed
image.  This is on by default if -onroot or -windowid is specified.
.TP
-fork
Fork xloadimage.  This causes xloadimage to disassociate itself from
the shell.  This option automatically turns on -quiet.
.TP
-fullscreen
Use the entire screen to display images.  If combined with -onroot,
the image will be zoomed to fill the entire rootwindow.
.TP
-geometry \fIWxH[{+-X}{+-}Y]\fR
This sets the size of the window onto which the images are loaded to a
different value than the size of the image.  When viewing an image in
a window, this can be used to reduce the size of the destination
window.  When loading an image onto the root window, this option
controls the size of the pixmap which will be loaded onto the root.
If the size is smaller than that of the display, the image will be
replicated.
.TP
-goto image_name
Forces the next image to be displayed to be the image named
\fIimage_name\fR.  This is useful for generating looped slideshows.
If more than one image of the same name as the target exists on the
argument list, the first in the argument list is used.
.TP
-help [option ...]
Give information on an option or list of options.  If no option is
given, a simple interactive help facility is invoked.
.TP
-identify
Identify the supplied images rather than display them.
.TP
-install
Forcibly install the image's colormap when the window is focused.
This violates ICCCM standards and only exists to allow operation with
naive window managers.  Use this option only if your window manager
does not install colormaps properly.
.TP
-list
List the images which are along the image path.
.TP
-onroot
Load image(s) onto the root window instead of viewing in a window.
This option automatically sets the -fit option.
This is the opposite of \fI-view\fR.  \fIXSetbg\fR has this option set
by default.
.TP
-path
Displays miscellaneous information about the program configuration.
This option is obsolete and has been replaced by -configuration.
.TP
-pixmap
Force the use of a pixmap as backing-store.  This is provided for
servers where backing-store is broken (such as some versions of the
AIXWindows server).  It may improve scrolling performance on servers
which provide backing-store.
.TP
-private
Force the use of a private colormap.  Normally colors are allocated
shared unless there are not enough colors available.
.TP
-quiet
Forces \fIxloadimage\fR and \fIxview\fR to be quiet.  This is the
default for \fIxsetbg\fR, but the others like to whistle. 
.TP
-supported
List the supported image types. 
.TP
-type \fItype_name\fR
Forces \fIxloadimage\fR to try to load the image as a particular file
type rather than trying to guess.  This often improves load
performance noticably.
.TP
-verbose
Causes \fIxloadimage\fR to be talkative, telling you what kind of
image it's playing with and any special processing that it has to do. 
This is the default for \fIxview\fR and \fIxloadimage\fR. 
.TP
-version
Print the version number and patchlevel of this version of
\fIxloadimage\fR.
.TP
-view
View image(s) in a window.  This is the opposite of \fI-onroot\fR and
the default for \fIxview\fR and \fIxloadimage\fR. 
.TP
-visual \fIvisual_name\fR
Force the use of a specific visual type to display an image.  Normally
\fIxloadimage\fR tries to pick the best available image for a
particular image type.  The available visual types are:  DirectColor,
TrueColor, PseudoColor, StaticColor, GrayScale, and StaticGray.
Nonconflicting names may be abbreviated and case is ignored.
.TP
-windowid \fIhex_window_id\fR
Sets the background pixmap of a particular window ID.  The argument
must be in hexadecimal and must be preceeded by "0x" (\fIeg\fR
-windowid 0x40000b.  This is intended for setting the background
pixmap of some servers which use untagged virtual roots
(\fIeg\fR HP-VUE), but can have other interesting applications.
.SH IMAGE OPTIONS
The following options may preceed each image.  These options are
local to the image they preceed. 
.TP
-at \fIX\fR,\fIY\fR
Indicates coordinates to load the image at on the base image.  If
this is an option to the first image, and the \fI-onroot\fR option is
specified, the image will be loaded at the given location on the
display background. 
.TP
-background \fIcolor\fR
Use \fIcolor\fR as the background color instead of the default
(usually white but this depends on the image type) if you are
transferring a monochrome image to a color display. 
.TP
-brighten \fIpercentage\fR
Specify a percentage multiplier for a color image's colormap.  A value
of more than 100 will brighten an image, one of less than 100 will
darken it. 
.TP
-center
Center the image on the base image loaded.  If this is an option to
the first image, and the \fI-onroot\fR option is specified, the image
will be centered on the display background. 
.TP
-clip \fIX\fR,\fIY\fR,\fIW\fR,\fIH\fR
Clip the image before loading it.  \fIX\fR and \fIY\fR define the
upper-left corner of the clip area, and \fIW\fR and \fIH\fR define the
extents of the area.  A zero value for \fIW\fR or \fIH\fR will be
interpreted as the remainder of the image. 
.TP
-colors \fIn\fR
Specify the maximum number of colors to use in the image.  This is a
way to forcibly reduce the depth of an image.
.TP
-dither
Dither a color image to monochrome using a Floyd-Steinberg dithering
algorithm.  This happens by default when viewing color images on a
monochrome display.  This is slower than \fI-halftone\fR and affects
the image accuracy but usually looks much better.
.TP
-foreground \fIcolor\fR
Use \fIcolor\fR as the foreground color instead of black if you are
transferring a monochrome image to a color display.  This can also be
used to invert the foreground and background colors of a monochrome
image. 
.TP
-gamma \fIdisplay_gamma\fR
Specify the gamma correction for the display.
The default value is 1.0, a typical display needs 2.0 to 2.5.
.TP
-global
Force the following option to apply to all images rather than one
specific image.  Local image options will temporarily override any
option specified with -global.
.TP
-gray
Convert an image to grayscale.  This is very useful when displaying
colorful images on servers with limited color capability.  It can also
be used to convert a bitmap image into a grayscale image, although the
resulting image will be smaller than the original.  The optional
spelling \fI-grey\fR may also be used.
.TP
-halftone
Force halftone dithering of a color image when displaying on a
monochrome display.  This option is ignored on monochrome images.
This dithering algorithm blows an image up by sixteen times; if you
don't like this, the \fI-dither\fR option will not blow the image up
but will take longer to process and will be less accurate.
.TP
-idelay \fIsecs\fR
Set the delay to be used for this image to \fIsecs\fR seconds (see
\fI-delay\fR).  If \fI-delay\fR was specified, this overrides it.  If
it was not specified, this sets the automatic advance delay for this
image while others will wait for the user to advance them.
.TP
-invert
Inverts a monochrome image.  This is shorthand for \fI-foreground
white -background black\fR.
.TP
-merge
Merge this image onto the base image after local processing.  The base
image is considered to be the first image specified or the last image
that was not preceeded by \fI-merge\fR.  If used in conjunction with
\fI-at\fR and \fI-clip\fR, very complex images can be built up.  This
option is on by default for all images if the \fI-onroot\fR or
\fI-windowid\fR options are specified.
.TP
-name \fIimage_name\fR
Force the next argument to be treated as an image name.  This is
useful if the name of the image is \fI-dither\fR, for instance. 
.TP
-newoptions
Reset globally-specified options.
.TP
-normalize
Normalize a color image.
.TP
-rotate \fIdegrees\fR
Rotate the image by \fIdegrees\fR clockwise.  The number must be a
multiple of 90.
.TP
-shrink
Shrink an image down to fit on the display.  This is particularly
useful with servers that do not support window sizes larger than the
physical screen (eg DECWINDOWS servers).
.TP
-smooth
Smooth a color image.  This reduces blockiness after zooming an image
up.  If used on a monochrome image, nothing happens.  This option can
take awhile to perform, especially on large images.  You may specify
more than one \fI-smooth\fR option per image, causing multiple
iterations of the smoothing algorithm.
.TP
-tile
Tile this image (after any necessary merging or tiling) to create a
fullscreen image.  This is usually used to create a large background
image on which to merge other images.  \fI-geometry\fR can be used to
set the new image size to something other than -fullscreen.
.TP
-title \fItitle\fR
Change the title of the image.  This sets the title bar title if
displaying in a window or the NIFF file image title if dumping the
image.
.TP
-xzoom \fIpercentage\fR
Zoom the X axis of an image by \fIpercentage\fR.  A number greater
than 100 will expand the image, one smaller will compress it.  A zero
value will be ignored.  This option, and the related \fI-yzoom\fR are
useful for correcting the aspect ratio of images to be displayed.
.TP
-yzoom \fIpercentage\fR
Zoom the Y axis of an image by \fIpercentage\fR.  See \fI-xzoom\fR for
more information. 
.TP
-zoom \fIpercentage\fR
Zoom both the X and Y axes by \fIpercentage\fR.  See \fI-xzoom\fR for
more information.  Technically the percentage actually zoomed is the
square of the number supplied since the zoom is to both axes, but I
opted for consistency instead of accuracy.
.SH EXAMPLES
To load the rasterfile "my.image" onto the background and replicate
it to fill the entire background:
.sp
.ti +5
xloadimage -onroot my.image
.PP
To center an image on the default root background:
.sp
.ti +5
xloadimage -default -tile my.image
.sp
If using a monochrome display and a color image you will probably want
to dither the image for a cleaner (and faster) display:
.sp
.ti +5
xloadimage -default -tile -dither my.image
.PP
To load a monochrome image "my.image" onto the background, using red
as the foreground color, replicate the image, and overlay
"another.image" onto it at coordinate (10,10):
.sp
.ti +5
xloadimage -foreground red my.image -at 10,10 another.image
.PP
To center the rectangular region from 10 to 110 along the X axis and
from 10 to the height of the image along the Y axis:
.sp
.ti +5
xloadimage -center -clip 10,10,100,0 my.image
.PP
To double the size of an image:
.sp
.ti +5
xloadimage -zoom 200 my.image
.PP
To halve the size of an image:
.sp
.ti +5
xloadimage -zoom 50 my.image
.PP
To brighten a dark image:
.sp
.ti +5
xloadimage -brighten 150 my.image
.PP
To darken a bright image:
.sp
.ti +5
xloadimage -brighten 50 my.image
.SH HINTS FOR GOOD IMAGE DISPLAYS
Since images are likely to come from a variety of sources, they may be
in a variety of aspect ratios which may not be supported by your
display.  The \fI-xzoom\fR and \fI-yzoom\fR options can be used to
change the aspect ratio of an image before display.  If you use these
options, it is recommended that you increase the size of one of the
dimensions instead of shrinking the other, since shrinking looses
detail.  For instance, many GIF and G3 FAX images have an X:Y ratio of
about 2:1.  You can correct this for viewing on a 1:1 display with
either \fI-xzoom 50\fR or \fI-yzoom 200\fR (reduce X axis to 50% of
its size and expand Y axis to 200% of its size, respectively) but the
latter should be used so no detail is lost in the conversion.
.PP
When zooming color images up you can reduce blockiness with
\fI-smooth\fR.  For zooms of 300% or more, I recommend two smoothing
passes (although this can take awhile to do on slow machines).  There
will be a noticable improvement in the image.
.PP
You can perform image processing on a small portion of an image by
loading the image more than once and using the \fI-merge\fR, \fI-at\fR
and \fI-clip\fR options.  Load the image, then merge it with a
clipped, processed version of itself.  To brighten a 100x100 rectangular
portion of an image located at (50,50), for instance, you could type:
.sp
.ti +5
xloadimage my.image -merge -at 50,50 -clip 50,50,100,100 -brighten 150 my.image
.PP
If you're using a display with a small colormap to display colorful
images, try using the \fI-gray\fR option to convert to grayscale.
.SH PATHS AND EXTENSIONS
The file ~/.xloadimagerc (and optionally a system-wide file) defines a
number of configuration options that affect xloadimage.
.PP
This file is split into three section, the \fIpath\fR section, the
\fIextension\fR section, and the \fIfilter\fR section.  The sections
are identified by typing the section name followed by an equals sign,
eg "path =".
.PP
The \fIpath\fR statement is used to provide a set of search paths to
use when looking for an image of a specified name.  Separate each path
in the list by whitespace (eg one or more spaces, tabs, or newlines).
The path is searched in the order it is specified.  For example:
.PP
.nf
  path = ~/images /usr/local/images ~fred
.fi
.PP
will first look for the image name you specified, then look for the
name in ~/images (the tilde is expanded to the value of $HOME), then
in /usr/local/images, then in user fred's home directory.  This allows
easy use of image repositories.
.PP
The \fIextension\fR statement is used to provide a set of default
extensions to use when looking for an image of a specified name.
Separate each extension in the list by whitespace.  The extensions are
searched in the order in which they are specified.  For example:
.PP
.nf
  extension = .gif .jpg
.fi
.PP
If you have a file named \fImyimage.gif\fR you could specify the name
\fImyimage\fR and xloadimage would append the \fI.gif\fR extension
automatically.
.PP
The \fIfilter\fR statement is used to describe filter programs, such
as "uncompress", which are to be applied to image files automatically.
You specify one filter program and any number of recognized extensions
following the \fIfilter\fR keyword.  For example:
.PP
.nf
  filter = uncompress .Z
.fi
.PP
specifies that the program \fIuncompress\fR should be used as a filter
whenever an image file has a .Z extension.  By default filters are
provided for compressed (.Z) files and GNU zip (.gz) files.  See the
\fBFILTERS\fR section for more information on defining your own
filters.
.PP
Any text on a line following a hash-mark (#) is ignored; if you wish
to use a hash-mark in a path, extension, or filter you can escape it
using a backslash (\\).
.PP
If you wish to include white-space in a filter program name, path, or
extension you can enclose the entire text in double-quotes.  For
example:
.PP
.nf
  filter = "gzip -cd" .gz
.fi
.PP
Use backslash (\\) characters to allow inclusion of double-quote marks
or newlines.
.PP
The following is a sample ~/.xloadimagerc file:
.PP
.nf
  # paths to look for images in
  path = /usr/local/images        # system image repository
        ~/images                 # personal images
        /usr/include/X11/bitmaps # standard X bitmaps

  # default extensions for images
  extension = .csun .msun .sun .face .xbm .bm

  # invoke GNU zip if a .z or .zip extension is found
  filter = "gzip -cd" .z .zip

.fi
.PP
.SH IMAGE TYPES
.PP
\fIXloadimage\fR currently supports many common and some uncommon
image types, and can create images in several formats.  For a complete
list use the \fI-supported\fR option.
.SH DUMPING IMAGES
Several image dumpers are included that can be used to create a new
image after loading and processing.  The NIFF (Native Image File
Format) is the simplest and creates images that \fIxloadimage\fR can
read the fastest; it is essentially a copy of the internal image
format.
.PP
Some image dumpers allow options that affect the image output.  These
options are appended to the image type following a comma and are
separated by commas.  If a value is desired it can be specified
following an equals-sign.  For example, to create a monochrome JPEG
image file with a quality factor of 80, you would use the following
command line:
.PP
.nf
  xloadimage image_name -dump jpeg,quality=80,grayscale new_image.jpg
.fi
.PP
Option names can be abbreviated but if the abbreviation is too short
to be unique the option which will be used is indeterminate.
.SH FILTERS
Xloadimage supports automatic filtering by recognizing file
extensions.  By default "compress" and "gzip" files are recognized and
their names passed to appropriate commands to decompress them.
.PP
The xloadimage distribution includes a special "smart" uudecoder,
called \fIuufilter\fR that can be used to automatically uudecode files
for processing.  \fIUufilter\fR ignores extraneous lines in the file
so it is particularly useful if the uuencoded file was created by
concatenating email or news postings that had headers or line-break
indicators included.
.PP
To make use of \fIuufilter\fR you can add the following to your
\fI.xloadimagerc\fR file:
.PP
.nf
  filter = "uufilter -s" .uu .uue
.fi
The filter will be automatically invoked on any file with a .uu or
.uue extension.
.PP
For a list of filters automatically recognized by xloadimage use the
\fI-configuration\fR option.
.PP
.SH SUPPORTED IMAGE OPTIONS
.PP
The JPEG image dumper supports the following options:
.TP 8
arithmetic
Use arithmetic encoding.
.TP
grayscale
Force a monochrome (grayscale) image to be created given a color
image.
.TP
nointerleave
Create a non-interleaved file.
.TP
optimize
Enable entropy parameter optimization.
.TP
quality
Adjust the quality of the image to be created.  The default quality
factor is 75; lower values create poorer images.
.TP
restart \fIinterval\fR
Set the restart interval in MCU rows, or MCUs if 'b' follows the
interval value.
.TP
smooth \fIsmoothing_factor\fR
Set the smoothing factor.  Value should be between 0 and 100,
inclusive.
.PP
If you are not familiar with the meaning of these options you can ask
the Independent JPEG Group (IJG) via email at jpeg@cs.columbia.edu.
.PP
The PBM image dumper supports the following options:
.TP 8
normal
Dump a normal (ascii) PBM/PPM file.
.TP
raw
Dump a RawBits format PBM/PPM file.  This is the default and results
in significantly smaller image files than when using \fInormal\fR.
.PP
There is no way to dump a PGM format file or a "compact" PBM format
file (sorry).
.PP
The TIFF image dumper supports the following options:
.TP 8
compression
Image data compression technique.  Can be one of:
\fInone\fR (no compression),
\fIrle\fR (CCITT RLE compression),
\fIg3fax\fR (CCITT Group 3 FAX compression),
\fIg4fax\fR (CCITT Group 4 FAX compression),
\fIlzw\fR (Limpel-Ziv-Welsh compression, the default),
\fIjpeg\fR (JPEG compression),
\fInext\fR (NeXT run-length compression),
\fIrlew\fR (CCITT RLEW compression),
\fImac\fR (Macintosh PackBits compression),
\fIpackbits\fR (same as \fImac\fR),
\fIthunderscan\fR (ThunderScan compression).
.PP
\fIXloadimage\fR will save using the MINISBLACK, MINISWHITE, COLORMAP,
or RGB photometrics as appropriate for its internal image format.
There is no way to specify a particular photometric or any other TIFF
fields.
.PP
.SH AUTHOR
.nf
Jim Frost
CenterLine Software
jimf@centerline.com
.fi
.PP
For a more-or-less complete list of other contributors (there are a
\fIlot\fR of them), please see the README file enclosed with the
distribution.
.SH FILES
.nf
.in +5
xloadimage              - the image loader and viewer
xsetbg                  - pseudonym which quietly sets the background
xview                   - pseudonym which views in a window
/usr/lib/X11/Xloadimage - default system-wide configuration file
~/.xloadimagerc         - user's personal configuration file
.in -5
.fi
.SH COPYRIGHT
Copyright (c) 1989, 1993 Jim Frost and others.
.PP
\fIXloadimage\fR is copywritten material with a very loose copyright
allowing unlimited modification and distribution if the copyright
notices are left intact.  Various portions are copywritten by various
people, but all use a modification of the MIT copyright notice.
Please check the source for complete copyright information.  The
intent is to keep the source free, not to stifle its distribution, so
please write to me if you have any questions.
.SH BUGS
Zooming dithered images, especially downwards, is UGLY.
.PP
Images can come in a variety of aspect ratios.  \fIXloadimage\fR cannot
detect what aspect ratio the particular image being loaded has, nor
the aspect ratio of the destination display, so images with differing
aspect ratios from the destination display will appear distorted.  See
\fIHINTS FOR GOOD IMAGE DISPLAYS\fR for more information.
.PP
The GIF format allows more than one image to be stored in a single GIF
file, but \fIxloadimage\fR will only display the first.
.PP
Only GIF87a format is supported.
.PP
One of the pseudonyms for \fIxloadimage\fR, \fIxview\fR, is the same
name as Sun uses for their SunView-under-X package.  This will be
confusing if you're one of those poor souls who has to use Sun's
XView.
.PP
Some window managers do not correctly handle window size requests.  In
particular, many versions of the twm window manager use
the MaxSize hint instead of the PSize hint, causing images which
are larger than the screen to display in a window larger than the
screen, something which is normally avoided.  Some versions of twm
also ignore the MaxSize argument's real function, to limit the maximum
size of the window, and allow the window to be resized larger than the
image.  If this happens, \fIxloadimage\fR merely places the image in
the upper-left corner of the window and uses the zero-value'ed pixel
for any space which is not covered by the image.  This behavior is
less-than-graceful but so are window managers which are cruel enough
to ignore such details.
