/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2006 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>

#include "netkeyer.h"
#include "support.h"

static gint socket_descriptor;
static struct sockaddr_in address;

/* initialize the UDP socket for cwdaemon */
gint
netkeyer_init (void) 
{
	gint netkeyer_port = 6789;
	gchar netkeyer_hostaddress[16] = "127.0.0.1";
	struct hostent *hostbyname;

	hostbyname = gethostbyname (netkeyer_hostaddress);
	if (hostbyname == NULL) return 1;

	bzero (&address, sizeof (address));
	address.sin_family = AF_INET;
	memcpy (&address.sin_addr.s_addr, hostbyname->h_addr,
		 sizeof (address.sin_addr.s_addr));
	address.sin_port = htons (netkeyer_port);
	
	socket_descriptor = socket (AF_INET, SOCK_DGRAM, 0);
	if (socket_descriptor == -1) return 2;
	return 0;
}

/* close UDP socket */
void
netkeyer_close (void)
{
	gint close_rc;

	close_rc = close (socket_descriptor);
	if (close_rc == -1)
		g_warning (_("closing of socket failed"));
}

/* use sendto to transmit a message over the socket, the only control messages
   we use here are speed and abort */
gint
tonetkeyer (gint cw_op, gchar *cwmessage) 
{
	gchar buf[80];
	ssize_t sendto_rc;

	switch (cw_op)
	{

		case K_MESSAGE:	// cw message
			g_snprintf(buf, 80, "%s", cwmessage);
		break;
		case K_SPEED:	// speed
			g_snprintf(buf, 80, "%c2%s", 27, cwmessage);
		break;
		case K_ABORT:	// message abort
			g_snprintf(buf, 80, "%c4", 27);
		break;
		default:
			buf[0] = '\0';
	}
	
	if (buf[0] != '\0')
	{
		sendto_rc = sendto (socket_descriptor, buf, sizeof (buf), 0,
				(struct sockaddr *) &address, sizeof (address));
	}
	else
		sendto_rc = -1;

	return sendto_rc;
}
