#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

//#include <sys/types.h>
//#include <sys/stat.h>
//#include <unistd.h>
//#include <string.h>

//#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

//#ifdef USE_IMLIB
//#include <gdk_imlib.h>
//#else
//#include <gdk-pixbuf/gdk-pixbuf.h>
//#endif

#include "gtktopdata.h"
#include "gtksettings.h"

static
void
on_setting_activate    (GtkMenuItem     *menuitem,
			gpointer         user_data)
{  
     
  g_message(" activate '%s' from %d to %d\n",
	    *(char **)user_data,
	    GPOINTER_TO_INT(*((gpointer *)user_data+1)),
	    GTK_CHECK_MENU_ITEM(menuitem)->active);
	 
  *((gpointer *)user_data+1)=GINT_TO_POINTER(GTK_CHECK_MENU_ITEM(menuitem)->active);


  {
    void (*callback)();
    callback =gtk_widget_get_data_top(GTK_WIDGET(menuitem),"callback");
    g_assert(callback);
    (*callback)();
  }
  
}

static
void
on_setting_toggle    (GtkMenuItem     *menuitem,
			gpointer         user_data)
{ 
  g_message(" toggle '%s' from %d to %d\n",
	    *(char **)user_data,
	    GPOINTER_TO_INT(*((gpointer *)user_data+1)),
	    GTK_CHECK_MENU_ITEM(menuitem)->active);
	 
  *( ((gpointer *)user_data) +1)=GINT_TO_POINTER(GTK_CHECK_MENU_ITEM(menuitem)->active);



}

GtkWidget*
gtk_settings_create(gpointer thesettings[],
		     void callback())
{
  GtkWidget *menuSettings;
  GtkAccelGroup *menuSettings_accels;
  GtkWidget *item;
  GtkTooltips *tooltips;
  int lp;

  g_assert(thesettings[0] == callback);
  thesettings+=GTKSETTINGS_BLOCKS_PRE;

  tooltips = gtk_tooltips_new ();

  menuSettings = gtk_menu_new ();
  gtk_widget_set_name (menuSettings, "menuSettings");
  gtk_object_set_data (GTK_OBJECT (menuSettings), "menuSettings", menuSettings);
  menuSettings_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (menuSettings));
  
  lp=0;
  while(thesettings[lp]) {
    thesettings[lp+4]= item =
      gtk_check_menu_item_new_with_label (thesettings[lp]);
    
    gtk_widget_set_name (item,thesettings[lp]);
    gtk_widget_ref (item );
    gtk_object_set_data_full (GTK_OBJECT (menuSettings),"warped image in other win1" , 
			      item,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (menuSettings), item);
    gtk_tooltips_set_tip (tooltips, item, thesettings[lp+3], NULL);
    if(thesettings[lp+1])
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item), TRUE);
    
    gtk_signal_connect (GTK_OBJECT (item), "activate",
    			GTK_SIGNAL_FUNC (on_setting_activate ),
    			thesettings+lp);
    gtk_signal_connect (GTK_OBJECT (item), "toggle",
    			GTK_SIGNAL_FUNC (on_setting_toggle ),
    			thesettings+lp);

    gtk_object_set_data (GTK_OBJECT (menuSettings), "tooltips", tooltips);
    
    lp+=GTKSETTINGS_BLOCKS_SIZE;
  }

  gtk_widget_set_data_top(menuSettings,"callback", callback);
  
  return menuSettings;
}
