/* by A Mennucci, Aug 2000
 *
 * code based on:
 *
 * diw_map.c: Digital Image Warping X graphical user interface
//
// Written and Copyright (C) 1994-1999 by Michael J. Gourlay
//
// PROVIDED AS IS.  NO WARRANTEES, EXPRESS OR IMPLIED.
//
*/







/* Meshpoint picking and drawing parameters */

/* MP_PICK_DIST: farthest you may be from a Mesh point to pick it 
   currently ignored
*/
//#define MP_PICK_DIST 15

#define MP_SIZE 8

#define MP_ARC  (360*64)



#include <stdio.h>
#include <stdlib.h>

#include "gtk/gtk.h"

//#include "xmorphspline.h"
#include "../libmorph/spl-array.h"
//#include "RgbaImage.h"
//#include "image_cb.h"
//#include "image_diw.h"
#include "../libmorph/mesh.h"
//#include "mjg_dialog.h"



#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#include <gdk/gdkx.h>
#include <gdk/gdkrgb.h>


#include <gdk/gdk.h>

#include "main.h"
//#include "diw_map.h"


#include "drawmesh.h"


#define MY_CALLOC(A,B) (g_malloc0((A)*sizeof(B)))
#define FREE(A) (g_free(A))





/* --------------------------------------------------------------- */

/* NAME
//   gdk_draw_mesh: Draw mesh lines and points for one mesh
//
//
//
//
// DESCRIPTION
//   Draw mesh lines and points.
//   Also draw the selected meshpoint.
//
//  if subimage !=NULL, rescale the mesh to stay in the subimage
//
// SEE ALSO
//   DrawMeshes
*/

typedef struct _GdkArc GdkArc;
struct _GdkArc {
  gint          filled;
  gint          x;
  gint          y;
  gint          width;
  gint          height;
  gint          angle1;
  gint          angle2;
} ;

//widget->style->black_gc

gboolean
gdk_draw_mesh(GdkDrawable  *drawable,
	      GdkGC        *lines_gc, //lines GC
	      GdkGC        *points_gc, //points GC
	      MeshT *mesh,
	      GdkRectangle *subimage,
	      int height, //viewport height
	      int width //viewport width
	      )
{

  

  //extern GC mpl_gc;  /* mesh line graphics context */
  //extern GC mp_gc;   /* mesh point graphics context */
  //extern GdkGC *mps_gc;  /* (selected) mesh point graphics context */

  //Display *display = XtDisplay(widget);
  //Window   window  = XtWindow(widget);


  GdkPoint *xpoints;
  

  //XPoint  *xpoints;
  //XArc    *xarcs;

  int xi, yi;
  const double *xsP = mesh->x;
  const double *ysP = mesh->y;
  //const double *xdP = dmP->mesh_dst.x;
  //const double *ydP = dmP->mesh_dst.y;
  //const double  mpt = dmP->mesh_t;
  double *x_tmp; //= mesh->x;
  double *y_tmp; //= mesh->y;
  double *xrow;
  double *yrow;


  // this is not defined currently in gdk, so we define it above
  GdkArc     xarc;

  xarc.width = MP_SIZE;
  xarc.height = MP_SIZE ;   
  xarc.angle1=0;
  xarc.angle2=MP_ARC;  
 
  if(!(x_tmp=MY_CALLOC(MAX(mesh->nx,mesh->ny)+1, double))) {
    return(FALSE);
  }
  
  if(!(y_tmp=MY_CALLOC(MAX(mesh->nx,mesh->ny)+1, double))) {
    return(FALSE);
  }

  if(!(xrow=MY_CALLOC(MAX(width/4,height/4)+1, double)))
  {
    return(FALSE);
  }

  if(!(yrow=MY_CALLOC(MAX(width/4,height/4)+1, double)))
  {
    return(FALSE);
  }

  if(!(xpoints=MY_CALLOC(MAX(width/4,height/4)+1, GdkPoint)))
  {
    return(FALSE);
  }

  //if(!(xarcs = MY_CALLOC(mesh->ny, GdkArc))) {
  //  return(FALSE);
  //}

  /* Draw meshpoints and vertical meshlines */
  for(xi=0; xi < mesh->nx; xi++) {
    /* Draw vertical mesh lines */
      {
      /* Create 1D array of mesh points knots */
	if(subimage)
	  for(yi=0; yi<mesh->ny; yi++) {
	    x_tmp[yi] = 
	      xsP[yi*mesh->nx + xi] * subimage->width /width + subimage->x;
	    y_tmp[yi] =  
	      ysP[yi*mesh->nx + xi]* subimage->height /height+ subimage->y;
	  }
	else
	  for(yi=0; yi<mesh->ny; yi++) {
	    x_tmp[yi] =      xsP[yi*mesh->nx + xi];
	    y_tmp[yi] =      ysP[yi*mesh->nx + xi];
      }
#ifdef USE_SPLINES
      /* Create abcissas of interpolant to make a smoothly drawn mesh line */
      for(yi=0; yi<(height/4); yi++)
        yrow[yi] = yi*4;

      /* Make sure last abcissa is set */
      yrow[yi-1] = height-1;

      /* Create the interpolated line segments */
      hermite3_array(y_tmp, x_tmp, mesh->ny, yrow, xrow, height/4);

      /* Create an array of XPoints to draw smoothly interpolated mesh line */
      for(yi=0; yi<(height/4); yi++) {
        xpoints[yi].x = (int) xrow[yi];
        xpoints[yi].y = (int) yrow[yi];
      }
      /* Draw the smoothly interpolated mesh line */
      gdk_draw_lines(drawable,lines_gc , xpoints,height/4);
#else USE_SPLINES
      for(yi=0; yi< mesh->ny; yi++) {
        xpoints[yi].x = (int) x_tmp[yi];
        xpoints[yi].y = (int) y_tmp[yi];
      }
      /* Draw the mesh lines */
      gdk_draw_lines(drawable,lines_gc , xpoints, mesh->ny);
#endif
    }

    /* Draw mesh points */
      {
	for(yi=0; yi<mesh->ny; yi++) {
	  xarc.x =  x_tmp[yi]   ;
	  xarc.y =  y_tmp[yi]  ;	
	    
	  if ( meshGetLabel(mesh,xi,yi))
	    gdk_draw_arc  (drawable, points_gc,
			   TRUE,
			   xarc.          x - MP_SIZE/2,
			   xarc.          y - MP_SIZE/2,
			   xarc.          width,
			   xarc.          height,
			   xarc.          angle1,
			   xarc.          angle2 );
#ifdef DRAW_UNSELECTED_POINTS
	  else
	    gdk_draw_arc  (drawable, lines_gc,
			   TRUE,
			   xarc.          x - MP_SIZE/2,
			   xarc.          y - MP_SIZE/2,
			   xarc.          width/2,
			   xarc.          height/2,
			   xarc.          angle1,
			   xarc.          angle2 );	
#endif
	}
    }
  }

  /* Draw horizontal meshlines */
  {
    for(yi=0; yi<mesh->ny; yi++) {
      if(subimage)
	for(xi=0; xi<mesh->nx; xi++) {
	  x_tmp[xi] =
	    xsP[yi*mesh->nx + xi]* subimage->width /width + subimage->x;  
	  y_tmp[xi] = 
	    ysP[yi*mesh->nx + xi]* subimage->height /height+ subimage->y;
	}
      else
	for(xi=0; xi<mesh->nx; xi++) {
	  x_tmp[xi] =   xsP[yi*mesh->nx + xi];
	  y_tmp[xi] =   ysP[yi*mesh->nx + xi];
	}

#ifdef USE_SPLINES 
      for(xi=0; xi<(width/4); xi++)
	xrow[xi] = xi*4;
      xrow[xi-1] = width-1;
      
      hermite3_array(x_tmp, y_tmp, mesh->nx, xrow, yrow, width/4);

      for(xi=0; xi<(width/4); xi++) {
        xpoints[xi].x = (int) xrow[xi];
        xpoints[xi].y = (int) yrow[xi];
      }
      gdk_draw_lines (drawable, lines_gc,
		      xpoints, width/4); 
#else
      for(xi=0; xi<mesh->nx; xi++) {
        xpoints[xi].x = (int) x_tmp[xi];
        xpoints[xi].y = (int) y_tmp[xi];
      }
      gdk_draw_lines (drawable, lines_gc,
		      xpoints, mesh->nx);      
#endif
    }
  }

    for(yi=0; yi<mesh->ny; yi++) {
      for(xi=0; xi<mesh->nx; xi++) {

      }}

  //FREE(x_tmp);
  //FREE(y_tmp);
  g_free(xrow);
  g_free(yrow);
  g_free(xpoints);

  return(TRUE);
}


