/*
 * Copyright 1991 by David A. Curry
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The
 * author makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 */
#ifndef lint
static char	*RCSid = "$Header: /home/harbor/davy/stuff/xpostit/RCS/title.c,v 1.6 1992/12/10 16:39:38 davy Exp $";
#endif

/*
 * title.c - handle getting a new title from the user.
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * West Lafayette, IN 47907
 * davy@ecn.purdue.edu
 *
 * $Log: title.c,v $
 * Revision 1.6  1992/12/10  16:39:38  davy
 * Added code for keyboard accelerators, tearoff notes, wm protocols, etc.
 * from Joe English (joe@trystero.art.com).
 *
 * Revision 1.5  1992/12/09  20:02:33  davy
 * Added changes to work properly under mwm from Brian Walker,
 * brian@crl.labs.tek.com.
 *
 * Revision 1.4  1992/12/09  19:54:16  davy
 * Added XI18N international Xaw support from Hiroshi Kuribayashi,
 * kuri@omron.co.jp.
 *
 * Revision 1.3  1991/11/08  14:26:49  davy
 * Fixed titles to stay with their own notes.
 *
 * Revision 1.2  91/09/06  18:29:29  davy
 * Added copyright/permission notice for submission to MIT R5 contrib.
 * 
 * Revision 1.1  91/09/06  17:14:43  davy
 * Initial revision
 * 
 */
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Shell.h>
#include <stdio.h>

#include "xpostit.h"

Widget		dialog;
static int	notenum;
static Widget	titlewidget;

/*
 * GetNoteTitle - return the note's new title.
 */
char *
GetNoteTitle(pn, okayCallback, cancelCallback)
XtCallbackProc okayCallback, cancelCallback;
PostItNote *pn;
{
	Arg args[8];
	Widget value;
	Window root, child;
	unsigned int buttons;
	register int nargs, nwidgets;
	static Boolean inited = False;
	int root_x, root_y, child_x, child_y;

	/*
	 * Find out where the mouse is, so we can put the confirmation
	 * box right there.
	 */
	XQueryPointer(display, XtWindow(toplevel), &root, &child,
		      &root_x, &root_y, &child_x, &child_y, &buttons);

	root_x -= 5;
	root_y -= 5;
	notenum = pn->pn_index;

	/*
	 * If we need to construct the confirmation box do that,
	 * otherwise just reset the position and callbacks and
	 * put it up again.
	 */
	if (!inited) {
		nargs = 0;
		SetArg(XtNx, root_x);
		SetArg(XtNy, root_y);
		SetArg(XtNallowShellResize, True);

		/*
		 * The dialog box will be a pop-up widget.
		 */
		titlewidget = XtCreatePopupShell("Title",
#ifdef XI18N
						   topLevelShellWidgetClass,
#else
						   transientShellWidgetClass,
#endif
						   toplevel, args, nargs);

		nargs = 0;
		SetArg(XtNlabel, "New Title:");
		SetArg(XtNvalue, pn->pn_title);

		dialog = XtCreateWidget("Dialog", dialogWidgetClass,
					titlewidget, args, nargs);

		nargs = 0;
		SetArg(XtNresizable, True);
		value = XtNameToWidget(dialog, "value");
		XtSetValues(value, args, nargs);

		XawDialogAddButton(dialog, "Okay", okayCallback,
				   (caddr_t) &notenum);
		XawDialogAddButton(dialog, "Cancel", cancelCallback,
				   (caddr_t) &notenum);

		XtInstallAllAccelerators(value, dialog);

		/*
		 * Let the shell widget know we're here.
		 */
		XtManageChild(dialog);

		XtRealizeWidget(titlewidget);
		inited = True;
	}
	else {
		/*
		 * Reset the title box position and value.
		 */
		nargs = 0;
		SetArg(XtNx, root_x);
		SetArg(XtNy, root_y);
		XtSetValues(titlewidget, args, nargs);

		nargs = 0;
		SetArg(XtNvalue, pn->pn_title);
		XtSetValues(dialog, args, nargs);
	}

	/*
	 * Pop up the dialog box.
	 */
	XtPopup(titlewidget, XtGrabExclusive);
}

/*
 * ClearTitle - get rid of the title box.
 */
void
ClearTitle()
{
	XtPopdown(titlewidget);
}

