/*-
# X-BASED OCTAHEDRON
#
#  OctP.h
#
###
#
#  Copyright (c) 1994 - 2006	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Oct */

#ifndef _OctP_h
#define _OctP_h

#include "xwin.h"
#include "timer.h"
#include "Oct.h"

#ifdef WINVER
extern void DestroyPuzzle(HBRUSH brush);
extern void ResizePuzzle(OctWidget w);
extern void SizePuzzle(OctWidget w);
extern void InitializePuzzle(OctWidget w, HBRUSH brush);
extern void ExposePuzzle(OctWidget w);
extern void HidePuzzle(OctWidget w);
extern void SelectPuzzle(OctWidget w,
	const int x, const int y, const int control);
extern void ReleasePuzzle(OctWidget w,
	const int x, const int y, const int shift, const int control);
extern void PracticePuzzle(OctWidget w);
extern void RandomizePuzzle(OctWidget w);
extern void GetPuzzle(OctWidget w);
extern void WritePuzzle(OctWidget w);
extern void UndoPuzzle(OctWidget w);
extern void RedoPuzzle(OctWidget w);
extern void ClearPuzzle(OctWidget w);
extern void SolvePuzzle(OctWidget w);
extern void IncrementPuzzle(OctWidget w);
extern Boolean DecrementPuzzle(OctWidget w);
extern void OrientizePuzzle(OctWidget w);
extern void StickyModePuzzle(OctWidget w);
extern void PeriodModePuzzle(OctWidget w, const int mode);
extern void Period3ModePuzzle(OctWidget w);
extern void Period4ModePuzzle(OctWidget w);
extern void BothModePuzzle(OctWidget w);
extern void EnterPuzzle(OctWidget w);
extern void LeavePuzzle(OctWidget w);
extern void MovePuzzleInput(OctWidget w,
	int x, int y, int direction, int shift, int control);
extern int  MovePuzzleDir(OctWidget w, const int direction);

#else

/* This gets around C's inability to do inheritance */
typedef struct _OctClassPart {
	int         ignore;
} OctClassPart;

typedef struct _OctClassRec {
	CoreClassPart coreClass;
	OctClassPart octClass;
} OctClassRec;

extern OctClassRec octClassRec;
#endif

#define SYMBOL ':'

#define IGNORE_DIR (-1)
#define TOP 0
#define TR 1
#define RIGHT 2
#define BR 3
#define BOTTOM 4
#define BL 5
#define LEFT 6
#define TL 7
#define COORD 8
#define CW 9
#define CCW 15

#define MAXFACES 8
#define SAME 0
#define OPPOSITE 1
#define UP 1
#define DOWN 0
#define MAXVIEWS 2
#define MAXSIDES (MAXFACES/MAXVIEWS)
#define MAXORIENT (3*MAXSIDES)

typedef struct _MoveRecord {
#if 0
	int face, direction, style, control;
#endif
	unsigned short int packed;  /* This makes assumptions on the data. */
	int position;		    /* Do not make assumptions on this one. */
} MoveRecord;

typedef struct _MoveStack {
	MoveRecord move;
	struct _MoveStack *previous, *next;
} MoveStack;

typedef struct _OctStack {
	MoveStack *currMove, *lastMove, *firstMove;
	int count;
} OctStack;

typedef struct _OctLoc {
	int face, rotation;
} OctLoc;

typedef struct _OctPart {
	OctLoc     *facetLoc[MAXFACES];
	OctLoc     *faceLoc;
	OctLoc     *rowLoc[MAXORIENT / 2];
	int         currentFace, currentPosition;
	Boolean     started, cheat;
	Boolean     practice, orient, vertical, mono, reverse, sticky, focus;
	Boolean     scoreOnly, versionOnly;
	int         size, sizeSize, mode;
	Position    delta;
	Position    facetLength;
	Position    faceLength;
	Position    viewLength, viewMiddle;
	Position    orientLineLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAXFACES];
#ifdef WINVER
	char        userName[81], scoreFile[81];
	char        faceChar[MAXFACES];
#else
	int         menu;
	char       *userName, *scoreFile, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAXFACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAXFACES];
	XtCallbackList select;
#endif
} OctPart;

typedef struct _OctRec {
	CorePart    core;
	OctPart     oct;
} OctRec;

extern OctLoc *startLoc[MAXFACES];
extern void setPuzzle(OctWidget w, int reason);
extern void MovePuzzle(OctWidget w,
	int face, int position, int direction, int style, int control);

#if 0
/* For future auto-solver */
extern void SolvePolyhedrons(OctWidget w);

#endif
extern void DrawAllPieces(OctWidget w);
extern Boolean CheckSolved(OctWidget w);
extern void newMoves(OctStack *s);
extern void deleteMoves(OctStack *s);
extern void setMove(OctStack *s,
	int face, int position, int direction, int style, int control);
extern void getMove(OctStack *s,
	int *face, int *position, int *direction, int *style, int *control);
extern int madeMoves(OctStack *s);
extern void flushMoves(OctWidget w, OctStack *s, Boolean undo);
extern int numMoves(OctStack *s);
extern void scanMoves(FILE *fp, OctWidget w, int moves);
extern void printMoves(FILE *fp, OctStack *s);
extern void scanStartPosition(FILE *fp, OctWidget w);
extern void printStartPosition(FILE *fp, OctWidget w);
extern void setStartPosition(OctWidget w);

#endif /* _OctP_h */
