/*
 * @(#)HexagonsP.h
 *
 * Copyright 1994 - 2008  David A. Bagley, bagleyd@tux.org
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for Hexagons */

#ifndef _HexagonsP_h
#define _HexagonsP_h

#include "xwin.h"
#include "timer.h"
#include "Hexagons.h"

#ifdef WINVER
extern void destroyPuzzle(HexagonsWidget w, HBRUSH brush);
extern void resizePuzzle(HexagonsWidget w);
extern void sizePuzzle(HexagonsWidget w);
extern void initializePuzzle(HexagonsWidget w, HBRUSH brush);
extern void exposePuzzle(HexagonsWidget w);
extern void hidePuzzle(HexagonsWidget w);
extern void selectPuzzle(HexagonsWidget w, const int x, const int y);
extern void releasePuzzle(HexagonsWidget w, const int x, const int y);
extern void getPuzzle(HexagonsWidget w);
extern void writePuzzle(HexagonsWidget w);
extern void undoPuzzle(HexagonsWidget w);
extern void redoPuzzle(HexagonsWidget w);
extern void clearPuzzle(HexagonsWidget w);
extern void randomizePuzzle(HexagonsWidget w);
extern void solvePuzzle(HexagonsWidget w);
extern void cornersPuzzle(HexagonsWidget w);
extern void speedUpPuzzle(HexagonsWidget w);
extern void slowDownPuzzle(HexagonsWidget w);
extern void toggleSoundPuzzle(HexagonsWidget w);
extern void enterPuzzle(HexagonsWidget w);
extern void leavePuzzle(HexagonsWidget w);
extern int movePuzzle(HexagonsWidget w, const int direction,
	const int control);

#else

/* This gets around C's inability to do inheritance */
typedef struct _HexagonsClassPart {
	int ignore;
} HexagonsClassPart;

typedef struct _HexagonsClassRec {
	CoreClassPart coreClass;
	HexagonsClassPart hexagonsClass;
} HexagonsClassRec;

extern HexagonsClassRec hexagonsClassRec;
#endif

#ifndef BUMPSOUND
#define BUMPSOUND "bump"
#endif

#define SYMBOL ':'

#define TR 0
#define RIGHT 1
#define BR 2
#define BL 3
#define LEFT 4
#define TL 5
#define COORD 6
#define TOP 6
#define BOTTOM 9
#define TRBL 0
#define TLBR 1
#define ROW 2
#define ROW_TYPES 3
#define LOW 0
#define HIGH 1
#define SPACES 2
#define BLOCKED (-3)
#define SPACE (-2)
#define FG_SHADES 3
#define BG_SHADES 5
#define MAX_SLICES 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

typedef struct _MoveRecord {
#if 0
	int direction;
#endif
	unsigned char packed;   /* This makes assumptions on the data. */
} MoveRecord;

typedef struct _MoveStack {
	MoveRecord move;
	struct _MoveStack *previous, *next;
} MoveStack;

typedef struct _HexagonsStack {
	MoveStack *currMove, *lastMove, *firstMove;
	int count;
} HexagonsStack;

typedef struct _HexagonsPart {
	int        *tileOfPosition, spacePosition[SPACES];
	int         spaceRow[ROW_TYPES];
	int         currentPosition, currentRow[ROW_TYPES];
	Boolean     started, cheat, sound;
	Boolean     corners, mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         delay, numSlices;
	int         base;
	int         sizeX, sizeY, sizeSize, sizeCenter;
	Point       offset, tileSize, puzzleSize;
	Point       delta, puzzleOffset, digitOffset;
	GC          textGC;
	GC          tileGC[FG_SHADES];
	GC          inverseGC[BG_SHADES];
	Pixmap      bufferTiles[2];
	TimeVal     oldTime;
#ifdef WINVER
	char        userName[81], scoreFile[81], bumpSound[81], picture[81];
#else
	int         menu, graphicsFormat, pixmapSize;
	char       *userName, *scoreFile, *bumpSound;
	char       *picture, *font;
	Boolean     install;
	Colormap    colormap, oldColormap;
	XImage     *image;
	XFontStruct *fontInfo;
	Pixel       foreground, background;
	Pixel       frameColor, tileColor, textColor;
	XtCallbackList select;
#endif
} HexagonsPart;

typedef struct _HexagonsRec {
	CorePart core;
	HexagonsPart hexagons;
} HexagonsRec;

extern int *startPosition;
extern void setPuzzle(HexagonsWidget w, int reason);
extern int movePuzzleDir(HexagonsWidget w, const int direction,
	const int fast);

#if 0
/* For future auto-solver */
extern void solveSomeTiles(HexagonsWidget w);
#endif
extern void drawAllTiles(const HexagonsWidget w);
extern Boolean checkSolved(const HexagonsWidget w);
extern void newMoves(HexagonsStack *s);
extern void deleteMoves(HexagonsStack *s);
extern void setMove(HexagonsStack *s, int direction);
extern void getMove(HexagonsStack *s, int *direction);
extern int madeMoves(HexagonsStack *s);
extern void flushMoves(HexagonsWidget w, HexagonsStack *s, Boolean undo);
extern int numMoves(HexagonsStack *s);
extern void scanMoves(FILE *fp, HexagonsWidget w, int moves);
extern void printMoves(FILE *fp, HexagonsStack *s);
extern void scanStartPosition(FILE *fp, HexagonsWidget w);
extern void printStartPosition(FILE *fp, HexagonsWidget w);
extern void setStartPosition(HexagonsWidget w);
extern int toRow(HexagonsWidget w, const int pos);
extern int toTrBl(HexagonsWidget w, const int pos, const int posRow);
extern int toTlBr(HexagonsWidget w, const int pos, const int posRow);

#endif /* _HexagonsP_h */
