/*  xtraceroute - graphically show traceroute information.
 *  Copyright (C) 1996-1998  Bjrn Augustsson 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "xt.h"

static gint tag = 0;
static gint spinner_state;
static GtkWidget *label;

gint spinner_spin(gpointer data)
{
  switch(spinner_state)
    {
    case 0:
      gtk_label_set(GTK_LABEL(label)," O ");
      spinner_state++;
      break;
    case 1:
      gtk_label_set(GTK_LABEL(label),"O  ");
      spinner_state++;
      break;
    case 2:
      gtk_label_set(GTK_LABEL(label)," O ");
      spinner_state++;
      break;
    case 3:
      gtk_label_set(GTK_LABEL(label),"  O");
      spinner_state = 0;
      break;
    }
    return TRUE;
}


void spinner_start(void)
{
    if(tag == 0)
	tag = gtk_timeout_add (100, spinner_spin, NULL);
}


void spinner_stop(void)
{
  if(tag != 0)
    gtk_timeout_remove(tag);
  tag = 0;
  spinner_state = 0;
  if(label)
    gtk_label_set(GTK_LABEL(label)," ");
}


GtkWidget* spinner_new(void)
{
  GtkWidget *spin;

  spin  = gtk_button_new();
  label = gtk_label_new(" ");
  gtk_container_add(GTK_CONTAINER(spin), label);
  
  gtk_signal_connect(GTK_OBJECT(spin), "clicked",
		     (GtkSignalFunc)new_trace,
		     (gpointer)NULL);
  spinner_state = 0;
  gtk_widget_show(label);

  return spin;
}
