// 	$Id: xxTideContext.cc,v 1.2 1999/12/05 20:13:03 dave Exp $	
/*  xxTideContext  Specialization of TideContext.

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "xtide.hh"

xxTideContext::xxTideContext (int in_argc, char **in_argv, xxContext *context,
xxXTideRoot *in_root, Colors *in_colors, Settings *in_settings):
  TideContext (in_argc, in_argv, in_colors, in_settings) {
  xxcontext = context;
  root = in_root;
}

// THIS CODE IS DUPLICATED IN TIDECONTEXT!  The duplication is needed
// to embed XEvent polling in xxTideContext.
StationIndex *xxTideContext::stationIndex (XtGrabKind in_grabkind) {
  if (!myStationIndex) {
    xxTitleScreen titleScreen (this, xxcontext, *harmonicsPath, in_grabkind);
    myStationIndex = new StationIndex();
    for (unsigned i=0; i<harmonicsPath->length(); i++) {
      titleScreen.updateProgress (i);
      HarmonicsFile h ((*harmonicsPath)[i], settings);
      StationRef *s;
      while ((s = h.getNextStationRef())) {
        myStationIndex->add (s);
        xxMainLoop (xxcontext);
      }
    }
    if (myStationIndex->length() == 0)
      barf (NO_HFILE_PATH);
    myStationIndex->qsort();
  }
  return myStationIndex;
}
