// $Id: CommandLineSettings.hh,v 1.3 2002/11/20 19:23:57 flaterco Exp $
/*  CommandLineSettings  Settings from command line.

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

class CommandLineSettings: public Settings {
public:
  CommandLineSettings (int argc, char **argv);
  ~CommandLineSettings();
  char *settingsid();

  // Unique to command line.
  struct lnode {
    Dstr name;
    struct lnode *next;
  };
  struct lnode *l;
  unsigned l_len;
  Dstr b, e, f, m, s, o;
  int ml_isnull;
  PredictionValue ml;

  enum argtype {boolean, temporal, mode, format, number, color, unit, text};
  struct Argdesc {char *name; argtype typ;};

protected:
  struct arglist {Dstr svitch; Dstr arg; arglist *next;};

  // The goal is to disambiguate the argument string.
  // Inputs:
  //   int argc, char **argv   The usual
  //   int argi                Index to the argument now being looked at
  // Returns:
  //   arglist*  Disambiguated argument list if valid.  Null if not.
  arglist *disambiguate (int argc, char **argv, int argi);

  // The goal is still to disambiguate the argument string.
  // char *argii   Index to the current character position in argv[argi].
  // argtype t     The type of argument we expect to find there.
  arglist *check_arg (int argc, char **argv, int argi, char *argii, CommandLineSettings::argtype t);

  // Search command line.  Returns NULL if not found.
  char *findarg (char *arg, arglist *args);
};
