/* TideEditor class definition.  */

/*****************************************************************************\

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

\*****************************************************************************/


#ifndef TIDEEDITOR_H
#define TIDEEDITOR_H

/* RWL the following ifdef removes a templates error when compiling with MSVC (Known bug) */

#ifdef WIN32
#include <math.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <qapplication.h>
#include <qevent.h>
#include <qpainter.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qstatusbar.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qmessagebox.h>
#include <qtooltip.h>
#include <qrect.h>
#include <qpoint.h>
#include <qcolordialog.h>
#include <qfiledialog.h>
#include <qcursor.h>
#include <qimage.h>
#include <qstrlist.h>
#include <qintdict.h>
#include <qwhatsthis.h>
#include <qaction.h>
#include <qmainwindow.h>
#include <qrangecontrol.h>
#include <qpen.h>
#include <qpoint.h>
#include <qpixmap.h>
#include <qwidget.h>
#include <qstring.h>
#include <qpointarray.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qlistbox.h>

#include "map.h"
#include "tcd.h"
#include "version.h"


char *fixpos (double degs, double *deg, double *min, double *sec, char *hem,
              char *c_type, char *c_form);
void posfix (char *string, double *degs, char *c_type);


typedef struct
{
    int  recnum;
    char *name;
    double latitude;
    double longitude;
} STATION_LIST;


class QToolButton;
class QAction;


class TideEditor;
class TideList;

class TideEditor:public QMainWindow
{
    Q_OBJECT 


  public:

    TideEditor (QWidget *parent = 0, const char *name = 0);
    ~TideEditor ();

    void setRedrawZeroLevel ();
    void redrawMap ();
    void highlightStation (double lat, double lon, unsigned char record_type);

    int size, half_size;

    int  number_of_records;


    STATION_LIST *station_list;


    char pos_format[10];
      

    TideList *tideList;


  protected:

    char hfile[512];

    Map *map;

    DB_HEADER_PUBLIC db;
    TIDE_RECORD rec;

    QColor refStationColor, subStationColor;
    QButtonGroup *bGrp;
    QDialog *prefsD, *searchD;
    QListBox *searchList;
    QLineEdit *searchName;
    int lastrec;

    QToolButton    *bQuit, *bZoomOut, *bReset, *bLeft, *bUp, *bDown, *bRight, 
                   *bPrefs, *bDisaster, *bSearch;

    void plotStations ();
    void envin ();
    void envout ();


  protected slots:

    void slotRedraw ();
    void slotLeftMouse (QMouseEvent * e);
    void slotMidMouse (QMouseEvent * e);
    void slotRightMouse (QMouseEvent * e);
    void slotMouseMove (QMouseEvent * e);

    void slotQuit ();
    void slotDisaster ();

    void slotPrefs ();
    void slotPrefsClicked ();
    void slotClosePrefs ();
    void slotCloseSearch ();
    void slotSelected ();
    void slotHighlighted ();
    void slotTextChanged ();
    void slotSearch ();
    void slotRefColor ();
    void slotSubColor ();
    void slotZoomOut ();
    void slotReset ();

    void slotUp ();
    void slotDown ();

    void slotRight ();
    void slotLeft ();

    void about ();
    void aboutQt ();

  private:
    void keyPressEvent (QKeyEvent * e);
};

#endif
