/*****************************************************************************\

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

\*****************************************************************************/


#ifndef TIDEDIALOG_H
#define TIDEDIALOG_H

/* RWL the following ifdef removes a templates error when compiling with MSVC (Known bug) */

#ifdef WIN32
#include <math.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <qapplication.h>
#include <qevent.h>
#include <qpainter.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qstatusbar.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qmessagebox.h>
#include <qtooltip.h>
#include <qrect.h>
#include <qpoint.h>
#include <qcolordialog.h>
#include <qfiledialog.h>
#include <qcursor.h>
#include <qimage.h>
#include <qstrlist.h>
#include <qintdict.h>
#include <qwhatsthis.h>
#include <qaction.h>
#include <qmainwindow.h>
#include <qrangecontrol.h>
#include <qpen.h>
#include <qpoint.h>
#include <qpixmap.h>
#include <qwidget.h>
#include <qstring.h>
#include <qpointarray.h>
#include <qtabdialog.h>
#include <qcombobox.h>
#include <qtextedit.h>
#include <qtable.h>
#include <qheader.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qstringlist.h>
#include <qinputdialog.h>
#include <qprinter.h>
#include <qpaintdevicemetrics.h>
#include <qsimplerichtext.h>

#include "tcd.h"
#include "tideEditor.h"

typedef struct
{
    int        num;
    char       name[15];
} CONSTITUENT;


class TideDialog:public QTabDialog
{
    Q_OBJECT 


  public:

    TideDialog (QWidget *parent, const char *name, TIDE_RECORD lrec, 
        TideEditor *te);
    ~TideDialog ();


  protected:

    DB_HEADER_PUBLIC db;
    TIDE_RECORD rec, inf_rec;
    TideEditor *tideEditor;


    QTabDialog *tideDialog;
    QTextEdit *comments;
    QLineEdit *name, *source, *lat, *lon, *datum_offset, *zone_offset, *months,
      *min_time_add, *min_level_add, *min_level_mult, 
      *min_direction, *max_time_add, *max_level_add, *max_level_mult, 
      *max_direction, *flood_begins, *ebb_begins, 
      *expiration_date, *ldos;
    QComboBox *tzfile, *country, *restriction, *conf, 
      *level_units, *direction_units, *datum;
    QListBox *subList;
    QTable *constituents;

    int *sub_station;

    CONSTITUENT *cnst;


    void generalTab ();
    void constituentsTab ();
    void offsetsTab ();


  protected slots:

    void slotUpdateStation ();
    void slotCancelStation ();
    void slotDeleteStation ();
    void slotPrintStation ();
    void slotChangeRefStation ();

  private:
};

#endif
