/*
 * Program:     $RCSfile: Ver2_compatible program $  $Revision: 4.5 $
 *
 * Purpose:     Protocol routines of internet "youbin" service.
 *
 * Author:      K.Agusa     agusa@nuie.nagoya-u.ac.jp
 *              S.Yamamoto  yamamoto@nuie.nagoya-u.ac.jp
 *
 * Date:        1993/07/24
 * Modified:    $Date: 1995/01/07 10:35:34 $
 *
 * Copyright:   K.Agusa and S.Yamamoto  1993 - 94
 *
 * The X Consortium, and any party obtaining a copy of these files from
 * the X Consortium, directly or indirectly, is granted, free of charge,
 * a full and unrestricted irrevocable, world-wide, paid up, royalty-free,
 * nonexclusive right and license to deal in this software and documentation
 * files (the "Software"), including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons who receive copies from any such
 * party to do so. This license includes without limitation a license to do
 * the foregoing actions under any patents of the party supplying this
 * software to the X Consortium.
 */
#ifdef VER2_BC

#ifndef lint
static char rcsid[] =
    "$Id: protocol.c,v 4.5 1995/01/07 10:35:34 yamamoto Exp $";
#endif /* not lint */

#include <sys/types.h>          /* Must be included before "sys/socket.h". */
#include <sys/socket.h>         /* For struct sockaddr. */ 
#include <netinet/in.h>         /* For struct sockaddr_in. */
#include <arpa/inet.h>          /* For inet_ntoa(). */ 
#include <netdb.h>              /* For gethostbyname() and gethostbyaddr(). */
#include <stdio.h>

#include "youbin.h"
#include "server.h"

void ver2_Wakeup( char *, char * );
void ver2_Update( char * );

void
ver2_proc( char *mess, int len )
{
  switch( *mess ){
  case 'T':
    do_Thank( mess + 2 );
    break;
  case 'W':
    ver2_Wakeup( mess + 2 , mess + len );
    break;
  case 'U':
    ver2_Update( mess + 2 );
    break;
  case 'Q':
    do_Quit( mess + 2 );
    break;
  default:
    warn_log("Unknown packet: %s\n", mess );
  }
}

void
ver2_Wakeup(mess, endp)
char    *mess, *endp;
{
    /* 
     * mess := "<user name> <protocol version>"
     *       | "<user name> <protocol version> <options>"
     */
    char        *cp;                        /* Pointer to <protocol version>. */
    char        *cp1;                       /* Pointer to <option>. */
    StateP      id;                         /* User ID. */
    char        buff[MESS_LEN];
    enum        a_mode auth;

    if ((cp = strchr(mess, ' ')) == NULL) {
      send_packet("NAK Invalid version", CA_ADDR);
      return;
    }
    *cp++ = '\0';                           /* Trim protocol version. */
    if ((cp1 = strchr(cp, ' ')) == NULL) {
      cp1 = endp;                           /* No options. */
    } else {
      *cp1++ = '\0';                        /* Trim options. */
    }
    if (strcmp(cp, "2") != 0) {    /* Check protocol version. */
      strcpy(NAK_reason, "Invalid version");
      send_packet("NAK Invalid version", CA_ADDR);
      return;
    }

    auth = *cp1 =='B' ? ROK : NONE;
    if((id = make_user(mess, auth )) != NULL) {
      if (debug_mode || trace_mode) {
	char            buff_log[LOG_LEN];  /* Only for log. */
	struct hostent  *hp;
	
	if ((hp = gethostbyaddr((char *)&ca.sin_addr,
				sizeof(ca.sin_addr), ca.sin_family)) == NULL) {
	  sys_error_log("gethostbyaddr");
	} 
	sprintf(buff_log, "Wakeup packet: %s [%ld]: host = %s, port = %d\n",
		mess, (long)id,
		((hp != NULL) ? hp->h_name : inet_ntoa(ca.sin_addr)),
		ntohs(ca.sin_port));
	debug_log("    %s", buff_log);
	trace(buff_log);
      }
      if( check_pass( id, "", *cp1 == 'B' ? 11 : 0 ) == FAIL ){
	                                    /* head="Body,Subject:,From:" */
	send_packet( "NAK Authentification error", id );
	del_state(id);                      /* dispose_state(sp);*/
	return;
      }
      id->mode.head_list = *cp1 == 'B' ? 11 :0;
      id->option.no_KeepAlive = FALSE;
      id->option.ver2_user = 1;
      id->state = WAIT;      /* new_sate() set it to PW1. Then need to change */
      sprintf(buff, "R %ld %d", (long)id, CLIENT_TIME_OUT);
      send_packet( buff, id);               /* R packet:   Send to global ca. */
      check_spool( id->parent);             /* Check spool file */
      send_Status(id);
    } else {                                         /* Invalid user. */
      sprintf( buff, "NAK %s", NAK_reason );
      send_packet( buff, CA_ADDR);                   /* Send to global ca. */
    }
}

void
ver2_Update(mess)
char    *mess;
{
    /*
     * Value of mess is one of below:
     * (1) packet = "U <user name>", mess = "<user name>"
     * (2) packet = "U /<user id>", mess = "/<user id>"
     */
  char buff[MESS_LEN];
    
  if (*mess == '/') {         /* Case (2). */
    do_Update( mess + 1 );
  } else {                    /* Case (1). */
    sprintf( buff, "0 %s", mess );
    do_Update( buff );
    }
}

#endif
