char * ckcuni = "Unicode support 7.0.106, 10 Nov 1999";

#ifdef OS2
#define KERMITFONT
#endif /* OS2 */

/*  C K C U N I . C  --  Unicode/Terminal character-set translations  */

/*
  Copyright (C) 1999, 2000,
    Trustees of Columbia University in the City of New York.
    All rights reserved.  See the C-Kermit COPYING.TXT file or the
    copyright text in the ckcmai.c module for disclaimer and permissions.

  Authors:
    Frank da Cruz <fdc@columbia.edu>
    Jeffrey Altman <jaltman@columbia.edu>
    The Kermit Project, Columbia University, New York City.

  Functions u_blah() translate from blah to Unicode (incoming material).
  Functions tx_blah() translate from Unicode to blah (keystrokes).
  Function pointers are kept in parallel arrays indexed by TX_blah values
  defined in ckcuni.h.   NOTE: tx_decspec and tx_dectech are undefined since
  these character sets are never typed, only displayed.

  The blah_u() routines accept an unsigned character value in character-set
  blah, and return the Unicode translation, or 0xfffd if the character is not
  defined in Unicode.  The 8th bit of the argument should be ignored, a`la ISO
  4873 and 2022.

  The tx_blah() routines accept a unicode value and return the value of the
  corresponding character in character-set blah, or else -1 if the character
  does not exist in blah.  In this case, the full 8-bit value is returned,
  since ISO 2022 only works in the host-to-terminal direction.

  NOTE: KERMITFONT should be defined only if we are using the new (still
  hypothetical) Kermit font that has all the VT/Heath/Wyse/TVI graphic
  characters in it.  IMPORTANT: all Kermitfont code points need updating to
  the values in the final proposal to the UTC.

  TO DO: A lot of the functions can be tightened up -- use ranges when
  possible, sort switch statements in order of frequency, etc.
*/
#include "ckcsym.h"			/* Includes... */
#include "ckcdeb.h"
#include "ckcker.h"
#include "ckucmd.h"
#include "ckcxla.h"
#include "ckuxla.h"

#ifdef UNICODE

#ifdef OS2
/*
  This material is needed for the integration of TextPS into Kermit 95.
  When printing a file we use the SET FILE CHARACTER-SET value as the input
  character-set and then convert it to the special Latin1 set called
  CourierLatin1 using the Unicode translation functions.
*/
struct _pair { int tx; int fc; } TXFC[] = {
    TX_ASCII,       FC_USASCII,
    TX_BRITISH,     FC_UKASCII,
    TX_CN_FRENCH,   FC_FCASCII,
    TX_CP437,       FC_CP437,
    TX_CP850,       FC_CP850,
    TX_CP852,       FC_CP852,
    TX_CP857,       -2,
    TX_CP862,       FC_CP862,
    TX_CP864,       -2,
    TX_CP866,       FC_CP866,
    TX_CP869,       -2,
    TX_CUBAN,       -2,
    TX_CZECH,       -2,
    TX_DANISH,      -2,
    TX_DECMCS,      FC_DECMCS,
    TX_DECSPEC,     -2,             /* while defined, not in fcs tables */
    TX_DECTECH,     -2,             /* while defined, not in fcs tables */
    TX_DGI,         FC_DGMCS,
    TX_DUTCH,       FC_DUASCII,
    TX_FINNISH,     FC_FIASCII,
    TX_FRENCH,      FC_FRASCII,
    TX_GERMAN,      FC_GEASCII,
    TX_HE7,         FC_HE7,
    TX_HPR8,        FC_HPR8,
    TX_HUNGARIAN,   FC_HUASCII,
    TX_ITALIAN,     FC_ITASCII,
    TX_J201R,       -2,
    TX_J201K,       -2,
    TX_KOI7,        FC_KOI7,
    TX_KOI8,        FC_KOI8,
    TX_KOI8R,       FC_KOI8R,
    TX_KOI8U,       FC_KOI8U,
    TX_8859_1,      FC_1LATIN,
    TX_8859_2,      FC_2LATIN,
    TX_8859_3,      -2,
    TX_8859_4,      -2,
    TX_8859_5,      FC_CYRILL,
    TX_8859_6,      -2,
    TX_8859_7,      -2,
    TX_8859_8,      FC_HEBREW,
    TX_8859_9,      -2,
    TX_8859_10,     -2,
    TX_8859_15,     -2,
    TX_MACL1,       FC_APPQD,
    TX_NEXT,        FC_NEXT,
    TX_NORWEGIAN,   FC_NOASCII,
    TX_PORTUGUESE,  FC_POASCII,
    TX_SPANISH,     FC_SPASCII,
    TX_SWEDISH,     FC_SWASCII,
    TX_SWISS,       FC_CHASCII,
    TX_ICELANDIC,   -2,
    TX_JIS7,        -2,
    TX_SHJIS,       FC_SHJIS,
    TX_JEUC,        FC_JEUC,
    TX_JDEC,        FC_JDEC,
    TX_ELOT927,     FC_ELOT,
    TX_DGPCGRPH,    -2,
    TX_DGLDGRPH,    -2,
    TX_DGWPGRPH,    -2,
    TX_HPLINE,      -2,
    TX_HPMATH,      -2,
    TX_QNXGRPH,     -2,
    TX_SNIBRACK,    -2,
    TX_SNIEURO,     -2,
    TX_SNIFACET,    -2,
    TX_SNIIBM,      -2,
    TX_SNIBLANK,    -2,
    TX_CP1252,      -2,
    TX_CP1250,      FC_CP1250,
    TX_CP1251,      FC_CP1251,
    TX_CP1253,      -2,
    TX_CP1254,      -2,
    TX_CP1257,      -2,
    TX_CP856,       -2,
    TX_CP855,       FC_CP855,
    TX_CP819,       FC_1LATIN,
    TX_CP912,       FC_2LATIN,
    TX_CP913,       -2,
    TX_CP914,       -2,
    TX_CP915,       FC_CYRILL,
    TX_CP1089,      -2,
    TX_CP813,       FC_GREEK,
    TX_CP916,       FC_HEBREW,
    TX_CP920,       -2,
    TX_CP1051,      -2,
    TX_CP858,       FC_CP858,
    TX_8859_15,     FC_9LATIN,
    TX_CP923,       FC_CP923,
    TX_ELOT928,     -2,
    TX_CP10000,     -2,
    TX_CP37,        -2,
    TX_CP1255,      -2,
    TX_CP1256,      -2,
    TX_CP1258,      -2,
    TX_MAZOVIA,     FC_MAZOVIA,
    TX_TRANSP,      FC_TRANSP
};
int nTXFC = sizeof(TXFC) / sizeof(struct _pair);

int
#ifdef CK_ANSIC
fc2tx(int fc)
#else
fc2tx(int c) int fc;
#endif /* CK_ANSIC */
{
    int i;
    for (i = 0; i<nTXFC ; i++)
      if (TXFC[i].fc == fc && TXFC[i].tx >= 0)
	return(TXFC[i].tx);
    return(TX_ASCII);
}

int
#ifdef CK_ANSIC
tx2fc(int tx)
#else
tx2fc(int x) int tx;
#endif /* CK_ANSIC */
{
    int i;
    for (i = 0; i < nTXFC ; i++)
      if (TXFC[i].tx == tx && TXFC[i].fc >= 0)
	return(TXFC[i].fc);
    return(FC_USASCII);
}

/* SET TERMINAL REMOTE CHARACTER-SET keyword table */

struct keytab txrtab[] = {
    "arabic-iso",       TX_8859_6,     0,
    "ascii",            TX_ASCII,      0,
    "british",          TX_BRITISH,    0,
    "canadian-french",  TX_CN_FRENCH,  0,
    "bulgaria-pc",      TX_CP856,      0,
#ifdef COMMENT
    "cp037",            TX_CP37,       0, /* U.S. EBCDIC */
#endif /* COMMENT */
    "cp10000",          TX_CP10000,    0, /* Apple Quickdraw */
    "cp1051",           TX_CP1051,     0, /* Same as HP Roman 8 */
    "cp1089",           TX_CP1089,     0, /* Same as ISO 8859-6 */
    "cp1250",           TX_CP1250,     0, /* Latin-2 Windows */
    "cp1251",           TX_CP1251,     0, /* Cyrillic Windows */
    "cp1252",           TX_CP1252,     0, /* Latin-1 Windows */
    "cp1253",           TX_CP1253,     0, /* Greek Windows */
    "cp1254",           TX_CP1254,     0, /* Turkey Windows */
    "cp1255",           TX_CP1255,     0, /* Hebrew Windows */
    "cp1256",           TX_CP1256,     0, /* Arabic Windows */
    "cp1257",           TX_CP1257,     0, /* Latin-4 Windows */
    "cp1258",           TX_CP1258,     0, /* Viet Nam Windows */
    "cp437",            TX_CP437,      0,
    "cp813",            TX_CP813,      0, /* Same as ISO 8859-7 */
    "cp819",            TX_CP819,      0, /* Same as ISO 8859-1 */
    "cp850",            TX_CP850,      0,
    "cp852",            TX_CP852,      0,
    "cp855",            TX_CP855,      0, /* Cyrillic */
    "cp856",            TX_CP856,      CM_INV, /* Bulgaria */
    "cp857",            TX_CP857,      0, /* Latin-5 */
    "cp858",            TX_CP858,      0, /* Euro modified cp850 */
    "cp862-hebrew",     TX_CP862,      0, /* Hebrew */
    "cp864",            TX_CP864,      0, /* Arabic */
    "cp866",            TX_CP866,      0, /* Cyrillic */
    "cp869",            TX_CP869,      0, /* Greek */
    "cp912",            TX_CP912,      0, /* Same as ISO 8859-2 */
    "cp913",            TX_CP913,      0, /* Same as ISO 8859-3 */
    "cp914",            TX_CP914,      0, /* Same as ISO 8859-4 */
    "cp915",            TX_CP915,      0, /* Same as ISO 8859-5 */
    "cp916",            TX_CP916,      0, /* Same as ISO 8859-8 */
    "cp920",            TX_CP920,      0, /* Same as ISO 8859-9 */
    "cp923",            TX_CP923,      0, /* Same as ISO 8859-15 */
#ifdef COMMENT
/* Not implemented yet */
    "cuban",            TX_CUBAN,      0,
#endif /* COMMENT */
    "cyrillic-iso",     TX_8859_5,     0,
#ifdef COMMENT
/* Not implemented yet */
    "czech",            TX_CZECH,      0,
#endif /* COMMENT */
    "danish",           TX_DANISH,     0,
    "dec-m",            TX_DECMCS,     CM_ABR|CM_INV,
    "dec-mcs",          TX_DECMCS,     CM_INV,
    "dec-multinational",TX_DECMCS,     0,
#ifdef COMMENT				/* Not implemented yet */
    "dec-kanji",        TX_JDEC,       0,
#endif /* COMMENT */
    "dec-special",      TX_DECSPEC,    0,
    "dec-technical",    TX_DECTECH,    0,
    "dg-international", TX_DGI,        0,
    "dg-linedrawing",   TX_DGLDGRPH,   0,
    "dg-specialgraphcs",TX_DGPCGRPH,   0,
    "dg-wordprocessing",TX_DGWPGRPH,   0,
    "dutch",            TX_DUTCH,      0,
    "elot927-greek",    TX_ELOT927,    0,
    "elot928-greek",    TX_ELOT928,    0,
    "finnish",          TX_FINNISH,    0,
    "french",           TX_FRENCH,     0,
    "german",           TX_GERMAN,     0,
    "greek-iso",        TX_8859_7,     0,
    "hebrew-7",         TX_HE7,        0,
    "hebrew-iso",       TX_8859_8,     0,
    "hp-line-drawing",  TX_HPLINE,     0,
    "hp-math/technical",TX_HPMATH,     0,
    "hp-roman8",        TX_HPR8,       0,
    "hungarian",        TX_HUNGARIAN,  0,
    "italian",          TX_ITALIAN,    0,
    "japanese-roman",   TX_J201R,      0,
#ifdef COMMENT				/* Not implemented yet */
    "japanese-euc",     TX_JEUC,       0,
    "jis7-kanji",       TX_JIS7,       0,
#endif /* COMMENT */
    "katakana",         TX_J201K,      0,
    "ko",               TX_KOI8,       CM_ABR|CM_INV,
    "koi",              TX_KOI8,       CM_ABR|CM_INV,
    "koi8",             TX_KOI8,       0,
    "koi8-cyrillic",    TX_KOI8,       CM_INV,
    "koi8r",            TX_KOI8R,      0,
    "koi8u",            TX_KOI8U,      0,
    "l",                TX_8859_1,     CM_ABR|CM_INV,
    "la",               TX_8859_1,     CM_ABR|CM_INV,
    "lat",              TX_8859_1,     CM_ABR|CM_INV,
    "lati",             TX_8859_1,     CM_ABR|CM_INV,
    "latin",            TX_8859_1,     CM_ABR|CM_INV,
    "latin1-iso",       TX_8859_1,     0,
    "latin2-iso",       TX_8859_2,     0,
    "latin3-iso",       TX_8859_3,     0,
    "latin4-iso",       TX_8859_4,     0,
    "latin5-iso",       TX_8859_9,     0,
    "latin6-iso",       TX_8859_10,    0,
    "latin9-iso",       TX_8859_15,    0,
    "macintosh-latin",  TX_MACL1,      0,
    "mazovia-pc",       TX_MAZOVIA,    0,
    "next-multinational",TX_NEXT,      0,
    "norwegian",        TX_NORWEGIAN,  0,
    "portuguese",       TX_PORTUGUESE, 0,
    "qnx-console",      TX_QNXGRPH,    0,
#ifdef COMMENT				/* Not implemented yet */
    "shift-jis",        TX_SHJIS,      0,
#endif /* COMMENT */
    "short-koi",        TX_KOI7,       0,
    "sni-blanks",       TX_SNIBLANK,   0,
    "sni-brackets",     TX_SNIBRACK,   0,
    "sni-euro",         TX_SNIEURO,    0,
    "sni-facet",        TX_SNIFACET,   0,
    "sni-ibm",          TX_SNIIBM,     0,
    "spanish",          TX_SPANISH,    0,
    "swedish",          TX_SWEDISH,    0,
    "swiss",            TX_SWISS,      0,
    "transparent",      TX_TRANSP,     0,
#ifdef COMMENT
    "utf7",             TX_UTF7,       0,
#endif /* COMMENT */
    "utf8",             TX_UTF8,       0,
    "", 0, 0
};
int ntxrtab = sizeof(txrtab)/sizeof(struct keytab) - 1;
#endif /* OS2 */

#ifdef KANJI
/*
  All Kanji/Unicode translations are based on the Unicode 3.0
  Shift-JIS mapping.  Other character sets, like EUC-JP, JIS-7, etc,
  are transformed algorithmically to/from Shift-JIS before/after
  conversion to/from Unicode.  This is because Kanji/Unicode mapping
  tables add about 120K to the program, and we don't want to do this
  for each Kanji character set.
*/
static USHORT				/* Shift-JIS to Unicode */
sju_8140[] = {				/* 0x8140 thru 0x9ffc */
    0x3000, 0x3001, 0x3002, 0xff0c, 0xff0e, 0x30fb, 0xff1a, 0xff1b,
    0xff1f, 0xff01, 0x309b, 0x309c, 0x00b4, 0xff40, 0x00a8, 0xff3e,
    0xffe3, 0xff3f, 0x30fd, 0x30fe, 0x309d, 0x309e, 0x3003, 0x4edd,
    0x3005, 0x3006, 0x3007, 0x30fc, 0x2015, 0x2010, 0xff0f, 0x005c,
    0x301c, 0x2016, 0xff5c, 0x2026, 0x2025, 0x2018, 0x2019, 0x201c,
    0x201d, 0xff08, 0xff09, 0x3014, 0x3015, 0xff3b, 0xff3d, 0xff5b,
    0xff5d, 0x3008, 0x3009, 0x300a, 0x300b, 0x300c, 0x300d, 0x300e,
    0x300f, 0x3010, 0x3011, 0xff0b, 0x2212, 0x00b1, 0x00d7, 0xfffd,
    0x00f7, 0xff1d, 0x2260, 0xff1c, 0xff1e, 0x2266, 0x2267, 0x221e,
    0x2234, 0x2642, 0x2640, 0x00b0, 0x2032, 0x2033, 0x2103, 0xffe5,
    0xff04, 0x00a2, 0x00a3, 0xff05, 0xff03, 0xff06, 0xff0a, 0xff20,
    0x00a7, 0x2606, 0x2605, 0x25cb, 0x25cf, 0x25ce, 0x25c7, 0x25c6,
    0x25a1, 0x25a0, 0x25b3, 0x25b2, 0x25bd, 0x25bc, 0x203b, 0x3012,
    0x2192, 0x2190, 0x2191, 0x2193, 0x3013, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x2208, 0x220b, 0x2286, 0x2287, 0x2282, 0x2283, 0x222a, 0x2229,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x2227, 0x2228, 0x00ac, 0x21d2, 0x21d4, 0x2200, 0x2203, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x2220, 0x22a5, 0x2312, 0x2202, 0x2207, 0x2261,
    0x2252, 0x226a, 0x226b, 0x221a, 0x223d, 0x221d, 0x2235, 0x222b,
    0x222c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x212b, 0x2030, 0x266f, 0x266d, 0x266a, 0x2020, 0x2021, 0x00b6,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x25ef, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xff10,
    0xff11, 0xff12, 0xff13, 0xff14, 0xff15, 0xff16, 0xff17, 0xff18,
    0xff19, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xff21, 0xff22, 0xff23, 0xff24, 0xff25, 0xff26, 0xff27, 0xff28,
    0xff29, 0xff2a, 0xff2b, 0xff2c, 0xff2d, 0xff2e, 0xff2f, 0xff30,
    0xff31, 0xff32, 0xff33, 0xff34, 0xff35, 0xff36, 0xff37, 0xff38,
    0xff39, 0xff3a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xff41, 0xff42, 0xff43, 0xff44, 0xff45, 0xff46, 0xff47,
    0xff48, 0xff49, 0xff4a, 0xff4b, 0xff4c, 0xff4d, 0xff4e, 0xff4f,
    0xff50, 0xff51, 0xff52, 0xff53, 0xff54, 0xff55, 0xff56, 0xff57,
    0xff58, 0xff59, 0xff5a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x3041,
    0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 0x3049,
    0x304a, 0x304b, 0x304c, 0x304d, 0x304e, 0x304f, 0x3050, 0x3051,
    0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 0x3059,
    0x305a, 0x305b, 0x305c, 0x305d, 0x305e, 0x305f, 0x3060, 0x3061,
    0x3062, 0x3063, 0x3064, 0x3065, 0x3066, 0x3067, 0x3068, 0x3069,
    0x306a, 0x306b, 0x306c, 0x306d, 0x306e, 0x306f, 0x3070, 0x3071,
    0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 0x3077, 0x3078, 0x3079,
    0x307a, 0x307b, 0x307c, 0x307d, 0x307e, 0x307f, 0x3080, 0x3081,
    0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 0x3088, 0x3089,
    0x308a, 0x308b, 0x308c, 0x308d, 0x308e, 0x308f, 0x3090, 0x3091,
    0x3092, 0x3093, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x30a1, 0x30a2, 0x30a3, 0x30a4, 0x30a5, 0x30a6, 0x30a7, 0x30a8,
    0x30a9, 0x30aa, 0x30ab, 0x30ac, 0x30ad, 0x30ae, 0x30af, 0x30b0,
    0x30b1, 0x30b2, 0x30b3, 0x30b4, 0x30b5, 0x30b6, 0x30b7, 0x30b8,
    0x30b9, 0x30ba, 0x30bb, 0x30bc, 0x30bd, 0x30be, 0x30bf, 0x30c0,
    0x30c1, 0x30c2, 0x30c3, 0x30c4, 0x30c5, 0x30c6, 0x30c7, 0x30c8,
    0x30c9, 0x30ca, 0x30cb, 0x30cc, 0x30cd, 0x30ce, 0x30cf, 0x30d0,
    0x30d1, 0x30d2, 0x30d3, 0x30d4, 0x30d5, 0x30d6, 0x30d7, 0x30d8,
    0x30d9, 0x30da, 0x30db, 0x30dc, 0x30dd, 0x30de, 0x30df, 0xfffd,
    0x30e0, 0x30e1, 0x30e2, 0x30e3, 0x30e4, 0x30e5, 0x30e6, 0x30e7,
    0x30e8, 0x30e9, 0x30ea, 0x30eb, 0x30ec, 0x30ed, 0x30ee, 0x30ef,
    0x30f0, 0x30f1, 0x30f2, 0x30f3, 0x30f4, 0x30f5, 0x30f6, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0391,
    0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399,
    0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f, 0x03a0, 0x03a1,
    0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8, 0x03a9, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x03b1,
    0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 0x03b8, 0x03b9,
    0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 0x03c0, 0x03c1,
    0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8, 0x03c9, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0401, 0x0416,
    0x0417, 0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e,
    0x041f, 0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426,
    0x0427, 0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e,
    0x042f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0451, 0x0436,
    0x0437, 0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0xfffd,
    0x043e, 0x043f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445,
    0x0446, 0x0447, 0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d,
    0x044e, 0x044f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x2500,
    0x2502, 0x250c, 0x2510, 0x2518, 0x2514, 0x251c, 0x252c, 0x2524,
    0x2534, 0x253c, 0x2501, 0x2503, 0x250f, 0x2513, 0x251b, 0x2517,
    0x2523, 0x2533, 0x252b, 0x253b, 0x254b, 0x2520, 0x252f, 0x2528,
    0x2537, 0x253f, 0x251d, 0x2530, 0x2525, 0x2538, 0x2542, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x4e9c,
    0x5516, 0x5a03, 0x963f, 0x54c0, 0x611b, 0x6328, 0x59f6, 0x9022,
    0x8475, 0x831c, 0x7a50, 0x60aa, 0x63e1, 0x6e25, 0x65ed, 0x8466,
    0x82a6, 0x9bf5, 0x6893, 0x5727, 0x65a1, 0x6271, 0x5b9b, 0x59d0,
    0x867b, 0x98f4, 0x7d62, 0x7dbe, 0x9b8e, 0x6216, 0x7c9f, 0x88b7,
    0x5b89, 0x5eb5, 0x6309, 0x6697, 0x6848, 0x95c7, 0x978d, 0x674f,
    0x4ee5, 0x4f0a, 0x4f4d, 0x4f9d, 0x5049, 0x56f2, 0x5937, 0x59d4,
    0x5a01, 0x5c09, 0x60df, 0x610f, 0x6170, 0x6613, 0x6905, 0x70ba,
    0x754f, 0x7570, 0x79fb, 0x7dad, 0x7def, 0x80c3, 0x840e, 0x8863,
    0x8b02, 0x9055, 0x907a, 0x533b, 0x4e95, 0x4ea5, 0x57df, 0x80b2,
    0x90c1, 0x78ef, 0x4e00, 0x58f1, 0x6ea2, 0x9038, 0x7a32, 0x8328,
    0x828b, 0x9c2f, 0x5141, 0x5370, 0x54bd, 0x54e1, 0x56e0, 0x59fb,
    0x5f15, 0x98f2, 0x6deb, 0x80e4, 0x852d, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9662, 0x9670, 0x96a0, 0x97fb, 0x540b, 0x53f3, 0x5b87, 0x70cf,
    0x7fbd, 0x8fc2, 0x96e8, 0x536f, 0x9d5c, 0x7aba, 0x4e11, 0x7893,
    0x81fc, 0x6e26, 0x5618, 0x5504, 0x6b1d, 0x851a, 0x9c3b, 0x59e5,
    0x53a9, 0x6d66, 0x74dc, 0x958f, 0x5642, 0x4e91, 0x904b, 0x96f2,
    0x834f, 0x990c, 0x53e1, 0x55b6, 0x5b30, 0x5f71, 0x6620, 0x66f3,
    0x6804, 0x6c38, 0x6cf3, 0x6d29, 0x745b, 0x76c8, 0x7a4e, 0x9834,
    0x82f1, 0x885b, 0x8a60, 0x92ed, 0x6db2, 0x75ab, 0x76ca, 0x99c5,
    0x60a6, 0x8b01, 0x8d8a, 0x95b2, 0x698e, 0x53ad, 0x5186, 0xfffd,
    0x5712, 0x5830, 0x5944, 0x5bb4, 0x5ef6, 0x6028, 0x63a9, 0x63f4,
    0x6cbf, 0x6f14, 0x708e, 0x7114, 0x7159, 0x71d5, 0x733f, 0x7e01,
    0x8276, 0x82d1, 0x8597, 0x9060, 0x925b, 0x9d1b, 0x5869, 0x65bc,
    0x6c5a, 0x7525, 0x51f9, 0x592e, 0x5965, 0x5f80, 0x5fdc, 0x62bc,
    0x65fa, 0x6a2a, 0x6b27, 0x6bb4, 0x738b, 0x7fc1, 0x8956, 0x9d2c,
    0x9d0e, 0x9ec4, 0x5ca1, 0x6c96, 0x837b, 0x5104, 0x5c4b, 0x61b6,
    0x81c6, 0x6876, 0x7261, 0x4e59, 0x4ffa, 0x5378, 0x6069, 0x6e29,
    0x7a4f, 0x97f3, 0x4e0b, 0x5316, 0x4eee, 0x4f55, 0x4f3d, 0x4fa1,
    0x4f73, 0x52a0, 0x53ef, 0x5609, 0x590f, 0x5ac1, 0x5bb6, 0x5be1,
    0x79d1, 0x6687, 0x679c, 0x67b6, 0x6b4c, 0x6cb3, 0x706b, 0x73c2,
    0x798d, 0x79be, 0x7a3c, 0x7b87, 0x82b1, 0x82db, 0x8304, 0x8377,
    0x83ef, 0x83d3, 0x8766, 0x8ab2, 0x5629, 0x8ca8, 0x8fe6, 0x904e,
    0x971e, 0x868a, 0x4fc4, 0x5ce8, 0x6211, 0x7259, 0x753b, 0x81e5,
    0x82bd, 0x86fe, 0x8cc0, 0x96c5, 0x9913, 0x99d5, 0x4ecb, 0x4f1a,
    0x89e3, 0x56de, 0x584a, 0x58ca, 0x5efb, 0x5feb, 0x602a, 0x6094,
    0x6062, 0x61d0, 0x6212, 0x62d0, 0x6539, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9b41, 0x6666, 0x68b0, 0x6d77, 0x7070, 0x754c, 0x7686, 0x7d75,
    0x82a5, 0x87f9, 0x958b, 0x968e, 0x8c9d, 0x51f1, 0x52be, 0x5916,
    0x54b3, 0x5bb3, 0x5d16, 0x6168, 0x6982, 0x6daf, 0x788d, 0x84cb,
    0x8857, 0x8a72, 0x93a7, 0x9ab8, 0x6d6c, 0x99a8, 0x86d9, 0x57a3,
    0x67ff, 0x86ce, 0x920e, 0x5283, 0x5687, 0x5404, 0x5ed3, 0x62e1,
    0x64b9, 0x683c, 0x6838, 0x6bbb, 0x7372, 0x78ba, 0x7a6b, 0x899a,
    0x89d2, 0x8d6b, 0x8f03, 0x90ed, 0x95a3, 0x9694, 0x9769, 0x5b66,
    0x5cb3, 0x697d, 0x984d, 0x984e, 0x639b, 0x7b20, 0x6a2b, 0xfffd,
    0x6a7f, 0x68b6, 0x9c0d, 0x6f5f, 0x5272, 0x559d, 0x6070, 0x62ec,
    0x6d3b, 0x6e07, 0x6ed1, 0x845b, 0x8910, 0x8f44, 0x4e14, 0x9c39,
    0x53f6, 0x691b, 0x6a3a, 0x9784, 0x682a, 0x515c, 0x7ac3, 0x84b2,
    0x91dc, 0x938c, 0x565b, 0x9d28, 0x6822, 0x8305, 0x8431, 0x7ca5,
    0x5208, 0x82c5, 0x74e6, 0x4e7e, 0x4f83, 0x51a0, 0x5bd2, 0x520a,
    0x52d8, 0x52e7, 0x5dfb, 0x559a, 0x582a, 0x59e6, 0x5b8c, 0x5b98,
    0x5bdb, 0x5e72, 0x5e79, 0x60a3, 0x611f, 0x6163, 0x61be, 0x63db,
    0x6562, 0x67d1, 0x6853, 0x68fa, 0x6b3e, 0x6b53, 0x6c57, 0x6f22,
    0x6f97, 0x6f45, 0x74b0, 0x7518, 0x76e3, 0x770b, 0x7aff, 0x7ba1,
    0x7c21, 0x7de9, 0x7f36, 0x7ff0, 0x809d, 0x8266, 0x839e, 0x89b3,
    0x8acc, 0x8cab, 0x9084, 0x9451, 0x9593, 0x9591, 0x95a2, 0x9665,
    0x97d3, 0x9928, 0x8218, 0x4e38, 0x542b, 0x5cb8, 0x5dcc, 0x73a9,
    0x764c, 0x773c, 0x5ca9, 0x7feb, 0x8d0b, 0x96c1, 0x9811, 0x9854,
    0x9858, 0x4f01, 0x4f0e, 0x5371, 0x559c, 0x5668, 0x57fa, 0x5947,
    0x5b09, 0x5bc4, 0x5c90, 0x5e0c, 0x5e7e, 0x5fcc, 0x63ee, 0x673a,
    0x65d7, 0x65e2, 0x671f, 0x68cb, 0x68c4, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x6a5f, 0x5e30, 0x6bc5, 0x6c17, 0x6c7d, 0x757f, 0x7948, 0x5b63,
    0x7a00, 0x7d00, 0x5fbd, 0x898f, 0x8a18, 0x8cb4, 0x8d77, 0x8ecc,
    0x8f1d, 0x98e2, 0x9a0e, 0x9b3c, 0x4e80, 0x507d, 0x5100, 0x5993,
    0x5b9c, 0x622f, 0x6280, 0x64ec, 0x6b3a, 0x72a0, 0x7591, 0x7947,
    0x7fa9, 0x87fb, 0x8abc, 0x8b70, 0x63ac, 0x83ca, 0x97a0, 0x5409,
    0x5403, 0x55ab, 0x6854, 0x6a58, 0x8a70, 0x7827, 0x6775, 0x9ecd,
    0x5374, 0x5ba2, 0x811a, 0x8650, 0x9006, 0x4e18, 0x4e45, 0x4ec7,
    0x4f11, 0x53ca, 0x5438, 0x5bae, 0x5f13, 0x6025, 0x6551, 0xfffd,
    0x673d, 0x6c42, 0x6c72, 0x6ce3, 0x7078, 0x7403, 0x7a76, 0x7aae,
    0x7b08, 0x7d1a, 0x7cfe, 0x7d66, 0x65e7, 0x725b, 0x53bb, 0x5c45,
    0x5de8, 0x62d2, 0x62e0, 0x6319, 0x6e20, 0x865a, 0x8a31, 0x8ddd,
    0x92f8, 0x6f01, 0x79a6, 0x9b5a, 0x4ea8, 0x4eab, 0x4eac, 0x4f9b,
    0x4fa0, 0x50d1, 0x5147, 0x7af6, 0x5171, 0x51f6, 0x5354, 0x5321,
    0x537f, 0x53eb, 0x55ac, 0x5883, 0x5ce1, 0x5f37, 0x5f4a, 0x602f,
    0x6050, 0x606d, 0x631f, 0x6559, 0x6a4b, 0x6cc1, 0x72c2, 0x72ed,
    0x77ef, 0x80f8, 0x8105, 0x8208, 0x854e, 0x90f7, 0x93e1, 0x97ff,
    0x9957, 0x9a5a, 0x4ef0, 0x51dd, 0x5c2d, 0x6681, 0x696d, 0x5c40,
    0x66f2, 0x6975, 0x7389, 0x6850, 0x7c81, 0x50c5, 0x52e4, 0x5747,
    0x5dfe, 0x9326, 0x65a4, 0x6b23, 0x6b3d, 0x7434, 0x7981, 0x79bd,
    0x7b4b, 0x7dca, 0x82b9, 0x83cc, 0x887f, 0x895f, 0x8b39, 0x8fd1,
    0x91d1, 0x541f, 0x9280, 0x4e5d, 0x5036, 0x53e5, 0x533a, 0x72d7,
    0x7396, 0x77e9, 0x82e6, 0x8eaf, 0x99c6, 0x99c8, 0x99d2, 0x5177,
    0x611a, 0x865e, 0x55b0, 0x7a7a, 0x5076, 0x5bd3, 0x9047, 0x9685,
    0x4e32, 0x6adb, 0x91e7, 0x5c51, 0x5c48, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x6398, 0x7a9f, 0x6c93, 0x9774, 0x8f61, 0x7aaa, 0x718a, 0x9688,
    0x7c82, 0x6817, 0x7e70, 0x6851, 0x936c, 0x52f2, 0x541b, 0x85ab,
    0x8a13, 0x7fa4, 0x8ecd, 0x90e1, 0x5366, 0x8888, 0x7941, 0x4fc2,
    0x50be, 0x5211, 0x5144, 0x5553, 0x572d, 0x73ea, 0x578b, 0x5951,
    0x5f62, 0x5f84, 0x6075, 0x6176, 0x6167, 0x61a9, 0x63b2, 0x643a,
    0x656c, 0x666f, 0x6842, 0x6e13, 0x7566, 0x7a3d, 0x7cfb, 0x7d4c,
    0x7d99, 0x7e4b, 0x7f6b, 0x830e, 0x834a, 0x86cd, 0x8a08, 0x8a63,
    0x8b66, 0x8efd, 0x981a, 0x9d8f, 0x82b8, 0x8fce, 0x9be8, 0xfffd,
    0x5287, 0x621f, 0x6483, 0x6fc0, 0x9699, 0x6841, 0x5091, 0x6b20,
    0x6c7a, 0x6f54, 0x7a74, 0x7d50, 0x8840, 0x8a23, 0x6708, 0x4ef6,
    0x5039, 0x5026, 0x5065, 0x517c, 0x5238, 0x5263, 0x55a7, 0x570f,
    0x5805, 0x5acc, 0x5efa, 0x61b2, 0x61f8, 0x62f3, 0x6372, 0x691c,
    0x6a29, 0x727d, 0x72ac, 0x732e, 0x7814, 0x786f, 0x7d79, 0x770c,
    0x80a9, 0x898b, 0x8b19, 0x8ce2, 0x8ed2, 0x9063, 0x9375, 0x967a,
    0x9855, 0x9a13, 0x9e78, 0x5143, 0x539f, 0x53b3, 0x5e7b, 0x5f26,
    0x6e1b, 0x6e90, 0x7384, 0x73fe, 0x7d43, 0x8237, 0x8a00, 0x8afa,
    0x9650, 0x4e4e, 0x500b, 0x53e4, 0x547c, 0x56fa, 0x59d1, 0x5b64,
    0x5df1, 0x5eab, 0x5f27, 0x6238, 0x6545, 0x67af, 0x6e56, 0x72d0,
    0x7cca, 0x88b4, 0x80a1, 0x80e1, 0x83f0, 0x864e, 0x8a87, 0x8de8,
    0x9237, 0x96c7, 0x9867, 0x9f13, 0x4e94, 0x4e92, 0x4f0d, 0x5348,
    0x5449, 0x543e, 0x5a2f, 0x5f8c, 0x5fa1, 0x609f, 0x68a7, 0x6a8e,
    0x745a, 0x7881, 0x8a9e, 0x8aa4, 0x8b77, 0x9190, 0x4e5e, 0x9bc9,
    0x4ea4, 0x4f7c, 0x4faf, 0x5019, 0x5016, 0x5149, 0x516c, 0x529f,
    0x52b9, 0x52fe, 0x539a, 0x53e3, 0x5411, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x540e, 0x5589, 0x5751, 0x57a2, 0x597d, 0x5b54, 0x5b5d, 0x5b8f,
    0x5de5, 0x5de7, 0x5df7, 0x5e78, 0x5e83, 0x5e9a, 0x5eb7, 0x5f18,
    0x6052, 0x614c, 0x6297, 0x62d8, 0x63a7, 0x653b, 0x6602, 0x6643,
    0x66f4, 0x676d, 0x6821, 0x6897, 0x69cb, 0x6c5f, 0x6d2a, 0x6d69,
    0x6e2f, 0x6e9d, 0x7532, 0x7687, 0x786c, 0x7a3f, 0x7ce0, 0x7d05,
    0x7d18, 0x7d5e, 0x7db1, 0x8015, 0x8003, 0x80af, 0x80b1, 0x8154,
    0x818f, 0x822a, 0x8352, 0x884c, 0x8861, 0x8b1b, 0x8ca2, 0x8cfc,
    0x90ca, 0x9175, 0x9271, 0x783f, 0x92fc, 0x95a4, 0x964d, 0xfffd,
    0x9805, 0x9999, 0x9ad8, 0x9d3b, 0x525b, 0x52ab, 0x53f7, 0x5408,
    0x58d5, 0x62f7, 0x6fe0, 0x8c6a, 0x8f5f, 0x9eb9, 0x514b, 0x523b,
    0x544a, 0x56fd, 0x7a40, 0x9177, 0x9d60, 0x9ed2, 0x7344, 0x6f09,
    0x8170, 0x7511, 0x5ffd, 0x60da, 0x9aa8, 0x72db, 0x8fbc, 0x6b64,
    0x9803, 0x4eca, 0x56f0, 0x5764, 0x58be, 0x5a5a, 0x6068, 0x61c7,
    0x660f, 0x6606, 0x6839, 0x68b1, 0x6df7, 0x75d5, 0x7d3a, 0x826e,
    0x9b42, 0x4e9b, 0x4f50, 0x53c9, 0x5506, 0x5d6f, 0x5de6, 0x5dee,
    0x67fb, 0x6c99, 0x7473, 0x7802, 0x8a50, 0x9396, 0x88df, 0x5750,
    0x5ea7, 0x632b, 0x50b5, 0x50ac, 0x518d, 0x6700, 0x54c9, 0x585e,
    0x59bb, 0x5bb0, 0x5f69, 0x624d, 0x63a1, 0x683d, 0x6b73, 0x6e08,
    0x707d, 0x91c7, 0x7280, 0x7815, 0x7826, 0x796d, 0x658e, 0x7d30,
    0x83dc, 0x88c1, 0x8f09, 0x969b, 0x5264, 0x5728, 0x6750, 0x7f6a,
    0x8ca1, 0x51b4, 0x5742, 0x962a, 0x583a, 0x698a, 0x80b4, 0x54b2,
    0x5d0e, 0x57fc, 0x7895, 0x9dfa, 0x4f5c, 0x524a, 0x548b, 0x643e,
    0x6628, 0x6714, 0x67f5, 0x7a84, 0x7b56, 0x7d22, 0x932f, 0x685c,
    0x9bad, 0x7b39, 0x5319, 0x518a, 0x5237, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x5bdf, 0x62f6, 0x64ae, 0x64e6, 0x672d, 0x6bba, 0x85a9, 0x96d1,
    0x7690, 0x9bd6, 0x634c, 0x9306, 0x9bab, 0x76bf, 0x6652, 0x4e09,
    0x5098, 0x53c2, 0x5c71, 0x60e8, 0x6492, 0x6563, 0x685f, 0x71e6,
    0x73ca, 0x7523, 0x7b97, 0x7e82, 0x8695, 0x8b83, 0x8cdb, 0x9178,
    0x9910, 0x65ac, 0x66ab, 0x6b8b, 0x4ed5, 0x4ed4, 0x4f3a, 0x4f7f,
    0x523a, 0x53f8, 0x53f2, 0x55e3, 0x56db, 0x58eb, 0x59cb, 0x59c9,
    0x59ff, 0x5b50, 0x5c4d, 0x5e02, 0x5e2b, 0x5fd7, 0x601d, 0x6307,
    0x652f, 0x5b5c, 0x65af, 0x65bd, 0x65e8, 0x679d, 0x6b62, 0xfffd,
    0x6b7b, 0x6c0f, 0x7345, 0x7949, 0x79c1, 0x7cf8, 0x7d19, 0x7d2b,
    0x80a2, 0x8102, 0x81f3, 0x8996, 0x8a5e, 0x8a69, 0x8a66, 0x8a8c,
    0x8aee, 0x8cc7, 0x8cdc, 0x96cc, 0x98fc, 0x6b6f, 0x4e8b, 0x4f3c,
    0x4f8d, 0x5150, 0x5b57, 0x5bfa, 0x6148, 0x6301, 0x6642, 0x6b21,
    0x6ecb, 0x6cbb, 0x723e, 0x74bd, 0x75d4, 0x78c1, 0x793a, 0x800c,
    0x8033, 0x81ea, 0x8494, 0x8f9e, 0x6c50, 0x9e7f, 0x5f0f, 0x8b58,
    0x9d2b, 0x7afa, 0x8ef8, 0x5b8d, 0x96eb, 0x4e03, 0x53f1, 0x57f7,
    0x5931, 0x5ac9, 0x5ba4, 0x6089, 0x6e7f, 0x6f06, 0x75be, 0x8cea,
    0x5b9f, 0x8500, 0x7be0, 0x5072, 0x67f4, 0x829d, 0x5c61, 0x854a,
    0x7e1e, 0x820e, 0x5199, 0x5c04, 0x6368, 0x8d66, 0x659c, 0x716e,
    0x793e, 0x7d17, 0x8005, 0x8b1d, 0x8eca, 0x906e, 0x86c7, 0x90aa,
    0x501f, 0x52fa, 0x5c3a, 0x6753, 0x707c, 0x7235, 0x914c, 0x91c8,
    0x932b, 0x82e5, 0x5bc2, 0x5f31, 0x60f9, 0x4e3b, 0x53d6, 0x5b88,
    0x624b, 0x6731, 0x6b8a, 0x72e9, 0x73e0, 0x7a2e, 0x816b, 0x8da3,
    0x9152, 0x9996, 0x5112, 0x53d7, 0x546a, 0x5bff, 0x6388, 0x6a39,
    0x7dac, 0x9700, 0x56da, 0x53ce, 0x5468, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x5b97, 0x5c31, 0x5dde, 0x4fee, 0x6101, 0x62fe, 0x6d32, 0x79c0,
    0x79cb, 0x7d42, 0x7e4d, 0x7fd2, 0x81ed, 0x821f, 0x8490, 0x8846,
    0x8972, 0x8b90, 0x8e74, 0x8f2f, 0x9031, 0x914b, 0x916c, 0x96c6,
    0x919c, 0x4ec0, 0x4f4f, 0x5145, 0x5341, 0x5f93, 0x620e, 0x67d4,
    0x6c41, 0x6e0b, 0x7363, 0x7e26, 0x91cd, 0x9283, 0x53d4, 0x5919,
    0x5bbf, 0x6dd1, 0x795d, 0x7e2e, 0x7c9b, 0x587e, 0x719f, 0x51fa,
    0x8853, 0x8ff0, 0x4fca, 0x5cfb, 0x6625, 0x77ac, 0x7ae3, 0x821c,
    0x99ff, 0x51c6, 0x5faa, 0x65ec, 0x696f, 0x6b89, 0x6df3, 0xfffd,
    0x6e96, 0x6f64, 0x76fe, 0x7d14, 0x5de1, 0x9075, 0x9187, 0x9806,
    0x51e6, 0x521d, 0x6240, 0x6691, 0x66d9, 0x6e1a, 0x5eb6, 0x7dd2,
    0x7f72, 0x66f8, 0x85af, 0x85f7, 0x8af8, 0x52a9, 0x53d9, 0x5973,
    0x5e8f, 0x5f90, 0x6055, 0x92e4, 0x9664, 0x50b7, 0x511f, 0x52dd,
    0x5320, 0x5347, 0x53ec, 0x54e8, 0x5546, 0x5531, 0x5617, 0x5968,
    0x59be, 0x5a3c, 0x5bb5, 0x5c06, 0x5c0f, 0x5c11, 0x5c1a, 0x5e84,
    0x5e8a, 0x5ee0, 0x5f70, 0x627f, 0x6284, 0x62db, 0x638c, 0x6377,
    0x6607, 0x660c, 0x662d, 0x6676, 0x677e, 0x68a2, 0x6a1f, 0x6a35,
    0x6cbc, 0x6d88, 0x6e09, 0x6e58, 0x713c, 0x7126, 0x7167, 0x75c7,
    0x7701, 0x785d, 0x7901, 0x7965, 0x79f0, 0x7ae0, 0x7b11, 0x7ca7,
    0x7d39, 0x8096, 0x83d6, 0x848b, 0x8549, 0x885d, 0x88f3, 0x8a1f,
    0x8a3c, 0x8a54, 0x8a73, 0x8c61, 0x8cde, 0x91a4, 0x9266, 0x937e,
    0x9418, 0x969c, 0x9798, 0x4e0a, 0x4e08, 0x4e1e, 0x4e57, 0x5197,
    0x5270, 0x57ce, 0x5834, 0x58cc, 0x5b22, 0x5e38, 0x60c5, 0x64fe,
    0x6761, 0x6756, 0x6d44, 0x72b6, 0x7573, 0x7a63, 0x84b8, 0x8b72,
    0x91b8, 0x9320, 0x5631, 0x57f4, 0x98fe, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x62ed, 0x690d, 0x6b96, 0x71ed, 0x7e54, 0x8077, 0x8272, 0x89e6,
    0x98df, 0x8755, 0x8fb1, 0x5c3b, 0x4f38, 0x4fe1, 0x4fb5, 0x5507,
    0x5a20, 0x5bdd, 0x5be9, 0x5fc3, 0x614e, 0x632f, 0x65b0, 0x664b,
    0x68ee, 0x699b, 0x6d78, 0x6df1, 0x7533, 0x75b9, 0x771f, 0x795e,
    0x79e6, 0x7d33, 0x81e3, 0x82af, 0x85aa, 0x89aa, 0x8a3a, 0x8eab,
    0x8f9b, 0x9032, 0x91dd, 0x9707, 0x4eba, 0x4ec1, 0x5203, 0x5875,
    0x58ec, 0x5c0b, 0x751a, 0x5c3d, 0x814e, 0x8a0a, 0x8fc5, 0x9663,
    0x976d, 0x7b25, 0x8acf, 0x9808, 0x9162, 0x56f3, 0x53a8, 0xfffd,
    0x9017, 0x5439, 0x5782, 0x5e25, 0x63a8, 0x6c34, 0x708a, 0x7761,
    0x7c8b, 0x7fe0, 0x8870, 0x9042, 0x9154, 0x9310, 0x9318, 0x968f,
    0x745e, 0x9ac4, 0x5d07, 0x5d69, 0x6570, 0x67a2, 0x8da8, 0x96db,
    0x636e, 0x6749, 0x6919, 0x83c5, 0x9817, 0x96c0, 0x88fe, 0x6f84,
    0x647a, 0x5bf8, 0x4e16, 0x702c, 0x755d, 0x662f, 0x51c4, 0x5236,
    0x52e2, 0x59d3, 0x5f81, 0x6027, 0x6210, 0x653f, 0x6574, 0x661f,
    0x6674, 0x68f2, 0x6816, 0x6b63, 0x6e05, 0x7272, 0x751f, 0x76db,
    0x7cbe, 0x8056, 0x58f0, 0x88fd, 0x897f, 0x8aa0, 0x8a93, 0x8acb,
    0x901d, 0x9192, 0x9752, 0x9759, 0x6589, 0x7a0e, 0x8106, 0x96bb,
    0x5e2d, 0x60dc, 0x621a, 0x65a5, 0x6614, 0x6790, 0x77f3, 0x7a4d,
    0x7c4d, 0x7e3e, 0x810a, 0x8cac, 0x8d64, 0x8de1, 0x8e5f, 0x78a9,
    0x5207, 0x62d9, 0x63a5, 0x6442, 0x6298, 0x8a2d, 0x7a83, 0x7bc0,
    0x8aac, 0x96ea, 0x7d76, 0x820c, 0x8749, 0x4ed9, 0x5148, 0x5343,
    0x5360, 0x5ba3, 0x5c02, 0x5c16, 0x5ddd, 0x6226, 0x6247, 0x64b0,
    0x6813, 0x6834, 0x6cc9, 0x6d45, 0x6d17, 0x67d3, 0x6f5c, 0x714e,
    0x717d, 0x65cb, 0x7a7f, 0x7bad, 0x7dda, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x7e4a, 0x7fa8, 0x817a, 0x821b, 0x8239, 0x85a6, 0x8a6e, 0x8cce,
    0x8df5, 0x9078, 0x9077, 0x92ad, 0x9291, 0x9583, 0x9bae, 0x524d,
    0x5584, 0x6f38, 0x7136, 0x5168, 0x7985, 0x7e55, 0x81b3, 0x7cce,
    0x564c, 0x5851, 0x5ca8, 0x63aa, 0x66fe, 0x66fd, 0x695a, 0x72d9,
    0x758f, 0x758e, 0x790e, 0x7956, 0x79df, 0x7c97, 0x7d20, 0x7d44,
    0x8607, 0x8a34, 0x963b, 0x9061, 0x9f20, 0x50e7, 0x5275, 0x53cc,
    0x53e2, 0x5009, 0x55aa, 0x58ee, 0x594f, 0x723d, 0x5b8b, 0x5c64,
    0x531d, 0x60e3, 0x60f3, 0x635c, 0x6383, 0x633f, 0x63bb, 0xfffd,
    0x64cd, 0x65e9, 0x66f9, 0x5de3, 0x69cd, 0x69fd, 0x6f15, 0x71e5,
    0x4e89, 0x75e9, 0x76f8, 0x7a93, 0x7cdf, 0x7dcf, 0x7d9c, 0x8061,
    0x8349, 0x8358, 0x846c, 0x84bc, 0x85fb, 0x88c5, 0x8d70, 0x9001,
    0x906d, 0x9397, 0x971c, 0x9a12, 0x50cf, 0x5897, 0x618e, 0x81d3,
    0x8535, 0x8d08, 0x9020, 0x4fc3, 0x5074, 0x5247, 0x5373, 0x606f,
    0x6349, 0x675f, 0x6e2c, 0x8db3, 0x901f, 0x4fd7, 0x5c5e, 0x8cca,
    0x65cf, 0x7d9a, 0x5352, 0x8896, 0x5176, 0x63c3, 0x5b58, 0x5b6b,
    0x5c0a, 0x640d, 0x6751, 0x905c, 0x4ed6, 0x591a, 0x592a, 0x6c70,
    0x8a51, 0x553e, 0x5815, 0x59a5, 0x60f0, 0x6253, 0x67c1, 0x8235,
    0x6955, 0x9640, 0x99c4, 0x9a28, 0x4f53, 0x5806, 0x5bfe, 0x8010,
    0x5cb1, 0x5e2f, 0x5f85, 0x6020, 0x614b, 0x6234, 0x66ff, 0x6cf0,
    0x6ede, 0x80ce, 0x817f, 0x82d4, 0x888b, 0x8cb8, 0x9000, 0x902e,
    0x968a, 0x9edb, 0x9bdb, 0x4ee3, 0x53f0, 0x5927, 0x7b2c, 0x918d,
    0x984c, 0x9df9, 0x6edd, 0x7027, 0x5353, 0x5544, 0x5b85, 0x6258,
    0x629e, 0x62d3, 0x6ca2, 0x6fef, 0x7422, 0x8a17, 0x9438, 0x6fc1,
    0x8afe, 0x8338, 0x51e7, 0x86f8, 0x53ea, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x53e9, 0x4f46, 0x9054, 0x8fb0, 0x596a, 0x8131, 0x5dfd, 0x7aea,
    0x8fbf, 0x68da, 0x8c37, 0x72f8, 0x9c48, 0x6a3d, 0x8ab0, 0x4e39,
    0x5358, 0x5606, 0x5766, 0x62c5, 0x63a2, 0x65e6, 0x6b4e, 0x6de1,
    0x6e5b, 0x70ad, 0x77ed, 0x7aef, 0x7baa, 0x7dbb, 0x803d, 0x80c6,
    0x86cb, 0x8a95, 0x935b, 0x56e3, 0x58c7, 0x5f3e, 0x65ad, 0x6696,
    0x6a80, 0x6bb5, 0x7537, 0x8ac7, 0x5024, 0x77e5, 0x5730, 0x5f1b,
    0x6065, 0x667a, 0x6c60, 0x75f4, 0x7a1a, 0x7f6e, 0x81f4, 0x8718,
    0x9045, 0x99b3, 0x7bc9, 0x755c, 0x7af9, 0x7b51, 0x84c4, 0xfffd,
    0x9010, 0x79e9, 0x7a92, 0x8336, 0x5ae1, 0x7740, 0x4e2d, 0x4ef2,
    0x5b99, 0x5fe0, 0x62bd, 0x663c, 0x67f1, 0x6ce8, 0x866b, 0x8877,
    0x8a3b, 0x914e, 0x92f3, 0x99d0, 0x6a17, 0x7026, 0x732a, 0x82e7,
    0x8457, 0x8caf, 0x4e01, 0x5146, 0x51cb, 0x558b, 0x5bf5, 0x5e16,
    0x5e33, 0x5e81, 0x5f14, 0x5f35, 0x5f6b, 0x5fb4, 0x61f2, 0x6311,
    0x66a2, 0x671d, 0x6f6e, 0x7252, 0x753a, 0x773a, 0x8074, 0x8139,
    0x8178, 0x8776, 0x8abf, 0x8adc, 0x8d85, 0x8df3, 0x929a, 0x9577,
    0x9802, 0x9ce5, 0x52c5, 0x6357, 0x76f4, 0x6715, 0x6c88, 0x73cd,
    0x8cc3, 0x93ae, 0x9673, 0x6d25, 0x589c, 0x690e, 0x69cc, 0x8ffd,
    0x939a, 0x75db, 0x901a, 0x585a, 0x6802, 0x63b4, 0x69fb, 0x4f43,
    0x6f2c, 0x67d8, 0x8fbb, 0x8526, 0x7db4, 0x9354, 0x693f, 0x6f70,
    0x576a, 0x58f7, 0x5b2c, 0x7d2c, 0x722a, 0x540a, 0x91e3, 0x9db4,
    0x4ead, 0x4f4e, 0x505c, 0x5075, 0x5243, 0x8c9e, 0x5448, 0x5824,
    0x5b9a, 0x5e1d, 0x5e95, 0x5ead, 0x5ef7, 0x5f1f, 0x608c, 0x62b5,
    0x633a, 0x63d0, 0x68af, 0x6c40, 0x7887, 0x798e, 0x7a0b, 0x7de0,
    0x8247, 0x8a02, 0x8ae6, 0x8e44, 0x9013, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x90b8, 0x912d, 0x91d8, 0x9f0e, 0x6ce5, 0x6458, 0x64e2, 0x6575,
    0x6ef4, 0x7684, 0x7b1b, 0x9069, 0x93d1, 0x6eba, 0x54f2, 0x5fb9,
    0x64a4, 0x8f4d, 0x8fed, 0x9244, 0x5178, 0x586b, 0x5929, 0x5c55,
    0x5e97, 0x6dfb, 0x7e8f, 0x751c, 0x8cbc, 0x8ee2, 0x985b, 0x70b9,
    0x4f1d, 0x6bbf, 0x6fb1, 0x7530, 0x96fb, 0x514e, 0x5410, 0x5835,
    0x5857, 0x59ac, 0x5c60, 0x5f92, 0x6597, 0x675c, 0x6e21, 0x767b,
    0x83df, 0x8ced, 0x9014, 0x90fd, 0x934d, 0x7825, 0x783a, 0x52aa,
    0x5ea6, 0x571f, 0x5974, 0x6012, 0x5012, 0x515a, 0x51ac, 0xfffd,
    0x51cd, 0x5200, 0x5510, 0x5854, 0x5858, 0x5957, 0x5b95, 0x5cf6,
    0x5d8b, 0x60bc, 0x6295, 0x642d, 0x6771, 0x6843, 0x68bc, 0x68df,
    0x76d7, 0x6dd8, 0x6e6f, 0x6d9b, 0x706f, 0x71c8, 0x5f53, 0x75d8,
    0x7977, 0x7b49, 0x7b54, 0x7b52, 0x7cd6, 0x7d71, 0x5230, 0x8463,
    0x8569, 0x85e4, 0x8a0e, 0x8b04, 0x8c46, 0x8e0f, 0x9003, 0x900f,
    0x9419, 0x9676, 0x982d, 0x9a30, 0x95d8, 0x50cd, 0x52d5, 0x540c,
    0x5802, 0x5c0e, 0x61a7, 0x649e, 0x6d1e, 0x77b3, 0x7ae5, 0x80f4,
    0x8404, 0x9053, 0x9285, 0x5ce0, 0x9d07, 0x533f, 0x5f97, 0x5fb3,
    0x6d9c, 0x7279, 0x7763, 0x79bf, 0x7be4, 0x6bd2, 0x72ec, 0x8aad,
    0x6803, 0x6a61, 0x51f8, 0x7a81, 0x6934, 0x5c4a, 0x9cf6, 0x82eb,
    0x5bc5, 0x9149, 0x701e, 0x5678, 0x5c6f, 0x60c7, 0x6566, 0x6c8c,
    0x8c5a, 0x9041, 0x9813, 0x5451, 0x66c7, 0x920d, 0x5948, 0x90a3,
    0x5185, 0x4e4d, 0x51ea, 0x8599, 0x8b0e, 0x7058, 0x637a, 0x934b,
    0x6962, 0x99b4, 0x7e04, 0x7577, 0x5357, 0x6960, 0x8edf, 0x96e3,
    0x6c5d, 0x4e8c, 0x5c3c, 0x5f10, 0x8fe9, 0x5302, 0x8cd1, 0x8089,
    0x8679, 0x5eff, 0x65e5, 0x4e73, 0x5165, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x5982, 0x5c3f, 0x97ee, 0x4efb, 0x598a, 0x5fcd, 0x8a8d, 0x6fe1,
    0x79b0, 0x7962, 0x5be7, 0x8471, 0x732b, 0x71b1, 0x5e74, 0x5ff5,
    0x637b, 0x649a, 0x71c3, 0x7c98, 0x4e43, 0x5efc, 0x4e4b, 0x57dc,
    0x56a2, 0x60a9, 0x6fc3, 0x7d0d, 0x80fd, 0x8133, 0x81bf, 0x8fb2,
    0x8997, 0x86a4, 0x5df4, 0x628a, 0x64ad, 0x8987, 0x6777, 0x6ce2,
    0x6d3e, 0x7436, 0x7834, 0x5a46, 0x7f75, 0x82ad, 0x99ac, 0x4ff3,
    0x5ec3, 0x62dd, 0x6392, 0x6557, 0x676f, 0x76c3, 0x724c, 0x80cc,
    0x80ba, 0x8f29, 0x914d, 0x500d, 0x57f9, 0x5a92, 0x6885, 0xfffd,
    0x6973, 0x7164, 0x72fd, 0x8cb7, 0x58f2, 0x8ce0, 0x966a, 0x9019,
    0x877f, 0x79e4, 0x77e7, 0x8429, 0x4f2f, 0x5265, 0x535a, 0x62cd,
    0x67cf, 0x6cca, 0x767d, 0x7b94, 0x7c95, 0x8236, 0x8584, 0x8feb,
    0x66dd, 0x6f20, 0x7206, 0x7e1b, 0x83ab, 0x99c1, 0x9ea6, 0x51fd,
    0x7bb1, 0x7872, 0x7bb8, 0x8087, 0x7b48, 0x6ae8, 0x5e61, 0x808c,
    0x7551, 0x7560, 0x516b, 0x9262, 0x6e8c, 0x767a, 0x9197, 0x9aea,
    0x4f10, 0x7f70, 0x629c, 0x7b4f, 0x95a5, 0x9ce9, 0x567a, 0x5859,
    0x86e4, 0x96bc, 0x4f34, 0x5224, 0x534a, 0x53cd, 0x53db, 0x5e06,
    0x642c, 0x6591, 0x677f, 0x6c3e, 0x6c4e, 0x7248, 0x72af, 0x73ed,
    0x7554, 0x7e41, 0x822c, 0x85e9, 0x8ca9, 0x7bc4, 0x91c6, 0x7169,
    0x9812, 0x98ef, 0x633d, 0x6669, 0x756a, 0x76e4, 0x78d0, 0x8543,
    0x86ee, 0x532a, 0x5351, 0x5426, 0x5983, 0x5e87, 0x5f7c, 0x60b2,
    0x6249, 0x6279, 0x62ab, 0x6590, 0x6bd4, 0x6ccc, 0x75b2, 0x76ae,
    0x7891, 0x79d8, 0x7dcb, 0x7f77, 0x80a5, 0x88ab, 0x8ab9, 0x8cbb,
    0x907f, 0x975e, 0x98db, 0x6a0b, 0x7c38, 0x5099, 0x5c3e, 0x5fae,
    0x6787, 0x6bd8, 0x7435, 0x7709, 0x7f8e, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9f3b, 0x67ca, 0x7a17, 0x5339, 0x758b, 0x9aed, 0x5f66, 0x819d,
    0x83f1, 0x8098, 0x5f3c, 0x5fc5, 0x7562, 0x7b46, 0x903c, 0x6867,
    0x59eb, 0x5a9b, 0x7d10, 0x767e, 0x8b2c, 0x4ff5, 0x5f6a, 0x6a19,
    0x6c37, 0x6f02, 0x74e2, 0x7968, 0x8868, 0x8a55, 0x8c79, 0x5edf,
    0x63cf, 0x75c5, 0x79d2, 0x82d7, 0x9328, 0x92f2, 0x849c, 0x86ed,
    0x9c2d, 0x54c1, 0x5f6c, 0x658c, 0x6d5c, 0x7015, 0x8ca7, 0x8cd3,
    0x983b, 0x654f, 0x74f6, 0x4e0d, 0x4ed8, 0x57e0, 0x592b, 0x5a66,
    0x5bcc, 0x51a8, 0x5e03, 0x5e9c, 0x6016, 0x6276, 0x6577, 0xfffd,
    0x65a7, 0x666e, 0x6d6e, 0x7236, 0x7b26, 0x8150, 0x819a, 0x8299,
    0x8b5c, 0x8ca0, 0x8ce6, 0x8d74, 0x961c, 0x9644, 0x4fae, 0x64ab,
    0x6b66, 0x821e, 0x8461, 0x856a, 0x90e8, 0x5c01, 0x6953, 0x98a8,
    0x847a, 0x8557, 0x4f0f, 0x526f, 0x5fa9, 0x5e45, 0x670d, 0x798f,
    0x8179, 0x8907, 0x8986, 0x6df5, 0x5f17, 0x6255, 0x6cb8, 0x4ecf,
    0x7269, 0x9b92, 0x5206, 0x543b, 0x5674, 0x58b3, 0x61a4, 0x626e,
    0x711a, 0x596e, 0x7c89, 0x7cde, 0x7d1b, 0x96f0, 0x6587, 0x805e,
    0x4e19, 0x4f75, 0x5175, 0x5840, 0x5e63, 0x5e73, 0x5f0a, 0x67c4,
    0x4e26, 0x853d, 0x9589, 0x965b, 0x7c73, 0x9801, 0x50fb, 0x58c1,
    0x7656, 0x78a7, 0x5225, 0x77a5, 0x8511, 0x7b86, 0x504f, 0x5909,
    0x7247, 0x7bc7, 0x7de8, 0x8fba, 0x8fd4, 0x904d, 0x4fbf, 0x52c9,
    0x5a29, 0x5f01, 0x97ad, 0x4fdd, 0x8217, 0x92ea, 0x5703, 0x6355,
    0x6b69, 0x752b, 0x88dc, 0x8f14, 0x7a42, 0x52df, 0x5893, 0x6155,
    0x620a, 0x66ae, 0x6bcd, 0x7c3f, 0x83e9, 0x5023, 0x4ff8, 0x5305,
    0x5446, 0x5831, 0x5949, 0x5b9d, 0x5cf0, 0x5cef, 0x5d29, 0x5e96,
    0x62b1, 0x6367, 0x653e, 0x65b9, 0x670b, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x6cd5, 0x6ce1, 0x70f9, 0x7832, 0x7e2b, 0x80de, 0x82b3, 0x840c,
    0x84ec, 0x8702, 0x8912, 0x8a2a, 0x8c4a, 0x90a6, 0x92d2, 0x98fd,
    0x9cf3, 0x9d6c, 0x4e4f, 0x4ea1, 0x508d, 0x5256, 0x574a, 0x59a8,
    0x5e3d, 0x5fd8, 0x5fd9, 0x623f, 0x66b4, 0x671b, 0x67d0, 0x68d2,
    0x5192, 0x7d21, 0x80aa, 0x81a8, 0x8b00, 0x8c8c, 0x8cbf, 0x927e,
    0x9632, 0x5420, 0x982c, 0x5317, 0x50d5, 0x535c, 0x58a8, 0x64b2,
    0x6734, 0x7267, 0x7766, 0x7a46, 0x91e6, 0x52c3, 0x6ca1, 0x6b86,
    0x5800, 0x5e4c, 0x5954, 0x672c, 0x7ffb, 0x51e1, 0x76c6, 0xfffd,
    0x6469, 0x78e8, 0x9b54, 0x9ebb, 0x57cb, 0x59b9, 0x6627, 0x679a,
    0x6bce, 0x54e9, 0x69d9, 0x5e55, 0x819c, 0x6795, 0x9baa, 0x67fe,
    0x9c52, 0x685d, 0x4ea6, 0x4fe3, 0x53c8, 0x62b9, 0x672b, 0x6cab,
    0x8fc4, 0x4fad, 0x7e6d, 0x9ebf, 0x4e07, 0x6162, 0x6e80, 0x6f2b,
    0x8513, 0x5473, 0x672a, 0x9b45, 0x5df3, 0x7b95, 0x5cac, 0x5bc6,
    0x871c, 0x6e4a, 0x84d1, 0x7a14, 0x8108, 0x5999, 0x7c8d, 0x6c11,
    0x7720, 0x52d9, 0x5922, 0x7121, 0x725f, 0x77db, 0x9727, 0x9d61,
    0x690b, 0x5a7f, 0x5a18, 0x51a5, 0x540d, 0x547d, 0x660e, 0x76df,
    0x8ff7, 0x9298, 0x9cf4, 0x59ea, 0x725d, 0x6ec5, 0x514d, 0x68c9,
    0x7dbf, 0x7dec, 0x9762, 0x9eba, 0x6478, 0x6a21, 0x8302, 0x5984,
    0x5b5f, 0x6bdb, 0x731b, 0x76f2, 0x7db2, 0x8017, 0x8499, 0x5132,
    0x6728, 0x9ed9, 0x76ee, 0x6762, 0x52ff, 0x9905, 0x5c24, 0x623b,
    0x7c7e, 0x8cb0, 0x554f, 0x60b6, 0x7d0b, 0x9580, 0x5301, 0x4e5f,
    0x51b6, 0x591c, 0x723a, 0x8036, 0x91ce, 0x5f25, 0x77e2, 0x5384,
    0x5f79, 0x7d04, 0x85ac, 0x8a33, 0x8e8d, 0x9756, 0x67f3, 0x85ae,
    0x9453, 0x6109, 0x6108, 0x6cb9, 0x7652, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8aed, 0x8f38, 0x552f, 0x4f51, 0x512a, 0x52c7, 0x53cb, 0x5ba5,
    0x5e7d, 0x60a0, 0x6182, 0x63d6, 0x6709, 0x67da, 0x6e67, 0x6d8c,
    0x7336, 0x7337, 0x7531, 0x7950, 0x88d5, 0x8a98, 0x904a, 0x9091,
    0x90f5, 0x96c4, 0x878d, 0x5915, 0x4e88, 0x4f59, 0x4e0e, 0x8a89,
    0x8f3f, 0x9810, 0x50ad, 0x5e7c, 0x5996, 0x5bb9, 0x5eb8, 0x63da,
    0x63fa, 0x64c1, 0x66dc, 0x694a, 0x69d8, 0x6d0b, 0x6eb6, 0x7194,
    0x7528, 0x7aaf, 0x7f8a, 0x8000, 0x8449, 0x84c9, 0x8981, 0x8b21,
    0x8e0a, 0x9065, 0x967d, 0x990a, 0x617e, 0x6291, 0x6b32, 0xfffd,
    0x6c83, 0x6d74, 0x7fcc, 0x7ffc, 0x6dc0, 0x7f85, 0x87ba, 0x88f8,
    0x6765, 0x83b1, 0x983c, 0x96f7, 0x6d1b, 0x7d61, 0x843d, 0x916a,
    0x4e71, 0x5375, 0x5d50, 0x6b04, 0x6feb, 0x85cd, 0x862d, 0x89a7,
    0x5229, 0x540f, 0x5c65, 0x674e, 0x68a8, 0x7406, 0x7483, 0x75e2,
    0x88cf, 0x88e1, 0x91cc, 0x96e2, 0x9678, 0x5f8b, 0x7387, 0x7acb,
    0x844e, 0x63a0, 0x7565, 0x5289, 0x6d41, 0x6e9c, 0x7409, 0x7559,
    0x786b, 0x7c92, 0x9686, 0x7adc, 0x9f8d, 0x4fb6, 0x616e, 0x65c5,
    0x865c, 0x4e86, 0x4eae, 0x50da, 0x4e21, 0x51cc, 0x5bee, 0x6599,
    0x6881, 0x6dbc, 0x731f, 0x7642, 0x77ad, 0x7a1c, 0x7ce7, 0x826f,
    0x8ad2, 0x907c, 0x91cf, 0x9675, 0x9818, 0x529b, 0x7dd1, 0x502b,
    0x5398, 0x6797, 0x6dcb, 0x71d0, 0x7433, 0x81e8, 0x8f2a, 0x96a3,
    0x9c57, 0x9e9f, 0x7460, 0x5841, 0x6d99, 0x7d2f, 0x985e, 0x4ee4,
    0x4f36, 0x4f8b, 0x51b7, 0x52b1, 0x5dba, 0x601c, 0x73b2, 0x793c,
    0x82d3, 0x9234, 0x96b7, 0x96f6, 0x970a, 0x9e97, 0x9f62, 0x66a6,
    0x6b74, 0x5217, 0x52a3, 0x70c8, 0x88c2, 0x5ec9, 0x604b, 0x6190,
    0x6f23, 0x7149, 0x7c3e, 0x7df4, 0x806f, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x84ee, 0x9023, 0x932c, 0x5442, 0x9b6f, 0x6ad3, 0x7089, 0x8cc2,
    0x8def, 0x9732, 0x52b4, 0x5a41, 0x5eca, 0x5f04, 0x6717, 0x697c,
    0x6994, 0x6d6a, 0x6f0f, 0x7262, 0x72fc, 0x7bed, 0x8001, 0x807e,
    0x874b, 0x90ce, 0x516d, 0x9e93, 0x7984, 0x808b, 0x9332, 0x8ad6,
    0x502d, 0x548c, 0x8a71, 0x6b6a, 0x8cc4, 0x8107, 0x60d1, 0x67a0,
    0x9df2, 0x4e99, 0x4e98, 0x9c10, 0x8a6b, 0x85c1, 0x8568, 0x6900,
    0x6e7e, 0x7897, 0x8155, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x5f0c,
    0x4e10, 0x4e15, 0x4e2a, 0x4e31, 0x4e36, 0x4e3c, 0x4e3f, 0x4e42,
    0x4e56, 0x4e58, 0x4e82, 0x4e85, 0x8c6b, 0x4e8a, 0x8212, 0x5f0d,
    0x4e8e, 0x4e9e, 0x4e9f, 0x4ea0, 0x4ea2, 0x4eb0, 0x4eb3, 0x4eb6,
    0x4ece, 0x4ecd, 0x4ec4, 0x4ec6, 0x4ec2, 0x4ed7, 0x4ede, 0x4eed,
    0x4edf, 0x4ef7, 0x4f09, 0x4f5a, 0x4f30, 0x4f5b, 0x4f5d, 0x4f57,
    0x4f47, 0x4f76, 0x4f88, 0x4f8f, 0x4f98, 0x4f7b, 0x4f69, 0x4f70,
    0x4f91, 0x4f6f, 0x4f86, 0x4f96, 0x5118, 0x4fd4, 0x4fdf, 0x4fce,
    0x4fd8, 0x4fdb, 0x4fd1, 0x4fda, 0x4fd0, 0x4fe4, 0x4fe5, 0x501a,
    0x5028, 0x5014, 0x502a, 0x5025, 0x5005, 0x4f1c, 0x4ff6, 0x5021,
    0x5029, 0x502c, 0x4ffe, 0x4fef, 0x5011, 0x5006, 0x5043, 0x5047,
    0x6703, 0x5055, 0x5050, 0x5048, 0x505a, 0x5056, 0x506c, 0x5078,
    0x5080, 0x509a, 0x5085, 0x50b4, 0x50b2, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x50c9, 0x50ca, 0x50b3, 0x50c2, 0x50d6, 0x50de, 0x50e5, 0x50ed,
    0x50e3, 0x50ee, 0x50f9, 0x50f5, 0x5109, 0x5101, 0x5102, 0x5116,
    0x5115, 0x5114, 0x511a, 0x5121, 0x513a, 0x5137, 0x513c, 0x513b,
    0x513f, 0x5140, 0x5152, 0x514c, 0x5154, 0x5162, 0x7af8, 0x5169,
    0x516a, 0x516e, 0x5180, 0x5182, 0x56d8, 0x518c, 0x5189, 0x518f,
    0x5191, 0x5193, 0x5195, 0x5196, 0x51a4, 0x51a6, 0x51a2, 0x51a9,
    0x51aa, 0x51ab, 0x51b3, 0x51b1, 0x51b2, 0x51b0, 0x51b5, 0x51bd,
    0x51c5, 0x51c9, 0x51db, 0x51e0, 0x8655, 0x51e9, 0x51ed, 0xfffd,
    0x51f0, 0x51f5, 0x51fe, 0x5204, 0x520b, 0x5214, 0x520e, 0x5227,
    0x522a, 0x522e, 0x5233, 0x5239, 0x524f, 0x5244, 0x524b, 0x524c,
    0x525e, 0x5254, 0x526a, 0x5274, 0x5269, 0x5273, 0x527f, 0x527d,
    0x528d, 0x5294, 0x5292, 0x5271, 0x5288, 0x5291, 0x8fa8, 0x8fa7,
    0x52ac, 0x52ad, 0x52bc, 0x52b5, 0x52c1, 0x52cd, 0x52d7, 0x52de,
    0x52e3, 0x52e6, 0x98ed, 0x52e0, 0x52f3, 0x52f5, 0x52f8, 0x52f9,
    0x5306, 0x5308, 0x7538, 0x530d, 0x5310, 0x530f, 0x5315, 0x531a,
    0x5323, 0x532f, 0x5331, 0x5333, 0x5338, 0x5340, 0x5346, 0x5345,
    0x4e17, 0x5349, 0x534d, 0x51d6, 0x535e, 0x5369, 0x536e, 0x5918,
    0x537b, 0x5377, 0x5382, 0x5396, 0x53a0, 0x53a6, 0x53a5, 0x53ae,
    0x53b0, 0x53b6, 0x53c3, 0x7c12, 0x96d9, 0x53df, 0x66fc, 0x71ee,
    0x53ee, 0x53e8, 0x53ed, 0x53fa, 0x5401, 0x543d, 0x5440, 0x542c,
    0x542d, 0x543c, 0x542e, 0x5436, 0x5429, 0x541d, 0x544e, 0x548f,
    0x5475, 0x548e, 0x545f, 0x5471, 0x5477, 0x5470, 0x5492, 0x547b,
    0x5480, 0x5476, 0x5484, 0x5490, 0x5486, 0x54c7, 0x54a2, 0x54b8,
    0x54a5, 0x54ac, 0x54c4, 0x54c8, 0x54a8, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x54ab, 0x54c2, 0x54a4, 0x54be, 0x54bc, 0x54d8, 0x54e5, 0x54e6,
    0x550f, 0x5514, 0x54fd, 0x54ee, 0x54ed, 0x54fa, 0x54e2, 0x5539,
    0x5540, 0x5563, 0x554c, 0x552e, 0x555c, 0x5545, 0x5556, 0x5557,
    0x5538, 0x5533, 0x555d, 0x5599, 0x5580, 0x54af, 0x558a, 0x559f,
    0x557b, 0x557e, 0x5598, 0x559e, 0x55ae, 0x557c, 0x5583, 0x55a9,
    0x5587, 0x55a8, 0x55da, 0x55c5, 0x55df, 0x55c4, 0x55dc, 0x55e4,
    0x55d4, 0x5614, 0x55f7, 0x5616, 0x55fe, 0x55fd, 0x561b, 0x55f9,
    0x564e, 0x5650, 0x71df, 0x5634, 0x5636, 0x5632, 0x5638, 0xfffd,
    0x566b, 0x5664, 0x562f, 0x566c, 0x566a, 0x5686, 0x5680, 0x568a,
    0x56a0, 0x5694, 0x568f, 0x56a5, 0x56ae, 0x56b6, 0x56b4, 0x56c2,
    0x56bc, 0x56c1, 0x56c3, 0x56c0, 0x56c8, 0x56ce, 0x56d1, 0x56d3,
    0x56d7, 0x56ee, 0x56f9, 0x5700, 0x56ff, 0x5704, 0x5709, 0x5708,
    0x570b, 0x570d, 0x5713, 0x5718, 0x5716, 0x55c7, 0x571c, 0x5726,
    0x5737, 0x5738, 0x574e, 0x573b, 0x5740, 0x574f, 0x5769, 0x57c0,
    0x5788, 0x5761, 0x577f, 0x5789, 0x5793, 0x57a0, 0x57b3, 0x57a4,
    0x57aa, 0x57b0, 0x57c3, 0x57c6, 0x57d4, 0x57d2, 0x57d3, 0x580a,
    0x57d6, 0x57e3, 0x580b, 0x5819, 0x581d, 0x5872, 0x5821, 0x5862,
    0x584b, 0x5870, 0x6bc0, 0x5852, 0x583d, 0x5879, 0x5885, 0x58b9,
    0x589f, 0x58ab, 0x58ba, 0x58de, 0x58bb, 0x58b8, 0x58ae, 0x58c5,
    0x58d3, 0x58d1, 0x58d7, 0x58d9, 0x58d8, 0x58e5, 0x58dc, 0x58e4,
    0x58df, 0x58ef, 0x58fa, 0x58f9, 0x58fb, 0x58fc, 0x58fd, 0x5902,
    0x590a, 0x5910, 0x591b, 0x68a6, 0x5925, 0x592c, 0x592d, 0x5932,
    0x5938, 0x593e, 0x7ad2, 0x5955, 0x5950, 0x594e, 0x595a, 0x5958,
    0x5962, 0x5960, 0x5967, 0x596c, 0x5969, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x5978, 0x5981, 0x599d, 0x4f5e, 0x4fab, 0x59a3, 0x59b2, 0x59c6,
    0x59e8, 0x59dc, 0x598d, 0x59d9, 0x59da, 0x5a25, 0x5a1f, 0x5a11,
    0x5a1c, 0x5a09, 0x5a1a, 0x5a40, 0x5a6c, 0x5a49, 0x5a35, 0x5a36,
    0x5a62, 0x5a6a, 0x5a9a, 0x5abc, 0x5abe, 0x5acb, 0x5ac2, 0x5abd,
    0x5ae3, 0x5ad7, 0x5ae6, 0x5ae9, 0x5ad6, 0x5afa, 0x5afb, 0x5b0c,
    0x5b0b, 0x5b16, 0x5b32, 0x5ad0, 0x5b2a, 0x5b36, 0x5b3e, 0x5b43,
    0x5b45, 0x5b40, 0x5b51, 0x5b55, 0x5b5a, 0x5b5b, 0x5b65, 0x5b69,
    0x5b70, 0x5b73, 0x5b75, 0x5b78, 0x6588, 0x5b7a, 0x5b80, 0xfffd,
    0x5b83, 0x5ba6, 0x5bb8, 0x5bc3, 0x5bc7, 0x5bc9, 0x5bd4, 0x5bd0,
    0x5be4, 0x5be6, 0x5be2, 0x5bde, 0x5be5, 0x5beb, 0x5bf0, 0x5bf6,
    0x5bf3, 0x5c05, 0x5c07, 0x5c08, 0x5c0d, 0x5c13, 0x5c20, 0x5c22,
    0x5c28, 0x5c38, 0x5c39, 0x5c41, 0x5c46, 0x5c4e, 0x5c53, 0x5c50,
    0x5c4f, 0x5b71, 0x5c6c, 0x5c6e, 0x4e62, 0x5c76, 0x5c79, 0x5c8c,
    0x5c91, 0x5c94, 0x599b, 0x5cab, 0x5cbb, 0x5cb6, 0x5cbc, 0x5cb7,
    0x5cc5, 0x5cbe, 0x5cc7, 0x5cd9, 0x5ce9, 0x5cfd, 0x5cfa, 0x5ced,
    0x5d8c, 0x5cea, 0x5d0b, 0x5d15, 0x5d17, 0x5d5c, 0x5d1f, 0x5d1b,
    0x5d11, 0x5d14, 0x5d22, 0x5d1a, 0x5d19, 0x5d18, 0x5d4c, 0x5d52,
    0x5d4e, 0x5d4b, 0x5d6c, 0x5d73, 0x5d76, 0x5d87, 0x5d84, 0x5d82,
    0x5da2, 0x5d9d, 0x5dac, 0x5dae, 0x5dbd, 0x5d90, 0x5db7, 0x5dbc,
    0x5dc9, 0x5dcd, 0x5dd3, 0x5dd2, 0x5dd6, 0x5ddb, 0x5deb, 0x5df2,
    0x5df5, 0x5e0b, 0x5e1a, 0x5e19, 0x5e11, 0x5e1b, 0x5e36, 0x5e37,
    0x5e44, 0x5e43, 0x5e40, 0x5e4e, 0x5e57, 0x5e54, 0x5e5f, 0x5e62,
    0x5e64, 0x5e47, 0x5e75, 0x5e76, 0x5e7a, 0x9ebc, 0x5e7f, 0x5ea0,
    0x5ec1, 0x5ec2, 0x5ec8, 0x5ed0, 0x5ecf, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x5ed6, 0x5ee3, 0x5edd, 0x5eda, 0x5edb, 0x5ee2, 0x5ee1, 0x5ee8,
    0x5ee9, 0x5eec, 0x5ef1, 0x5ef3, 0x5ef0, 0x5ef4, 0x5ef8, 0x5efe,
    0x5f03, 0x5f09, 0x5f5d, 0x5f5c, 0x5f0b, 0x5f11, 0x5f16, 0x5f29,
    0x5f2d, 0x5f38, 0x5f41, 0x5f48, 0x5f4c, 0x5f4e, 0x5f2f, 0x5f51,
    0x5f56, 0x5f57, 0x5f59, 0x5f61, 0x5f6d, 0x5f73, 0x5f77, 0x5f83,
    0x5f82, 0x5f7f, 0x5f8a, 0x5f88, 0x5f91, 0x5f87, 0x5f9e, 0x5f99,
    0x5f98, 0x5fa0, 0x5fa8, 0x5fad, 0x5fbc, 0x5fd6, 0x5ffb, 0x5fe4,
    0x5ff8, 0x5ff1, 0x5fdd, 0x60b3, 0x5fff, 0x6021, 0x6060, 0xfffd,
    0x6019, 0x6010, 0x6029, 0x600e, 0x6031, 0x601b, 0x6015, 0x602b,
    0x6026, 0x600f, 0x603a, 0x605a, 0x6041, 0x606a, 0x6077, 0x605f,
    0x604a, 0x6046, 0x604d, 0x6063, 0x6043, 0x6064, 0x6042, 0x606c,
    0x606b, 0x6059, 0x6081, 0x608d, 0x60e7, 0x6083, 0x609a, 0x6084,
    0x609b, 0x6096, 0x6097, 0x6092, 0x60a7, 0x608b, 0x60e1, 0x60b8,
    0x60e0, 0x60d3, 0x60b4, 0x5ff0, 0x60bd, 0x60c6, 0x60b5, 0x60d8,
    0x614d, 0x6115, 0x6106, 0x60f6, 0x60f7, 0x6100, 0x60f4, 0x60fa,
    0x6103, 0x6121, 0x60fb, 0x60f1, 0x610d, 0x610e, 0x6147, 0x613e,
    0x6128, 0x6127, 0x614a, 0x613f, 0x613c, 0x612c, 0x6134, 0x613d,
    0x6142, 0x6144, 0x6173, 0x6177, 0x6158, 0x6159, 0x615a, 0x616b,
    0x6174, 0x616f, 0x6165, 0x6171, 0x615f, 0x615d, 0x6153, 0x6175,
    0x6199, 0x6196, 0x6187, 0x61ac, 0x6194, 0x619a, 0x618a, 0x6191,
    0x61ab, 0x61ae, 0x61cc, 0x61ca, 0x61c9, 0x61f7, 0x61c8, 0x61c3,
    0x61c6, 0x61ba, 0x61cb, 0x7f79, 0x61cd, 0x61e6, 0x61e3, 0x61f6,
    0x61fa, 0x61f4, 0x61ff, 0x61fd, 0x61fc, 0x61fe, 0x6200, 0x6208,
    0x6209, 0x620d, 0x620c, 0x6214, 0x621b, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x621e, 0x6221, 0x622a, 0x622e, 0x6230, 0x6232, 0x6233, 0x6241,
    0x624e, 0x625e, 0x6263, 0x625b, 0x6260, 0x6268, 0x627c, 0x6282,
    0x6289, 0x627e, 0x6292, 0x6293, 0x6296, 0x62d4, 0x6283, 0x6294,
    0x62d7, 0x62d1, 0x62bb, 0x62cf, 0x62ff, 0x62c6, 0x64d4, 0x62c8,
    0x62dc, 0x62cc, 0x62ca, 0x62c2, 0x62c7, 0x629b, 0x62c9, 0x630c,
    0x62ee, 0x62f1, 0x6327, 0x6302, 0x6308, 0x62ef, 0x62f5, 0x6350,
    0x633e, 0x634d, 0x641c, 0x634f, 0x6396, 0x638e, 0x6380, 0x63ab,
    0x6376, 0x63a3, 0x638f, 0x6389, 0x639f, 0x63b5, 0x636b, 0xfffd,
    0x6369, 0x63be, 0x63e9, 0x63c0, 0x63c6, 0x63e3, 0x63c9, 0x63d2,
    0x63f6, 0x63c4, 0x6416, 0x6434, 0x6406, 0x6413, 0x6426, 0x6436,
    0x651d, 0x6417, 0x6428, 0x640f, 0x6467, 0x646f, 0x6476, 0x644e,
    0x652a, 0x6495, 0x6493, 0x64a5, 0x64a9, 0x6488, 0x64bc, 0x64da,
    0x64d2, 0x64c5, 0x64c7, 0x64bb, 0x64d8, 0x64c2, 0x64f1, 0x64e7,
    0x8209, 0x64e0, 0x64e1, 0x62ac, 0x64e3, 0x64ef, 0x652c, 0x64f6,
    0x64f4, 0x64f2, 0x64fa, 0x6500, 0x64fd, 0x6518, 0x651c, 0x6505,
    0x6524, 0x6523, 0x652b, 0x6534, 0x6535, 0x6537, 0x6536, 0x6538,
    0x754b, 0x6548, 0x6556, 0x6555, 0x654d, 0x6558, 0x655e, 0x655d,
    0x6572, 0x6578, 0x6582, 0x6583, 0x8b8a, 0x659b, 0x659f, 0x65ab,
    0x65b7, 0x65c3, 0x65c6, 0x65c1, 0x65c4, 0x65cc, 0x65d2, 0x65db,
    0x65d9, 0x65e0, 0x65e1, 0x65f1, 0x6772, 0x660a, 0x6603, 0x65fb,
    0x6773, 0x6635, 0x6636, 0x6634, 0x661c, 0x664f, 0x6644, 0x6649,
    0x6641, 0x665e, 0x665d, 0x6664, 0x6667, 0x6668, 0x665f, 0x6662,
    0x6670, 0x6683, 0x6688, 0x668e, 0x6689, 0x6684, 0x6698, 0x669d,
    0x66c1, 0x66b9, 0x66c9, 0x66be, 0x66bc, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x66c4, 0x66b8, 0x66d6, 0x66da, 0x66e0, 0x663f, 0x66e6, 0x66e9,
    0x66f0, 0x66f5, 0x66f7, 0x670f, 0x6716, 0x671e, 0x6726, 0x6727,
    0x9738, 0x672e, 0x673f, 0x6736, 0x6741, 0x6738, 0x6737, 0x6746,
    0x675e, 0x6760, 0x6759, 0x6763, 0x6764, 0x6789, 0x6770, 0x67a9,
    0x677c, 0x676a, 0x678c, 0x678b, 0x67a6, 0x67a1, 0x6785, 0x67b7,
    0x67ef, 0x67b4, 0x67ec, 0x67b3, 0x67e9, 0x67b8, 0x67e4, 0x67de,
    0x67dd, 0x67e2, 0x67ee, 0x67b9, 0x67ce, 0x67c6, 0x67e7, 0x6a9c,
    0x681e, 0x6846, 0x6829, 0x6840, 0x684d, 0x6832, 0x684e, 0xfffd,
    0x68b3, 0x682b, 0x6859, 0x6863, 0x6877, 0x687f, 0x689f, 0x688f,
    0x68ad, 0x6894, 0x689d, 0x689b, 0x6883, 0x6aae, 0x68b9, 0x6874,
    0x68b5, 0x68a0, 0x68ba, 0x690f, 0x688d, 0x687e, 0x6901, 0x68ca,
    0x6908, 0x68d8, 0x6922, 0x6926, 0x68e1, 0x690c, 0x68cd, 0x68d4,
    0x68e7, 0x68d5, 0x6936, 0x6912, 0x6904, 0x68d7, 0x68e3, 0x6925,
    0x68f9, 0x68e0, 0x68ef, 0x6928, 0x692a, 0x691a, 0x6923, 0x6921,
    0x68c6, 0x6979, 0x6977, 0x695c, 0x6978, 0x696b, 0x6954, 0x697e,
    0x696e, 0x6939, 0x6974, 0x693d, 0x6959, 0x6930, 0x6961, 0x695e,
    0x695d, 0x6981, 0x696a, 0x69b2, 0x69ae, 0x69d0, 0x69bf, 0x69c1,
    0x69d3, 0x69be, 0x69ce, 0x5be8, 0x69ca, 0x69dd, 0x69bb, 0x69c3,
    0x69a7, 0x6a2e, 0x6991, 0x69a0, 0x699c, 0x6995, 0x69b4, 0x69de,
    0x69e8, 0x6a02, 0x6a1b, 0x69ff, 0x6b0a, 0x69f9, 0x69f2, 0x69e7,
    0x6a05, 0x69b1, 0x6a1e, 0x69ed, 0x6a14, 0x69eb, 0x6a0a, 0x6a12,
    0x6ac1, 0x6a23, 0x6a13, 0x6a44, 0x6a0c, 0x6a72, 0x6a36, 0x6a78,
    0x6a47, 0x6a62, 0x6a59, 0x6a66, 0x6a48, 0x6a38, 0x6a22, 0x6a90,
    0x6a8d, 0x6aa0, 0x6a84, 0x6aa2, 0x6aa3, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x6a97, 0x8617, 0x6abb, 0x6ac3, 0x6ac2, 0x6ab8, 0x6ab3, 0x6aac,
    0x6ade, 0x6ad1, 0x6adf, 0x6aaa, 0x6ada, 0x6aea, 0x6afb, 0x6b05,
    0x8616, 0x6afa, 0x6b12, 0x6b16, 0x9b31, 0x6b1f, 0x6b38, 0x6b37,
    0x76dc, 0x6b39, 0x98ee, 0x6b47, 0x6b43, 0x6b49, 0x6b50, 0x6b59,
    0x6b54, 0x6b5b, 0x6b5f, 0x6b61, 0x6b78, 0x6b79, 0x6b7f, 0x6b80,
    0x6b84, 0x6b83, 0x6b8d, 0x6b98, 0x6b95, 0x6b9e, 0x6ba4, 0x6baa,
    0x6bab, 0x6baf, 0x6bb2, 0x6bb1, 0x6bb3, 0x6bb7, 0x6bbc, 0x6bc6,
    0x6bcb, 0x6bd3, 0x6bdf, 0x6bec, 0x6beb, 0x6bf3, 0x6bef, 0xfffd,
    0x9ebe, 0x6c08, 0x6c13, 0x6c14, 0x6c1b, 0x6c24, 0x6c23, 0x6c5e,
    0x6c55, 0x6c62, 0x6c6a, 0x6c82, 0x6c8d, 0x6c9a, 0x6c81, 0x6c9b,
    0x6c7e, 0x6c68, 0x6c73, 0x6c92, 0x6c90, 0x6cc4, 0x6cf1, 0x6cd3,
    0x6cbd, 0x6cd7, 0x6cc5, 0x6cdd, 0x6cae, 0x6cb1, 0x6cbe, 0x6cba,
    0x6cdb, 0x6cef, 0x6cd9, 0x6cea, 0x6d1f, 0x884d, 0x6d36, 0x6d2b,
    0x6d3d, 0x6d38, 0x6d19, 0x6d35, 0x6d33, 0x6d12, 0x6d0c, 0x6d63,
    0x6d93, 0x6d64, 0x6d5a, 0x6d79, 0x6d59, 0x6d8e, 0x6d95, 0x6fe4,
    0x6d85, 0x6df9, 0x6e15, 0x6e0a, 0x6db5, 0x6dc7, 0x6de6, 0x6db8,
    0x6dc6, 0x6dec, 0x6dde, 0x6dcc, 0x6de8, 0x6dd2, 0x6dc5, 0x6dfa,
    0x6dd9, 0x6de4, 0x6dd5, 0x6dea, 0x6dee, 0x6e2d, 0x6e6e, 0x6e2e,
    0x6e19, 0x6e72, 0x6e5f, 0x6e3e, 0x6e23, 0x6e6b, 0x6e2b, 0x6e76,
    0x6e4d, 0x6e1f, 0x6e43, 0x6e3a, 0x6e4e, 0x6e24, 0x6eff, 0x6e1d,
    0x6e38, 0x6e82, 0x6eaa, 0x6e98, 0x6ec9, 0x6eb7, 0x6ed3, 0x6ebd,
    0x6eaf, 0x6ec4, 0x6eb2, 0x6ed4, 0x6ed5, 0x6e8f, 0x6ea5, 0x6ec2,
    0x6e9f, 0x6f41, 0x6f11, 0x704c, 0x6eec, 0x6ef8, 0x6efe, 0x6f3f,
    0x6ef2, 0x6f31, 0x6eef, 0x6f32, 0x6ecc
};

static USHORT				/* Shift-JIS to Unicode */
sju_e040[] = {				/* 0xe040 thru 0xeaa4 */
    0x6f3e, 0x6f13, 0x6ef7, 0x6f86, 0x6f7a, 0x6f78, 0x6f81, 0x6f80,
    0x6f6f, 0x6f5b, 0x6ff3, 0x6f6d, 0x6f82, 0x6f7c, 0x6f58, 0x6f8e,
    0x6f91, 0x6fc2, 0x6f66, 0x6fb3, 0x6fa3, 0x6fa1, 0x6fa4, 0x6fb9,
    0x6fc6, 0x6faa, 0x6fdf, 0x6fd5, 0x6fec, 0x6fd4, 0x6fd8, 0x6ff1,
    0x6fee, 0x6fdb, 0x7009, 0x700b, 0x6ffa, 0x7011, 0x7001, 0x700f,
    0x6ffe, 0x701b, 0x701a, 0x6f74, 0x701d, 0x7018, 0x701f, 0x7030,
    0x703e, 0x7032, 0x7051, 0x7063, 0x7099, 0x7092, 0x70af, 0x70f1,
    0x70ac, 0x70b8, 0x70b3, 0x70ae, 0x70df, 0x70cb, 0x70dd, 0xfffd,
    0x70d9, 0x7109, 0x70fd, 0x711c, 0x7119, 0x7165, 0x7155, 0x7188,
    0x7166, 0x7162, 0x714c, 0x7156, 0x716c, 0x718f, 0x71fb, 0x7184,
    0x7195, 0x71a8, 0x71ac, 0x71d7, 0x71b9, 0x71be, 0x71d2, 0x71c9,
    0x71d4, 0x71ce, 0x71e0, 0x71ec, 0x71e7, 0x71f5, 0x71fc, 0x71f9,
    0x71ff, 0x720d, 0x7210, 0x721b, 0x7228, 0x722d, 0x722c, 0x7230,
    0x7232, 0x723b, 0x723c, 0x723f, 0x7240, 0x7246, 0x724b, 0x7258,
    0x7274, 0x727e, 0x7282, 0x7281, 0x7287, 0x7292, 0x7296, 0x72a2,
    0x72a7, 0x72b9, 0x72b2, 0x72c3, 0x72c6, 0x72c4, 0x72ce, 0x72d2,
    0x72e2, 0x72e0, 0x72e1, 0x72f9, 0x72f7, 0x500f, 0x7317, 0x730a,
    0x731c, 0x7316, 0x731d, 0x7334, 0x732f, 0x7329, 0x7325, 0x733e,
    0x734e, 0x734f, 0x9ed8, 0x7357, 0x736a, 0x7368, 0x7370, 0x7378,
    0x7375, 0x737b, 0x737a, 0x73c8, 0x73b3, 0x73ce, 0x73bb, 0x73c0,
    0x73e5, 0x73ee, 0x73de, 0x74a2, 0x7405, 0x746f, 0x7425, 0x73f8,
    0x7432, 0x743a, 0x7455, 0x743f, 0x745f, 0x7459, 0x7441, 0x745c,
    0x7469, 0x7470, 0x7463, 0x746a, 0x7476, 0x747e, 0x748b, 0x749e,
    0x74a7, 0x74ca, 0x74cf, 0x74d4, 0x73f1, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x74e0, 0x74e3, 0x74e7, 0x74e9, 0x74ee, 0x74f2, 0x74f0, 0x74f1,
    0x74f8, 0x74f7, 0x7504, 0x7503, 0x7505, 0x750c, 0x750e, 0x750d,
    0x7515, 0x7513, 0x751e, 0x7526, 0x752c, 0x753c, 0x7544, 0x754d,
    0x754a, 0x7549, 0x755b, 0x7546, 0x755a, 0x7569, 0x7564, 0x7567,
    0x756b, 0x756d, 0x7578, 0x7576, 0x7586, 0x7587, 0x7574, 0x758a,
    0x7589, 0x7582, 0x7594, 0x759a, 0x759d, 0x75a5, 0x75a3, 0x75c2,
    0x75b3, 0x75c3, 0x75b5, 0x75bd, 0x75b8, 0x75bc, 0x75b1, 0x75cd,
    0x75ca, 0x75d2, 0x75d9, 0x75e3, 0x75de, 0x75fe, 0x75ff, 0xfffd,
    0x75fc, 0x7601, 0x75f0, 0x75fa, 0x75f2, 0x75f3, 0x760b, 0x760d,
    0x7609, 0x761f, 0x7627, 0x7620, 0x7621, 0x7622, 0x7624, 0x7634,
    0x7630, 0x763b, 0x7647, 0x7648, 0x7646, 0x765c, 0x7658, 0x7661,
    0x7662, 0x7668, 0x7669, 0x766a, 0x7667, 0x766c, 0x7670, 0x7672,
    0x7676, 0x7678, 0x767c, 0x7680, 0x7683, 0x7688, 0x768b, 0x768e,
    0x7696, 0x7693, 0x7699, 0x769a, 0x76b0, 0x76b4, 0x76b8, 0x76b9,
    0x76ba, 0x76c2, 0x76cd, 0x76d6, 0x76d2, 0x76de, 0x76e1, 0x76e5,
    0x76e7, 0x76ea, 0x862f, 0x76fb, 0x7708, 0x7707, 0x7704, 0x7729,
    0x7724, 0x771e, 0x7725, 0x7726, 0x771b, 0x7737, 0x7738, 0x7747,
    0x775a, 0x7768, 0x776b, 0x775b, 0x7765, 0x777f, 0x777e, 0x7779,
    0x778e, 0x778b, 0x7791, 0x77a0, 0x779e, 0x77b0, 0x77b6, 0x77b9,
    0x77bf, 0x77bc, 0x77bd, 0x77bb, 0x77c7, 0x77cd, 0x77d7, 0x77da,
    0x77dc, 0x77e3, 0x77ee, 0x77fc, 0x780c, 0x7812, 0x7926, 0x7820,
    0x792a, 0x7845, 0x788e, 0x7874, 0x7886, 0x787c, 0x789a, 0x788c,
    0x78a3, 0x78b5, 0x78aa, 0x78af, 0x78d1, 0x78c6, 0x78cb, 0x78d4,
    0x78be, 0x78bc, 0x78c5, 0x78ca, 0x78ec, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x78e7, 0x78da, 0x78fd, 0x78f4, 0x7907, 0x7912, 0x7911, 0x7919,
    0x792c, 0x792b, 0x7940, 0x7960, 0x7957, 0x795f, 0x795a, 0x7955,
    0x7953, 0x797a, 0x797f, 0x798a, 0x799d, 0x79a7, 0x9f4b, 0x79aa,
    0x79ae, 0x79b3, 0x79b9, 0x79ba, 0x79c9, 0x79d5, 0x79e7, 0x79ec,
    0x79e1, 0x79e3, 0x7a08, 0x7a0d, 0x7a18, 0x7a19, 0x7a20, 0x7a1f,
    0x7980, 0x7a31, 0x7a3b, 0x7a3e, 0x7a37, 0x7a43, 0x7a57, 0x7a49,
    0x7a61, 0x7a62, 0x7a69, 0x9f9d, 0x7a70, 0x7a79, 0x7a7d, 0x7a88,
    0x7a97, 0x7a95, 0x7a98, 0x7a96, 0x7aa9, 0x7ac8, 0x7ab0, 0xfffd,
    0x7ab6, 0x7ac5, 0x7ac4, 0x7abf, 0x9083, 0x7ac7, 0x7aca, 0x7acd,
    0x7acf, 0x7ad5, 0x7ad3, 0x7ad9, 0x7ada, 0x7add, 0x7ae1, 0x7ae2,
    0x7ae6, 0x7aed, 0x7af0, 0x7b02, 0x7b0f, 0x7b0a, 0x7b06, 0x7b33,
    0x7b18, 0x7b19, 0x7b1e, 0x7b35, 0x7b28, 0x7b36, 0x7b50, 0x7b7a,
    0x7b04, 0x7b4d, 0x7b0b, 0x7b4c, 0x7b45, 0x7b75, 0x7b65, 0x7b74,
    0x7b67, 0x7b70, 0x7b71, 0x7b6c, 0x7b6e, 0x7b9d, 0x7b98, 0x7b9f,
    0x7b8d, 0x7b9c, 0x7b9a, 0x7b8b, 0x7b92, 0x7b8f, 0x7b5d, 0x7b99,
    0x7bcb, 0x7bc1, 0x7bcc, 0x7bcf, 0x7bb4, 0x7bc6, 0x7bdd, 0x7be9,
    0x7c11, 0x7c14, 0x7be6, 0x7be5, 0x7c60, 0x7c00, 0x7c07, 0x7c13,
    0x7bf3, 0x7bf7, 0x7c17, 0x7c0d, 0x7bf6, 0x7c23, 0x7c27, 0x7c2a,
    0x7c1f, 0x7c37, 0x7c2b, 0x7c3d, 0x7c4c, 0x7c43, 0x7c54, 0x7c4f,
    0x7c40, 0x7c50, 0x7c58, 0x7c5f, 0x7c64, 0x7c56, 0x7c65, 0x7c6c,
    0x7c75, 0x7c83, 0x7c90, 0x7ca4, 0x7cad, 0x7ca2, 0x7cab, 0x7ca1,
    0x7ca8, 0x7cb3, 0x7cb2, 0x7cb1, 0x7cae, 0x7cb9, 0x7cbd, 0x7cc0,
    0x7cc5, 0x7cc2, 0x7cd8, 0x7cd2, 0x7cdc, 0x7ce2, 0x9b3b, 0x7cef,
    0x7cf2, 0x7cf4, 0x7cf6, 0x7cfa, 0x7d06, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x7d02, 0x7d1c, 0x7d15, 0x7d0a, 0x7d45, 0x7d4b, 0x7d2e, 0x7d32,
    0x7d3f, 0x7d35, 0x7d46, 0x7d73, 0x7d56, 0x7d4e, 0x7d72, 0x7d68,
    0x7d6e, 0x7d4f, 0x7d63, 0x7d93, 0x7d89, 0x7d5b, 0x7d8f, 0x7d7d,
    0x7d9b, 0x7dba, 0x7dae, 0x7da3, 0x7db5, 0x7dc7, 0x7dbd, 0x7dab,
    0x7e3d, 0x7da2, 0x7daf, 0x7ddc, 0x7db8, 0x7d9f, 0x7db0, 0x7dd8,
    0x7ddd, 0x7de4, 0x7dde, 0x7dfb, 0x7df2, 0x7de1, 0x7e05, 0x7e0a,
    0x7e23, 0x7e21, 0x7e12, 0x7e31, 0x7e1f, 0x7e09, 0x7e0b, 0x7e22,
    0x7e46, 0x7e66, 0x7e3b, 0x7e35, 0x7e39, 0x7e43, 0x7e37, 0xfffd,
    0x7e32, 0x7e3a, 0x7e67, 0x7e5d, 0x7e56, 0x7e5e, 0x7e59, 0x7e5a,
    0x7e79, 0x7e6a, 0x7e69, 0x7e7c, 0x7e7b, 0x7e83, 0x7dd5, 0x7e7d,
    0x8fae, 0x7e7f, 0x7e88, 0x7e89, 0x7e8c, 0x7e92, 0x7e90, 0x7e93,
    0x7e94, 0x7e96, 0x7e8e, 0x7e9b, 0x7e9c, 0x7f38, 0x7f3a, 0x7f45,
    0x7f4c, 0x7f4d, 0x7f4e, 0x7f50, 0x7f51, 0x7f55, 0x7f54, 0x7f58,
    0x7f5f, 0x7f60, 0x7f68, 0x7f69, 0x7f67, 0x7f78, 0x7f82, 0x7f86,
    0x7f83, 0x7f88, 0x7f87, 0x7f8c, 0x7f94, 0x7f9e, 0x7f9d, 0x7f9a,
    0x7fa3, 0x7faf, 0x7fb2, 0x7fb9, 0x7fae, 0x7fb6, 0x7fb8, 0x8b71,
    0x7fc5, 0x7fc6, 0x7fca, 0x7fd5, 0x7fd4, 0x7fe1, 0x7fe6, 0x7fe9,
    0x7ff3, 0x7ff9, 0x98dc, 0x8006, 0x8004, 0x800b, 0x8012, 0x8018,
    0x8019, 0x801c, 0x8021, 0x8028, 0x803f, 0x803b, 0x804a, 0x8046,
    0x8052, 0x8058, 0x805a, 0x805f, 0x8062, 0x8068, 0x8073, 0x8072,
    0x8070, 0x8076, 0x8079, 0x807d, 0x807f, 0x8084, 0x8086, 0x8085,
    0x809b, 0x8093, 0x809a, 0x80ad, 0x5190, 0x80ac, 0x80db, 0x80e5,
    0x80d9, 0x80dd, 0x80c4, 0x80da, 0x80d6, 0x8109, 0x80ef, 0x80f1,
    0x811b, 0x8129, 0x8123, 0x812f, 0x814b, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x968b, 0x8146, 0x813e, 0x8153, 0x8151, 0x80fc, 0x8171, 0x816e,
    0x8165, 0x8166, 0x8174, 0x8183, 0x8188, 0x818a, 0x8180, 0x8182,
    0x81a0, 0x8195, 0x81a4, 0x81a3, 0x815f, 0x8193, 0x81a9, 0x81b0,
    0x81b5, 0x81be, 0x81b8, 0x81bd, 0x81c0, 0x81c2, 0x81ba, 0x81c9,
    0x81cd, 0x81d1, 0x81d9, 0x81d8, 0x81c8, 0x81da, 0x81df, 0x81e0,
    0x81e7, 0x81fa, 0x81fb, 0x81fe, 0x8201, 0x8202, 0x8205, 0x8207,
    0x820a, 0x820d, 0x8210, 0x8216, 0x8229, 0x822b, 0x8238, 0x8233,
    0x8240, 0x8259, 0x8258, 0x825d, 0x825a, 0x825f, 0x8264, 0xfffd,
    0x8262, 0x8268, 0x826a, 0x826b, 0x822e, 0x8271, 0x8277, 0x8278,
    0x827e, 0x828d, 0x8292, 0x82ab, 0x829f, 0x82bb, 0x82ac, 0x82e1,
    0x82e3, 0x82df, 0x82d2, 0x82f4, 0x82f3, 0x82fa, 0x8393, 0x8303,
    0x82fb, 0x82f9, 0x82de, 0x8306, 0x82dc, 0x8309, 0x82d9, 0x8335,
    0x8334, 0x8316, 0x8332, 0x8331, 0x8340, 0x8339, 0x8350, 0x8345,
    0x832f, 0x832b, 0x8317, 0x8318, 0x8385, 0x839a, 0x83aa, 0x839f,
    0x83a2, 0x8396, 0x8323, 0x838e, 0x8387, 0x838a, 0x837c, 0x83b5,
    0x8373, 0x8375, 0x83a0, 0x8389, 0x83a8, 0x83f4, 0x8413, 0x83eb,
    0x83ce, 0x83fd, 0x8403, 0x83d8, 0x840b, 0x83c1, 0x83f7, 0x8407,
    0x83e0, 0x83f2, 0x840d, 0x8422, 0x8420, 0x83bd, 0x8438, 0x8506,
    0x83fb, 0x846d, 0x842a, 0x843c, 0x855a, 0x8484, 0x8477, 0x846b,
    0x84ad, 0x846e, 0x8482, 0x8469, 0x8446, 0x842c, 0x846f, 0x8479,
    0x8435, 0x84ca, 0x8462, 0x84b9, 0x84bf, 0x849f, 0x84d9, 0x84cd,
    0x84bb, 0x84da, 0x84d0, 0x84c1, 0x84c6, 0x84d6, 0x84a1, 0x8521,
    0x84ff, 0x84f4, 0x8517, 0x8518, 0x852c, 0x851f, 0x8515, 0x8514,
    0x84fc, 0x8540, 0x8563, 0x8558, 0x8548, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8541, 0x8602, 0x854b, 0x8555, 0x8580, 0x85a4, 0x8588, 0x8591,
    0x858a, 0x85a8, 0x856d, 0x8594, 0x859b, 0x85ea, 0x8587, 0x859c,
    0x8577, 0x857e, 0x8590, 0x85c9, 0x85ba, 0x85cf, 0x85b9, 0x85d0,
    0x85d5, 0x85dd, 0x85e5, 0x85dc, 0x85f9, 0x860a, 0x8613, 0x860b,
    0x85fe, 0x85fa, 0x8606, 0x8622, 0x861a, 0x8630, 0x863f, 0x864d,
    0x4e55, 0x8654, 0x865f, 0x8667, 0x8671, 0x8693, 0x86a3, 0x86a9,
    0x86aa, 0x868b, 0x868c, 0x86b6, 0x86af, 0x86c4, 0x86c6, 0x86b0,
    0x86c9, 0x8823, 0x86ab, 0x86d4, 0x86de, 0x86e9, 0x86ec, 0xfffd,
    0x86df, 0x86db, 0x86ef, 0x8712, 0x8706, 0x8708, 0x8700, 0x8703,
    0x86fb, 0x8711, 0x8709, 0x870d, 0x86f9, 0x870a, 0x8734, 0x873f,
    0x8737, 0x873b, 0x8725, 0x8729, 0x871a, 0x8760, 0x875f, 0x8778,
    0x874c, 0x874e, 0x8774, 0x8757, 0x8768, 0x876e, 0x8759, 0x8753,
    0x8763, 0x876a, 0x8805, 0x87a2, 0x879f, 0x8782, 0x87af, 0x87cb,
    0x87bd, 0x87c0, 0x87d0, 0x96d6, 0x87ab, 0x87c4, 0x87b3, 0x87c7,
    0x87c6, 0x87bb, 0x87ef, 0x87f2, 0x87e0, 0x880f, 0x880d, 0x87fe,
    0x87f6, 0x87f7, 0x880e, 0x87d2, 0x8811, 0x8816, 0x8815, 0x8822,
    0x8821, 0x8831, 0x8836, 0x8839, 0x8827, 0x883b, 0x8844, 0x8842,
    0x8852, 0x8859, 0x885e, 0x8862, 0x886b, 0x8881, 0x887e, 0x889e,
    0x8875, 0x887d, 0x88b5, 0x8872, 0x8882, 0x8897, 0x8892, 0x88ae,
    0x8899, 0x88a2, 0x888d, 0x88a4, 0x88b0, 0x88bf, 0x88b1, 0x88c3,
    0x88c4, 0x88d4, 0x88d8, 0x88d9, 0x88dd, 0x88f9, 0x8902, 0x88fc,
    0x88f4, 0x88e8, 0x88f2, 0x8904, 0x890c, 0x890a, 0x8913, 0x8943,
    0x891e, 0x8925, 0x892a, 0x892b, 0x8941, 0x8944, 0x893b, 0x8936,
    0x8938, 0x894c, 0x891d, 0x8960, 0x895e, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8966, 0x8964, 0x896d, 0x896a, 0x896f, 0x8974, 0x8977, 0x897e,
    0x8983, 0x8988, 0x898a, 0x8993, 0x8998, 0x89a1, 0x89a9, 0x89a6,
    0x89ac, 0x89af, 0x89b2, 0x89ba, 0x89bd, 0x89bf, 0x89c0, 0x89da,
    0x89dc, 0x89dd, 0x89e7, 0x89f4, 0x89f8, 0x8a03, 0x8a16, 0x8a10,
    0x8a0c, 0x8a1b, 0x8a1d, 0x8a25, 0x8a36, 0x8a41, 0x8a5b, 0x8a52,
    0x8a46, 0x8a48, 0x8a7c, 0x8a6d, 0x8a6c, 0x8a62, 0x8a85, 0x8a82,
    0x8a84, 0x8aa8, 0x8aa1, 0x8a91, 0x8aa5, 0x8aa6, 0x8a9a, 0x8aa3,
    0x8ac4, 0x8acd, 0x8ac2, 0x8ada, 0x8aeb, 0x8af3, 0x8ae7, 0xfffd,
    0x8ae4, 0x8af1, 0x8b14, 0x8ae0, 0x8ae2, 0x8af7, 0x8ade, 0x8adb,
    0x8b0c, 0x8b07, 0x8b1a, 0x8ae1, 0x8b16, 0x8b10, 0x8b17, 0x8b20,
    0x8b33, 0x97ab, 0x8b26, 0x8b2b, 0x8b3e, 0x8b28, 0x8b41, 0x8b4c,
    0x8b4f, 0x8b4e, 0x8b49, 0x8b56, 0x8b5b, 0x8b5a, 0x8b6b, 0x8b5f,
    0x8b6c, 0x8b6f, 0x8b74, 0x8b7d, 0x8b80, 0x8b8c, 0x8b8e, 0x8b92,
    0x8b93, 0x8b96, 0x8b99, 0x8b9a, 0x8c3a, 0x8c41, 0x8c3f, 0x8c48,
    0x8c4c, 0x8c4e, 0x8c50, 0x8c55, 0x8c62, 0x8c6c, 0x8c78, 0x8c7a,
    0x8c82, 0x8c89, 0x8c85, 0x8c8a, 0x8c8d, 0x8c8e, 0x8c94, 0x8c7c,
    0x8c98, 0x621d, 0x8cad, 0x8caa, 0x8cbd, 0x8cb2, 0x8cb3, 0x8cae,
    0x8cb6, 0x8cc8, 0x8cc1, 0x8ce4, 0x8ce3, 0x8cda, 0x8cfd, 0x8cfa,
    0x8cfb, 0x8d04, 0x8d05, 0x8d0a, 0x8d07, 0x8d0f, 0x8d0d, 0x8d10,
    0x9f4e, 0x8d13, 0x8ccd, 0x8d14, 0x8d16, 0x8d67, 0x8d6d, 0x8d71,
    0x8d73, 0x8d81, 0x8d99, 0x8dc2, 0x8dbe, 0x8dba, 0x8dcf, 0x8dda,
    0x8dd6, 0x8dcc, 0x8ddb, 0x8dcb, 0x8dea, 0x8deb, 0x8ddf, 0x8de3,
    0x8dfc, 0x8e08, 0x8e09, 0x8dff, 0x8e1d, 0x8e1e, 0x8e10, 0x8e1f,
    0x8e42, 0x8e35, 0x8e30, 0x8e34, 0x8e4a, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8e47, 0x8e49, 0x8e4c, 0x8e50, 0x8e48, 0x8e59, 0x8e64, 0x8e60,
    0x8e2a, 0x8e63, 0x8e55, 0x8e76, 0x8e72, 0x8e7c, 0x8e81, 0x8e87,
    0x8e85, 0x8e84, 0x8e8b, 0x8e8a, 0x8e93, 0x8e91, 0x8e94, 0x8e99,
    0x8eaa, 0x8ea1, 0x8eac, 0x8eb0, 0x8ec6, 0x8eb1, 0x8ebe, 0x8ec5,
    0x8ec8, 0x8ecb, 0x8edb, 0x8ee3, 0x8efc, 0x8efb, 0x8eeb, 0x8efe,
    0x8f0a, 0x8f05, 0x8f15, 0x8f12, 0x8f19, 0x8f13, 0x8f1c, 0x8f1f,
    0x8f1b, 0x8f0c, 0x8f26, 0x8f33, 0x8f3b, 0x8f39, 0x8f45, 0x8f42,
    0x8f3e, 0x8f4c, 0x8f49, 0x8f46, 0x8f4e, 0x8f57, 0x8f5c, 0xfffd,
    0x8f62, 0x8f63, 0x8f64, 0x8f9c, 0x8f9f, 0x8fa3, 0x8fad, 0x8faf,
    0x8fb7, 0x8fda, 0x8fe5, 0x8fe2, 0x8fea, 0x8fef, 0x9087, 0x8ff4,
    0x9005, 0x8ff9, 0x8ffa, 0x9011, 0x9015, 0x9021, 0x900d, 0x901e,
    0x9016, 0x900b, 0x9027, 0x9036, 0x9035, 0x9039, 0x8ff8, 0x904f,
    0x9050, 0x9051, 0x9052, 0x900e, 0x9049, 0x903e, 0x9056, 0x9058,
    0x905e, 0x9068, 0x906f, 0x9076, 0x96a8, 0x9072, 0x9082, 0x907d,
    0x9081, 0x9080, 0x908a, 0x9089, 0x908f, 0x90a8, 0x90af, 0x90b1,
    0x90b5, 0x90e2, 0x90e4, 0x6248, 0x90db, 0x9102, 0x9112, 0x9119,
    0x9132, 0x9130, 0x914a, 0x9156, 0x9158, 0x9163, 0x9165, 0x9169,
    0x9173, 0x9172, 0x918b, 0x9189, 0x9182, 0x91a2, 0x91ab, 0x91af,
    0x91aa, 0x91b5, 0x91b4, 0x91ba, 0x91c0, 0x91c1, 0x91c9, 0x91cb,
    0x91d0, 0x91d6, 0x91df, 0x91e1, 0x91db, 0x91fc, 0x91f5, 0x91f6,
    0x921e, 0x91ff, 0x9214, 0x922c, 0x9215, 0x9211, 0x925e, 0x9257,
    0x9245, 0x9249, 0x9264, 0x9248, 0x9295, 0x923f, 0x924b, 0x9250,
    0x929c, 0x9296, 0x9293, 0x929b, 0x925a, 0x92cf, 0x92b9, 0x92b7,
    0x92e9, 0x930f, 0x92fa, 0x9344, 0x932e, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9319, 0x9322, 0x931a, 0x9323, 0x933a, 0x9335, 0x933b, 0x935c,
    0x9360, 0x937c, 0x936e, 0x9356, 0x93b0, 0x93ac, 0x93ad, 0x9394,
    0x93b9, 0x93d6, 0x93d7, 0x93e8, 0x93e5, 0x93d8, 0x93c3, 0x93dd,
    0x93d0, 0x93c8, 0x93e4, 0x941a, 0x9414, 0x9413, 0x9403, 0x9407,
    0x9410, 0x9436, 0x942b, 0x9435, 0x9421, 0x943a, 0x9441, 0x9452,
    0x9444, 0x945b, 0x9460, 0x9462, 0x945e, 0x946a, 0x9229, 0x9470,
    0x9475, 0x9477, 0x947d, 0x945a, 0x947c, 0x947e, 0x9481, 0x947f,
    0x9582, 0x9587, 0x958a, 0x9594, 0x9596, 0x9598, 0x9599, 0xfffd,
    0x95a0, 0x95a8, 0x95a7, 0x95ad, 0x95bc, 0x95bb, 0x95b9, 0x95be,
    0x95ca, 0x6ff6, 0x95c3, 0x95cd, 0x95cc, 0x95d5, 0x95d4, 0x95d6,
    0x95dc, 0x95e1, 0x95e5, 0x95e2, 0x9621, 0x9628, 0x962e, 0x962f,
    0x9642, 0x964c, 0x964f, 0x964b, 0x9677, 0x965c, 0x965e, 0x965d,
    0x965f, 0x9666, 0x9672, 0x966c, 0x968d, 0x9698, 0x9695, 0x9697,
    0x96aa, 0x96a7, 0x96b1, 0x96b2, 0x96b0, 0x96b4, 0x96b6, 0x96b8,
    0x96b9, 0x96ce, 0x96cb, 0x96c9, 0x96cd, 0x894d, 0x96dc, 0x970d,
    0x96d5, 0x96f9, 0x9704, 0x9706, 0x9708, 0x9713, 0x970e, 0x9711,
    0x970f, 0x9716, 0x9719, 0x9724, 0x972a, 0x9730, 0x9739, 0x973d,
    0x973e, 0x9744, 0x9746, 0x9748, 0x9742, 0x9749, 0x975c, 0x9760,
    0x9764, 0x9766, 0x9768, 0x52d2, 0x976b, 0x9771, 0x9779, 0x9785,
    0x977c, 0x9781, 0x977a, 0x9786, 0x978b, 0x978f, 0x9790, 0x979c,
    0x97a8, 0x97a6, 0x97a3, 0x97b3, 0x97b4, 0x97c3, 0x97c6, 0x97c8,
    0x97cb, 0x97dc, 0x97ed, 0x9f4f, 0x97f2, 0x7adf, 0x97f6, 0x97f5,
    0x980f, 0x980c, 0x9838, 0x9824, 0x9821, 0x9837, 0x983d, 0x9846,
    0x984f, 0x984b, 0x986b, 0x986f, 0x9870, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9871, 0x9874, 0x9873, 0x98aa, 0x98af, 0x98b1, 0x98b6, 0x98c4,
    0x98c3, 0x98c6, 0x98e9, 0x98eb, 0x9903, 0x9909, 0x9912, 0x9914,
    0x9918, 0x9921, 0x991d, 0x991e, 0x9924, 0x9920, 0x992c, 0x992e,
    0x993d, 0x993e, 0x9942, 0x9949, 0x9945, 0x9950, 0x994b, 0x9951,
    0x9952, 0x994c, 0x9955, 0x9997, 0x9998, 0x99a5, 0x99ad, 0x99ae,
    0x99bc, 0x99df, 0x99db, 0x99dd, 0x99d8, 0x99d1, 0x99ed, 0x99ee,
    0x99f1, 0x99f2, 0x99fb, 0x99f8, 0x9a01, 0x9a0f, 0x9a05, 0x99e2,
    0x9a19, 0x9a2b, 0x9a37, 0x9a45, 0x9a42, 0x9a40, 0x9a43, 0xfffd,
    0x9a3e, 0x9a55, 0x9a4d, 0x9a5b, 0x9a57, 0x9a5f, 0x9a62, 0x9a65,
    0x9a64, 0x9a69, 0x9a6b, 0x9a6a, 0x9aad, 0x9ab0, 0x9abc, 0x9ac0,
    0x9acf, 0x9ad1, 0x9ad3, 0x9ad4, 0x9ade, 0x9adf, 0x9ae2, 0x9ae3,
    0x9ae6, 0x9aef, 0x9aeb, 0x9aee, 0x9af4, 0x9af1, 0x9af7, 0x9afb,
    0x9b06, 0x9b18, 0x9b1a, 0x9b1f, 0x9b22, 0x9b23, 0x9b25, 0x9b27,
    0x9b28, 0x9b29, 0x9b2a, 0x9b2e, 0x9b2f, 0x9b32, 0x9b44, 0x9b43,
    0x9b4f, 0x9b4d, 0x9b4e, 0x9b51, 0x9b58, 0x9b74, 0x9b93, 0x9b83,
    0x9b91, 0x9b96, 0x9b97, 0x9b9f, 0x9ba0, 0x9ba8, 0x9bb4, 0x9bc0,
    0x9bca, 0x9bb9, 0x9bc6, 0x9bcf, 0x9bd1, 0x9bd2, 0x9be3, 0x9be2,
    0x9be4, 0x9bd4, 0x9be1, 0x9c3a, 0x9bf2, 0x9bf1, 0x9bf0, 0x9c15,
    0x9c14, 0x9c09, 0x9c13, 0x9c0c, 0x9c06, 0x9c08, 0x9c12, 0x9c0a,
    0x9c04, 0x9c2e, 0x9c1b, 0x9c25, 0x9c24, 0x9c21, 0x9c30, 0x9c47,
    0x9c32, 0x9c46, 0x9c3e, 0x9c5a, 0x9c60, 0x9c67, 0x9c76, 0x9c78,
    0x9ce7, 0x9cec, 0x9cf0, 0x9d09, 0x9d08, 0x9ceb, 0x9d03, 0x9d06,
    0x9d2a, 0x9d26, 0x9daf, 0x9d23, 0x9d1f, 0x9d44, 0x9d15, 0x9d12,
    0x9d41, 0x9d3f, 0x9d3e, 0x9d46, 0x9d48, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9d5d, 0x9d5e, 0x9d64, 0x9d51, 0x9d50, 0x9d59, 0x9d72, 0x9d89,
    0x9d87, 0x9dab, 0x9d6f, 0x9d7a, 0x9d9a, 0x9da4, 0x9da9, 0x9db2,
    0x9dc4, 0x9dc1, 0x9dbb, 0x9db8, 0x9dba, 0x9dc6, 0x9dcf, 0x9dc2,
    0x9dd9, 0x9dd3, 0x9df8, 0x9de6, 0x9ded, 0x9def, 0x9dfd, 0x9e1a,
    0x9e1b, 0x9e1e, 0x9e75, 0x9e79, 0x9e7d, 0x9e81, 0x9e88, 0x9e8b,
    0x9e8c, 0x9e92, 0x9e95, 0x9e91, 0x9e9d, 0x9ea5, 0x9ea9, 0x9eb8,
    0x9eaa, 0x9ead, 0x9761, 0x9ecc, 0x9ece, 0x9ecf, 0x9ed0, 0x9ed4,
    0x9edc, 0x9ede, 0x9edd, 0x9ee0, 0x9ee5, 0x9ee8, 0x9eef, 0xfffd,
    0x9ef4, 0x9ef6, 0x9ef7, 0x9ef9, 0x9efb, 0x9efc, 0x9efd, 0x9f07,
    0x9f08, 0x76b7, 0x9f15, 0x9f21, 0x9f2c, 0x9f3e, 0x9f4a, 0x9f52,
    0x9f54, 0x9f63, 0x9f5f, 0x9f60, 0x9f61, 0x9f66, 0x9f67, 0x9f6c,
    0x9f6a, 0x9f77, 0x9f72, 0x9f76, 0x9f95, 0x9f9c, 0x9fa0, 0x582f,
    0x69c7, 0x9059, 0x7464, 0x51dc, 0x7199
};

/* Unicode-to-Kanji tables... */

static USHORT				/* Unicode to Shift-JIS */
usj_0391[] = {				/* 0x0391 thru 0x039c */
    0x839f, 0x83a0, 0x83a1, 0x83a2, 0x83a3, 0x83a4, 0x83a5, 0x83a6,
    0x83a7, 0x83a8, 0x83a9, 0x83aa, 0x83ab, 0x83ac, 0x83ad, 0x83ae,
    0x83af, 0xfffd, 0x83b0, 0x83b1, 0x83b2, 0x83b3, 0x83b4, 0x83b5,
    0x83b6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x83bf, 0x83c0, 0x83c1, 0x83c2, 0x83c3, 0x83c4, 0x83c5, 0x83c6,
    0x83c7, 0x83c8, 0x83c9, 0x83ca, 0x83cb, 0x83cc, 0x83cd, 0x83ce,
    0x83cf, 0xfffd, 0x83d0, 0x83d1, 0x83d2, 0x83d3, 0x83d4, 0x83d5, 0x83d6
};

static USHORT				/* Unicode to Shift-JIS */
usj_0401[] = {				/* 0x0401 thru 0x0451 */
    0x8446, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8440,
    0x8441, 0x8442, 0x8443, 0x8444, 0x8445, 0x8447, 0x8448, 0x8449,
    0x844a, 0x844b, 0x844c, 0x844d, 0x844e, 0x844f, 0x8450, 0x8451,
    0x8452, 0x8453, 0x8454, 0x8455, 0x8456, 0x8457, 0x8458, 0x8459,
    0x845a, 0x845b, 0x845c, 0x845d, 0x845e, 0x845f, 0x8460, 0x8470,
    0x8471, 0x8472, 0x8473, 0x8474, 0x8475, 0x8477, 0x8478, 0x8479,
    0x847a, 0x847b, 0x847c, 0x847d, 0x847e, 0x8480, 0x8481, 0x8482,
    0x8483, 0x8484, 0x8485, 0x8486, 0x8487, 0x8488, 0x8489, 0x848a,
    0x848b, 0x848c, 0x848d, 0x848e, 0x848f, 0x8490, 0x8491, 0xfffd, 0x8476
};

static USHORT				/* Unicode to Shift-JIS */
usj_3000[] = {				/* 0x3000 thru 0x30ff */
    0x8140, 0x8141, 0x8142, 0x8156, 0xfffd, 0x8158, 0x8159, 0x815a,
    0x8171, 0x8172, 0x8173, 0x8174, 0x8175, 0x8176, 0x8177, 0x8178,
    0x8179, 0x817a, 0x81a7, 0x81ac, 0x816b, 0x816c, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8160, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x829f, 0x82a0, 0x82a1, 0x82a2, 0x82a3, 0x82a4, 0x82a5,
    0x82a6, 0x82a7, 0x82a8, 0x82a9, 0x82aa, 0x82ab, 0x82ac, 0x82ad,
    0x82ae, 0x82af, 0x82b0, 0x82b1, 0x82b2, 0x82b3, 0x82b4, 0x82b5,
    0x82b6, 0x82b7, 0x82b8, 0x82b9, 0x82ba, 0x82bb, 0x82bc, 0x82bd,
    0x82be, 0x82bf, 0x82c0, 0x82c1, 0x82c2, 0x82c3, 0x82c4, 0x82c5,
    0x82c6, 0x82c7, 0x82c8, 0x82c9, 0x82ca, 0x82cb, 0x82cc, 0x82cd,
    0x82ce, 0x82cf, 0x82d0, 0x82d1, 0x82d2, 0x82d3, 0x82d4, 0x82d5,
    0x82d6, 0x82d7, 0x82d8, 0x82d9, 0x82da, 0x82db, 0x82dc, 0x82dd,
    0x82de, 0x82df, 0x82e0, 0x82e1, 0x82e2, 0x82e3, 0x82e4, 0x82e5,
    0x82e6, 0x82e7, 0x82e8, 0x82e9, 0x82ea, 0x82eb, 0x82ec, 0x82ed,
    0x82ee, 0x82ef, 0x82f0, 0x82f1, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x814a, 0x814b, 0x8154, 0x8155, 0xfffd,
    0xfffd, 0x8340, 0x8341, 0x8342, 0x8343, 0x8344, 0x8345, 0x8346,
    0x8347, 0x8348, 0x8349, 0x834a, 0x834b, 0x834c, 0x834d, 0x834e,
    0x834f, 0x8350, 0x8351, 0x8352, 0x8353, 0x8354, 0x8355, 0x8356,
    0x8357, 0x8358, 0x8359, 0x835a, 0x835b, 0x835c, 0x835d, 0x835e,
    0x835f, 0x8360, 0x8361, 0x8362, 0x8363, 0x8364, 0x8365, 0x8366,
    0x8367, 0x8368, 0x8369, 0x836a, 0x836b, 0x836c, 0x836d, 0x836e,
    0x836f, 0x8370, 0x8371, 0x8372, 0x8373, 0x8374, 0x8375, 0x8376,
    0x8377, 0x8378, 0x8379, 0x837a, 0x837b, 0x837c, 0x837d, 0x837e,
    0x8380, 0x8381, 0x8382, 0x8383, 0x8384, 0x8385, 0x8386, 0x8387,
    0x8388, 0x8389, 0x838a, 0x838b, 0x838c, 0x838d, 0x838e, 0x838f,
    0x8390, 0x8391, 0x8392, 0x8393, 0x8394, 0x8395, 0x8396, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8145, 0x815b, 0x8152, 0x8153, 0xfffd
};

static USHORT				/* Unicode to Shift-JIS */
usj_ff00[] = {				/* 0xff00 thru 0x0ff9f */
    0xfffd, 0x8149, 0xfffd, 0x8194, 0x8190, 0x8193, 0x8195, 0xfffd,
    0x8169, 0x816a, 0x8196, 0x817b, 0x8143, 0xfffd, 0x8144, 0x815e,
    0x824f, 0x8250, 0x8251, 0x8252, 0x8253, 0x8254, 0x8255, 0x8256,
    0x8257, 0x8258, 0x8146, 0x8147, 0x8183, 0x8181, 0x8184, 0x8148,
    0x8197, 0x8260, 0x8261, 0x8262, 0x8263, 0x8264, 0x8265, 0x8266,
    0x8267, 0x8268, 0x8269, 0x826a, 0x826b, 0x826c, 0x826d, 0x826e,
    0x826f, 0x8270, 0x8271, 0x8272, 0x8273, 0x8274, 0x8275, 0x8276,
    0x8277, 0x8278, 0x8279, 0x816d, 0xfffd, 0x816e, 0x814f, 0x8151,
    0x814d, 0x8281, 0x8282, 0x8283, 0x8284, 0x8285, 0x8286, 0x8287,
    0x8288, 0x8289, 0x828a, 0x828b, 0x828c, 0x828d, 0x828e, 0x828f,
    0x8290, 0x8291, 0x8292, 0x8293, 0x8294, 0x8295, 0x8296, 0x8297,
    0x8298, 0x8299, 0x829a, 0x816f, 0x8162, 0x8170, 0xfffd, 0xfffd,
    0xfffd, 0x00a1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7,
    0x00a8, 0x00a9, 0x00aa, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af,
    0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7,
    0x00b8, 0x00b9, 0x00ba, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf,
    0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x00c7,
    0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf,
    0x00d0, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d7,
    0x00d8, 0x00d9, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00df
};

/* Now one humongous table for Kanji */

static USHORT				/* Unicode to Shift-JIS */
usj_4e00[] = {				/* 0x4e00 thru 0x9fa0 */
    0x88ea, 0x929a, 0xfffd, 0x8eb5, 0xfffd, 0xfffd, 0xfffd, 0x969c,
    0x8fe4, 0x8e4f, 0x8fe3, 0x89ba, 0xfffd, 0x9573, 0x975e, 0xfffd,
    0x98a0, 0x894e, 0xfffd, 0xfffd, 0x8a8e, 0x98a1, 0x90a2, 0x99c0,
    0x8b75, 0x95b8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8fe5, 0xfffd,
    0xfffd, 0x97bc, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x95c0, 0xfffd,
    0xfffd, 0xfffd, 0x98a2, 0xfffd, 0xfffd, 0x9286, 0xfffd, 0xfffd,
    0xfffd, 0x98a3, 0x8bf8, 0xfffd, 0xfffd, 0xfffd, 0x98a4, 0xfffd,
    0x8adb, 0x924f, 0xfffd, 0x8ee5, 0x98a5, 0xfffd, 0xfffd, 0x98a6,
    0xfffd, 0xfffd, 0x98a7, 0x9454, 0xfffd, 0x8b76, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9456, 0xfffd, 0x93e1, 0x8cc1, 0x9652,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe568, 0x98a8, 0x8fe6,
    0x98a9, 0x89b3, 0xfffd, 0xfffd, 0xfffd, 0x8be3, 0x8cee, 0x96e7,
    0xfffd, 0xfffd, 0x9ba4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9790, 0xfffd, 0x93fb, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8aa3, 0xfffd,
    0x8b54, 0xfffd, 0x98aa, 0xfffd, 0xfffd, 0x98ab, 0x97b9, 0xfffd,
    0x975c, 0x9188, 0x98ad, 0x8e96, 0x93f1, 0xfffd, 0x98b0, 0xfffd,
    0xfffd, 0x895d, 0x8cdd, 0xfffd, 0x8cdc, 0x88e4, 0xfffd, 0xfffd,
    0x986a, 0x9869, 0xfffd, 0x8db1, 0x889f, 0xfffd, 0x98b1, 0x98b2,
    0x98b3, 0x9653, 0x98b4, 0xfffd, 0x8cf0, 0x88e5, 0x9692, 0xfffd,
    0x8b9c, 0xfffd, 0xfffd, 0x8b9d, 0x8b9e, 0x92e0, 0x97ba, 0xfffd,
    0x98b5, 0xfffd, 0xfffd, 0x98b6, 0xfffd, 0xfffd, 0x98b7, 0xfffd,
    0xfffd, 0xfffd, 0x906c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8f59, 0x906d, 0x98bc, 0xfffd, 0x98ba, 0xfffd, 0x98bb, 0x8b77,
    0xfffd, 0xfffd, 0x8da1, 0x89ee, 0xfffd, 0x98b9, 0x98b8, 0x95a7,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8e65, 0x8e64, 0x91bc, 0x98bd,
    0x9574, 0x90e5, 0xfffd, 0xfffd, 0xfffd, 0x8157, 0x98be, 0x98c0,
    0xfffd, 0xfffd, 0xfffd, 0x91e3, 0x97df, 0x88c8, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x98bf, 0x89bc, 0xfffd,
    0x8bc2, 0xfffd, 0x9287, 0xfffd, 0xfffd, 0xfffd, 0x8c8f, 0x98c1,
    0xfffd, 0xfffd, 0xfffd, 0x9443, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8ae9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x98c2, 0x88c9, 0xfffd, 0xfffd, 0x8cde, 0x8aea, 0x959a,
    0x94b0, 0x8b78, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x89ef, 0xfffd, 0x98e5, 0x9360, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x948c,
    0x98c4, 0xfffd, 0xfffd, 0xfffd, 0x94ba, 0xfffd, 0x97e0, 0xfffd,
    0x904c, 0xfffd, 0x8e66, 0xfffd, 0x8e97, 0x89be, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x92cf, 0xfffd, 0xfffd, 0x9241, 0x98c8,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x88ca, 0x92e1, 0x8f5a,
    0x8db2, 0x9743, 0xfffd, 0x91cc, 0xfffd, 0x89bd, 0xfffd, 0x98c7,
    0xfffd, 0x975d, 0x98c3, 0x98c5, 0x8dec, 0x98c6, 0x9b43, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x98ce, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x98d1,
    0x98cf, 0xfffd, 0xfffd, 0x89c0, 0xfffd, 0x95b9, 0x98c9, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x98cd, 0x8cf1, 0xfffd, 0xfffd, 0x8e67,
    0xfffd, 0xfffd, 0xfffd, 0x8aa4, 0xfffd, 0xfffd, 0x98d2, 0xfffd,
    0x98ca, 0xfffd, 0xfffd, 0x97e1, 0xfffd, 0x8e98, 0xfffd, 0x98cb,
    0xfffd, 0x98d0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x98d3, 0xfffd,
    0x98cc, 0xfffd, 0xfffd, 0x8b9f, 0xfffd, 0x88cb, 0xfffd, 0xfffd,
    0x8ba0, 0x89bf, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9b44, 0xfffd, 0x9699, 0x958e, 0x8cf2,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x904e, 0x97b5, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x95d6,
    0xfffd, 0xfffd, 0x8c57, 0x91a3, 0x89e2, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8f72, 0xfffd, 0xfffd, 0xfffd, 0x98d7, 0xfffd,
    0x98dc, 0x98da, 0xfffd, 0xfffd, 0x98d5, 0xfffd, 0xfffd, 0x91ad,
    0x98d8, 0xfffd, 0x98db, 0x98d9, 0xfffd, 0x95db, 0xfffd, 0x98d6,
    0xfffd, 0x904d, 0xfffd, 0x9693, 0x98dd, 0x98de, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f43, 0x98eb,
    0xfffd, 0xfffd, 0xfffd, 0x946f, 0xfffd, 0x9555, 0x98e6, 0xfffd,
    0x95ee, 0xfffd, 0x89b4, 0xfffd, 0xfffd, 0xfffd, 0x98ea, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x98e4, 0x98ed, 0xfffd,
    0xfffd, 0x9171, 0xfffd, 0x8cc2, 0xfffd, 0x947b, 0xfffd, 0xe0c5,
    0xfffd, 0x98ec, 0x937c, 0xfffd, 0x98e1, 0xfffd, 0x8cf4, 0xfffd,
    0xfffd, 0x8cf3, 0x98df, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8ed8,
    0xfffd, 0x98e7, 0xfffd, 0x95ed, 0x926c, 0x98e3, 0x8c91, 0xfffd,
    0x98e0, 0x98e8, 0x98e2, 0x97cf, 0x98e9, 0x9860, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8be4, 0xfffd,
    0xfffd, 0x8c90, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x98ee, 0xfffd, 0xfffd, 0xfffd, 0x98ef,
    0x98f3, 0x88cc, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x95ce,
    0x98f2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x98f1, 0x98f5, 0xfffd,
    0xfffd, 0xfffd, 0x98f4, 0xfffd, 0x92e2, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8c92, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x98f6, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8ec3, 0xfffd, 0x91a4, 0x92e3, 0x8bf4, 0xfffd,
    0x98f7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8b55, 0xfffd, 0xfffd,
    0x98f8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x98fa, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9654, 0xfffd, 0xfffd,
    0xfffd, 0x8c86, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8e50, 0x94f5, 0x98f9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8dc3, 0x9762, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x98fc, 0x9942, 0x98fb, 0x8dc2, 0xfffd, 0x8f9d,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8c58, 0xfffd,
    0xfffd, 0xfffd, 0x9943, 0xfffd, 0xfffd, 0x8bcd, 0xfffd, 0xfffd,
    0xfffd, 0x9940, 0x9941, 0xfffd, 0xfffd, 0x93ad, 0xfffd, 0x919c,
    0xfffd, 0x8ba1, 0xfffd, 0xfffd, 0xfffd, 0x966c, 0x9944, 0xfffd,
    0xfffd, 0xfffd, 0x97bb, 0xfffd, 0xfffd, 0xfffd, 0x9945, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9948, 0xfffd, 0x9946, 0xfffd, 0x916d,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9947, 0x9949, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x994b, 0xfffd, 0xfffd,
    0xfffd, 0x994a, 0xfffd, 0x95c6, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8b56, 0x994d, 0x994e, 0xfffd, 0x89ad, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x994c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8ef2, 0xfffd, 0x9951, 0x9950, 0x994f, 0xfffd,
    0x98d4, 0xfffd, 0x9952, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f9e,
    0xfffd, 0x9953, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9744, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x96d7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9955,
    0xfffd, 0xfffd, 0x9954, 0x9957, 0x9956, 0xfffd, 0xfffd, 0x9958,
    0x9959, 0x88f2, 0xfffd, 0x8cb3, 0x8c5a, 0x8f5b, 0x929b, 0x8ba2,
    0x90e6, 0x8cf5, 0xfffd, 0x8d8e, 0x995b, 0x96c6, 0x9365, 0xfffd,
    0x8e99, 0xfffd, 0x995a, 0xfffd, 0x995c, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x937d, 0xfffd, 0x8a95, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x995d, 0xfffd, 0xfffd, 0x93fc, 0xfffd, 0xfffd,
    0x9153, 0x995f, 0x9960, 0x94aa, 0x8cf6, 0x985a, 0x9961, 0xfffd,
    0xfffd, 0x8ba4, 0xfffd, 0xfffd, 0xfffd, 0x95ba, 0x91b4, 0x8bef,
    0x9354, 0xfffd, 0xfffd, 0xfffd, 0x8c93, 0xfffd, 0xfffd, 0xfffd,
    0x9962, 0xfffd, 0x9963, 0xfffd, 0xfffd, 0x93e0, 0x897e, 0xfffd,
    0xfffd, 0x9966, 0x8dfb, 0xfffd, 0x9965, 0x8dc4, 0xfffd, 0x9967,
    0xe3ec, 0x9968, 0x9660, 0x9969, 0xfffd, 0x996a, 0x996b, 0x8fe7,
    0xfffd, 0x8eca, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8aa5, 0xfffd, 0x996e, 0xfffd, 0x996c, 0x96bb, 0x996d, 0xfffd,
    0x9579, 0x996f, 0x9970, 0x9971, 0x937e, 0xfffd, 0xfffd, 0xfffd,
    0x9975, 0x9973, 0x9974, 0x9972, 0x8de1, 0x9976, 0x96e8, 0x97e2,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9977, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x90a6, 0x9978, 0x8f79, 0xfffd,
    0xfffd, 0x9979, 0xfffd, 0x929c, 0x97bd, 0x9380, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x99c3, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x997a, 0xeaa3, 0x8bc3, 0xfffd, 0xfffd,
    0x997b, 0x967d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f88, 0x91fa,
    0xfffd, 0x997d, 0x93e2, 0xfffd, 0xfffd, 0x997e, 0xfffd, 0xfffd,
    0x9980, 0x8a4d, 0xfffd, 0xfffd, 0xfffd, 0x9981, 0x8ba5, 0xfffd,
    0x93ca, 0x899a, 0x8f6f, 0xfffd, 0xfffd, 0x949f, 0x9982, 0xfffd,
    0x9381, 0xfffd, 0xfffd, 0x906e, 0x9983, 0xfffd, 0x95aa, 0x90d8,
    0x8aa0, 0xfffd, 0x8aa7, 0x9984, 0xfffd, 0xfffd, 0x9986, 0xfffd,
    0xfffd, 0x8c59, 0xfffd, 0xfffd, 0x9985, 0xfffd, 0xfffd, 0x97f1,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f89, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x94bb, 0x95ca, 0xfffd, 0x9987,
    0xfffd, 0x9798, 0x9988, 0xfffd, 0xfffd, 0xfffd, 0x9989, 0xfffd,
    0x939e, 0xfffd, 0xfffd, 0x998a, 0xfffd, 0xfffd, 0x90a7, 0x8dfc,
    0x8c94, 0x998b, 0x8e68, 0x8d8f, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x92e4, 0x998d, 0xfffd, 0xfffd, 0x91a5,
    0xfffd, 0xfffd, 0x8ded, 0x998e, 0x998f, 0x914f, 0xfffd, 0x998c,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9991, 0xfffd, 0x9655, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8d84, 0xfffd, 0xfffd, 0x9990, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8c95, 0x8ddc, 0x948d, 0xfffd, 0xfffd,
    0xfffd, 0x9994, 0x9992, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x959b,
    0x8fe8, 0x999b, 0x8a84, 0x9995, 0x9993, 0x916e, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9997, 0xfffd, 0x9996,
    0xfffd, 0xfffd, 0xfffd, 0x8a63, 0xfffd, 0xfffd, 0xfffd, 0x8c80,
    0x999c, 0x97ab, 0xfffd, 0xfffd, 0xfffd, 0x9998, 0xfffd, 0xfffd,
    0xfffd, 0x999d, 0x999a, 0xfffd, 0x9999, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x97cd, 0xfffd, 0xfffd, 0xfffd, 0x8cf7,
    0x89c1, 0xfffd, 0xfffd, 0x97f2, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8f95, 0x9377, 0x8d85, 0x99a0, 0x99a1, 0xfffd, 0xfffd,
    0xfffd, 0x97e3, 0xfffd, 0xfffd, 0x984a, 0x99a3, 0xfffd, 0xfffd,
    0xfffd, 0x8cf8, 0xfffd, 0xfffd, 0x99a2, 0xfffd, 0x8a4e, 0xfffd,
    0xfffd, 0x99a4, 0xfffd, 0x9675, 0xfffd, 0x92ba, 0xfffd, 0x9745,
    0xfffd, 0x95d7, 0xfffd, 0xfffd, 0xfffd, 0x99a5, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe8d3, 0xfffd, 0xfffd, 0x93ae, 0xfffd, 0x99a6,
    0x8aa8, 0x96b1, 0xfffd, 0xfffd, 0xfffd, 0x8f9f, 0x99a7, 0x95e5,
    0x99ab, 0xfffd, 0x90a8, 0x99a8, 0x8bce, 0xfffd, 0x99a9, 0x8aa9,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8c4d, 0x99ac, 0xfffd, 0x99ad, 0xfffd, 0xfffd,
    0x99ae, 0x99af, 0x8ed9, 0xfffd, 0xfffd, 0xfffd, 0x8cf9, 0x96dc,
    0xfffd, 0x96e6, 0x93f5, 0xfffd, 0xfffd, 0x95ef, 0x99b0, 0xfffd,
    0x99b1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x99b3, 0xfffd, 0x99b5,
    0x99b4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x99b6, 0x89bb, 0x966b,
    0xfffd, 0x8dfa, 0x99b7, 0xfffd, 0xfffd, 0x9178, 0xfffd, 0xfffd,
    0x8fa0, 0x8ba7, 0xfffd, 0x99b8, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x94d9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x99b9,
    0xfffd, 0x99ba, 0xfffd, 0x99bb, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x99bc, 0x9543, 0x8be6, 0x88e3, 0xfffd, 0xfffd, 0xfffd, 0x93bd,
    0x99bd, 0x8f5c, 0xfffd, 0x90e7, 0xfffd, 0x99bf, 0x99be, 0x8fa1,
    0x8cdf, 0x99c1, 0x94bc, 0xfffd, 0xfffd, 0x99c2, 0xfffd, 0xfffd,
    0xfffd, 0x94da, 0x91b2, 0x91ec, 0x8ba6, 0xfffd, 0xfffd, 0x93ec,
    0x9250, 0xfffd, 0x948e, 0xfffd, 0x966d, 0xfffd, 0x99c4, 0xfffd,
    0x90e8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8c54, 0xfffd,
    0xfffd, 0x99c5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x99c6, 0x894b,
    0x88f3, 0x8aeb, 0xfffd, 0x91a6, 0x8b70, 0x9791, 0xfffd, 0x99c9,
    0x89b5, 0xfffd, 0xfffd, 0x99c8, 0xfffd, 0xfffd, 0xfffd, 0x8ba8,
    0xfffd, 0xfffd, 0x99ca, 0xfffd, 0x96ef, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x99cb, 0xfffd,
    0x97d0, 0xfffd, 0x8cfa, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8cb4,
    0x99cc, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x99ce, 0x99cd, 0xfffd,
    0x907e, 0x8958, 0xfffd, 0xfffd, 0xfffd, 0x897d, 0x99cf, 0xfffd,
    0x99d0, 0xfffd, 0xfffd, 0x8cb5, 0xfffd, 0xfffd, 0x99d1, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8b8e, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8e51, 0x99d2, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9694, 0x8db3, 0x8b79, 0x9746, 0x916f, 0x94bd, 0x8efb, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f66, 0xfffd, 0x8ee6, 0x8ef3,
    0xfffd, 0x8f96, 0xfffd, 0x94be, 0xfffd, 0xfffd, 0xfffd, 0x99d5,
    0xfffd, 0x8962, 0x9170, 0x8cfb, 0x8cc3, 0x8be5, 0xfffd, 0xfffd,
    0x99d9, 0x9240, 0x91fc, 0x8ba9, 0x8fa2, 0x99da, 0x99d8, 0x89c2,
    0x91e4, 0x8eb6, 0x8e6a, 0x8945, 0xfffd, 0xfffd, 0x8a90, 0x8d86,
    0x8e69, 0xfffd, 0x99db, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x99dc, 0xfffd, 0x8b68, 0x8a65, 0xfffd, 0xfffd, 0xfffd,
    0x8d87, 0x8b67, 0x92dd, 0x8944, 0x93af, 0x96bc, 0x8d40, 0x9799,
    0x9366, 0x8cfc, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8c4e, 0xfffd, 0x99e5, 0xfffd, 0x8be1,
    0x9669, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x94db, 0xfffd,
    0xfffd, 0x99e4, 0xfffd, 0x8adc, 0x99df, 0x99e0, 0x99e2, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x99e3, 0xfffd,
    0x8b7a, 0x9081, 0xfffd, 0x95ab, 0x99e1, 0x99dd, 0x8ce1, 0xfffd,
    0x99de, 0xfffd, 0x9843, 0xfffd, 0xfffd, 0xfffd, 0x95f0, 0xfffd,
    0x92e6, 0x8ce0, 0x8d90, 0xfffd, 0xfffd, 0xfffd, 0x99e6, 0xfffd,
    0xfffd, 0x93db, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x99ea,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8efc, 0xfffd, 0x8ef4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x99ed, 0x99eb, 0xfffd, 0x96a1, 0xfffd, 0x99e8, 0x99f1, 0x99ec,
    0xfffd, 0xfffd, 0xfffd, 0x99ef, 0x8cc4, 0x96bd, 0xfffd, 0xfffd,
    0x99f0, 0xfffd, 0xfffd, 0xfffd, 0x99f2, 0xfffd, 0x99f4, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8dee, 0x9861, 0xfffd, 0x99e9, 0x99e7,
    0x99f3, 0xfffd, 0x99ee, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x99f6, 0xfffd, 0x9a42, 0x99f8, 0xfffd, 0xfffd,
    0x99fc, 0xfffd, 0xfffd, 0x9a40, 0x99f9, 0xfffd, 0xfffd, 0x9a5d,
    0xfffd, 0xfffd, 0x8de7, 0x8a50, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x99f7, 0xfffd, 0xfffd, 0xfffd, 0x9a44, 0x88f4, 0x9a43, 0xfffd,
    0x88a3, 0x9569, 0x9a41, 0xfffd, 0x99fa, 0xfffd, 0xfffd, 0x99f5,
    0x99fb, 0x8dc6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9a45, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x88f5, 0x9a4e, 0xfffd, 0xfffd, 0x9a46, 0x9a47, 0xfffd,
    0x8fa3, 0x9689, 0xfffd, 0xfffd, 0xfffd, 0x9a4c, 0x9a4b, 0xfffd,
    0xfffd, 0xfffd, 0x934e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9a4d, 0xfffd, 0xfffd, 0x9a4a, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8953, 0xfffd, 0x8db4, 0x904f,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a48,
    0x9382, 0xfffd, 0xfffd, 0xfffd, 0x9a49, 0xfffd, 0x88a0, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a53, 0x9742,
    0xfffd, 0x8fa5, 0xfffd, 0x9a59, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9a58, 0x9a4f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x91c1, 0xfffd,
    0x9a50, 0xfffd, 0xfffd, 0xfffd, 0x91ed, 0x9a55, 0x8fa4, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a52, 0xfffd, 0xfffd, 0x96e2,
    0xfffd, 0xfffd, 0xfffd, 0x8c5b, 0xfffd, 0xfffd, 0x9a56, 0x9a57,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a54, 0x9a5a, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9a51, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9a60, 0x9a65, 0xfffd, 0x9a61, 0xfffd,
    0x9a5c, 0xfffd, 0xfffd, 0x9a66, 0x9150, 0xfffd, 0xfffd, 0x9a68,
    0xfffd, 0x8d41, 0x9a5e, 0x929d, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9a62, 0x9a5b, 0x8aab, 0xfffd, 0x8aec, 0x8a85, 0x9a63, 0x9a5f,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8c96,
    0x9a69, 0x9a67, 0x9172, 0x8b69, 0x8baa, 0xfffd, 0x9a64, 0xfffd,
    0x8bf2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8963, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a6d, 0x9a6b, 0xfffd, 0x9aa5,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a70, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9a6a, 0xfffd, 0x9a6e, 0xfffd, 0xfffd, 0x9a6c,
    0xfffd, 0xfffd, 0xfffd, 0x8e6b, 0x9a6f, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a72,
    0xfffd, 0x9a77, 0xfffd, 0xfffd, 0xfffd, 0x9a75, 0x9a74, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9251, 0xfffd,
    0xfffd, 0x89c3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a71, 0xfffd, 0x9a73, 0x8fa6,
    0x8952, 0xfffd, 0xfffd, 0x9a76, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x89dc, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a82,
    0xfffd, 0x8ffa, 0x9a7d, 0xfffd, 0x9a7b, 0xfffd, 0x9a7c, 0xfffd,
    0x9a7e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x895c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9158, 0xfffd, 0x9a78, 0xfffd,
    0x9a79, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8a9a, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a81, 0xfffd, 0xfffd, 0xfffd,
    0x8aed, 0xfffd, 0x9a84, 0x9a80, 0x9a83, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x95ac, 0xfffd, 0xfffd, 0xfffd,
    0x93d3, 0xfffd, 0x94b6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9a86, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a85, 0x8a64,
    0xfffd, 0xfffd, 0x9a87, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a8a,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a89, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9a88, 0xfffd, 0x9458, 0xfffd, 0xfffd, 0x9a8b, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a8c, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a8e, 0xfffd, 0x9a8d, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a90, 0xfffd, 0xfffd, 0xfffd,
    0x9a93, 0x9a91, 0x9a8f, 0x9a92, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9a94, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a95, 0xfffd,
    0xfffd, 0x9a96, 0xfffd, 0x9a97, 0xfffd, 0xfffd, 0xfffd, 0x9a98,
    0x9964, 0xfffd, 0x8efa, 0x8e6c, 0xfffd, 0xfffd, 0x89f1, 0xfffd,
    0x88f6, 0xfffd, 0xfffd, 0x9263, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a99, 0xfffd,
    0x8da2, 0xfffd, 0x88cd, 0x907d, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9a9a, 0x8cc5, 0xfffd, 0xfffd, 0x8d91, 0xfffd, 0x9a9c,
    0x9a9b, 0xfffd, 0xfffd, 0x95de, 0x9a9d, 0xfffd, 0xfffd, 0xfffd,
    0x9a9f, 0x9a9e, 0xfffd, 0x9aa0, 0xfffd, 0x9aa1, 0xfffd, 0x8c97,
    0xfffd, 0xfffd, 0x8980, 0x9aa2, 0xfffd, 0xfffd, 0x9aa4, 0xfffd,
    0x9aa3, 0xfffd, 0xfffd, 0xfffd, 0x9aa6, 0xfffd, 0xfffd, 0x9379,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9aa7, 0x88b3,
    0x8ddd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8c5c, 0xfffd, 0xfffd,
    0x926e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9aa8,
    0x9aa9, 0xfffd, 0xfffd, 0x9aab, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9aac, 0xfffd, 0x8de2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8bcf,
    0xfffd, 0xfffd, 0x9656, 0xfffd, 0xfffd, 0xfffd, 0x9aaa, 0x9aad,
    0x8dbf, 0x8d42, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9ab1, 0xfffd, 0xfffd, 0x8da3, 0xfffd, 0x9252, 0xfffd,
    0xfffd, 0x9aae, 0x92d8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9ab2,
    0xfffd, 0xfffd, 0x9082, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9ab0, 0x9ab3, 0xfffd, 0x8c5e, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9ab4, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9ab5, 0xfffd, 0x8d43, 0x8a5f, 0x9ab7, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9ab8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9ab9, 0xfffd, 0xfffd, 0x9ab6, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9aaf, 0xfffd, 0xfffd, 0x9aba, 0xfffd, 0xfffd, 0x9abb, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9684, 0xfffd, 0xfffd, 0x8fe9, 0xfffd,
    0xfffd, 0xfffd, 0x9abd, 0x9abe, 0x9abc, 0xfffd, 0x9ac0, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9457, 0xfffd, 0xfffd, 0x88e6,
    0x9575, 0xfffd, 0xfffd, 0x9ac1, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8ffb, 0xfffd, 0xfffd, 0x8eb7,
    0xfffd, 0x947c, 0x8aee, 0xfffd, 0x8de9, 0xfffd, 0xfffd, 0xfffd,
    0x9678, 0xfffd, 0x93b0, 0xfffd, 0xfffd, 0x8c98, 0x91cd, 0xfffd,
    0xfffd, 0xfffd, 0x9abf, 0x9ac2, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x91c2, 0xfffd, 0xfffd,
    0xfffd, 0x9ac3, 0xfffd, 0xfffd, 0xfffd, 0x9ac4, 0xfffd, 0xfffd,
    0xfffd, 0x9ac6, 0xfffd, 0xfffd, 0x92e7, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8aac, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea9f,
    0x8981, 0x95f1, 0xfffd, 0xfffd, 0x8fea, 0x9367, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8de4, 0xfffd, 0xfffd, 0x9acc, 0xfffd, 0xfffd,
    0x95bb, 0x97db, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x89f2, 0x9ac8, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9159, 0x9acb, 0xfffd, 0x9383, 0xfffd, 0xfffd, 0x9368,
    0x9384, 0x94b7, 0x92cb, 0xfffd, 0xfffd, 0xfffd, 0x8dc7, 0xfffd,
    0xfffd, 0xfffd, 0x9ac7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8996, 0xfffd, 0x9355, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9ac9, 0xfffd, 0x9ac5, 0xfffd, 0xfffd, 0x906f, 0xfffd, 0xfffd,
    0xfffd, 0x9acd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f6d, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8bab, 0xfffd, 0x9ace, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x95e6, 0xfffd, 0xfffd, 0xfffd, 0x919d,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x92c4, 0xfffd, 0xfffd, 0x9ad0,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x966e, 0xfffd, 0xfffd, 0x9ad1, 0xfffd, 0xfffd, 0x9ad6, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x95ad, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9ad5, 0x9acf, 0x9ad2, 0x9ad4, 0xfffd, 0xfffd, 0x8da4, 0xfffd,
    0xfffd, 0x95c7, 0xfffd, 0xfffd, 0xfffd, 0x9ad7, 0xfffd, 0x9264,
    0xfffd, 0xfffd, 0x89f3, 0xfffd, 0x8feb, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9ad9, 0xfffd, 0x9ad8, 0xfffd, 0x8d88, 0xfffd, 0x9ada,
    0x9adc, 0x9adb, 0xfffd, 0xfffd, 0x9ade, 0xfffd, 0x9ad3, 0x9ae0,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9adf, 0x9add, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8e6d, 0x9070, 0xfffd, 0x9173, 0x9ae1,
    0x90ba, 0x88eb, 0x9484, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x92d9,
    0xfffd, 0x9ae3, 0x9ae2, 0x9ae4, 0x9ae5, 0x9ae6, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9ae7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x95cf, 0x9ae8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x89c4,
    0x9ae9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x975b, 0x8a4f, 0xfffd,
    0x99c7, 0x8f67, 0x91bd, 0x9aea, 0x96e9, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x96b2, 0xfffd, 0xfffd, 0x9aec, 0xfffd, 0x91e5,
    0xfffd, 0x9356, 0x91be, 0x9576, 0x9aed, 0x9aee, 0x899b, 0xfffd,
    0xfffd, 0x8eb8, 0x9aef, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x88ce,
    0x9af0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9af1, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8982, 0xfffd, 0xfffd, 0x8aef,
    0x93de, 0x95f2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9af5, 0x9174,
    0x9af4, 0x8c5f, 0xfffd, 0xfffd, 0x967a, 0x9af3, 0xfffd, 0x9385,
    0x9af7, 0xfffd, 0x9af6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9af9, 0xfffd, 0x9af8, 0xfffd, 0xfffd, 0x899c, 0xfffd, 0x9afa,
    0x8fa7, 0x9afc, 0x9244, 0xfffd, 0x9afb, 0xfffd, 0x95b1, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8f97, 0x937a, 0xfffd, 0xfffd, 0xfffd,
    0x9b40, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8d44, 0xfffd, 0xfffd,
    0xfffd, 0x9b41, 0x9440, 0x94dc, 0x96cf, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9444, 0xfffd, 0xfffd, 0x9b4a, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8b57, 0xfffd, 0xfffd, 0x9764, 0xfffd,
    0xfffd, 0x96ad, 0xfffd, 0x9baa, 0xfffd, 0x9b42, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9b45, 0xfffd, 0x91c3, 0xfffd, 0xfffd,
    0x9657, 0xfffd, 0xfffd, 0xfffd, 0x9369, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9b46, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9685, 0xfffd, 0x8dc8, 0xfffd, 0xfffd, 0x8fa8, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9b47, 0xfffd,
    0xfffd, 0x8e6f, 0xfffd, 0x8e6e, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x88b7, 0x8cc6, 0xfffd, 0x90a9, 0x88cf, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9b4b, 0x9b4c, 0xfffd, 0x9b49, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8957, 0x8aad, 0xfffd,
    0x9b48, 0xfffd, 0x96c3, 0x9550, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x88a6, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x88f7, 0xfffd, 0xfffd, 0xfffd, 0x8e70,
    0xfffd, 0x88d0, 0xfffd, 0x88a1, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9b51, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9b4f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x96ba, 0xfffd, 0x9b52, 0xfffd, 0x9b50, 0xfffd, 0xfffd, 0x9b4e,
    0x9050, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9b4d, 0xfffd, 0xfffd,
    0xfffd, 0x95d8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8ce2,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9b56, 0x9b57, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8fa9, 0xfffd, 0xfffd, 0xfffd,
    0x9b53, 0x984b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x946b, 0xfffd,
    0xfffd, 0x9b55, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8da5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9b58, 0xfffd, 0xfffd, 0xfffd, 0x9577, 0xfffd,
    0xfffd, 0xfffd, 0x9b59, 0xfffd, 0x9b54, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x96b9,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x947d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9b5a, 0x9551, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9b5b, 0x9b5f, 0x9b5c, 0xfffd,
    0xfffd, 0x89c5, 0x9b5e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8eb9, 0xfffd, 0x9b5d, 0x8c99, 0xfffd, 0xfffd, 0xfffd,
    0x9b6b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9b64, 0x9b61,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9284, 0xfffd, 0x9b60, 0xfffd, 0xfffd, 0x9b62, 0xfffd,
    0xfffd, 0x9b63, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9b65, 0x9b66, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8af0, 0xfffd, 0x9b68, 0x9b67, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9b69, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8fec, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9b6c, 0xfffd, 0x92da, 0xfffd, 0xfffd, 0xfffd,
    0x8964, 0xfffd, 0x9b6a, 0xfffd, 0xfffd, 0xfffd, 0x9b6d, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9b6e, 0xfffd,
    0x9b71, 0xfffd, 0xfffd, 0x9b6f, 0xfffd, 0x9b70, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8e71, 0x9b72, 0xfffd, 0xfffd, 0x8d45, 0x9b73, 0xfffd, 0x8e9a,
    0x91b6, 0xfffd, 0x9b74, 0x9b75, 0x8e79, 0x8d46, 0xfffd, 0x96d0,
    0xfffd, 0xfffd, 0xfffd, 0x8b47, 0x8cc7, 0x9b76, 0x8a77, 0xfffd,
    0xfffd, 0x9b77, 0xfffd, 0x91b7, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9b78, 0x9ba1, 0xfffd, 0x9b79, 0xfffd, 0x9b7a, 0xfffd, 0xfffd,
    0x9b7b, 0xfffd, 0x9b7d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9b7e, 0xfffd, 0xfffd, 0x9b80, 0xfffd, 0x91ee, 0xfffd, 0x8946,
    0x8ee7, 0x88c0, 0xfffd, 0x9176, 0x8aae, 0x8eb3, 0xfffd, 0x8d47,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9386, 0xfffd, 0x8f40,
    0x8aaf, 0x9288, 0x92e8, 0x88b6, 0x8b58, 0x95f3, 0xfffd, 0x8ec0,
    0xfffd, 0xfffd, 0x8b71, 0x90e9, 0x8eba, 0x9747, 0x9b81, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8b7b, 0xfffd,
    0x8dc9, 0xfffd, 0xfffd, 0x8a51, 0x8983, 0x8faa, 0x89c6, 0xfffd,
    0x9b82, 0x9765, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f68,
    0xfffd, 0xfffd, 0x8ee2, 0x9b83, 0x8af1, 0x93d0, 0x96a7, 0x9b84,
    0xfffd, 0x9b85, 0xfffd, 0xfffd, 0x9578, 0xfffd, 0xfffd, 0xfffd,
    0x9b87, 0xfffd, 0x8aa6, 0x8bf5, 0x9b86, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8ab0, 0xfffd, 0x9051, 0x9b8b, 0x8e40,
    0xfffd, 0x89c7, 0x9b8a, 0xfffd, 0x9b88, 0x9b8c, 0x9b89, 0x944a,
    0x9ecb, 0x9052, 0xfffd, 0x9b8d, 0xfffd, 0xfffd, 0x97be, 0xfffd,
    0x9b8e, 0xfffd, 0xfffd, 0x9b90, 0xfffd, 0x929e, 0x9b8f, 0xfffd,
    0x90a1, 0xfffd, 0x8e9b, 0xfffd, 0xfffd, 0xfffd, 0x91ce, 0x8ef5,
    0xfffd, 0x9595, 0x90ea, 0xfffd, 0x8ecb, 0x9b91, 0x8fab, 0x9b92,
    0x9b93, 0x88d1, 0x91b8, 0x9071, 0xfffd, 0x9b94, 0x93b1, 0x8fac,
    0xfffd, 0x8fad, 0xfffd, 0x9b95, 0xfffd, 0xfffd, 0x90eb, 0xfffd,
    0xfffd, 0xfffd, 0x8fae, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9b96, 0xfffd, 0x9b97, 0xfffd, 0x96de, 0xfffd, 0xfffd, 0xfffd,
    0x9b98, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8bc4, 0xfffd, 0xfffd,
    0xfffd, 0x8f41, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9b99, 0x9b9a, 0x8eda, 0x904b, 0x93f2, 0x9073, 0x94f6, 0x9441,
    0x8bc7, 0x9b9b, 0xfffd, 0xfffd, 0xfffd, 0x8b8f, 0x9b9c, 0xfffd,
    0x8bfc, 0xfffd, 0x93cd, 0x89ae, 0xfffd, 0x8e72, 0x9b9d, 0x9ba0,
    0x9b9f, 0x8bfb, 0xfffd, 0x9b9e, 0xfffd, 0x9357, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x91ae, 0xfffd,
    0x936a, 0x8ec6, 0xfffd, 0xfffd, 0x9177, 0x979a, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9ba2, 0xfffd, 0x9ba3, 0x93d4,
    0xfffd, 0x8e52, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9ba5, 0xfffd,
    0xfffd, 0x9ba6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9ba7, 0xfffd, 0xfffd, 0xfffd,
    0x8af2, 0x9ba8, 0xfffd, 0xfffd, 0x9ba9, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x89aa, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x915a, 0x8ae2, 0xfffd, 0x9bab, 0x96a6, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x91d0, 0xfffd, 0x8a78, 0xfffd, 0xfffd, 0x9bad, 0x9baf,
    0x8add, 0xfffd, 0xfffd, 0x9bac, 0x9bae, 0xfffd, 0x9bb1, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9bb0, 0xfffd, 0x9bb2,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9bb3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x93bb, 0x8bac, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x89e3, 0x9bb4, 0x9bb9, 0xfffd, 0xfffd, 0x9bb7, 0xfffd, 0x95f5,
    0x95f4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9387, 0xfffd,
    0xfffd, 0xfffd, 0x9bb6, 0x8f73, 0xfffd, 0x9bb5, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9092,
    0xfffd, 0xfffd, 0xfffd, 0x9bba, 0xfffd, 0xfffd, 0x8de8, 0xfffd,
    0xfffd, 0x9bc0, 0xfffd, 0xfffd, 0x9bc1, 0x9bbb, 0x8a52, 0x9bbc,
    0x9bc5, 0x9bc4, 0x9bc3, 0x9bbf, 0xfffd, 0xfffd, 0xfffd, 0x9bbe,
    0xfffd, 0xfffd, 0x9bc2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x95f6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9bc9, 0x9bc6, 0xfffd, 0x9bc8, 0xfffd,
    0x9792, 0xfffd, 0x9bc7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9bbd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9093, 0xfffd, 0xfffd, 0x9bca, 0xfffd, 0xfffd, 0x8db5,
    0xfffd, 0xfffd, 0xfffd, 0x9bcb, 0xfffd, 0xfffd, 0x9bcc, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9bcf, 0xfffd, 0x9bce, 0xfffd, 0xfffd, 0x9bcd,
    0xfffd, 0xfffd, 0xfffd, 0x9388, 0x9bb8, 0xfffd, 0xfffd, 0xfffd,
    0x9bd5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9bd1, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9bd0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9bd2, 0xfffd, 0x9bd3, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9bd6,
    0xfffd, 0xfffd, 0x97e4, 0xfffd, 0x9bd7, 0x9bd4, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9bd8, 0xfffd, 0xfffd, 0x8ade, 0x9bd9, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9bdb, 0x9bda, 0xfffd, 0xfffd, 0x9bdc, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9bdd, 0xfffd, 0x90ec, 0x8f42, 0xfffd,
    0xfffd, 0x8f84, 0xfffd, 0x9183, 0xfffd, 0x8d48, 0x8db6, 0x8d49,
    0x8b90, 0xfffd, 0xfffd, 0x9bde, 0xfffd, 0xfffd, 0x8db7, 0xfffd,
    0xfffd, 0x8cc8, 0x9bdf, 0x96a4, 0x9462, 0x9be0, 0xfffd, 0x8d4a,
    0xfffd, 0xfffd, 0xfffd, 0x8aaa, 0xfffd, 0x9246, 0x8bd0, 0xfffd,
    0xfffd, 0xfffd, 0x8e73, 0x957a, 0xfffd, 0xfffd, 0x94bf, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9be1, 0x8af3, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9be4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x929f, 0xfffd,
    0xfffd, 0x9be3, 0x9be2, 0x9be5, 0xfffd, 0x92e9, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9083, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8e74, 0xfffd, 0x90c8, 0xfffd, 0x91d1,
    0x8b41, 0xfffd, 0xfffd, 0x92a0, 0xfffd, 0xfffd, 0x9be6, 0x9be7,
    0x8fed, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9658, 0xfffd, 0xfffd,
    0x9bea, 0xfffd, 0xfffd, 0x9be9, 0x9be8, 0x959d, 0xfffd, 0x9bf1,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9679, 0xfffd, 0x9beb, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9bed, 0x968b, 0xfffd, 0x9bec,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9bee,
    0xfffd, 0x94a6, 0x9bef, 0x95bc, 0x9bf0, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8ab1, 0x95bd, 0x944e, 0x9bf2, 0x9bf3, 0xfffd,
    0x8d4b, 0x8ab2, 0x9bf4, 0x8cb6, 0x9763, 0x9748, 0x8af4, 0x9bf6,
    0xfffd, 0x92a1, 0xfffd, 0x8d4c, 0x8faf, 0xfffd, 0xfffd, 0x94dd,
    0xfffd, 0xfffd, 0x8fb0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f98,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x92ea, 0x95f7, 0x9358,
    0xfffd, 0xfffd, 0x8d4d, 0xfffd, 0x957b, 0xfffd, 0xfffd, 0xfffd,
    0x9bf7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9378, 0x8dc0,
    0xfffd, 0xfffd, 0xfffd, 0x8cc9, 0xfffd, 0x92eb, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x88c1, 0x8f8e, 0x8d4e,
    0x9766, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9bf8, 0x9bf9, 0x9470, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9bfa, 0x97f5, 0x984c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9bfc,
    0x9bfb, 0xfffd, 0xfffd, 0x8a66, 0xfffd, 0xfffd, 0x9c40, 0xfffd,
    0xfffd, 0xfffd, 0x9c43, 0x9c44, 0xfffd, 0x9c42, 0xfffd, 0x955f,
    0x8fb1, 0x9c46, 0x9c45, 0x9c41, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9c47, 0x9c48, 0xfffd, 0xfffd, 0x9c49, 0xfffd, 0xfffd, 0xfffd,
    0x9c4c, 0x9c4a, 0xfffd, 0x9c4b, 0x9c4d, 0xfffd, 0x8984, 0x92ec,
    0x9c4e, 0xfffd, 0x8c9a, 0x89f4, 0x9455, 0xfffd, 0x9c4f, 0x93f9,
    0xfffd, 0x95d9, 0xfffd, 0x9c50, 0x984d, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9c51, 0x95be, 0x9c54, 0x989f, 0x98af, 0xfffd, 0x8eae,
    0x93f3, 0x9c55, 0xfffd, 0x8b7c, 0x92a2, 0x88f8, 0x9c56, 0x95a4,
    0x8d4f, 0xfffd, 0xfffd, 0x926f, 0xfffd, 0xfffd, 0xfffd, 0x92ed,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x96ed, 0x8cb7, 0x8cca,
    0xfffd, 0x9c57, 0xfffd, 0xfffd, 0xfffd, 0x9c58, 0xfffd, 0x9c5e,
    0xfffd, 0x8ee3, 0xfffd, 0xfffd, 0xfffd, 0x92a3, 0xfffd, 0x8bad,
    0x9c59, 0xfffd, 0xfffd, 0xfffd, 0x954a, 0xfffd, 0x9265, 0xfffd,
    0xfffd, 0x9c5a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9c5b, 0xfffd, 0x8bae, 0xfffd, 0x9c5c, 0xfffd, 0x9c5d, 0xfffd,
    0xfffd, 0x9c5f, 0xfffd, 0x9396, 0xfffd, 0xfffd, 0x9c60, 0x9c61,
    0xfffd, 0x9c62, 0xfffd, 0xfffd, 0x9c53, 0x9c52, 0xfffd, 0xfffd,
    0xfffd, 0x9c63, 0x8c60, 0xfffd, 0xfffd, 0xfffd, 0x9546, 0xfffd,
    0xfffd, 0x8dca, 0x9556, 0x92a4, 0x956a, 0x9c64, 0xfffd, 0xfffd,
    0x8fb2, 0x8965, 0xfffd, 0x9c65, 0xfffd, 0xfffd, 0xfffd, 0x9c66,
    0xfffd, 0x96f0, 0xfffd, 0xfffd, 0x94de, 0xfffd, 0xfffd, 0x9c69,
    0x899d, 0x90aa, 0x9c68, 0x9c67, 0x8c61, 0x91d2, 0xfffd, 0x9c6d,
    0x9c6b, 0xfffd, 0x9c6a, 0x97a5, 0x8ce3, 0xfffd, 0xfffd, 0xfffd,
    0x8f99, 0x9c6c, 0x936b, 0x8f5d, 0xfffd, 0xfffd, 0xfffd, 0x93be,
    0x9c70, 0x9c6f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9c6e, 0xfffd,
    0x9c71, 0x8ce4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9c72, 0x959c, 0x8f7a, 0xfffd, 0xfffd, 0x9c73, 0x94f7, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x93bf, 0x92a5, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x934f, 0xfffd, 0xfffd, 0x9c74, 0x8b4a, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9053, 0xfffd, 0x954b, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8af5, 0x9445, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9c75, 0x8e75,
    0x9659, 0x965a, 0xfffd, 0xfffd, 0x899e, 0x9c7a, 0xfffd, 0xfffd,
    0x9289, 0xfffd, 0xfffd, 0xfffd, 0x9c77, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x89f5, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9cab, 0x9c79, 0xfffd, 0xfffd, 0xfffd, 0x944f, 0xfffd, 0xfffd,
    0x9c78, 0xfffd, 0xfffd, 0x9c76, 0xfffd, 0x8d9a, 0xfffd, 0x9c7c,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9c83, 0x9c89,
    0x9c81, 0xfffd, 0x937b, 0xfffd, 0xfffd, 0x9c86, 0x957c, 0xfffd,
    0xfffd, 0x9c80, 0xfffd, 0x9c85, 0x97e5, 0x8e76, 0xfffd, 0xfffd,
    0x91d3, 0x9c7d, 0xfffd, 0xfffd, 0xfffd, 0x8b7d, 0x9c88, 0x90ab,
    0x8985, 0x9c82, 0x89f6, 0x9c87, 0xfffd, 0xfffd, 0xfffd, 0x8baf,
    0xfffd, 0x9c84, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9c8a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9c8c, 0x9c96, 0x9c94, 0xfffd, 0xfffd, 0x9c91, 0xfffd,
    0xfffd, 0xfffd, 0x9c90, 0x97f6, 0xfffd, 0x9c92, 0xfffd, 0xfffd,
    0x8bb0, 0xfffd, 0x8d50, 0xfffd, 0xfffd, 0x8f9a, 0xfffd, 0xfffd,
    0xfffd, 0x9c99, 0x9c8b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9c8f,
    0x9c7e, 0xfffd, 0x89f8, 0x9c93, 0x9c95, 0x9270, 0xfffd, 0xfffd,
    0x8da6, 0x89b6, 0x9c8d, 0x9c98, 0x9c97, 0x8bb1, 0xfffd, 0x91a7,
    0x8a86, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8c62, 0xfffd, 0x9c8e,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9c9a, 0xfffd, 0x9c9d, 0x9c9f, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8ebb, 0xfffd, 0x9ca5, 0x92ee, 0x9c9b, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9ca3, 0xfffd, 0x89f7, 0xfffd, 0x9ca1, 0x9ca2,
    0xfffd, 0xfffd, 0x9c9e, 0x9ca0, 0xfffd, 0xfffd, 0xfffd, 0x8ce5,
    0x9749, 0xfffd, 0xfffd, 0x8ab3, 0xfffd, 0xfffd, 0x8978, 0x9ca4,
    0xfffd, 0x9459, 0x88ab, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x94df, 0x9c7b, 0x9caa, 0x9cae, 0x96e3, 0xfffd,
    0x9ca7, 0xfffd, 0xfffd, 0xfffd, 0x9389, 0x9cac, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8fee, 0x9cad, 0x93d5,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9866, 0xfffd, 0x9ca9, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9caf, 0xfffd, 0x8d9b, 0xfffd, 0x90c9, 0xfffd, 0xfffd, 0x88d2,
    0x9ca8, 0x9ca6, 0xfffd, 0x9179, 0xfffd, 0xfffd, 0xfffd, 0x9c9c,
    0x8e53, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x91c4, 0x9cbb, 0xfffd, 0x917a, 0x9cb6, 0xfffd, 0x9cb3, 0x9cb4,
    0xfffd, 0x8ee4, 0x9cb7, 0x9cba, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9cb5, 0x8f44, 0xfffd, 0x9cb8, 0xfffd, 0xfffd, 0x9cb2, 0xfffd,
    0x96fa, 0x96f9, 0xfffd, 0xfffd, 0xfffd, 0x9cbc, 0x9cbd, 0x88d3,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9cb1, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8bf0, 0x88a4, 0xfffd, 0xfffd, 0xfffd, 0x8ab4,
    0xfffd, 0x9cb9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9cc1,
    0x9cc0, 0xfffd, 0xfffd, 0xfffd, 0x9cc5, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9cc6, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9cc4, 0x9cc7, 0x9cbf, 0x9cc3,
    0xfffd, 0xfffd, 0x9cc8, 0xfffd, 0x9cc9, 0xfffd, 0xfffd, 0x9cbe,
    0x8e9c, 0xfffd, 0x9cc2, 0x91d4, 0x8d51, 0x9cb0, 0x9054, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9cd6, 0xfffd, 0x95e7, 0xfffd, 0xfffd,
    0x9ccc, 0x9ccd, 0x9cce, 0xfffd, 0xfffd, 0x9cd5, 0xfffd, 0x9cd4,
    0xfffd, 0xfffd, 0x969d, 0x8ab5, 0xfffd, 0x9cd2, 0xfffd, 0x8c64,
    0x8a53, 0xfffd, 0xfffd, 0x9ccf, 0xfffd, 0xfffd, 0x97b6, 0x9cd1,
    0x88d4, 0x9cd3, 0xfffd, 0x9cca, 0x9cd0, 0x9cd7, 0x8c63, 0x9ccb,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x977c, 0xfffd,
    0xfffd, 0xfffd, 0x974a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9cda,
    0xfffd, 0xfffd, 0x9cde, 0xfffd, 0xfffd, 0xfffd, 0x919e, 0xfffd,
    0x97f7, 0x9cdf, 0xfffd, 0xfffd, 0x9cdc, 0xfffd, 0x9cd9, 0xfffd,
    0xfffd, 0x9cd8, 0x9cdd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x95ae, 0xfffd, 0xfffd, 0x93b2,
    0xfffd, 0x8c65, 0xfffd, 0x9ce0, 0x9cdb, 0xfffd, 0x9ce1, 0xfffd,
    0xfffd, 0xfffd, 0x8c9b, 0xfffd, 0xfffd, 0xfffd, 0x89af, 0xfffd,
    0xfffd, 0xfffd, 0x9ce9, 0xfffd, 0xfffd, 0xfffd, 0x8ab6, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9ce7, 0xfffd, 0xfffd, 0x9ce8, 0x8da7,
    0x9ce6, 0x9ce4, 0x9ce3, 0x9cea, 0x9ce2, 0x9cec, 0xfffd, 0xfffd,
    0x89f9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9cee, 0xfffd, 0xfffd, 0x9ced, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x92a6, 0xfffd, 0x9cf1, 0xfffd, 0x9cef, 0x9ce5,
    0x8c9c, 0xfffd, 0x9cf0, 0xfffd, 0x9cf4, 0x9cf3, 0x9cf5, 0x9cf2,
    0x9cf6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9cf7, 0x9cf8, 0x95e8, 0xfffd, 0x9cfa, 0x9cf9, 0x8f5e, 0xfffd,
    0x90ac, 0x89e4, 0x89fa, 0xfffd, 0x9cfb, 0xfffd, 0x88bd, 0xfffd,
    0xfffd, 0xfffd, 0x90ca, 0x9cfc, 0xfffd, 0xe6c1, 0x9d40, 0x8c81,
    0xfffd, 0x9d41, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x90ed, 0xfffd,
    0xfffd, 0xfffd, 0x9d42, 0xfffd, 0xfffd, 0xfffd, 0x9d43, 0x8b59,
    0x9d44, 0xfffd, 0x9d45, 0x9d46, 0x91d5, 0xfffd, 0xfffd, 0xfffd,
    0x8ccb, 0xfffd, 0xfffd, 0x96df, 0xfffd, 0xfffd, 0xfffd, 0x965b,
    0x8f8a, 0x9d47, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x90ee,
    0xe7bb, 0x94e0, 0xfffd, 0x8ee8, 0xfffd, 0x8dcb, 0x9d48, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x91c5, 0xfffd, 0x95a5, 0xfffd, 0xfffd,
    0x91ef, 0xfffd, 0xfffd, 0x9d4b, 0xfffd, 0xfffd, 0x9d49, 0xfffd,
    0x9d4c, 0xfffd, 0xfffd, 0x9d4a, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9d4d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x95af, 0xfffd,
    0xfffd, 0x88b5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x957d, 0xfffd,
    0xfffd, 0x94e1, 0xfffd, 0xfffd, 0x9d4e, 0xfffd, 0x9d51, 0x8fb3,
    0x8b5a, 0xfffd, 0x9d4f, 0x9d56, 0x8fb4, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9d50, 0x9463, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x977d, 0x9d52, 0x9d53, 0x9d57, 0x938a, 0x9d54, 0x8d52,
    0x90dc, 0xfffd, 0xfffd, 0x9d65, 0x94b2, 0xfffd, 0x91f0, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x94e2, 0x9dab, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x95f8, 0xfffd, 0xfffd, 0xfffd, 0x92ef, 0xfffd, 0xfffd,
    0xfffd, 0x9695, 0xfffd, 0x9d5a, 0x899f, 0x928a, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9d63, 0xfffd, 0xfffd, 0x9253, 0x9d5d, 0x9d64,
    0x9d5f, 0x9d66, 0x9d62, 0xfffd, 0x9d61, 0x948f, 0xfffd, 0x9d5b,
    0x89fb, 0x9d59, 0x8b91, 0x91f1, 0x9d55, 0xfffd, 0xfffd, 0x9d58,
    0x8d53, 0x90d9, 0xfffd, 0x8fb5, 0x9d60, 0x9471, 0xfffd, 0xfffd,
    0x8b92, 0x8a67, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8a87, 0x9040, 0x9d68, 0x9d6d,
    0xfffd, 0x9d69, 0xfffd, 0x8c9d, 0xfffd, 0x9d6e, 0x8e41, 0x8d89,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f45, 0x9d5c,
    0xfffd, 0x8e9d, 0x9d6b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8e77,
    0x9d6c, 0x88c2, 0xfffd, 0xfffd, 0x9d67, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x92a7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8b93, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8bb2,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9d6a,
    0x88a5, 0xfffd, 0xfffd, 0x8dc1, 0xfffd, 0xfffd, 0xfffd, 0x9055,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x92f0, 0xfffd, 0xfffd, 0x94d2, 0x9d70, 0x917d,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x91a8, 0xfffd, 0xfffd, 0x8e4a, 0x9d71, 0xfffd, 0x9d73,
    0x9d6f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x95df, 0xfffd, 0x92bb,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x917b, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x95f9,
    0x8ecc, 0x9d80, 0xfffd, 0x9d7e, 0xfffd, 0xfffd, 0x9098, 0xfffd,
    0xfffd, 0xfffd, 0x8c9e, 0xfffd, 0xfffd, 0xfffd, 0x9d78, 0x8fb7,
    0xfffd, 0xfffd, 0x93e6, 0x9450, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9d76, 0xfffd, 0xfffd, 0x917c, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8ef6, 0x9d7b, 0xfffd, 0xfffd, 0x8fb6, 0xfffd, 0x9d75, 0x9d7a,
    0xfffd, 0xfffd, 0x9472, 0xfffd, 0xfffd, 0xfffd, 0x9d74, 0xfffd,
    0x8c40, 0xfffd, 0xfffd, 0x8a7c, 0xfffd, 0xfffd, 0xfffd, 0x9d7c,
    0x97a9, 0x8dcc, 0x9254, 0x9d79, 0xfffd, 0x90da, 0xfffd, 0x8d54,
    0x9084, 0x8986, 0x915b, 0x9d77, 0x8b64, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8c66, 0xfffd, 0x92cd, 0x9d7d, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x917e, 0xfffd, 0xfffd, 0x9d81, 0xfffd,
    0x9d83, 0xfffd, 0xfffd, 0x91b5, 0x9d89, 0xfffd, 0x9d84, 0xfffd,
    0xfffd, 0x9d86, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9560,
    0x92f1, 0xfffd, 0x9d87, 0xfffd, 0xfffd, 0xfffd, 0x974b, 0xfffd,
    0xfffd, 0xfffd, 0x9767, 0x8ab7, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x88ac, 0xfffd, 0x9d85, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9d82, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8af6, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8987, 0xfffd, 0x9d88, 0xfffd,
    0xfffd, 0xfffd, 0x9768, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9d8c, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x91b9, 0xfffd, 0x9d93,
    0xfffd, 0xfffd, 0xfffd, 0x9d8d, 0xfffd, 0xfffd, 0x9d8a, 0x9d91,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9d72, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9d8e, 0xfffd,
    0x9d92, 0xfffd, 0xfffd, 0xfffd, 0x94c0, 0x938b, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9d8b, 0xfffd, 0x9d8f, 0xfffd,
    0xfffd, 0xfffd, 0x8c67, 0xfffd, 0xfffd, 0xfffd, 0x8def, 0xfffd,
    0xfffd, 0xfffd, 0x90db, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9d97, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9345, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9d94,
    0xfffd, 0x9680, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9d95,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9d96, 0xfffd,
    0x96cc, 0xfffd, 0x90a0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8c82, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9d9d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8e54, 0x9d9a, 0xfffd, 0x9d99, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9451, 0xfffd, 0xfffd, 0xfffd, 0x93b3, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9350, 0x9d9b, 0xfffd, 0xfffd,
    0xfffd, 0x9d9c, 0xfffd, 0x958f, 0xfffd, 0x9464, 0x8e42, 0xfffd,
    0x90ef, 0xfffd, 0x966f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8a68, 0xfffd, 0x9da3, 0x9d9e, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9769, 0x9da5, 0xfffd, 0xfffd, 0x9da1, 0xfffd, 0x9da2,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9180, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9da0, 0xfffd, 0x9d5e, 0xfffd, 0xfffd, 0xfffd,
    0x9da4, 0xfffd, 0x9d9f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9da9, 0x9daa, 0x9346, 0x9dac, 0xfffd, 0xfffd, 0x8e43, 0x9da7,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8b5b, 0xfffd, 0xfffd, 0x9dad,
    0xfffd, 0x9da6, 0x9db1, 0xfffd, 0x9db0, 0xfffd, 0x9daf, 0xfffd,
    0xfffd, 0xfffd, 0x9db2, 0xfffd, 0xfffd, 0x9db4, 0x8fef, 0xfffd,
    0x9db3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9db7, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9db5, 0xfffd, 0xfffd, 0xfffd, 0x9db6, 0x9d90, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9db9, 0x9db8, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9d98, 0x9dba, 0x9dae, 0xfffd, 0xfffd, 0x8e78,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9dbb, 0x9dbc, 0x9dbe, 0x9dbd,
    0x9dbf, 0x89fc, 0xfffd, 0x8d55, 0xfffd, 0xfffd, 0x95fa, 0x90ad,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8ccc, 0xfffd, 0xfffd,
    0x9dc1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9dc4, 0xfffd, 0x9571,
    0xfffd, 0x8b7e, 0xfffd, 0xfffd, 0xfffd, 0x9dc3, 0x9dc2, 0x9473,
    0x9dc5, 0x8bb3, 0xfffd, 0xfffd, 0xfffd, 0x9dc7, 0x9dc6, 0xfffd,
    0xfffd, 0xfffd, 0x8ab8, 0x8e55, 0xfffd, 0xfffd, 0x93d6, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8c68, 0xfffd, 0xfffd, 0xfffd,
    0x9094, 0xfffd, 0x9dc8, 0xfffd, 0x90ae, 0x9347, 0xfffd, 0x957e,
    0x9dc9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9dca, 0x9dcb, 0xfffd, 0xfffd, 0xfffd, 0x95b6,
    0x9b7c, 0x90c4, 0xfffd, 0xfffd, 0x956b, 0xfffd, 0x8dd6, 0xfffd,
    0x94e3, 0x94c1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x936c,
    0xfffd, 0x97bf, 0xfffd, 0x9dcd, 0x8ece, 0xfffd, 0xfffd, 0x9dce,
    0xfffd, 0x88b4, 0xfffd, 0xfffd, 0x8bd2, 0x90cb, 0xfffd, 0x9580,
    0xfffd, 0xfffd, 0xfffd, 0x9dcf, 0x8e61, 0x9266, 0xfffd, 0x8e7a,
    0x9056, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9dd0,
    0xfffd, 0x95fb, 0xfffd, 0xfffd, 0x8997, 0x8e7b, 0xfffd, 0xfffd,
    0xfffd, 0x9dd3, 0xfffd, 0x9dd1, 0x9dd4, 0x97b7, 0x9dd2, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x90f9, 0x9dd5, 0xfffd, 0xfffd, 0x91b0,
    0xfffd, 0xfffd, 0x9dd6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8af8,
    0xfffd, 0x9dd8, 0xfffd, 0x9dd7, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9dd9, 0x9dda, 0x8af9, 0xfffd, 0xfffd, 0x93fa, 0x9255, 0x8b8c,
    0x8e7c, 0x9181, 0xfffd, 0xfffd, 0x8f7b, 0x88ae, 0xfffd, 0xfffd,
    0xfffd, 0x9ddb, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x89a0, 0x9ddf, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8d56, 0x9dde, 0xfffd, 0xfffd, 0x8da9, 0x8fb8,
    0xfffd, 0xfffd, 0x9ddd, 0xfffd, 0x8fb9, 0xfffd, 0x96be, 0x8da8,
    0xfffd, 0xfffd, 0xfffd, 0x88d5, 0x90cc, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9de4, 0xfffd, 0xfffd, 0x90af,
    0x8966, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f74, 0xfffd, 0x9686,
    0x8df0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8fba, 0xfffd, 0x90a5,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9de3, 0x9de1, 0x9de2, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x928b, 0xfffd, 0xfffd, 0x9e45,
    0xfffd, 0x9de8, 0x8e9e, 0x8d57, 0x9de6, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9de7, 0xfffd, 0x9057, 0xfffd, 0xfffd, 0xfffd, 0x9de5,
    0xfffd, 0xfffd, 0x8e4e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9dea, 0x9de9, 0x9dee,
    0xfffd, 0xfffd, 0x9def, 0xfffd, 0x9deb, 0xfffd, 0x8a41, 0x9dec,
    0x9ded, 0x94d3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9581, 0x8c69,
    0x9df0, 0xfffd, 0xfffd, 0xfffd, 0x90b0, 0xfffd, 0x8fbb, 0xfffd,
    0xfffd, 0xfffd, 0x9271, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8bc5, 0xfffd, 0x9df1, 0x9df5, 0xfffd, 0xfffd, 0x89c9,
    0x9df2, 0x9df4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9df3, 0xfffd,
    0xfffd, 0x8f8b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9267, 0x88c3,
    0x9df6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9df7, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x92a8, 0xfffd, 0xfffd, 0xfffd, 0x97ef, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8e62, 0xfffd, 0xfffd, 0x95e9, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x965c, 0xfffd, 0xfffd, 0xfffd,
    0x9e41, 0x9df9, 0xfffd, 0xfffd, 0x9dfc, 0xfffd, 0x9dfb, 0xfffd,
    0xfffd, 0x9df8, 0xfffd, 0xfffd, 0x9e40, 0xfffd, 0xfffd, 0x93dc,
    0xfffd, 0x9dfa, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9e42, 0xfffd,
    0xfffd, 0x8f8c, 0x9e43, 0xfffd, 0x976a, 0x9498, 0xfffd, 0xfffd,
    0x9e44, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9e46, 0xfffd,
    0xfffd, 0x9e47, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9e48, 0xfffd, 0x8bc8, 0x8967, 0x8d58, 0x9e49, 0xfffd, 0x9e4a,
    0x8f91, 0x9182, 0xfffd, 0xfffd, 0x99d6, 0x915d, 0x915c, 0x91d6,
    0x8dc5, 0xfffd, 0xfffd, 0x98f0, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8c8e, 0x974c, 0xfffd, 0x95fc, 0xfffd, 0x959e, 0xfffd, 0x9e4b,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8df1, 0x92bd, 0x9e4c, 0x984e,
    0xfffd, 0xfffd, 0xfffd, 0x965d, 0xfffd, 0x92a9, 0x9e4d, 0x8afa,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9e4e, 0x9e4f,
    0x96d8, 0xfffd, 0x96a2, 0x9696, 0x967b, 0x8e44, 0x9e51, 0xfffd,
    0xfffd, 0x8ee9, 0xfffd, 0xfffd, 0x9670, 0xfffd, 0x9e53, 0x9e56,
    0x9e55, 0xfffd, 0x8af7, 0xfffd, 0xfffd, 0x8b80, 0xfffd, 0x9e52,
    0xfffd, 0x9e54, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9e57, 0xfffd,
    0xfffd, 0x9099, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x979b, 0x88c7,
    0x8dde, 0x91ba, 0xfffd, 0x8edb, 0xfffd, 0xfffd, 0x8ff1, 0xfffd,
    0xfffd, 0x9e5a, 0xfffd, 0xfffd, 0x936d, 0xfffd, 0x9e58, 0x91a9,
    0x9e59, 0x8ff0, 0x96db, 0x9e5b, 0x9e5c, 0x9788, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9e61, 0xfffd, 0xfffd, 0x8d59, 0xfffd, 0x9474,
    0x9e5e, 0x938c, 0x9ddc, 0x9de0, 0xfffd, 0x8b6e, 0xfffd, 0x9466,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9e60, 0xfffd, 0x8fbc, 0x94c2,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9e66, 0xfffd, 0x94f8,
    0xfffd, 0x9e5d, 0xfffd, 0x9e63, 0x9e62, 0xfffd, 0xfffd, 0xfffd,
    0x90cd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x968d, 0xfffd, 0x97d1,
    0xfffd, 0xfffd, 0x9687, 0xfffd, 0x89ca, 0x8e7d, 0xfffd, 0xfffd,
    0x9867, 0x9e65, 0x9095, 0xfffd, 0xfffd, 0xfffd, 0x9e64, 0xfffd,
    0xfffd, 0x9e5f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8ccd,
    0xfffd, 0xfffd, 0xfffd, 0x9e6b, 0x9e69, 0xfffd, 0x89cb, 0x9e67,
    0x9e6d, 0x9e73, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x91c6, 0xfffd, 0xfffd, 0x95bf, 0xfffd, 0x9e75, 0xfffd,
    0xfffd, 0xfffd, 0x9541, 0xfffd, 0xfffd, 0xfffd, 0x9e74, 0x9490,
    0x965e, 0x8ab9, 0xfffd, 0x90f5, 0x8f5f, 0xfffd, 0xfffd, 0xfffd,
    0x92d1, 0xfffd, 0x974d, 0xfffd, 0xfffd, 0x9e70, 0x9e6f, 0xfffd,
    0xfffd, 0xfffd, 0x9e71, 0xfffd, 0x9e6e, 0xfffd, 0xfffd, 0x9e76,
    0xfffd, 0x9e6c, 0xfffd, 0xfffd, 0x9e6a, 0xfffd, 0x9e72, 0x9e68,
    0xfffd, 0x928c, 0xfffd, 0x96f6, 0x8ec4, 0x8df2, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8db8, 0xfffd, 0xfffd, 0x968f, 0x8a60,
    0xfffd, 0xfffd, 0x92cc, 0x93c8, 0x8968, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x90f0, 0xfffd, 0xfffd, 0x90b2, 0x8c49,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9e78, 0xfffd,
    0xfffd, 0x8d5a, 0x8a9c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9e7a, 0x8a94, 0x9e81, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9e7d, 0xfffd, 0x90f1, 0xfffd, 0xfffd, 0xfffd,
    0x8a6a, 0x8daa, 0xfffd, 0xfffd, 0x8a69, 0x8dcd, 0xfffd, 0xfffd,
    0x9e7b, 0x8c85, 0x8c6a, 0x938d, 0xfffd, 0xfffd, 0x9e79, 0xfffd,
    0x88c4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9e7c, 0x9e7e, 0xfffd,
    0x8bcb, 0x8c4b, 0xfffd, 0x8aba, 0x8b6a, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9e82, 0xfffd, 0xfffd, 0x8df7, 0x9691, 0xfffd, 0x8e56,
    0xfffd, 0xfffd, 0xfffd, 0x9e83, 0xfffd, 0xfffd, 0xfffd, 0x954f,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9e8f, 0xfffd, 0x89b1, 0x9e84,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9e95, 0x9e85,
    0xfffd, 0x97c0, 0xfffd, 0x9e8c, 0xfffd, 0x947e, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9e94, 0xfffd, 0x9e87,
    0xfffd, 0xfffd, 0xfffd, 0x88b2, 0x9e89, 0xfffd, 0xfffd, 0x8d5b,
    0xfffd, 0xfffd, 0xfffd, 0x9e8b, 0xfffd, 0x9e8a, 0xfffd, 0x9e86,
    0x9e91, 0xfffd, 0x8fbd, 0xfffd, 0xfffd, 0xfffd, 0x9aeb, 0x8ce6,
    0x979c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9e88, 0xfffd, 0x92f2,
    0x8a42, 0x8dab, 0xfffd, 0x9e80, 0xfffd, 0x9e90, 0x8a81, 0xfffd,
    0xfffd, 0x9e8e, 0x9e92, 0xfffd, 0x938e, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8afc, 0xfffd, 0x9eb0, 0xfffd,
    0xfffd, 0x96c7, 0x9e97, 0x8afb, 0xfffd, 0x9e9e, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x965f, 0xfffd, 0x9e9f, 0x9ea1, 0xfffd, 0x9ea5,
    0x9e99, 0xfffd, 0x9249, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x938f,
    0x9ea9, 0x9e9c, 0xfffd, 0x9ea6, 0xfffd, 0xfffd, 0xfffd, 0x9ea0,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9058, 0x9eaa,
    0xfffd, 0xfffd, 0x90b1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9ea8, 0x8abb, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x986f, 0x9e96, 0xfffd, 0xfffd, 0x9ea4, 0x88d6, 0xfffd, 0xfffd,
    0x9e98, 0xfffd, 0xfffd, 0x96b8, 0x9e9d, 0x9041, 0x92c5, 0x9e93,
    0xfffd, 0xfffd, 0x9ea3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x909a, 0x9ead, 0x8a91, 0x8c9f, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9eaf, 0x9e9a, 0x9eae, 0xfffd, 0x9ea7, 0x9e9b, 0xfffd,
    0x9eab, 0xfffd, 0x9eac, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9ebd, 0xfffd, 0xfffd, 0xfffd, 0x93cc, 0xfffd, 0x9ea2, 0xfffd,
    0xfffd, 0x9eb9, 0xfffd, 0xfffd, 0xfffd, 0x9ebb, 0xfffd, 0x92d6,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x976b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9596, 0x9eb6, 0x91c8, 0xfffd, 0xfffd,
    0xfffd, 0x9ebc, 0x915e, 0xfffd, 0x9eb3, 0x9ec0, 0x9ebf, 0xfffd,
    0x93ed, 0x9ebe, 0x93e8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9ec2, 0x9eb5, 0xfffd, 0x8bc6, 0x9eb8, 0x8f7c,
    0xfffd, 0xfffd, 0xfffd, 0x9480, 0x9eba, 0x8bc9, 0xfffd, 0x9eb2,
    0x9eb4, 0x9eb1, 0xfffd, 0xfffd, 0x984f, 0x8a79, 0x9eb7, 0xfffd,
    0xfffd, 0x9ec1, 0x8a54, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8de5, 0xfffd, 0xfffd, 0xfffd, 0x897c, 0xfffd,
    0xfffd, 0x9ed2, 0xfffd, 0xfffd, 0x9850, 0x9ed5, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9059, 0x9ed4, 0xfffd, 0xfffd, 0xfffd,
    0x9ed3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9ed0,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9ec4, 0xfffd,
    0xfffd, 0x9ee1, 0x9ec3, 0xfffd, 0x9ed6, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9ece, 0xfffd, 0xfffd, 0x9ec9, 0x9ec6,
    0xfffd, 0x9ec7, 0xfffd, 0x9ecf, 0xfffd, 0xfffd, 0xfffd, 0xeaa0,
    0xfffd, 0xfffd, 0x9ecc, 0x8d5c, 0x92c6, 0x9184, 0x9eca, 0xfffd,
    0x9ec5, 0xfffd, 0xfffd, 0x9ec8, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x976c, 0x968a, 0xfffd, 0xfffd, 0xfffd, 0x9ecd, 0x9ed7, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9edf,
    0x9ed8, 0xfffd, 0xfffd, 0x9ee5, 0xfffd, 0x9ee3, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9ede, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9edd, 0xfffd, 0x92ce, 0xfffd, 0x9185, 0xfffd, 0x9edb,
    0xfffd, 0xfffd, 0x9ed9, 0xfffd, 0xfffd, 0x9ee0, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9ee6, 0x94f3, 0x9eec, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9ee7, 0x9eea, 0x9ee4, 0xfffd, 0xfffd, 0x9294,
    0xfffd, 0x9557, 0xfffd, 0x9eda, 0xfffd, 0xfffd, 0x9ee2, 0x8fbe,
    0xfffd, 0x96cd, 0x9ef6, 0x9ee9, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8ca0, 0x89a1, 0x8a7e, 0xfffd, 0xfffd, 0x9ed1, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8fbf, 0x9eee, 0xfffd,
    0x9ef5, 0x8ef7, 0x8a92, 0xfffd, 0xfffd, 0x924d, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9eeb, 0xfffd, 0xfffd, 0x9ef0,
    0x9ef4, 0xfffd, 0xfffd, 0x8bb4, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8b6b, 0x9ef2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8b40,
    0xfffd, 0x93c9, 0x9ef1, 0xfffd, 0xfffd, 0xfffd, 0x9ef3, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9eed, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9eef, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8a80,
    0x9268, 0xfffd, 0xfffd, 0xfffd, 0x9efa, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9ef8, 0x8ce7, 0xfffd,
    0x9ef7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9f40,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9e77, 0xfffd, 0xfffd, 0xfffd,
    0x9ef9, 0xfffd, 0x9efb, 0x9efc, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9f4b, 0xfffd, 0x9f47, 0xfffd, 0x9e8d, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9f46, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9f45, 0xfffd, 0xfffd, 0x9f42, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9ee8, 0x9f44, 0x9f43, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9f49, 0xfffd, 0x9845, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9f4c, 0x8bf9, 0xfffd, 0xfffd, 0x9f48, 0x9f4a,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x94a5, 0xfffd, 0x9f4d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9f51, 0x9f4e, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9793, 0x9f4f, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9edc, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9f52, 0xfffd, 0xfffd, 0xfffd, 0x9f53, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8954, 0xfffd, 0x9f55,
    0x8c87, 0x8e9f, 0xfffd, 0x8bd3, 0xfffd, 0xfffd, 0xfffd, 0x89a2,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x977e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9f57,
    0x9f56, 0x9f59, 0x8b5c, 0xfffd, 0xfffd, 0x8bd4, 0x8abc, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9f5c, 0xfffd, 0xfffd, 0xfffd, 0x9f5b,
    0xfffd, 0x9f5d, 0xfffd, 0xfffd, 0x89cc, 0xfffd, 0x9256, 0xfffd,
    0x9f5e, 0xfffd, 0xfffd, 0x8abd, 0x9f60, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9f5f, 0xfffd, 0x9f61, 0xfffd, 0xfffd, 0xfffd, 0x9f62,
    0xfffd, 0x9f63, 0x8e7e, 0x90b3, 0x8d9f, 0xfffd, 0x9590, 0xfffd,
    0xfffd, 0x95e0, 0x9863, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8e95,
    0xfffd, 0xfffd, 0xfffd, 0x8dce, 0x97f0, 0xfffd, 0xfffd, 0xfffd,
    0x9f64, 0x9f65, 0xfffd, 0x8e80, 0xfffd, 0xfffd, 0xfffd, 0x9f66,
    0x9f67, 0xfffd, 0xfffd, 0x9f69, 0x9f68, 0xfffd, 0x9677, 0xfffd,
    0xfffd, 0x8f7d, 0x8eea, 0x8e63, 0xfffd, 0x9f6a, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9f6c, 0x9042, 0xfffd,
    0x9f6b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9f6d, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9f6e, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9f6f, 0x9f70, 0xfffd, 0xfffd, 0xfffd, 0x9f71,
    0xfffd, 0x9f73, 0x9f72, 0x9f74, 0x89a3, 0x9269, 0xfffd, 0x9f75,
    0xfffd, 0xfffd, 0x8e45, 0x8a6b, 0x9f76, 0xfffd, 0xfffd, 0x9361,
    0x9aca, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8b42, 0x9f77, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9f78, 0xfffd, 0x95ea, 0x9688, 0xfffd,
    0xfffd, 0xfffd, 0x93c5, 0x9f79, 0x94e4, 0xfffd, 0xfffd, 0xfffd,
    0x94f9, 0xfffd, 0xfffd, 0x96d1, 0xfffd, 0xfffd, 0xfffd, 0x9f7a,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9f7c, 0x9f7b, 0xfffd, 0xfffd, 0x9f7e,
    0xfffd, 0xfffd, 0xfffd, 0x9f7d, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9f81, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8e81,
    0xfffd, 0x96af, 0xfffd, 0x9f82, 0x9f83, 0xfffd, 0xfffd, 0x8b43,
    0xfffd, 0xfffd, 0xfffd, 0x9f84, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9f86, 0x9f85, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9085, 0xfffd, 0xfffd, 0x9558,
    0x8969, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x94c3, 0xfffd,
    0x92f3, 0x8f60, 0x8b81, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x94c4, 0xfffd,
    0x8eac, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9f88, 0xfffd, 0x8abe,
    0xfffd, 0xfffd, 0x8998, 0xfffd, 0xfffd, 0x93f0, 0x9f87, 0x8d5d,
    0x9272, 0xfffd, 0x9f89, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9f91, 0xfffd, 0x9f8a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x91bf, 0xfffd, 0x8b82, 0x9f92, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8c88, 0xfffd, 0xfffd, 0x8b44, 0x9f90, 0xfffd,
    0xfffd, 0x9f8e, 0x9f8b, 0x9780, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x92be, 0xfffd, 0xfffd, 0xfffd, 0x93d7, 0x9f8c, 0xfffd, 0xfffd,
    0x9f94, 0xfffd, 0x9f93, 0x8c42, 0xfffd, 0xfffd, 0x89ab, 0xfffd,
    0xfffd, 0x8db9, 0x9f8d, 0x9f8f, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9676, 0x91f2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9697, 0xfffd, 0xfffd, 0x9f9c, 0xfffd,
    0xfffd, 0x9f9d, 0xfffd, 0x89cd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x95a6, 0x96fb, 0x9f9f, 0x8ea1, 0x8fc0, 0x9f98, 0x9f9e, 0x8988,
    0xfffd, 0x8bb5, 0xfffd, 0xfffd, 0x9f95, 0x9f9a, 0xfffd, 0xfffd,
    0xfffd, 0x90f2, 0x9491, 0xfffd, 0x94e5, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9f97, 0xfffd, 0x9640, 0xfffd, 0x9f99,
    0xfffd, 0x9fa2, 0xfffd, 0x9fa0, 0xfffd, 0x9f9b, 0xfffd, 0xfffd,
    0xfffd, 0x9641, 0x9467, 0x8b83, 0xfffd, 0x9344, 0xfffd, 0xfffd,
    0x928d, 0xfffd, 0x9fa3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9fa1,
    0x91d7, 0x9f96, 0xfffd, 0x896a, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x976d, 0x9fae, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9fad, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x90f4,
    0xfffd, 0x9faa, 0xfffd, 0x978c, 0xfffd, 0xfffd, 0x93b4, 0x9fa4,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x92c3, 0xfffd, 0xfffd,
    0xfffd, 0x896b, 0x8d5e, 0x9fa7, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8f46, 0x9fac, 0xfffd, 0x9fab, 0x9fa6, 0xfffd,
    0x9fa9, 0xfffd, 0xfffd, 0x8a88, 0xfffd, 0x9fa8, 0x9468, 0xfffd,
    0xfffd, 0x97ac, 0xfffd, 0xfffd, 0x8ff2, 0x90f3, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9fb4, 0x9fb2, 0xfffd, 0x956c, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9faf, 0x9fb1, 0xfffd, 0x8959, 0xfffd,
    0xfffd, 0x8d5f, 0x9851, 0xfffd, 0x8a5c, 0xfffd, 0x9582, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9781, 0xfffd, 0xfffd, 0x8a43,
    0x905a, 0x9fb3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9fb8, 0xfffd, 0xfffd,
    0x8fc1, 0xfffd, 0xfffd, 0xfffd, 0x974f, 0xfffd, 0x9fb5, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9fb0, 0xfffd, 0x9fb6, 0xfffd, 0xfffd,
    0xfffd, 0x97dc, 0xfffd, 0x9393, 0x93c0, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8a55,
    0xfffd, 0xfffd, 0x8974, 0xfffd, 0xfffd, 0x9fbc, 0xfffd, 0xfffd,
    0x9fbf, 0xfffd, 0xfffd, 0xfffd, 0x97c1, 0xfffd, 0xfffd, 0xfffd,
    0x9784, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9fc6, 0x9fc0, 0x9fbd,
    0xfffd, 0xfffd, 0xfffd, 0x97d2, 0x9fc3, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8f69, 0x9fc5, 0xfffd, 0xfffd, 0x9fca, 0xfffd, 0xfffd,
    0x9391, 0x9fc8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9fc2, 0xfffd,
    0xfffd, 0x9257, 0xfffd, 0xfffd, 0x9fc9, 0xfffd, 0x9fbe, 0xfffd,
    0x9fc4, 0xfffd, 0x9fcb, 0x88fa, 0x9fc1, 0xfffd, 0x9fcc, 0xfffd,
    0xfffd, 0x905b, 0xfffd, 0x8f7e, 0xfffd, 0x95a3, 0xfffd, 0x8dac,
    0xfffd, 0x9fb9, 0x9fc7, 0x9359, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x90b4, 0xfffd, 0x8a89,
    0x8dcf, 0x8fc2, 0x9fbb, 0x8f61, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8c6b, 0xfffd, 0x9fba, 0xfffd, 0xfffd,
    0xfffd, 0x9fd0, 0x8f8d, 0x8cb8, 0xfffd, 0x9fdf, 0xfffd, 0x9fd9,
    0x8b94, 0x936e, 0xfffd, 0x9fd4, 0x9fdd, 0x88ad, 0x8951, 0xfffd,
    0xfffd, 0x89b7, 0xfffd, 0x9fd6, 0x91aa, 0x9fcd, 0x9fcf, 0x8d60,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9fe0, 0xfffd, 0x9fdb, 0xfffd, 0xfffd, 0xfffd, 0x9fd3, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9fda, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x96a9, 0xfffd, 0xfffd, 0x9fd8, 0x9fdc, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8cce, 0xfffd,
    0x8fc3, 0xfffd, 0xfffd, 0x9258, 0xfffd, 0xfffd, 0xfffd, 0x9fd2,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x974e,
    0xfffd, 0xfffd, 0xfffd, 0x9fd5, 0xfffd, 0xfffd, 0x9fce, 0x9392,
    0xfffd, 0xfffd, 0x9fd1, 0xfffd, 0xfffd, 0xfffd, 0x9fd7, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9870, 0x8ebc,
    0x969e, 0xfffd, 0x9fe1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x94ac, 0xfffd, 0xfffd, 0x9fed,
    0x8cb9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f80, 0xfffd,
    0x9fe3, 0xfffd, 0xfffd, 0xfffd, 0x97ad, 0x8d61, 0xfffd, 0x9ff0,
    0xfffd, 0xfffd, 0x88ec, 0xfffd, 0xfffd, 0x9fee, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9fe2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9fe8,
    0xfffd, 0xfffd, 0x9fea, 0xfffd, 0xfffd, 0xfffd, 0x976e, 0x9fe5,
    0xfffd, 0xfffd, 0x934d, 0xfffd, 0xfffd, 0x9fe7, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9fef, 0xfffd, 0x9fe9, 0x96c5, 0xfffd, 0xfffd,
    0xfffd, 0x9fe4, 0xfffd, 0x8ea0, 0x9ffc, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8a8a, 0xfffd, 0x9fe6, 0x9feb, 0x9fec, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x91ea, 0x91d8, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9ff4, 0xfffd, 0xfffd, 0x9ffa,
    0xfffd, 0xfffd, 0x9ff8, 0xfffd, 0x9348, 0xfffd, 0xfffd, 0xe042,
    0x9ff5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9ff6, 0x9fde,
    0xfffd, 0x8b99, 0x9559, 0xfffd, 0xfffd, 0xfffd, 0x8ebd, 0xfffd,
    0xfffd, 0x8d97, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9852,
    0xfffd, 0x9ff2, 0xfffd, 0xe041, 0x8989, 0x9186, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9499, 0xfffd, 0x8abf, 0x97f8, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x969f, 0x92d0, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9ff9, 0x9ffb, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9151, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe040, 0x9ff7,
    0xfffd, 0x9ff1, 0xfffd, 0xfffd, 0xfffd, 0x8ac1, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8c89, 0xfffd, 0xfffd, 0xfffd,
    0xe04e, 0xfffd, 0xfffd, 0xe049, 0x90f6, 0xfffd, 0xfffd, 0x8a83,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f81, 0xfffd, 0xe052, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe04b, 0x92aa, 0xe048,
    0x92d7, 0xfffd, 0xfffd, 0xfffd, 0xe06b, 0xfffd, 0xfffd, 0xfffd,
    0xe045, 0xfffd, 0xe044, 0xfffd, 0xe04d, 0xfffd, 0xfffd, 0xfffd,
    0xe047, 0xe046, 0xe04c, 0xfffd, 0x909f, 0xfffd, 0xe043, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe04f, 0xfffd,
    0xfffd, 0xe050, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8ac0,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe055, 0xfffd, 0xe054, 0xe056, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe059, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9362, 0xfffd, 0xe053, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe057, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8c83, 0x91f7, 0xe051, 0x945a, 0xfffd, 0xfffd, 0xe058, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe05d, 0xe05b, 0xfffd, 0xfffd,
    0xe05e, 0xfffd, 0xfffd, 0xe061, 0xfffd, 0xfffd, 0xfffd, 0xe05a,
    0x8d8a, 0x9447, 0xfffd, 0xfffd, 0x9fb7, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9794, 0xe05c, 0xfffd, 0xe060, 0x91f3,
    0xfffd, 0xe05f, 0xfffd, 0xe04a, 0xfffd, 0xfffd, 0xe889, 0xfffd,
    0xfffd, 0xfffd, 0xe064, 0xfffd, 0xfffd, 0xfffd, 0xe068, 0xfffd,
    0xfffd, 0xe066, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe062, 0xfffd, 0xe063, 0xfffd, 0xfffd, 0xfffd, 0xe067,
    0xfffd, 0xe065, 0xfffd, 0xfffd, 0xfffd, 0x956d, 0xfffd, 0xfffd,
    0xe06d, 0xfffd, 0xe06a, 0xe069, 0xfffd, 0xe06c, 0x93d2, 0xe06e,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9295, 0x91eb,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x90a3, 0xfffd, 0xfffd, 0xfffd,
    0xe06f, 0xfffd, 0xe071, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe070, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9ff3, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe072, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x93e5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe073, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x89ce, 0xfffd, 0xfffd, 0xfffd, 0x9394,
    0x8a44, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8b84, 0xfffd, 0xfffd, 0xfffd, 0x8edc, 0x8dd0, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9846, 0x9086, 0xfffd, 0xfffd, 0xfffd, 0x898a, 0xfffd,
    0xfffd, 0xfffd, 0xe075, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe074, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe078, 0x9259, 0xe07b, 0xe076,
    0xfffd, 0xfffd, 0xfffd, 0xe07a, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe079, 0x935f, 0x88d7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x97f3, 0xfffd, 0xfffd, 0xe07d, 0xfffd, 0xfffd, 0xfffd, 0x8947,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe080, 0xfffd, 0xfffd, 0xfffd, 0xe07e, 0xfffd, 0xe07c,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe077, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9642, 0xfffd, 0xfffd, 0xfffd, 0xe082, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe081, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x898b, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe084, 0x95b0, 0xfffd, 0xe083, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x96b3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8fc5, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9152, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8fc4, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x97f9, 0xfffd, 0xfffd, 0xe08a, 0xfffd, 0x90f7, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe086, 0xe08b, 0xfffd,
    0xfffd, 0x898c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe089, 0xfffd, 0x9481, 0xe085, 0xe088, 0x8fc6,
    0xfffd, 0x94cf, 0xfffd, 0xfffd, 0xe08c, 0xfffd, 0x8ecf, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x90f8, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe08f, 0xfffd, 0xfffd, 0xfffd,
    0xe087, 0xfffd, 0x8c46, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe08d,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x976f, 0xe090, 0xfffd, 0xfffd,
    0xfffd, 0xeaa4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f6e,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe091, 0xfffd, 0xfffd, 0xfffd, 0xe092, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x944d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe094, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe095, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9452, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9395, 0xe097, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe099, 0xfffd,
    0x97d3, 0xfffd, 0xe096, 0xfffd, 0xe098, 0x898d, 0xfffd, 0xe093,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9a7a,
    0xe09a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9187, 0x8e57, 0xe09c,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe09b, 0x9043, 0x99d7, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe09d, 0xfffd, 0xfffd,
    0xfffd, 0xe09f, 0xfffd, 0xe08e, 0xe09e, 0xfffd, 0xfffd, 0xe0a0,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x949a, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0a1, 0xfffd, 0xfffd,
    0xe0a2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe0a3, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe0a4, 0xfffd, 0x92dc, 0xfffd, 0xe0a6, 0xe0a5, 0xfffd, 0xfffd,
    0xe0a7, 0xfffd, 0xe0a8, 0xfffd, 0xfffd, 0x8edd, 0x9583, 0xfffd,
    0xfffd, 0xfffd, 0x96ea, 0xe0a9, 0xe0aa, 0x9175, 0x8ea2, 0xe0ab,
    0xe0ac, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0ad, 0x95d0,
    0x94c5, 0xfffd, 0xfffd, 0xe0ae, 0x9476, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x92ab, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe0af, 0x89e5, 0xfffd, 0x8b8d, 0xfffd, 0x96c4, 0xfffd, 0x96b4,
    0xfffd, 0x89b2, 0x9853, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9671,
    0xfffd, 0x95a8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x90b5, 0xfffd, 0xe0b0, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x93c1, 0xfffd, 0xfffd, 0xfffd, 0x8ca1, 0xe0b1, 0xfffd,
    0x8dd2, 0xe0b3, 0xe0b2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0b4,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe0b5, 0xfffd, 0xfffd, 0xfffd, 0xe0b6, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8b5d, 0xfffd, 0xe0b7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0b8,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8ca2, 0xfffd, 0xfffd, 0x94c6,
    0xfffd, 0xfffd, 0xe0ba, 0xfffd, 0xfffd, 0xfffd, 0x8ff3, 0xfffd,
    0xfffd, 0xe0b9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8bb6, 0xe0bb, 0xe0bd, 0xfffd, 0xe0bc, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0be, 0xfffd,
    0x8ccf, 0xfffd, 0xe0bf, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8be7,
    0xfffd, 0x915f, 0xfffd, 0x8d9d, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe0c1, 0xe0c2, 0xe0c0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8eeb, 0xfffd, 0xfffd, 0x93c6, 0x8bb7, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0c4,
    0x924b, 0xe0c3, 0xfffd, 0xfffd, 0x9854, 0x9482, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe0c7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0c9, 0xe0c6,
    0xfffd, 0xfffd, 0xfffd, 0x96d2, 0xe0c8, 0xe0ca, 0xfffd, 0x97c2,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0ce, 0xfffd, 0xfffd,
    0xfffd, 0xe0cd, 0x9296, 0x944c, 0xfffd, 0xfffd, 0x8ca3, 0xe0cc,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0cb, 0xfffd, 0x9750, 0x9751,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0cf, 0x898e,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8d96, 0x8e82, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0d0, 0xe0d1,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0d3,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8f62, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe0d5, 0xfffd, 0xe0d4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe0d6, 0xfffd, 0x8a6c, 0xfffd, 0xfffd, 0xe0d8, 0xfffd, 0xfffd,
    0xe0d7, 0xfffd, 0xe0da, 0xe0d9, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8cba, 0xfffd, 0xfffd, 0x97a6,
    0xfffd, 0x8bca, 0xfffd, 0x89a4, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8be8, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8adf, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x97e6, 0xe0dc, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe0de, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe0df, 0xfffd, 0x89cf, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe0db, 0xfffd, 0x8e58, 0xfffd, 0xfffd, 0x92bf, 0xe0dd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0e2, 0xfffd,
    0x8eec, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0e0, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8c5d, 0xfffd, 0xfffd, 0x94c7, 0xe0e1, 0xfffd,
    0xfffd, 0xe0fc, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe0e7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8cbb, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8b85, 0xfffd, 0xe0e4, 0x979d, 0xfffd,
    0xfffd, 0x97ae, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x91f4, 0xfffd, 0xfffd, 0xe0e6, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe0e8, 0x97d4, 0x8bd5, 0x94fa, 0x9469, 0xfffd,
    0xfffd, 0xfffd, 0xe0e9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0eb,
    0xfffd, 0xe0ee, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0ea, 0xfffd, 0xfffd,
    0xfffd, 0xe0ed, 0x8ce8, 0x896c, 0xe0ef, 0xfffd, 0x9090, 0xe0ec,
    0x97da, 0xfffd, 0xfffd, 0xe0f2, 0xeaa2, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe0f0, 0xe0f3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0e5,
    0xe0f1, 0xfffd, 0xfffd, 0x8dba, 0xfffd, 0xfffd, 0xe0f4, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0f5, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x979e, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe0f6, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0f7, 0xfffd,
    0xfffd, 0xfffd, 0xe0e3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0f8,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8ac2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8ea3, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe0f9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0fa,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe0fb, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x895a, 0xfffd, 0xfffd, 0xfffd,
    0xe140, 0xfffd, 0x955a, 0xe141, 0xfffd, 0xfffd, 0x8aa2, 0xe142,
    0xfffd, 0xe143, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe144, 0xfffd,
    0xe146, 0xe147, 0xe145, 0xfffd, 0xfffd, 0xfffd, 0x9572, 0xe149,
    0xe148, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe14b, 0xe14a, 0xe14c, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe14d, 0xe14f, 0xe14e, 0xfffd,
    0xfffd, 0x8d99, 0xfffd, 0xe151, 0xfffd, 0xe150, 0xfffd, 0xfffd,
    0x8ac3, 0xfffd, 0x9072, 0xfffd, 0x935b, 0xfffd, 0xe152, 0x90b6,
    0xfffd, 0xfffd, 0xfffd, 0x8e59, 0xfffd, 0x8999, 0xe153, 0xfffd,
    0x9770, 0xfffd, 0xfffd, 0x95e1, 0xe154, 0xfffd, 0xfffd, 0xfffd,
    0x9363, 0x9752, 0x8d62, 0x905c, 0xfffd, 0xfffd, 0xfffd, 0x926a,
    0x99b2, 0xfffd, 0x92ac, 0x89e6, 0xe155, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe156, 0xfffd, 0xe15b, 0xfffd,
    0xfffd, 0xe159, 0xe158, 0x9dc0, 0x8a45, 0xe157, 0xfffd, 0x88d8,
    0xfffd, 0x94a8, 0xfffd, 0xfffd, 0x94c8, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x97af, 0xe15c, 0xe15a, 0x927b, 0x90a4, 0xfffd, 0xfffd,
    0x94a9, 0xfffd, 0x954c, 0xfffd, 0xe15e, 0x97aa, 0x8c6c, 0xe15f,
    0xfffd, 0xe15d, 0x94d4, 0xe160, 0xfffd, 0xe161, 0xfffd, 0xfffd,
    0x88d9, 0xfffd, 0xfffd, 0x8ff4, 0xe166, 0xfffd, 0xe163, 0x93eb,
    0xe162, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8b45,
    0xfffd, 0xfffd, 0xe169, 0xfffd, 0xfffd, 0xfffd, 0xe164, 0xe165,
    0xfffd, 0xe168, 0xe167, 0x9544, 0xfffd, 0xfffd, 0x9161, 0x9160,
    0xfffd, 0x8b5e, 0xfffd, 0xfffd, 0xe16a, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe16b, 0xfffd, 0xfffd, 0xe16c, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe16e, 0xfffd, 0xe16d, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8975, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe176, 0x94e6, 0xe170, 0xfffd, 0xe172, 0xfffd, 0xfffd,
    0xe174, 0x905d, 0xfffd, 0xfffd, 0xe175, 0xe173, 0x8ebe, 0xfffd,
    0xfffd, 0xfffd, 0xe16f, 0xe171, 0xfffd, 0x9561, 0xfffd, 0x8fc7,
    0xfffd, 0xfffd, 0xe178, 0xfffd, 0xfffd, 0xe177, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe179, 0xfffd, 0x8ea4, 0x8dad, 0xfffd, 0xfffd,
    0x9397, 0xe17a, 0xfffd, 0x92c9, 0xfffd, 0xfffd, 0xe17c, 0xfffd,
    0xfffd, 0xfffd, 0x979f, 0xe17b, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9189, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe182, 0xfffd, 0xe184, 0xe185, 0x9273, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe183, 0xfffd, 0xe180, 0xfffd, 0xe17d, 0xe17e,
    0xfffd, 0xe181, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe188, 0xfffd, 0xe186, 0xfffd, 0xe187, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe189,
    0xe18b, 0xe18c, 0xe18d, 0xfffd, 0xe18e, 0xfffd, 0xfffd, 0xe18a,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe190, 0xfffd, 0xfffd, 0xfffd, 0xe18f, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe191, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x97c3, 0xfffd, 0xfffd, 0xfffd, 0xe194, 0xe192,
    0xe193, 0xfffd, 0xfffd, 0xfffd, 0x8ae0, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x96fc, 0xfffd, 0xfffd, 0xfffd, 0x95c8, 0xfffd,
    0xe196, 0xfffd, 0xfffd, 0xfffd, 0xe195, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe197, 0xe198, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe19c,
    0xe199, 0xe19a, 0xe19b, 0xfffd, 0xe19d, 0xfffd, 0xfffd, 0xfffd,
    0xe19e, 0xfffd, 0xe19f, 0xfffd, 0xfffd, 0xfffd, 0xe1a0, 0xfffd,
    0xe1a1, 0xfffd, 0x94ad, 0x936f, 0xe1a2, 0x9492, 0x9553, 0xfffd,
    0xe1a3, 0xfffd, 0xfffd, 0xe1a4, 0x9349, 0xfffd, 0x8a46, 0x8d63,
    0xe1a5, 0xfffd, 0xfffd, 0xe1a6, 0xfffd, 0xfffd, 0xe1a7, 0xfffd,
    0x8e48, 0xfffd, 0xfffd, 0xe1a9, 0xfffd, 0xfffd, 0xe1a8, 0xfffd,
    0xfffd, 0xe1aa, 0xe1ab, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x94e7, 0xfffd,
    0xe1ac, 0xfffd, 0xfffd, 0xfffd, 0xe1ad, 0xfffd, 0xfffd, 0xea89,
    0xe1ae, 0xe1af, 0xe1b0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8e4d,
    0xfffd, 0xfffd, 0xe1b1, 0x9475, 0xfffd, 0xfffd, 0x967e, 0xfffd,
    0x896d, 0xfffd, 0x8976, 0xfffd, 0xfffd, 0xe1b2, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe1b4, 0xfffd, 0xfffd, 0xfffd, 0xe1b3, 0x9390,
    0xfffd, 0xfffd, 0xfffd, 0x90b7, 0x9f58, 0xfffd, 0xe1b5, 0x96bf,
    0xfffd, 0xe1b6, 0xfffd, 0x8ac4, 0x94d5, 0xe1b7, 0xfffd, 0xe1b8,
    0xfffd, 0xfffd, 0xe1b9, 0xfffd, 0xfffd, 0xfffd, 0x96da, 0xfffd,
    0xfffd, 0xfffd, 0x96d3, 0xfffd, 0x92bc, 0xfffd, 0xfffd, 0xfffd,
    0x918a, 0xfffd, 0xfffd, 0xe1bb, 0xfffd, 0xfffd, 0x8f82, 0xfffd,
    0xfffd, 0x8fc8, 0xfffd, 0xfffd, 0xe1be, 0xfffd, 0xfffd, 0xe1bd,
    0xe1bc, 0x94fb, 0xfffd, 0x8ac5, 0x8ca7, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe1c4, 0xfffd, 0xfffd, 0xe1c1, 0x905e,
    0x96b0, 0xfffd, 0xfffd, 0xfffd, 0xe1c0, 0xe1c2, 0xe1c3, 0xfffd,
    0xfffd, 0xe1bf, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe1c5,
    0xe1c6, 0xfffd, 0x92ad, 0xfffd, 0x8ae1, 0xfffd, 0xfffd, 0xfffd,
    0x9285, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe1c7,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe1c8, 0xe1cb, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9087, 0xfffd, 0x93c2, 0xfffd, 0xe1cc, 0x9672, 0xfffd,
    0xe1c9, 0xfffd, 0xfffd, 0xe1ca, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe1cf, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe1ce, 0xe1cd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe1d1, 0xfffd, 0xfffd, 0xe1d0, 0xfffd,
    0xfffd, 0xe1d2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe1d4, 0xfffd,
    0xe1d3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x95cb, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f75, 0x97c4, 0xfffd, 0xfffd,
    0xe1d5, 0xfffd, 0xfffd, 0x93b5, 0xfffd, 0xfffd, 0xe1d6, 0xfffd,
    0xfffd, 0xe1d7, 0xfffd, 0xe1db, 0xe1d9, 0xe1da, 0xfffd, 0xe1d8,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe1dc,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe1dd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe1de,
    0xfffd, 0xfffd, 0xe1df, 0x96b5, 0xe1e0, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x96ee, 0xe1e1, 0xfffd, 0x926d, 0xfffd, 0x948a,
    0xfffd, 0x8be9, 0xfffd, 0xfffd, 0xfffd, 0x925a, 0xe1e2, 0x8bb8,
    0xfffd, 0xfffd, 0xfffd, 0x90ce, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe1e3, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8dbb, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe1e4, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe1e5, 0xfffd, 0x8ca4, 0x8dd3, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe1e7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9375, 0x8dd4, 0x8b6d,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9643, 0xfffd, 0x946a, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9376, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8d7b,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe1e9, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8fc9, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x97b0, 0x8d64, 0xfffd, 0xfffd, 0x8ca5,
    0xfffd, 0xfffd, 0x94a1, 0xfffd, 0xe1eb, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe1ed, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8ce9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe1ec, 0x92f4,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe1ef, 0x8a56, 0xe1ea, 0xfffd,
    0xfffd, 0x94e8, 0xfffd, 0x894f, 0xfffd, 0x8dea, 0xfffd, 0x9871,
    0xfffd, 0xfffd, 0xe1ee, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe1f0, 0xfffd, 0xfffd, 0xfffd, 0x95c9,
    0xfffd, 0x90d7, 0xe1f2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe1f3,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe1f1, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8a6d, 0xfffd, 0xe1f9, 0xfffd, 0xe1f8, 0xfffd,
    0xfffd, 0x8ea5, 0xfffd, 0xfffd, 0xfffd, 0xe1fa, 0xe1f5, 0xfffd,
    0xfffd, 0xfffd, 0xe1fb, 0xe1f6, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x94d6, 0xe1f4, 0xfffd, 0xfffd, 0xe1f7, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe241, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe240,
    0x9681, 0xfffd, 0xfffd, 0xfffd, 0xe1fc, 0xfffd, 0xfffd, 0x88e9,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe243, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe242, 0xfffd, 0xfffd,
    0xfffd, 0x8fca, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe244,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9162, 0xfffd,
    0xfffd, 0xe246, 0xe245, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe247, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe1e6, 0xfffd,
    0xfffd, 0xfffd, 0xe1e8, 0xe249, 0xe248, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8ea6, 0xfffd, 0x97e7, 0xfffd, 0x8ed0, 0xfffd,
    0xe24a, 0x8c56, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8b5f,
    0x8b46, 0x8e83, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9753, 0xfffd, 0xfffd, 0xe250, 0xfffd, 0xe24f, 0x9163, 0xe24c,
    0xfffd, 0xfffd, 0xe24e, 0xfffd, 0xfffd, 0x8f6a, 0x905f, 0xe24d,
    0xe24b, 0xfffd, 0x9449, 0xfffd, 0xfffd, 0x8fcb, 0xfffd, 0xfffd,
    0x955b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8dd5, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9398,
    0xfffd, 0xfffd, 0xe251, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe252,
    0xe268, 0x8bd6, 0xfffd, 0xfffd, 0x985c, 0x9154, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe253, 0xfffd, 0xfffd, 0x89d0, 0x92f5, 0x959f,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe254, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8b9a, 0xe255,
    0xfffd, 0xfffd, 0xe257, 0xfffd, 0xfffd, 0xfffd, 0xe258, 0xfffd,
    0x9448, 0xfffd, 0xfffd, 0xe259, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe25a, 0xe25b, 0xfffd, 0xfffd, 0x8bd7, 0x89d1, 0x93c3,
    0x8f47, 0x8e84, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe25c, 0xfffd, 0x8f48, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x89c8, 0x9562, 0xfffd, 0xfffd, 0xe25d, 0xfffd, 0xfffd,
    0x94e9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9164,
    0xfffd, 0xe260, 0xfffd, 0xe261, 0x9489, 0xfffd, 0x9060, 0xe25e,
    0xfffd, 0x9281, 0xfffd, 0xfffd, 0xe25f, 0xfffd, 0xfffd, 0xfffd,
    0x8fcc, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x88da, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8b48, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe262, 0xfffd, 0xfffd, 0x92f6, 0xfffd, 0xe263, 0x90c5, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x96ab, 0xfffd, 0xfffd, 0x9542,
    0xe264, 0xe265, 0x9274, 0xfffd, 0x97c5, 0xfffd, 0xfffd, 0xe267,
    0xe266, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8eed, 0xfffd,
    0xfffd, 0xe269, 0x88ee, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe26c,
    0xfffd, 0xfffd, 0xfffd, 0xe26a, 0x89d2, 0x8c6d, 0xe26b, 0x8d65,
    0x8d92, 0xfffd, 0x95e4, 0xe26d, 0xfffd, 0xfffd, 0x9673, 0xfffd,
    0xfffd, 0xe26f, 0xfffd, 0xfffd, 0xfffd, 0x90cf, 0x896e, 0x89b8,
    0x88aa, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe26e,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe270, 0xe271, 0x8ff5, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe272, 0xfffd, 0x8a6e, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe274, 0xfffd, 0xfffd, 0xfffd, 0x8c8a, 0xfffd, 0x8b86, 0xfffd,
    0xfffd, 0xe275, 0x8bf3, 0xfffd, 0xfffd, 0xe276, 0xfffd, 0x90fa,
    0xfffd, 0x93cb, 0xfffd, 0x90de, 0x8df3, 0xfffd, 0xfffd, 0xfffd,
    0xe277, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9282, 0x918b, 0xfffd, 0xe279, 0xe27b, 0xe278,
    0xe27a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8c41,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe27c, 0x8c45, 0xfffd, 0xfffd, 0xfffd, 0x8b87, 0x9771,
    0xe27e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe280, 0xfffd,
    0xfffd, 0xfffd, 0x894d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe283,
    0xfffd, 0xfffd, 0xfffd, 0x8a96, 0xe282, 0xe281, 0xfffd, 0xe285,
    0xe27d, 0xfffd, 0xe286, 0x97a7, 0xfffd, 0xe287, 0xfffd, 0xe288,
    0xfffd, 0xfffd, 0x9af2, 0xe28a, 0xfffd, 0xe289, 0xfffd, 0xfffd,
    0xfffd, 0xe28b, 0xe28c, 0xfffd, 0x97b3, 0xe28d, 0xfffd, 0xe8ed,
    0x8fcd, 0xe28e, 0xe28f, 0x8f76, 0xfffd, 0x93b6, 0xe290, 0xfffd,
    0xfffd, 0xfffd, 0x9247, 0xfffd, 0xfffd, 0xe291, 0xfffd, 0x925b,
    0xe292, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8ba3, 0xfffd,
    0x995e, 0x927c, 0x8eb1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8ac6,
    0xfffd, 0xfffd, 0xe293, 0xfffd, 0xe2a0, 0xfffd, 0xe296, 0xfffd,
    0x8b88, 0xfffd, 0xe295, 0xe2a2, 0xfffd, 0xfffd, 0xfffd, 0xe294,
    0xfffd, 0x8fce, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe298, 0xe299, 0xfffd, 0x934a, 0xfffd, 0xfffd, 0xe29a, 0xfffd,
    0x8a7d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9079, 0x9584, 0xfffd,
    0xe29c, 0xfffd, 0xfffd, 0xfffd, 0x91e6, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe297, 0xfffd, 0xe29b, 0xe29d, 0xfffd,
    0xfffd, 0x8df9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe2a4, 0x954d, 0xfffd,
    0x94a4, 0x9399, 0xfffd, 0x8bd8, 0xe2a3, 0xe2a1, 0xfffd, 0x94b3,
    0xe29e, 0x927d, 0x939b, 0xfffd, 0x939a, 0xfffd, 0x8df4, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe2b6, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe2a6, 0xfffd, 0xe2a8,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe2ab, 0xfffd, 0xe2ac, 0xfffd,
    0xe2a9, 0xe2aa, 0xfffd, 0xfffd, 0xe2a7, 0xe2a5, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe29f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x95cd, 0x89d3,
    0xfffd, 0xfffd, 0xfffd, 0xe2b3, 0xfffd, 0xe2b0, 0xfffd, 0xe2b5,
    0xfffd, 0xfffd, 0xe2b4, 0xfffd, 0x9493, 0x96a5, 0xfffd, 0x8e5a,
    0xe2ae, 0xe2b7, 0xe2b2, 0xfffd, 0xe2b1, 0xe2ad, 0xfffd, 0xe2af,
    0xfffd, 0x8ac7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x925c, 0xfffd, 0xfffd, 0x90fb, 0xfffd, 0xfffd,
    0xfffd, 0x94a0, 0xfffd, 0xfffd, 0xe2bc, 0xfffd, 0xfffd, 0xfffd,
    0x94a2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x90df, 0xe2b9, 0xfffd, 0xfffd, 0x94cd, 0xfffd, 0xe2bd, 0x95d1,
    0xfffd, 0x927a, 0xfffd, 0xe2b8, 0xe2ba, 0xfffd, 0xfffd, 0xe2bb,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe2be, 0xfffd, 0xfffd,
    0x8ec2, 0xfffd, 0xfffd, 0xfffd, 0x93c4, 0xe2c3, 0xe2c2, 0xfffd,
    0xfffd, 0xe2bf, 0xfffd, 0xfffd, 0xfffd, 0x9855, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe2c8, 0xfffd, 0xfffd, 0xe2cc, 0xe2c9,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe2c5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe2c6,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe2cb, 0xfffd, 0xfffd,
    0xfffd, 0xe2c0, 0x99d3, 0xe2c7, 0xe2c1, 0xfffd, 0xfffd, 0xe2ca,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe2d0,
    0xfffd, 0x8ac8, 0xfffd, 0xe2cd, 0xfffd, 0xfffd, 0xfffd, 0xe2ce,
    0xfffd, 0xfffd, 0xe2cf, 0xe2d2, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe2d1,
    0x94f4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe2d3, 0x97fa, 0x95eb,
    0xe2d8, 0xfffd, 0xfffd, 0xe2d5, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe2d4, 0x90d0, 0xfffd, 0xe2d7,
    0xe2d9, 0xfffd, 0xfffd, 0xfffd, 0xe2d6, 0xfffd, 0xe2dd, 0xfffd,
    0xe2da, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe2db,
    0xe2c4, 0xfffd, 0xfffd, 0xfffd, 0xe2dc, 0xe2de, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe2df, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x95c4, 0xfffd, 0xe2e0, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x96e0, 0xfffd,
    0xfffd, 0x8bcc, 0x8c48, 0xe2e1, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x95b2, 0xfffd, 0x9088, 0xfffd, 0x96ae, 0xfffd, 0xfffd,
    0xe2e2, 0xfffd, 0x97b1, 0xfffd, 0xfffd, 0x9494, 0xfffd, 0x9165,
    0x9453, 0xfffd, 0xfffd, 0x8f6c, 0xfffd, 0xfffd, 0xfffd, 0x88be,
    0xfffd, 0xe2e7, 0xe2e5, 0xfffd, 0xe2e3, 0x8a9f, 0xfffd, 0x8fcf,
    0xe2e8, 0xfffd, 0xfffd, 0xe2e6, 0xfffd, 0xe2e4, 0xe2ec, 0xfffd,
    0xfffd, 0xe2eb, 0xe2ea, 0xe2e9, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe2ed, 0xfffd, 0xfffd, 0xfffd, 0xe2ee, 0x90b8, 0xfffd,
    0xe2ef, 0xfffd, 0xe2f1, 0xfffd, 0xfffd, 0xe2f0, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8cd0, 0xfffd, 0xfffd, 0xfffd, 0x9157, 0xfffd,
    0xfffd, 0xfffd, 0xe2f3, 0xfffd, 0xfffd, 0xfffd, 0x939c, 0xfffd,
    0xe2f2, 0xfffd, 0xfffd, 0xfffd, 0xe2f4, 0xfffd, 0x95b3, 0x918c,
    0x8d66, 0xfffd, 0xe2f5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x97c6,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe2f7,
    0xfffd, 0xfffd, 0xe2f8, 0xfffd, 0xe2f9, 0xfffd, 0xe2fa, 0xfffd,
    0x8e85, 0xfffd, 0xe2fb, 0x8c6e, 0xfffd, 0xfffd, 0x8b8a, 0xfffd,
    0x8b49, 0xfffd, 0xe340, 0xfffd, 0x96f1, 0x8d67, 0xe2fc, 0xfffd,
    0xfffd, 0xfffd, 0xe343, 0x96e4, 0xfffd, 0x945b, 0xfffd, 0xfffd,
    0x9552, 0xfffd, 0xfffd, 0xfffd, 0x8f83, 0xe342, 0xfffd, 0x8ed1,
    0x8d68, 0x8e86, 0x8b89, 0x95b4, 0xe341, 0xfffd, 0xfffd, 0xfffd,
    0x9166, 0x9661, 0x8df5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8e87, 0x92db, 0xfffd, 0xe346, 0x97dd,
    0x8dd7, 0xfffd, 0xe347, 0x9061, 0xfffd, 0xe349, 0xfffd, 0xfffd,
    0xfffd, 0x8fd0, 0x8dae, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe348,
    0xfffd, 0xfffd, 0x8f49, 0x8cbc, 0x9167, 0xe344, 0xe34a, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe345, 0x8c6f, 0xfffd, 0xe34d, 0xe351,
    0x8c8b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe34c, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe355, 0xfffd, 0xfffd, 0x8d69, 0xfffd,
    0xfffd, 0x978d, 0x88ba, 0xe352, 0xfffd, 0xfffd, 0x8b8b, 0xfffd,
    0xe34f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe350, 0xfffd,
    0xfffd, 0x939d, 0xe34e, 0xe34b, 0xfffd, 0x8a47, 0x90e2, 0xfffd,
    0xfffd, 0x8ca6, 0xfffd, 0xfffd, 0xfffd, 0xe357, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe354, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe356,
    0xfffd, 0xfffd, 0xfffd, 0xe353, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8c70, 0x91b1, 0xe358, 0x918e, 0xfffd, 0xfffd, 0xe365,
    0xfffd, 0xfffd, 0xe361, 0xe35b, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe35f, 0x8ef8, 0x88db, 0xe35a, 0xe362,
    0xe366, 0x8d6a, 0x96d4, 0xfffd, 0x92d4, 0xe35c, 0xfffd, 0xfffd,
    0xe364, 0xfffd, 0xe359, 0x925d, 0xfffd, 0xe35e, 0x88bb, 0x96c8,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe35d,
    0xfffd, 0xfffd, 0x8bd9, 0x94ea, 0xfffd, 0xfffd, 0xfffd, 0x918d,
    0xfffd, 0x97ce, 0x8f8f, 0xfffd, 0xfffd, 0xe38e, 0xfffd, 0xfffd,
    0xe367, 0xfffd, 0x90fc, 0xfffd, 0xe363, 0xe368, 0xe36a, 0xfffd,
    0x92f7, 0xe36d, 0xfffd, 0xfffd, 0xe369, 0xfffd, 0xfffd, 0xfffd,
    0x95d2, 0x8ac9, 0xfffd, 0xfffd, 0x96c9, 0xfffd, 0xfffd, 0x88dc,
    0xfffd, 0xfffd, 0xe36c, 0xfffd, 0x97fb, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe36b, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x898f, 0xfffd, 0xfffd, 0x93ea, 0xe36e, 0xfffd, 0xfffd,
    0xfffd, 0xe375, 0xe36f, 0xe376, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe372, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x949b, 0xfffd, 0xfffd, 0x8ec8, 0xe374,
    0xfffd, 0xe371, 0xe377, 0xe370, 0xfffd, 0xfffd, 0x8f63, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9644, 0xfffd, 0xfffd, 0x8f6b, 0xfffd,
    0xfffd, 0xe373, 0xe380, 0xfffd, 0xfffd, 0xe37b, 0xfffd, 0xe37e,
    0xfffd, 0xe37c, 0xe381, 0xe37a, 0xfffd, 0xe360, 0x90d1, 0xfffd,
    0xfffd, 0x94c9, 0xfffd, 0xe37d, 0xfffd, 0xfffd, 0xe378, 0xfffd,
    0xfffd, 0xfffd, 0x9140, 0x8c71, 0xfffd, 0x8f4a, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9044, 0x9155, 0xe384, 0xfffd,
    0xfffd, 0xe386, 0xe387, 0xfffd, 0xfffd, 0xe383, 0xe385, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe379, 0xe382,
    0xfffd, 0xe38a, 0xe389, 0xfffd, 0xfffd, 0x969a, 0xfffd, 0xfffd,
    0x8c4a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe388, 0xfffd, 0xe38c, 0xe38b, 0xe38f, 0xfffd, 0xe391,
    0xfffd, 0xfffd, 0x8e5b, 0xe38d, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe392, 0xe393, 0xfffd, 0xfffd, 0xe394, 0xfffd, 0xe39a, 0x935a,
    0xe396, 0xfffd, 0xe395, 0xe397, 0xe398, 0xfffd, 0xe399, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe39b, 0xe39c, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8aca, 0xfffd,
    0xe39d, 0xfffd, 0xe39e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe39f, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe3a0, 0xe3a1, 0xe3a2, 0xfffd,
    0xe3a3, 0xe3a4, 0xfffd, 0xfffd, 0xe3a6, 0xe3a5, 0xfffd, 0xfffd,
    0xe3a7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe3a8,
    0xe3a9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe3ac,
    0xe3aa, 0xe3ab, 0x8ddf, 0x8c72, 0xfffd, 0xfffd, 0x9275, 0xfffd,
    0x94b1, 0xfffd, 0x8f90, 0xfffd, 0xfffd, 0x946c, 0xfffd, 0x94eb,
    0xe3ad, 0x9ceb, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe3ae, 0xe3b0, 0xfffd, 0x9785, 0xe3af, 0xe3b2,
    0xe3b1, 0xfffd, 0x9772, 0xfffd, 0xe3b3, 0xfffd, 0x94fc, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe3b4, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe3b7, 0xfffd, 0xfffd, 0xe3b6, 0xe3b5, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe3b8, 0x8c51, 0xfffd, 0xfffd, 0xfffd,
    0x9141, 0x8b60, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe3bc, 0xe3b9,
    0xfffd, 0xfffd, 0xe3ba, 0xfffd, 0xfffd, 0xfffd, 0xe3bd, 0xfffd,
    0xe3be, 0xe3bb, 0xfffd, 0xfffd, 0xfffd, 0x8948, 0xfffd, 0xfffd,
    0xfffd, 0x89a5, 0xfffd, 0xfffd, 0xfffd, 0xe3c0, 0xe3c1, 0xfffd,
    0xfffd, 0xfffd, 0xe3c2, 0xfffd, 0x9782, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8f4b, 0xfffd, 0xe3c4, 0xe3c3, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9089, 0xe3c5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe3c6, 0xfffd,
    0xfffd, 0xe3c7, 0xfffd, 0x8ae3, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8acb, 0xfffd, 0xfffd, 0xe3c8, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe3c9, 0xfffd, 0x967c, 0x9783, 0xfffd, 0xfffd, 0xfffd,
    0x9773, 0x9856, 0xfffd, 0x8d6c, 0xe3cc, 0x8ed2, 0xe3cb, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe3cd, 0x8ea7, 0xfffd, 0xfffd, 0xfffd,
    0x91cf, 0xfffd, 0xe3ce, 0xfffd, 0xfffd, 0x8d6b, 0xfffd, 0x96d5,
    0xe3cf, 0xe3d0, 0xfffd, 0xfffd, 0xe3d1, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe3d2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe3d3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8ea8, 0xfffd, 0xfffd, 0x96eb, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe3d5, 0xfffd, 0x925e, 0xfffd, 0xe3d4,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe3d7, 0xfffd,
    0xfffd, 0xfffd, 0xe3d6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe3d8, 0xfffd, 0xfffd, 0xfffd, 0x90b9, 0xfffd,
    0xe3d9, 0xfffd, 0xe3da, 0xfffd, 0xfffd, 0xfffd, 0x95b7, 0xe3db,
    0xfffd, 0x918f, 0xe3dc, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe3dd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x97fc,
    0xe3e0, 0xfffd, 0xe3df, 0xe3de, 0x92ae, 0xfffd, 0xe3e1, 0x9045,
    0xfffd, 0xe3e2, 0xfffd, 0xfffd, 0xfffd, 0xe3e3, 0x9857, 0xe3e4,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe3e5, 0xe3e7, 0xe3e6, 0x94a3,
    0xfffd, 0x93f7, 0xfffd, 0x985d, 0x94a7, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe3e9, 0xfffd, 0xfffd, 0x8fd1, 0xfffd,
    0x9549, 0xfffd, 0xe3ea, 0xe3e8, 0xfffd, 0x8acc, 0xfffd, 0xfffd,
    0xfffd, 0x8cd2, 0x8e88, 0xfffd, 0xfffd, 0x94ec, 0xfffd, 0xfffd,
    0xfffd, 0x8ca8, 0x9662, 0xfffd, 0xe3ed, 0xe3eb, 0xfffd, 0x8d6d,
    0xfffd, 0x8d6e, 0x88e7, 0xfffd, 0x8de6, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9478, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x88dd, 0xe3f2, 0xfffd, 0x925f, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9477, 0xfffd, 0x91d9, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe3f4, 0xfffd,
    0xfffd, 0xe3f0, 0xe3f3, 0xe3ee, 0xfffd, 0xe3f1, 0x9645, 0xfffd,
    0xfffd, 0x8cd3, 0xfffd, 0xfffd, 0x88fb, 0xe3ef, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe3f6,
    0xfffd, 0xe3f7, 0xfffd, 0xfffd, 0x93b7, 0xfffd, 0xfffd, 0xfffd,
    0x8bb9, 0xfffd, 0xfffd, 0xfffd, 0xe445, 0x945c, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8e89, 0xfffd, 0xfffd, 0x8bba, 0x90c6, 0x9865,
    0x96ac, 0xe3f5, 0x90d2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8b72, 0xe3f8, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe3fa, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe3f9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe3fb,
    0xfffd, 0x9245, 0xfffd, 0x945d, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x92af, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe442, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe441, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe3fc, 0xfffd, 0xfffd, 0x9074, 0xfffd,
    0x9585, 0xe444, 0xfffd, 0xe443, 0x8d6f, 0x9872, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe454,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe448, 0xe449, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8eee, 0xfffd, 0xfffd, 0xe447, 0xfffd,
    0x8d98, 0xe446, 0xfffd, 0xfffd, 0xe44a, 0xfffd, 0xfffd, 0xfffd,
    0x92b0, 0x95a0, 0x9142, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x91da,
    0xe44e, 0xfffd, 0xe44f, 0xe44b, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe44c, 0xfffd, 0xe44d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8d70,
    0xfffd, 0xfffd, 0xfffd, 0xe455, 0xfffd, 0xe451, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9586, 0xfffd, 0x968c, 0x9547, 0xfffd, 0xfffd,
    0xe450, 0xfffd, 0xfffd, 0xe453, 0xe452, 0xfffd, 0xfffd, 0xfffd,
    0x9663, 0xe456, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe457, 0xfffd, 0xfffd, 0x9156, 0xfffd, 0xe458, 0xfffd, 0xfffd,
    0xe45a, 0xfffd, 0xe45e, 0xfffd, 0xfffd, 0xe45b, 0xe459, 0x945e,
    0xe45c, 0xfffd, 0xe45d, 0xfffd, 0xfffd, 0xfffd, 0x89b0, 0xfffd,
    0xe464, 0xe45f, 0xfffd, 0xfffd, 0xfffd, 0xe460, 0xfffd, 0xfffd,
    0xfffd, 0xe461, 0xfffd, 0x919f, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe463, 0xe462, 0xe465, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe466,
    0xe467, 0xfffd, 0xfffd, 0x9062, 0xfffd, 0x89e7, 0xfffd, 0xe468,
    0x97d5, 0xfffd, 0x8ea9, 0xfffd, 0xfffd, 0x8f4c, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8e8a, 0x9276, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe469, 0xe46a, 0x8950, 0xfffd, 0xe46b, 0xfffd,
    0xfffd, 0xe46c, 0xe46d, 0xfffd, 0xfffd, 0xe46e, 0xfffd, 0xe46f,
    0x8bbb, 0x9da8, 0xe470, 0xfffd, 0x90e3, 0xe471, 0x8ec9, 0xfffd,
    0xe472, 0xfffd, 0x98ae, 0xfffd, 0xfffd, 0xfffd, 0xe473, 0x95dc,
    0x8ada, 0xfffd, 0xfffd, 0x9143, 0x8f77, 0xfffd, 0x9591, 0x8f4d,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe474, 0x8d71, 0xe475, 0x94ca, 0xfffd, 0xe484, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe477, 0xfffd, 0x91c7, 0x9495, 0x8cbd,
    0xe476, 0x9144, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe478, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x92f8,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe47a, 0xe479, 0xe47c, 0xfffd, 0xfffd, 0xe47b, 0xfffd, 0xe47d,
    0xfffd, 0xfffd, 0xe480, 0xfffd, 0xe47e, 0xfffd, 0x8acd, 0xfffd,
    0xe481, 0xfffd, 0xe482, 0xe483, 0xfffd, 0xfffd, 0x8daf, 0x97c7,
    0xfffd, 0xe485, 0x9046, 0xfffd, 0xfffd, 0xfffd, 0x8990, 0xe486,
    0xe487, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe488, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x88f0, 0xfffd, 0xe489, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe48a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9587, 0xfffd, 0xfffd, 0xfffd, 0x8ec5, 0xfffd, 0xe48c,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8a48, 0x88b0, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe48b, 0xe48e, 0x946d, 0xfffd, 0x9063,
    0xfffd, 0x89d4, 0xfffd, 0x9646, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8c7c, 0x8bda, 0xfffd, 0xe48d, 0xfffd, 0x89e8, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8aa1, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8991, 0xe492, 0x97e8, 0x91db, 0xfffd, 0xfffd, 0x9563,
    0xfffd, 0xe49e, 0xfffd, 0x89d5, 0xe49c, 0xfffd, 0xe49a, 0xe491,
    0xfffd, 0xe48f, 0xfffd, 0xe490, 0xfffd, 0x8ee1, 0x8bea, 0x9297,
    0xfffd, 0xfffd, 0xfffd, 0x93cf, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8970, 0xfffd, 0xe494, 0xe493, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe499, 0xe495, 0xe498, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x96ce, 0xe497, 0x89d6, 0x8a9d, 0xe49b, 0xfffd,
    0xfffd, 0xe49d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8c73, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe4a1, 0xe4aa,
    0xe4ab, 0xfffd, 0xfffd, 0xfffd, 0x88a9, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe4b2, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x88ef, 0xfffd, 0xfffd, 0xe4a9, 0xfffd, 0xfffd, 0xfffd, 0xe4a8,
    0xfffd, 0xe4a3, 0xe4a2, 0xfffd, 0xe4a0, 0xe49f, 0x9283, 0xfffd,
    0x91f9, 0xe4a5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe4a4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe4a7, 0xfffd, 0xfffd,
    0xfffd, 0x9190, 0x8c74, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8960,
    0xe4a6, 0xfffd, 0x8d72, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9191, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe4b8, 0xfffd, 0xe4b9, 0xfffd, 0x89d7,
    0xfffd, 0xfffd, 0xfffd, 0x89ac, 0xe4b6, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe4ac, 0xfffd, 0xe4b4,
    0xfffd, 0xe4bb, 0xe4b5, 0xfffd, 0xfffd, 0xfffd, 0xe4b3, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe496, 0xfffd, 0xfffd, 0xe4b1, 0xfffd,
    0xfffd, 0xfffd, 0xe4ad, 0xfffd, 0xfffd, 0xfffd, 0x8ace, 0xe4af,
    0xe4ba, 0xfffd, 0xe4b0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe4bc, 0xfffd, 0xe4ae, 0x949c, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9789, 0xfffd, 0xfffd, 0xfffd, 0xe4b7, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe4cd, 0xfffd, 0xfffd,
    0xfffd, 0xe4c5, 0xfffd, 0xfffd, 0xfffd, 0x909b, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8b65, 0xfffd, 0x8bdb, 0xfffd, 0xe4c0, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x89d9, 0xfffd, 0xfffd, 0x8fd2, 0xfffd,
    0xe4c3, 0xfffd, 0xfffd, 0xfffd, 0x8dd8, 0xfffd, 0xfffd, 0x9370,
    0xe4c8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x95ec, 0xfffd, 0xe4bf, 0xfffd, 0xfffd, 0xfffd, 0x89d8,
    0x8cd4, 0x9548, 0xe4c9, 0xfffd, 0xe4bd, 0xfffd, 0xfffd, 0xe4c6,
    0xfffd, 0xfffd, 0xfffd, 0xe4d0, 0xfffd, 0xe4c1, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe4c2, 0x93b8, 0xfffd, 0xfffd, 0xe4c7,
    0xfffd, 0xfffd, 0xfffd, 0xe4c4, 0x9647, 0xe4ca, 0x88de, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe4be, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe4cc, 0xfffd, 0xe4cb, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x948b, 0xe4d2, 0xfffd, 0xe4dd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8a9e, 0xfffd, 0xfffd, 0xfffd, 0xe4e0, 0xfffd, 0xfffd,
    0xe4ce, 0xfffd, 0xfffd, 0xfffd, 0xe4d3, 0x978e, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe4dc, 0xfffd,
    0xfffd, 0x9774, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x97a8, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9298,
    0xfffd, 0xfffd, 0xfffd, 0x8a8b, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x9592, 0xe4e2, 0x939f, 0xfffd, 0xfffd, 0x88af, 0xfffd,
    0xfffd, 0xe4db, 0xfffd, 0xe4d7, 0x9192, 0xe4d1, 0xe4d9, 0xe4de,
    0xfffd, 0x944b, 0xfffd, 0xfffd, 0xfffd, 0x88a8, 0xfffd, 0xe4d6,
    0xfffd, 0xe4df, 0x9598, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe4da, 0xfffd, 0xe4d5, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8fd3, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8f4e, 0xfffd, 0xfffd, 0xfffd, 0x8eaa, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x96d6, 0xfffd, 0xfffd, 0x9566, 0xfffd, 0xfffd, 0xe4e5,
    0xfffd, 0xe4ee, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe4d8, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8a97, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8ff6, 0xe4e3, 0xfffd, 0xe4e8, 0x9193, 0xfffd, 0xfffd, 0xe4e4,
    0xfffd, 0xe4eb, 0xfffd, 0xfffd, 0x927e, 0xfffd, 0xe4ec, 0xfffd,
    0xfffd, 0x9775, 0xe4e1, 0x8a57, 0xfffd, 0xe4e7, 0xfffd, 0xfffd,
    0xe4ea, 0x96aa, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe4ed, 0xfffd,
    0xfffd, 0xe4e6, 0xe4e9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9648, 0xfffd, 0x9840, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe4f1, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe4f8, 0xfffd, 0xfffd, 0xe4f0,
    0x8ec1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe4cf, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x95cc, 0xfffd, 0x96a0, 0xe4f7, 0xe4f6, 0xfffd, 0xe4f2,
    0xe4f3, 0xfffd, 0x8955, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe4f5,
    0xfffd, 0xe4ef, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x92d3, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe4f4, 0x88fc, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x91a0, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x95c1, 0xfffd, 0xfffd,
    0xe4f9, 0xe540, 0xfffd, 0x94d7, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe4fc, 0x8fd4, 0x8ec7, 0xe542, 0xfffd, 0xfffd, 0x8bbc, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe543, 0xfffd, 0x9599,
    0xe4fb, 0xfffd, 0xe4d4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe4fa, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x986e, 0x93a0, 0x9593, 0xfffd, 0xfffd, 0xe54a, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe550,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe551, 0xfffd,
    0xe544, 0xfffd, 0xfffd, 0xfffd, 0x9496, 0xfffd, 0xfffd, 0xe54e,
    0xe546, 0xfffd, 0xe548, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe552, 0xe547, 0xfffd, 0xfffd, 0xe54b, 0xfffd, 0xfffd, 0x8992,
    0xfffd, 0x93e3, 0xfffd, 0xe54c, 0xe54f, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe545, 0xfffd, 0x9145, 0xfffd,
    0xe549, 0x8e46, 0x9064, 0x8c4f, 0x96f2, 0xfffd, 0x96f7, 0x8f92,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe556, 0xe554, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x986d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe553, 0xfffd, 0xfffd, 0xfffd, 0x9795, 0xfffd, 0xe555,
    0xe557, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe558, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe55b, 0xe559, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x93a1, 0xe55a, 0xfffd, 0xfffd,
    0xfffd, 0x94cb, 0xe54d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f93,
    0xfffd, 0xe55c, 0xe561, 0x9194, 0xfffd, 0xfffd, 0xe560, 0xfffd,
    0xfffd, 0xfffd, 0xe541, 0xfffd, 0xfffd, 0xfffd, 0xe562, 0x9168,
    0xfffd, 0xfffd, 0xe55d, 0xe55f, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe55e, 0xfffd, 0xfffd, 0x9f50, 0x9f41,
    0xfffd, 0xfffd, 0xe564, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe563, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9796, 0xfffd, 0xe1ba,
    0xe565, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe566,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe567, 0x8cd5, 0xfffd,
    0x8b73, 0xfffd, 0xfffd, 0xfffd, 0xe569, 0x997c, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8b95, 0xfffd, 0x97b8, 0xfffd, 0x8bf1, 0xe56a,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe56b,
    0xfffd, 0xfffd, 0xfffd, 0x928e, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe56c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x93f8, 0xfffd, 0x88b8, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x89e1, 0xe571, 0xe572, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe56d, 0xfffd, 0x8e5c, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe56e, 0x9461, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe56f, 0xe570, 0xe57a, 0xfffd, 0xfffd, 0xfffd, 0xe574,
    0xe577, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe573, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe575, 0xfffd, 0xe576, 0x8ed6,
    0xfffd, 0xe578, 0xfffd, 0x9260, 0xfffd, 0x8c75, 0x8a61, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe57b, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8a5e, 0xfffd, 0xe581, 0xfffd, 0xfffd, 0xe57c, 0xe580,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x94b8, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe57d, 0xfffd, 0xfffd, 0xe57e, 0x9567, 0x94d8, 0xe582,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x91fb, 0xe58c, 0xfffd, 0xe588, 0xfffd, 0xfffd, 0x89e9, 0xfffd,
    0xe586, 0xfffd, 0x9649, 0xe587, 0xfffd, 0xfffd, 0xe584, 0xfffd,
    0xe585, 0xe58a, 0xe58d, 0xfffd, 0xfffd, 0xe58b, 0xfffd, 0xfffd,
    0xfffd, 0xe589, 0xe583, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9277, 0xfffd, 0xe594, 0xfffd, 0x96a8, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe592, 0xfffd, 0xfffd,
    0xfffd, 0xe593, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe58e, 0xfffd, 0xfffd, 0xe590,
    0xfffd, 0xfffd, 0xfffd, 0xe591, 0xfffd, 0xfffd, 0xfffd, 0xe58f,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x90e4, 0xfffd, 0x9858, 0xe598, 0xfffd, 0xe599, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe59f, 0xfffd, 0x9049, 0xfffd, 0xe59b,
    0xfffd, 0xe59e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe596,
    0xe595, 0xfffd, 0xfffd, 0xe5a0, 0xfffd, 0xfffd, 0x89da, 0xfffd,
    0xe59c, 0xfffd, 0xe5a1, 0xfffd, 0xfffd, 0xfffd, 0xe59d, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe59a, 0xfffd, 0x92b1, 0xfffd,
    0xe597, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9488,
    0xfffd, 0xfffd, 0xe5a5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x975a, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe5a4,
    0xfffd, 0xfffd, 0xe5a3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe5ac, 0xfffd, 0xfffd, 0xfffd, 0xe5a6,
    0xfffd, 0xfffd, 0xfffd, 0xe5ae, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9786, 0xe5b1, 0xfffd, 0xe5a8, 0xfffd, 0xfffd,
    0xe5a9, 0xfffd, 0xfffd, 0xfffd, 0xe5ad, 0xfffd, 0xe5b0, 0xe5af,
    0xfffd, 0xfffd, 0xfffd, 0xe5a7, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe5aa, 0xfffd, 0xe5bb, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe5b4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe5b2,
    0xfffd, 0xfffd, 0xe5b3, 0xfffd, 0xfffd, 0xfffd, 0xe5b8, 0xe5b9,
    0xfffd, 0x8a49, 0xfffd, 0x8b61, 0xfffd, 0xfffd, 0xe5b7, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe5a2, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe5b6, 0xe5ba, 0xe5b5,
    0xfffd, 0xe5bc, 0xfffd, 0xfffd, 0xfffd, 0xe5be, 0xe5bd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe5c0, 0xe5bf, 0xe579, 0xfffd, 0xfffd, 0xfffd, 0xe5c4,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe5c1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe5c2, 0xfffd,
    0xfffd, 0xe5c3, 0xfffd, 0xe5c5, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8c8c, 0xfffd, 0xe5c7, 0xfffd, 0xe5c6, 0xfffd, 0x8f4f, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8d73, 0x9fa5, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe5c8, 0x8f70, 0xfffd, 0xfffd, 0xfffd, 0x8a58,
    0xfffd, 0xe5c9, 0xfffd, 0x8971, 0xfffd, 0x8fd5, 0xe5ca, 0xfffd,
    0xfffd, 0x8d74, 0xe5cb, 0x88df, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x955c, 0xfffd, 0xfffd, 0xe5cc, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x908a, 0xfffd, 0xe5d3, 0xfffd, 0xfffd, 0xe5d0, 0xfffd, 0x928f,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe5d1, 0xe5ce, 0x8bdc,
    0xfffd, 0xe5cd, 0xe5d4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8c55, 0xfffd, 0xfffd, 0x91dc, 0xfffd, 0xe5da, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe5d6, 0xfffd, 0xfffd, 0xfffd, 0x91b3, 0xe5d5,
    0xfffd, 0xe5d8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe5cf, 0xfffd,
    0xfffd, 0xfffd, 0xe5d9, 0xfffd, 0xe5db, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x94ed, 0xfffd, 0xfffd, 0xe5d7, 0xfffd,
    0xe5dc, 0xe5de, 0xfffd, 0xfffd, 0x8cd1, 0xe5d2, 0xfffd, 0x88bf,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe5dd,
    0xfffd, 0x8dd9, 0x97f4, 0xe5df, 0xe5e0, 0x9195, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x97a0,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe5e1, 0x9754, 0xfffd, 0xfffd,
    0xe5e2, 0xe5e3, 0xfffd, 0xfffd, 0x95e2, 0xe5e4, 0xfffd, 0x8dbe,
    0xfffd, 0x97a1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe5e9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe5ea, 0x8fd6, 0xe5e8, 0xfffd, 0xfffd, 0xfffd,
    0x9787, 0xe5e5, 0xfffd, 0xfffd, 0xe5e7, 0x90bb, 0x909e, 0xfffd,
    0xfffd, 0xfffd, 0xe5e6, 0xfffd, 0xe5eb, 0xfffd, 0xfffd, 0x95a1,
    0xfffd, 0xfffd, 0xe5ed, 0xfffd, 0xe5ec, 0xfffd, 0xfffd, 0xfffd,
    0x8a8c, 0xfffd, 0x964a, 0xe5ee, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe5fa, 0xe5f0, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe5f1, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe5f2, 0xe5f3, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe5f7, 0xfffd,
    0xe5f8, 0xfffd, 0xfffd, 0xe5f6, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe5f4, 0xfffd, 0xe5ef, 0xe5f5, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe5f9, 0xe8b5, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x89a6, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe5fc, 0x8bdd,
    0xe5fb, 0xfffd, 0xfffd, 0xfffd, 0xe641, 0xfffd, 0xe640, 0xfffd,
    0xfffd, 0xfffd, 0xe643, 0xfffd, 0xfffd, 0xe642, 0xfffd, 0xe644,
    0xfffd, 0xfffd, 0x8f50, 0xfffd, 0xe645, 0xfffd, 0xfffd, 0xe646,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe647, 0x90bc,
    0xfffd, 0x9776, 0xfffd, 0xe648, 0xfffd, 0xfffd, 0x95a2, 0x9465,
    0xe649, 0xfffd, 0xe64a, 0x8ca9, 0xfffd, 0xfffd, 0xfffd, 0x8b4b,
    0xfffd, 0xfffd, 0xfffd, 0xe64b, 0xfffd, 0xfffd, 0x8e8b, 0x9460,
    0xe64c, 0xfffd, 0x8a6f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe64d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe64f, 0x9797,
    0xfffd, 0xe64e, 0x9065, 0xfffd, 0xe650, 0xfffd, 0xfffd, 0xe651,
    0xfffd, 0xfffd, 0xe652, 0x8acf, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe653, 0xfffd, 0xfffd, 0xe654, 0xfffd, 0xe655,
    0xe656, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8a70, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe657, 0xfffd, 0xe658, 0xe659, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x89f0, 0xfffd, 0xfffd, 0x9047, 0xe65a,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe65b, 0xfffd, 0xfffd, 0xfffd,
    0xe65c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8cbe, 0xfffd, 0x92f9, 0xe65d, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8c76, 0xfffd, 0x9075, 0xfffd, 0xe660, 0xfffd, 0x93a2, 0xfffd,
    0xe65f, 0xfffd, 0xfffd, 0x8c50, 0xfffd, 0xfffd, 0xe65e, 0x91f5,
    0x8b4c, 0xfffd, 0xfffd, 0xe661, 0xfffd, 0xe662, 0xfffd, 0x8fd7,
    0xfffd, 0xfffd, 0xfffd, 0x8c8d, 0xfffd, 0xe663, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x964b, 0xfffd, 0xfffd, 0x90dd, 0xfffd, 0xfffd,
    0xfffd, 0x8b96, 0xfffd, 0x96f3, 0x9169, 0xfffd, 0xe664, 0xfffd,
    0xfffd, 0xfffd, 0x9066, 0x9290, 0x8fd8, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe665, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe668, 0xfffd,
    0xe669, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8dbc, 0x91c0, 0xe667, 0xfffd, 0x8fd9, 0x955d, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe666, 0xfffd, 0xfffd, 0x8e8c, 0xfffd,
    0x8972, 0xfffd, 0xe66d, 0x8c77, 0xfffd, 0xfffd, 0x8e8e, 0xfffd,
    0xfffd, 0x8e8d, 0xfffd, 0x986c, 0xe66c, 0xe66b, 0x9146, 0xfffd,
    0x8b6c, 0x9862, 0x8a59, 0x8fda, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe66a, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe66f, 0xfffd, 0xe670, 0xe66e, 0xfffd, 0x8cd6,
    0xfffd, 0x975f, 0xfffd, 0xfffd, 0x8e8f, 0x9446, 0xfffd, 0xfffd,
    0xfffd, 0xe673, 0xfffd, 0x90be, 0xfffd, 0x9261, 0xfffd, 0xfffd,
    0x9755, 0xfffd, 0xe676, 0xfffd, 0xfffd, 0xfffd, 0x8cea, 0xfffd,
    0x90bd, 0xe672, 0xfffd, 0xe677, 0x8ceb, 0xe674, 0xe675, 0xfffd,
    0xe671, 0xfffd, 0xfffd, 0xfffd, 0x90e0, 0x93c7, 0xfffd, 0xfffd,
    0x924e, 0xfffd, 0x89db, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x94ee, 0xfffd, 0xfffd, 0x8b62, 0xfffd, 0xfffd, 0x92b2,
    0xfffd, 0xfffd, 0xe67a, 0xfffd, 0xe678, 0xfffd, 0xfffd, 0x926b,
    0xfffd, 0xfffd, 0xfffd, 0x90bf, 0x8ad0, 0xe679, 0xfffd, 0x907a,
    0xfffd, 0xfffd, 0x97c8, 0xfffd, 0xfffd, 0xfffd, 0x985f, 0xfffd,
    0xfffd, 0xfffd, 0xe67b, 0xe687, 0x92b3, 0xfffd, 0xe686, 0xfffd,
    0xe683, 0xe68b, 0xe684, 0xfffd, 0xe680, 0xfffd, 0x92fa, 0xe67e,
    0xfffd, 0xfffd, 0xfffd, 0xe67c, 0xfffd, 0x9740, 0x8e90, 0xfffd,
    0xfffd, 0xe681, 0xfffd, 0xe67d, 0xfffd, 0xfffd, 0xfffd, 0xe685,
    0x8f94, 0xfffd, 0x8cbf, 0xfffd, 0xfffd, 0xfffd, 0x91f8, 0xfffd,
    0x9664, 0x8979, 0x88e0, 0xfffd, 0x93a3, 0xfffd, 0xfffd, 0xe689,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe688, 0xfffd, 0x93e4, 0xfffd,
    0xe68d, 0xfffd, 0xfffd, 0xfffd, 0xe682, 0xfffd, 0xe68c, 0xe68e,
    0xfffd, 0x8caa, 0xe68a, 0x8d75, 0xfffd, 0x8ed3, 0xfffd, 0xfffd,
    0xe68f, 0x9777, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe692, 0xfffd,
    0xe695, 0xfffd, 0xfffd, 0xe693, 0x9554, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe690, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8bde, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe694, 0xfffd,
    0xfffd, 0xe696, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe69a, 0xfffd, 0xfffd, 0xe697, 0xfffd, 0xe699, 0xe698,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe69b, 0xfffd,
    0x8eaf, 0xfffd, 0xe69d, 0xe69c, 0x9588, 0xfffd, 0xfffd, 0xe69f,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8c78, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe69e, 0xe6a0, 0xfffd, 0xfffd, 0xe6a1,
    0x8b63, 0xe3bf, 0x8ff7, 0xfffd, 0xe6a2, 0xfffd, 0xfffd, 0x8cec,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe6a3, 0xfffd, 0xfffd,
    0xe6a4, 0xfffd, 0xfffd, 0x8e5d, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9dcc, 0xfffd, 0xe6a5, 0xfffd, 0xe6a6, 0xfffd,
    0x8f51, 0xfffd, 0xe6a7, 0xe6a8, 0xfffd, 0xfffd, 0xe6a9, 0xfffd,
    0xfffd, 0xe6aa, 0xe6ab, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x924a,
    0xfffd, 0xfffd, 0xe6ac, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe6ae,
    0xfffd, 0xe6ad, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x93a4, 0xfffd,
    0xe6af, 0xfffd, 0x964c, 0xfffd, 0xe6b0, 0xfffd, 0xe6b1, 0xfffd,
    0xe6b2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe6b3, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x93d8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8fdb, 0xe6b4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8d8b, 0x98ac, 0xe6b5, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe6b6, 0x955e, 0xe6b7, 0xfffd, 0xe6bf, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe6b8, 0xfffd, 0xfffd, 0xe6ba, 0xfffd, 0xfffd,
    0xfffd, 0xe6b9, 0xe6bb, 0xfffd, 0x9665, 0xe6bc, 0xe6bd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe6be, 0xfffd, 0xfffd, 0xfffd,
    0xe6c0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8a4c, 0x92e5, 0xfffd,
    0x9589, 0x8de0, 0x8d76, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x956e,
    0x89dd, 0x94cc, 0xe6c3, 0x8ad1, 0x90d3, 0xe6c2, 0xe6c7, 0x9299,
    0x96e1, 0xfffd, 0xe6c5, 0xe6c6, 0x8b4d, 0xfffd, 0xe6c8, 0x9483,
    0x91dd, 0xfffd, 0xfffd, 0x94ef, 0x935c, 0xe6c4, 0xfffd, 0x9666,
    0x89ea, 0xe6ca, 0x9847, 0x92c0, 0x9864, 0xfffd, 0xfffd, 0x8e91,
    0xe6c9, 0xfffd, 0x91af, 0xfffd, 0xfffd, 0xe6da, 0x9147, 0xfffd,
    0xfffd, 0x93f6, 0xfffd, 0x956f, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe6cd, 0x8e5e, 0x8e92, 0xfffd, 0x8fdc, 0xfffd,
    0x9485, 0xfffd, 0x8cab, 0xe6cc, 0xe6cb, 0xfffd, 0x958a, 0xfffd,
    0xfffd, 0xfffd, 0x8ebf, 0xfffd, 0xfffd, 0x9371, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe6cf, 0xe6d0, 0x8d77, 0xe6ce, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe6d1, 0xe6d2, 0xfffd, 0xe6d4,
    0x91a1, 0xfffd, 0xe6d3, 0x8ae4, 0xfffd, 0xe6d6, 0xfffd, 0xe6d5,
    0xe6d7, 0xfffd, 0xfffd, 0xe6d9, 0xe6db, 0xfffd, 0xe6dc, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x90d4, 0xfffd, 0x8ecd, 0xe6dd,
    0xfffd, 0xfffd, 0xfffd, 0x8a71, 0xfffd, 0xe6de, 0xfffd, 0xfffd,
    0x9196, 0xe6df, 0xfffd, 0xe6e0, 0x958b, 0xfffd, 0xfffd, 0x8b4e,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe6e1, 0xfffd, 0xfffd, 0xfffd, 0x92b4, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x897a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe6e2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8eef, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9096, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x91ab, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe6e5, 0xfffd, 0xfffd, 0xfffd, 0xe6e4, 0xfffd,
    0xfffd, 0xfffd, 0xe6e3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe6eb, 0xe6e9, 0xfffd, 0xfffd, 0xe6e6,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe6e8, 0xfffd,
    0xfffd, 0xfffd, 0xe6e7, 0xe6ea, 0xfffd, 0x8b97, 0xfffd, 0xe6ee,
    0xfffd, 0x90d5, 0xfffd, 0xe6ef, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8cd7, 0xfffd, 0xe6ec, 0xe6ed, 0xfffd, 0xfffd, 0xfffd, 0x9848,
    0xfffd, 0xfffd, 0xfffd, 0x92b5, 0xfffd, 0x9148, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe6f0, 0xfffd, 0xfffd, 0xe6f3,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe6f1, 0xe6f2, 0x9778, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x93a5,
    0xe6f6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe6f4, 0xe6f5, 0xe6f7,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe748, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe6fa, 0xfffd, 0xfffd, 0xfffd, 0xe6fb, 0xe6f9, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe6f8, 0xfffd, 0x92fb, 0xfffd, 0xfffd, 0xe740,
    0xe744, 0xe741, 0xe6fc, 0xfffd, 0xe742, 0xfffd, 0xfffd, 0xfffd,
    0xe743, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe74a, 0xfffd, 0xfffd,
    0xfffd, 0xe745, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x90d6,
    0xe747, 0xfffd, 0xfffd, 0xe749, 0xe746, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe74c, 0xfffd, 0x8f52, 0xfffd, 0xe74b, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe74d, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe74e, 0xfffd, 0xfffd, 0xe751, 0xe750, 0xfffd, 0xe74f,
    0xfffd, 0xfffd, 0xe753, 0xe752, 0xfffd, 0x96f4, 0xfffd, 0xfffd,
    0xfffd, 0xe755, 0xfffd, 0xe754, 0xe756, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe757, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe759, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe758, 0x9067, 0xe75a, 0xfffd, 0xfffd, 0x8beb,
    0xe75b, 0xe75d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe75e, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe75f, 0xe75c, 0xfffd,
    0xe760, 0xfffd, 0x8ed4, 0xe761, 0x8b4f, 0x8c52, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8cac, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe762, 0xfffd, 0xfffd, 0xfffd, 0x93ee,
    0xfffd, 0xfffd, 0x935d, 0xe763, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe766, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8eb2, 0xfffd, 0xfffd, 0xe765, 0xe764, 0x8c79, 0xe767, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8a72, 0xfffd, 0xe769, 0xfffd, 0xfffd,
    0xfffd, 0x8dda, 0xe768, 0xfffd, 0xe771, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe76b, 0xe76d, 0x95e3, 0xe76a, 0xfffd, 0xfffd,
    0xfffd, 0xe76c, 0xfffd, 0xe770, 0xe76e, 0x8b50, 0xfffd, 0xe76f,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe772, 0xfffd,
    0xfffd, 0x9479, 0x97d6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f53,
    0xfffd, 0xfffd, 0xfffd, 0xe773, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9741, 0xe775, 0xfffd, 0xe774, 0xfffd, 0xfffd, 0xe778, 0x9760,
    0xfffd, 0xfffd, 0xe777, 0xfffd, 0x8a8d, 0xe776, 0xe77b, 0xfffd,
    0xfffd, 0xe77a, 0xfffd, 0xfffd, 0xe779, 0x9351, 0xe77c, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe77d,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe77e, 0xfffd, 0xfffd, 0x8d8c,
    0xfffd, 0x8c44, 0xe780, 0xe781, 0xe782, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9068, 0xe783, 0xfffd, 0x8eab, 0xe784,
    0xfffd, 0xfffd, 0xfffd, 0xe785, 0xfffd, 0xfffd, 0xfffd, 0x999f,
    0x999e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe786, 0xe390, 0xe787,
    0x9243, 0x904a, 0x945f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe788,
    0xfffd, 0xfffd, 0x95d3, 0x92d2, 0x8d9e, 0xfffd, 0xfffd, 0x9248,
    0xfffd, 0xfffd, 0x8949, 0xfffd, 0x9698, 0x9076, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8c7d, 0xfffd,
    0xfffd, 0x8bdf, 0xfffd, 0xfffd, 0x95d4, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe789, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe78b, 0xfffd, 0xfffd, 0xe78a, 0x89de, 0xfffd,
    0xfffd, 0x93f4, 0xe78c, 0x9497, 0xfffd, 0x9352, 0xfffd, 0xe78d,
    0x8f71, 0xfffd, 0xfffd, 0xfffd, 0xe78f, 0xfffd, 0xfffd, 0x96c0,
    0xe79e, 0xe791, 0xe792, 0xfffd, 0xfffd, 0x92c7, 0xfffd, 0xfffd,
    0x91de, 0x9197, 0xfffd, 0x93a6, 0xfffd, 0xe790, 0x8b74, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe799, 0xfffd, 0xe796, 0xe7a3, 0x93a7,
    0x9280, 0xe793, 0xfffd, 0x92fc, 0x9372, 0xe794, 0xe798, 0x9080,
    0xfffd, 0x9487, 0x92ca, 0xfffd, 0xfffd, 0x90c0, 0xe797, 0x91ac,
    0x91a2, 0xe795, 0x88a7, 0x9841, 0xfffd, 0xfffd, 0xfffd, 0xe79a,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x91df, 0xfffd,
    0xfffd, 0x8f54, 0x9069, 0xfffd, 0xfffd, 0xe79c, 0xe79b, 0xfffd,
    0x88ed, 0xe79d, 0xfffd, 0xfffd, 0x954e, 0xfffd, 0xe7a5, 0xfffd,
    0xfffd, 0x93d9, 0x908b, 0xfffd, 0xfffd, 0x9278, 0xfffd, 0x8bf6,
    0xfffd, 0xe7a4, 0x9756, 0x895e, 0xfffd, 0x95d5, 0x89df, 0xe79f,
    0xe7a0, 0xe7a1, 0xe7a2, 0x93b9, 0x9242, 0x88e1, 0xe7a6, 0xfffd,
    0xe7a7, 0xeaa1, 0xfffd, 0xfffd, 0x91bb, 0xfffd, 0xe7a8, 0xfffd,
    0x8993, 0x916b, 0xfffd, 0x8cad, 0xfffd, 0x9779, 0xfffd, 0xfffd,
    0xe7a9, 0x934b, 0xfffd, 0xfffd, 0xfffd, 0x9198, 0x8ed5, 0xe7aa,
    0xfffd, 0xfffd, 0xe7ad, 0xfffd, 0xfffd, 0x8f85, 0xe7ab, 0x914a,
    0x9149, 0xfffd, 0x88e2, 0xfffd, 0x97c9, 0xe7af, 0xfffd, 0x94f0,
    0xe7b1, 0xe7b0, 0xe7ae, 0xe284, 0x8ad2, 0xfffd, 0xfffd, 0xe78e,
    0xfffd, 0xe7b3, 0xe7b2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe7b4,
    0xfffd, 0x9757, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x93df, 0xfffd, 0xfffd, 0x964d, 0xfffd,
    0xe7b5, 0xfffd, 0x8ed7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe7b6,
    0xfffd, 0xe7b7, 0xfffd, 0xfffd, 0xfffd, 0xe7b8, 0xfffd, 0xfffd,
    0x9340, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x88e8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x8d78, 0xfffd, 0xfffd, 0xfffd, 0x9859, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe7bc, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8c53, 0xe7b9, 0xfffd, 0xe7ba, 0xfffd, 0xfffd, 0xfffd,
    0x9594, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8a73, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9758, 0xfffd, 0x8bbd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9373, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe7bd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe7be, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe7bf, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9341, 0xfffd, 0xfffd,
    0xe7c1, 0xfffd, 0xe7c0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x93d1, 0xe7c2, 0x8f55, 0x8ede, 0x947a, 0x9291, 0xfffd,
    0xfffd, 0xfffd, 0x8ef0, 0xfffd, 0x908c, 0xfffd, 0xe7c3, 0xfffd,
    0xe7c4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x907c, 0xe7c5, 0xfffd, 0xe7c6, 0xfffd, 0xfffd,
    0xfffd, 0xe7c7, 0x978f, 0xfffd, 0x8f56, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe7c9, 0xe7c8, 0xfffd, 0x8d79, 0xfffd, 0x8d93,
    0x8e5f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe7cc, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f86,
    0xfffd, 0xe7cb, 0xfffd, 0xe7ca, 0xfffd, 0x91e7, 0xfffd, 0xfffd,
    0x8ced, 0xfffd, 0x90c1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x94ae,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f58, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe7cd, 0xfffd, 0x8fdd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe7d0, 0xe7ce, 0xfffd, 0xfffd, 0xfffd, 0xe7cf,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe7d2, 0xe7d1, 0xfffd, 0xfffd,
    0x8ff8, 0xfffd, 0xe7d3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe7d4, 0xe7d5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x94ce, 0x8dd1,
    0x8edf, 0xe7d6, 0xfffd, 0xe7d7, 0x97a2, 0x8f64, 0x96ec, 0x97ca,
    0xe7d8, 0x8be0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe7d9, 0xfffd,
    0x9342, 0xfffd, 0xfffd, 0xe7dc, 0x8a98, 0x906a, 0xfffd, 0xe7da,
    0xfffd, 0xe7db, 0xfffd, 0x92de, 0xfffd, 0xfffd, 0x9674, 0x8bfa,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe7de, 0xe7df, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe7dd, 0xfffd, 0xfffd, 0xe7e1,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x93dd, 0x8a62, 0xfffd,
    0xfffd, 0xe7e5, 0xfffd, 0xfffd, 0xe7e2, 0xe7e4, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe7e0, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe86e, 0xfffd, 0xfffd, 0xe7e3, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x97e9, 0xfffd, 0xfffd, 0x8cd8,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe7ed,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9353, 0xe7e8, 0xfffd, 0xfffd,
    0xe7eb, 0xe7e9, 0xfffd, 0xe7ee, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe7ef, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe7e7,
    0xfffd, 0xfffd, 0xe7f4, 0x8994, 0xfffd, 0xfffd, 0xe7e6, 0xfffd,
    0xfffd, 0xfffd, 0x94ab, 0xfffd, 0xe7ea, 0xfffd, 0x8fde, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8d7a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9667, 0xfffd,
    0x8be2, 0xfffd, 0xfffd, 0x8f65, 0xfffd, 0x93ba, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x914c, 0xfffd, 0xe7f2, 0xfffd, 0xe7ec, 0xe7f1, 0xfffd,
    0x96c1, 0xfffd, 0x92b6, 0xe7f3, 0xe7f0, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x914b, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe7f7,
    0xfffd, 0xe7f6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe7f5,
    0xfffd, 0xfffd, 0x964e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8f9b, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe7f8, 0x95dd, 0xfffd, 0xfffd, 0x8973, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9565, 0x9292, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8b98, 0xfffd, 0xe7fa, 0xfffd, 0x8d7c, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8e4b, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe7f9,
    0x908d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x908e, 0xe840, 0xe842, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8ff9, 0xfffd, 0xe841, 0xe843, 0xfffd, 0xfffd, 0x8bd1, 0xfffd,
    0x9564, 0xfffd, 0xfffd, 0x8ee0, 0x9842, 0xfffd, 0xe7fc, 0x8df6,
    0xfffd, 0xfffd, 0x985e, 0xfffd, 0xfffd, 0xe845, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe844, 0xe846, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe7fb, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x93e7, 0xfffd, 0x9374, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x92d5, 0xfffd, 0xe84b, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9262, 0xe847, 0xfffd, 0xfffd, 0xfffd,
    0xe848, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8c4c, 0xfffd, 0xe84a, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8cae, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe849, 0xfffd, 0x8fdf, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8a99, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe84f, 0xfffd, 0x8dbd, 0x9199,
    0xfffd, 0xfffd, 0x92c8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8a5a,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe84d, 0xe84e, 0x92c1, 0xfffd,
    0xe84c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe850, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe856, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe859, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe858, 0x934c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe851, 0xe852,
    0xe855, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe857, 0xfffd, 0xfffd,
    0xfffd, 0x8bbe, 0xfffd, 0xfffd, 0xe85a, 0xe854, 0xfffd, 0xfffd,
    0xe853, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe85e, 0xfffd, 0xfffd, 0xfffd, 0xe85f,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe860, 0xfffd, 0xfffd, 0xe85d, 0xe85c, 0xfffd, 0xfffd, 0xfffd,
    0x8fe0, 0x93a8, 0xe85b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe864, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe862, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe863, 0xe861, 0xfffd,
    0x91f6, 0xfffd, 0xe865, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe866, 0xfffd, 0xfffd, 0xe868, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8ad3, 0xe867, 0x96f8, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe873, 0xe869, 0xfffd, 0xfffd, 0xe86c, 0xfffd,
    0xe86a, 0xfffd, 0xe86b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xe86d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe86f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe870, 0xfffd, 0xe871,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe874, 0xe872, 0xe875, 0xe877,
    0xfffd, 0xe876, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x92b7,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x96e5, 0xfffd, 0xe878, 0x914d, 0xfffd, 0xfffd, 0xfffd, 0xe879,
    0xfffd, 0x95c2, 0xe87a, 0x8a4a, 0xfffd, 0xfffd, 0xfffd, 0x895b,
    0xfffd, 0x8ad5, 0xfffd, 0x8ad4, 0xe87b, 0xfffd, 0xe87c, 0xfffd,
    0xe87d, 0xe87e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe880, 0xfffd, 0x8ad6, 0x8a74, 0x8d7d, 0x94b4, 0xfffd, 0xe882,
    0xe881, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe883, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x897b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe886, 0xfffd, 0xe885, 0xe884, 0xfffd, 0xe887, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe88a, 0xfffd, 0xfffd, 0xfffd, 0x88c5,
    0xfffd, 0xfffd, 0xe888, 0xfffd, 0xe88c, 0xe88b, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe88e, 0xe88d, 0xe88f, 0xfffd,
    0x93ac, 0xfffd, 0xfffd, 0xfffd, 0xe890, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe891, 0xe893, 0xfffd, 0xfffd, 0xe892, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x958c, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe894, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe895, 0xfffd, 0x8de3, 0xfffd, 0xfffd, 0xfffd, 0xe896, 0xe897,
    0xfffd, 0xfffd, 0x9668, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x916a, 0xfffd, 0xfffd, 0xfffd, 0x88a2,
    0x91c9, 0xfffd, 0xe898, 0xfffd, 0x958d, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe89b, 0xe899, 0x8d7e, 0xfffd, 0xe89a,
    0x8cc0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x95c3, 0xe89d, 0xe89f, 0xe89e, 0xe8a0,
    0xfffd, 0xfffd, 0x8940, 0x9077, 0x8f9c, 0x8ad7, 0xe8a1, 0xfffd,
    0xfffd, 0xfffd, 0x9486, 0xfffd, 0xe8a3, 0xfffd, 0xfffd, 0xfffd,
    0x8941, 0xfffd, 0xe8a2, 0x92c2, 0xfffd, 0x97cb, 0x93a9, 0xe89c,
    0x97a4, 0xfffd, 0x8caf, 0xfffd, 0xfffd, 0x977a, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8bf7, 0x97b2, 0xfffd,
    0x8c47, 0xfffd, 0x91e0, 0xe440, 0xfffd, 0xe8a4, 0x8a4b, 0x908f,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8a75, 0xe8a6, 0xfffd, 0xe8a7,
    0xe8a5, 0x8c84, 0xfffd, 0x8ddb, 0x8fe1, 0xfffd, 0xfffd, 0xfffd,
    0x8942, 0xfffd, 0xfffd, 0x97d7, 0xfffd, 0xfffd, 0xfffd, 0xe8a9,
    0xe7ac, 0xfffd, 0xe8a8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe8ac, 0xe8aa, 0xe8ab, 0xfffd, 0xe8ad, 0xfffd, 0xe8ae, 0x97ea,
    0xe8af, 0xe8b0, 0xfffd, 0x90c7, 0x94b9, 0xfffd, 0xfffd, 0xfffd,
    0x909d, 0x8ae5, 0xfffd, 0xfffd, 0x9759, 0x89eb, 0x8f57, 0x8cd9,
    0xfffd, 0xe8b3, 0xfffd, 0xe8b2, 0x8e93, 0xe8b4, 0xe8b1, 0xfffd,
    0xfffd, 0x8e47, 0xfffd, 0xfffd, 0xfffd, 0xe8b8, 0xe5ab, 0xfffd,
    0xfffd, 0x99d4, 0xfffd, 0x9097, 0xe8b6, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x97a3, 0x93ef, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x894a, 0xfffd, 0x90e1, 0x8eb4, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x95b5, 0xfffd, 0x895f, 0xfffd, 0xfffd, 0xfffd, 0x97eb, 0x978b,
    0xfffd, 0xe8b9, 0xfffd, 0x9364, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8ef9, 0xfffd, 0xfffd, 0xfffd, 0xe8ba, 0xfffd, 0xe8bb, 0x906b,
    0xe8bc, 0xfffd, 0x97ec, 0xfffd, 0xfffd, 0xe8b7, 0xe8be, 0xe8c0,
    0xfffd, 0xe8bf, 0xfffd, 0xe8bd, 0xfffd, 0xfffd, 0xe8c1, 0xfffd,
    0xfffd, 0xe8c2, 0xfffd, 0xfffd, 0x919a, 0xfffd, 0x89e0, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe8c3, 0xfffd, 0xfffd, 0x96b6,
    0xfffd, 0xfffd, 0xe8c4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe8c5, 0xfffd, 0x9849, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9e50, 0xe8c6, 0xfffd, 0xfffd, 0xfffd, 0xe8c7, 0xe8c8, 0xfffd,
    0xfffd, 0xfffd, 0xe8cc, 0xfffd, 0xe8c9, 0xfffd, 0xe8ca, 0xfffd,
    0xe8cb, 0xe8cd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x90c2, 0xfffd, 0xfffd, 0xfffd, 0x96f5, 0xfffd,
    0xfffd, 0x90c3, 0xfffd, 0xfffd, 0xe8ce, 0xfffd, 0x94f1, 0xfffd,
    0xe8cf, 0xea72, 0x96ca, 0xfffd, 0xe8d0, 0xfffd, 0xe8d1, 0xfffd,
    0xe8d2, 0x8a76, 0xfffd, 0xe8d4, 0xfffd, 0x9078, 0xfffd, 0xfffd,
    0xfffd, 0xe8d5, 0xfffd, 0xfffd, 0x8c43, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe8d6, 0xe8da, 0xfffd, 0xe8d8, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe8d9, 0xfffd, 0xfffd, 0x8a93, 0xe8d7, 0xe8db, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe8dc, 0xfffd, 0x88c6, 0xfffd, 0xe8dd,
    0xe8de, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8fe2, 0xfffd, 0xfffd, 0xfffd, 0xe8df, 0xfffd, 0xfffd, 0xfffd,
    0x8b66, 0xfffd, 0xfffd, 0xe8e2, 0xfffd, 0xfffd, 0xe8e1, 0xfffd,
    0xe8e0, 0xfffd, 0xfffd, 0xe691, 0xfffd, 0x95da, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe8e3, 0xe8e4, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe8e5, 0xfffd, 0xfffd, 0xe8e6, 0xfffd,
    0xe8e7, 0xfffd, 0xfffd, 0xe8e8, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8ad8, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe8e9, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe8ea, 0x9442, 0xfffd,
    0xfffd, 0xfffd, 0xe8ec, 0x89b9, 0xfffd, 0xe8ef, 0xe8ee, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8943, 0xfffd, 0xfffd, 0xfffd, 0x8bbf,
    0xfffd, 0x95c5, 0x92b8, 0x8da0, 0xfffd, 0x8d80, 0x8f87, 0xfffd,
    0x907b, 0xfffd, 0xfffd, 0xfffd, 0xe8f1, 0xfffd, 0xfffd, 0xe8f0,
    0x9761, 0x8ae6, 0x94d0, 0x93da, 0xfffd, 0xfffd, 0xfffd, 0x909c,
    0x97cc, 0xfffd, 0x8c7a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe8f4, 0xfffd, 0xfffd, 0xe8f3, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x966a, 0x93aa, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x896f, 0xfffd, 0xfffd, 0xe8f5,
    0xe8f2, 0xfffd, 0xfffd, 0x9570, 0x978a, 0xe8f6, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe8f7, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe8f9, 0x91e8, 0x8a7a, 0x8a7b, 0xe8f8,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8ae7, 0x8cb0, 0xfffd, 0xfffd,
    0x8ae8, 0xfffd, 0xfffd, 0x935e, 0xfffd, 0xfffd, 0x97de, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8cda,
    0xfffd, 0xfffd, 0xfffd, 0xe8fa, 0xfffd, 0xfffd, 0xfffd, 0xe8fb,
    0xe8fc, 0xe940, 0xfffd, 0xe942, 0xe941, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9597, 0xfffd, 0xe943, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe944,
    0xfffd, 0xe945, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe946, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe948, 0xe947, 0xfffd, 0xe949, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x94f2, 0xe3ca, 0xfffd, 0xfffd, 0x9048,
    0xfffd, 0xfffd, 0x8b51, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe94a, 0xfffd, 0xe94b, 0xfffd, 0x99aa, 0x9f5a, 0x94d1,
    0xfffd, 0xfffd, 0x88f9, 0xfffd, 0x88b9, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8e94, 0x964f, 0x8ffc, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe94c, 0xfffd, 0x96dd, 0xfffd, 0xfffd,
    0xfffd, 0xe94d, 0x977b, 0xfffd, 0x8961, 0xfffd, 0xfffd, 0xfffd,
    0x8e60, 0xfffd, 0xe94e, 0x89ec, 0xe94f, 0xfffd, 0xfffd, 0xfffd,
    0xe950, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe952, 0xe953, 0xfffd,
    0xe955, 0xe951, 0xfffd, 0xfffd, 0xe954, 0xfffd, 0xfffd, 0xfffd,
    0x8ad9, 0xfffd, 0xfffd, 0xfffd, 0xe956, 0xfffd, 0xe957, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe958, 0xe959, 0xfffd,
    0xfffd, 0xfffd, 0xe95a, 0xfffd, 0xfffd, 0xe95c, 0xfffd, 0xfffd,
    0xfffd, 0xe95b, 0xfffd, 0xe95e, 0xe961, 0xfffd, 0xfffd, 0xfffd,
    0xe95d, 0xe95f, 0xe960, 0xfffd, 0xfffd, 0xe962, 0xfffd, 0x8bc0,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8ef1, 0xe963,
    0xe964, 0x8d81, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe965, 0xfffd, 0xfffd,
    0x8a5d, 0xfffd, 0xfffd, 0xfffd, 0x946e, 0xe966, 0xe967, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9279, 0x93e9, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe968, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x949d, 0xfffd, 0xfffd, 0x91ca, 0x8977, 0x8bec, 0xfffd,
    0x8bed, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x9293, 0xe96d, 0x8bee, 0xfffd, 0xfffd, 0x89ed, 0xfffd, 0xfffd,
    0xe96c, 0xfffd, 0xfffd, 0xe96a, 0xfffd, 0xe96b, 0xfffd, 0xe969,
    0xfffd, 0xfffd, 0xe977, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe96e, 0xe96f, 0xfffd,
    0xfffd, 0xe970, 0xe971, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe973, 0xfffd, 0xfffd, 0xe972, 0xfffd, 0xfffd, 0xfffd, 0x8f78,
    0xfffd, 0xe974, 0xfffd, 0xfffd, 0xfffd, 0xe976, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8b52, 0xe975,
    0xfffd, 0xfffd, 0x919b, 0x8cb1, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe978, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x91cb, 0xfffd, 0xfffd, 0xe979, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x93ab, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe97a,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe980, 0xfffd,
    0xe97d, 0xfffd, 0xe97c, 0xe97e, 0xfffd, 0xe97b, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe982, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe981, 0xfffd, 0xe984,
    0xfffd, 0xfffd, 0x8bc1, 0xe983, 0xfffd, 0xfffd, 0xfffd, 0xe985,
    0xfffd, 0xfffd, 0xe986, 0xfffd, 0xe988, 0xe987, 0xfffd, 0xfffd,
    0xfffd, 0xe989, 0xe98b, 0xe98a, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8d9c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe98c, 0xfffd, 0xfffd,
    0xe98d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x8a5b, 0xfffd, 0xfffd, 0xfffd, 0xe98e, 0xfffd, 0xfffd, 0xfffd,
    0xe98f, 0xfffd, 0xfffd, 0xfffd, 0x9091, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe990,
    0xfffd, 0xe991, 0xfffd, 0xe992, 0xe993, 0xfffd, 0xfffd, 0xfffd,
    0x8d82, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe994, 0xe995,
    0xfffd, 0xfffd, 0xe996, 0xe997, 0xfffd, 0xfffd, 0xe998, 0xfffd,
    0xfffd, 0xfffd, 0x94af, 0xe99a, 0xfffd, 0x9545, 0xe99b, 0xe999,
    0xfffd, 0xe99d, 0xfffd, 0xfffd, 0xe99c, 0xfffd, 0xfffd, 0xe99e,
    0xfffd, 0xfffd, 0xfffd, 0xe99f, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe9a0, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe9a1, 0xfffd, 0xe9a2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe9a3,
    0xfffd, 0xfffd, 0xe9a4, 0xe9a5, 0xfffd, 0xe9a6, 0xfffd, 0xe9a7,
    0xe9a8, 0xe9a9, 0xe9aa, 0xfffd, 0xfffd, 0xfffd, 0xe9ab, 0xe9ac,
    0xfffd, 0x9f54, 0xe9ad, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe2f6, 0x8b53, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8a40, 0x8db0, 0xe9af, 0xe9ae, 0x96a3, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe9b1, 0xe9b2, 0xe9b0,
    0xfffd, 0xe9b3, 0xfffd, 0xfffd, 0x9682, 0xfffd, 0xfffd, 0xfffd,
    0xe9b4, 0xfffd, 0x8b9b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9844,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe9b5, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe9b7, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x88bc, 0xfffd,
    0xfffd, 0xe9b8, 0x95a9, 0xe9b6, 0xfffd, 0xfffd, 0xe9b9, 0xe9ba,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe9bb,
    0xe9bc, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe9bd, 0xfffd, 0x968e, 0x8e4c, 0xfffd, 0x8df8, 0x914e, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe9be, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe9c1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe9bf, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe9c2, 0xfffd,
    0xfffd, 0x8cef, 0xe9c0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe9c3,
    0xfffd, 0xe9c4, 0xe9c5, 0xfffd, 0xe9c9, 0xfffd, 0x8e49, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x91e2, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe9ca, 0xe9c7, 0xe9c6, 0xe9c8, 0xfffd, 0xfffd, 0xfffd,
    0x8c7e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe9ce, 0xe9cd, 0xe9cc, 0xfffd, 0xfffd, 0x88b1, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe9d8, 0xfffd, 0xe9d4, 0xfffd,
    0xe9d5, 0xe9d1, 0xe9d7, 0xfffd, 0xe9d3, 0x8a82, 0xfffd, 0xfffd,
    0x986b, 0xfffd, 0xe9d6, 0xe9d2, 0xe9d0, 0xe9cf, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe9da, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xe9dd, 0xfffd, 0xfffd, 0xe9dc, 0xe9db, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9568, 0xe9d9, 0x88f1,
    0xe9de, 0xfffd, 0xe9e0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x8a8f, 0xe9cb, 0x8956, 0xfffd, 0xfffd, 0xe9e2, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe9e1, 0xe9df,
    0x924c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0x9690, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x97d8,
    0xfffd, 0xfffd, 0xe9e3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xe9e4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe9e5,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xe9e6, 0xfffd,
    0xe9e7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x92b9, 0xfffd, 0xe9e8,
    0xfffd, 0x94b5, 0xfffd, 0xe9ed, 0xe9e9, 0xfffd, 0xfffd, 0xfffd,
    0xe9ea, 0xfffd, 0xfffd, 0x9650, 0x96c2, 0xfffd, 0x93ce, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xe9ee, 0xfffd, 0xfffd, 0xe9ef, 0x93bc,
    0xe9ec, 0xe9eb, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x89a8, 0xfffd,
    0xfffd, 0xfffd, 0xe9f7, 0xfffd, 0xfffd, 0xe9f6, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8995, 0xfffd, 0xfffd, 0xfffd, 0xe9f4,
    0xfffd, 0xfffd, 0xfffd, 0xe9f3, 0xfffd, 0xfffd, 0xe9f1, 0xfffd,
    0x8a9b, 0xfffd, 0xe9f0, 0x8eb0, 0x89a7, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8d83, 0xfffd, 0xfffd, 0xe9fa, 0xe9f9,
    0xfffd, 0xe9f8, 0xfffd, 0xfffd, 0xe9f5, 0xfffd, 0xe9fb, 0xfffd,
    0xe9fc, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xea44, 0xea43, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xea45, 0xfffd, 0xfffd, 0x894c, 0xea40, 0xea41, 0xfffd,
    0x8d94, 0x96b7, 0xfffd, 0xfffd, 0xea42, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9651, 0xfffd, 0xfffd, 0xea4a,
    0xfffd, 0xfffd, 0xea46, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xea4b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea48,
    0xfffd, 0xea47, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8c7b,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xea4c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea4d, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xea4e, 0xfffd, 0xea49, 0xfffd, 0xfffd, 0xfffd, 0xe9f2,
    0xfffd, 0xfffd, 0xea4f, 0xfffd, 0x92df, 0xfffd, 0xfffd, 0xfffd,
    0xea53, 0xfffd, 0xea54, 0xea52, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xea51, 0xea57, 0xfffd, 0xea50, 0xfffd, 0xea55, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea56,
    0xfffd, 0xfffd, 0xfffd, 0xea59, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xea58, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea5b, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea5c, 0xfffd, 0xea5d,
    0xfffd, 0xfffd, 0x9868, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xea5a, 0x91e9, 0x8deb, 0xfffd, 0xfffd, 0xea5e, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xea5f, 0xea60, 0xfffd, 0xfffd, 0xea61, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea62, 0xfffd, 0xfffd,
    0x8cb2, 0xea63, 0xfffd, 0xfffd, 0xfffd, 0xea64, 0xfffd, 0x8ead,
    0xfffd, 0xea65, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xea66, 0xfffd, 0xfffd, 0xea67, 0xea68, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xea6b, 0xea69, 0x985b, 0xfffd, 0xea6a, 0xfffd, 0x97ed,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea6c, 0xfffd, 0x97d9,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea6d, 0x949e, 0xfffd,
    0xfffd, 0xea6e, 0xea70, 0xfffd, 0xfffd, 0xea71, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xea6f, 0x8d8d, 0x96cb, 0x9683, 0x9bf5, 0xfffd, 0x9f80, 0x969b,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x89a9, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea73, 0x8b6f, 0xea74, 0xea75,
    0xea76, 0xfffd, 0x8d95, 0xfffd, 0xea77, 0xfffd, 0xfffd, 0xfffd,
    0xe0d2, 0x96d9, 0xfffd, 0x91e1, 0xea78, 0xea7a, 0xea79, 0xfffd,
    0xea7b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea7c, 0xfffd, 0xfffd,
    0xea7d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea7e,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea80, 0xfffd, 0xea81, 0xea82,
    0xfffd, 0xea83, 0xfffd, 0xea84, 0xea85, 0xea86, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea87,
    0xea88, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9343, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x8cdb, 0xfffd, 0xea8a, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x916c, 0xea8b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea8c, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x9540, 0xfffd, 0xfffd, 0xea8d, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xea8e, 0xe256, 0xfffd, 0xfffd, 0xe6d8, 0xe8eb,
    0xfffd, 0xfffd, 0xea8f, 0xfffd, 0xea90, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea92,
    0xea93, 0xea94, 0x97ee, 0xea91, 0xfffd, 0xfffd, 0xea95, 0xea96,
    0xfffd, 0xfffd, 0xea98, 0xfffd, 0xea97, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xea9a, 0xfffd, 0xfffd, 0xfffd, 0xea9b, 0xea99,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x97b4, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea9c, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xea9d, 0xe273, 0xfffd, 0xfffd,
    0xea9e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};

#endif /* KANJI */

/* Blah-to-Unicode translation tables */

struct x_to_unicode u_transparent = {
    256, X2U_CXG, 0, 0, "Transparent", "transparent", 0, "",
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
    0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
    0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F,
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
    0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
    0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
    0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F,
    0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
    0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
    0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
    0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
    0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7,
    0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,
    0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7,
    0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF,
    0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
    0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF,
    0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7,
    0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
    0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7,
    0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF,
    0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
    0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF
};

/* 7-bit character sets: ISO 646, DEC NRCs, Short KOI, and Hebrew-7 */

struct x_to_unicode u_ascii = {
    94, 33, X2U_ISO|X2U_STD, AL_ROMAN, "US ASCII", "ascii", 6, "B",
	    0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e
};

struct x_to_unicode u_british = {
    94, 33, X2U_ISO|X2U_STD, AL_ROMAN, "British ISO 646", "british", 1, "A",
	    0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e
};

struct x_to_unicode u_dutch = {
    94, 33, X2U_DEC|X2U_STD, AL_ROMAN, "Dutch NRC", "dutch", 0, "4",
	    0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x00be, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00ff, 0x00bd, 0x007c, 0x005e, 0x005f,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00a8, 0x00a4, 0x00bc, 0x0027
};

struct x_to_unicode u_finnish = {
    94, 33, X2U_DEC|X2U_STD, AL_ROMAN, "Finnish NRC", "finnish", 0, "5C",
	    0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00c4, 0x00d6, 0x00c5, 0x00dc, 0x005f,
    0x00e9, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00e4, 0x00f6, 0x00e5, 0x00fc
};

struct x_to_unicode u_french = {
    94, 33, X2U_ISO|X2U_STD, AL_ROMAN, "French ISO 646", "french", 0, "fR",
	    0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x00e0, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00b0, 0x00e7, 0x00a7, 0x005e, 0x005f,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00e9, 0x00f9, 0x00e8, 0x00a8
};

struct x_to_unicode u_fr_canadian = {
 94,33,X2U_DEC|X2U_STD,AL_ROMAN,"French Canadian NRC","canadian-french",0,"9Q",
	    0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x00e0, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00e2, 0x00e7, 0x00ea, 0x00ee, 0x005f,
    0x00f4, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00e9, 0x00f9, 0x00e8, 0x00fb
};

struct x_to_unicode u_german = {
    94, 33, X2U_ISO|X2U_STD, AL_ROMAN, "German ISO 646", "german", 21, "K",
	    0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x00a7, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00c4, 0x00d6, 0x00dc, 0x005e, 0x005f,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00e4, 0x00f6, 0x00fc, 0x00df
};

struct x_to_unicode u_hungarian = {
    94, 33, X2U_ISO|X2U_STD, AL_ROMAN, "Hungarian ISO 646","hungarian",86,"i",
	    0x0021, 0x0022, 0x0023, 0x00a4, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x00c1, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00c9, 0x00d6, 0x00dc, 0x005e, 0x005f,
    0x00e1, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00e9, 0x00f6, 0x00fc, 0x0022, 0x02dd
};

struct x_to_unicode u_italian = {
    94, 33, X2U_ISO|X2U_STD, AL_ROMAN, "Italian ISO 646", "italian", 15, "Y",
	    0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x00a7, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00b0, 0x00e7, 0x00e9, 0x005e, 0x005f,
    0x00f9, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00e0, 0x00f2, 0x00e8, 0x00ec
};

struct x_to_unicode u_icelandic = {
    94, 33, X2U_DEC|X2U_STD, AL_ROMAN, "Icelandic NRC", "icelandic", 0, NULL,
	    0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x00de, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00f0, 0x00d8, 0x00c6, 0x00d6, 0x005f,
    0x00fe, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00f0, 0x007c, 0x00e6, 0x00f6
};

struct x_to_unicode u_jis0201r = {
    94, 33, X2U_ISO|X2U_STD,AL_ROMAN,"Japanese Roman","japanese-roman",14,"J",
	    0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x00a5, 0x005d, 0x005e, 0x005f,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x203e
};

struct x_to_unicode u_jis0201k = {
    94, 33, X2U_ISO|X2U_STD,AL_KANA,"Japanese Katakana", "katakana", 13, "I",
	    0xff61, 0xff62, 0xff63, 0xff64, 0xff65, 0xff66, 0xff67,
    0xff68, 0xff69, 0xff6a, 0xff6b, 0xff6c, 0xff6d, 0xff6e, 0xff6f,
    0xff70, 0xff71, 0xff72, 0xff73, 0xff74, 0xff75, 0xff76, 0xff77,
    0xff78, 0xff79, 0xff7a, 0xff7b, 0xff7c, 0xff7d, 0xff7e, 0xff7f,
    0xff80, 0xff81, 0xff82, 0xff83, 0xff84, 0xff85, 0xff86, 0xff87,
    0xff88, 0xff89, 0xff8a, 0xff8b, 0xff8c, 0xff8d, 0xff8e, 0xff8f,
    0xff90, 0xff91, 0xff92, 0xff93, 0xff94, 0xff95, 0xff96, 0xff97,
    0xff98, 0xff99, 0xff9a, 0xff9b, 0xff9c, 0xff9d, 0xff9e, 0xff9f,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd
};

struct x_to_unicode u_norwegian = {	/* Same as Danish */
    94,33,X2U_ISO|X2U_STD,AL_ROMAN,"Norwegian ISO 646", "norwegian", 60, "`E6",
	    0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00c6, 0x00d8, 0x00c5, 0x005e, 0x005f,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00e6, 0x00f8, 0x00e5, 0x007e
};

struct x_to_unicode u_danish = {	/* Same as Norwegian */
    94, 33, X2U_ISO|X2U_STD, AL_ROMAN, "Danish ISO 646", "danish", 60, "`E6",
	    0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00c6, 0x00d8, 0x00c5, 0x005e, 0x005f,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00e6, 0x00f8, 0x00e5, 0x007e
};

struct x_to_unicode u_portuguese = {
    94,33,X2U_ISO|X2U_STD,AL_ROMAN,"Portuguese ISO 646","portuguese",16,"L%6",
	    0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00c6, 0x00d8, 0x00c5, 0x005e, 0x005f,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00e6, 0x00f8, 0x00e5, 0x007e
};

struct x_to_unicode u_spanish = {
    94, 33, X2U_ISO|X2U_STD, AL_ROMAN, "Spanish ISO 646", "spanish", 17, "Z",
	    0x0021, 0x0022, 0x00a3, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x00a7, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00a1, 0x00d1, 0x00bf, 0x005e, 0x005f,
    0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00b0, 0x00f1, 0x00e7, 0x007e
};

struct x_to_unicode u_swedish = {
    94, 33, X2U_ISO|X2U_STD, AL_ROMAN, "Swedish ISO 646", "swedish", 11, "HG",
	    0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x00c9, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00c4, 0x00d6, 0x00c5, 0x00dc, 0x005f,
    0x00e9, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00e4, 0x00f6, 0x00e5, 0x00fc
};

struct x_to_unicode u_swiss = {
    94, 33, X2U_DEC|X2U_STD, AL_ROMAN, "Swiss NRC", "swiss", 0, "=",
	    0x0021, 0x0022, 0x00f9, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x00e0, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x00e9, 0x00e7, 0x00ea, 0x00ee, 0x00e8,
    0x00f4, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007a, 0x00e4, 0x00f6, 0x00fc, 0x00fb
};

struct x_to_unicode u_koi7 = {
    94, 33, X2U_STD, AL_CYRIL, "Short KOI", "short-koi", 0, NULL,
	    0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
    0x042e, 0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413,
    0x0425, 0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e,
    0x041f, 0x042f, 0x0420, 0x0421, 0x0422, 0x0423, 0x0416, 0x0412,
    0x042c, 0x042b, 0x0417, 0x0428, 0x042d, 0x0429, 0x0427
};

struct x_to_unicode u_elot927 = {
    94, 33, X2U_STD, AL_GREEK, "ELOT 927", "elot927-greek", 0, NULL,
	    0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
    0x0060, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397,
    0x0398, 0x0399, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f,
    0x03a0, 0x03a1, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8,
    0x03a9, 0x0020, 0x0020, 0x007b, 0x007c, 0x007d, 0x007e
};


struct x_to_unicode u_hebrew7 = {
    94, 33, X2U_STD, AL_HEBREW, "Hebrew-7", "hebrew-7", 0, NULL,
	    0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
    0x05d0, 0x05d1, 0x05d2, 0x05d3, 0x05d4, 0x05d5, 0x05d6, 0x05d7,
    0x05d8, 0x05d9, 0x05da, 0x05db, 0x05dc, 0x05dd, 0x05de, 0x05df,
    0x05e0, 0x05e1, 0x05e2, 0x05e3, 0x05e4, 0x05e5, 0x05e6, 0x05e7,
    0x05e8, 0x05e9, 0x05ea, 0x007b, 0x007c, 0x007d, 0x007e
};

/* ISO 8859 Latin Alphabets */

struct x_to_unicode u_8859_1 = {
    96, 32, X2U_ISO|X2U_STD, AL_ROMAN, "ISO Latin-1", "latin1", 100, "A",
    0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
    0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF,
    0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
    0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
    0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF,
    0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
    0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
    0x00F0, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
    0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x00FF
};

struct x_to_unicode u_8859_2 = {
    96, 32, X2U_ISO|X2U_STD, AL_ROMAN, "ISO Latin-2", "latin2", 101, "B",
    0x00A0, 0x0104, 0x02D8, 0x0141, 0x00A4, 0x013D, 0x015A, 0x00A7,
    0x00A8, 0x0160, 0x015E, 0x0164, 0x0179, 0x00AD, 0x017D, 0x017B,
    0x00B0, 0x0105, 0x02DB, 0x0142, 0x00B4, 0x013E, 0x015B, 0x02C7,
    0x00B8, 0x0161, 0x015F, 0x0165, 0x017A, 0x02DD, 0x017E, 0x017C,
    0x0154, 0x00C1, 0x00C2, 0x0102, 0x00C4, 0x0139, 0x0106, 0x00C7,
    0x010C, 0x00C9, 0x0118, 0x00CB, 0x011A, 0x00CD, 0x00CE, 0x010E,
    0x0110, 0x0143, 0x0147, 0x00D3, 0x00D4, 0x0150, 0x00D6, 0x00D7,
    0x0158, 0x016E, 0x00DA, 0x0170, 0x00DC, 0x00DD, 0x0162, 0x00DF,
    0x0155, 0x00E1, 0x00E2, 0x0103, 0x00E4, 0x013A, 0x0107, 0x00E7,
    0x010D, 0x00E9, 0x0119, 0x00EB, 0x011B, 0x00ED, 0x00EE, 0x010F,
    0x0111, 0x0144, 0x0148, 0x00F3, 0x00F4, 0x0151, 0x00F6, 0x00F7,
    0x0159, 0x016F, 0x00FA, 0x0171, 0x00FC, 0x00FD, 0x0163, 0x02D9
};

struct x_to_unicode u_8859_3 = {
    96, 32, X2U_ISO|X2U_STD, AL_ROMAN, "ISO Latin-3", "latin3", 109, "C",
    0x00A0, 0x0126, 0x02D8, 0x00A3, 0x00A4, 0xfffd, 0x0124, 0x00A7,
    0x00A8, 0x0130, 0x015E, 0x011E, 0x0134, 0x00AD, 0xfffd, 0x017B,
    0x00B0, 0x0127, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x0125, 0x00B7,
    0x00B8, 0x0131, 0x015F, 0x011F, 0x0135, 0x00BD, 0xfffd, 0x017C,
    0x00C0, 0x00C1, 0x00C2, 0xfffd, 0x00C4, 0x010A, 0x0108, 0x00C7,
    0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
    0xfffd, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x0120, 0x00D6, 0x00D7,
    0x011C, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x016C, 0x015C, 0x00DF,
    0x00E0, 0x00E1, 0x00E2, 0xfffd, 0x00E4, 0x010B, 0x0109, 0x00E7,
    0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
    0xfffd, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x0121, 0x00F6, 0x00F7,
    0x011D, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x016D, 0x015D, 0x02D9
};

struct x_to_unicode u_8859_4 = {
    96, 32, X2U_ISO|X2U_STD, AL_ROMAN, "ISO Latin-4", "latin4", 110, "D",
    0x00A0, 0x0104, 0x0138, 0x0156, 0x00A4, 0x0128, 0x013B, 0x00A7,
    0x00A8, 0x0160, 0x0112, 0x0122, 0x0166, 0x00AD, 0x017D, 0x00AF,
    0x00B0, 0x0105, 0x02DB, 0x0157, 0x00B4, 0x0129, 0x013C, 0x02C7,
    0x00B8, 0x0161, 0x0113, 0x0123, 0x0167, 0x014A, 0x017E, 0x014B,
    0x0100, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x012E,
    0x010C, 0x00C9, 0x0118, 0x00CB, 0x0116, 0x00CD, 0x00CE, 0x012A,
    0x0110, 0x0145, 0x014C, 0x0136, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x0172, 0x00DA, 0x00DB, 0x00DC, 0x0168, 0x016A, 0x00DF,
    0x0101, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x012F,
    0x010D, 0x00E9, 0x0119, 0x00EB, 0x0117, 0x00ED, 0x00EE, 0x012B,
    0x0111, 0x0146, 0x014D, 0x0137, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
    0x00F8, 0x0173, 0x00FA, 0x00FB, 0x00FC, 0x0169, 0x016B, 0x02D9
};

struct x_to_unicode u_8859_5 = {
    96,32,X2U_ISO|X2U_STD,AL_CYRIL,"ISO Latin/Cyrillic","cyrillic-iso",144,"L",
    0x00A0, 0x0401, 0x0402, 0x0403, 0x0404, 0x0405, 0x0406, 0x0407,
    0x0408, 0x0409, 0x040A, 0x040B, 0x040C, 0x00AD, 0x040E, 0x040F,
    0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
    0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F,
    0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
    0x0428, 0x0429, 0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F,
    0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
    0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E, 0x043F,
    0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
    0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F,
    0x2116, 0x0451, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457,
    0x0458, 0x0459, 0x045A, 0x045B, 0x045C, 0x00A7, 0x045E, 0x045F
};

struct x_to_unicode u_8859_6 = {
    96, 32, X2U_ISO|X2U_STD,AL_ARABIC,"ISO Latin/Arabic","arabic-iso",127,"G",
    0x00A0, 0xfffd, 0xfffd, 0xfffd, 0x00A4, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x060C, 0x00AD, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0x061B, 0xfffd, 0xfffd, 0xfffd, 0x061F,
    0xfffd, 0x0621, 0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0627,
    0x0628, 0x0629, 0x062A, 0x062B, 0x062C, 0x062D, 0x062E, 0x062F,
    0x0630, 0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x0637,
    0x0638, 0x0639, 0x063A, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x0640, 0x0641, 0x0642, 0x0643, 0x0644, 0x0645, 0x0646, 0x0647,
    0x0648, 0x0649, 0x064A, 0x064B, 0x064C, 0x064D, 0x064E, 0x064F,
    0x0650, 0x0651, 0x0652, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd
};

struct x_to_unicode u_8859_7 = {
    96, 32, X2U_ISO|X2U_STD,AL_GREEK,"ISO Latin/Greek", "greek-iso", 126, "F",
    0x00A0, 0x2018, 0x2019, 0x00A3, 0xFFFD, 0xFFFD, 0x00A6, 0x00A7,
    0x00A8, 0x00A9, 0xFFFD, 0x00AB, 0x00AC, 0x00AD, 0xFFFD, 0x2015,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x0384, 0x0385, 0x0386, 0x00B7,
    0x0388, 0x0389, 0x038A, 0x00BB, 0x038C, 0x00BD, 0x038E, 0x038F,
    0x0390, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397,
    0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F,
    0x03A0, 0x03A1, 0xfffd, 0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7,
    0x03A8, 0x03A9, 0x03AA, 0x03AB, 0x03AC, 0x03AD, 0x03AE, 0x03AF,
    0x03B0, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7,
    0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF,
    0x03C0, 0x03C1, 0x03C2, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7,
    0x03C8, 0x03C9, 0x03CA, 0x03CB, 0x03CC, 0x03CD, 0x03CE, 0xfffd
};

struct x_to_unicode u_8859_8 = {
    96, 32, X2U_ISO|X2U_STD,AL_HEBREW,"ISO Latin/Hebrew","hebrew-iso",121,"H",
    0x00A0, 0xfffd, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
    0x00A8, 0x00A9, 0x00D7, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x203E,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00B8, 0x00B9, 0x00F7, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x2017,
    0x05D0, 0x05D1, 0x05D2, 0x05D3, 0x05D4, 0x05D5, 0x05D6, 0x05D7,
    0x05D8, 0x05D9, 0x05DA, 0x05DB, 0x05DC, 0x05DD, 0x05DE, 0x05DF,
    0x05E0, 0x05E1, 0x05E2, 0x05E3, 0x05E4, 0x05E5, 0x05E6, 0x05E7,
    0x05E8, 0x05E9, 0x05EA, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd
};

struct x_to_unicode u_8859_9 = {
    96, 32, X2U_ISO|X2U_STD, AL_ROMAN, "ISO Latin-5", "latin5", 148, "M",
    0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
    0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF,
    0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
    0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
    0x011E, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x0130, 0x015E, 0x00DF,
    0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
    0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
    0x011F, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
    0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x0131, 0x015F, 0x00FF
};

struct x_to_unicode u_8859_10 = {
    96, 32, X2U_ISO|X2U_STD, AL_ROMAN, "ISO Latin-6", "latin6", 157, "V",
    0x00a0, 0x0104, 0x0112, 0x0122, 0x012a, 0x0128, 0x0136, 0x013b,
    0x0143, 0x0156, 0x0160, 0x0166, 0x017d, 0x00ad, 0x0138, 0x014a,
    0x0111, 0x0105, 0x0113, 0x0123, 0x012b, 0x0129, 0x0137, 0x013c,
    0x0144, 0x0157, 0x0161, 0x0167, 0x017e, 0x00bd, 0x00be, 0x014b,
    0x0100, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c6, 0x012e,
    0x010c, 0x00c9, 0x0118, 0x00cb, 0x0116, 0x00cd, 0x00ce, 0x00cf,
    0x0110, 0x0145, 0x014c, 0x00de, 0x00d4, 0x00d5, 0x00d6, 0x0168,
    0x00d8, 0x0172, 0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x016a,
    0x0101, 0x00e1, 0x00e2, 0x00d3, 0x00e4, 0x00e5, 0x00e6, 0x012f,
    0x010d, 0x00e9, 0x0119, 0x00eb, 0x0117, 0x00ed, 0x00ee, 0x00ef,
    0x00f0, 0x00f1, 0x014d, 0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x0169,
    0x00f8, 0x0173, 0x00fa, 0x00fb, 0x00fc, 0x00fd, 0x00fe, 0x016b
};

/* Latin-9 (ISO 8859-15) is the same as Latin-1 with the following changes:
 *   A4 is Euro Symbol           20AC
 *   A6 is Capital S Caron       0160
 *   A8 is Small s caron         0161
 *   B4 is Capital Z caron       017D
 *   B8 is Small z caron         017E
 *   BC is Capital OE ligature   0152
 *   BD is Small oe ligature     0153
 *   BE is Capital Y diaeresis   0178
 */

struct x_to_unicode u_8859_15 = {
    96, 32, X2U_ISO|X2U_STD, AL_ROMAN, "ISO Latin-9", "latin9", 0, NULL,
    0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x20AC, 0x00A5, 0x0160, 0x00A7,
    0x0161, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x017D, 0x00B5, 0x00B6, 0x00B7,
    0x017E, 0x00B9, 0x00BA, 0x00BB, 0x0152, 0x0153, 0x0178, 0x00BF,
    0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
    0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
    0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF,
    0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
    0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
    0x00F0, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
    0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x00FF
};

/* 8-bit GOST standard sets */

struct x_to_unicode u_koi8 = {
    96, 32, X2U_STD, AL_CYRIL, "KOI-8", "koi8", 0, NULL,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x044E, 0x0430, 0x0431, 0x0446, 0x0434, 0x0435, 0x0444, 0x0433,
    0x0445, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E,
    0x043F, 0x044F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0436, 0x0432,
    0x044C, 0x044B, 0x0437, 0x0448, 0x044D, 0x0449, 0x0447, 0x044A,
    0x042E, 0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413,
    0x0425, 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E,
    0x041F, 0x042F, 0x0420, 0x0421, 0x0422, 0x0423, 0x0416, 0x0412,
    0x042C, 0x042B, 0x0417, 0x0428, 0x042D, 0x0429, 0x0427, 0xfffd
};

/* Other KOI-8 based sets */

struct x_to_unicode u_koi8r = {		/* (Russia) Table from RFC1489 */
    128, 0, X2U_CP, AL_CYRIL, "KOI8-R", "koi8r", 0, NULL,
    0x2500, 0x2502, 0x250C, 0x2510, 0x2514, 0x2518, 0x251C, 0x2524,
    0x252C, 0x2534, 0x253C, 0x2580, 0x2584, 0x2588, 0x258C, 0x2590,
    0x2591, 0x2592, 0x2593, 0x2320, 0x25A0, 0x2219, 0x221A, 0x2248,
    0x2264, 0x2265, 0x00A0, 0x2321, 0x00B0, 0x00B2, 0x00B7, 0x00F7,
    0x2550, 0x2551, 0x2552, 0x0451, 0x2553, 0x2554, 0x2555, 0x2556,
    0x2557, 0x2558, 0x2559, 0x255A, 0x255B, 0x255C, 0x255D, 0x255E,
    0x255F, 0x2560, 0x2561, 0x0401, 0x2562, 0x2563, 0x2564, 0x2565,
    0x2566, 0x2567, 0x2568, 0x2569, 0x256A, 0x256B, 0x256C, 0x00A9,
    0x044E, 0x0430, 0x0431, 0x0446, 0x0434, 0x0435, 0x0444, 0x0433,
    0x0445, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E,
    0x043F, 0x044F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0436, 0x0432,
    0x044C, 0x044B, 0x0437, 0x0448, 0x044D, 0x0449, 0x0447, 0x044A,
    0x042E, 0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413,
    0x0425, 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E,
    0x041F, 0x042F, 0x0420, 0x0421, 0x0422, 0x0423, 0x0416, 0x0412,
    0x042C, 0x042B, 0x0417, 0x0428, 0x042D, 0x0429, 0x0427, 0x042A
};

struct x_to_unicode u_koi8u = {		/* (Ukraine) From RFC2319 */
   128, 0, X2U_CP, AL_CYRIL, "KOI8-U", "koi8u", 0, NULL,
    0x2500, 0x2502, 0x250C, 0x2510, 0x2514, 0x2518, 0x251C, 0x2524,
    0x252C, 0x2534, 0x253C, 0x2580, 0x2584, 0x2588, 0x258C, 0x2590,
    0x2591, 0x2592, 0x2593, 0x2320, 0x25A0, 0x2219, 0x221A, 0x2248,
    0x2264, 0x2265, 0x00A0, 0x2321, 0x00B0, 0x00B2, 0x00B7, 0x00F7,
    0x2550, 0x2551, 0x2552, 0x0451, 0x0454, 0x2554, 0x0456, 0x0457,
    0x2557, 0x2558, 0x2559, 0x255A, 0x255B, 0x0491, 0x255D, 0x255E,
    0x255F, 0x2560, 0x2561, 0x0401, 0x0404, 0x2563, 0x0406, 0x0407,
    0x2566, 0x2567, 0x2568, 0x2569, 0x256A, 0x0490, 0x256C, 0x00A9,
    0x044E, 0x0430, 0x0431, 0x0446, 0x0434, 0x0435, 0x0444, 0x0433,
    0x0445, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 0x043E,
    0x043F, 0x044F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0436, 0x0432,
    0x044C, 0x044B, 0x0437, 0x0448, 0x044D, 0x0449, 0x0447, 0x044A,
    0x042E, 0x0410, 0x0411, 0x0426, 0x0414, 0x0415, 0x0424, 0x0413,
    0x0425, 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E,
    0x041F, 0x042F, 0x0420, 0x0421, 0x0422, 0x0423, 0x0416, 0x0412,
    0x042C, 0x042B, 0x0417, 0x0428, 0x042D, 0x0429, 0x0427, 0x042A
};

/* PC Code Pages */

struct x_to_unicode u_cp437 = {
    128, 0, X2U_CP, AL_ROMAN,"PC Code Page 437","cp437", 0, NULL,
    0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x00e0, 0x00e5, 0x00e7,
    0x00ea, 0x00eb, 0x00e8, 0x00ef, 0x00ee, 0x00ec, 0x00c4, 0x00c5,
    0x00c9, 0x00e6, 0x00c6, 0x00f4, 0x00f6, 0x00f2, 0x00fb, 0x00f9,
    0x00ff, 0x00d6, 0x00dc, 0x00a2, 0x00a3, 0x00a5, 0x20a7, 0x0192,
    0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x00f1, 0x00d1, 0x00aa, 0x00ba,
    0x00bf, 0x2310, 0x00ac, 0x00bd, 0x00bc, 0x00a1, 0x00ab, 0x00bb,
    0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556,
    0x2555, 0x2563, 0x2551, 0x2557, 0x255d, 0x255c, 0x255b, 0x2510,
    0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x255e, 0x255f,
    0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x2567,
    0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256b,
    0x256a, 0x2518, 0x250c, 0x2588, 0x2584, 0x258c, 0x2590, 0x2580,
    0x03b1, 0x00df, 0x0393, 0x03c0, 0x03a3, 0x03c3, 0x00b5, 0x03c4,
    0x03a6, 0x0398, 0x03a9, 0x03b4, 0x221e, 0x03c6, 0x03b5, 0x2229,
    0x2261, 0x00b1, 0x2265, 0x2264, 0x2320, 0x2321, 0x00f7, 0x2248,
    0x00b0, 0x2219, 0x00b7, 0x221a, 0x207f, 0x00b2, /* 0x25ae */ 0x25a0, 0x00a0
};

struct x_to_unicode u_mazovia = {
    128, 0, X2U_CP, AL_ROMAN,"Polish Mazovia PC Code Page","mazovia", 0, NULL,
    0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x00e0, 0x0105, 0x00e7, /* 80 */
    0x00ea, 0x00eb, 0x00e8, 0x00ef, 0x00ee, 0x0107, 0x00c4, 0x0104, /* 88 */
    0x0118, 0x0119, 0x0142, 0x00f4, 0x00f6, 0x0106, 0x00fb, 0x00f9, /* 90 */
    0x015a, 0x00d6, 0x00dc, 0x00a2, 0x0141, 0x00a5, 0x015b, 0x0192, /* 98 */
    0x0179, 0x017b, 0x00f3, 0x00d3, 0x0144, 0x0143, 0x017a, 0x017c, /* a0 */
    0x00bf, 0x2310, 0x00ac, 0x00bd, 0x00bc, 0x00a1, 0x00ab, 0x00bb, /* a8 */
    0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556, /* b0 */
    0x2555, 0x2563, 0x2551, 0x2557, 0x255d, 0x255c, 0x255b, 0x2510, /* b8 */
    0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x255e, 0x255f, /* c0 */
    0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x2567, /* c8 */
    0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256b, /* d0 */
    0x256a, 0x2518, 0x250c, 0x2588, 0x2584, 0x258c, 0x2590, 0x2580, /* d8 */
    0x03b1, 0x00df, 0x0393, 0x03c0, 0x03a3, 0x03c3, 0x00b5, 0x03c4, /* e0 */
    0x03a6, 0x0398, 0x03a9, 0x03b4, 0x221e, 0x03c6, 0x03b5, 0x2229, /* e8 */
    0x2261, 0x00b1, 0x2265, 0x2264, 0x2320, 0x2321, 0x00f7, 0x2248, /* f0 */
    0x00b0, 0x2219, 0x00b7, 0x221a, 0x207f, 0x00b2, 0x25a0, 0x00a0  /* f8 */
};

struct x_to_unicode u_cp850 = {
    128, 0, X2U_CP, AL_ROMAN,"PC Code Page 850","cp850", 0, NULL,
    0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x00e0, 0x00e5, 0x00e7,
    0x00ea, 0x00eb, 0x00e8, 0x00ef, 0x00ee, 0x00ec, 0x00c4, 0x00c5,
    0x00c9, 0x00e6, 0x00c6, 0x00f4, 0x00f6, 0x00f2, 0x00fb, 0x00f9,
    0x00ff, 0x00d6, 0x00dc, 0x00f8, 0x00a3, 0x00d8, 0x00d7, 0x0192,
    0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x00f1, 0x00d1, 0x00aa, 0x00ba,
    0x00bf, 0x00ae, 0x00ac, 0x00bd, 0x00bc, 0x00a1, 0x00ab, 0x00bb,
    0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x00c1, 0x00c2, 0x00c0,
    0x00a9, 0x2563, 0x2551, 0x2557, 0x255d, 0x00a2, 0x00a5, 0x2510,
    0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x00e3, 0x00c3,
    0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x00a4,
    0x00f0, 0x00d0, 0x00ca, 0x00cb, 0x00c8, 0x0131, 0x00cd, 0x00ce,
    0x00cf, 0x2518, 0x250c, 0x2588, 0x2584, 0x00a6, 0x00cc, 0x2580,
    0x00d3, 0x00df, 0x00d4, 0x00d2, 0x00f5, 0x00d5, 0x00b5, 0x00fe,
    0x00de, 0x00da, 0x00db, 0x00d9, 0x00fd, 0x00dd, 0x00af, 0x00b4,
    0x00ad, 0x00b1, 0x2017, 0x00be, 0x00b6, 0x00a7, 0x00f7, 0x00b8,
    0x00b0, 0x00a8, 0x00b7, 0x00b9, 0x00b3, 0x00b2, 0x25a0, 0x00a0
};

struct x_to_unicode u_cp852 = {
    128, 0, X2U_CP, AL_ROMAN,"PC Code Page 852","cp852", 0, NULL,
    0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x016f, 0x0107, 0x00e7,
    0x0142, 0x00eb, 0x0150, 0x0151, 0x00ee, 0x0179, 0x00c4, 0x0106,
    0x00c9, 0x0139, 0x013a, 0x00f4, 0x00f6, 0x013d, 0x013e, 0x015a,
    0x015b, 0x00d6, 0x00dc, 0x0164, 0x0165, 0x0141, 0x00d7, 0x010d,
    0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x0104, 0x0105, 0x017d, 0x017e,
    0x0118, 0x0119, 0x00ac, 0x017a, 0x010c, 0x015f, 0x00ab, 0x00bb,
    0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x00c1, 0x00c2, 0x011a,
    0x015e, 0x2563, 0x2551, 0x2557, 0x255d, 0x017b, 0x017c, 0x2510,
    0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x0102, 0x0103,
    0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x00a4,
    0x0111, 0x0110, 0x010e, 0x00cb, 0x010f, 0x0147, 0x00cd, 0x00ce,
    0x011b, 0x2518, 0x250c, 0x2588, 0x2584, 0x0162, 0x016e, 0x2580,
    0x00d3, 0x00df, 0x00d4, 0x0143, 0x0144, 0x0148, 0x0160, 0x0161,
    0x0154, 0x00da, 0x0155, 0x0170, 0x00fd, 0x00dd, 0x0163, 0x00b4,
    0x00ad, 0x02dd, 0x02db, 0x02c7, 0x02d8, 0x00a7, 0x00f7, 0x00b8,
    0x00b0, 0x00a8, 0x02d9, 0x0171, 0x0158, 0x0159, 0x25a0, 0x00a0
};

struct x_to_unicode u_cp855 = {		/* CP855 Cyrillic to Unicode */
    128, 0, X2U_CP, AL_CYRIL,"PC Code Page 855","cp855", 0, NULL,
    0x0452, 0x0402, 0x0453, 0x0403, 0x0451, 0x0401, 0x0454, 0x0404,
    0x0455, 0x0405, 0x0456, 0x0406, 0x0457, 0x0407, 0x0458, 0x0408,
    0x0459, 0x0409, 0x045a, 0x040a, 0x045b, 0x040b, 0x045c, 0x040c,
    0x045e, 0x040e, 0x045f, 0x040f, 0x044e, 0x042e, 0x044a, 0x042a,
    0x0430, 0x0410, 0x0431, 0x0411, 0x0446, 0x0426, 0x0434, 0x0414,
    0x0435, 0x0415, 0x0444, 0x0424, 0x0433, 0x0413, 0x00ab, 0x00bb,
    0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x0445, 0x0425, 0x0438,
    0x0418, 0x2563, 0x2551, 0x2557, 0x255d, 0x0439, 0x0419, 0x2510,
    0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x043a, 0x041a,
    0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x00a4,
    0x043b, 0x041b, 0x043c, 0x041c, 0x043d, 0x041d, 0x043e, 0x041e,
    0x043f, 0x2518, 0x250c, 0x2588, 0x2584, 0x041f, 0x044f, 0x2580,
    0x042f, 0x0440, 0x0420, 0x0441, 0x0421, 0x0442, 0x0422, 0x0443,
    0x0423, 0x0436, 0x0416, 0x0432, 0x0412, 0x044c, 0x042c, 0x2116,
    0x002d, 0x044b, 0x042b, 0x0437, 0x0417, 0x0448, 0x0428, 0x044d,
    0x042d, 0x0449, 0x0429, 0x0447, 0x0427, 0x00a7, 0x25a0, 0x0020
};

struct x_to_unicode u_cp856 = {		/* CP856 (Bulgaria) to Unicode */
    128, 0, X2U_CP, AL_CYRIL,"PC Code Page 856","cp856", 0, NULL,
    0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
    0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f,
    0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
    0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e, 0x042f,
    0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
    0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f,
    0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
    0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e, 0x044f,
    0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x2563, 0x2551,
    0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x2510,
    0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2116, 0x00a7, 0x2557,
    0x255d, 0x2518, 0x250c, 0x2588, 0x2584, 0x258c, 0x2590, 0x2580,
    0x03b1, 0x00df, 0x0393, 0x03c0, 0x03a3, 0x03c3, 0x00b5, 0x03c4,
    0x03a6, 0x0398, 0x03a9, 0x03b4, 0x221e, 0x03c6, 0x03b5, 0x2229,
    0x2261, 0x00b1, 0x2265, 0x2264, 0x2320, 0x2321, 0x00f7, 0x2248,
    0x00b0, 0x2219, 0x00b7, 0x221a, 0x207f, 0x00b2, 0x25a0, 0x00a0
};

struct x_to_unicode u_cp857 = {
    128, 0, X2U_CP, AL_ROMAN,"PC Code Page 857","cp857", 0, NULL,
    0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x00e0, 0x00e5, 0x00e7, /* 0x80 */
    0x00ea, 0x00eb, 0x00e8, 0x00ef, 0x00ee, 0x0131, 0x00c4, 0x00c5, /* 0x88 */
    0x00c9, 0x00e6, 0x00c6, 0x00f4, 0x00f6, 0x00f2, 0x00fb, 0x00f9, /* 0x90 */
    0x0130, 0x00d6, 0x00dc, 0x00f8, 0x00a3, 0x00d8, 0x015e, 0x015f, /* 0x98 */
    0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x00f1, 0x00d1, 0x011e, 0x011f, /* 0xa0 */
    0x00bf, 0x00ae, 0x00ac, 0x00bd, 0x00bc, 0x00a1, 0x00ab, 0x00bb, /* 0xa8 */
    0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x00c1, 0x00c2, 0x00c0, /* 0xb0 */
    0x00a9, 0x2563, 0x2551, 0x2557, 0x255d, 0x00a2, 0x00a5, 0x2510, /* 0xb8 */
    0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x00e3, 0x00c3, /* 0xc0 */
    0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x00a4, /* 0xc8 */
    0x00ba, 0x00aa, 0x00ca, 0x00cb, 0x00c8, 0x20ac, 0x00cd, 0x00ce, /* 0xd0 */
    0x00cf, 0x2518, 0x250c, 0x2588, 0x2584, 0x00a6, 0x00cc, 0x2580, /* 0xd8 */
    0x00d3, 0x00df, 0x00d4, 0x00d2, 0x00f5, 0x00d5, 0x00b5, 0xfffd, /* 0xe0 */
    0x00d7, 0x00da, 0x00db, 0x00d9, 0x00ec, 0x00ff, 0x00af, 0x00b4, /* 0xe8 */
    0x00ad, 0x00b1, 0xfffd, 0x00be, 0x00b6, 0x00a7, 0x00f7, 0x00b8, /* 0xf0 */
    0x00b0, 0x00a8, 0x00b7, 0x00b9, 0x00b3, 0x00b2, 0x25a0, 0x00a0  /* 0xf8 */
};

struct x_to_unicode u_cp858 = {
    128, 0, X2U_CP, AL_ROMAN,"PC Code Page 858","cp858", 0, NULL,
    0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x00e0, 0x00e5, 0x00e7,
    0x00ea, 0x00eb, 0x00e8, 0x00ef, 0x00ee, 0x00ec, 0x00c4, 0x00c5,
    0x00c9, 0x00e6, 0x00c6, 0x00f4, 0x00f6, 0x00f2, 0x00fb, 0x00f9,
    0x00ff, 0x00d6, 0x00dc, 0x00f8, 0x00a3, 0x00d8, 0x00d7, 0x0192,
    0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x00f1, 0x00d1, 0x00aa, 0x00ba,
    0x00bf, 0x00ae, 0x00ac, 0x00bd, 0x00bc, 0x00a1, 0x00ab, 0x00bb,
    0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x00c1, 0x00c2, 0x00c0,
    0x00a9, 0x2563, 0x2551, 0x2557, 0x255d, 0x00a2, 0x00a5, 0x2510,
    0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x00e3, 0x00c3,
    0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x00a4,
    0x00f0, 0x00d0, 0x00ca, 0x00cb, 0x00c8, 0x20ac, 0x00cd, 0x00ce,
    0x00cf, 0x2518, 0x250c, 0x2588, 0x2584, 0x00a6, 0x00cc, 0x2580,
    0x00d3, 0x00df, 0x00d4, 0x00d2, 0x00f5, 0x00d5, 0x00b5, 0x00fe,
    0x00de, 0x00da, 0x00db, 0x00d9, 0x00fd, 0x00dd, 0x00af, 0x00b4,
    0x00ad, 0x00b1, 0x2017, 0x00be, 0x00b6, 0x00a7, 0x00f7, 0x00b8,
    0x00b0, 0x00a8, 0x00b7, 0x00b9, 0x00b3, 0x00b2, 0x25a0, 0x00a0
};

struct x_to_unicode u_cp862 = {
    128, 0, X2U_CP, AL_HEBREW,"PC Code Page 862","cp862", 0, NULL,
    0x05d0, 0x05d1, 0x05d2, 0x05d3, 0x05d4, 0x05d5, 0x05d6, 0x05d7,
    0x05d8, 0x05d9, 0x05da, 0x05db, 0x05dc, 0x05dd, 0x05de, 0x05df,
    0x05e0, 0x05e1, 0x05e2, 0x05e3, 0x05e4, 0x05e5, 0x05e6, 0x05e7,
    0x05e8, 0x05e9, 0x05ea, 0x00a2, 0x00a3, 0x00a5, 0x20a7, 0x0192,
    0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x00f1, 0x00d1, 0x00aa, 0x00ba,
    0x00bf, 0x2310, 0x00ac, 0x00bd, 0x00bc, 0x00a1, 0x00ab, 0x00bb,
    0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556,
    0x2555, 0x2563, 0x2551, 0x2557, 0x255d, 0x255c, 0x255b, 0x2510,
    0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x255e, 0x255f,
    0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x2567,
    0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256b,
    0x256a, 0x2518, 0x250c, 0x2588, 0x2584, 0x258c, 0x2590, 0x2580,
    0x03b1, 0x00df, 0x0393, 0x03c0, 0x03a3, 0x03c3, 0x00b5, 0x03c4,
    0x03a6, 0x0398, 0x03a9, 0x03b4, 0x221e, 0x03c6, 0x03b5, 0x2229,
    0x2261, 0x00b1, 0x2265, 0x2264, 0x2320, 0x2321, 0x00f7, 0x2248,
    0x00b0, 0x2219, 0x00b7, 0x221a, 0x207f, 0x00b2, 0x25a0, 0x00a0
};

struct x_to_unicode u_cp864 = {
    128, 0, X2U_CP, AL_ARABIC,"PC Code Page 864","cp864", 0, NULL,
    0x00b0, 0x00b7, 0x2219, 0x221a, 0x2592, 0x2500, 0x2502, 0x253c,
    0x2524, 0x252c, 0x251c, 0x2534, 0x2510, 0x250c, 0x2514, 0x2518,
    0x03b2, 0x221e, 0x03c6, 0x00b1, 0x00bd, 0x00bc, 0x2248, 0x00ab,
    0x00bb, 0xfef7, 0xfef8, 0xfffd, 0xfffd, 0xfefb, 0xfefc, 0xfffd,
    0x00a0, 0x00ad, 0xfe82, 0x00a3, 0x00a4, 0xfe84, 0xfffd, 0xfffd,
    0xfe8e, 0xfe8f, 0xfe95, 0xfe99, 0x060c, 0xfe9d, 0xfea1, 0xfea5,
    0x0660, 0x0661, 0x0662, 0x0663, 0x0664, 0x0665, 0x0666, 0x0667,
    0x0668, 0x0669, 0xfed1, 0x061b, 0xfeb1, 0xfeb5, 0xfeb9, 0x061f,
    0x00a2, 0xfe80, 0xfe81, 0xfe83, 0xfe85, 0xfeca, 0xfe8b, 0xfe8d,
    0xfe91, 0xfe93, 0xfe97, 0xfe9b, 0xfe9f, 0xfea3, 0xfea7, 0xfea9,
    0xfeab, 0xfead, 0xfeaf, 0xfeb3, 0xfeb7, 0xfebb, 0xfebf, 0xfec1,
    0xfec5, 0xfecb, 0xfecf, 0x00a6, 0x00ac, 0x00f7, 0x00d7, 0xfec9,
    0x0640, 0xfed3, 0xfed7, 0xfedb, 0xfedf, 0xfee3, 0xfee7, 0xfeeb,
    0xfeed, 0xfeef, 0xfef3, 0xfebd, 0xfecc, 0xfece, 0xfecd, 0xfee1,
    0xfe7d, 0x0651, 0xfee5, 0xfee9, 0xfeec, 0xfef0, 0xfef2, 0xfed0,
    0xfed5, 0xfef5, 0xfef6, 0xfedd, 0xfed9, 0xfef1, 0x25a0, 0xfffd
};

struct x_to_unicode u_cp866 = {
    128, 0, X2U_CP, AL_CYRIL,"PC Code Page 866","cp866", 0, NULL,
    0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417,
    0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f,
    0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427,
    0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e, 0x042f,
    0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437,
    0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f,
    0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556,
    0x2555, 0x2563, 0x2551, 0x2557, 0x255d, 0x255c, 0x255b, 0x2510,
    0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x255e, 0x255f,
    0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x2567,
    0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256b,
    0x256a, 0x2518, 0x250c, 0x2588, 0x2584, 0x258c, 0x2590, 0x2580,
    0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447,
    0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e, 0x044f,
    0x0401, 0x0451, 0x0404, 0x0454, 0x0407, 0x0457, 0x040e, 0x045e,
    0x00b0, 0x2219, 0x00b7, 0x221a, 0x2116, 0x00a4, 0x25a0, 0x00a0
};

struct x_to_unicode u_cp869 = {
    128, 0, X2U_CP, AL_GREEK,"PC Code Page 869","cp869", 0, NULL,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x0386, 0xfffd,
    0x00b7, 0x00ac, 0x00a6, 0x2018, 0x2019, 0x0388, 0x2015, 0x0389,
    0x038a, 0x03aa, 0x038c, 0xfffd, 0xfffd, 0x038e, 0x03ab, 0x00a9,
    0x038f, 0x00b2, 0x00b3, 0x03ac, 0x00a3, 0x03ad, 0x03ae, 0x03af,
    0x03ca, 0x0390, 0x03cc, 0x03cd, 0x0391, 0x0392, 0x0393, 0x0394,
    0x0395, 0x0396, 0x0397, 0x00bd, 0x0398, 0x0399, 0x00ab, 0x00bb,
    0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x039a, 0x039b, 0x039c,
    0x039d, 0x2563, 0x2551, 0x2557, 0x255d, 0x039e, 0x039f, 0x2510,
    0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x03a0, 0x03a1,
    0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x03a3,
    0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8, 0x03a9, 0x03b1, 0x03b2,
    0x03b3, 0x2518, 0x250c, 0x2588, 0x2584, 0x03b4, 0x03b5, 0x2580,
    0x03b6, 0x03b7, 0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd,
    0x03be, 0x03bf, 0x03c0, 0x03c1, 0x03c3, 0x03c2, 0x03c4, 0x0384,
    0x00ad, 0x00b1, 0x03c5, 0x03c6, 0x03c7, 0x00a7, 0x03c8, 0x0385,
    0x00b0, 0x00a8, 0x03c9, 0x03cb, 0x03b0, 0x03ce, 0x25a0, 0x00a0
};

/* Windows code pages */

struct x_to_unicode u_cp1250 = {	/* Windows Latin-2 */
    128, 0, X2U_CP, AL_ROMAN,"Windows Code Page 1250","cp1250", 0, NULL,
    0x20ac, 0xfffd, 0x201a, 0x0192, 0x201e, 0x2026, 0x2020, 0x2021, /* 80 */
    0x005e, 0x2031, 0x0160, 0x003c, 0x015a, 0x0164, 0x017d, 0x0179, /* 88 */
    0xfffd, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2012, 0x2014, /* 90 */
    0xfffd, 0x2122, 0x0161, 0x003e, 0x015b, 0x0165, 0x017e, 0x017a, /* 98 */
    0x00A0, 0x02c7, 0x02d8, 0x0141, 0x00A4, 0x0104, 0x00A6, 0x00A7, /* A0 */
    0x00A8, 0x00a9, 0x015E, 0x00ab, 0x00ac, 0x002D, 0x00ae, 0x017B, /* A8 */
    0x00B0, 0x00b1, 0x02DB, 0x0142, 0x00B4, 0x00b5, 0x00b6, 0x00b7, /* B0 */
    0x00B8, 0x0105, 0x015F, 0x00bb, 0x013d, 0x02DD, 0x013E, 0x017C, /* B8 */
    0x0154, 0x00C1, 0x00C2, 0x0102, 0x00C4, 0x0139, 0x0106, 0x00C7, /* C0 */
    0x010C, 0x00C9, 0x0118, 0x00CB, 0x011A, 0x00CD, 0x00CE, 0x010E,
    0x0110, 0x0143, 0x0147, 0x00D3, 0x00D4, 0x0150, 0x00D6, 0x00D7,
    0x0158, 0x016E, 0x00DA, 0x0170, 0x00DC, 0x00DD, 0x0162, 0x00DF,
    0x0155, 0x00E1, 0x00E2, 0x0103, 0x00E4, 0x013A, 0x0107, 0x00E7,
    0x010D, 0x00E9, 0x0119, 0x00EB, 0x011B, 0x00ED, 0x00EE, 0x010F,
    0x0111, 0x0144, 0x0148, 0x00F3, 0x00F4, 0x0151, 0x00F6, 0x00F7,
    0x0159, 0x016F, 0x00FA, 0x0171, 0x00FC, 0x00FD, 0x0163, 0x02D9
};

struct x_to_unicode u_cp1251 = {	/* Windows Cyrillic */
    128, 0, X2U_CP, AL_CYRIL,"Windows Code Page 1251","cp1251", 0, NULL,
    0x0402, 0x0403, 0x201a, 0x0453, 0x201e, 0x2026, 0x2020, 0x2021, /* 80 */
    0x20ac, 0x2031, 0x0409, 0x003c, 0x040a, 0x040c, 0x040b, 0x040f, /* 88 */
    0x0452, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2012, 0x2014, /* 90 */
    0x007e, 0x2122, 0x0459, 0x003e, 0x045a, 0x045c, 0x045b, 0x045f, /* 98 */
    0x00A0, 0x040e, 0x045e, 0x0408, 0x00A4, 0x0490, 0x00A6, 0x00A7, /* a0 */
    0x0401, 0x00A9, 0x0404, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x0407, /* a8 */
    0x00b0, 0x00b1, 0x0406, 0x0456, 0x0491, 0x00B5, 0x00B6, 0x00B7, /* b0 */
    0x0451, 0x2116, 0x0454, 0x00BB, 0x0458, 0x0405, 0x0455, 0x0457, /* b8 */
    0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417, /* c0 */
    0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d, 0x041e, 0x041f, /* c8 */
    0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, /* d0 */
    0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d, 0x042e, 0x042f, /* d8 */
    0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0436, 0x0437, /* e0 */
    0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d, 0x043e, 0x043f, /* e8 */
    0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, /* f0 */
    0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d, 0x044e, 0x044f  /* f8 */
};

struct x_to_unicode u_cp1252 = {	/* Windows Latin-1 */
/*
  The following code points added September 1998:
  0x80: Euro
  0x8E: Latin Capital Letter Z with Caron
  0x9E: Latin Small Letter Z with Caron
  Announced by Murray Sargent <murrays@microsoft.com> to Unicode consortium,
  email, 3 September 1998.  The code page was changed in June 1998.  The
  change is reflected in Windows 98 and "recent service packs" for Window 95
  and Windows NT 4.0.
*/
    128, 0, X2U_CP, AL_ROMAN,"Windows Code Page 1252","cp1252", 0, NULL,
    0x20ac, 0xfffd, 0x201a, 0x0192, 0x201e, 0x2026, 0x2020, 0x2021,
    0x005e, 0x2031, 0x0160, 0x003c, 0x0152, 0xfffd, 0x017D, 0xfffd,
    0xfffd, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2012, 0x2014,
    0x007e, 0x2122, 0x0161, 0x003e, 0x0153, 0xfffd, 0x017E, 0x0178,
    0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
    0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF,
    0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
    0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
    0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF,
    0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
    0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
    0x00F0, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
    0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x00FF
};

struct x_to_unicode u_cp1253 = {	/* Windows Greece */
    128, 0, X2U_CP, AL_GREEK,"Windows Code Page 1253","cp1253", 0, NULL,
    0x20ac, 0xfffd, 0x201a, 0x0192, 0x201e, 0x2026, 0x2020, 0x2021, /* 80 */
    0xfffd, 0x2031, 0xfffd, 0x003c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, /* 88 */
    0xfffd, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2012, 0x2014, /* 90 */
    0xfffd, 0x2122, 0xfffd, 0x003e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, /* 98 */
    0x00A0, 0x00b7, 0x0386, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7, /* a0 */
    0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF, /* a8 */
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B7, 0x00B5, 0x00B6, 0x00B7, /* b0 */
    0x0388, 0x0389, 0x038A, 0x00BB, 0x038C, 0x00BD, 0x038E, 0x038F, /* b8 */
    0x0390, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, /* c0 */
    0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F, /* c8 */
    0x03a0, 0x03a1, 0xfffd, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, /* d0 */
    0x03a8, 0x03a9, 0x03aA, 0x03aB, 0x03aC, 0x03aD, 0x03aE, 0x03aF, /* d8 */
    0x03b0, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, /* e0 */
    0x03b8, 0x03b9, 0x03bA, 0x03bB, 0x03bC, 0x03bD, 0x03bE, 0x03bF, /* e8 */
    0x03c0, 0x03c1, 0x03c2, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, /* f0 */
    0x03c8, 0x03c9, 0x03cA, 0x03cB, 0x03cC, 0x03cD, 0x03cE, 0xfffd  /* f8 */
};

struct x_to_unicode u_cp1254 = {	/* Windows Turkey */
    128, 0, X2U_CP, AL_ROMAN,"Windows Code Page 1254","cp1254", 0, NULL,
    0x20ac, 0xfffd, 0x201a, 0x0192, 0x201e, 0x2026, 0x2020, 0x2021, /* 80 */
    0x005e, 0x2031, 0x0160, 0x003c, 0x0152, 0xfffd, 0xfffd, 0xfffd, /* 88 */
    0xfffd, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2012, 0x2014, /* 90 */
    0x007e, 0x2122, 0x0161, 0x003e, 0x0153, 0xfffd, 0xfffd, 0x0178, /* 98 */
    0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
    0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
    0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF,
    0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
    0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
    0x011e, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x0130, 0x015e, 0x00DF,
    0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
    0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
    0x011f, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
    0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x0131, 0x015f, 0x00FF
};

struct x_to_unicode u_cp1255 = {	/* Windows Hebrew */
    128, 0, X2U_CP, AL_ROMAN,"Windows Code Page 1255 (Hebrew)","cp1255",
    0, NULL,
    0x20AC, 0xFFFD, 0x201a, 0x0192, 0x201e, 0x2026, 0x2020, 0x2021,
    0x02c6, 0x2030, 0xfffd, 0x2039, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014,
    0x02dc, 0x2122, 0xfffd, 0x203a, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x00a0, 0x00a1, 0x00a2, 0x00a3, 0x20aa, 0x00a5, 0x00a6, 0x00a7,
    0x00a8, 0x00a9, 0x00d7, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x00af,
    0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7,
    0x00b8, 0x00b9, 0x00f7, 0x00bb, 0x00bc, 0x00bd, 0x00be, 0x00bf,
    0x05b0, 0x05b1, 0x05b2, 0x05b3, 0x05b4, 0x05b5, 0x05b6, 0x05b7,
    0x05b8, 0x05b9, 0xfffd, 0x05bb, 0x05bc, 0x05bd, 0x05be, 0x05bf,
    0x05c0, 0x05c1, 0x05c2, 0x05c3, 0x05f0, 0x05f1, 0x05f2, 0x05f3,
    0x05f4, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x05d0, 0x05d1, 0x05d2, 0x05d3, 0x05d4, 0x05d5, 0x05d6, 0x05d7,
    0x05d8, 0x05d9, 0x05da, 0x05db, 0x05dc, 0x05dd, 0x05de, 0x05df,
    0x05e0, 0x05e1, 0x05e2, 0x05e3, 0x05e4, 0x05e5, 0x05e6, 0x05e7,
    0x05e8, 0x05e9, 0x05ea, 0xfffd, 0xfffd, 0x200e, 0x200f, 0xfffd
};

struct x_to_unicode u_cp1256 = {	/* Windows Arabic */
    128, 0, X2U_CP, AL_ROMAN,"Windows Code Page 1256 (Arabic)","cp1256",
    0, NULL,
    0x20ac, 0x067e, 0x201a, 0x0192, 0x201e, 0x2026, 0x2020, 0x2021,
    0x02c6, 0x2030, 0xfffd, 0x2039, 0x0152, 0x0686, 0x0698, 0xfffd, /* 88 */
    0x06af, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014, /* 90 */
    0xfffd, 0x2122, 0xfffd, 0x003a, 0x0153, 0x200c, 0x200d, 0xfffd, /* 98 */
    0x00A0, 0x060c, 0x00A2, 0x00A3, 0x00A4, 0x00a5, 0x00A6, 0x00A7, /* a0 */
    0x00a8, 0x00A9, 0xfffd, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00af, /* a8 */
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00b4, 0x00B5, 0x00B6, 0x00B7, /* b0 */
    0x00b8, 0x00B9, 0x061b, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x061f, /* b8 */
    0xfffd, 0x0621, 0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0627, /* c0 */
    0x0628, 0x0629, 0x062a, 0x062b, 0x062c, 0x062d, 0x062e, 0x062f, /* c8 */
    0x0630, 0x0631, 0x0632, 0x0633, 0x0634, 0x0635, 0x0636, 0x00D7, /* d0 */
    0x0637, 0x0638, 0x0639, 0x063a, 0x0640, 0x0641, 0x0642, 0x0643, /* d8 */
    0x00e0, 0x0644, 0x00e2, 0x0645, 0x0646, 0x0647, 0x0648, 0x00e7, /* e0 */
    0x00e8, 0x00E9, 0x00ea, 0x00eb, 0x0649, 0x064a, 0x00ee, 0x00ef, /* e8 */
    0x064b, 0x064c, 0x064d, 0x064e, 0x00f4, 0x064f, 0x0650, 0x00F7, /* f0 */
    0x0651, 0x00f9, 0x0652, 0x00fb, 0x00fc, 0x200e, 0x200f, 0xfffd  /* f8 */
};

struct x_to_unicode u_cp1257 = {	/* Windows Latin-4 */
    128, 0, X2U_CP, AL_ROMAN,"Windows Code Page 1257","cp1257", 0, NULL,
    0x20ac, 0xfffd, 0x201a, 0xfffd, 0x201e, 0x2026, 0x2020, 0x2021, /* 80 */
    0xfffd, 0x2031, 0xfffd, 0x003c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, /* 88 */
    0xfffd, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2012, 0x2014, /* 90 */
    0xfffd, 0x2122, 0xfffd, 0x003e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, /* 98 */
    0x00A0, 0xfffd, 0x00A2, 0x00A3, 0x00A4, 0xfffd, 0x00A6, 0x00A7, /* a0 */
    0x00d8, 0x00A9, 0x0156, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00c6, /* a8 */
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0xfffd, 0x00B5, 0x00B6, 0x00B7, /* b0 */
    0x00f8, 0x00B9, 0x0157, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00e6, /* b8 */
    0x0104, 0x012e, 0x0100, 0x0106, 0x00C4, 0x00C5, 0x0118, 0x0112, /* c0 */
    0x010C, 0x00C9, 0x0179, 0x0116, 0x0122, 0x0136, 0x012a, 0x00b7, /* c8 */
    0x0160, 0x0143, 0x0145, 0x00d3, 0x014c, 0x00D5, 0x00D6, 0x00D7, /* d0 */
    0x0172, 0x0141, 0x015A, 0x016a, 0x00DC, 0x017b, 0x017d, 0x00DF, /* d8 */
    0x0105, 0x012f, 0x0101, 0x0107, 0x00E4, 0x00E5, 0x0119, 0x0113, /* e0 */
    0x010D, 0x00E9, 0x017a, 0x0117, 0x0123, 0x0137, 0x012b, 0x013c, /* e8 */
    0x0161, 0x0144, 0x0146, 0x00f3, 0x014d, 0x00F5, 0x00F6, 0x00F7, /* f0 */
    0x0173, 0x0142, 0x015b, 0x016b, 0x00fc, 0x017c, 0x017e, 0xfffd  /* f8 */
};

struct x_to_unicode u_cp1258 = {	/* Windows Viet Nam */
    128, 0, X2U_CP, AL_ROMAN,"Windows Code Page 1258 (Viet Nam)","cp1258",
    0, NULL,
    0x20ac, 0xfffd, 0x201a, 0x0192, 0x201e, 0x2026, 0x2020, 0x2021, /* 80 */
    0x02c6, 0x2030, 0xfffd, 0x2039, 0x0152, 0xfffd, 0xfffd, 0xfffd, /* 88 */
    0xfffd, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014, /* 90 */
    0x02dc, 0x2122, 0xfffd, 0x203a, 0x0153, 0xfffd, 0xfffd, 0x0178, /* 98 */
    0x00A0, 0x00a1, 0x00A2, 0x00A3, 0x00A4, 0x00a5, 0x00A6, 0x00A7, /* a0 */
    0x00a8, 0x00A9, 0x00aa, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00af, /* a8 */
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00b4, 0x00B5, 0x00B6, 0x00B7, /* b0 */
    0x00b8, 0x00B9, 0x00ba, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00bf, /* b8 */
    0x00c0, 0x00c1, 0x00c2, 0x0102, 0x00C4, 0x00C5, 0x00c6, 0x00c7, /* c0 */
    0x00c8, 0x00C9, 0x00ca, 0x00cb, 0x0300, 0x00cd, 0x00ce, 0x00cf, /* c8 */
    0x0110, 0x00d1, 0x0309, 0x00d3, 0x00d4, 0x01a0, 0x00D6, 0x00D7, /* d0 */
    0x00d8, 0x00d9, 0x00da, 0x00db, 0x00DC, 0x01af, 0x0303, 0x00DF, /* d8 */
    0x00e0, 0x00e1, 0x00e2, 0x0103, 0x00E4, 0x00E5, 0x00e6, 0x00d7, /* e0 */
    0x00e8, 0x00E9, 0x00ea, 0x00eb, 0x0301, 0x00ed, 0x00ee, 0x00ef, /* e8 */
    0x0111, 0x00f1, 0x0323, 0x00f3, 0x00f4, 0x01a1, 0x00F6, 0x00F7, /* f0 */
    0x00f8, 0x00f9, 0x00fa, 0x00fb, 0x00fc, 0x01b0, 0x20ab, 0x00ff  /* f8 */
};

struct x_to_unicode u_cp37 = {	/* EBCDIC U.S. */
    256, 0, X2U_CP, AL_ROMAN,"Code Page 037 EBCDIC (U.S.)","cp037", 0, NULL,
    0x0000, 0x0001, 0x0002, 0x0003, 0x009C, 0x0009, 0x0086, 0x007F,
    0x0097, 0x008D, 0x008E, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
    0x0010, 0x0011, 0x0012, 0x0013, 0x009D, 0x0085, 0x0008, 0x0087,
    0x0018, 0x0019, 0x0092, 0x008F, 0x001C, 0x001D, 0x001E, 0x001F,
    0x0080, 0x0081, 0x0082, 0x0083, 0x0084, 0x000A, 0x0017, 0x001B,
    0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x0005, 0x0006, 0x0007,
    0x0090, 0x0091, 0x0016, 0x0093, 0x0094, 0x0095, 0x0096, 0x0004,
    0x0098, 0x0099, 0x009A, 0x009B, 0x0014, 0x0015, 0x009E, 0x001A,
    0x0020, 0x00A0, 0x00E2, 0x00E4, 0x00E0, 0x00E1, 0x00E3, 0x00E5,
    0x00E7, 0x00F1, 0x00A2, 0x002E, 0x003C, 0x0028, 0x002B, 0x007C,
    0x0026, 0x00E9, 0x00EA, 0x00EB, 0x00E8, 0x00ED, 0x00EE, 0x00EF,
    0x00EC, 0x00DF, 0x0021, 0x0024, 0x002A, 0x0029, 0x003B, 0x00AC,
    0x002D, 0x002F, 0x00C2, 0x00C4, 0x00C0, 0x00C1, 0x00C3, 0x00C5,
    0x00C7, 0x00D1, 0x00A6, 0x002C, 0x0025, 0x005F, 0x003E, 0x003F,
    0x00F8, 0x00C9, 0x00CA, 0x00CB, 0x00C8, 0x00CD, 0x00CE, 0x00CF,
    0x00CC, 0x0060, 0x003A, 0x0023, 0x0040, 0x0027, 0x003D, 0x0022,
    0x00D8, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x00AB, 0x00BB, 0x00F0, 0x00FD, 0x00FE, 0x00B1,
    0x00B0, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F, 0x0070,
    0x0071, 0x0072, 0x00AA, 0x00BA, 0x00E6, 0x00B8, 0x00C6, 0x00A4,
    0x00B5, 0x007E, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
    0x0079, 0x007A, 0x00A1, 0x00BF, 0x00D0, 0x00DD, 0x00DE, 0x00AE,
    0x005E, 0x00A3, 0x00A5, 0x00B7, 0x00A9, 0x00A7, 0x00B6, 0x00BC,
    0x00BD, 0x00BE, 0x005B, 0x005D, 0x00AF, 0x00A8, 0x00B4, 0x00D7,
    0x007B, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x00AD, 0x00F4, 0x00F6, 0x00F2, 0x00F3, 0x00F5,
    0x007D, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050,
    0x0051, 0x0052, 0x00B9, 0x00FB, 0x00FC, 0x00F9, 0x00FA, 0x00FF,
    0x005C, 0x00F7, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058,
    0x0059, 0x005A, 0x00B2, 0x00D4, 0x00D6, 0x00D2, 0x00D3, 0x00D5,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x00B3, 0x00DB, 0x00DC, 0x00D9, 0x00DA, 0x009F
};

/* Other proprietary 8-bit sets */

struct x_to_unicode u_decmcs = {
    96, 32, X2U_DEC|X2U_STD, AL_ROMAN, "DEC Multinational", "dec-mcs", 0, "%5",
    0x00A0, 0x00A1, 0x00A2, 0x00A3, 0xfffd, 0x00A5, 0xfffd, 0x00A7,
    0x00A4, 0x00A9, 0x00AA, 0x00AB, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x00B0, 0x00B1, 0x00B2, 0x00B3, 0xfffd, 0x00B5, 0x00B6, 0x00B7,
    0xfffd, 0x00B9, 0x00BA, 0x00BB, 0x00BC, 0x00BD, 0xfffd, 0x00BF,
    0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
    0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
    0xfffd, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x0152,
    0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0xfffd, 0x00DF,
    0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
    0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
    0xfffd, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x0153,
    0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0xfffd, 0x00FF
};

struct x_to_unicode u_hproman8 = {
    96, 32, X2U_STD, AL_ROMAN, "Hewlett Packard Roman 8", "hp-roman8", 0, NULL,
    0x00a0, 0x00c0, 0x00c2, 0x00c8, 0x00ca, 0x00cb, 0x00ce, 0x00cf,
    0x00b4, 0x00a6, 0x00a9, 0x00a8, 0x00ac, 0x00d9, 0x00db, 0x20a4,
    0x00af, 0x00dd, 0x00fd, 0x00b0, 0x00c7, 0x00e7, 0x00d1, 0x00f1,
    0x00a1, 0x00bf, 0x00a4, 0x00a3, 0x00a5, 0x00a7, 0x0192, 0x00a2,
    0x00e2, 0x00ea, 0x00f4, 0x00fb, 0x00e1, 0x00e9, 0x00f3, 0x00fa,
    0x00e0, 0x00e8, 0x00f2, 0x00f9, 0x00e4, 0x00eb, 0x00f6, 0x00fc,
    0x00c5, 0x00ee, 0x00d8, 0x00c6, 0x00e5, 0x00ed, 0x00f8, 0x00e6,
    0x00c4, 0x00ec, 0x00d6, 0x00dc, 0x00c9, 0x00ef, 0x00df, 0x00d4,
    0x00c1, 0x00c3, 0x00e3, 0x00d0, 0x00f0, 0x00cd, 0x00cc, 0x00d3,
    0x00d2, 0x00d5, 0x00f5, 0x0160, 0x0161, 0x00da, 0x00b8, 0x00ff,
    0x00de, 0x00fe, 0x00b7, 0x00b5, 0x00b6, 0x00be, 0x2015, 0x00bc,
    0x00bd, 0x00aa, 0x00ba, 0x00ab, 0x2588, 0x00bb, 0x00b1, 0xfffd
};

struct x_to_unicode u_dgi = {
 96,32,X2U_STD,AL_ROMAN,"Data General International","dg-international",0,NULL,
    0x00a0, 0x00ac, 0x00bd, 0x00b5, 0x00b2, 0x00b3, 0x00a4, 0x00a2,
    0x00a3, 0x00aa, 0x00ba, 0x00a1, 0x00bf, 0x00a9, 0x00ae, 0x2021,
    0x00bb, 0x00ab, 0x00b6, 0x2122, 0x0192, 0x00a5, 0x00b1, 0x2264,
    0x2265, 0x00b7, 0x00b8, 0x00a7, 0x00b0, 0x00a8, 0x00b4, 0x2191,
    0x00c1, 0x00c0, 0x00c2, 0x00c4, 0x00c3, 0x00c5, 0x00c6, 0x00c7,
    0x00c9, 0x00c8, 0x00ca, 0x00cb, 0x00cd, 0x00cc, 0x00ce, 0x00cf,
    0x00d1, 0x00d3, 0x00d2, 0x00d4, 0x00d6, 0x00d5, 0x00d8, 0x0276,
    0x00da, 0x00d9, 0x00db, 0x00dc, 0xfffd, 0x0178, 0xfffd, 0xfffd,
    0x00e1, 0x00e0, 0x00e2, 0x00e4, 0x00e3, 0x00e5, 0x00e6, 0x00e7,
    0x00e9, 0x00e8, 0x00ea, 0x00eb, 0x00ed, 0x00ec, 0x00ee, 0x00ef,
    0x00f1, 0x00f3, 0x00f2, 0x00f4, 0x00f6, 0x00f5, 0x00f8, 0x0153,
    0x00fa, 0x00f9, 0x00fb, 0x00fc, 0x00df, 0x00ff, 0xfffd, 0x2588
};

struct x_to_unicode u_nextstep = {
    128, 0, 0, AL_ROMAN,"NeXTSTEP Multinational","next-multinational",0,NULL,
    0x00a0, 0x00c0, 0x00c1, 0x00c2, 0x00c3, 0x00c4, 0x00c5, 0x00c7,
    0x00c8, 0x00c9, 0x00ca, 0x00cb, 0x00cc, 0x00cd, 0x00ce, 0x00cf,
    0x00d0, 0x00d1, 0x00d2, 0x00d3, 0x00d4, 0x00d5, 0x00d6, 0x00d9,
    0x00da, 0x00db, 0x00dc, 0x00dd, 0x00de, 0x00b5, 0x00d7, 0x00f7,
    0x00a9, 0x00a1, 0x00a2, 0x00a3, 0x2044, 0x00a5, 0x0192, 0x00a7,
    0x00a4, 0x2019, 0x201c, 0x00ab, 0x2039, 0x203a, 0xfb01, 0xfb02,
    0x00ae, 0x2013, 0x2020, 0x2021, 0x00b7, 0x00a6, 0x00b6, 0x2022,
    0x201a, 0x201e, 0x201d, 0x00bb, 0x2026, 0x2030, 0x00ac, 0x00bf,
    0x00b9, 0x02cb, 0x00b4, 0x02c6, 0x02dc, 0x00af, 0x02d8, 0x02d9,
    0x00a8, 0x00b2, 0x02da, 0x00b8, 0x00b3, 0x02dd, 0x02db, 0x02c7,
    0x2014, 0x00b1, 0x00bc, 0x00bd, 0x00be, 0x00e0, 0x00e1, 0x00e2,
    0x00e3, 0x00e4, 0x00e5, 0x00e7, 0x00e8, 0x00e9, 0x00ea, 0x00eb,
    0x00ec, 0x00c6, 0x00ed, 0x00aa, 0x00ee, 0x00ef, 0x00f0, 0x00f1,
    0x0141, 0x00d8, 0x0152, 0x00ba, 0x00f2, 0x00f3, 0x00f4, 0x00f5,
    0x00f6, 0x00e6, 0x00f9, 0x00fa, 0x00fb, 0x0131, 0x00fc, 0x00fd,
    0x0142, 0x00f8, 0x0153, 0x00df, 0x00fe, 0x00ff, 0xfffd, 0xfffd
};

struct x_to_unicode u_maclatin = {
    128, 0, 0, AL_ROMAN,"Macintosh Latin","maclatin", 0, NULL,
    0x00C4, 0x00C5, 0x00C7, 0x00C9, 0x00D1, 0x00D6, 0x00DC, 0x00E1,
    0x00E0, 0x00E2, 0x00E4, 0x00E3, 0x00E5, 0x00E7, 0x00E9, 0x00E8,
    0x00EA, 0x00EB, 0x00ED, 0x00EC, 0x00EE, 0x00EF, 0x00F1, 0x00F3,
    0x00F2, 0x00F4, 0x00F6, 0x00F5, 0x00FA, 0x00F9, 0x00FB, 0x00FC,
    0x00DD, 0x00B0, 0x00A2, 0x00A3, 0x00A7, 0x2022, 0x00B6, 0x00DF,
    0x00AE, 0x00A9, 0x2122, 0x00B4, 0x00A8, 0x2260, 0x00C6, 0x00D8,
    0x221E, 0x00B1, 0x2264, 0x2265, 0x00A5, 0x00B5, 0x2202, 0x2211,
    0x220F, 0x03C0, 0x222B, 0x00AA, 0x00BA, 0x2126, 0x00E6, 0x00F8,
    0x00BF, 0x00A1, 0x00AC, 0x221A, 0x0192, 0x2248, 0x2206, 0x00AB,
    0x00BB, 0x2026, 0x00A0, 0x00C0, 0x00C3, 0x00D5, 0x0152, 0x0153,
    0x2013, 0x2014, 0x201C, 0x201D, 0x2018, 0x2019, 0x00F7, 0x25CA,
    0x00FF, 0x0178, 0x2044, 0x00A4, 0x00D0, 0x00F0, 0x00DE, 0x00FE,
    0x00FD, 0x00B7, 0x201A, 0x201E, 0x2030, 0x00C2, 0x00CA, 0x00C1,
    0x00CB, 0x00C8, 0x00CD, 0x00CE, 0x00CF, 0x00CC, 0x00D3, 0x00D4,
    0xF8FF, 0x00D2, 0x00DA, 0x00DB, 0x00D9, 0x0131, 0x02C6, 0x02DC,
    0x00AF, 0x02D8, 0x02D9, 0x02DA, 0x00B8, 0x02DD, 0x02DB, 0x02C7
};

struct x_to_unicode u_quickdraw = {
    128, 0, 0, AL_ROMAN,"QuickDraw","quickdraw", 0, NULL,
    0x00C4, 0x00C5, 0x00C7, 0x00C9, 0x00D1, 0x00D6, 0x00DC, 0x00E1,
    0x00E0, 0x00E2, 0x00E4, 0x00E3, 0x00E5, 0x00E7, 0x00E9, 0x00E8,
    0x00EA, 0x00EB, 0x00ED, 0x00EC, 0x00EE, 0x00EF, 0x00F1, 0x00F3,
    0x00F2, 0x00F4, 0x00F6, 0x00F5, 0x00FA, 0x00F9, 0x00FB, 0x00FC,
    0x2020, 0x00B0, 0x00A2, 0x00A3, 0x00A7, 0x2022, 0x00B6, 0x00DF,
    0x00AE, 0x00A9, 0x2122, 0x00B4, 0x00A8, 0x2260, 0x00C6, 0x00D8,
    0x221E, 0x00B1, 0x2264, 0x2265, 0x00A5, 0x00B5, 0x2202, 0x2211,
    0x220F, 0x03C0, 0x222B, 0x00AA, 0x00BA, 0x03A9, 0x00E6, 0x00F8,
    0x00BF, 0x00A1, 0x00AC, 0x221A, 0x0192, 0x2248, 0x2206, 0x00AB,
    0x00BB, 0x2026, 0x00A0, 0x00C0, 0x00C3, 0x00D5, 0x0152, 0x0153,
    0x2013, 0x2014, 0x201C, 0x201D, 0x2018, 0x2019, 0x00F7, 0x25CA,
    0x00FF, 0x0178, 0x2044, 0x00A4, 0x2039, 0x203A, 0xFB01, 0xFB02,
    0x2021, 0x00B7, 0x201A, 0x201E, 0x2030, 0x00C2, 0x00CA, 0x00C1,
    0x00CB, 0x00C8, 0x00CD, 0x00CE, 0x00CF, 0x00CC, 0x00D3, 0x00D4,
    0xF8FF, 0x00D2, 0x00DA, 0x00DB, 0x00D9, 0x0131, 0x02C6, 0x02DC,
    0x00AF, 0x02D8, 0x02D9, 0x02DA, 0x00B8, 0x02DD, 0x02DB, 0x02C7
};

/* DEC special graphics / technical sets for VT emulation */

#ifdef KERMITFONT
struct x_to_unicode u_dectech = {
    94, 33, X2U_DEC|X2U_STD,AL_ROMAN,"DEC Technical", "dec-technical", 0, ">",
            0xE400, 0x250c, 0x2500, 0x2320, 0x2321, 0x2502, 0xE204,
    0xE203, 0xE209, 0xE208, 0xE202, 0xE201, 0xE207, 0xE206, 0xE200,
    0xE205, 0xE20D, 0xE20C, 0x2572, 0x2571, 0xE20E, 0xE20F, 0x232a,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x2264, 0x2260, 0x2265, 0x222b,
    0x2234, 0x221d, 0x221e, 0x00f7, 0x2206, 0x2207, 0x03a6, 0x0393,
    0x223c, 0x2243, 0x0398, 0x00d7, 0x039b, 0x21d4, 0x21d2, 0x2261,
    0x220f, 0x03a8, 0xE401, 0x03a3, 0xFFFD, 0xfffd, 0x221a, 0x03a9,
    0x039e, 0x03d2, 0x2282, 0x2283, 0x2229, 0x222a, 0x2227, 0x2228,
    0x00ac, 0x03b1, 0x03b2, 0x03c7, 0x03b4, 0x03b5, 0x03c6, 0x03b3,
    0x03b7, 0x03b9, 0x03b8, 0x03ba, 0x03bb, 0xFFFD, 0x03bd, 0x2202,
    0x03c0, 0x03c8, 0x03c1, 0x03c3, 0x03c4, 0xFFFD, 0x0192, 0x03c9,
    0x03be, 0x03c5, 0x03b6, 0x2190, 0x2191, 0x2192, 0x2193
};
#else
struct x_to_unicode u_dectech = {
    94, 33, X2U_DEC|X2U_STD,AL_ROMAN,"DEC Technical", "dec-technical", 0, ">",
            0x221a, 0x250c, 0x2500, 0x2320, 0x2321, 0x2502, 0x2308, /* 21-27 */
    0x230a, 0x2309, 0x230b, 0x256d, 0x2570, 0x256e, 0x256f, 0x2525, /* 28-2f */
    0x251d, 0x2211, 0x2211, 0x2572, 0x2571, 0x231d, 0x231f, 0x232a, /* 30-37 */
    0x005b, 0x2022, 0x005d, 0x00b1, 0x2264, 0x2260, 0x2265, 0x222b, /* 38-3f */
    0x2234, 0x221d, 0x221e, 0x00f7, 0x25b3, 0x25bd, 0x03a6, 0x0393, /* 40-47 */
    0x223c, 0x2243, 0x0398, 0x00d7, 0x039b, 0x21d4, 0x21d2, 0x2261, /* 48-4f */
    0x220f, 0x03a8, 0x2218, 0x2211, 0x00a7, 0x00b6, 0x221a, 0x03a9, /* 50-57 */
    0x039e, 0x03d2, 0x2282, 0x2283, 0x2229, 0x222a, 0x2227, 0x2228, /* 58-5f */
    0x00ac, 0x03b1, 0x03b2, 0x03c7, 0x03b4, 0x03b5, 0x03c6, 0x03b3, /* 60-67 */
    0x03b7, 0x03b9, 0x03b8, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x2202, /* 68-6f */
    0x03c0, 0x03c8, 0x03c1, 0x03c3, 0x03c4, 0x0020, 0x0192, 0x03c9, /* 70-77 */
    0x03be, 0x03c5, 0x03b6, 0x2190, 0x2191, 0x2192, 0x2193          /* 78-7e */
};
#endif /* KERMITFONT */

#ifdef KERMITFONT
struct x_to_unicode u_decspec = {
    94,33,X2U_DEC|X2U_STD,AL_ROMAN,"DEC Special Graphics","dec-special",0,"0",
            0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
    0x2666, 0x2591, 0x2409, 0x240c, 0x240d, 0x240a, 0x00b0, 0x00b1,
    0x2424, 0x240b, 0x2518, 0x2510, 0x250c, 0x2514, 0x253c, 0xE311,
    0xE313, 0xE315, 0xE317, 0xE319, 0x251c, 0x2524, 0x2534, 0x252c,
    0x2502, 0x2264, 0x2265, 0x03c0, 0x2260, 0x00a3, 0x00B7
};
#else
struct x_to_unicode u_decspec = {
    94,33,X2U_DEC|X2U_STD,AL_ROMAN,"DEC Special Graphics","dec-special",0,"0",
            0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f,
    0x2666, 0x2591, 0x2409, 0x240c, 0x240d, 0x240a, 0x00b0, 0x00b1,
    0x2424, 0x240b, 0x2518, 0x2510, 0x250c, 0x2514, 0x253c, 0x2594,
    0x2500, 0x2500, 0x2500, 0x2500, 0x251c, 0x2524, 0x2534, 0x252c,
    0x2502, 0x2264, 0x2265, 0x03a0, 0x2260, 0x00a3, 0x00B7
};
#endif /* KERMITFONT */

/*
  Hazeltine 1500/1520 graphic set.  Includes several approximations:
   . (0,9) should be heavy black right arrow.  Unicode has one of these
     at U+27A1 but...
   . (3,9) should be heavy black down arrow; Unicode doesn't have one.
     So we use the white versions of the heavy arrows instead.
   . (1,9) the letters "Pe" in one cell, doesn't exist in Unicode.
     Substitution is just "P".
*/
struct x_to_unicode u_hz1500 = {
    94,33,X2U_STD,AL_ROMAN,"Hazeltime Graphics","hz1500-graphics",0,"0",
/*     0       1       2       3       4       5       6       7         */
            0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, /* 0 */
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, /* 1 */
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, /* 2 */
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, /* 3 */
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, /* 4 */
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, /* 5 */
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, /* 6 */
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, /* 7 */
    0x2500, 0x2502, 0x253c, 0x2534, 0x252c, 0x2514, 0x250c, 0x00b1, /* 8 */
    0x21e8, 0x0050, 0x00f7, 0x21e9, 0x2510, 0x2518, 0x251c, 0x2524, /* 9 */
    0x0070, 0x0071, 0x0072, 0x250c, 0x0074, 0x0075, 0x0076, 0x0077, /* a */
    0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e	    /* b */

};

#ifdef KERMITFONT
struct x_to_unicode u_heath19g = {
    94,33,X2U_STD,AL_ROMAN,"Heath-19 Special Graphics","h19-special",0,NULL,
            0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x25cf, 0xe30b,
    0x2502, 0x2500, 0x253c, 0x2510, 0x2518, 0x2514, 0x250c, 0x00b1,
    0x2192, 0x2592, 0x00f7, 0x2193, 0xe321, 0xe320, 0xe322, 0xe328,
    0x2580, 0xe325, 0xe30a, 0x252c, 0x2524, 0x2534, 0x251c, 0x2573,
    0x2571, 0x2572, 0xe311, 0xe319, 0xe300, 0xe309, 0x00b6
};
#else
struct x_to_unicode u_heath19g = {
    94,33,X2U_STD,AL_ROMAN,"Heath-19 Special Graphics","h19-special",0,NULL,
            0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
    0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f,
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f,
    0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x25cf, 0x25e5,
    0x2502, 0x2500, 0x253c, 0x2510, 0x2518, 0x2514, 0x250c, 0x00b1,
    0x2192, 0x2592, 0x00f7, 0x2193, 0x2590, 0x258c, 0x258c, 0x2590,
    0x2580, 0x2590, 0x25e4, 0x252c, 0x2524, 0x2534, 0x251c, 0x2573,
    0x2571, 0x2572, 0x2500, 0x2500, 0x2502, 0x2502, 0x00b6
};
#endif /* KERMITFONT */

/* DG Graphic sets - "KERMITFONT" these later... */

/* Missing,    backwards question mark
   eighth note
   "DT" control pic
   horizontal scan lines
*/
struct x_to_unicode u_dgspec = {	/* Needs to be checked */
    94, 33, X2U_STD,AL_ROMAN,"DG Special Graphics","dg-specialgraphics",0,NULL,
            0xfffd, 0xfffd, 0x2424, 0x2594, 0x2594, 0x2581, 0x2581,
    0x25a1, 0x263a, 0x263b, 0x2665, 0x2663, 0x2660, 0x25cf, 0x25d8,
    0x25cb, 0x25d9, 0x2642, 0x2640, 0x266a, 0x266c, 0x263c, 0x2195,
    0x2583, 0x21a8, 0x231e, 0x2194, 0x2207, 0x00ff, 0x20a7, 0x00aa,
    0x00ba, 0x231c, 0x231d, 0x2591, 0x2591, 0x2593, 0x2561, 0x2562,
    0x2556, 0x2555, 0x2563, 0x2551, 0x2557, 0x255d, 0x255c, 0x255b,
    0x255e, 0x255f, 0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550,
    0x256c, 0x2567, 0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552,
    0x2553, 0x256b, 0x256a, 0x2588, 0x2584, 0x258c, 0x2590, 0x2580,
    0x0393, 0x03c0, 0x03a3, 0x03a6, 0x0398, 0x03d5, 0x03b5, 0x03a0,
    0x039e, 0x00b7, 0x03b7, 0x25a0, 0x0178, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd
};

/* Missing: arrow-to-line, various orientations */

struct x_to_unicode u_dgline = {
    94, 33, X2U_STD,AL_ROMAN,"DG Line Drawing","dg-linedrawing",0,NULL,
            0x250c, 0x2510, 0x2514, 0x2518, 0x252c, 0x2524, 0x251c,
    0x2534, 0x253c, 0x2502, 0x2500, 0x219f, 0x21e5, 0x21e4, 0x21a1,
    0x2506, 0x250f, 0x2513, 0x2517, 0x251b, 0x2533, 0x252b, 0x2523,
    0x253b, 0x254b, 0x2503, 0x2501, 0x2504, 0x00f7, 0x00a2, 0x2122,
    0x00ae, 0x00a9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd
};

struct x_to_unicode u_dgword = {
    94, 33, X2U_STD,AL_ROMAN,"DG Word Processing","dg-wordprocessing",0,NULL,
            0x2308, 0x230a, 0x2309, 0x230b, 0x0192, 0x223c, 0x2202,
    0xfffd, 0xfffd, 0x2320, 0x2321, 0x221a, 0xfffd, 0x221e, 0x221d,
    0x2070, 0x00b9, 0x00b2, 0x00b3, 0x2074, 0x2075, 0x2076, 0x2077,
    0x2078, 0x2079, 0x2260, 0xfffd, 0x21ef, 0xfffd, 0x21e5, 0x00b7,
    0x203c, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7,
    0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf,
    0x03c0, 0x03c1, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8,
    0x03c9, 0x03a9, 0x0394, 0x00b6, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x22a6, 0x25c6, 0x25b6, 0x25b7, 0x25c0, 0x25b2, 0x25bc, 0x2327,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x25e3, 0x25e2,
    0x2080, 0x2081, 0x2082, 0x2083, 0x2084, 0x2085, 0x2086, 0x2087,
    0x2088, 0x2089, 0xfffd, 0x2191, 0x2192, 0x2190, 0x2193
};

/* HP Graphic sets - "KERMITFONT" these later... */

/*
  Many are missing from Unicode,
  Single-to-triple-line box-drawing characters.
  Double/double cross & some others.
*/
struct x_to_unicode u_hpline = {	/* Needs to be checked */
    94, 33, X2U_STD,AL_ROMAN,"HP Line Drawing Graphics",
    "hp-line-drawing",0,NULL,
            0x2520, 0x2528, 0x252f, 0x2537, 0x255f, 0x2562, 0x2564,
    0x2567, 0x2551, 0x2542, 0x253f, 0x2550, 0x230a, 0x2502, 0x253c,
    0x254b, 0x2523, 0x252b, 0x2533, 0x253b, 0x251c, 0x2524, 0x252c,
    0x2534, 0x2550, 0x2503, 0x2501, 0x256b, 0x2308, 0x256a, 0x256c,
    0x255e, 0x2517, 0x2549, 0x2588, 0x258c, 0x258e, 0x2514, 0x2518,
    0x2510, 0x2555, 0x252c, 0x2556, 0x2556, 0x2547, 0x2548, 0x2555,
    0x230b, 0x250f, 0x250c, 0x251b, 0x2510, 0x2524, 0x254a, 0x2513,
    0x2584, 0x2309, 0x2582, 0x2561, 0x2504, 0x2559, 0x2576, 0x2565,
    0x255e, 0x2517, 0x2549, 0x2588, 0x258c, 0x258e, 0x2514, 0x2518,
    0x2510, 0x2555, 0x252c, 0x2556, 0x2556, 0x2547, 0x2548, 0x2555,
    0x230b, 0x250f, 0x250c, 0x251b, 0x2510, 0x2524, 0x254a, 0x2513,
    0x2584, 0x2309, 0x2582, 0x2561, 0x2504, 0x2559, 0x2576
};

struct x_to_unicode u_hpmath = {
    94, 33, X2U_STD,AL_ROMAN,"HP Math/Technical","hp-math/technical",0,NULL,
            0x221a, 0x2223, 0x00a7, 0x2207, 0x00b1, 0x03b1, 0x2320,
    0x00f7, 0x2243, 0x03a0, 0x0393, 0x03c8, 0x2261, 0x03a6, 0x039e,
    0x2070, 0x00b9, 0x00b2, 0x00b3, 0x2074, 0x2075, 0x2076, 0x2077,
    0x2078, 0x2079, 0x03a9, 0x039b, 0x221e, 0x2321, 0x2020, 0x03a3,
    0x00b6, 0x03b1, 0x03b2, 0x03c8, 0x03d5, 0x03b5, 0x2202, 0x03bb,
    0x03b7, 0x03b9, 0x0398, 0x03ba, 0x03c9, 0x03bc, 0x03bd, 0x03c1,
    0x03c0, 0x03b3, 0x03b8, 0x03c3, 0x03c4, 0x03be, 0x0394, 0x03b4,
    0x00d7, 0x03c5, 0x03b6, 0x2191, 0x2192, 0x03d2, 0x2190, 0x2193,
    0x00b6, 0x03b1, 0x03b2, 0x03c8, 0x03d5, 0x03b5, 0x2202, 0x03bb,
    0x03b7, 0x03b9, 0x0398, 0x03ba, 0x03c9, 0x03bc, 0x03bd, 0x03c1,
    0x03c0, 0x03b3, 0x03b8, 0x03c3, 0x03c4, 0x03be, 0x0394, 0x03b4,
    0x00d7, 0x03c5, 0x03b6, 0x2191, 0x2192, 0x03d2, 0x2190
};

struct x_to_unicode u_tvig = {
    15,65,0,0,"Televideo Special Graphics","tvi-special",0,NULL,
	    0x2570, 0x256D, 0x256E, 0x256F, 0x2514, 0x250C, 0x2510,
    0x2518, 0x253C, 0x2502, 0x2500, 0x2524, 0x251C, 0x252C, 0x2534
};

struct x_to_unicode u_wyse_gn = {
#ifdef COMMENT
    16,16,0,0,"Wyse Normal-Mode Graphics","wy-graphics-normal",0,NULL,
    0x252C, 0x2514, 0x250C, 0x2510, 0x251C, 0x2518, 0x2502, 0x2588,
    0x253C, 0x2524, 0x2500, 0x2592, 0x2550, 0x2534, 0x2551, 0x2591
#else
    80,48,0,0,"Wyse Normal-Mode Graphics","wy-graphics-normal",0,NULL,
    0x252C, 0x2514, 0x250C, 0x2510, 0x251C, 0x2518, 0x2502, 0x2588,
    0x253C, 0x2524, 0x2500, 0x2592, 0x2550, 0x2534, 0x2551, 0x2591,
    0x252C, 0x2514, 0x250C, 0x2510, 0x251C, 0x2518, 0x2502, 0x2588,
    0x253C, 0x2524, 0x2500, 0x2592, 0x2550, 0x2534, 0x2551, 0x2591,
    0x252C, 0x2514, 0x250C, 0x2510, 0x251C, 0x2518, 0x2502, 0x2588,
    0x253C, 0x2524, 0x2500, 0x2592, 0x2550, 0x2534, 0x2551, 0x2591,
    0x252C, 0x2514, 0x250C, 0x2510, 0x251C, 0x2518, 0x2502, 0x2588,
    0x253C, 0x2524, 0x2500, 0x2592, 0x2550, 0x2534, 0x2551, 0x2591,
    0x252C, 0x2514, 0x250C, 0x2510, 0x251C, 0x2518, 0x2502, 0x2588,
    0x253C, 0x2524, 0x2500, 0x2592, 0x2550, 0x2534, 0x2551, 0x2591
#endif /* COMMENT */
};

struct x_to_unicode u_wyse_g1 = {
    79,48,0,0,"Wyse Graphics 1","wy-graphics-1",0,NULL,
    0x2070, 0x00B9, 0x00B2, 0x00B3, 0x2074, 0x2075, 0x2075, 0x2077,
    0x2078, 0x2079, 0xFFFD, 0xFFFD, 0x25BA, 0x25C4, 0x25B2, 0x25BC,
    0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD,
    0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD,
    0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD,
    0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD,
    0x2080, 0x2081, 0x2082, 0x2083, 0x2084, 0x2085, 0x2086, 0x2087,
    0x2088, 0x2089, 0x2518, 0x2510, 0x250C, 0x2514, 0x253C, 0x258C,
    0x2590, 0x2500, 0x2584, 0x2580, 0x251C, 0x2524, 0x2534, 0x252C,
    0x2502, 0xFFFD, 0x256E, 0x256F, 0x2570, 0x256D, 0x258C
};

struct x_to_unicode u_wyse_g2 = {
    41,64,0,0,"Wyse Graphics 2","wy-graphics-2",0,NULL,
    0x250C, 0xFFFD, 0xFFFD, 0xFFFD, 0x2510, 0xFFFD, 0xFFFD, 0xFFFD,
    0x2514, 0xFFFD, 0xFFFD, 0xFFFD, 0x2518, 0xFFFD, 0xFFFD, 0xFFFD,
    0x252C, 0xFFFD, 0xFFFD, 0xFFFD, 0x2524, 0xFFFD, 0xFFFD, 0xFFFD,
    0x251C, 0xFFFD, 0xFFFD, 0xFFFD, 0x2534, 0xFFFD, 0xFFFD, 0xFFFD,
    0x2500, 0xFFFD, 0xFFFD, 0xFFFD, 0x2502, 0xFFFD, 0xFFFD, 0xFFFD,
    0x253C
};

#ifdef KERMITFONT
struct x_to_unicode u_wyse_g3 = {
    31,65,0,0,"Wyse Graphics 3","wy-graphics-3",0,NULL,
	    0x2570, 0x256D, 0x256E, 0x256F, 0x2514, 0x250C, 0x2510,
    0x2518, 0x253C, 0x2502, 0x2500, 0x2524, 0x251C, 0x252C, 0x2534,
    0xE311, 0xE319, 0x2666, 0xE328, 0xE321, 0xE320, 0xE322, 0x2590,
    0x2584, 0x258C, 0x2580, 0xE323, 0xE326, 0xE327, 0xE329, 0x258C
};
#else
struct x_to_unicode u_wyse_g3 = {
    31,65,0,0,"Wyse Graphics 3","wy-graphics-3",0,NULL,
	    0x2570, 0x256D, 0x256E, 0x256F, 0x2514, 0x250C, 0x2510,
    0x2518, 0x253C, 0x2502, 0x2500, 0x2524, 0x251C, 0x252C, 0x2534,
    0x2500, 0x2500, 0x2666, 0x2590, 0x2590, 0x258c, 0x258c, 0x2590,
    0x2584, 0x258C, 0x2580, 0x2588, 0x2588, 0x2588, 0x2588, 0x258C
};
#endif /* KERMITFONT */
/*
  QNX Console  --  This is exactly the same as CP437 except for the code
  point at 0xEE (epsilon vs element-of), which I think was just a mistake
  in reading glyphs by the QNX people, but who knows.  Also the glyph at
  0xED might be a fi (as it is in CP437, and as I have it here) or it might
  be a null-set symbol.
*/
struct x_to_unicode u_qnxgrph = {
    128,0,0,0,"QNX Console","qnx-console",0,NULL,
    0x00c7, 0x00fc, 0x00e9, 0x00e2, 0x00e4, 0x00e0, 0x00e5, 0x00e7, /* 128 */
    0x00ea, 0x00eb, 0x00e8, 0x00ef, 0x00ee, 0x00ec, 0x00c4, 0x00c5, /* 136 */
    0x00c9, 0x00e6, 0x00c6, 0x00f4, 0x00f6, 0x00f2, 0x00fb, 0x00f9, /* 144 */
    0x00ff, 0x00d6, 0x00dc, 0x00a2, 0x00a3, 0x00a5, 0x20a7, 0x0192, /* 152 */
    0x00e1, 0x00ed, 0x00f3, 0x00fa, 0x00f1, 0x00d1, 0x00aa, 0x00ba, /* 160 */
    0x00bf, 0x2310, 0x00ac, 0x00bd, 0x00bc, 0x00a1, 0x00ab, 0x00bb, /* 168 */
    0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556, /* 176 */
    0x2555, 0x2563, 0x2551, 0x2557, 0x255d, 0x255c, 0x255b, 0x2510, /* 184 */
    0x2514, 0x2534, 0x252c, 0x251c, 0x2500, 0x253c, 0x255e, 0x255f, /* 192 */
    0x255a, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256c, 0x2567, /* 200 */
    0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256b, /* 208 */
    0x256a, 0x2518, 0x250c, 0x2588, 0x2584, 0x258c, 0x2590, 0x2580, /* 216 */
    0x221d, 0x00df, 0x0393, 0x03c0, 0x03a3, 0x03c3, 0x00b5, 0x03c4, /* 224 */
    0x03a6, 0x0398, 0x03a9, 0x03b4, 0x221e, 0x03c6, 0x2208, 0x2229, /* 232 */
    0x2261, 0x00b1, 0x2265, 0x2264, 0x2320, 0x2321, 0x00f7, 0x2248, /* 240 */
    0x00b0, 0x2219, 0x00b7, 0x221a, 0x207f, 0x00b2, 0x25ae, 0x00a0  /* 248 */
};

struct x_to_unicode u_snibrack = {
    94, 33, 0, 0,"Siemens Nixdorf 97801 Brackets","sni-brackets",0,"w",
            0x2590, 0x258c, 0x2584, 0x2580, 0x2590, 0x258c, 0x2584, /* a0-7 */
    0x2580, 0x2329, 0x2327, 0x25af, 0x00b7, 0x25b9, 0x25c1, 0x003c, /* a8-f */
    0x253b, 0x2533, 0x2523, 0x252b, 0x2329, 0x232a, 0x2304, 0x2303, /* b0-7 */
    0x25e4, 0x25e5, 0x25e3, 0x25e2, 0x253f, 0x231b, 0x25cf, 0x25cb, /* b8-f */
    0x2502, 0x2500, 0x250c, 0x2510, 0x2514, 0x2518, 0x251c, 0x2524, /* c0-7 */
    0x252c, 0x2534, 0x253c, 0x2192, 0x2190, 0x2191, 0x2193, 0x2575, /* c8-f */
    0x2577, 0x25d4, 0x256d, 0x256e, 0x2570, 0x256f, 0x251c, 0x2524, /* d0-7 */
    0x252c, 0x2534, 0x253c, 0x253c, 0x2592, 0x2591, 0x2592, 0x2593, /* d8-f */
    0x2503, 0x2501, 0x250f, 0x2513, 0x2517, 0x251b, 0x2523, 0x252b, /* e0-7 */
    0x2533, 0x253b, 0x254b, 0x279e, 0x2190, 0x2191, 0x2193, 0x2579, /* e8-f */
    0x257b, 0x2261, 0x2554, 0x2557, 0x255a, 0x255d, 0x2523, 0x252b, /* f0-7 */
    0x2533, 0x253b, 0x254b, 0x254b, 0x0393, 0x03c3, 0x03c4          /* f8-f */
};

struct x_to_unicode u_sniblanks = {
    94, 33, 0, 0,"Siemens Nixdorf 97801 Blanks","sni-blanks",0,"y",
            0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, /* a0-7 */
    0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, /* a8-f */
    0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, /* b0-7 */
    0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, /* b8-f */
    0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, /* c0-7 */
    0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, /* c8-f */
    0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, /* d0-7 */
    0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, /* d8-f */
    0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, /* e0-7 */
    0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, /* e8-f */
    0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, /* f0-7 */
    0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020          /* f8-f */
};

struct x_to_unicode u_snifacet = {
    94, 33, 0, 0,"Siemens Nixdorf 97801 Facet","sni-facet",0,"c",
            0x0020, 0x2581, 0x2582, 0x2583, 0x2584, 0x2585, 0x2587, /* a1-a7 */
    0x005f, 0x2581, 0x2582, 0x2583, 0x2584, 0x2585, 0x2586, 0x2587, /* a8-af */
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, /* b0-b7 */
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, /* b8-bf */
    0x2503, 0x2501, 0x250f, 0x2513, 0x2517, 0x251b, 0x2523, 0x252b, /* c0-c7 */
    0x2533, 0x253b, 0x254b, 0x258f, 0x2595, 0xfffd, 0xfffd, 0xfffd, /* c8-cf */
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, /* d0-d7 */
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x2591, 0x2591, 0x2588, /* d8-df */
    0x2503, 0x2501, 0x250f, 0x2513, 0x2517, 0x251b, 0x2523, 0x252b, /* e0-e7 */
    0x2533, 0x253b, 0x254b, 0xfffd, 0xfffd, 0x2593, 0x2593, 0x0020, /* e8-ef */
    0x2585, 0x2586, 0x2587, 0x2588, 0xfffd, 0xfffd, 0xfffd, 0xfffd, /* f0-f7 */
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x2594, 0x2594, 0xfffd          /* f8-fe */
};

struct x_to_unicode u_sniibm = {
    94, 33, 0, 0,"Siemens Nixdorf 97801 IBM","sni-ibm",0,"v",
            0x263a, 0x263b, 0x2665, 0x2666, 0x2663, 0x2660, 0x25cf,
    0x25d8, 0x25cb, 0x25d9, 0x2642, 0x2640, 0x266a, 0x266b, 0x263c,
    0x25ba, 0x25c4, 0x2195, 0x203c, 0x00b6, 0x25c1, 0x2582, 0x21a8,
    0x2191, 0x2193, 0x2192, 0x2190, 0x2319, 0x2194, 0x25b4, 0x25be,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, /* Hex */
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, /* bytes */
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0x2070, 0x00b9, 0x00b2, 0x00b3, 0x2074, 0x2075, 0x2076, 0x2077,
    0x2078, 0x2079, 0x207b, 0x207a, 0xfffd, 0xfffd, 0x2320, 0x2321,
    0x2080, 0x2081, 0x2082, 0x2083, 0x2084, 0x2085, 0x2086, 0x2087,
    0x2088, 0x2089, 0x208b, 0x208a, 0x221e, 0x03b1, 0x03a6
};

struct x_to_unicode u_snieuro = {
    94, 33, 0, 0,"Siemens Nixdorf 97801 Euro","sni-euro",0,"u",
            0x00e0, 0x00e1, 0x00e2, 0x00e4, 0x00e5, 0x0105, 0x00e3,
    0x0103, 0x00e6, 0x00e7, 0x010d, 0x0107, 0x00f0, 0x0111, 0x010f,
    0x00e8, 0x00e9, 0x00ea, 0x00eb, 0x011b, 0x0119, 0x011f, 0x0131,
    0x00ee, 0x00ec, 0x01d0, 0x00ef, 0x0133, 0x013a, 0x0142, 0x013e,
    0x0148, 0x0144, 0x00f1, 0x00f2, 0x00f3, 0x00f4, 0x00f6, 0x00f5,
    0x00f8, 0x0151, 0x0153, 0x00fe, 0x0159, 0x0155, 0x0161, 0x015b,
    0x015f, 0x00df, 0x0163, 0x0165, 0x00f9, 0x00fa, 0x00fb, 0x00fc,
    0x016f, 0x0171, 0x00fd, 0x00ff, 0x017e, 0x017a, 0x017c, 0x00c9,
    0x00c5, 0x00c6, 0x00d0, 0x0130, 0x0132, 0x0167, 0x00d8, 0x0152,
    0x00de, 0x00c4, 0x00d6, 0x00dc, 0x00a7, 0x0024, 0x00a3, 0x00ae,
    0x00a9, 0x03a9, 0x00b5, 0x00b0, 0x00c7, 0x20a7, 0x03c0, 0x02d8,
    0x00b4, 0x02dd, 0x00d1, 0x2514, 0x2518, 0x007e, 0x02c7
};

struct x_to_unicode u_smiley = {
    32,0,X2U_CXG,0,"PC C0 Graphics","smiley-faces",0,NULL,
    0x00a0, 0x263a, 0x263b, 0x2665, 0x2666, 0x2663, 0x2660, 0x2022,
    0x25d8, 0x25ef, 0x25d9, 0x2642, 0x2640, 0x266a, 0x266c, 0x263c,
    0x25ba, 0x25c4, 0x2195, 0x203c, 0x00b6, 0x00a7, 0x25ac, 0x21a8,
    0x2191, 0x2193, 0x2192, 0x2190, 0x2319, 0x2194, 0x25b2, 0x25bc
};

struct x_to_unicode u_c0pics = {
    128,0,X2U_CXG,0,"C0/C1 Display Controls","display-controls",0,NULL,
    0x2400, 0x2401, 0x2402, 0x2403, 0x2404, 0x2405, 0x2406, 0x2407,
    0x2408, 0x2409, 0x240a, 0x240b, 0x240c, 0x240d, 0x240e, 0x240f,
    0x2410, 0x2411, 0x2412, 0x2413, 0x2414, 0x2415, 0x2416, 0x2417,
    0x2418, 0x2419, 0x241a, 0x241b, 0x241c, 0x241d, 0x241e, 0x241f,
    0x2420, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x2421
};

#ifdef KERMITFONT
struct x_to_unicode u_c1pics = {
    32,0,X2U_CXG,0,"C1 Display Controls","c1-display-controls",0,NULL,
    0xe080, 0xe081, 0xe082, 0xe083, 0xe084, 0xe085, 0xe086, 0xe087,
    0xe088, 0xe089, 0xe08a, 0xe08b, 0xe08c, 0xe08d, 0xe08e, 0xe08f,
    0xe090, 0xe091, 0xe092, 0xe093, 0xe094, 0xe095, 0xe096, 0xe097,
    0xe098, 0xe099, 0xe09a, 0xe09b, 0xe09c, 0xe09d, 0xe09e, 0xe09f
};
#else
struct x_to_unicode u_c1pics = {
    32,0,X2U_CXG,0,"C1 Display Controls","c1-display-controls",0,NULL,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
    0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd
};
#endif /* KERMITFONT */


/* Blah-to-Unicode functions */

USHORT
#ifdef CK_ANSIC
ascii_u(CHAR c)
#else
ascii_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
/*
  NOTE: Strict ANSI compilers complain about "<" and similar comparisons
  between unsigned and signed quantities, as found in all the routines of
  the "blah_u()" class -- casts must be added to squelch the warnings.
*/
    if (c < u_ascii.offset)
      return(c);
    else if (c >= u_ascii.offset + u_ascii.size)
      return(c);
    else
      return(u_ascii.map[c - u_ascii.offset]);
}

USHORT
#ifdef CK_ANSIC
british_u(CHAR c)
#else
british_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_british.offset)
      return(c);
    else if (c >= u_british.offset + u_british.size)
      return(c);
    else
      return(u_british.map[c - u_british.offset]);
}

USHORT
#ifdef CK_ANSIC
dutch_u(CHAR c)
#else
dutch_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_dutch.offset)
      return(c);
    else if (c >= u_dutch.offset + u_dutch.size)
      return(c);
    else
      return(u_dutch.map[c - u_dutch.offset]);
}

USHORT
#ifdef CK_ANSIC
finnish_u(CHAR c)
#else
finnish_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_finnish.offset)
      return(c);
    else if (c >= u_finnish.offset + u_finnish.size)
      return(c);
    else
      return(u_finnish.map[c - u_finnish.offset]);
}

USHORT
#ifdef CK_ANSIC
french_u(CHAR c)
#else
french_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_french.offset)
      return(c);
    else if (c >= u_french.offset + u_french.size)
      return(c);
    else
      return(u_french.map[c - u_french.offset]);
}

USHORT
#ifdef CK_ANSIC
fr_canadian_u(CHAR c)
#else
fr_canadian_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_fr_canadian.offset)
      return(c);
    else if (c >= u_fr_canadian.offset + u_fr_canadian.size)
      return(c);
    else
      return(u_fr_canadian.map[c - u_fr_canadian.offset]);
}

USHORT
#ifdef CK_ANSIC
german_u(CHAR c)
#else
german_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_german.offset)
      return(c);
    else if (c >= u_german.offset + u_german.size)
      return(c);
    else
      return(u_german.map[c - u_german.offset]);
}

USHORT
#ifdef CK_ANSIC
hungarian_u(CHAR c)
#else
hungarian_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_hungarian.offset)
      return(c);
    else if (c >= u_hungarian.offset + u_hungarian.size)
      return(c);
    else
      return(u_hungarian.map[c - u_hungarian.offset]);
}

USHORT
#ifdef CK_ANSIC
italian_u(CHAR c)
#else
italian_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_italian.offset)
      return(c);
    else if (c >= u_italian.offset + u_italian.size)
      return(c);
    else
      return(u_italian.map[c - u_italian.offset]);
}

USHORT
#ifdef CK_ANSIC
icelandic_u(CHAR c)
#else
icelandic_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_icelandic.offset)
      return(c);
    else if (c >= u_icelandic.offset + u_icelandic.size)
      return(c);
    else
      return(u_icelandic.map[c - u_icelandic.offset]);
}

USHORT
#ifdef CK_ANSIC
jis0201r_u(CHAR c)
#else
jis0201r_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_jis0201r.offset)
      return(c);
    else if (c >= u_jis0201r.offset + u_jis0201r.size)
      return(c);
    else
      return(u_jis0201r.map[c - u_jis0201r.offset]);
}

USHORT
#ifdef CK_ANSIC
jis0201k_u(CHAR c)
#else
jis0201k_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_jis0201k.offset)
      return(c);
    else if (c >= u_jis0201k.offset + u_jis0201k.size)
      return(c);
    else
      return(u_jis0201k.map[c - u_jis0201k.offset]);
}

USHORT
#ifdef CK_ANSIC
norwegian_u(CHAR c)
#else
norwegian_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_norwegian.offset)
      return(c);
    else if (c >= u_norwegian.offset + u_norwegian.size)
      return(c);
    else
      return(u_norwegian.map[c - u_norwegian.offset]);
}

USHORT
#ifdef CK_ANSIC
danish_u(CHAR c)
#else
danish_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_danish.offset)
      return(c);
    else if (c >= u_danish.offset + u_danish.size)
      return(c);
    else
      return(u_danish.map[c - u_danish.offset]);
}

USHORT
#ifdef CK_ANSIC
portuguese_u(CHAR c)
#else
portuguese_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_portuguese.offset)
      return(c);
    else if (c >= u_portuguese.offset + u_portuguese.size)
      return(c);
    else
      return(u_portuguese.map[c - u_portuguese.offset]);
}

USHORT
#ifdef CK_ANSIC
spanish_u(CHAR c)
#else
spanish_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_spanish.offset)
      return(c);
    else if (c >= u_spanish.offset + u_spanish.size)
      return(c);
    else
      return(u_spanish.map[c - u_spanish.offset]);
}

USHORT
#ifdef CK_ANSIC
swedish_u(CHAR c)
#else
swedish_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_swedish.offset)
      return(c);
    else if (c >= u_swedish.offset + u_swedish.size)
      return(c);
    else
      return(u_swedish.map[c - u_swedish.offset]);
}

USHORT
#ifdef CK_ANSIC
swiss_u(CHAR c)
#else
swiss_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_swiss.offset)
      return(c);
    else if (c >= u_swiss.offset + u_swiss.size)
      return(c);
    else
      return(u_swiss.map[c - u_swiss.offset]);
}

USHORT
#ifdef CK_ANSIC
ident_u(CHAR c)
#else /* CK_ANSIC */
ident_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return((USHORT)c);
}

USHORT
#ifdef CK_ANSIC
iso_8859_1_u(CHAR c)
#else
iso_8859_1_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_8859_1.offset)
      return(c);
    else if (c >= u_8859_1.offset + u_8859_1.size)
      return(c);
    else
      return(u_8859_1.map[c - u_8859_1.offset]);
}

USHORT
#ifdef CK_ANSIC
iso_8859_2_u(CHAR c)
#else
iso_8859_2_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_8859_2.offset)
      return(c);
    else if (c >= u_8859_2.offset + u_8859_2.size)
      return(c);
    else
      return(u_8859_2.map[c - u_8859_2.offset]);
}

USHORT
#ifdef CK_ANSIC
iso_8859_3_u(CHAR c)
#else
iso_8859_3_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_8859_3.offset)
      return(c);
    else if (c >= u_8859_3.offset + u_8859_3.size)
      return(c);
    else
      return(u_8859_3.map[c - u_8859_3.offset]);
}

USHORT
#ifdef CK_ANSIC
iso_8859_4_u(CHAR c)
#else
iso_8859_4_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_8859_4.offset)
      return(c);
    else if (c >= u_8859_4.offset + u_8859_4.size)
      return(c);
    else
      return(u_8859_4.map[c - u_8859_4.offset]);
}

USHORT
#ifdef CK_ANSIC
iso_8859_5_u(CHAR c)
#else
iso_8859_5_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_8859_5.offset)
      return(c);
    else if (c >= u_8859_5.offset + u_8859_5.size)
      return(c);
    else
      return(u_8859_5.map[c - u_8859_5.offset]);
}

USHORT
#ifdef CK_ANSIC
koi8_u(CHAR c)
#else
koi8_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_koi8.offset)
      return(c);
    else if (c >= u_koi8.offset + u_koi8.size)
      return(c);
    else
      return(u_koi8.map[c - u_koi8.offset]);
}

USHORT
#ifdef CK_ANSIC
koi8r_u(CHAR c)				/* KOI8-R to Unicode */
#else
koi8r_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    debug(F001,"koi8r_u","",c);
    c &= 0x7f;
    if (c < u_koi8r.offset)
      return(c);
    else if (c >= u_koi8r.offset + u_koi8r.size)
      return(c);
    else
      return(u_koi8r.map[c - u_koi8r.offset]);
}

USHORT
#ifdef CK_ANSIC
koi8u_u(CHAR c)
#else
koi8u_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_koi8u.offset)
      return(c);
    else if (c >= u_koi8u.offset + u_koi8u.size)
      return(c);
    else
      return(u_koi8u.map[c - u_koi8u.offset]);
}

USHORT
#ifdef CK_ANSIC
iso_8859_6_u(CHAR c)
#else
iso_8859_6_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_8859_6.offset)
      return(c);
    else if (c >= u_8859_6.offset + u_8859_6.size)
      return(c);
    else
      return(u_8859_6.map[c - u_8859_6.offset]);
}

USHORT
#ifdef CK_ANSIC
iso_8859_7_u(CHAR c)
#else
iso_8859_7_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_8859_7.offset)
      return(c);
    else if (c >= u_8859_7.offset + u_8859_7.size)
      return(c);
    else
      return(u_8859_7.map[c - u_8859_7.offset]);
}

USHORT
#ifdef CK_ANSIC
iso_8859_8_u(CHAR c)
#else
iso_8859_8_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_8859_8.offset)
      return(c);
    else if (c >= u_8859_8.offset + u_8859_8.size)
      return(c);
    else
      return(u_8859_8.map[c - u_8859_8.offset]);
}

USHORT
#ifdef CK_ANSIC
hebrew7_u(CHAR c)
#else
hebrew7_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_hebrew7.offset)
      return(c);
    else if (c >= u_hebrew7.offset + u_hebrew7.size)
      return(c);
    else
      return(u_hebrew7.map[c - u_hebrew7.offset]);
}

USHORT
#ifdef CK_ANSIC
elot927_u(CHAR c)
#else
elot927_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_elot927.offset)
      return(c);
    else if (c >= u_elot927.offset + u_elot927.size)
      return(c);
    else
      return(u_elot927.map[c - u_elot927.offset]);
}

USHORT
#ifdef CK_ANSIC
iso_8859_9_u(CHAR c)
#else
iso_8859_9_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_8859_9.offset)
      return(c);
    else if (c >= u_8859_9.offset + u_8859_9.size)
      return(c);
    else
      return(u_8859_9.map[c - u_8859_9.offset]);
}

USHORT
#ifdef CK_ANSIC
iso_8859_10_u(CHAR c)
#else
iso_8859_10_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_8859_10.offset)
      return(c);
    else if (c >= u_8859_10.offset + u_8859_10.size)
      return(c);
    else
      return(u_8859_10.map[c - u_8859_10.offset]);
}

USHORT
#ifdef CK_ANSIC
iso_8859_15_u(CHAR c)
#else
iso_8859_15_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_8859_15.offset)
      return(c);
    else if (c >= u_8859_15.offset + u_8859_15.size)
      return(c);
    else
      return(u_8859_15.map[c - u_8859_15.offset]);
}

USHORT
#ifdef CK_ANSIC
koi7_u(CHAR c)
#else
koi7_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_koi7.offset)
      return(c);
    else if (c >= u_koi7.offset + u_koi7.size)
      return(c);
    else
      return(u_koi7.map[c - u_koi7.offset]);
}

USHORT
#ifdef CK_ANSIC
decmcs_u(CHAR c)
#else
decmcs_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_decmcs.offset)
      return(c);
    else if (c >= u_decmcs.offset + u_decmcs.size)
      return(c);
    else
      return(u_decmcs.map[c - u_decmcs.offset]);
}

USHORT
#ifdef CK_ANSIC
nextstep_u(CHAR c)
#else
nextstep_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_nextstep.map[(c & 0x7f) - u_nextstep.offset]);
}

USHORT
#ifdef CK_ANSIC
dgi_u(CHAR c)
#else
dgi_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_dgi.map[(c & 0x7f) - u_dgi.offset]);
}

USHORT
#ifdef CK_ANSIC
hproman8_u(CHAR c)
#else
hproman8_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_hproman8.map[(c & 0x7f) - u_hproman8.offset]);
}

USHORT
#ifdef CK_ANSIC
cp37_u(CHAR c)
#else
cp37_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp37.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp437_u(CHAR c)
#else
cp437_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp437.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
mazovia_u(CHAR c) /* Mazovia = CP437 with substitutions */
#else
mazovia_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_mazovia.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp850_u(CHAR c)
#else
cp850_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp850.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp858_u(CHAR c)
#else
cp858_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp858.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp1250_u(CHAR c)
#else
cp1250_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp1250.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp1251_u(CHAR c)
#else
cp1251_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp1251.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp1252_u(CHAR c)
#else
cp1252_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp1252.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp1253_u(CHAR c)
#else
cp1253_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp1253.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp1254_u(CHAR c)
#else
cp1254_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp1254.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp1255_u(CHAR c)
#else
cp1255_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp1255.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp1256_u(CHAR c)
#else
cp1256_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp1256.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp1257_u(CHAR c)
#else
cp1257_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp1257.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp1258_u(CHAR c)
#else
cp1258_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp1258.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp852_u(CHAR c)
#else
cp852_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp852.map[c & 0x7f]);
}

USHORT					/* Cyrillic */
#ifdef CK_ANSIC
cp855_u(CHAR c)
#else
cp855_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp855.map[c & 0x7f]);
}

USHORT					/* Bulgaria */
#ifdef CK_ANSIC
cp856_u(CHAR c)
#else
cp856_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp856.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp857_u(CHAR c)
#else
cp857_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp857.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp862_u(CHAR c)
#else
cp862_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp862.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp864_u(CHAR c)
#else
cp864_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp864.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp866_u(CHAR c)
#else
cp866_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp866.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
cp869_u(CHAR c)
#else
cp869_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_cp869.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
maclatin_u(CHAR c)
#else
maclatin_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_maclatin.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
quickdraw_u(CHAR c)
#else
quickdraw_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    return(u_quickdraw.map[c & 0x7f]);
}

USHORT
#ifdef CK_ANSIC
decspec_u(CHAR c)
#else
decspec_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_decspec.offset)
      return(c);
    else if (c >= u_decspec.offset + u_decspec.size)
      return(c);
    else
      return(u_decspec.map[c - u_decspec.offset]);
}

USHORT
#ifdef CK_ANSIC
dectech_u(CHAR c)
#else
dectech_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_dectech.offset)
      return(c);
    else if (c >= u_dectech.offset + u_dectech.size)
      return(c);
    else
      return(u_dectech.map[c - u_dectech.offset]);
}

USHORT
#ifdef CK_ANSIC
dgspec_u(CHAR c)
#else
dgspec_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_dgspec.offset)
      return(c);
    else if (c >= u_dgspec.offset + u_dgspec.size)
      return(c);
    else
      return(u_dgspec.map[c - u_dgspec.offset]);
}

USHORT
#ifdef CK_ANSIC
dgline_u(CHAR c)
#else
dgline_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_dgline.offset)
      return(c);
    else if (c >= u_dgline.offset + u_dgline.size)
      return(c);
    else
      return(u_dgline.map[c - u_dgline.offset]);
}

USHORT
#ifdef CK_ANSIC
dgword_u(CHAR c)
#else
dgword_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_dgword.offset)
      return(c);
    else if (c >= u_dgword.offset + u_dgword.size)
      return(c);
    else
      return(u_dgword.map[c - u_dgword.offset]);
}

USHORT
#ifdef CK_ANSIC
hpline_u(CHAR c)
#else
hpline_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_hpline.offset)
      return(c);
    else if (c >= u_hpline.offset + u_hpline.size)
      return(c);
    else
      return(u_hpline.map[c - u_hpline.offset]);
}

USHORT
#ifdef CK_ANSIC
hpmath_u(CHAR c)
#else
hpmath_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_hpmath.offset)
      return(c);
    else if (c >= u_hpmath.offset + u_hpmath.size)
      return(c);
    else
      return(u_hpmath.map[c - u_hpmath.offset]);
}

USHORT
#ifdef CK_ANSIC
qnxgrph_u(CHAR c)
#else
qnxgrph_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_qnxgrph.offset)
      return(c);
    else if (c >= u_qnxgrph.offset + u_qnxgrph.size)
      return(c);
    else
      return(u_qnxgrph.map[c - u_qnxgrph.offset]);
}

USHORT
#ifdef CK_ANSIC
hz1500_u(CHAR c)
#else
hz1500_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_hz1500.offset)
      return(c);
    else if (c >= u_hz1500.offset + u_hz1500.size)
      return(c);
    else
      return(u_hz1500.map[c - u_hz1500.offset]);
}

USHORT
#ifdef CK_ANSIC
sniblanks_u(CHAR c)
#else
sniblanks_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_sniblanks.offset)
      return(c);
    else if (c >= u_sniblanks.offset + u_sniblanks.size)
      return(c);
    else
      return(u_sniblanks.map[c - u_sniblanks.offset]);
}

USHORT
#ifdef CK_ANSIC
snibrack_u(CHAR c)
#else
snibrack_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_snibrack.offset)
      return(c);
    else if (c >= u_snibrack.offset + u_snibrack.size)
      return(c);
    else
      return(u_snibrack.map[c - u_snibrack.offset]);
}

USHORT
#ifdef CK_ANSIC
snifacet_u(CHAR c)
#else
snifacet_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_snifacet.offset)
      return(c);
    else if (c >= u_snifacet.offset + u_snifacet.size)
      return(c);
    else
      return(u_snifacet.map[c - u_snifacet.offset]);
}

USHORT
#ifdef CK_ANSIC
sniibm_u(CHAR c)
#else
sniibm_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_sniibm.offset)
      return(c);
    else if (c >= u_sniibm.offset + u_sniibm.size)
      return(c);
    else
      return(u_sniibm.map[c - u_sniibm.offset]);
}

USHORT
#ifdef CK_ANSIC
snieuro_u(CHAR c)
#else
snieuro_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_snieuro.offset)
      return(c);
    else if (c >= u_snieuro.offset + u_snieuro.size)
      return(c);
    else
      return(u_snieuro.map[c - u_snieuro.offset]);
}

USHORT
#ifdef CK_ANSIC
heath19g_u(CHAR c)
#else
heath19g_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_heath19g.offset)
      return(c);
    else if (c >= u_heath19g.offset + u_heath19g.size)
      return(c);
    else
      return(u_heath19g.map[c - u_heath19g.offset]);
}

USHORT
#ifdef CK_ANSIC
tvig_u(CHAR c)
#else
tvig_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_tvig.offset)
      return(c);
    else if (c >= u_tvig.offset + u_tvig.size)
      return(c);
    else
      return(u_tvig.map[c - u_tvig.offset]);
}

USHORT
#ifdef CK_ANSIC
wyse_gn_u(CHAR c)
#else
wyse_gn_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_wyse_gn.offset)
      return(c);
    else if (c >= u_wyse_gn.offset + u_wyse_gn.size)
      return(c);
    else
      return(u_wyse_gn.map[c - u_wyse_gn.offset]);
}

USHORT
#ifdef CK_ANSIC
wyse_g1_u(CHAR c)
#else
wyse_g1_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_wyse_g1.offset)
      return(c);
    else if (c >= u_wyse_g1.offset + u_wyse_g1.size)
      return(c);
    else
      return(u_wyse_g1.map[c - u_wyse_g1.offset]);
}

USHORT
#ifdef CK_ANSIC
wyse_g2_u(CHAR c)
#else
wyse_g2_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_wyse_g2.offset)
      return(c);
    else if (c >= u_wyse_g2.offset + u_wyse_g2.size)
      return(c);
    else
      return(u_wyse_g2.map[c - u_wyse_g2.offset]);
}

USHORT
#ifdef CK_ANSIC
wyse_g3_u(CHAR c)
#else
wyse_g3_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_wyse_g3.offset)
      return(c);
    else if (c >= u_wyse_g3.offset + u_wyse_g3.size)
      return(c);
    else
      return(u_wyse_g3.map[c - u_wyse_g3.offset]);
}

USHORT
#ifdef CK_ANSIC
smiley_u(CHAR c)
#else
smiley_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_smiley.offset)
      return(c);
    else if (c >= u_smiley.offset + u_smiley.size)
      return(c);
    else
      return(u_smiley.map[c - u_smiley.offset]);
}

USHORT
#ifdef CK_ANSIC
c0pics_u(CHAR c)
#else
c0pics_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_c0pics.offset)
      return(c);
    else if (c >= u_c0pics.offset + u_c0pics.size)
      return(c);
    else
      return(u_c0pics.map[c - u_c0pics.offset]);
}

USHORT
#ifdef CK_ANSIC
c1pics_u(CHAR c)
#else
c1pics_u(c) CHAR c;
#endif /* CK_ANSIC */
{
    c &= 0x7f;
    if (c < u_c1pics.offset)
      return(c);
    else if (c >= u_c1pics.offset + u_c1pics.size)
      return(c);
    else
      return(u_c1pics.map[c - u_c1pics.offset]);
}

#ifdef KANJI				/* Kanji/Unicode functions */

static long				/* Statistics counters */
  bytes = 0,				/* REMOVE THESE LATER... */
  bad = 0,
  kanji = 0,
  kana = 0,
  greek = 0,
  cyrillic = 0,
  special = 0,
  other = 0,
  roman = 0;

USHORT
#ifdef CK_ANSIC
sj_to_un(USHORT sj)			/* Shift-JIS to Unicode */
#else
sj_to_un(sj) USHORT sj;
#endif /* CK_ANSIC */
{

/* Kanji blocks */

    if (sj >= 0x8140) {			/* All possible Kanjis */
	kanji++;			/* Optimistically count a Kanji */
	if (sj <= 0x9ffc) {		/* 7869-element table */
	    return(sju_8140[sj - 0x8140]);
	} else if (sj >= 0xe040 && sj <= 0xeaa4) { /* 2660-element table */
	    return(sju_e040[sj - 0xe040]);
	} else if (sj >= 0xf040) {	/* User-defined areas */
	    if (sj <= 0xf0fc) {		/* ten 189-char chunks */
		return(0xe000 + (sj - 0xf040));
	    } else if (sj >= 0xf140 && sj <= 0xf1fc) {
		return(0xe0bc + (sj - 0xf140));
	    } else if (sj >= 0xf240 && sj <= 0xf2fc) {
		return(0xe178 + (sj - 0xf240));
	    } else if (sj >= 0xf340 && sj <= 0xf3fc) {
		return(0xe234 + (sj - 0xf340));
	    } else if (sj >= 0xf440 && sj <= 0xf4fc) {
		return(0xe2f0 + (sj - 0xf440));
	    } else if (sj >= 0xf540 && sj <= 0xf5fc) {
		return(0xe3ac + (sj - 0xf540));
	    } else if (sj >= 0xf640 && sj <= 0xf6fc) {
		return(0xe468 + (sj - 0xf640));
	    } else if (sj >= 0xf740 && sj <= 0xf7fc) {
		return(0xe524 + (sj - 0xf740));
	    } else if (sj >= 0xf840 && sj <= 0xf8fc) {
		return(0xe5e0 + (sj - 0xf840));
	    } else if (sj >= 0xf940 && sj <= 0xf9fc) {
		return(0xe69c + (sj - 0xf940));
	    }
	}
	kanji--;			/* None of the above, uncount */
    }

/* C0 / Halfwidth-Roman / C1 block (0x00-0x9f, no holes) */

    else if (sj < 0x00a0) {
	roman++;			/* Count a Roman */
	if (sj == 0x5c) {		/* Yen sign */
	    return(0x00a5);
	} else if (sj == 0x7e) {	/* Overline (macron) */
	    return(0x203e);
	} else {			/* Control or Halfwidth Roman */
	    return(sj);
	}
    }

/* Halfwidth Katakana block (0xa0-0xdf, no holes) */

    else if (sj >= 0xa1 && sj <= 0xdf) {
	kana++;
	return(sj + 0xfec0);
    }

/* Catch-all must be final */

    bad++;
    return(0xfffd);
}

USHORT
#ifdef CK_ANSIC
un_to_sj(USHORT un)			/* Unicode to Shift-JIS */
#else
un_to_sj(un) USHORT un;
#endif /* CK_ANSIC */
{

    if (un < 0x00a0) {
	switch (un) {
	  case 0x005c: roman++; return(0x815f);	/* Backslash */
	  case 0x007e: bad++;	return(0xfffd);	/* No tilde in Shift-JIS */
	  default:				/* ASCII or C0/C1 control */
	    roman++;
	    return(un);
	}
    }
    if (un >= 0x00a0 && un < 0x0391) { /* Latin-1 symbols */
	roman++;
	switch(un) {
	  case 0x00A2: return(0x8191);
	  case 0x00A3: return(0x8192);
	  case 0x00A5: return(0x005C);	/* Yen */
	  case 0x00A7: return(0x8198);
	  case 0x00A8: return(0x814E);
	  case 0x00AC: return(0x81CA);
	  case 0x00B0: return(0x818B);
	  case 0x00B1: return(0x817D);
	  case 0x00B4: return(0x814C);
	  case 0x00B6: return(0x81F7);
	  case 0x00D7: return(0x817E);
	  case 0x00F7: return(0x8180);
	  default:
	    roman--;
	    bad++;
	    return(0xfffd);
	}
    }
    if (un >= 0x0391 && un < 0x0401) {	/* Greek */
	greek++;
	if (un <= 0x039c)
	  return(usj_0391[un-0x0391]);
	greek--;
	bad++;
	return(0xfffd);
    }
    if (un >= 0x0401 && un < 0x2010) {	/* Cyrillic */
	cyrillic++;
	if (un <= 0x0451)
	  return(usj_0401[un-0x0401]);
	cyrillic--;
	bad++;
	return(0xfffd);
    }
    if (un >= 0x2010 && un < 0x2500) {	/* General punctuation */
	special++;
	switch(un) {
	  case 0x2010: return(0x815D);
	  case 0x2015: return(0x815C);
	  case 0x2016: return(0x8161);
	  case 0x2018: return(0x8165);
	  case 0x2019: return(0x8166);
	  case 0x201C: return(0x8167);
	  case 0x201D: return(0x8168);
	  case 0x2020: return(0x81F5);
	  case 0x2021: return(0x81F6);
	  case 0x2025: return(0x8164);
	  case 0x2026: return(0x8163);
	  case 0x2030: return(0x81F1);
	  case 0x2032: return(0x818C);
	  case 0x2033: return(0x818D);
	  case 0x203B: return(0x81A6);
	  case 0x203E: return(0x007E);
	  case 0x2103: return(0x818E);	/* Letterlike symbols */
	  case 0x212B: return(0x81F0);
	  case 0x2190: return(0x81A9);	/* Arrows */
	  case 0x2191: return(0x81AA);
	  case 0x2192: return(0x81A8);
	  case 0x2193: return(0x81AB);
	  case 0x21D2: return(0x81CB);
	  case 0x21D4: return(0x81CC);
	  case 0x2200: return(0x81CD);	/* Math */
	  case 0x2202: return(0x81DD);
	  case 0x2203: return(0x81CE);
	  case 0x2207: return(0x81DE);
	  case 0x2208: return(0x81B8);
	  case 0x220B: return(0x81B9);
	  case 0x2212: return(0x817C);
	  case 0x221A: return(0x81E3);
	  case 0x221D: return(0x81E5);
	  case 0x221E: return(0x8187);
	  case 0x2220: return(0x81DA);
	  case 0x2227: return(0x81C8);
	  case 0x2228: return(0x81C9);
	  case 0x2229: return(0x81BF);
	  case 0x222A: return(0x81BE);
	  case 0x222B: return(0x81E7);
	  case 0x222C: return(0x81E8);
	  case 0x2234: return(0x8188);
	  case 0x2235: return(0x81E6);
	  case 0x223D: return(0x81E4);
	  case 0x2252: return(0x81E0);
	  case 0x2260: return(0x8182);
	  case 0x2261: return(0x81DF);
	  case 0x2266: return(0x8185);
	  case 0x2267: return(0x8186);
	  case 0x226A: return(0x81E1);
	  case 0x226B: return(0x81E2);
	  case 0x2282: return(0x81BC);
	  case 0x2283: return(0x81BD);
	  case 0x2286: return(0x81BA);
	  case 0x2287: return(0x81BB);
	  case 0x22A5: return(0x81DB);
	  case 0x2312: return(0x81DC);	/* Arc */
	  default:
	    special--;
	    bad++;
	    return(0xfffd);
	}
    }
    if (un >= 0x2500 && un < 0x3000) {	/* Box drawing */
	special++;
	switch(un) {
	  case 0x2500: return(0x849F);
	  case 0x2501: return(0x84AA);
	  case 0x2502: return(0x84A0);
	  case 0x2503: return(0x84AB);
	  case 0x250C: return(0x84A1);
	  case 0x250F: return(0x84AC);
	  case 0x2510: return(0x84A2);
	  case 0x2513: return(0x84AD);
	  case 0x2514: return(0x84A4);
	  case 0x2517: return(0x84AF);
	  case 0x2518: return(0x84A3);
	  case 0x251B: return(0x84AE);
	  case 0x251C: return(0x84A5);
	  case 0x251D: return(0x84BA);
	  case 0x2520: return(0x84B5);
	  case 0x2523: return(0x84B0);
	  case 0x2524: return(0x84A7);
	  case 0x2525: return(0x84BC);
	  case 0x2528: return(0x84B7);
	  case 0x252B: return(0x84B2);
	  case 0x252C: return(0x84A6);
	  case 0x252F: return(0x84B6);
	  case 0x2530: return(0x84BB);
	  case 0x2533: return(0x84B1);
	  case 0x2534: return(0x84A8);
	  case 0x2537: return(0x84B8);
	  case 0x2538: return(0x84BD);
	  case 0x253B: return(0x84B3);
	  case 0x253C: return(0x84A9);
	  case 0x253F: return(0x84B9);
	  case 0x2542: return(0x84BE);
	  case 0x254B: return(0x84B4);
	  case 0x25A0: return(0x81A1);	/* Geometric shapes */
	  case 0x25A1: return(0x81A0);
	  case 0x25B2: return(0x81A3);
	  case 0x25B3: return(0x81A2);
	  case 0x25BC: return(0x81A5);
	  case 0x25BD: return(0x81A4);
	  case 0x25C6: return(0x819F);
	  case 0x25C7: return(0x819E);
	  case 0x25CB: return(0x819B);
	  case 0x25CE: return(0x819D);
	  case 0x25CF: return(0x819C);
	  case 0x25EF: return(0x81FC);
	  case 0x2605: return(0x819A);	/* Misc symbols */
	  case 0x2606: return(0x8199);
	  case 0x2640: return(0x818A);
	  case 0x2642: return(0x8189);
	  case 0x266A: return(0x81F4);
	  case 0x266D: return(0x81F3);
	  case 0x266F: return(0x81F2);
	  default:
	    special--;
	    bad++;
	    return(0xfffd);
	}
    }
    if (un >= 0x3000 && un < 0x4e00) {	/* CJK symbols & punc */
	kanji++;
	if (un <= 0x30ff)
	  return(usj_3000[un-0x3000]);
	kanji--;
	bad++;
	return(0xfffd);
    }
    if (un >= 0xff00 && un < 0xffff) {	/* Half/full-width Roman & Katakana */
	if (un <= 0xff9f) {
	    if (un > 0xff60)
	      kana++;
	    return(usj_ff00[un-0xff00]);
	}
	bad++;
	return(0xfffd);
    }
    if (un >= 0x4e00 && un < 0xe000) {	/* Kanji */
	kanji++;
	if (un <= 0x9fa0)
	  return(usj_4e00[un-0x4e00]);
	kanji--;
	bad++;
	return(0xfffd);
    }
    if (un >= 0xe000 && un < 0xff00) {	/* User-defined (Gaiji) */
	kanji++;
	if (un <= 0xe0bb) {		/* ten 189-char chunks */
	    return(0xf040 + (un - 0xe000));
	} else if (un >= 0xe0bc && un <= 0xe177) {
	    return(0xf140 + (un - 0xe0bc));
	} else if (un >= 0xe178 && un <= 0xe233) {
	    return(0xf240 + (un - 0xe178));
	} else if (un >= 0xe234 && un <= 0xe2ef) {
	    return(0xf340 + (un - 0xe234));
	} else if (un >= 0xe2f0 && un <= 0xe3ab) {
	    return(0xf440 + (un - 0xe2f0));
	} else if (un >= 0xe3ac && un <= 0xe467) {
	    return(0xf540 + (un - 0xe3ac));
	} else if (un >= 0xe468 && un <= 0xe523) {
	    return(0xf640 + (un - 0xe468));
	} else if (un >= 0xe524 && un <= 0xe5df) {
	    return(0xf740 + (un - 0xe524));
	} else if (un >= 0xe5e0 && un <= 0xe69b) {
	    return(0xf840 + (un - 0xe5e0));
	} else if (un >= 0xe69c && un <= 0xe757) {
	    return(0xf940 + (un - 0xe69c));
	}
	bad++;
	return(0xfffd);
    }
    /* NOTREACHED */
    /* Some compilers (correctly) warn of "statement not reached" here. */
    /* But others give up the ghost with "no return value".  The former */
    /* is the lesser of two evils. */
    bad++;
    return(0xfffd);
}
#endif /* KANJI */

/* Unicode-to-blah functions, tx_blah(). */

static int
#ifdef CK_ANSIC
tx_punc(USHORT c)
#else
tx_punc(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c >= 0x2000 && c <= 0x200a)	/* Various-width spaces */
      return((CHAR)(0x20));
    else if (c >= 0x2010 && c <= 0x2015) /* Various-width dashes */
      return((CHAR)'-');
    else if (c >= 0x2018 && c <= 0x201b) /* Assorted single quotes */
      return((CHAR)0x27);
    else if (c >= 0x201c && c <= 0x201f) /* Assorted double quotes */
      return((CHAR)0x22);
    else if (c >= 0x2022 && c <= 0x2024 || c == 0x2043) /* Bullets */
      return((CHAR)0xb7);
    switch (c) {
      case 0x2039:			/* Less-than sign */
	return((CHAR)0x3c);
      case 0x203a:			/* Greater-than sign */
	return((CHAR)0x3e);
      case 0x2044:			/* Solidus -> Slash */
	return((CHAR)0x2f);
      default:
	return(-1);
    }
}


int					/* For Latin-1 */
#ifdef CK_ANSIC
tx_ident(USHORT c)
#else
tx_ident(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c == 0x203e)			/* Overline -> Macron */
      return((CHAR)0xaf);
    else if (c < 0x100)			/* Latin-1 range */
      return((CHAR)(c & 0xff));
    else				/* Or maybe from punctuation block */
      return(tx_punc(c));
}

int
#ifdef CK_ANSIC
tx_usascii(USHORT c)
#else
tx_usascii(c) USHORT c;			/* US ASCII */
#endif /* CK_ANSIC */
{
    if (c < 0x80)
      return((CHAR)(c & 0xff));
    else if (c >= 0x2000 && c <= 0x200a) /* Various-width spaces */
      return((CHAR)(0x20));
    else if (c >= 0x2010 && c <= 0x2015) /* Various-width dashes */
      return((CHAR)'-');
    else if (c >= 0x2018 && c <= 0x201b) /* Assorted single quotes */
      return((CHAR)0x27);
    else if (c >= 0x201c && c <= 0x201f) /* Assorted double quotes */
      return((CHAR)0x22);
    else if (c >= 0x2022 && c <= 0x2024 || c == 0x2043) /* Bullets */
      return((CHAR)0xb7);
    switch (c) {
      case 0x2039:			/* Less-than sign */
	return((CHAR)0x3c);
      case 0x203a:			/* Greater-than sign */
	return((CHAR)0x3e);
      case 0x2044:			/* Solidus -> Slash */
	return((CHAR)0x2f);
    }
    return((c & 0xff80) ? -1 : (CHAR)(c & 0x7f));
}

int
#ifdef CK_ANSIC
tx_british(USHORT c)
#else
tx_british(c) USHORT c;			/* British */
#endif /* CK_ANSIC */
{
    if (c & 0xff00)
      return(-1);
    else if (c == (USHORT) 0x00a3)	/* Pound sign */
      return(0x2b);
    else
      return(tx_usascii(c));
}

int					/* Canadian French */
#ifdef CK_ANSIC
tx_fr_canadian(USHORT c)
#else
tx_fr_canadian(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c & 0xff00)			/* Out of range */
      return(-1);
    switch(c) {
      case 0xe0: return(0x40);		/* a grave */
      case 0xe2: return(0x5b);		/* a circumflex */
      case 0xe7: return(0x5c);		/* c cedilla */
      case 0xe8: return(0x7d);		/* e grave */
      case 0xe9: return(0x7b);		/* e acute */
      case 0xea: return(0x5d);		/* e circumflex */
      case 0xee: return(0x5e);		/* i circumflex */
      case 0xf4: return(0x60);		/* o circumflex */
      case 0xf9: return(0x7c);		/* u grave */
      case 0xfb: return(0x6e);		/* u circumflex */
      default:   return(tx_usascii(c));
    }
}

int					/* Danish/Norwegian */
#ifdef CK_ANSIC
tx_danish(USHORT c)
#else
tx_danish(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c & 0xff00)			/* Out of range */
      return(-1);
    switch(c) {
      case 0xc6: return(0x5b);		/* AE */
      case 0xd8: return(0x5c);		/* O stroke */
      case 0xe6: return(0x7b);		/* ae */
      case 0xf8: return(0x7c);		/* o stroke */
      case 0xe5: return(0x7d);		/* a ring */
      case 0xaf: return(0x7e);		/* macron */
      default:   return(tx_usascii(c));
    }
}

int					/* Dutch */
#ifdef CK_ANSIC
tx_dutch(USHORT c)
#else
tx_dutch(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c & 0xfe00)			/* Out of range */
      return(-1);
    switch(c) {
      case 0x007c: return(0x5d);	/* vertical bar */
      case 0x00a3: return(0x23);	/* pound sign */
      case 0x00ab: return(0x7b);	/* diaeresis */
      case 0x00b4: return(0x7e);	/* acute accent */
      case 0x00bc: return(0x7d);	/* 1/4 */
      case 0x00be: return(0x40);	/* 3/4 */
      case 0x00bd: return(0x5c);	/* 1/2 */
      case 0x00ff: return(0x5b);	/* y diaeresis (ij) */
      case 0x0192: return(0x7c);	/* Florin */
      default:   return((c & 0x80) ? -1 : (CHAR)(c & 0x7f));
    }
}

int					/* Finnish */
#ifdef CK_ANSIC
tx_finnish(USHORT c)
#else
tx_finnish(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c & 0xff00)			/* Out of range */
      return(-1);
    switch(c) {
      case 0xc4: return(0x5b);		/* A diaeresis */
      case 0xd6: return(0x5c);		/* O diaeresis */
      case 0xc5: return(0x5d);		/* A ring */
      case 0xdc: return(0x5e);		/* U diaeresis */
      case 0xe9: return(0x60);		/* e acute */
      case 0xe4: return(0x7b);		/* a diaeresis */
      case 0xf6: return(0x7c);		/* o diaeresis */
      case 0xe5: return(0x7d);		/* a ring */
      case 0xfc: return(0x7e);		/* u diaeresis */
      default:   return(tx_usascii(c));
    }
}

int					/* French */
#ifdef CK_ANSIC
tx_french(USHORT c)
#else
tx_french(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c & 0xff00)			/* Out of range */
      return(-1);
    switch(c) {
      case 0xa3: return(0x23);		/* pound sign */
      case 0xa7: return(0x5d);		/* section sign */
      case 0xa8: return(0x7e);		/* diaeresis */
      case 0xb0: return(0x5b);		/* ring */
      case 0xb5: return(0x60);		/* micron sign (mu) */
      case 0xe0: return(0x40);		/* a grave */
      case 0xe7: return(0x5c);		/* c cedilla */
      case 0xe8: return(0x7d);		/* e grave */
      case 0xe9: return(0x7b);		/* e acute */
      case 0xf9: return(0x7c);		/* u grave */
      default:   return(tx_usascii(c));
    }
}

int					/* German */
#ifdef CK_ANSIC
tx_german(USHORT c)
#else
tx_german(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c & 0xff00)			/* Out of range */
      return(-1);
    switch(c) {
      case 0xa7: return(0x40);		/* section sign */
      case 0xc4: return(0x5b);		/* A umlaut */
      case 0xd6: return(0x5c);		/* O umlaut */
      case 0xdc: return(0x5d);		/* U umlaut */
      case 0xdf: return(0x7e);		/* ess-zet */
      case 0xe4: return(0x7b);		/* a umlaut */
      case 0xf6: return(0x7c);		/* o umlaut */
      case 0xfc: return(0x7d);		/* u umlaut*/
      default:   return(tx_usascii(c));
    }
}

int					/* Hebrew-7 */
#ifdef CK_ANSIC
tx_hebrew7(USHORT c)
#else
tx_hebrew7(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x60)			/* ASCII */
      return((CHAR)(c & 0x7f));
    else if (c >= 123 && c < 128)	/* ASCII */
      return((CHAR)(c & 0x7f));
    else if (c >= 0x05d0 && c < 0x05ea)	/* Hebrew 27 contiguous characters */
      return((CHAR)((int)c - 0x5d0 + 96));
    else return(-1);
}

int					/* Greek ELOT 927 */
#ifdef CK_ANSIC
tx_elot927(USHORT c)
#else
tx_elot927(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c <= 0x80) {			/* ASCII */
	if (islower(c)) c = toupper(c);	/* Send all letters in uppercase */
	return((CHAR)(c & 0x7f));
    }

/* Greek -- map all Greek characters to unaccented uppercase */

    if (c >= 0x0391 && c <= 0x03a1) /* Alpha thru Rho - uppercase */
      return((CHAR)((int)c - 0x0391 + 97));
    else if (c >= 0x03a3 && c <= 0x03a9) /* Sigma thru Omega - uppercase */
      return((CHAR)((int)c - 0x0391 + 96));
    else if (c >= 0x03b1 && c <= 0x03c1) /* Alpha thru Rho - lowercase */
      return((CHAR)((int)c - 0x0391 + 97));
    else if (c >= 0x03c3 && c <= 0x03c9) /* Sigma thru Omega - uppercase */
      return((CHAR)((int)c - 0x0391 + 96));
    switch (c) {
      case 0x03c2: return((CHAR)114);	/* Terminal sigma */
      case 0x0386: return((CHAR)97);	/* Alpha Tonos */
      case 0x03ac: return((CHAR)97);	/* alpha Tonos */
      case 0x0388: return((CHAR)101);	/* Epsilon Tonos */
      case 0x03ad: return((CHAR)101);	/* epsilon Tonos */
      case 0x0389: return((CHAR)103);	/* Eta Tonos */
      case 0x03ae: return((CHAR)103);	/* eta Tonos */
      case 0x038a: return((CHAR)105);	/* Iota Tonos */
      case 0x03af: return((CHAR)105);	/* iota Tonos */
      case 0x03ca: return((CHAR)105);	/* iota Dialytika */
      case 0x038c: return((CHAR)111);	/* Omicron Tonos */
      case 0x03cc: return((CHAR)111);	/* omicron Tonos */
      case 0x038e: return((CHAR)116);	/* Upsilon Tonos */
      case 0x03d3: return((CHAR)116);	/* Upsilon Tonos */
      case 0x03cd: return((CHAR)116);	/* upsilon Tonos */
      case 0x03cb: return((CHAR)116);	/* upsilon Dialytika */
      case 0x03b0: return((CHAR)116);	/* upsilon Dialytika+Tonos */
      case 0x038f: return((CHAR)120);	/* Omega Tonos */
      case 0x03ce: return((CHAR)120);	/* omega Tonos */
      case 0x0390: return((CHAR)105);	/* iota Dialytika+Tonos */
      case 0x03aa: return((CHAR)105);	/* Iota Dialytika */
      case 0x03ab: return((CHAR)116);	/* Upsilon Dialytika */
      case 0x03d4: return((CHAR)116);	/* Upsilon Dialytika */
      case 0x03d0: return((CHAR)98);	/* Alternative beta */
      case 0x03d1: return((CHAR)104);	/* Open theta */
      case 0x03d5: return((CHAR)117);	/* Open phi */
      case 0x03d6: return((CHAR)112);	/* Alternative Pi */
      default: return(-1);
    }
}

int					/* Hungarian */
#ifdef CK_ANSIC
tx_hungarian(USHORT c)
#else
tx_hungarian(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c == 0x02dd || c == 0x2033)
      return(0x7e);			/* double acute accent */
    else if (c & 0xff00)		/* Out of range */
      return(-1);
    switch(c) {
      case 0xc1: return(0x40);		/* A acute */
      case 0xc9: return(0x5b);		/* E acute */
      case 0xd6: return(0x5c);		/* O umlaut */
      case 0xdc: return(0x5d);		/* U umlaut */
      case 0xe9: return(0x7b);		/* e acute */
      case 0xf6: return(0x7c);		/* o umlaut */
      case 0xfa: return(0x60);		/* u acute */
      case 0xfc: return(0x7d);		/* u umlaut */
      default:   return(tx_usascii(c));
    }
}

int					/* Icelandic */
#ifdef CK_ANSIC
tx_icelandic(USHORT c)
#else
tx_icelandic(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c & 0xff00)			/* Out of range */
      return(-1);
    switch(c) {
      case 0xde: return(0x40);		/* Thorn */
      case 0xd0: return(0x5b);		/* Eth */
      case 0xc6: return(0x5d);		/* AE */
      case 0xd6: return(0x5e);		/* O umlaut */
      case 0xfe: return(0x60);		/* thorn */
      case 0xf0: return(0x7b);		/* eth */
      case 0xe6: return(0x7d);		/* ae */
      case 0xf6: return(0x7e);		/* o umlaut */
      default:   return(tx_usascii(c));
    }
}

int					/* Italian */
#ifdef CK_ANSIC
tx_italian(USHORT c)
#else
tx_italian(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c & 0xff00)			/* Out of range */
      return(-1);
    switch(c) {
      case 0xa3: return(0x23);		/* pound sign */
      case 0xa7: return(0x40);		/* section sign */
      case 0xb0: return(0x5b);		/* ring */
      case 0xe7: return(0x5c);		/* c cedilla */
      case 0xe9: return(0x5d);		/* e acute */
      case 0xf9: return(0x60);		/* u grave */
      case 0xe0: return(0x7b);		/* a grave */
      case 0xf2: return(0x7c);		/* o grave */
      case 0xe8: return(0x7d);		/* e grave */
      case 0xec: return(0x7e);		/* i grave */
      default:   return(tx_usascii(c));
    }
}

int					/* JIS 0201 Roman */
#ifdef CK_ANSIC
tx_jis0201r(USHORT c)
#else
tx_jis0201r(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c && 0xff80)			/* 7 bits */
      return(-1);
    switch (c) {			/* Like ASCII with */
      case 0x00a5: return(92);		/* two exceptions */
      case 0x00af: return(126);
      case 0x203e: return(126);
      default:   return(tx_usascii(c));
    }
}

int					/* JIS 0201 Katakana */
#ifdef CK_ANSIC
tx_jis0201k(USHORT c)
#else
tx_jis0201k(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xff61 || c > 0xff9f)
      return(-1);			/* Out of range */
    else
      return((int)c - 0xfec0);		/* 0xff61 - a0 = 0xfec0 */
}

int					/* Short KOI */
#ifdef CK_ANSIC
tx_koi7(USHORT c)
#else
tx_koi7(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x50)
      return((CHAR)(c & 0x7f));
    else if (c > 0x7f)
      return(-1);			/* Out of range */
    switch(c) {
      case 0x0410: return((CHAR)97);
      case 0x0411: return((CHAR)98);
      case 0x0412: return((CHAR)119);
      case 0x0413: return((CHAR)103);
      case 0x0414: return((CHAR)100);
      case 0x0415: return((CHAR)101);
      case 0x0416: return((CHAR)118);
      case 0x0417: return((CHAR)122);
      case 0x0418: return((CHAR)105);
      case 0x0419: return((CHAR)106);
      case 0x041a: return((CHAR)107);
      case 0x041b: return((CHAR)108);
      case 0x041c: return((CHAR)109);
      case 0x041d: return((CHAR)110);
      case 0x041e: return((CHAR)111);
      case 0x041f: return((CHAR)112);
      case 0x0420: return((CHAR)114);
      case 0x0421: return((CHAR)115);
      case 0x0422: return((CHAR)116);
      case 0x0423: return((CHAR)117);
      case 0x0424: return((CHAR)102);
      case 0x0425: return((CHAR)104);
      case 0x0426: return((CHAR)99);
      case 0x0427: return((CHAR)126);
      case 0x0428: return((CHAR)123);
      case 0x0429: return((CHAR)125);
      case 0x042b: return((CHAR)121);
      case 0x042c: return((CHAR)120);
      case 0x042d: return((CHAR)124);
      case 0x042e: return((CHAR)96);
      case 0x042f: return((CHAR)113);
      default: return(-1);
    }
}

int					/* Portuguese */
#ifdef CK_ANSIC
tx_portuguese(USHORT c)
#else
tx_portuguese(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c & 0xff00)			/* Out of range */
      return(-1);
    switch(c) {
      case 0xe0: return(0xa7);		/* section sign */
      case 0xb0: return(0xc3);		/* A tilde */
      case 0xe7: return(0xc7);		/* C cedilla */
      case 0xa7: return(0xd5);		/* O tilde */
      case 0xe9: return(0xe3);		/* a tilde */
      case 0xf9: return(0xe7);		/* c cedilla */
      case 0xe8: return(0xf5);		/* o tilde */
      case 0xa8: return(0xb0);		/* ring */
      default:   return(tx_usascii(c));
    }
}

int					/* Spanish */
#ifdef CK_ANSIC
tx_spanish(USHORT c)
#else
tx_spanish(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c & 0xff00)			/* Out of range */
      return(-1);
    switch(c) {
      case 0xa3: return(0x23);		/* pound sign */
      case 0xa7: return(0x40);		/* section */
      case 0xa1: return(0x5b);		/* inverted exclamation */
      case 0xd1: return(0x5c);		/* N tilde */
      case 0xbf: return(0x5d);		/* inverted question mark */
      case 0xb0: return(0x7b);		/* ring */
      case 0xf1: return(0x7c);		/* n tilde */
      case 0xe7: return(0x7d);		/* c cedilla */
      default:   return(tx_usascii(c));
    }
}

int					/* Swedish */
#ifdef CK_ANSIC
tx_swedish(USHORT c)
#else
tx_swedish(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c & 0xff00)			/* Out of range */
      return(-1);
    switch(c) {
      case 0xc9: return(0x40);		/* E acute */
      case 0xc4: return(0x5b);		/* A umlaut*/
      case 0xd6: return(0x5c);		/* O umlaut */
      case 0xc5: return(0x5d);		/* A ring */
      case 0xdc: return(0x5e);		/* U umlaut */
      case 0xe9: return(0x60);		/* e acute */
      case 0xe4: return(0x7b);		/* a umlaut */
      case 0xf6: return(0x7c);		/* o umlaut */
      case 0xe5: return(0x7d);		/* a ring */
      case 0xfc: return(0x7e);		/* u umlaut */
      default:   return(tx_usascii(c));
    }
}


int					/* Swiss NRC */
#ifdef CK_ANSIC
tx_swiss(USHORT c)
#else
tx_swiss(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c & 0xff00)			/* Out of range */
      return(-1);
    switch(c) {
      case 0xf9: return(0x23);		/* u grave */
      case 0xe0: return(0x40);		/* a grave */
      case 0xe9: return(0x5b);		/* e acute */
      case 0xe7: return(0x5c);		/* c cedilla */
      case 0xea: return(0x5d);		/* e circumflex */
      case 0xee: return(0x5e);		/* i circumflex */
      case 0xe8: return(0x5f);		/* e grave */
      case 0xf4: return(0x60);		/* o circumflex */
      case 0xe4: return(0x7b);		/* a umlaut */
      case 0xf6: return(0x7c);		/* o umlaut */
      case 0xfc: return(0x7d);		/* u umlaut */
      case 0xfb: return(0x7e);		/* u circumflex */
      default:   return(tx_usascii(c));
    }
}

/* For Latin-1, use tx_ident() */

int					/* Latin-2 */
#ifdef CK_ANSIC
tx_8859_2(USHORT c)
#else
tx_8859_2(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xa0)
      return((CHAR)(c & 0xff));
    switch(c) {
      case 0x00A0: return((CHAR)160);
      case 0x00A4: return((CHAR)164);
      case 0x00A7: return((CHAR)167);
      case 0x00A8: return((CHAR)168);
      case 0x00AD: return((CHAR)173);
      case 0x00B0: return((CHAR)176);
      case 0x00B4: return((CHAR)180);
      case 0x00B8: return((CHAR)184);
      case 0x00C1: return((CHAR)193);
      case 0x00C2: return((CHAR)194);
      case 0x00C4: return((CHAR)196);
      case 0x00C7: return((CHAR)199);
      case 0x00C9: return((CHAR)201);
      case 0x00CB: return((CHAR)203);
      case 0x00CD: return((CHAR)205);
      case 0x00CE: return((CHAR)206);
      case 0x00D3: return((CHAR)211);
      case 0x00D4: return((CHAR)212);
      case 0x00D6: return((CHAR)214);
      case 0x00D7: return((CHAR)215);
      case 0x00DA: return((CHAR)218);
      case 0x00DC: return((CHAR)220);
      case 0x00DD: return((CHAR)221);
      case 0x00DF: return((CHAR)223);
      case 0x00E1: return((CHAR)225);
      case 0x00E2: return((CHAR)226);
      case 0x00E4: return((CHAR)228);
      case 0x00E7: return((CHAR)231);
      case 0x00E9: return((CHAR)233);
      case 0x00EB: return((CHAR)235);
      case 0x00ED: return((CHAR)237);
      case 0x00EE: return((CHAR)238);
      case 0x00F3: return((CHAR)243);
      case 0x00F4: return((CHAR)244);
      case 0x00F6: return((CHAR)246);
      case 0x00F7: return((CHAR)247);
      case 0x00FA: return((CHAR)250);
      case 0x00FC: return((CHAR)252);
      case 0x00FD: return((CHAR)253);
      case 0x0102: return((CHAR)195);
      case 0x0103: return((CHAR)227);
      case 0x0104: return((CHAR)161);
      case 0x0105: return((CHAR)177);
      case 0x0106: return((CHAR)198);
      case 0x0107: return((CHAR)230);
      case 0x010C: return((CHAR)200);
      case 0x010D: return((CHAR)232);
      case 0x010E: return((CHAR)207);
      case 0x010F: return((CHAR)239);
      case 0x0110: return((CHAR)208);
      case 0x0111: return((CHAR)240);
      case 0x0118: return((CHAR)202);
      case 0x0119: return((CHAR)234);
      case 0x011A: return((CHAR)204);
      case 0x011B: return((CHAR)236);
      case 0x0139: return((CHAR)197);
      case 0x013A: return((CHAR)229);
      case 0x013D: return((CHAR)165);
      case 0x013E: return((CHAR)181);
      case 0x0141: return((CHAR)163);
      case 0x0142: return((CHAR)179);
      case 0x0143: return((CHAR)209);
      case 0x0144: return((CHAR)241);
      case 0x0147: return((CHAR)210);
      case 0x0148: return((CHAR)242);
      case 0x0150: return((CHAR)213);
      case 0x0151: return((CHAR)245);
      case 0x0154: return((CHAR)192);
      case 0x0155: return((CHAR)224);
      case 0x0158: return((CHAR)216);
      case 0x0159: return((CHAR)248);
      case 0x015A: return((CHAR)166);
      case 0x015B: return((CHAR)182);
      case 0x015E: return((CHAR)170);
      case 0x015F: return((CHAR)186);
      case 0x0160: return((CHAR)169);
      case 0x0161: return((CHAR)185);
      case 0x0162: return((CHAR)222);
      case 0x0163: return((CHAR)254);
      case 0x0164: return((CHAR)171);
      case 0x0165: return((CHAR)187);
      case 0x016E: return((CHAR)217);
      case 0x016F: return((CHAR)249);
      case 0x0170: return((CHAR)219);
      case 0x0171: return((CHAR)251);
      case 0x0179: return((CHAR)172);
      case 0x017A: return((CHAR)188);
      case 0x017B: return((CHAR)175);
      case 0x017C: return((CHAR)191);
      case 0x017D: return((CHAR)174);
      case 0x017E: return((CHAR)190);
      case 0x02C7: return((CHAR)183);
      case 0x02D8: return((CHAR)162);
      case 0x02D9: return((CHAR)255);
      case 0x02DB: return((CHAR)178);
      case 0x02DD: return((CHAR)189);
      default: return(tx_punc(c));
    }
}

int					/* Latin-3 */
#ifdef CK_ANSIC
tx_8859_3(USHORT c)
#else
tx_8859_3(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xa0)
      return((CHAR)(c & 0xff));
    switch(c) {
      case 0x00A0: return((CHAR)160);
      case 0x00A3: return((CHAR)163);
      case 0x00A4: return((CHAR)164);
      case 0x00A7: return((CHAR)167);
      case 0x00A8: return((CHAR)168);
      case 0x00AD: return((CHAR)173);
      case 0x00B0: return((CHAR)176);
      case 0x00B2: return((CHAR)178);
      case 0x00B3: return((CHAR)179);
      case 0x00B4: return((CHAR)180);
      case 0x00B5: return((CHAR)181);
      case 0x00B7: return((CHAR)183);
      case 0x00B8: return((CHAR)184);
      case 0x00BD: return((CHAR)189);
      case 0x00C0: return((CHAR)192);
      case 0x00C1: return((CHAR)193);
      case 0x00C2: return((CHAR)194);
      case 0x00C4: return((CHAR)196);
      case 0x00C7: return((CHAR)199);
      case 0x00C8: return((CHAR)200);
      case 0x00C9: return((CHAR)201);
      case 0x00CA: return((CHAR)202);
      case 0x00CB: return((CHAR)203);
      case 0x00CC: return((CHAR)204);
      case 0x00CD: return((CHAR)205);
      case 0x00CE: return((CHAR)206);
      case 0x00CF: return((CHAR)207);
      case 0x00D1: return((CHAR)209);
      case 0x00D2: return((CHAR)210);
      case 0x00D3: return((CHAR)211);
      case 0x00D4: return((CHAR)212);
      case 0x00D6: return((CHAR)214);
      case 0x00D7: return((CHAR)215);
      case 0x00D9: return((CHAR)217);
      case 0x00DA: return((CHAR)218);
      case 0x00DB: return((CHAR)219);
      case 0x00DC: return((CHAR)220);
      case 0x00DF: return((CHAR)223);
      case 0x00E0: return((CHAR)224);
      case 0x00E1: return((CHAR)225);
      case 0x00E2: return((CHAR)226);
      case 0x00E4: return((CHAR)228);
      case 0x00E7: return((CHAR)231);
      case 0x00E8: return((CHAR)232);
      case 0x00E9: return((CHAR)233);
      case 0x00EA: return((CHAR)234);
      case 0x00EB: return((CHAR)235);
      case 0x00EC: return((CHAR)236);
      case 0x00ED: return((CHAR)237);
      case 0x00EE: return((CHAR)238);
      case 0x00EF: return((CHAR)239);
      case 0x00F1: return((CHAR)241);
      case 0x00F2: return((CHAR)242);
      case 0x00F3: return((CHAR)243);
      case 0x00F4: return((CHAR)244);
      case 0x00F6: return((CHAR)246);
      case 0x00F7: return((CHAR)247);
      case 0x00F9: return((CHAR)249);
      case 0x00FA: return((CHAR)250);
      case 0x00FB: return((CHAR)251);
      case 0x00FC: return((CHAR)252);
      case 0x0108: return((CHAR)198);
      case 0x0109: return((CHAR)230);
      case 0x010A: return((CHAR)197);
      case 0x010B: return((CHAR)229);
      case 0x011C: return((CHAR)216);
      case 0x011D: return((CHAR)248);
      case 0x011E: return((CHAR)171);
      case 0x011F: return((CHAR)187);
      case 0x0120: return((CHAR)213);
      case 0x0121: return((CHAR)245);
      case 0x0124: return((CHAR)166);
      case 0x0125: return((CHAR)182);
      case 0x0126: return((CHAR)161);
      case 0x0127: return((CHAR)177);
      case 0x0130: return((CHAR)169);
      case 0x0131: return((CHAR)185);
      case 0x0134: return((CHAR)172);
      case 0x0135: return((CHAR)188);
      case 0x015C: return((CHAR)222);
      case 0x015D: return((CHAR)254);
      case 0x015E: return((CHAR)170);
      case 0x015F: return((CHAR)186);
      case 0x016C: return((CHAR)221);
      case 0x016D: return((CHAR)253);
      case 0x017B: return((CHAR)175);
      case 0x017C: return((CHAR)191);
      case 0x02D8: return((CHAR)162);
      case 0x02D9: return((CHAR)255);
      default: return(tx_punc(c));
    }
}

int					/* Latin-4 */
#ifdef CK_ANSIC
tx_8859_4(USHORT c)
#else
tx_8859_4(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xa0)
      return((CHAR)(c & 0xff));
    switch(c) {
      case 0x00A0: return((CHAR)160);
      case 0x00A4: return((CHAR)164);
      case 0x00A7: return((CHAR)167);
      case 0x00A8: return((CHAR)168);
      case 0x00AD: return((CHAR)173);
      case 0x00AF: return((CHAR)175);
      case 0x00B0: return((CHAR)176);
      case 0x00B4: return((CHAR)180);
      case 0x00B8: return((CHAR)184);
      case 0x00C1: return((CHAR)193);
      case 0x00C2: return((CHAR)194);
      case 0x00C3: return((CHAR)195);
      case 0x00C4: return((CHAR)196);
      case 0x00C5: return((CHAR)197);
      case 0x00C6: return((CHAR)198);
      case 0x00C9: return((CHAR)201);
      case 0x00CB: return((CHAR)203);
      case 0x00CD: return((CHAR)205);
      case 0x00CE: return((CHAR)206);
      case 0x00D4: return((CHAR)212);
      case 0x00D5: return((CHAR)213);
      case 0x00D6: return((CHAR)214);
      case 0x00D7: return((CHAR)215);
      case 0x00D8: return((CHAR)216);
      case 0x00DA: return((CHAR)218);
      case 0x00DB: return((CHAR)219);
      case 0x00DC: return((CHAR)220);
      case 0x00DF: return((CHAR)223);
      case 0x00E1: return((CHAR)225);
      case 0x00E2: return((CHAR)226);
      case 0x00E3: return((CHAR)227);
      case 0x00E4: return((CHAR)228);
      case 0x00E5: return((CHAR)229);
      case 0x00E6: return((CHAR)230);
      case 0x00E9: return((CHAR)233);
      case 0x00EB: return((CHAR)235);
      case 0x00ED: return((CHAR)237);
      case 0x00EE: return((CHAR)238);
      case 0x00F4: return((CHAR)244);
      case 0x00F5: return((CHAR)245);
      case 0x00F6: return((CHAR)246);
      case 0x00F7: return((CHAR)247);
      case 0x00F8: return((CHAR)248);
      case 0x00FA: return((CHAR)250);
      case 0x00FB: return((CHAR)251);
      case 0x00FC: return((CHAR)252);
      case 0x0100: return((CHAR)192);
      case 0x0101: return((CHAR)224);
      case 0x0104: return((CHAR)161);
      case 0x0105: return((CHAR)177);
      case 0x010C: return((CHAR)200);
      case 0x010D: return((CHAR)232);
      case 0x0110: return((CHAR)208);
      case 0x0111: return((CHAR)240);
      case 0x0112: return((CHAR)170);
      case 0x0113: return((CHAR)186);
      case 0x0116: return((CHAR)204);
      case 0x0117: return((CHAR)236);
      case 0x0118: return((CHAR)202);
      case 0x0119: return((CHAR)234);
      case 0x0122: return((CHAR)171);
      case 0x0123: return((CHAR)187);
      case 0x0128: return((CHAR)165);
      case 0x0129: return((CHAR)181);
      case 0x012A: return((CHAR)207);
      case 0x012B: return((CHAR)239);
      case 0x012E: return((CHAR)199);
      case 0x012F: return((CHAR)231);
      case 0x0136: return((CHAR)211);
      case 0x0137: return((CHAR)243);
      case 0x0138: return((CHAR)162);
      case 0x013B: return((CHAR)166);
      case 0x013C: return((CHAR)182);
      case 0x0145: return((CHAR)209);
      case 0x0146: return((CHAR)241);
      case 0x014A: return((CHAR)189);
      case 0x014B: return((CHAR)191);
      case 0x014C: return((CHAR)210);
      case 0x014D: return((CHAR)242);
      case 0x0156: return((CHAR)163);
      case 0x0157: return((CHAR)179);
      case 0x0160: return((CHAR)169);
      case 0x0161: return((CHAR)185);
      case 0x0166: return((CHAR)172);
      case 0x0167: return((CHAR)188);
      case 0x0168: return((CHAR)221);
      case 0x0169: return((CHAR)253);
      case 0x016A: return((CHAR)222);
      case 0x016B: return((CHAR)254);
      case 0x0172: return((CHAR)217);
      case 0x0173: return((CHAR)249);
      case 0x017D: return((CHAR)174);
      case 0x017E: return((CHAR)190);
      case 0x02C7: return((CHAR)183);
      case 0x02D9: return((CHAR)255);
      case 0x02DB: return((CHAR)178);
      default: return(tx_punc(c));
    }
}

int					/* ISO 8859-5 (Latin/Cyrillic) */
#ifdef CK_ANSIC
tx_8859_5(USHORT c)
#else
tx_8859_5(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xa0)			/* (8859-5 is not Latin-5!) */
      return((CHAR)(c & 0xff));
    switch(c) {
      case 0x00A0: return((CHAR)160);
      case 0x00A7: return((CHAR)253);
      case 0x00AD: return((CHAR)173);
      case 0x0401: return((CHAR)161);
      case 0x0402: return((CHAR)162);
      case 0x0403: return((CHAR)163);
      case 0x0404: return((CHAR)164);
      case 0x0405: return((CHAR)165);
      case 0x0406: return((CHAR)166);
      case 0x0407: return((CHAR)167);
      case 0x0408: return((CHAR)168);
      case 0x0409: return((CHAR)169);
      case 0x040A: return((CHAR)170);
      case 0x040B: return((CHAR)171);
      case 0x040C: return((CHAR)172);
      case 0x040E: return((CHAR)174);
      case 0x040F: return((CHAR)175);
      case 0x0410: return((CHAR)176);
      case 0x0411: return((CHAR)177);
      case 0x0412: return((CHAR)178);
      case 0x0413: return((CHAR)179);
      case 0x0414: return((CHAR)180);
      case 0x0415: return((CHAR)181);
      case 0x0416: return((CHAR)182);
      case 0x0417: return((CHAR)183);
      case 0x0418: return((CHAR)184);
      case 0x0419: return((CHAR)185);
      case 0x041A: return((CHAR)186);
      case 0x041B: return((CHAR)187);
      case 0x041C: return((CHAR)188);
      case 0x041D: return((CHAR)189);
      case 0x041E: return((CHAR)190);
      case 0x041F: return((CHAR)191);
      case 0x0420: return((CHAR)192);
      case 0x0421: return((CHAR)193);
      case 0x0422: return((CHAR)194);
      case 0x0423: return((CHAR)195);
      case 0x0424: return((CHAR)196);
      case 0x0425: return((CHAR)197);
      case 0x0426: return((CHAR)198);
      case 0x0427: return((CHAR)199);
      case 0x0428: return((CHAR)200);
      case 0x0429: return((CHAR)201);
      case 0x042A: return((CHAR)202);
      case 0x042B: return((CHAR)203);
      case 0x042C: return((CHAR)204);
      case 0x042D: return((CHAR)205);
      case 0x042E: return((CHAR)206);
      case 0x042F: return((CHAR)207);
      case 0x0430: return((CHAR)208);
      case 0x0431: return((CHAR)209);
      case 0x0432: return((CHAR)210);
      case 0x0433: return((CHAR)211);
      case 0x0434: return((CHAR)212);
      case 0x0435: return((CHAR)213);
      case 0x0436: return((CHAR)214);
      case 0x0437: return((CHAR)215);
      case 0x0438: return((CHAR)216);
      case 0x0439: return((CHAR)217);
      case 0x043A: return((CHAR)218);
      case 0x043B: return((CHAR)219);
      case 0x043C: return((CHAR)220);
      case 0x043D: return((CHAR)221);
      case 0x043E: return((CHAR)222);
      case 0x043F: return((CHAR)223);
      case 0x0440: return((CHAR)224);
      case 0x0441: return((CHAR)225);
      case 0x0442: return((CHAR)226);
      case 0x0443: return((CHAR)227);
      case 0x0444: return((CHAR)228);
      case 0x0445: return((CHAR)229);
      case 0x0446: return((CHAR)230);
      case 0x0447: return((CHAR)231);
      case 0x0448: return((CHAR)232);
      case 0x0449: return((CHAR)233);
      case 0x044A: return((CHAR)234);
      case 0x044B: return((CHAR)235);
      case 0x044C: return((CHAR)236);
      case 0x044D: return((CHAR)237);
      case 0x044E: return((CHAR)238);
      case 0x044F: return((CHAR)239);
      case 0x0451: return((CHAR)241);
      case 0x0452: return((CHAR)242);
      case 0x0453: return((CHAR)243);
      case 0x0454: return((CHAR)244);
      case 0x0455: return((CHAR)245);
      case 0x0456: return((CHAR)246);
      case 0x0457: return((CHAR)247);
      case 0x0458: return((CHAR)248);
      case 0x0459: return((CHAR)249);
      case 0x045A: return((CHAR)250);
      case 0x045B: return((CHAR)251);
      case 0x045C: return((CHAR)252);
      case 0x045E: return((CHAR)254);
      case 0x045F: return((CHAR)255);
      case 0x2116: return((CHAR)240);
      default: return(tx_punc(c));
    }
}

int					/* ISO 8859-6 (Latin/Arabic) */
#ifdef CK_ANSIC
tx_8859_6(USHORT c)
#else
tx_8859_6(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xa0)			/* (8859-6 != Latin-6) */
      return((CHAR)(c & 0xff));
    switch(c) {
      case 0x00A0: return((CHAR)160);
      case 0x00A4: return((CHAR)164);
      case 0x00AD: return((CHAR)173);
      case 0x060C: return((CHAR)172);
      case 0x061B: return((CHAR)187);
      case 0x061F: return((CHAR)191);
      case 0x0621: return((CHAR)193);
      case 0x0622: return((CHAR)194);
      case 0x0623: return((CHAR)195);
      case 0x0624: return((CHAR)196);
      case 0x0625: return((CHAR)197);
      case 0x0626: return((CHAR)198);
      case 0x0627: return((CHAR)199);
      case 0x0628: return((CHAR)200);
      case 0x0629: return((CHAR)201);
      case 0x062A: return((CHAR)202);
      case 0x062B: return((CHAR)203);
      case 0x062C: return((CHAR)204);
      case 0x062D: return((CHAR)205);
      case 0x062E: return((CHAR)206);
      case 0x062F: return((CHAR)207);
      case 0x0630: return((CHAR)208);
      case 0x0631: return((CHAR)209);
      case 0x0632: return((CHAR)210);
      case 0x0633: return((CHAR)211);
      case 0x0634: return((CHAR)212);
      case 0x0635: return((CHAR)213);
      case 0x0636: return((CHAR)214);
      case 0x0637: return((CHAR)215);
      case 0x0638: return((CHAR)216);
      case 0x0639: return((CHAR)217);
      case 0x063A: return((CHAR)218);
      case 0x0640: return((CHAR)224);
      case 0x0641: return((CHAR)225);
      case 0x0642: return((CHAR)226);
      case 0x0643: return((CHAR)227);
      case 0x0644: return((CHAR)228);
      case 0x0645: return((CHAR)229);
      case 0x0646: return((CHAR)230);
      case 0x0647: return((CHAR)231);
      case 0x0648: return((CHAR)232);
      case 0x0649: return((CHAR)233);
      case 0x064A: return((CHAR)234);
      case 0x064B: return((CHAR)235);
      case 0x064C: return((CHAR)236);
      case 0x064D: return((CHAR)237);
      case 0x064E: return((CHAR)238);
      case 0x064F: return((CHAR)239);
      case 0x0650: return((CHAR)240);
      case 0x0651: return((CHAR)241);
      case 0x0652: return((CHAR)242);
      default: return(tx_punc(c));
    }
}

int					/* ISO 8859-7 (Latin/Greek) */
#ifdef CK_ANSIC
tx_8859_7(USHORT c)
#else
tx_8859_7(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xa0)
      return((CHAR)(c & 0xff));
    switch(c) {
	case 0x00a0: return((CHAR)160);
	case 0x00a3: return((CHAR)163);
	case 0x00a6: return((CHAR)166);
	case 0x00a7: return((CHAR)167);
	case 0x00a8: return((CHAR)168);
	case 0x00a9: return((CHAR)169);
	case 0x00ab: return((CHAR)171);
	case 0x00ac: return((CHAR)172);
	case 0x00ad: return((CHAR)173);
	case 0x00b0: return((CHAR)176);
	case 0x00b1: return((CHAR)177);
	case 0x00b2: return((CHAR)178);
	case 0x00b3: return((CHAR)179);
	case 0x00b7: return((CHAR)183);
	case 0x00bb: return((CHAR)187);
	case 0x00bd: return((CHAR)189);
	case 0x02bc: return((CHAR)162);
	case 0x02bd: return((CHAR)161);
	case 0x0384: return((CHAR)180);
	case 0x0385: return((CHAR)181);
	case 0x0386: return((CHAR)182);
	case 0x0388: return((CHAR)184);
	case 0x0389: return((CHAR)185);
	case 0x038a: return((CHAR)186);
	case 0x038c: return((CHAR)188);
	case 0x038e: return((CHAR)190);
	case 0x038f: return((CHAR)191);
	case 0x0390: return((CHAR)192);
	case 0x0391: return((CHAR)193);
	case 0x0392: return((CHAR)194);
	case 0x0393: return((CHAR)195);
	case 0x0394: return((CHAR)196);
	case 0x0395: return((CHAR)197);
	case 0x0396: return((CHAR)198);
	case 0x0397: return((CHAR)199);
	case 0x0398: return((CHAR)200);
	case 0x0399: return((CHAR)201);
	case 0x039a: return((CHAR)202);
	case 0x039b: return((CHAR)203);
	case 0x039c: return((CHAR)204);
	case 0x039d: return((CHAR)205);
	case 0x039e: return((CHAR)206);
	case 0x039f: return((CHAR)207);
	case 0x03a0: return((CHAR)208);
	case 0x03a1: return((CHAR)209);
	case 0x03a3: return((CHAR)211);
	case 0x03a4: return((CHAR)212);
	case 0x03a5: return((CHAR)213);
	case 0x03a6: return((CHAR)214);
	case 0x03a7: return((CHAR)215);
	case 0x03a8: return((CHAR)216);
	case 0x03a9: return((CHAR)217);
	case 0x03aa: return((CHAR)218);
	case 0x03ab: return((CHAR)219);
	case 0x03ac: return((CHAR)220);
	case 0x03ad: return((CHAR)221);
	case 0x03ae: return((CHAR)222);
	case 0x03af: return((CHAR)223);
	case 0x03b0: return((CHAR)224);
	case 0x03b1: return((CHAR)225);
	case 0x03b2: return((CHAR)226);
	case 0x03b3: return((CHAR)227);
	case 0x03b4: return((CHAR)228);
	case 0x03b5: return((CHAR)229);
	case 0x03b6: return((CHAR)230);
	case 0x03b7: return((CHAR)231);
	case 0x03b8: return((CHAR)232);
	case 0x03b9: return((CHAR)233);
	case 0x03ba: return((CHAR)234);
	case 0x03bb: return((CHAR)235);
	case 0x03bc: return((CHAR)236);
	case 0x03bd: return((CHAR)237);
	case 0x03be: return((CHAR)238);
	case 0x03bf: return((CHAR)239);
	case 0x03c0: return((CHAR)240);
	case 0x03c1: return((CHAR)241);
	case 0x03c2: return((CHAR)242);
	case 0x03c3: return((CHAR)243);
	case 0x03c4: return((CHAR)244);
	case 0x03c5: return((CHAR)245);
	case 0x03c6: return((CHAR)246);
	case 0x03c7: return((CHAR)247);
	case 0x03c8: return((CHAR)248);
	case 0x03c9: return((CHAR)249);
	case 0x03ca: return((CHAR)250);
	case 0x03cb: return((CHAR)251);
	case 0x03cc: return((CHAR)252);
	case 0x03cd: return((CHAR)253);
	case 0x03ce: return((CHAR)254);
	case 0x2015: return((CHAR)175);
	case 0x2018: return((CHAR)161);
	case 0x2019: return((CHAR)162);
	default: return(tx_punc(c));
    }
}

int					/* ISO 8859-8 (Latin/Hebrew) */
#ifdef CK_ANSIC
tx_8859_8(USHORT c)
#else
tx_8859_8(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xa0)
      return((CHAR)(c & 0xff));
    switch(c) {
      case 0x00a0: return((CHAR)160);
      case 0x00a2: return((CHAR)162);
      case 0x00a3: return((CHAR)163);
      case 0x00a4: return((CHAR)164);
      case 0x00a5: return((CHAR)165);
      case 0x00a6: return((CHAR)166);
      case 0x00a7: return((CHAR)167);
      case 0x00a8: return((CHAR)168);
      case 0x00a9: return((CHAR)169);
      case 0x00d7: return((CHAR)170);
      case 0x00ab: return((CHAR)171);
      case 0x00ac: return((CHAR)172);
      case 0x00ad: return((CHAR)173);
      case 0x00ae: return((CHAR)174);
      case 0x203e: return((CHAR)175);
      case 0x00b0: return((CHAR)176);
      case 0x00b1: return((CHAR)177);
      case 0x00b2: return((CHAR)178);
      case 0x00b3: return((CHAR)179);
      case 0x00b4: return((CHAR)180);
      case 0x00b5: return((CHAR)181);
      case 0x00b6: return((CHAR)182);
      case 0x00b7: return((CHAR)183);
      case 0x00b8: return((CHAR)184);
      case 0x00b9: return((CHAR)185);
      case 0x00f7: return((CHAR)186);
      case 0x00bb: return((CHAR)187);
      case 0x00bc: return((CHAR)188);
      case 0x00bd: return((CHAR)189);
      case 0x00be: return((CHAR)190);
      case 0x2017: return((CHAR)223);
      case 0x05d0: return((CHAR)224);
      case 0x05d1: return((CHAR)225);
      case 0x05d2: return((CHAR)226);
      case 0x05d3: return((CHAR)227);
      case 0x05d4: return((CHAR)228);
      case 0x05d5: return((CHAR)229);
      case 0x05d6: return((CHAR)230);
      case 0x05d7: return((CHAR)231);
      case 0x05d8: return((CHAR)232);
      case 0x05d9: return((CHAR)233);
      case 0x05da: return((CHAR)234);
      case 0x05db: return((CHAR)235);
      case 0x05dc: return((CHAR)236);
      case 0x05dd: return((CHAR)237);
      case 0x05de: return((CHAR)238);
      case 0x05df: return((CHAR)239);
      case 0x05e0: return((CHAR)240);
      case 0x05e1: return((CHAR)241);
      case 0x05e2: return((CHAR)242);
      case 0x05e3: return((CHAR)243);
      case 0x05e4: return((CHAR)244);
      case 0x05e5: return((CHAR)245);
      case 0x05e6: return((CHAR)246);
      case 0x05e7: return((CHAR)247);
      case 0x05e8: return((CHAR)248);
      case 0x05e9: return((CHAR)249);
      case 0x05ea: return((CHAR)250);
      default: return(tx_punc(c));
    }
}

int					/* ISO 8859-9 (Latin-4) */
#ifdef CK_ANSIC
tx_8859_9(USHORT c)
#else
tx_8859_9(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xa0)
      return((CHAR)(c & 0xff));
    switch(c) {
      case 0x011E: return((CHAR)208);	/* Differs from Latin-1 in */
      case 0x011F: return((CHAR)240);	/* only six places */
      case 0x0130: return((CHAR)221);
      case 0x0131: return((CHAR)253);
      case 0x015E: return((CHAR)222);
      case 0x015F: return((CHAR)254);
      default: return(tx_ident(c));
    }
}

int					/* Latin-6 */
#ifdef CK_ANSIC
tx_8859_10(USHORT c)
#else
tx_8859_10(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xa0)
      return((CHAR)(c & 0xff));
    switch(c) {
      case 0x00a0: return((CHAR)160);
      case 0x00ad: return((CHAR)173);
      case 0x00bd: return((CHAR)189);
      case 0x00be: return((CHAR)190);
      case 0x00c1: return((CHAR)193);
      case 0x00c2: return((CHAR)194);
      case 0x00c3: return((CHAR)195);
      case 0x00c4: return((CHAR)196);
      case 0x00c5: return((CHAR)197);
      case 0x00c6: return((CHAR)198);
      case 0x00c9: return((CHAR)201);
      case 0x00cb: return((CHAR)203);
      case 0x00cd: return((CHAR)205);
      case 0x00ce: return((CHAR)206);
      case 0x00cf: return((CHAR)207);
      case 0x00d3: return((CHAR)211);
      case 0x00d4: return((CHAR)212);
      case 0x00d5: return((CHAR)213);
      case 0x00d6: return((CHAR)214);
      case 0x00d8: return((CHAR)216);
      case 0x00da: return((CHAR)218);
      case 0x00db: return((CHAR)219);
      case 0x00dc: return((CHAR)220);
      case 0x00dd: return((CHAR)221);
      case 0x00de: return((CHAR)222);
      case 0x00e1: return((CHAR)225);
      case 0x00e2: return((CHAR)226);
      case 0x00e3: return((CHAR)227);
      case 0x00e4: return((CHAR)228);
      case 0x00e5: return((CHAR)229);
      case 0x00e6: return((CHAR)230);
      case 0x00e9: return((CHAR)233);
      case 0x00eb: return((CHAR)235);
      case 0x00ed: return((CHAR)237);
      case 0x00ee: return((CHAR)238);
      case 0x00ef: return((CHAR)239);
      case 0x00f0: return((CHAR)240);
      case 0x00f1: return((CHAR)241);
      case 0x00f3: return((CHAR)243);
      case 0x00f4: return((CHAR)244);
      case 0x00f5: return((CHAR)245);
      case 0x00f6: return((CHAR)246);
      case 0x00f8: return((CHAR)248);
      case 0x00fa: return((CHAR)250);
      case 0x00fb: return((CHAR)251);
      case 0x00fc: return((CHAR)252);
      case 0x00fd: return((CHAR)253);
      case 0x00fe: return((CHAR)254);
      case 0x0100: return((CHAR)192);
      case 0x0101: return((CHAR)224);
      case 0x0104: return((CHAR)161);
      case 0x0105: return((CHAR)177);
      case 0x010c: return((CHAR)200);
      case 0x010d: return((CHAR)232);
      case 0x0110: return((CHAR)208);
      case 0x0111: return((CHAR)176);
      case 0x0112: return((CHAR)162);
      case 0x0113: return((CHAR)178);
      case 0x0116: return((CHAR)204);
      case 0x0117: return((CHAR)236);
      case 0x0118: return((CHAR)202);
      case 0x0119: return((CHAR)234);
      case 0x0122: return((CHAR)163);
      case 0x0123: return((CHAR)179);
      case 0x0128: return((CHAR)165);
      case 0x0129: return((CHAR)181);
      case 0x012a: return((CHAR)164);
      case 0x012b: return((CHAR)180);
      case 0x012e: return((CHAR)199);
      case 0x012f: return((CHAR)231);
      case 0x0136: return((CHAR)166);
      case 0x0137: return((CHAR)182);
      case 0x0138: return((CHAR)174);
      case 0x013b: return((CHAR)167);
      case 0x013c: return((CHAR)183);
      case 0x0143: return((CHAR)168);
      case 0x0144: return((CHAR)184);
      case 0x0145: return((CHAR)209);
      case 0x014a: return((CHAR)175);
      case 0x014b: return((CHAR)191);
      case 0x014c: return((CHAR)210);
      case 0x014d: return((CHAR)242);
      case 0x0156: return((CHAR)169);
      case 0x0157: return((CHAR)185);
      case 0x0160: return((CHAR)170);
      case 0x0161: return((CHAR)186);
      case 0x0166: return((CHAR)171);
      case 0x0167: return((CHAR)187);
      case 0x0168: return((CHAR)215);
      case 0x0169: return((CHAR)247);
      case 0x016a: return((CHAR)223);
      case 0x016b: return((CHAR)255);
      case 0x0172: return((CHAR)217);
      case 0x0173: return((CHAR)249);
      case 0x017d: return((CHAR)172);
      case 0x017e: return((CHAR)188);
      default: return(tx_ident(c));
    }
}


int					/* ISO 8859-15 Latin-9 */
#ifdef CK_ANSIC
tx_8859_15(USHORT c)
#else
tx_8859_15(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xa0)
      return((CHAR)(c & 0xff));
    switch(c) {
      case 0x20AC: return((CHAR)0xA4);	/* Differs from Latin-1 in */
      case 0x0160: return((CHAR)0xAC);	/* only eight places */
      case 0x0161: return((CHAR)0xA8);
      case 0x017D: return((CHAR)0xB4);
      case 0x017E: return((CHAR)0xB8);
      case 0x0152: return((CHAR)0xBC);
      case 0x0153: return((CHAR)0xBD);
      case 0x0178: return((CHAR)0xBE);
      default: return(tx_ident(c));
    }
}

int					/* Old KOI-8 (ECMA 113 First Ed.) */
#ifdef CK_ANSIC
tx_koi8(USHORT c)
#else
tx_koi8(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xa0)
      return((CHAR)(c & 0xff));
    switch(c) {
      case 0x0410: return((CHAR)(225 & 0xff));
      case 0x0411: return((CHAR)(226 & 0xff));
      case 0x0412: return((CHAR)(247 & 0xff));
      case 0x0413: return((CHAR)(231 & 0xff));
      case 0x0414: return((CHAR)(228 & 0xff));
      case 0x0415: return((CHAR)(229 & 0xff));
      case 0x0416: return((CHAR)(246 & 0xff));
      case 0x0417: return((CHAR)(250 & 0xff));
      case 0x0418: return((CHAR)(233 & 0xff));
      case 0x0419: return((CHAR)(234 & 0xff));
      case 0x041a: return((CHAR)(235 & 0xff));
      case 0x041b: return((CHAR)(236 & 0xff));
      case 0x041c: return((CHAR)(237 & 0xff));
      case 0x041d: return((CHAR)(238 & 0xff));
      case 0x041e: return((CHAR)(239 & 0xff));
      case 0x041f: return((CHAR)(240 & 0xff));
      case 0x0420: return((CHAR)(242 & 0xff));
      case 0x0421: return((CHAR)(243 & 0xff));
      case 0x0422: return((CHAR)(244 & 0xff));
      case 0x0423: return((CHAR)(245 & 0xff));
      case 0x0424: return((CHAR)(230 & 0xff));
      case 0x0425: return((CHAR)(232 & 0xff));
      case 0x0426: return((CHAR)(227 & 0xff));
      case 0x0427: return((CHAR)(254 & 0xff));
      case 0x0428: return((CHAR)(251 & 0xff));
      case 0x0429: return((CHAR)(253 & 0xff));
      case 0x042b: return((CHAR)(249 & 0xff));
      case 0x042c: return((CHAR)(248 & 0xff));
      case 0x042d: return((CHAR)(252 & 0xff));
      case 0x042e: return((CHAR)(224 & 0xff));
      case 0x042f: return((CHAR)(241 & 0xff));
      case 0x0430: return((CHAR)(193 & 0xff));
      case 0x0431: return((CHAR)(194 & 0xff));
      case 0x0432: return((CHAR)(215 & 0xff));
      case 0x0433: return((CHAR)(199 & 0xff));
      case 0x0434: return((CHAR)(196 & 0xff));
      case 0x0435: return((CHAR)(197 & 0xff));
      case 0x0436: return((CHAR)(214 & 0xff));
      case 0x0437: return((CHAR)(218 & 0xff));
      case 0x0438: return((CHAR)(201 & 0xff));
      case 0x0439: return((CHAR)(202 & 0xff));
      case 0x043a: return((CHAR)(203 & 0xff));
      case 0x043b: return((CHAR)(204 & 0xff));
      case 0x043c: return((CHAR)(205 & 0xff));
      case 0x043d: return((CHAR)(206 & 0xff));
      case 0x043e: return((CHAR)(207 & 0xff));
      case 0x043f: return((CHAR)(208 & 0xff));
      case 0x0440: return((CHAR)(210 & 0xff));
      case 0x0441: return((CHAR)(211 & 0xff));
      case 0x0442: return((CHAR)(212 & 0xff));
      case 0x0443: return((CHAR)(213 & 0xff));
      case 0x0444: return((CHAR)(198 & 0xff));
      case 0x0445: return((CHAR)(200 & 0xff));
      case 0x0446: return((CHAR)(195 & 0xff));
      case 0x0447: return((CHAR)(222 & 0xff));
      case 0x0448: return((CHAR)(219 & 0xff));
      case 0x0449: return((CHAR)(221 & 0xff));
      case 0x044a: return((CHAR)(223 & 0xff));
      case 0x044b: return((CHAR)(217 & 0xff));
      case 0x044c: return((CHAR)(216 & 0xff));
      case 0x044d: return((CHAR)(220 & 0xff));
      case 0x044e: return((CHAR)(192 & 0xff));
      case 0x044f: return((CHAR)(209 & 0xff));
      default: return(tx_ident(c));
    }
}

int					/* UCS-2 to KOI8-R (Russia) */
#ifdef CK_ANSIC
tx_koi8r(USHORT c)
#else
tx_koi8r(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x00A0)
      return((CHAR)(c & 0xff));
    switch(c) {
      case 0x00A0: return((CHAR)(154 & 0xff));
      case 0x00A9: return((CHAR)(191 & 0xff));
      case 0x00B0: return((CHAR)(156 & 0xff));
      case 0x00B2: return((CHAR)(157 & 0xff));
      case 0x00B7: return((CHAR)(158 & 0xff));
      case 0x00F7: return((CHAR)(159 & 0xff));
      case 0x0401: return((CHAR)(179 & 0xff));
      case 0x0410: return((CHAR)(225 & 0xff));
      case 0x0411: return((CHAR)(226 & 0xff));
      case 0x0412: return((CHAR)(247 & 0xff));
      case 0x0413: return((CHAR)(231 & 0xff));
      case 0x0414: return((CHAR)(228 & 0xff));
      case 0x0415: return((CHAR)(229 & 0xff));
      case 0x0416: return((CHAR)(246 & 0xff));
      case 0x0417: return((CHAR)(250 & 0xff));
      case 0x0418: return((CHAR)(233 & 0xff));
      case 0x0419: return((CHAR)(234 & 0xff));
      case 0x041A: return((CHAR)(235 & 0xff));
      case 0x041B: return((CHAR)(236 & 0xff));
      case 0x041C: return((CHAR)(237 & 0xff));
      case 0x041D: return((CHAR)(238 & 0xff));
      case 0x041E: return((CHAR)(239 & 0xff));
      case 0x041F: return((CHAR)(240 & 0xff));
      case 0x0420: return((CHAR)(242 & 0xff));
      case 0x0421: return((CHAR)(243 & 0xff));
      case 0x0422: return((CHAR)(244 & 0xff));
      case 0x0423: return((CHAR)(245 & 0xff));
      case 0x0424: return((CHAR)(230 & 0xff));
      case 0x0425: return((CHAR)(232 & 0xff));
      case 0x0426: return((CHAR)(227 & 0xff));
      case 0x0427: return((CHAR)(254 & 0xff));
      case 0x0428: return((CHAR)(251 & 0xff));
      case 0x0429: return((CHAR)(253 & 0xff));
      case 0x042A: return((CHAR)(255 & 0xff));
      case 0x042B: return((CHAR)(249 & 0xff));
      case 0x042C: return((CHAR)(248 & 0xff));
      case 0x042D: return((CHAR)(252 & 0xff));
      case 0x042E: return((CHAR)(224 & 0xff));
      case 0x042F: return((CHAR)(241 & 0xff));
      case 0x0430: return((CHAR)(193 & 0xff));
      case 0x0431: return((CHAR)(194 & 0xff));
      case 0x0432: return((CHAR)(215 & 0xff));
      case 0x0433: return((CHAR)(199 & 0xff));
      case 0x0434: return((CHAR)(196 & 0xff));
      case 0x0435: return((CHAR)(197 & 0xff));
      case 0x0436: return((CHAR)(214 & 0xff));
      case 0x0437: return((CHAR)(218 & 0xff));
      case 0x0438: return((CHAR)(201 & 0xff));
      case 0x0439: return((CHAR)(202 & 0xff));
      case 0x043A: return((CHAR)(203 & 0xff));
      case 0x043B: return((CHAR)(204 & 0xff));
      case 0x043C: return((CHAR)(205 & 0xff));
      case 0x043D: return((CHAR)(206 & 0xff));
      case 0x043E: return((CHAR)(207 & 0xff));
      case 0x043F: return((CHAR)(208 & 0xff));
      case 0x0440: return((CHAR)(210 & 0xff));
      case 0x0441: return((CHAR)(211 & 0xff));
      case 0x0442: return((CHAR)(212 & 0xff));
      case 0x0443: return((CHAR)(213 & 0xff));
      case 0x0444: return((CHAR)(198 & 0xff));
      case 0x0445: return((CHAR)(200 & 0xff));
      case 0x0446: return((CHAR)(195 & 0xff));
      case 0x0447: return((CHAR)(222 & 0xff));
      case 0x0448: return((CHAR)(219 & 0xff));
      case 0x0449: return((CHAR)(221 & 0xff));
      case 0x044A: return((CHAR)(223 & 0xff));
      case 0x044B: return((CHAR)(217 & 0xff));
      case 0x044C: return((CHAR)(216 & 0xff));
      case 0x044D: return((CHAR)(220 & 0xff));
      case 0x044E: return((CHAR)(192 & 0xff));
      case 0x044F: return((CHAR)(209 & 0xff));
      case 0x0451: return((CHAR)(163 & 0xff));
      case 0x2219: return((CHAR)(149 & 0xff));
      case 0x221A: return((CHAR)(150 & 0xff));
      case 0x2248: return((CHAR)(151 & 0xff));
      case 0x2264: return((CHAR)(152 & 0xff));
      case 0x2265: return((CHAR)(153 & 0xff));
      case 0x2320: return((CHAR)(147 & 0xff));
      case 0x2321: return((CHAR)(155 & 0xff));
      case 0x2500: return((CHAR)(128 & 0xff));
      case 0x2502: return((CHAR)(129 & 0xff));
      case 0x250C: return((CHAR)(130 & 0xff));
      case 0x2510: return((CHAR)(131 & 0xff));
      case 0x2514: return((CHAR)(132 & 0xff));
      case 0x2518: return((CHAR)(133 & 0xff));
      case 0x251C: return((CHAR)(134 & 0xff));
      case 0x2524: return((CHAR)(135 & 0xff));
      case 0x252C: return((CHAR)(136 & 0xff));
      case 0x2534: return((CHAR)(137 & 0xff));
      case 0x253C: return((CHAR)(138 & 0xff));
      case 0x2550: return((CHAR)(160 & 0xff));
      case 0x2551: return((CHAR)(161 & 0xff));
      case 0x2552: return((CHAR)(162 & 0xff));
      case 0x2553: return((CHAR)(164 & 0xff));
      case 0x2554: return((CHAR)(165 & 0xff));
      case 0x2555: return((CHAR)(166 & 0xff));
      case 0x2556: return((CHAR)(167 & 0xff));
      case 0x2557: return((CHAR)(168 & 0xff));
      case 0x2558: return((CHAR)(169 & 0xff));
      case 0x2559: return((CHAR)(170 & 0xff));
      case 0x255A: return((CHAR)(171 & 0xff));
      case 0x255B: return((CHAR)(172 & 0xff));
      case 0x255C: return((CHAR)(173 & 0xff));
      case 0x255D: return((CHAR)(174 & 0xff));
      case 0x255E: return((CHAR)(175 & 0xff));
      case 0x255F: return((CHAR)(176 & 0xff));
      case 0x2560: return((CHAR)(177 & 0xff));
      case 0x2561: return((CHAR)(178 & 0xff));
      case 0x2562: return((CHAR)(180 & 0xff));
      case 0x2563: return((CHAR)(181 & 0xff));
      case 0x2564: return((CHAR)(182 & 0xff));
      case 0x2565: return((CHAR)(183 & 0xff));
      case 0x2566: return((CHAR)(184 & 0xff));
      case 0x2567: return((CHAR)(185 & 0xff));
      case 0x2568: return((CHAR)(186 & 0xff));
      case 0x2569: return((CHAR)(187 & 0xff));
      case 0x256A: return((CHAR)(188 & 0xff));
      case 0x256B: return((CHAR)(189 & 0xff));
      case 0x256C: return((CHAR)(190 & 0xff));
      case 0x2580: return((CHAR)(139 & 0xff));
      case 0x2584: return((CHAR)(140 & 0xff));
      case 0x2588: return((CHAR)(141 & 0xff));
      case 0x258C: return((CHAR)(142 & 0xff));
      case 0x2590: return((CHAR)(143 & 0xff));
      case 0x2591: return((CHAR)(144 & 0xff));
      case 0x2592: return((CHAR)(145 & 0xff));
      case 0x2593: return((CHAR)(146 & 0xff));
      case 0x25A0: return((CHAR)(148 & 0xff));
      default: return(tx_ident(c));
    }
}

int					/* KOI8-U (Ukraine) */
#ifdef CK_ANSIC
tx_koi8u(USHORT c)
#else
tx_koi8u(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xa0)
      return((CHAR)(c & 0xff));
    switch(c) {
      case 0x00A0: return((CHAR)(154 & 0xff));
      case 0x00A9: return((CHAR)(191 & 0xff));
      case 0x00B0: return((CHAR)(156 & 0xff));
      case 0x00B2: return((CHAR)(157 & 0xff));
      case 0x00B7: return((CHAR)(158 & 0xff));
      case 0x00F7: return((CHAR)(159 & 0xff));
      case 0x0401: return((CHAR)(179 & 0xff));
      case 0x0404: return((CHAR)(180 & 0xff));
      case 0x0406: return((CHAR)(182 & 0xff));
      case 0x0407: return((CHAR)(183 & 0xff));
      case 0x0410: return((CHAR)(225 & 0xff));
      case 0x0411: return((CHAR)(226 & 0xff));
      case 0x0412: return((CHAR)(247 & 0xff));
      case 0x0413: return((CHAR)(231 & 0xff));
      case 0x0414: return((CHAR)(228 & 0xff));
      case 0x0415: return((CHAR)(229 & 0xff));
      case 0x0416: return((CHAR)(246 & 0xff));
      case 0x0417: return((CHAR)(250 & 0xff));
      case 0x0418: return((CHAR)(233 & 0xff));
      case 0x0419: return((CHAR)(234 & 0xff));
      case 0x041A: return((CHAR)(235 & 0xff));
      case 0x041B: return((CHAR)(236 & 0xff));
      case 0x041C: return((CHAR)(237 & 0xff));
      case 0x041D: return((CHAR)(238 & 0xff));
      case 0x041E: return((CHAR)(239 & 0xff));
      case 0x041F: return((CHAR)(240 & 0xff));
      case 0x0420: return((CHAR)(242 & 0xff));
      case 0x0421: return((CHAR)(243 & 0xff));
      case 0x0422: return((CHAR)(244 & 0xff));
      case 0x0423: return((CHAR)(245 & 0xff));
      case 0x0424: return((CHAR)(230 & 0xff));
      case 0x0425: return((CHAR)(232 & 0xff));
      case 0x0426: return((CHAR)(227 & 0xff));
      case 0x0427: return((CHAR)(254 & 0xff));
      case 0x0428: return((CHAR)(251 & 0xff));
      case 0x0429: return((CHAR)(253 & 0xff));
      case 0x042A: return((CHAR)(255 & 0xff));
      case 0x042B: return((CHAR)(249 & 0xff));
      case 0x042C: return((CHAR)(248 & 0xff));
      case 0x042D: return((CHAR)(252 & 0xff));
      case 0x042E: return((CHAR)(224 & 0xff));
      case 0x042F: return((CHAR)(241 & 0xff));
      case 0x0430: return((CHAR)(193 & 0xff));
      case 0x0431: return((CHAR)(194 & 0xff));
      case 0x0432: return((CHAR)(215 & 0xff));
      case 0x0433: return((CHAR)(199 & 0xff));
      case 0x0434: return((CHAR)(196 & 0xff));
      case 0x0435: return((CHAR)(197 & 0xff));
      case 0x0436: return((CHAR)(214 & 0xff));
      case 0x0437: return((CHAR)(218 & 0xff));
      case 0x0438: return((CHAR)(201 & 0xff));
      case 0x0439: return((CHAR)(202 & 0xff));
      case 0x043A: return((CHAR)(203 & 0xff));
      case 0x043B: return((CHAR)(204 & 0xff));
      case 0x043C: return((CHAR)(205 & 0xff));
      case 0x043D: return((CHAR)(206 & 0xff));
      case 0x043E: return((CHAR)(207 & 0xff));
      case 0x043F: return((CHAR)(208 & 0xff));
      case 0x0440: return((CHAR)(210 & 0xff));
      case 0x0441: return((CHAR)(211 & 0xff));
      case 0x0442: return((CHAR)(212 & 0xff));
      case 0x0443: return((CHAR)(213 & 0xff));
      case 0x0444: return((CHAR)(198 & 0xff));
      case 0x0445: return((CHAR)(200 & 0xff));
      case 0x0446: return((CHAR)(195 & 0xff));
      case 0x0447: return((CHAR)(222 & 0xff));
      case 0x0448: return((CHAR)(219 & 0xff));
      case 0x0449: return((CHAR)(221 & 0xff));
      case 0x044A: return((CHAR)(223 & 0xff));
      case 0x044B: return((CHAR)(217 & 0xff));
      case 0x044C: return((CHAR)(216 & 0xff));
      case 0x044D: return((CHAR)(220 & 0xff));
      case 0x044E: return((CHAR)(192 & 0xff));
      case 0x044F: return((CHAR)(209 & 0xff));
      case 0x0451: return((CHAR)(163 & 0xff));
      case 0x0454: return((CHAR)(164 & 0xff));
      case 0x0456: return((CHAR)(166 & 0xff));
      case 0x0457: return((CHAR)(167 & 0xff));
      case 0x0490: return((CHAR)(189 & 0xff));
      case 0x0491: return((CHAR)(173 & 0xff));
      case 0x2219: return((CHAR)(149 & 0xff));
      case 0x221A: return((CHAR)(150 & 0xff));
      case 0x2248: return((CHAR)(151 & 0xff));
      case 0x2264: return((CHAR)(152 & 0xff));
      case 0x2265: return((CHAR)(153 & 0xff));
      case 0x2320: return((CHAR)(147 & 0xff));
      case 0x2321: return((CHAR)(155 & 0xff));
      case 0x2500: return((CHAR)(128 & 0xff));
      case 0x2502: return((CHAR)(129 & 0xff));
      case 0x250C: return((CHAR)(130 & 0xff));
      case 0x2510: return((CHAR)(131 & 0xff));
      case 0x2514: return((CHAR)(132 & 0xff));
      case 0x2518: return((CHAR)(133 & 0xff));
      case 0x251C: return((CHAR)(134 & 0xff));
      case 0x2524: return((CHAR)(135 & 0xff));
      case 0x252C: return((CHAR)(136 & 0xff));
      case 0x2534: return((CHAR)(137 & 0xff));
      case 0x253C: return((CHAR)(138 & 0xff));
      case 0x2550: return((CHAR)(160 & 0xff));
      case 0x2551: return((CHAR)(161 & 0xff));
      case 0x2552: return((CHAR)(162 & 0xff));
      case 0x2554: return((CHAR)(165 & 0xff));
      case 0x2557: return((CHAR)(168 & 0xff));
      case 0x2558: return((CHAR)(169 & 0xff));
      case 0x2559: return((CHAR)(170 & 0xff));
      case 0x255A: return((CHAR)(171 & 0xff));
      case 0x255B: return((CHAR)(172 & 0xff));
      case 0x255D: return((CHAR)(174 & 0xff));
      case 0x255E: return((CHAR)(175 & 0xff));
      case 0x255F: return((CHAR)(176 & 0xff));
      case 0x2560: return((CHAR)(177 & 0xff));
      case 0x2561: return((CHAR)(178 & 0xff));
      case 0x2563: return((CHAR)(181 & 0xff));
      case 0x2566: return((CHAR)(184 & 0xff));
      case 0x2567: return((CHAR)(185 & 0xff));
      case 0x2568: return((CHAR)(186 & 0xff));
      case 0x2569: return((CHAR)(187 & 0xff));
      case 0x256A: return((CHAR)(188 & 0xff));
      case 0x256C: return((CHAR)(190 & 0xff));
      case 0x2580: return((CHAR)(139 & 0xff));
      case 0x2584: return((CHAR)(140 & 0xff));
      case 0x2588: return((CHAR)(141 & 0xff));
      case 0x258C: return((CHAR)(142 & 0xff));
      case 0x2590: return((CHAR)(143 & 0xff));
      case 0x2591: return((CHAR)(144 & 0xff));
      case 0x2592: return((CHAR)(145 & 0xff));
      case 0x2593: return((CHAR)(146 & 0xff));
      case 0x25A0: return((CHAR)(148 & 0xff));
      default: return(tx_ident(c));
    }
}


int					/* DEC MCS */
#ifdef CK_ANSIC
tx_decmcs(USHORT c)
#else
tx_decmcs(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xa0)
      return((CHAR)(c & 0xff));
    switch(c) {
      case 0x00a6:
      case 0x00a8:
      case 0x00ac:
      case 0x00ae:
      case 0x00af:
      case 0x00b4:
      case 0x00b8:
      case 0x00be:
      case 0x00d0:
      case 0x00de:
      case 0x00f0:
      case 0x00fe:
      case 0x00ff:
        return(-1);			/* These are all undefined in DECMCS */
      case 0x00a4:			/* Currency sign */
	return((CHAR)0xa8);
      case 0x0152:			/* OE */
	return((CHAR)0xd7);
      case 0x0153:			/* oe */
	return((CHAR)0xf7);
      default: return(tx_ident(c));
    }
}

int					/* NeXTSTEP */
#ifdef CK_ANSIC
tx_nextstep(USHORT c)
#else
tx_nextstep(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x00a0: return((CHAR)(128 & 0xff));
      case 0x00a1: return((CHAR)(161 & 0xff));
      case 0x00a2: return((CHAR)(162 & 0xff));
      case 0x00a3: return((CHAR)(163 & 0xff));
      case 0x00a4: return((CHAR)(168 & 0xff));
      case 0x00a5: return((CHAR)(165 & 0xff));
      case 0x00a6: return((CHAR)(181 & 0xff));
      case 0x00a7: return((CHAR)(167 & 0xff));
      case 0x00a8: return((CHAR)(200 & 0xff));
      case 0x00a9: return((CHAR)(160 & 0xff));
      case 0x00aa: return((CHAR)(227 & 0xff));
      case 0x00ab: return((CHAR)(171 & 0xff));
      case 0x00ac: return((CHAR)(190 & 0xff));
      case 0x00ae: return((CHAR)(176 & 0xff));
      case 0x00af: return((CHAR)(197 & 0xff));
      case 0x00b1: return((CHAR)(209 & 0xff));
      case 0x00b2: return((CHAR)(201 & 0xff));
      case 0x00b3: return((CHAR)(204 & 0xff));
      case 0x00b4: return((CHAR)(194 & 0xff));
      case 0x00b5: return((CHAR)(157 & 0xff));
      case 0x00b6: return((CHAR)(182 & 0xff));
      case 0x00b7: return((CHAR)(180 & 0xff));
      case 0x00b8: return((CHAR)(203 & 0xff));
      case 0x00b9: return((CHAR)(192 & 0xff));
      case 0x00ba: return((CHAR)(235 & 0xff));
      case 0x00bb: return((CHAR)(187 & 0xff));
      case 0x00bc: return((CHAR)(210 & 0xff));
      case 0x00bd: return((CHAR)(211 & 0xff));
      case 0x00be: return((CHAR)(212 & 0xff));
      case 0x00bf: return((CHAR)(191 & 0xff));
      case 0x00c0: return((CHAR)(129 & 0xff));
      case 0x00c1: return((CHAR)(130 & 0xff));
      case 0x00c2: return((CHAR)(131 & 0xff));
      case 0x00c3: return((CHAR)(132 & 0xff));
      case 0x00c4: return((CHAR)(133 & 0xff));
      case 0x00c5: return((CHAR)(134 & 0xff));
      case 0x00c6: return((CHAR)(225 & 0xff));
      case 0x00c7: return((CHAR)(135 & 0xff));
      case 0x00c8: return((CHAR)(136 & 0xff));
      case 0x00c9: return((CHAR)(137 & 0xff));
      case 0x00ca: return((CHAR)(138 & 0xff));
      case 0x00cb: return((CHAR)(139 & 0xff));
      case 0x00cc: return((CHAR)(140 & 0xff));
      case 0x00cd: return((CHAR)(141 & 0xff));
      case 0x00ce: return((CHAR)(142 & 0xff));
      case 0x00cf: return((CHAR)(143 & 0xff));
      case 0x00d0: return((CHAR)(144 & 0xff));
      case 0x00d1: return((CHAR)(145 & 0xff));
      case 0x00d2: return((CHAR)(146 & 0xff));
      case 0x00d3: return((CHAR)(147 & 0xff));
      case 0x00d4: return((CHAR)(148 & 0xff));
      case 0x00d5: return((CHAR)(149 & 0xff));
      case 0x00d6: return((CHAR)(150 & 0xff));
      case 0x00d7: return((CHAR)(158 & 0xff));
      case 0x00d8: return((CHAR)(233 & 0xff));
      case 0x00d9: return((CHAR)(151 & 0xff));
      case 0x00da: return((CHAR)(152 & 0xff));
      case 0x00db: return((CHAR)(153 & 0xff));
      case 0x00dc: return((CHAR)(154 & 0xff));
      case 0x00dd: return((CHAR)(155 & 0xff));
      case 0x00de: return((CHAR)(156 & 0xff));
      case 0x00df: return((CHAR)(251 & 0xff));
      case 0x00e0: return((CHAR)(213 & 0xff));
      case 0x00e1: return((CHAR)(214 & 0xff));
      case 0x00e2: return((CHAR)(215 & 0xff));
      case 0x00e3: return((CHAR)(216 & 0xff));
      case 0x00e4: return((CHAR)(217 & 0xff));
      case 0x00e5: return((CHAR)(218 & 0xff));
      case 0x00e6: return((CHAR)(241 & 0xff));
      case 0x00e7: return((CHAR)(219 & 0xff));
      case 0x00e8: return((CHAR)(220 & 0xff));
      case 0x00e9: return((CHAR)(221 & 0xff));
      case 0x00ea: return((CHAR)(222 & 0xff));
      case 0x00eb: return((CHAR)(223 & 0xff));
      case 0x00ec: return((CHAR)(224 & 0xff));
      case 0x00ed: return((CHAR)(226 & 0xff));
      case 0x00ee: return((CHAR)(228 & 0xff));
      case 0x00ef: return((CHAR)(229 & 0xff));
      case 0x00f0: return((CHAR)(230 & 0xff));
      case 0x00f1: return((CHAR)(231 & 0xff));
      case 0x00f2: return((CHAR)(236 & 0xff));
      case 0x00f3: return((CHAR)(237 & 0xff));
      case 0x00f4: return((CHAR)(238 & 0xff));
      case 0x00f5: return((CHAR)(239 & 0xff));
      case 0x00f6: return((CHAR)(240 & 0xff));
      case 0x00f7: return((CHAR)(159 & 0xff));
      case 0x00f8: return((CHAR)(249 & 0xff));
      case 0x00f9: return((CHAR)(242 & 0xff));
      case 0x00fa: return((CHAR)(243 & 0xff));
      case 0x00fb: return((CHAR)(244 & 0xff));
      case 0x00fc: return((CHAR)(246 & 0xff));
      case 0x00fd: return((CHAR)(247 & 0xff));
      case 0x00fe: return((CHAR)(252 & 0xff));
      case 0x00ff: return((CHAR)(253 & 0xff));
      case 0x0131: return((CHAR)(245 & 0xff));
      case 0x0141: return((CHAR)(232 & 0xff));
      case 0x0142: return((CHAR)(248 & 0xff));
      case 0x0152: return((CHAR)(234 & 0xff));
      case 0x0153: return((CHAR)(250 & 0xff));
      case 0x0192: return((CHAR)(166 & 0xff));
      case 0x02c6: return((CHAR)(195 & 0xff));
      case 0x02c7: return((CHAR)(207 & 0xff));
      case 0x02cb: return((CHAR)(193 & 0xff));
      case 0x02d8: return((CHAR)(198 & 0xff));
      case 0x02d9: return((CHAR)(199 & 0xff));
      case 0x02da: return((CHAR)(202 & 0xff));
      case 0x02db: return((CHAR)(206 & 0xff));
      case 0x02dc: return((CHAR)(196 & 0xff));
      case 0x02dd: return((CHAR)(205 & 0xff));
      case 0x2013: return((CHAR)(177 & 0xff));
      case 0x2014: return((CHAR)(208 & 0xff));
      case 0x2019: return((CHAR)(169 & 0xff));
      case 0x201a: return((CHAR)(184 & 0xff));
      case 0x201c: return((CHAR)(170 & 0xff));
      case 0x201d: return((CHAR)(186 & 0xff));
      case 0x201e: return((CHAR)(185 & 0xff));
      case 0x2020: return((CHAR)(178 & 0xff));
      case 0x2021: return((CHAR)(179 & 0xff));
      case 0x2022: return((CHAR)(183 & 0xff));
      case 0x2026: return((CHAR)(188 & 0xff));
      case 0x2030: return((CHAR)(189 & 0xff));
      case 0x2039: return((CHAR)(172 & 0xff));
      case 0x203a: return((CHAR)(173 & 0xff));
      case 0x2044: return((CHAR)(164 & 0xff));
      case 0xfb01: return((CHAR)(174 & 0xff));
      case 0xfb02: return((CHAR)(175 & 0xff));
      default: return(tx_punc(c));
    }
}

int					/* DG International */
#ifdef CK_ANSIC
tx_dgi(USHORT c)
#else
tx_dgi(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xa0)
      return((CHAR)(c & 0xff));
    switch(c) {
      case 0x00a0: return((CHAR)(160 & 0xff));
      case 0x00a1: return((CHAR)(171 & 0xff));
      case 0x00a2: return((CHAR)(167 & 0xff));
      case 0x00a3: return((CHAR)(168 & 0xff));
      case 0x00a4: return((CHAR)(166 & 0xff));
      case 0x00a5: return((CHAR)(181 & 0xff));
      case 0x00a7: return((CHAR)(187 & 0xff));
      case 0x00a8: return((CHAR)(189 & 0xff));
      case 0x00a9: return((CHAR)(173 & 0xff));
      case 0x00aa: return((CHAR)(169 & 0xff));
      case 0x00ab: return((CHAR)(177 & 0xff));
      case 0x00ac: return((CHAR)(161 & 0xff));
      case 0x00ae: return((CHAR)(174 & 0xff));
      case 0x00b0: return((CHAR)(188 & 0xff));
      case 0x00b1: return((CHAR)(182 & 0xff));
      case 0x00b2: return((CHAR)(164 & 0xff));
      case 0x00b3: return((CHAR)(165 & 0xff));
      case 0x00b4: return((CHAR)(190 & 0xff));
      case 0x00b5: return((CHAR)(163 & 0xff));
      case 0x00b6: return((CHAR)(178 & 0xff));
      case 0x00b7: return((CHAR)(185 & 0xff));
      case 0x00b8: return((CHAR)(186 & 0xff));
      case 0x00ba: return((CHAR)(170 & 0xff));
      case 0x00bb: return((CHAR)(176 & 0xff));
      case 0x00bd: return((CHAR)(162 & 0xff));
      case 0x00bf: return((CHAR)(172 & 0xff));
      case 0x00c0: return((CHAR)(193 & 0xff));
      case 0x00c1: return((CHAR)(192 & 0xff));
      case 0x00c2: return((CHAR)(194 & 0xff));
      case 0x00c3: return((CHAR)(196 & 0xff));
      case 0x00c4: return((CHAR)(195 & 0xff));
      case 0x00c5: return((CHAR)(197 & 0xff));
      case 0x00c6: return((CHAR)(198 & 0xff));
      case 0x00c7: return((CHAR)(199 & 0xff));
      case 0x00c8: return((CHAR)(201 & 0xff));
      case 0x00c9: return((CHAR)(200 & 0xff));
      case 0x00ca: return((CHAR)(202 & 0xff));
      case 0x00cb: return((CHAR)(203 & 0xff));
      case 0x00cc: return((CHAR)(205 & 0xff));
      case 0x00cd: return((CHAR)(204 & 0xff));
      case 0x00ce: return((CHAR)(206 & 0xff));
      case 0x00cf: return((CHAR)(207 & 0xff));
      case 0x00d1: return((CHAR)(208 & 0xff));
      case 0x00d2: return((CHAR)(210 & 0xff));
      case 0x00d3: return((CHAR)(209 & 0xff));
      case 0x00d4: return((CHAR)(211 & 0xff));
      case 0x00d5: return((CHAR)(213 & 0xff));
      case 0x00d6: return((CHAR)(212 & 0xff));
      case 0x00d8: return((CHAR)(214 & 0xff));
      case 0x00d9: return((CHAR)(217 & 0xff));
      case 0x00da: return((CHAR)(216 & 0xff));
      case 0x00db: return((CHAR)(218 & 0xff));
      case 0x00dc: return((CHAR)(219 & 0xff));
      case 0x00df: return((CHAR)(252 & 0xff));
      case 0x00e0: return((CHAR)(225 & 0xff));
      case 0x00e1: return((CHAR)(224 & 0xff));
      case 0x00e2: return((CHAR)(226 & 0xff));
      case 0x00e3: return((CHAR)(228 & 0xff));
      case 0x00e4: return((CHAR)(227 & 0xff));
      case 0x00e5: return((CHAR)(229 & 0xff));
      case 0x00e6: return((CHAR)(230 & 0xff));
      case 0x00e7: return((CHAR)(231 & 0xff));
      case 0x00e8: return((CHAR)(233 & 0xff));
      case 0x00e9: return((CHAR)(232 & 0xff));
      case 0x00ea: return((CHAR)(234 & 0xff));
      case 0x00eb: return((CHAR)(235 & 0xff));
      case 0x00ec: return((CHAR)(237 & 0xff));
      case 0x00ed: return((CHAR)(236 & 0xff));
      case 0x00ee: return((CHAR)(238 & 0xff));
      case 0x00ef: return((CHAR)(239 & 0xff));
      case 0x00f1: return((CHAR)(240 & 0xff));
      case 0x00f2: return((CHAR)(242 & 0xff));
      case 0x00f3: return((CHAR)(241 & 0xff));
      case 0x00f4: return((CHAR)(243 & 0xff));
      case 0x00f5: return((CHAR)(245 & 0xff));
      case 0x00f6: return((CHAR)(244 & 0xff));
      case 0x00f8: return((CHAR)(246 & 0xff));
      case 0x00f9: return((CHAR)(249 & 0xff));
      case 0x00fa: return((CHAR)(248 & 0xff));
      case 0x00fb: return((CHAR)(250 & 0xff));
      case 0x00fc: return((CHAR)(251 & 0xff));
      case 0x00ff: return((CHAR)(253 & 0xff));
      case 0x0153: return((CHAR)(247 & 0xff));
      case 0x0178: return((CHAR)(221 & 0xff));
      case 0x0192: return((CHAR)(180 & 0xff));
      case 0x0276: return((CHAR)(215 & 0xff));
      case 0x2021: return((CHAR)(175 & 0xff));
      case 0x2122: return((CHAR)(179 & 0xff));
      case 0x2191: return((CHAR)(191 & 0xff));
      case 0x2264: return((CHAR)(183 & 0xff));
      case 0x2265: return((CHAR)(184 & 0xff));
      case 0x2588: return((CHAR)(255 & 0xff));
      default: return(tx_punc(c));
    }
}

int					/* Macintosh Latin */
#ifdef CK_ANSIC
tx_maclatin(USHORT c)
#else
tx_maclatin(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x00a0: return((CHAR)(202 & 0xff));
      case 0x00a1: return((CHAR)(193 & 0xff));
      case 0x00a2: return((CHAR)(162 & 0xff));
      case 0x00a3: return((CHAR)(163 & 0xff));
      case 0x00a4: return((CHAR)(219 & 0xff));
      case 0x00a5: return((CHAR)(180 & 0xff));
      case 0x00a7: return((CHAR)(164 & 0xff));
      case 0x00a8: return((CHAR)(172 & 0xff));
      case 0x00a9: return((CHAR)(169 & 0xff));
      case 0x00aa: return((CHAR)(187 & 0xff));
      case 0x00ab: return((CHAR)(199 & 0xff));
      case 0x00ac: return((CHAR)(194 & 0xff));
      case 0x00ae: return((CHAR)(168 & 0xff));
      case 0x00af: return((CHAR)(248 & 0xff));
      case 0x00b0: return((CHAR)(161 & 0xff));
      case 0x00b1: return((CHAR)(177 & 0xff));
      case 0x00b4: return((CHAR)(171 & 0xff));
      case 0x00b5: return((CHAR)(181 & 0xff));
      case 0x00b6: return((CHAR)(166 & 0xff));
      case 0x00b7: return((CHAR)(225 & 0xff));
      case 0x00b8: return((CHAR)(252 & 0xff));
      case 0x00ba: return((CHAR)(188 & 0xff));
      case 0x00bb: return((CHAR)(200 & 0xff));
      case 0x00bf: return((CHAR)(192 & 0xff));
      case 0x00c0: return((CHAR)(203 & 0xff));
      case 0x00c1: return((CHAR)(231 & 0xff));
      case 0x00c2: return((CHAR)(229 & 0xff));
      case 0x00c3: return((CHAR)(204 & 0xff));
      case 0x00c4: return((CHAR)(128 & 0xff));
      case 0x00c5: return((CHAR)(129 & 0xff));
      case 0x00c6: return((CHAR)(174 & 0xff));
      case 0x00c7: return((CHAR)(130 & 0xff));
      case 0x00c8: return((CHAR)(233 & 0xff));
      case 0x00c9: return((CHAR)(131 & 0xff));
      case 0x00ca: return((CHAR)(230 & 0xff));
      case 0x00cb: return((CHAR)(232 & 0xff));
      case 0x00cc: return((CHAR)(237 & 0xff));
      case 0x00cd: return((CHAR)(234 & 0xff));
      case 0x00ce: return((CHAR)(235 & 0xff));
      case 0x00cf: return((CHAR)(236 & 0xff));
      case 0x00d0: return((CHAR)(220 & 0xff));
      case 0x00d1: return((CHAR)(132 & 0xff));
      case 0x00d2: return((CHAR)(241 & 0xff));
      case 0x00d3: return((CHAR)(238 & 0xff));
      case 0x00d4: return((CHAR)(239 & 0xff));
      case 0x00d5: return((CHAR)(205 & 0xff));
      case 0x00d6: return((CHAR)(133 & 0xff));
      case 0x00d8: return((CHAR)(175 & 0xff));
      case 0x00d9: return((CHAR)(244 & 0xff));
      case 0x00da: return((CHAR)(242 & 0xff));
      case 0x00db: return((CHAR)(243 & 0xff));
      case 0x00dc: return((CHAR)(134 & 0xff));
      case 0x00dd: return((CHAR)(160 & 0xff));
      case 0x00de: return((CHAR)(222 & 0xff));
      case 0x00df: return((CHAR)(167 & 0xff));
      case 0x00e0: return((CHAR)(136 & 0xff));
      case 0x00e1: return((CHAR)(135 & 0xff));
      case 0x00e2: return((CHAR)(137 & 0xff));
      case 0x00e3: return((CHAR)(139 & 0xff));
      case 0x00e4: return((CHAR)(138 & 0xff));
      case 0x00e5: return((CHAR)(140 & 0xff));
      case 0x00e6: return((CHAR)(190 & 0xff));
      case 0x00e7: return((CHAR)(141 & 0xff));
      case 0x00e8: return((CHAR)(143 & 0xff));
      case 0x00e9: return((CHAR)(142 & 0xff));
      case 0x00ea: return((CHAR)(144 & 0xff));
      case 0x00eb: return((CHAR)(145 & 0xff));
      case 0x00ec: return((CHAR)(147 & 0xff));
      case 0x00ed: return((CHAR)(146 & 0xff));
      case 0x00ee: return((CHAR)(148 & 0xff));
      case 0x00ef: return((CHAR)(149 & 0xff));
      case 0x00f0: return((CHAR)(221 & 0xff));
      case 0x00f1: return((CHAR)(150 & 0xff));
      case 0x00f2: return((CHAR)(152 & 0xff));
      case 0x00f3: return((CHAR)(151 & 0xff));
      case 0x00f4: return((CHAR)(153 & 0xff));
      case 0x00f5: return((CHAR)(155 & 0xff));
      case 0x00f6: return((CHAR)(154 & 0xff));
      case 0x00f7: return((CHAR)(214 & 0xff));
      case 0x00f8: return((CHAR)(191 & 0xff));
      case 0x00f9: return((CHAR)(157 & 0xff));
      case 0x00fa: return((CHAR)(156 & 0xff));
      case 0x00fb: return((CHAR)(158 & 0xff));
      case 0x00fc: return((CHAR)(159 & 0xff));
      case 0x00fd: return((CHAR)(224 & 0xff));
      case 0x00fe: return((CHAR)(223 & 0xff));
      case 0x00ff: return((CHAR)(216 & 0xff));
      case 0x0131: return((CHAR)(245 & 0xff));
      case 0x0152: return((CHAR)(206 & 0xff));
      case 0x0153: return((CHAR)(207 & 0xff));
      case 0x0178: return((CHAR)(217 & 0xff));
      case 0x0192: return((CHAR)(196 & 0xff));
      case 0x02c6: return((CHAR)(246 & 0xff));
      case 0x02c7: return((CHAR)(255 & 0xff));
      case 0x02d8: return((CHAR)(249 & 0xff));
      case 0x02d9: return((CHAR)(250 & 0xff));
      case 0x02da: return((CHAR)(251 & 0xff));
      case 0x02db: return((CHAR)(254 & 0xff));
      case 0x02dc: return((CHAR)(247 & 0xff));
      case 0x02dd: return((CHAR)(253 & 0xff));
      case 0x03c0: return((CHAR)(185 & 0xff));
      case 0x2013: return((CHAR)(208 & 0xff));
      case 0x2014: return((CHAR)(209 & 0xff));
      case 0x2018: return((CHAR)(212 & 0xff));
      case 0x2019: return((CHAR)(213 & 0xff));
      case 0x201a: return((CHAR)(226 & 0xff));
      case 0x201c: return((CHAR)(210 & 0xff));
      case 0x201d: return((CHAR)(211 & 0xff));
      case 0x201e: return((CHAR)(227 & 0xff));
      case 0x2022: return((CHAR)(165 & 0xff));
      case 0x2026: return((CHAR)(201 & 0xff));
      case 0x2030: return((CHAR)(228 & 0xff));
      case 0x2044: return((CHAR)(218 & 0xff));
      case 0x2122: return((CHAR)(170 & 0xff));
      case 0x2126: return((CHAR)(189 & 0xff));
      case 0x2202: return((CHAR)(182 & 0xff));
      case 0x2206: return((CHAR)(198 & 0xff));
      case 0x220f: return((CHAR)(184 & 0xff));
      case 0x2211: return((CHAR)(183 & 0xff));
      case 0x221a: return((CHAR)(195 & 0xff));
      case 0x221e: return((CHAR)(176 & 0xff));
      case 0x222b: return((CHAR)(186 & 0xff));
      case 0x2248: return((CHAR)(197 & 0xff));
      case 0x2260: return((CHAR)(173 & 0xff));
      case 0x2264: return((CHAR)(178 & 0xff));
      case 0x2265: return((CHAR)(179 & 0xff));
      case 0x25ca: return((CHAR)(215 & 0xff));
      case 0xf8ff: return((CHAR)(240 & 0xff));
      default: return(tx_punc(c));
    }
}

int					/* Apple QuickDraw / CP10000 */
#ifdef CK_ANSIC
tx_quickdraw(USHORT c)
#else
tx_quickdraw(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x00a0: return((CHAR)(202 & 0xff));
      case 0x00a1: return((CHAR)(193 & 0xff));
      case 0x00a2: return((CHAR)(162 & 0xff));
      case 0x00a3: return((CHAR)(163 & 0xff));
      case 0x00a4: return((CHAR)(219 & 0xff));
      case 0x00a5: return((CHAR)(180 & 0xff));
      case 0x00a7: return((CHAR)(164 & 0xff));
      case 0x00a8: return((CHAR)(172 & 0xff));
      case 0x00a9: return((CHAR)(169 & 0xff));
      case 0x00aa: return((CHAR)(187 & 0xff));
      case 0x00ab: return((CHAR)(199 & 0xff));
      case 0x00ac: return((CHAR)(194 & 0xff));
      case 0x00ae: return((CHAR)(168 & 0xff));
      case 0x00af: return((CHAR)(248 & 0xff));
      case 0x00b0: return((CHAR)(161 & 0xff));
      case 0x00b1: return((CHAR)(177 & 0xff));
      case 0x00b4: return((CHAR)(171 & 0xff));
      case 0x00b5: return((CHAR)(181 & 0xff));
      case 0x00b6: return((CHAR)(166 & 0xff));
      case 0x00b7: return((CHAR)(225 & 0xff));
      case 0x00b8: return((CHAR)(252 & 0xff));
      case 0x00ba: return((CHAR)(188 & 0xff));
      case 0x00bb: return((CHAR)(200 & 0xff));
      case 0x00bf: return((CHAR)(192 & 0xff));
      case 0x00c0: return((CHAR)(203 & 0xff));
      case 0x00c1: return((CHAR)(231 & 0xff));
      case 0x00c2: return((CHAR)(229 & 0xff));
      case 0x00c3: return((CHAR)(204 & 0xff));
      case 0x00c4: return((CHAR)(128 & 0xff));
      case 0x00c5: return((CHAR)(129 & 0xff));
      case 0x00c6: return((CHAR)(174 & 0xff));
      case 0x00c7: return((CHAR)(130 & 0xff));
      case 0x00c8: return((CHAR)(233 & 0xff));
      case 0x00c9: return((CHAR)(131 & 0xff));
      case 0x00ca: return((CHAR)(230 & 0xff));
      case 0x00cb: return((CHAR)(232 & 0xff));
      case 0x00cc: return((CHAR)(237 & 0xff));
      case 0x00cd: return((CHAR)(234 & 0xff));
      case 0x00ce: return((CHAR)(235 & 0xff));
      case 0x00cf: return((CHAR)(236 & 0xff));
      case 0x2039: return((CHAR)(220 & 0xff));
      case 0x00d1: return((CHAR)(132 & 0xff));
      case 0x00d2: return((CHAR)(241 & 0xff));
      case 0x00d3: return((CHAR)(238 & 0xff));
      case 0x00d4: return((CHAR)(239 & 0xff));
      case 0x00d5: return((CHAR)(205 & 0xff));
      case 0x00d6: return((CHAR)(133 & 0xff));
      case 0x00d8: return((CHAR)(175 & 0xff));
      case 0x00d9: return((CHAR)(244 & 0xff));
      case 0x00da: return((CHAR)(242 & 0xff));
      case 0x00db: return((CHAR)(243 & 0xff));
      case 0x00dc: return((CHAR)(134 & 0xff));
      case 0x2020: return((CHAR)(160 & 0xff));
      case 0xfb01: return((CHAR)(222 & 0xff));
      case 0x00df: return((CHAR)(167 & 0xff));
      case 0x00e0: return((CHAR)(136 & 0xff));
      case 0x00e1: return((CHAR)(135 & 0xff));
      case 0x00e2: return((CHAR)(137 & 0xff));
      case 0x00e3: return((CHAR)(139 & 0xff));
      case 0x00e4: return((CHAR)(138 & 0xff));
      case 0x00e5: return((CHAR)(140 & 0xff));
      case 0x00e6: return((CHAR)(190 & 0xff));
      case 0x00e7: return((CHAR)(141 & 0xff));
      case 0x00e8: return((CHAR)(143 & 0xff));
      case 0x00e9: return((CHAR)(142 & 0xff));
      case 0x00ea: return((CHAR)(144 & 0xff));
      case 0x00eb: return((CHAR)(145 & 0xff));
      case 0x00ec: return((CHAR)(147 & 0xff));
      case 0x00ed: return((CHAR)(146 & 0xff));
      case 0x00ee: return((CHAR)(148 & 0xff));
      case 0x00ef: return((CHAR)(149 & 0xff));
      case 0x203a: return((CHAR)(221 & 0xff));
      case 0x00f1: return((CHAR)(150 & 0xff));
      case 0x00f2: return((CHAR)(152 & 0xff));
      case 0x00f3: return((CHAR)(151 & 0xff));
      case 0x00f4: return((CHAR)(153 & 0xff));
      case 0x00f5: return((CHAR)(155 & 0xff));
      case 0x00f6: return((CHAR)(154 & 0xff));
      case 0x00f7: return((CHAR)(214 & 0xff));
      case 0x00f8: return((CHAR)(191 & 0xff));
      case 0x00f9: return((CHAR)(157 & 0xff));
      case 0x00fa: return((CHAR)(156 & 0xff));
      case 0x00fb: return((CHAR)(158 & 0xff));
      case 0x00fc: return((CHAR)(159 & 0xff));
      case 0x2021: return((CHAR)(224 & 0xff));
      case 0xfb02: return((CHAR)(223 & 0xff));
      case 0x00ff: return((CHAR)(216 & 0xff));
      case 0x0131: return((CHAR)(245 & 0xff));
      case 0x0152: return((CHAR)(206 & 0xff));
      case 0x0153: return((CHAR)(207 & 0xff));
      case 0x0178: return((CHAR)(217 & 0xff));
      case 0x0192: return((CHAR)(196 & 0xff));
      case 0x02c6: return((CHAR)(246 & 0xff));
      case 0x02c7: return((CHAR)(255 & 0xff));
      case 0x02d8: return((CHAR)(249 & 0xff));
      case 0x02d9: return((CHAR)(250 & 0xff));
      case 0x02da: return((CHAR)(251 & 0xff));
      case 0x02db: return((CHAR)(254 & 0xff));
      case 0x02dc: return((CHAR)(247 & 0xff));
      case 0x02dd: return((CHAR)(253 & 0xff));
      case 0x03c0: return((CHAR)(185 & 0xff));
      case 0x2013: return((CHAR)(208 & 0xff));
      case 0x2014: return((CHAR)(209 & 0xff));
      case 0x2018: return((CHAR)(212 & 0xff));
      case 0x2019: return((CHAR)(213 & 0xff));
      case 0x201a: return((CHAR)(226 & 0xff));
      case 0x201c: return((CHAR)(210 & 0xff));
      case 0x201d: return((CHAR)(211 & 0xff));
      case 0x201e: return((CHAR)(227 & 0xff));
      case 0x2022: return((CHAR)(165 & 0xff));
      case 0x2026: return((CHAR)(201 & 0xff));
      case 0x2030: return((CHAR)(228 & 0xff));
      case 0x2044: return((CHAR)(218 & 0xff));
      case 0x2122: return((CHAR)(170 & 0xff));
      case 0x03a9: return((CHAR)(189 & 0xff));
      case 0x2202: return((CHAR)(182 & 0xff));
      case 0x2206: return((CHAR)(198 & 0xff));
      case 0x220f: return((CHAR)(184 & 0xff));
      case 0x2211: return((CHAR)(183 & 0xff));
      case 0x221a: return((CHAR)(195 & 0xff));
      case 0x221e: return((CHAR)(176 & 0xff));
      case 0x222b: return((CHAR)(186 & 0xff));
      case 0x2248: return((CHAR)(197 & 0xff));
      case 0x2260: return((CHAR)(173 & 0xff));
      case 0x2264: return((CHAR)(178 & 0xff));
      case 0x2265: return((CHAR)(179 & 0xff));
      case 0x25ca: return((CHAR)(215 & 0xff));
      case 0xf8ff: return((CHAR)(240 & 0xff));
      default: return(tx_punc(c));
    }
}

int					/* HP Roman-8 */
#ifdef CK_ANSIC
tx_hproman8(USHORT c)
#else
tx_hproman8(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xa0)
      return((CHAR)(c & 0xff));
    switch(c) {
      case 0x00a0: return((CHAR)(160 & 0xff));
      case 0x00a1: return((CHAR)(171 & 0xff));
      case 0x00a2: return((CHAR)(167 & 0xff));
      case 0x00a3: return((CHAR)(168 & 0xff));
      case 0x00a4: return((CHAR)(166 & 0xff));
      case 0x00a5: return((CHAR)(181 & 0xff));
      case 0x00a7: return((CHAR)(187 & 0xff));
      case 0x00a8: return((CHAR)(189 & 0xff));
      case 0x00a9: return((CHAR)(173 & 0xff));
      case 0x00aa: return((CHAR)(169 & 0xff));
      case 0x00ab: return((CHAR)(177 & 0xff));
      case 0x00ac: return((CHAR)(161 & 0xff));
      case 0x00ae: return((CHAR)(174 & 0xff));
      case 0x00b0: return((CHAR)(188 & 0xff));
      case 0x00b1: return((CHAR)(182 & 0xff));
      case 0x00b2: return((CHAR)(164 & 0xff));
      case 0x00b3: return((CHAR)(165 & 0xff));
      case 0x00b4: return((CHAR)(190 & 0xff));
      case 0x00b5: return((CHAR)(163 & 0xff));
      case 0x00b6: return((CHAR)(178 & 0xff));
      case 0x00b7: return((CHAR)(185 & 0xff));
      case 0x00b8: return((CHAR)(186 & 0xff));
      case 0x00ba: return((CHAR)(170 & 0xff));
      case 0x00bb: return((CHAR)(176 & 0xff));
      case 0x00bd: return((CHAR)(162 & 0xff));
      case 0x00bf: return((CHAR)(172 & 0xff));
      case 0x00c0: return((CHAR)(193 & 0xff));
      case 0x00c1: return((CHAR)(192 & 0xff));
      case 0x00c2: return((CHAR)(194 & 0xff));
      case 0x00c3: return((CHAR)(196 & 0xff));
      case 0x00c4: return((CHAR)(195 & 0xff));
      case 0x00c5: return((CHAR)(197 & 0xff));
      case 0x00c6: return((CHAR)(198 & 0xff));
      case 0x00c7: return((CHAR)(199 & 0xff));
      case 0x00c8: return((CHAR)(201 & 0xff));
      case 0x00c9: return((CHAR)(200 & 0xff));
      case 0x00ca: return((CHAR)(202 & 0xff));
      case 0x00cb: return((CHAR)(203 & 0xff));
      case 0x00cc: return((CHAR)(205 & 0xff));
      case 0x00cd: return((CHAR)(204 & 0xff));
      case 0x00ce: return((CHAR)(206 & 0xff));
      case 0x00cf: return((CHAR)(207 & 0xff));
      case 0x00d1: return((CHAR)(208 & 0xff));
      case 0x00d2: return((CHAR)(210 & 0xff));
      case 0x00d3: return((CHAR)(209 & 0xff));
      case 0x00d4: return((CHAR)(211 & 0xff));
      case 0x00d5: return((CHAR)(213 & 0xff));
      case 0x00d6: return((CHAR)(212 & 0xff));
      case 0x00d8: return((CHAR)(214 & 0xff));
      case 0x00d9: return((CHAR)(217 & 0xff));
      case 0x00da: return((CHAR)(216 & 0xff));
      case 0x00db: return((CHAR)(218 & 0xff));
      case 0x00dc: return((CHAR)(219 & 0xff));
      case 0x00df: return((CHAR)(252 & 0xff));
      case 0x00e0: return((CHAR)(225 & 0xff));
      case 0x00e1: return((CHAR)(224 & 0xff));
      case 0x00e2: return((CHAR)(226 & 0xff));
      case 0x00e3: return((CHAR)(228 & 0xff));
      case 0x00e4: return((CHAR)(227 & 0xff));
      case 0x00e5: return((CHAR)(229 & 0xff));
      case 0x00e6: return((CHAR)(230 & 0xff));
      case 0x00e7: return((CHAR)(231 & 0xff));
      case 0x00e8: return((CHAR)(233 & 0xff));
      case 0x00e9: return((CHAR)(232 & 0xff));
      case 0x00ea: return((CHAR)(234 & 0xff));
      case 0x00eb: return((CHAR)(235 & 0xff));
      case 0x00ec: return((CHAR)(237 & 0xff));
      case 0x00ed: return((CHAR)(236 & 0xff));
      case 0x00ee: return((CHAR)(238 & 0xff));
      case 0x00ef: return((CHAR)(239 & 0xff));
      case 0x00f1: return((CHAR)(240 & 0xff));
      case 0x00f2: return((CHAR)(242 & 0xff));
      case 0x00f3: return((CHAR)(241 & 0xff));
      case 0x00f4: return((CHAR)(243 & 0xff));
      case 0x00f5: return((CHAR)(245 & 0xff));
      case 0x00f6: return((CHAR)(244 & 0xff));
      case 0x00f8: return((CHAR)(246 & 0xff));
      case 0x00f9: return((CHAR)(249 & 0xff));
      case 0x00fa: return((CHAR)(248 & 0xff));
      case 0x00fb: return((CHAR)(250 & 0xff));
      case 0x00fc: return((CHAR)(251 & 0xff));
      case 0x00ff: return((CHAR)(253 & 0xff));
      case 0x0153: return((CHAR)(247 & 0xff));
      case 0x0178: return((CHAR)(221 & 0xff));
      case 0x0192: return((CHAR)(180 & 0xff));
      case 0x0276: return((CHAR)(215 & 0xff));
      case 0x2021: return((CHAR)(175 & 0xff));
      case 0x2122: return((CHAR)(179 & 0xff));
      case 0x2191: return((CHAR)(191 & 0xff));
      case 0x2264: return((CHAR)(183 & 0xff));
      case 0x2265: return((CHAR)(184 & 0xff));
      case 0x2588: return((CHAR)(255 & 0xff));
      default: return(tx_punc(c));
    }
}

int					/* PC Code Page 437 */
#ifdef CK_ANSIC
tx_cp437(USHORT c)
#else
tx_cp437(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x00a0: return((CHAR)(255 & 0xff));
      case 0x00a1: return((CHAR)(173 & 0xff));
      case 0x00a2: return((CHAR)(155 & 0xff));
      case 0x00a3: return((CHAR)(156 & 0xff));
      case 0x00a4: return((CHAR)(15 & 0xff));
      case 0x00a5: return((CHAR)(157 & 0xff));
      case 0x00a6: return((CHAR)(124 & 0xff));
      case 0x00a7: return((CHAR)(21 & 0xff));
      case 0x00a8: return((CHAR)(34 & 0xff));
      case 0x00a9: return((CHAR)(67 & 0xff));
      case 0x00aa: return((CHAR)(166 & 0xff));
      case 0x00ab: return((CHAR)(174 & 0xff));
      case 0x00ac: return((CHAR)(170 & 0xff));
      case 0x00ad: return((CHAR)(45 & 0xff));
      case 0x00ae: return((CHAR)(84 & 0xff));
      case 0x00af: return((CHAR)(22 & 0xff));
      case 0x00b0: return((CHAR)(248 & 0xff));
      case 0x00b1: return((CHAR)(241 & 0xff));
      case 0x00b2: return((CHAR)(253 & 0xff));
      case 0x00b3: return((CHAR)(51 & 0xff));
      case 0x00b4: return((CHAR)(39 & 0xff));
      case 0x00b5: return((CHAR)(230 & 0xff));
      case 0x00b6: return((CHAR)(20 & 0xff));
      case 0x00b7: return((CHAR)(250 & 0xff));
      case 0x00b8: return((CHAR)(44 & 0xff));
      case 0x00b9: return((CHAR)(49 & 0xff));
      case 0x00ba: return((CHAR)(167 & 0xff));
      case 0x00bb: return((CHAR)(175 & 0xff));
      case 0x00bc: return((CHAR)(172 & 0xff));
      case 0x00bd: return((CHAR)(171 & 0xff));
      case 0x00be: return((CHAR)(19 & 0xff));
      case 0x00bf: return((CHAR)(168 & 0xff));
      case 0x00c0: return((CHAR)(65 & 0xff));
      case 0x00c1: return((CHAR)(65 & 0xff));
      case 0x00c2: return((CHAR)(65 & 0xff));
      case 0x00c3: return((CHAR)(65 & 0xff));
      case 0x00c4: return((CHAR)(142 & 0xff));
      case 0x00c5: return((CHAR)(143 & 0xff));
      case 0x00c6: return((CHAR)(146 & 0xff));
      case 0x00c7: return((CHAR)(128 & 0xff));
      case 0x00c8: return((CHAR)(69 & 0xff));
      case 0x00c9: return((CHAR)(144 & 0xff));
      case 0x00ca: return((CHAR)(69 & 0xff));
      case 0x00cb: return((CHAR)(69 & 0xff));
      case 0x00cc: return((CHAR)(73 & 0xff));
      case 0x00cd: return((CHAR)(73 & 0xff));
      case 0x00ce: return((CHAR)(73 & 0xff));
      case 0x00cf: return((CHAR)(73 & 0xff));
      case 0x00d0: return((CHAR)(19 & 0xff));
      case 0x00d1: return((CHAR)(165 & 0xff));
      case 0x00d2: return((CHAR)(79 & 0xff));
      case 0x00d3: return((CHAR)(79 & 0xff));
      case 0x00d4: return((CHAR)(79 & 0xff));
      case 0x00d5: return((CHAR)(79 & 0xff));
      case 0x00d6: return((CHAR)(153 & 0xff));
      case 0x00d7: return((CHAR)(120 & 0xff));
      case 0x00d8: return((CHAR)(79 & 0xff));
      case 0x00d9: return((CHAR)(85 & 0xff));
      case 0x00da: return((CHAR)(85 & 0xff));
      case 0x00db: return((CHAR)(85 & 0xff));
      case 0x00dc: return((CHAR)(154 & 0xff));
      case 0x00dd: return((CHAR)(89 & 0xff));
      case 0x00de: return((CHAR)(19 & 0xff));
      case 0x00df: return((CHAR)(225 & 0xff));
      case 0x00e0: return((CHAR)(133 & 0xff));
      case 0x00e1: return((CHAR)(160 & 0xff));
      case 0x00e2: return((CHAR)(131 & 0xff));
      case 0x00e3: return((CHAR)(97 & 0xff)); /* a-tilde -> a (not 101 = e) */
      case 0x00e4: return((CHAR)(132 & 0xff));
      case 0x00e5: return((CHAR)(134 & 0xff));
      case 0x00e6: return((CHAR)(145 & 0xff));
      case 0x00e7: return((CHAR)(135 & 0xff));
      case 0x00e8: return((CHAR)(138 & 0xff));
      case 0x00e9: return((CHAR)(130 & 0xff));
      case 0x00ea: return((CHAR)(136 & 0xff));
      case 0x00eb: return((CHAR)(137 & 0xff));
      case 0x00ec: return((CHAR)(141 & 0xff));
      case 0x00ed: return((CHAR)(161 & 0xff));
      case 0x00ee: return((CHAR)(140 & 0xff));
      case 0x00ef: return((CHAR)(139 & 0xff));
      case 0x00f0: return((CHAR)(19 & 0xff));
      case 0x00f1: return((CHAR)(164 & 0xff));
      case 0x00f2: return((CHAR)(149 & 0xff));
      case 0x00f3: return((CHAR)(162 & 0xff));
      case 0x00f4: return((CHAR)(147 & 0xff));
      case 0x00f5: return((CHAR)(111 & 0xff));
      case 0x00f6: return((CHAR)(148 & 0xff));
      case 0x00f7: return((CHAR)(246 & 0xff));
      case 0x00f8: return((CHAR)(111 & 0xff));
      case 0x00f9: return((CHAR)(151 & 0xff));
      case 0x00fa: return((CHAR)(163 & 0xff));
      case 0x00fb: return((CHAR)(150 & 0xff));
      case 0x00fc: return((CHAR)(129 & 0xff));
      case 0x00fd: return((CHAR)(121 & 0xff));
      case 0x00fe: return((CHAR)(19 & 0xff));
      case 0x00ff: return((CHAR)(152 & 0xff));
      case 0x0192: return((CHAR)(159 & 0xff));
      case 0x0393: return((CHAR)(226 & 0xff));
      case 0x0398: return((CHAR)(233 & 0xff));
      case 0x03a3: return((CHAR)(228 & 0xff));
      case 0x03a6: return((CHAR)(232 & 0xff));
      case 0x03a9: return((CHAR)(234 & 0xff));
      case 0x03b1: return((CHAR)(224 & 0xff));
      case 0x03b4: return((CHAR)(235 & 0xff));
      case 0x03b5: return((CHAR)(238 & 0xff));
      case 0x03c0: return((CHAR)(227 & 0xff));
      case 0x03c3: return((CHAR)(229 & 0xff));
      case 0x03c4: return((CHAR)(231 & 0xff));
      case 0x03c6: return((CHAR)(237 & 0xff));
      case 0x207f: return((CHAR)(252 & 0xff));
      case 0x20a7: return((CHAR)(158 & 0xff));
      case 0x2219: return((CHAR)(249 & 0xff));
      case 0x221a: return((CHAR)(251 & 0xff));
      case 0x221e: return((CHAR)(236 & 0xff));
      case 0x2229: return((CHAR)(239 & 0xff));
      case 0x2248: return((CHAR)(247 & 0xff));
      case 0x2261: return((CHAR)(240 & 0xff));
      case 0x2264: return((CHAR)(243 & 0xff));
      case 0x2265: return((CHAR)(242 & 0xff));
      case 0x2310: return((CHAR)(169 & 0xff));
      case 0x2320: return((CHAR)(244 & 0xff));
      case 0x2321: return((CHAR)(245 & 0xff));
      case 0x2500: return((CHAR)(196 & 0xff));
      case 0x2502: return((CHAR)(179 & 0xff));
      case 0x250c: return((CHAR)(218 & 0xff));
      case 0x2510: return((CHAR)(191 & 0xff));
      case 0x2514: return((CHAR)(192 & 0xff));
      case 0x2518: return((CHAR)(217 & 0xff));
      case 0x251c: return((CHAR)(195 & 0xff));
      case 0x2524: return((CHAR)(180 & 0xff));
      case 0x252c: return((CHAR)(194 & 0xff));
      case 0x2534: return((CHAR)(193 & 0xff));
      case 0x253c: return((CHAR)(197 & 0xff));
      case 0x2550: return((CHAR)(205 & 0xff));
      case 0x2551: return((CHAR)(186 & 0xff));
      case 0x2552: return((CHAR)(213 & 0xff));
      case 0x2553: return((CHAR)(214 & 0xff));
      case 0x2554: return((CHAR)(201 & 0xff));
      case 0x2555: return((CHAR)(184 & 0xff));
      case 0x2556: return((CHAR)(183 & 0xff));
      case 0x2557: return((CHAR)(187 & 0xff));
      case 0x2558: return((CHAR)(212 & 0xff));
      case 0x2559: return((CHAR)(211 & 0xff));
      case 0x255a: return((CHAR)(200 & 0xff));
      case 0x255b: return((CHAR)(190 & 0xff));
      case 0x255c: return((CHAR)(189 & 0xff));
      case 0x255d: return((CHAR)(188 & 0xff));
      case 0x255e: return((CHAR)(198 & 0xff));
      case 0x255f: return((CHAR)(199 & 0xff));
      case 0x2560: return((CHAR)(204 & 0xff));
      case 0x2561: return((CHAR)(181 & 0xff));
      case 0x2562: return((CHAR)(182 & 0xff));
      case 0x2563: return((CHAR)(185 & 0xff));
      case 0x2564: return((CHAR)(209 & 0xff));
      case 0x2565: return((CHAR)(210 & 0xff));
      case 0x2566: return((CHAR)(203 & 0xff));
      case 0x2567: return((CHAR)(207 & 0xff));
      case 0x2568: return((CHAR)(208 & 0xff));
      case 0x2569: return((CHAR)(202 & 0xff));
      case 0x256a: return((CHAR)(216 & 0xff));
      case 0x256b: return((CHAR)(215 & 0xff));
      case 0x256c: return((CHAR)(206 & 0xff));
      case 0x2580: return((CHAR)(223 & 0xff));
      case 0x2584: return((CHAR)(220 & 0xff));
      case 0x2588: return((CHAR)(219 & 0xff));
      case 0x258c: return((CHAR)(221 & 0xff));
      case 0x2590: return((CHAR)(222 & 0xff));
      case 0x2591: return((CHAR)(176 & 0xff));
      case 0x2592: return((CHAR)(177 & 0xff));
      case 0x2593: return((CHAR)(178 & 0xff));
      case 0x25a0: return((CHAR)(254 & 0xff)); /* Black square */
      default: return(tx_cpsub(c));	/* For box characters etc */
    }
}

int					/* Mazovia */
#ifdef CK_ANSIC
tx_mazovia(USHORT c)
#else
tx_mazovia(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x00d3: return((CHAR)0xa3 & 0xff);	/* O acute */
      case 0x00f3: return((CHAR)0xa2 & 0xff);	/* O acute */
      case 0x0104: return((CHAR)0x8f & 0xff);	/* A Ogonek */
      case 0x0105: return((CHAR)0x86 & 0xff);	/* a Ogonek */
      case 0x0106: return((CHAR)0x95 & 0xff);	/* C acute */
      case 0x0107: return((CHAR)0x8d & 0xff);	/* c acute */
      case 0x0118: return((CHAR)0x90 & 0xff);	/* E Ogonek */
      case 0x0119: return((CHAR)0x91 & 0xff);	/* E Ogonek */
      case 0x0141: return((CHAR)0x9c & 0xff);	/* L stroke */
      case 0x0142: return((CHAR)0x92 & 0xff);	/* L stroke */
      case 0x0143: return((CHAR)0xa5 & 0xff);	/* N acute */
      case 0x0144: return((CHAR)0xa4 & 0xff);	/* N acute */
      case 0x015a: return((CHAR)0x98 & 0xff);	/* S acute */
      case 0x015b: return((CHAR)0x9e & 0xff);	/* S acute */
      case 0x0179: return((CHAR)0xa0 & 0xff);	/* Z acute */
      case 0x017a: return((CHAR)0xa6 & 0xff);	/* Z acute */
      case 0x017b: return((CHAR)0xa1 & 0xff);	/* Z dot above */
      case 0x017c: return((CHAR)0xa7 & 0xff);	/* Z dot above */
      default: return(tx_cp437(c));
    }
}

int					/* PC Code Page 850 */
#ifdef CK_ANSIC
tx_cp850(USHORT c)
#else
tx_cp850(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x00a0: return((CHAR)(255 & 0xff));
      case 0x00a1: return((CHAR)(173 & 0xff));
      case 0x00a2: return((CHAR)(189 & 0xff));
      case 0x00a3: return((CHAR)(156 & 0xff));
      case 0x00a4: return((CHAR)(207 & 0xff));
      case 0x00a5: return((CHAR)(190 & 0xff));
      case 0x00a6: return((CHAR)(221 & 0xff));
      case 0x00a7: return((CHAR)(245 & 0xff));
      case 0x00a8: return((CHAR)(249 & 0xff));
      case 0x00a9: return((CHAR)(184 & 0xff));
      case 0x00aa: return((CHAR)(166 & 0xff));
      case 0x00ab: return((CHAR)(174 & 0xff));
      case 0x00ac: return((CHAR)(170 & 0xff));
      case 0x00ad: return((CHAR)(240 & 0xff));
      case 0x00ae: return((CHAR)(169 & 0xff));
      case 0x00af: return((CHAR)(238 & 0xff));
      case 0x00b0: return((CHAR)(248 & 0xff));
      case 0x00b1: return((CHAR)(241 & 0xff));
      case 0x00b2: return((CHAR)(253 & 0xff));
      case 0x00b3: return((CHAR)(252 & 0xff));
      case 0x00b4: return((CHAR)(239 & 0xff));
      case 0x00b5: return((CHAR)(230 & 0xff));
      case 0x00b6: return((CHAR)(244 & 0xff));
      case 0x00b7: return((CHAR)(250 & 0xff));
      case 0x00b8: return((CHAR)(247 & 0xff));
      case 0x00b9: return((CHAR)(251 & 0xff));
      case 0x00ba: return((CHAR)(167 & 0xff));
      case 0x00bb: return((CHAR)(175 & 0xff));
      case 0x00bc: return((CHAR)(172 & 0xff));
      case 0x00bd: return((CHAR)(171 & 0xff));
      case 0x00be: return((CHAR)(243 & 0xff));
      case 0x00bf: return((CHAR)(168 & 0xff));
      case 0x00c0: return((CHAR)(183 & 0xff));
      case 0x00c1: return((CHAR)(181 & 0xff));
      case 0x00c2: return((CHAR)(182 & 0xff));
      case 0x00c3: return((CHAR)(199 & 0xff));
      case 0x00c4: return((CHAR)(142 & 0xff));
      case 0x00c5: return((CHAR)(143 & 0xff));
      case 0x00c6: return((CHAR)(146 & 0xff));
      case 0x00c7: return((CHAR)(128 & 0xff));
      case 0x00c8: return((CHAR)(212 & 0xff));
      case 0x00c9: return((CHAR)(144 & 0xff));
      case 0x00ca: return((CHAR)(210 & 0xff));
      case 0x00cb: return((CHAR)(211 & 0xff));
      case 0x00cc: return((CHAR)(222 & 0xff));
      case 0x00cd: return((CHAR)(214 & 0xff));
      case 0x00ce: return((CHAR)(215 & 0xff));
      case 0x00cf: return((CHAR)(216 & 0xff));
      case 0x00d0: return((CHAR)(209 & 0xff));
      case 0x00d1: return((CHAR)(165 & 0xff));
      case 0x00d2: return((CHAR)(227 & 0xff));
      case 0x00d3: return((CHAR)(224 & 0xff));
      case 0x00d4: return((CHAR)(226 & 0xff));
      case 0x00d5: return((CHAR)(229 & 0xff));
      case 0x00d6: return((CHAR)(153 & 0xff));
      case 0x00d7: return((CHAR)(158 & 0xff));
      case 0x00d8: return((CHAR)(157 & 0xff));
      case 0x00d9: return((CHAR)(235 & 0xff));
      case 0x00da: return((CHAR)(233 & 0xff));
      case 0x00db: return((CHAR)(234 & 0xff));
      case 0x00dc: return((CHAR)(154 & 0xff));
      case 0x00dd: return((CHAR)(237 & 0xff));
      case 0x00de: return((CHAR)(232 & 0xff));
      case 0x00df: return((CHAR)(225 & 0xff));
      case 0x00e0: return((CHAR)(133 & 0xff));
      case 0x00e1: return((CHAR)(160 & 0xff));
      case 0x00e2: return((CHAR)(131 & 0xff));
      case 0x00e3: return((CHAR)(198 & 0xff));
      case 0x00e4: return((CHAR)(132 & 0xff));
      case 0x00e5: return((CHAR)(134 & 0xff));
      case 0x00e6: return((CHAR)(145 & 0xff));
      case 0x00e7: return((CHAR)(135 & 0xff));
      case 0x00e8: return((CHAR)(138 & 0xff));
      case 0x00e9: return((CHAR)(130 & 0xff));
      case 0x00ea: return((CHAR)(136 & 0xff));
      case 0x00eb: return((CHAR)(137 & 0xff));
      case 0x00ec: return((CHAR)(141 & 0xff));
      case 0x00ed: return((CHAR)(161 & 0xff));
      case 0x00ee: return((CHAR)(140 & 0xff));
      case 0x00ef: return((CHAR)(139 & 0xff));
      case 0x00f0: return((CHAR)(208 & 0xff));
      case 0x00f1: return((CHAR)(164 & 0xff));
      case 0x00f2: return((CHAR)(149 & 0xff));
      case 0x00f3: return((CHAR)(162 & 0xff));
      case 0x00f4: return((CHAR)(147 & 0xff));
      case 0x00f5: return((CHAR)(228 & 0xff));
      case 0x00f6: return((CHAR)(148 & 0xff));
      case 0x00f7: return((CHAR)(246 & 0xff));
      case 0x00f8: return((CHAR)(155 & 0xff));
      case 0x00f9: return((CHAR)(151 & 0xff));
      case 0x00fa: return((CHAR)(163 & 0xff));
      case 0x00fb: return((CHAR)(150 & 0xff));
      case 0x00fc: return((CHAR)(129 & 0xff));
      case 0x00fd: return((CHAR)(236 & 0xff));
      case 0x00fe: return((CHAR)(231 & 0xff));
      case 0x00ff: return((CHAR)(152 & 0xff));
      case 0x0131: return((CHAR)(213 & 0xff));
      case 0x0192: return((CHAR)(159 & 0xff));
      case 0x2017: return((CHAR)(242 & 0xff));
      case 0x2500: return((CHAR)(196 & 0xff));
      case 0x2502: return((CHAR)(179 & 0xff));
      case 0x250c: return((CHAR)(218 & 0xff));
      case 0x2510: return((CHAR)(191 & 0xff));
      case 0x2514: return((CHAR)(192 & 0xff));
      case 0x2518: return((CHAR)(217 & 0xff));
      case 0x251c: return((CHAR)(195 & 0xff));
      case 0x2524: return((CHAR)(180 & 0xff));
      case 0x252c: return((CHAR)(194 & 0xff));
      case 0x2534: return((CHAR)(193 & 0xff));
      case 0x253c: return((CHAR)(197 & 0xff));
      case 0x2550: return((CHAR)(205 & 0xff));
      case 0x2551: return((CHAR)(186 & 0xff));
      case 0x2554: return((CHAR)(201 & 0xff));
      case 0x2557: return((CHAR)(187 & 0xff));
      case 0x255a: return((CHAR)(200 & 0xff));
      case 0x255d: return((CHAR)(188 & 0xff));
      case 0x2560: return((CHAR)(204 & 0xff));
      case 0x2563: return((CHAR)(185 & 0xff));
      case 0x2566: return((CHAR)(203 & 0xff));
      case 0x2569: return((CHAR)(202 & 0xff));
      case 0x256c: return((CHAR)(206 & 0xff));
      case 0x2580: return((CHAR)(223 & 0xff));
      case 0x2584: return((CHAR)(220 & 0xff));
      case 0x2588: return((CHAR)(219 & 0xff));
      case 0x2591: return((CHAR)(176 & 0xff));
      case 0x2592: return((CHAR)(177 & 0xff));
      case 0x2593: return((CHAR)(178 & 0xff));
      case 0x25a0: return((CHAR)(254 & 0xff));
      default: return(tx_cpsub(c));	/* For box characters etc */
    }
}

int					/* PC Code Page 858 */
#ifdef CK_ANSIC
tx_cp858(USHORT c)
#else
tx_cp858(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x00a0: return((CHAR)(255 & 0xff));
      case 0x00a1: return((CHAR)(173 & 0xff));
      case 0x00a2: return((CHAR)(189 & 0xff));
      case 0x00a3: return((CHAR)(156 & 0xff));
      case 0x00a4: return((CHAR)(207 & 0xff));
      case 0x00a5: return((CHAR)(190 & 0xff));
      case 0x00a6: return((CHAR)(221 & 0xff));
      case 0x00a7: return((CHAR)(245 & 0xff));
      case 0x00a8: return((CHAR)(249 & 0xff));
      case 0x00a9: return((CHAR)(184 & 0xff));
      case 0x00aa: return((CHAR)(166 & 0xff));
      case 0x00ab: return((CHAR)(174 & 0xff));
      case 0x00ac: return((CHAR)(170 & 0xff));
      case 0x00ad: return((CHAR)(240 & 0xff));
      case 0x00ae: return((CHAR)(169 & 0xff));
      case 0x00af: return((CHAR)(238 & 0xff));
      case 0x00b0: return((CHAR)(248 & 0xff));
      case 0x00b1: return((CHAR)(241 & 0xff));
      case 0x00b2: return((CHAR)(253 & 0xff));
      case 0x00b3: return((CHAR)(252 & 0xff));
      case 0x00b4: return((CHAR)(239 & 0xff));
      case 0x00b5: return((CHAR)(230 & 0xff));
      case 0x00b6: return((CHAR)(244 & 0xff));
      case 0x00b7: return((CHAR)(250 & 0xff));
      case 0x00b8: return((CHAR)(247 & 0xff));
      case 0x00b9: return((CHAR)(251 & 0xff));
      case 0x00ba: return((CHAR)(167 & 0xff));
      case 0x00bb: return((CHAR)(175 & 0xff));
      case 0x00bc: return((CHAR)(172 & 0xff));
      case 0x00bd: return((CHAR)(171 & 0xff));
      case 0x00be: return((CHAR)(243 & 0xff));
      case 0x00bf: return((CHAR)(168 & 0xff));
      case 0x00c0: return((CHAR)(183 & 0xff));
      case 0x00c1: return((CHAR)(181 & 0xff));
      case 0x00c2: return((CHAR)(182 & 0xff));
      case 0x00c3: return((CHAR)(199 & 0xff));
      case 0x00c4: return((CHAR)(142 & 0xff));
      case 0x00c5: return((CHAR)(143 & 0xff));
      case 0x00c6: return((CHAR)(146 & 0xff));
      case 0x00c7: return((CHAR)(128 & 0xff));
      case 0x00c8: return((CHAR)(212 & 0xff));
      case 0x00c9: return((CHAR)(144 & 0xff));
      case 0x00ca: return((CHAR)(210 & 0xff));
      case 0x00cb: return((CHAR)(211 & 0xff));
      case 0x00cc: return((CHAR)(222 & 0xff));
      case 0x00cd: return((CHAR)(214 & 0xff));
      case 0x00ce: return((CHAR)(215 & 0xff));
      case 0x00cf: return((CHAR)(216 & 0xff));
      case 0x00d0: return((CHAR)(209 & 0xff));
      case 0x00d1: return((CHAR)(165 & 0xff));
      case 0x00d2: return((CHAR)(227 & 0xff));
      case 0x00d3: return((CHAR)(224 & 0xff));
      case 0x00d4: return((CHAR)(226 & 0xff));
      case 0x00d5: return((CHAR)(229 & 0xff));
      case 0x00d6: return((CHAR)(153 & 0xff));
      case 0x00d7: return((CHAR)(158 & 0xff));
      case 0x00d8: return((CHAR)(157 & 0xff));
      case 0x00d9: return((CHAR)(235 & 0xff));
      case 0x00da: return((CHAR)(233 & 0xff));
      case 0x00db: return((CHAR)(234 & 0xff));
      case 0x00dc: return((CHAR)(154 & 0xff));
      case 0x00dd: return((CHAR)(237 & 0xff));
      case 0x00de: return((CHAR)(232 & 0xff));
      case 0x00df: return((CHAR)(225 & 0xff));
      case 0x00e0: return((CHAR)(133 & 0xff));
      case 0x00e1: return((CHAR)(160 & 0xff));
      case 0x00e2: return((CHAR)(131 & 0xff));
      case 0x00e3: return((CHAR)(198 & 0xff));
      case 0x00e4: return((CHAR)(132 & 0xff));
      case 0x00e5: return((CHAR)(134 & 0xff));
      case 0x00e6: return((CHAR)(145 & 0xff));
      case 0x00e7: return((CHAR)(135 & 0xff));
      case 0x00e8: return((CHAR)(138 & 0xff));
      case 0x00e9: return((CHAR)(130 & 0xff));
      case 0x00ea: return((CHAR)(136 & 0xff));
      case 0x00eb: return((CHAR)(137 & 0xff));
      case 0x00ec: return((CHAR)(141 & 0xff));
      case 0x00ed: return((CHAR)(161 & 0xff));
      case 0x00ee: return((CHAR)(140 & 0xff));
      case 0x00ef: return((CHAR)(139 & 0xff));
      case 0x00f0: return((CHAR)(208 & 0xff));
      case 0x00f1: return((CHAR)(164 & 0xff));
      case 0x00f2: return((CHAR)(149 & 0xff));
      case 0x00f3: return((CHAR)(162 & 0xff));
      case 0x00f4: return((CHAR)(147 & 0xff));
      case 0x00f5: return((CHAR)(228 & 0xff));
      case 0x00f6: return((CHAR)(148 & 0xff));
      case 0x00f7: return((CHAR)(246 & 0xff));
      case 0x00f8: return((CHAR)(155 & 0xff));
      case 0x00f9: return((CHAR)(151 & 0xff));
      case 0x00fa: return((CHAR)(163 & 0xff));
      case 0x00fb: return((CHAR)(150 & 0xff));
      case 0x00fc: return((CHAR)(129 & 0xff));
      case 0x00fd: return((CHAR)(236 & 0xff));
      case 0x00fe: return((CHAR)(231 & 0xff));
      case 0x00ff: return((CHAR)(152 & 0xff));
      case 0x20ac: return((CHAR)(213 & 0xff));
      case 0x0192: return((CHAR)(159 & 0xff));
      case 0x2017: return((CHAR)(242 & 0xff));
      case 0x2500: return((CHAR)(196 & 0xff));
      case 0x2502: return((CHAR)(179 & 0xff));
      case 0x250c: return((CHAR)(218 & 0xff));
      case 0x2510: return((CHAR)(191 & 0xff));
      case 0x2514: return((CHAR)(192 & 0xff));
      case 0x2518: return((CHAR)(217 & 0xff));
      case 0x251c: return((CHAR)(195 & 0xff));
      case 0x2524: return((CHAR)(180 & 0xff));
      case 0x252c: return((CHAR)(194 & 0xff));
      case 0x2534: return((CHAR)(193 & 0xff));
      case 0x253c: return((CHAR)(197 & 0xff));
      case 0x2550: return((CHAR)(205 & 0xff));
      case 0x2551: return((CHAR)(186 & 0xff));
      case 0x2554: return((CHAR)(201 & 0xff));
      case 0x2557: return((CHAR)(187 & 0xff));
      case 0x255a: return((CHAR)(200 & 0xff));
      case 0x255d: return((CHAR)(188 & 0xff));
      case 0x2560: return((CHAR)(204 & 0xff));
      case 0x2563: return((CHAR)(185 & 0xff));
      case 0x2566: return((CHAR)(203 & 0xff));
      case 0x2569: return((CHAR)(202 & 0xff));
      case 0x256c: return((CHAR)(206 & 0xff));
      case 0x2580: return((CHAR)(223 & 0xff));
      case 0x2584: return((CHAR)(220 & 0xff));
      case 0x2588: return((CHAR)(219 & 0xff));
      case 0x2591: return((CHAR)(176 & 0xff));
      case 0x2592: return((CHAR)(177 & 0xff));
      case 0x2593: return((CHAR)(178 & 0xff));
      case 0x25a0: return((CHAR)(254 & 0xff));
      default: return(tx_cpsub(c));	/* For box characters etc */
    }
}

int					/* Windows Code Page 1250 (Latin-2) */
#ifdef CK_ANSIC
tx_cp1250(USHORT c)
#else
tx_cp1250(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80 || c > 0xbf && c <= 0xff) /* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x002D: return((CHAR)(0xad & 0xff));
      case 0x00A0: return((CHAR)(0xa0 & 0xff));
      case 0x00A4: return((CHAR)(0xa4 & 0xff));
      case 0x00A6: return((CHAR)(0xa6 & 0xff));
      case 0x00A7: return((CHAR)(0xa7 & 0xff));
      case 0x00A8: return((CHAR)(0xa8 & 0xff));
      case 0x00A9: return((CHAR)(0xa9 & 0xff));
      case 0x00AB: return((CHAR)(0xab & 0xff));
      case 0x00AC: return((CHAR)(0xac & 0xff));
      case 0x00AE: return((CHAR)(0xae & 0xff));
      case 0x00B0: return((CHAR)(0xb0 & 0xff));
      case 0x00B1: return((CHAR)(0xb1 & 0xff));
      case 0x00B4: return((CHAR)(0xb4 & 0xff));
      case 0x00B5: return((CHAR)(0xb5 & 0xff));
      case 0x00B6: return((CHAR)(0xb6 & 0xff));
      case 0x00B7: return((CHAR)(0xb7 & 0xff));
      case 0x00B8: return((CHAR)(0xb8 & 0xff));
      case 0x00BB: return((CHAR)(0xbb & 0xff));
      case 0x0104: return((CHAR)(0xa5 & 0xff));
      case 0x0105: return((CHAR)(0xb9 & 0xff));
      case 0x013D: return((CHAR)(0xbc & 0xff));
      case 0x013E: return((CHAR)(0xbe & 0xff));
      case 0x0141: return((CHAR)(0xa3 & 0xff));
      case 0x0142: return((CHAR)(0xb3 & 0xff));
      case 0x015A: return((CHAR)(0x8c & 0xff));	/* S acute */
      case 0x015E: return((CHAR)(0xaa & 0xff));
      case 0x015F: return((CHAR)(0xba & 0xff));
      case 0x015b: return((CHAR)(0x9c & 0xff)); /* s acute */
      case 0x0164: return((CHAR)(0x8d & 0xff));	/* T caron */
      case 0x0165: return((CHAR)(0x9d & 0xff));	/* t caron */
      case 0x0173: return((CHAR)(0x9e & 0xff));	/* z caron */
      case 0x0179: return((CHAR)(0x8f & 0xff));	/* Z acute */
      case 0x017A: return((CHAR)(0x9f & 0xff));	/* z acute */
      case 0x017B: return((CHAR)(0xaf & 0xff));
      case 0x017C: return((CHAR)(0xbf & 0xff));
      case 0x017D: return((CHAR)(0x8e & 0xff));	/* Z caron */
      case 0x02C7: return((CHAR)(0xa1 & 0xff));
      case 0x02D8: return((CHAR)(0xa2 & 0xff));
      case 0x02DB: return((CHAR)(0xb2 & 0xff));
      case 0x02DD: return((CHAR)(0xbd & 0xff));
      case 0x2010: case 0x2011:		/* Hyphens */
	return((CHAR)(0x2d & 0xff));
      case 0x2012: case 0x2013:		/* en-dashes */
	return((CHAR)(0x96 & 0xff));
      case 0x2014: case 0x2015:		/* em-dashes */
	return((CHAR)(0x97 & 0xff));
      case 0x2018:			/* Various quotation marks... */
	return((CHAR)(0x91 & 0xff));
      case 0x2019:
	return((CHAR)(0x92 & 0xff));
      case 0x201c:
	return((CHAR)(0x93 & 0xff));
      case 0x201d:
	return((CHAR)(0x94 & 0xff));
      case 0x201e:
	return((CHAR)(0x84 & 0xff));
      case 0x2020:			/* Dagger */
	return((CHAR)(0x86 & 0xff));
      case 0x2021:			/* Double Dagger */
	return((CHAR)(0x87 & 0xff));
      case 0x2022:			/* Bullet */
	return((CHAR)(0x95 & 0xff));
      case 0x2026:			/* Ellipsis */
	return((CHAR)(0x85 & 0xff));
      case 0x2030:			/* Per mil */
	return((CHAR)(0x89 & 0xff));
      case 0x20AC:			/* Euro */
          return((CHAR)(0x80 & 0xff));
      case 0x2122:			/* Trade Mark */
	return((CHAR)(0x99 & 0xff));
      default: return(0x003f);
    }
}

int					/* Windows Code Page 1251 (Cyrillic) */
#ifdef CK_ANSIC
tx_cp1251(USHORT c)
#else
tx_cp1251(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    /* This is simply the inverse of u_cp1251.map */
    switch (c) {
      case 0x003c: return((CHAR)(0x8b & 0xff));
      case 0x003e: return((CHAR)(0x9b & 0xff));
      case 0x007e: return((CHAR)(0x98 & 0xff));
      case 0x00A0: return((CHAR)(0xa0 & 0xff));
      case 0x00A4: return((CHAR)(0xa4 & 0xff));
      case 0x00A6: return((CHAR)(0xa6 & 0xff));
      case 0x00A7: return((CHAR)(0xa7 & 0xff));
      case 0x00A9: return((CHAR)(0xa9 & 0xff));
      case 0x00AB: return((CHAR)(0xab & 0xff));
      case 0x00AC: return((CHAR)(0xac & 0xff));
      case 0x00AD: return((CHAR)(0xad & 0xff));
      case 0x00AE: return((CHAR)(0xae & 0xff));
      case 0x00b0: return((CHAR)(0xb0 & 0xff));
      case 0x00b1: return((CHAR)(0xb1 & 0xff));
      case 0x00B5: return((CHAR)(0xb5 & 0xff));
      case 0x00B6: return((CHAR)(0xb6 & 0xff));
      case 0x00B7: return((CHAR)(0xb7 & 0xff));
      case 0x00BB: return((CHAR)(0xbb & 0xff));
      case 0x0401: return((CHAR)(0xa8 & 0xff));
      case 0x0402: return((CHAR)(0x80 & 0xff));
      case 0x0403: return((CHAR)(0x81 & 0xff));
      case 0x0404: return((CHAR)(0xaa & 0xff));
      case 0x0405: return((CHAR)(0xbd & 0xff));
      case 0x0406: return((CHAR)(0xb2 & 0xff));
      case 0x0407: return((CHAR)(0xaf & 0xff));
      case 0x0408: return((CHAR)(0xa3 & 0xff));
      case 0x0409: return((CHAR)(0x8a & 0xff));
      case 0x040a: return((CHAR)(0x8c & 0xff));
      case 0x040b: return((CHAR)(0x8e & 0xff));
      case 0x040c: return((CHAR)(0x8d & 0xff));
      case 0x040e: return((CHAR)(0xa1 & 0xff));
      case 0x040f: return((CHAR)(0x8f & 0xff));
      case 0x0410: return((CHAR)(0xc0 & 0xff));
      case 0x0411: return((CHAR)(0xc1 & 0xff));
      case 0x0412: return((CHAR)(0xc2 & 0xff));
      case 0x0413: return((CHAR)(0xc3 & 0xff));
      case 0x0414: return((CHAR)(0xc4 & 0xff));
      case 0x0415: return((CHAR)(0xc5 & 0xff));
      case 0x0416: return((CHAR)(0xc6 & 0xff));
      case 0x0417: return((CHAR)(0xc7 & 0xff));
      case 0x0418: return((CHAR)(0xc8 & 0xff));
      case 0x0419: return((CHAR)(0xc9 & 0xff));
      case 0x041a: return((CHAR)(0xca & 0xff));
      case 0x041b: return((CHAR)(0xcb & 0xff));
      case 0x041c: return((CHAR)(0xcc & 0xff));
      case 0x041d: return((CHAR)(0xcd & 0xff));
      case 0x041e: return((CHAR)(0xce & 0xff));
      case 0x041f: return((CHAR)(0xcf & 0xff));
      case 0x0420: return((CHAR)(0xd0 & 0xff));
      case 0x0421: return((CHAR)(0xd1 & 0xff));
      case 0x0422: return((CHAR)(0xd2 & 0xff));
      case 0x0423: return((CHAR)(0xd3 & 0xff));
      case 0x0424: return((CHAR)(0xd4 & 0xff));
      case 0x0425: return((CHAR)(0xd5 & 0xff));
      case 0x0426: return((CHAR)(0xd6 & 0xff));
      case 0x0427: return((CHAR)(0xd7 & 0xff));
      case 0x0428: return((CHAR)(0xd8 & 0xff));
      case 0x0429: return((CHAR)(0xd9 & 0xff));
      case 0x042a: return((CHAR)(0xda & 0xff));
      case 0x042b: return((CHAR)(0xdb & 0xff));
      case 0x042c: return((CHAR)(0xdc & 0xff));
      case 0x042d: return((CHAR)(0xdd & 0xff));
      case 0x042e: return((CHAR)(0xde & 0xff));
      case 0x042f: return((CHAR)(0xdf & 0xff));
      case 0x0430: return((CHAR)(0xe0 & 0xff));
      case 0x0431: return((CHAR)(0xe1 & 0xff));
      case 0x0432: return((CHAR)(0xe2 & 0xff));
      case 0x0433: return((CHAR)(0xe3 & 0xff));
      case 0x0434: return((CHAR)(0xe4 & 0xff));
      case 0x0435: return((CHAR)(0xe5 & 0xff));
      case 0x0436: return((CHAR)(0xe6 & 0xff));
      case 0x0437: return((CHAR)(0xe7 & 0xff));
      case 0x0438: return((CHAR)(0xe8 & 0xff));
      case 0x0439: return((CHAR)(0xe9 & 0xff));
      case 0x043a: return((CHAR)(0xea & 0xff));
      case 0x043b: return((CHAR)(0xeb & 0xff));
      case 0x043c: return((CHAR)(0xec & 0xff));
      case 0x043d: return((CHAR)(0xed & 0xff));
      case 0x043e: return((CHAR)(0xee & 0xff));
      case 0x043f: return((CHAR)(0xef & 0xff));
      case 0x0440: return((CHAR)(0xf0 & 0xff));
      case 0x0441: return((CHAR)(0xf1 & 0xff));
      case 0x0442: return((CHAR)(0xf2 & 0xff));
      case 0x0443: return((CHAR)(0xf3 & 0xff));
      case 0x0444: return((CHAR)(0xf4 & 0xff));
      case 0x0445: return((CHAR)(0xf5 & 0xff));
      case 0x0446: return((CHAR)(0xf6 & 0xff));
      case 0x0447: return((CHAR)(0xf7 & 0xff));
      case 0x0448: return((CHAR)(0xf8 & 0xff));
      case 0x0449: return((CHAR)(0xf9 & 0xff));
      case 0x044a: return((CHAR)(0xfa & 0xff));
      case 0x044b: return((CHAR)(0xfb & 0xff));
      case 0x044c: return((CHAR)(0xfc & 0xff));
      case 0x044d: return((CHAR)(0xfd & 0xff));
      case 0x044e: return((CHAR)(0xfe & 0xff));
      case 0x044f: return((CHAR)(0xff & 0xff));
      case 0x0451: return((CHAR)(0xb8 & 0xff));
      case 0x0452: return((CHAR)(0x90 & 0xff));
      case 0x0453: return((CHAR)(0x83 & 0xff));
      case 0x0454: return((CHAR)(0xba & 0xff));
      case 0x0455: return((CHAR)(0xbe & 0xff));
      case 0x0456: return((CHAR)(0xb3 & 0xff));
      case 0x0457: return((CHAR)(0xbf & 0xff));
      case 0x0458: return((CHAR)(0xbc & 0xff));
      case 0x0459: return((CHAR)(0x9a & 0xff));
      case 0x045a: return((CHAR)(0x9c & 0xff));
      case 0x045b: return((CHAR)(0x9e & 0xff));
      case 0x045c: return((CHAR)(0x9d & 0xff));
      case 0x045e: return((CHAR)(0xa2 & 0xff));
      case 0x045f: return((CHAR)(0x9f & 0xff));
      case 0x0490: return((CHAR)(0xa5 & 0xff));
      case 0x0491: return((CHAR)(0xb4 & 0xff));
      case 0x2012: return((CHAR)(0x96 & 0xff));
      case 0x2014: return((CHAR)(0x97 & 0xff));
      case 0x2018: return((CHAR)(0x91 & 0xff));
      case 0x2019: return((CHAR)(0x92 & 0xff));
      case 0x201a: return((CHAR)(0x82 & 0xff));
      case 0x201c: return((CHAR)(0x93 & 0xff));
      case 0x201d: return((CHAR)(0x94 & 0xff));
      case 0x201e: return((CHAR)(0x84 & 0xff));
      case 0x2020: return((CHAR)(0x86 & 0xff));
      case 0x2021: return((CHAR)(0x87 & 0xff));
      case 0x2022: return((CHAR)(0x95 & 0xff));
      case 0x2026: return((CHAR)(0x85 & 0xff));
      case 0x2031: return((CHAR)(0x89 & 0xff));
      case 0x20AC:			/* Euro */
          return((CHAR)(0x88 & 0xff));
      case 0x2116: return((CHAR)(0xb9 & 0xff));
      case 0x2122: return((CHAR)(0x99 & 0xff));
      default: return(0x003f);
    }
}

int /* Unicode to Windows Code Page 1252 (Latin-1) */
#ifdef CK_ANSIC
tx_cp1252(USHORT c)
#else
tx_cp1252(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80 || c > 0x9f && c <= 0xff) /* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x0152:			/* OE */
	return((CHAR)(0x8c & 0xff));
      case 0x0153:			/* oe */
	return((CHAR)(0x9c & 0xff));
      case 0x0160:			/* S caron */
	return((CHAR)(0x8a & 0xff));
      case 0x0161:			/* s caron */
	return((CHAR)(0x9a & 0xff));
      case 0x0178:			/* Y diaeresis */
	return((CHAR)(0x9f & 0xff));
      case 0x017D:			/* Z caron */
	return((CHAR)(0x8e & 0xff));
      case 0x017E:			/* z caron */
	return((CHAR)(0x9e & 0xff));
      case 0x0192:			/* Florin */
	return((CHAR)(0x83 & 0xff));
      case 0x2010: case 0x2011:		/* Hyphens */
	return((CHAR)(0x2d & 0xff));
      case 0x2012: case 0x2013:		/* en-dashes */
	return((CHAR)(0x96 & 0xff));
      case 0x2014: case 0x2015:		/* em-dashes */
	return((CHAR)(0x97 & 0xff));
      case 0x2018:			/* Various quotation marks... */
	return((CHAR)(0x91 & 0xff));
      case 0x2019:
 	return((CHAR)(0x92 & 0xff));
      case 0x201c:
 	return((CHAR)(0x93 & 0xff));
      case 0x201d:
 	return((CHAR)(0x94 & 0xff));
      case 0x201e:
 	return((CHAR)(0x84 & 0xff));
      case 0x2020:			/* Dagger */
	return((CHAR)(0x86 & 0xff));
      case 0x2021:			/* Double Dagger */
	return((CHAR)(0x87 & 0xff));
      case 0x2022:			/* Bullet */
	return((CHAR)(0x95 & 0xff));
      case 0x2026:			/* Ellipsis */
	return((CHAR)(0x85 & 0xff));
      case 0x2030:			/* Per mil */
	return((CHAR)(0x89 & 0xff));
      case 0x20AC:			/* Euro */
          return((CHAR)(0x80 & 0xff));
      case 0x2122:			/* Trade Mark */
	return((CHAR)(0x99 & 0xff));
      default: return(0x003f);
    }
}

int					/* PC Code Page 852 */
#ifdef CK_ANSIC
tx_cp852(USHORT c)
#else
tx_cp852(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x00a0: return((CHAR)(255 & 0xff));
      case 0x00a4: return((CHAR)(207 & 0xff));
      case 0x00a7: return((CHAR)(245 & 0xff));
      case 0x00a8: return((CHAR)(249 & 0xff));
      case 0x00ab: return((CHAR)(174 & 0xff));
      case 0x00ac: return((CHAR)(170 & 0xff));
      case 0x00ad: return((CHAR)(240 & 0xff));
      case 0x00b0: return((CHAR)(248 & 0xff));
      case 0x00b4: return((CHAR)(239 & 0xff));
      case 0x00b8: return((CHAR)(247 & 0xff));
      case 0x00bb: return((CHAR)(175 & 0xff));
      case 0x00c1: return((CHAR)(181 & 0xff));
      case 0x00c2: return((CHAR)(182 & 0xff));
      case 0x00c4: return((CHAR)(142 & 0xff));
      case 0x00c7: return((CHAR)(128 & 0xff));
      case 0x00c9: return((CHAR)(144 & 0xff));
      case 0x00cb: return((CHAR)(211 & 0xff));
      case 0x00cd: return((CHAR)(214 & 0xff));
      case 0x00ce: return((CHAR)(215 & 0xff));
      case 0x00d3: return((CHAR)(224 & 0xff));
      case 0x00d4: return((CHAR)(226 & 0xff));
      case 0x00d6: return((CHAR)(153 & 0xff));
      case 0x00d7: return((CHAR)(158 & 0xff));
      case 0x00da: return((CHAR)(233 & 0xff));
      case 0x00dc: return((CHAR)(154 & 0xff));
      case 0x00dd: return((CHAR)(237 & 0xff));
      case 0x00df: return((CHAR)(225 & 0xff));
      case 0x00e1: return((CHAR)(160 & 0xff));
      case 0x00e2: return((CHAR)(131 & 0xff));
      case 0x00e4: return((CHAR)(132 & 0xff));
      case 0x00e7: return((CHAR)(135 & 0xff));
      case 0x00e9: return((CHAR)(130 & 0xff));
      case 0x00eb: return((CHAR)(137 & 0xff));
      case 0x00ed: return((CHAR)(161 & 0xff));
      case 0x00ee: return((CHAR)(140 & 0xff));
      case 0x00f3: return((CHAR)(162 & 0xff));
      case 0x00f4: return((CHAR)(147 & 0xff));
      case 0x00f6: return((CHAR)(148 & 0xff));
      case 0x00f7: return((CHAR)(246 & 0xff));
      case 0x00fa: return((CHAR)(163 & 0xff));
      case 0x00fc: return((CHAR)(129 & 0xff));
      case 0x00fd: return((CHAR)(236 & 0xff));
      case 0x0102: return((CHAR)(198 & 0xff));
      case 0x0103: return((CHAR)(199 & 0xff));
      case 0x0104: return((CHAR)(164 & 0xff));
      case 0x0105: return((CHAR)(165 & 0xff));
      case 0x0106: return((CHAR)(143 & 0xff));
      case 0x0107: return((CHAR)(134 & 0xff));
      case 0x010c: return((CHAR)(172 & 0xff));
      case 0x010d: return((CHAR)(159 & 0xff));
      case 0x010e: return((CHAR)(210 & 0xff));
      case 0x010f: return((CHAR)(212 & 0xff));
      case 0x0110: return((CHAR)(209 & 0xff));
      case 0x0111: return((CHAR)(208 & 0xff));
      case 0x0118: return((CHAR)(168 & 0xff));
      case 0x0119: return((CHAR)(169 & 0xff));
      case 0x011a: return((CHAR)(183 & 0xff));
      case 0x011b: return((CHAR)(216 & 0xff));
      case 0x0139: return((CHAR)(145 & 0xff));
      case 0x013a: return((CHAR)(146 & 0xff));
      case 0x013d: return((CHAR)(149 & 0xff));
      case 0x013e: return((CHAR)(150 & 0xff));
      case 0x0141: return((CHAR)(157 & 0xff));
      case 0x0142: return((CHAR)(136 & 0xff));
      case 0x0143: return((CHAR)(227 & 0xff));
      case 0x0144: return((CHAR)(228 & 0xff));
      case 0x0147: return((CHAR)(213 & 0xff));
      case 0x0148: return((CHAR)(229 & 0xff));
      case 0x0150: return((CHAR)(138 & 0xff));
      case 0x0151: return((CHAR)(139 & 0xff));
      case 0x0154: return((CHAR)(232 & 0xff));
      case 0x0155: return((CHAR)(234 & 0xff));
      case 0x0158: return((CHAR)(252 & 0xff));
      case 0x0159: return((CHAR)(253 & 0xff));
      case 0x015a: return((CHAR)(151 & 0xff));
      case 0x015b: return((CHAR)(152 & 0xff));
      case 0x015e: return((CHAR)(184 & 0xff));
      case 0x015f: return((CHAR)(173 & 0xff));
      case 0x0160: return((CHAR)(230 & 0xff));
      case 0x0161: return((CHAR)(231 & 0xff));
      case 0x0162: return((CHAR)(221 & 0xff));
      case 0x0163: return((CHAR)(238 & 0xff));
      case 0x0164: return((CHAR)(155 & 0xff));
      case 0x0165: return((CHAR)(156 & 0xff));
      case 0x016e: return((CHAR)(222 & 0xff));
      case 0x016f: return((CHAR)(133 & 0xff));
      case 0x0170: return((CHAR)(235 & 0xff));
      case 0x0171: return((CHAR)(251 & 0xff));
      case 0x0179: return((CHAR)(141 & 0xff));
      case 0x017a: return((CHAR)(171 & 0xff));
      case 0x017b: return((CHAR)(189 & 0xff));
      case 0x017c: return((CHAR)(190 & 0xff));
      case 0x017d: return((CHAR)(166 & 0xff));
      case 0x017e: return((CHAR)(167 & 0xff));
      case 0x02c7: return((CHAR)(243 & 0xff));
      case 0x02d8: return((CHAR)(244 & 0xff));
      case 0x02d9: return((CHAR)(250 & 0xff));
      case 0x02db: return((CHAR)(242 & 0xff));
      case 0x02dd: return((CHAR)(241 & 0xff));
      case 0x2500: return((CHAR)(196 & 0xff));
      case 0x2502: return((CHAR)(179 & 0xff));
      case 0x250c: return((CHAR)(218 & 0xff));
      case 0x2510: return((CHAR)(191 & 0xff));
      case 0x2514: return((CHAR)(192 & 0xff));
      case 0x2518: return((CHAR)(217 & 0xff));
      case 0x251c: return((CHAR)(195 & 0xff));
      case 0x2524: return((CHAR)(180 & 0xff));
      case 0x252c: return((CHAR)(194 & 0xff));
      case 0x2534: return((CHAR)(193 & 0xff));
      case 0x253c: return((CHAR)(197 & 0xff));
      case 0x2550: return((CHAR)(205 & 0xff));
      case 0x2551: return((CHAR)(186 & 0xff));
      case 0x2554: return((CHAR)(201 & 0xff));
      case 0x2557: return((CHAR)(187 & 0xff));
      case 0x255a: return((CHAR)(200 & 0xff));
      case 0x255d: return((CHAR)(188 & 0xff));
      case 0x2560: return((CHAR)(204 & 0xff));
      case 0x2563: return((CHAR)(185 & 0xff));
      case 0x2566: return((CHAR)(203 & 0xff));
      case 0x2569: return((CHAR)(202 & 0xff));
      case 0x256c: return((CHAR)(206 & 0xff));
      case 0x2580: return((CHAR)(223 & 0xff));
      case 0x2584: return((CHAR)(220 & 0xff));
      case 0x2588: return((CHAR)(219 & 0xff));
      case 0x2591: return((CHAR)(176 & 0xff));
      case 0x2592: return((CHAR)(177 & 0xff));
      case 0x2593: return((CHAR)(178 & 0xff));
      case 0x25a0: return((CHAR)(254 & 0xff));
      default: return(tx_cpsub(c));	/* For box characters etc */
    }
}

int					/* Windows Code Page 1253 (Greek) */
#ifdef CK_ANSIC
tx_cp1253(USHORT c)
#else
tx_cp1253(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x003c: return((CHAR)(0x8b & 0xff));
      case 0x003e: return((CHAR)(0x9b & 0xff));
      case 0x00A0: return((CHAR)(0xa0 & 0xff));
      case 0x00A3: return((CHAR)(0xa3 & 0xff));
      case 0x00A4: return((CHAR)(0xa4 & 0xff));
      case 0x00A5: return((CHAR)(0xa5 & 0xff));
      case 0x00A6: return((CHAR)(0xa6 & 0xff));
      case 0x00A7: return((CHAR)(0xa7 & 0xff));
      case 0x00A8: return((CHAR)(0xa8 & 0xff));
      case 0x00A9: return((CHAR)(0xa9 & 0xff));
      case 0x00AA: return((CHAR)(0xaa & 0xff));
      case 0x00AB: return((CHAR)(0xab & 0xff));
      case 0x00AC: return((CHAR)(0xac & 0xff));
      case 0x00AD: return((CHAR)(0xad & 0xff));
      case 0x00AE: return((CHAR)(0xae & 0xff));
      case 0x00AF: return((CHAR)(0xaf & 0xff));
      case 0x00B0: return((CHAR)(0xb0 & 0xff));
      case 0x00B1: return((CHAR)(0xb1 & 0xff));
      case 0x00B2: return((CHAR)(0xb2 & 0xff));
      case 0x00B3: return((CHAR)(0xb3 & 0xff));
      case 0x00B5: return((CHAR)(0xb5 & 0xff));
      case 0x00B6: return((CHAR)(0xb6 & 0xff));
      case 0x00b7: return((CHAR)(0xa1 & 0xff));
      case 0x00BB: return((CHAR)(0xbb & 0xff));
      case 0x00BD: return((CHAR)(0xbd & 0xff));
      case 0x0192: return((CHAR)(0x83 & 0xff));
      case 0x0386: return((CHAR)(0xa2 & 0xff));
      case 0x0388: return((CHAR)(0xb8 & 0xff));
      case 0x0389: return((CHAR)(0xb9 & 0xff));
      case 0x038A: return((CHAR)(0xba & 0xff));
      case 0x038C: return((CHAR)(0xbc & 0xff));
      case 0x038E: return((CHAR)(0xbe & 0xff));
      case 0x038F: return((CHAR)(0xbf & 0xff));
      case 0x0390: return((CHAR)(0xc0 & 0xff));
      case 0x0391: return((CHAR)(0xc1 & 0xff));
      case 0x0392: return((CHAR)(0xc2 & 0xff));
      case 0x0393: return((CHAR)(0xc3 & 0xff));
      case 0x0394: return((CHAR)(0xc4 & 0xff));
      case 0x0395: return((CHAR)(0xc5 & 0xff));
      case 0x0396: return((CHAR)(0xc6 & 0xff));
      case 0x0397: return((CHAR)(0xc7 & 0xff));
      case 0x0398: return((CHAR)(0xc8 & 0xff));
      case 0x0399: return((CHAR)(0xc9 & 0xff));
      case 0x039A: return((CHAR)(0xca & 0xff));
      case 0x039B: return((CHAR)(0xcb & 0xff));
      case 0x039C: return((CHAR)(0xcc & 0xff));
      case 0x039D: return((CHAR)(0xcd & 0xff));
      case 0x039E: return((CHAR)(0xce & 0xff));
      case 0x039F: return((CHAR)(0xcf & 0xff));
      case 0x03a0: return((CHAR)(0xd0 & 0xff));
      case 0x03a1: return((CHAR)(0xd1 & 0xff));
      case 0x03a3: return((CHAR)(0xd3 & 0xff));
      case 0x03a4: return((CHAR)(0xd4 & 0xff));
      case 0x03a5: return((CHAR)(0xd5 & 0xff));
      case 0x03a6: return((CHAR)(0xd6 & 0xff));
      case 0x03a7: return((CHAR)(0xd7 & 0xff));
      case 0x03a8: return((CHAR)(0xd8 & 0xff));
      case 0x03a9: return((CHAR)(0xd9 & 0xff));
      case 0x03aA: return((CHAR)(0xda & 0xff));
      case 0x03aB: return((CHAR)(0xdb & 0xff));
      case 0x03aC: return((CHAR)(0xdc & 0xff));
      case 0x03aD: return((CHAR)(0xdd & 0xff));
      case 0x03aE: return((CHAR)(0xde & 0xff));
      case 0x03aF: return((CHAR)(0xdf & 0xff));
      case 0x03b0: return((CHAR)(0xe0 & 0xff));
      case 0x03b1: return((CHAR)(0xe1 & 0xff));
      case 0x03b2: return((CHAR)(0xe2 & 0xff));
      case 0x03b3: return((CHAR)(0xe3 & 0xff));
      case 0x03b4: return((CHAR)(0xe4 & 0xff));
      case 0x03b5: return((CHAR)(0xe5 & 0xff));
      case 0x03b6: return((CHAR)(0xe6 & 0xff));
      case 0x03b7: return((CHAR)(0xe7 & 0xff));
      case 0x03b8: return((CHAR)(0xe8 & 0xff));
      case 0x03b9: return((CHAR)(0xe9 & 0xff));
      case 0x03bA: return((CHAR)(0xea & 0xff));
      case 0x03bB: return((CHAR)(0xeb & 0xff));
      case 0x03bC: return((CHAR)(0xec & 0xff));
      case 0x03bD: return((CHAR)(0xed & 0xff));
      case 0x03bE: return((CHAR)(0xee & 0xff));
      case 0x03bF: return((CHAR)(0xef & 0xff));
      case 0x03c0: return((CHAR)(0xf0 & 0xff));
      case 0x03c1: return((CHAR)(0xf1 & 0xff));
      case 0x03c2: return((CHAR)(0xf2 & 0xff));
      case 0x03c3: return((CHAR)(0xf3 & 0xff));
      case 0x03c4: return((CHAR)(0xf4 & 0xff));
      case 0x03c5: return((CHAR)(0xf5 & 0xff));
      case 0x03c6: return((CHAR)(0xf6 & 0xff));
      case 0x03c7: return((CHAR)(0xf7 & 0xff));
      case 0x03c8: return((CHAR)(0xf8 & 0xff));
      case 0x03c9: return((CHAR)(0xf9 & 0xff));
      case 0x03cA: return((CHAR)(0xfa & 0xff));
      case 0x03cB: return((CHAR)(0xfb & 0xff));
      case 0x03cC: return((CHAR)(0xfc & 0xff));
      case 0x03cD: return((CHAR)(0xfd & 0xff));
      case 0x03cE: return((CHAR)(0xfe & 0xff));
      case 0x2012: return((CHAR)(0x96 & 0xff));
      case 0x2014: return((CHAR)(0x97 & 0xff));
      case 0x2018: return((CHAR)(0x91 & 0xff));
      case 0x2019: return((CHAR)(0x92 & 0xff));
      case 0x201a: return((CHAR)(0x82 & 0xff));
      case 0x201c: return((CHAR)(0x93 & 0xff));
      case 0x201d: return((CHAR)(0x94 & 0xff));
      case 0x201e: return((CHAR)(0x84 & 0xff));
      case 0x2020: return((CHAR)(0x86 & 0xff));
      case 0x2021: return((CHAR)(0x87 & 0xff));
      case 0x2022: return((CHAR)(0x95 & 0xff));
      case 0x2026: return((CHAR)(0x85 & 0xff));
      case 0x2031: return((CHAR)(0x89 & 0xff));
      case 0x20AC:			/* Euro */
          return((CHAR)(0x80 & 0xff));
      case 0x2122: return((CHAR)(0x99 & 0xff));
      default: return(0x003f);
    }
}

int					/* Windows Code Page 1254 (Turkish) */
#ifdef CK_ANSIC
tx_cp1254(USHORT c)
#else
tx_cp1254(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x011e: return((CHAR)(0xd0 & 0xff));	/* G breve    */
      case 0x0130: return((CHAR)(0xdd & 0xff));	/* I with dot */
      case 0x015e: return((CHAR)(0xde & 0xff));	/* S cedilla  */
      case 0x011f: return((CHAR)(0xf0 & 0xff));	/* g breve    */
      case 0x0131: return((CHAR)(0xfd & 0xff));	/* i dotless */
      case 0x015f: return((CHAR)(0xfe & 0xff));	/* s cedilla */
      default: return(tx_cp1252(c));	/* The rest is like Windows Latin-1 */
    }
}

int
#ifdef CK_ANSIC
tx_cp1255(USHORT c)
#else
tx_cp1255(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x080)
        return((CHAR)(c & 0xff));
    switch (c) {
      case 0x20AC:
	return((CHAR)(0x80 & 0xff));	/* EURO SIGN */
      case 0x201A:
	return((CHAR)(0x82 & 0xff));	/* SINGLE LOW-9 QUOTATION MARK */
      case 0x0192:
	return((CHAR)(0x83 & 0xff));	/* LATIN SMALL LETTER F WITH HOOK */
      case 0x201E:
	return((CHAR)(0x84 & 0xff));	/* DOUBLE LOW-9 QUOTATION MARK */
      case 0x2026:
	return((CHAR)(0x85 & 0xff));	/* HORIZONTAL ELLIPSIS */
      case 0x2020:
	return((CHAR)(0x86 & 0xff));	/* DAGGER */
      case 0x2021:
	return((CHAR)(0x87 & 0xff));	/* DOUBLE DAGGER */
      case 0x02C6:
	return((CHAR)(0x88 & 0xff));	/* MODIFIER LETTER CIRCUMFLEX ACCENT */
      case 0x2030:
	return((CHAR)(0x89 & 0xff));	/* PER MILLE SIGN */
      case 0x2039:
	return((CHAR)(0x8B & 0xff));	/* SINGLE LEFT-POINTING ANGLE QUOTE */
      case 0x2018:
	return((CHAR)(0x91 & 0xff));	/* LEFT SINGLE QUOTATION MARK */
      case 0x2019:
	return((CHAR)(0x92 & 0xff));	/* RIGHT SINGLE QUOTATION MARK */
      case 0x201C:
	return((CHAR)(0x93 & 0xff));	/* LEFT DOUBLE QUOTATION MARK */
      case 0x201D:
	return((CHAR)(0x94 & 0xff));	/* RIGHT DOUBLE QUOTATION MARK */
      case 0x2022:
	return((CHAR)(0x95 & 0xff));	/* BULLET */
      case 0x2013:
	return((CHAR)(0x96 & 0xff));	/* EN DASH */
      case 0x2014:
        return((CHAR)(0x97 & 0xff));	/* EM DASH */
      case 0x02DC:
        return((CHAR)(0x98 & 0xff));	/* SMALL TILDE */
      case 0x2122:
        return((CHAR)(0x99 & 0xff));	/* TRADE MARK SIGN */
      case 0x203A:
        return((CHAR)(0x9B & 0xff));	/* SINGLE RIGHT-POINTING ANGLE QUOTE */
      case 0x00A0:
        return((CHAR)(0xA0 & 0xff));	/* NO-BREAK SPACE */
      case 0x00A1:
        return((CHAR)(0xA1 & 0xff));	/* INVERTED EXCLAMATION MARK */
      case 0x00A2:
        return((CHAR)(0xA2 & 0xff));	/* CENT SIGN */
      case 0x00A3:
        return((CHAR)(0xA3 & 0xff));	/* POUND SIGN */
      case 0x20AA:
        return((CHAR)(0xA4 & 0xff));	/* NEW SHEQEL SIGN */
      case 0x00A5:
        return((CHAR)(0xA5 & 0xff));	/* YEN SIGN */
      case 0x00A6:
        return((CHAR)(0xA6 & 0xff));	/* BROKEN BAR */
      case 0x00A7:
        return((CHAR)(0xA7 & 0xff));	/* SECTION SIGN */
      case 0x00A8:
        return((CHAR)(0xA8 & 0xff));	/* DIAERESIS */
      case 0x00A9:
        return((CHAR)(0xA9 & 0xff));	/* COPYRIGHT SIGN */
      case 0x00D7:
        return((CHAR)(0xAA & 0xff));	/* MULTIPLICATION SIGN */
      case 0x00AB:
        return((CHAR)(0xAB & 0xff));	/* LEFT-POINTING DOUBLE ANGLE QUOTE */
      case 0x00AC:
        return((CHAR)(0xAC & 0xff));	/* NOT SIGN */
      case 0x00AD:
        return((CHAR)(0xAD & 0xff));	/* SOFT HYPHEN */
      case 0x00AE:
        return((CHAR)(0xAE & 0xff));	/* REGISTERED SIGN */
      case 0x00AF:
        return((CHAR)(0xAF & 0xff));	/* MACRON */
      case 0x00B0:
        return((CHAR)(0xB0 & 0xff));	/* DEGREE SIGN */
      case 0x00B1:
        return((CHAR)(0xB1 & 0xff));	/* PLUS-MINUS SIGN */
      case 0x00B2:
        return((CHAR)(0xB2 & 0xff));	/* SUPERSCRIPT TWO */
      case 0x00B3:
        return((CHAR)(0xB3 & 0xff));	/* SUPERSCRIPT THREE */
      case 0x00B4:
        return((CHAR)(0xB4 & 0xff));	/* ACUTE ACCENT */
      case 0x00B5:
        return((CHAR)(0xB5 & 0xff));	/* MICRO SIGN */
      case 0x00B6:
        return((CHAR)(0xB6 & 0xff));	/* PILCROW SIGN */
      case 0x00B7:
        return((CHAR)(0xB7 & 0xff));	/* MIDDLE DOT */
      case 0x00B8:
        return((CHAR)(0xB8 & 0xff));	/* CEDILLA */
      case 0x00B9:
        return((CHAR)(0xB9 & 0xff));	/* SUPERSCRIPT ONE */
      case 0x00F7:
        return((CHAR)(0xBA & 0xff));	/* DIVISION SIGN */
      case 0x00BB:
        return((CHAR)(0xBB & 0xff));	/* RIGHT-POINTING DOUBLE ANGLE QUOTE */
      case 0x00BC:
        return((CHAR)(0xBC & 0xff));	/* VULGAR FRACTION ONE QUARTER */
      case 0x00BD:
        return((CHAR)(0xBD & 0xff));	/* VULGAR FRACTION ONE HALF */
      case 0x00BE:
        return((CHAR)(0xBE & 0xff));	/* VULGAR FRACTION THREE QUARTERS */
      case 0x00BF:
        return((CHAR)(0xBF & 0xff));	/* INVERTED QUESTION MARK */
      case 0x05B0:
        return((CHAR)(0xC0 & 0xff));	/* HEBREW POINT SHEVA */
      case 0x05B1:
        return((CHAR)(0xC1 & 0xff));	/* HEBREW POINT HATAF SEGOL */
      case 0x05B2:
        return((CHAR)(0xC2 & 0xff));	/* HEBREW POINT HATAF PATAH */
      case 0x05B3:
        return((CHAR)(0xC3 & 0xff));	/* HEBREW POINT HATAF QAMATS */
      case 0x05B4:
        return((CHAR)(0xC4 & 0xff));	/* HEBREW POINT HIRIQ */
      case 0x05B5:
        return((CHAR)(0xC5 & 0xff));	/* HEBREW POINT TSERE */
      case 0x05B6:
        return((CHAR)(0xC6 & 0xff));	/* HEBREW POINT SEGOL */
      case 0x05B7:
        return((CHAR)(0xC7 & 0xff));	/* HEBREW POINT PATAH */
      case 0x05B8:
        return((CHAR)(0xC8 & 0xff));	/* HEBREW POINT QAMATS */
      case 0x05B9:
        return((CHAR)(0xC9 & 0xff));	/* HEBREW POINT HOLAM */
      case 0x05BB:
        return((CHAR)(0xCB & 0xff));	/* HEBREW POINT QUBUTS */
      case 0x05BC:
        return((CHAR)(0xCC & 0xff));	/* HEBREW POINT DAGESH OR MAPIQ */
      case 0x05BD:
        return((CHAR)(0xCD & 0xff));	/* HEBREW POINT METEG */
      case 0x05BE:
        return((CHAR)(0xCE & 0xff));	/* HEBREW PUNCTUATION MAQAF */
      case 0x05BF:
        return((CHAR)(0xCF & 0xff));	/* HEBREW POINT RAFE */
      case 0x05C0:
        return((CHAR)(0xD0 & 0xff));	/* HEBREW PUNCTUATION PASEQ */
      case 0x05C1:
        return((CHAR)(0xD1 & 0xff));	/* HEBREW POINT SHIN DOT */
      case 0x05C2:
        return((CHAR)(0xD2 & 0xff));	/* HEBREW POINT SIN DOT */
      case 0x05C3:
        return((CHAR)(0xD3 & 0xff));	/* HEBREW PUNCTUATION SOF PASUQ */
      case 0x05F0:
        return((CHAR)(0xD4 & 0xff));	/* HEBREW LIG. YIDDISH DOUBLE VAV */
      case 0x05F1:
        return((CHAR)(0xD5 & 0xff));	/* HEBREW LIGATURE YIDDISH VAV YOD */
      case 0x05F2:
        return((CHAR)(0xD6 & 0xff));	/* HEBREW LIG. YIDDISH DOUBLE YOD */
      case 0x05F3:
        return((CHAR)(0xD7 & 0xff));	/* HEBREW PUNCTUATION GERESH */
      case 0x05F4:
        return((CHAR)(0xD8 & 0xff));	/* HEBREW PUNCTUATION GERSHAYIM */
      case 0x05D0:
        return((CHAR)(0xE0 & 0xff));	/* HEBREW LETTER ALEF */
      case 0x05D1:
        return((CHAR)(0xE1 & 0xff));	/* HEBREW LETTER BET */
      case 0x05D2:
        return((CHAR)(0xE2 & 0xff));	/* HEBREW LETTER GIMEL */
      case 0x05D3:
        return((CHAR)(0xE3 & 0xff));	/* HEBREW LETTER DALET */
      case 0x05D4:
        return((CHAR)(0xE4 & 0xff));	/* HEBREW LETTER HE */
      case 0x05D5:
        return((CHAR)(0xE5 & 0xff));	/* HEBREW LETTER VAV */
      case 0x05D6:
        return((CHAR)(0xE6 & 0xff));	/* HEBREW LETTER ZAYIN */
      case 0x05D7:
        return((CHAR)(0xE7 & 0xff));	/* HEBREW LETTER HET */
      case 0x05D8:
        return((CHAR)(0xE8 & 0xff));	/* HEBREW LETTER TET */
      case 0x05D9:
        return((CHAR)(0xE9 & 0xff));	/* HEBREW LETTER YOD */
      case 0x05DA:
        return((CHAR)(0xEA & 0xff));	/* HEBREW LETTER FINAL KAF */
      case 0x05DB:
        return((CHAR)(0xEB & 0xff));	/* HEBREW LETTER KAF */
      case 0x05DC:
        return((CHAR)(0xEC & 0xff));	/* HEBREW LETTER LAMED */
      case 0x05DD:
        return((CHAR)(0xED & 0xff));	/* HEBREW LETTER FINAL MEM */
      case 0x05DE:
        return((CHAR)(0xEE & 0xff));	/* HEBREW LETTER MEM */
      case 0x05DF:
        return((CHAR)(0xEF & 0xff));	/* HEBREW LETTER FINAL NUN */
      case 0x05E0:
        return((CHAR)(0xF0 & 0xff));	/* HEBREW LETTER NUN */
      case 0x05E1:
        return((CHAR)(0xF1 & 0xff));	/* HEBREW LETTER SAMEKH */
      case 0x05E2:
        return((CHAR)(0xF2 & 0xff));	/* HEBREW LETTER AYIN */
      case 0x05E3:
        return((CHAR)(0xF3 & 0xff));	/* HEBREW LETTER FINAL PE */
      case 0x05E4:
        return((CHAR)(0xF4 & 0xff));	/* HEBREW LETTER PE */
      case 0x05E5:
        return((CHAR)(0xF5 & 0xff));	/* HEBREW LETTER FINAL TSADI */
      case 0x05E6:
        return((CHAR)(0xF6 & 0xff));	/* HEBREW LETTER TSADI */
      case 0x05E7:
        return((CHAR)(0xF7 & 0xff));	/* HEBREW LETTER QOF */
      case 0x05E8:
        return((CHAR)(0xF8 & 0xff));	/* HEBREW LETTER RESH */
      case 0x05E9:
        return((CHAR)(0xF9 & 0xff));	/* HEBREW LETTER SHIN */
      case 0x05EA:
        return((CHAR)(0xFA & 0xff));	/* HEBREW LETTER TAV */
      case 0x200E:
        return((CHAR)(0xFD & 0xff));	/* LEFT-TO-RIGHT MARK */
      case 0x200F:
        return((CHAR)(0xFE & 0xff));	/* RIGHT-TO-LEFT MARK */
      default: return(0x003f);
    }
}

int					/* Windows Arabic */
#ifdef CK_ANSIC
tx_cp1256(USHORT c)
#else
tx_cp1256(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x20AC:
        return((CHAR)(0x80 & 0xff));	/* EURO SIGN */
      case 0x067E:
        return((CHAR)(0x81 & 0xff));	/* ARABIC LETTER PEH */
      case 0x201A:
        return((CHAR)(0x82 & 0xff));	/* SINGLE LOW-9 QUOTATION MARK */
      case 0x0192:
        return((CHAR)(0x83 & 0xff));	/* LATIN SMALL LETTER F WITH HOOK */
      case 0x201E:
        return((CHAR)(0x84 & 0xff));	/* DOUBLE LOW-9 QUOTATION MARK */
      case 0x2026:
        return((CHAR)(0x85 & 0xff));	/* HORIZONTAL ELLIPSIS */
      case 0x2020:
        return((CHAR)(0x86 & 0xff));	/* DAGGER */
      case 0x2021:
        return((CHAR)(0x87 & 0xff));	/* DOUBLE DAGGER */
      case 0x02C6:
        return((CHAR)(0x88 & 0xff));	/* MODIFIER LETTER CIRCUMFLEX ACCENT */
      case 0x2030:
        return((CHAR)(0x89 & 0xff));	/* PER MILLE SIGN */
      case 0x2039:
        return((CHAR)(0x8B & 0xff));	/* SINGLE LEFT-POINTING ANGLE QUOTE */
      case 0x0152:
        return((CHAR)(0x8C & 0xff));	/* LATIN CAPITAL LIGATURE OE */
      case 0x0686:
        return((CHAR)(0x8D & 0xff));	/* ARABIC LETTER TCHEH */
      case 0x0698:
        return((CHAR)(0x8E & 0xff));	/* ARABIC LETTER JEH */
      case 0x06AF:
        return((CHAR)(0x90 & 0xff));	/* ARABIC LETTER GAF */
      case 0x2018:
        return((CHAR)(0x91 & 0xff));	/* LEFT SINGLE QUOTATION MARK */
      case 0x2019:
        return((CHAR)(0x92 & 0xff));	/* RIGHT SINGLE QUOTATION MARK */
      case 0x201C:
        return((CHAR)(0x93 & 0xff));	/* LEFT DOUBLE QUOTATION MARK */
      case 0x201D:
        return((CHAR)(0x94 & 0xff));	/* RIGHT DOUBLE QUOTATION MARK */
      case 0x2022:
        return((CHAR)(0x95 & 0xff));	/* BULLET */
      case 0x2013:
        return((CHAR)(0x96 & 0xff));	/* EN DASH */
      case 0x2014:
        return((CHAR)(0x97 & 0xff));	/* EM DASH */
      case 0x2122:
        return((CHAR)(0x99 & 0xff));	/* TRADE MARK SIGN */
      case 0x203A:
        return((CHAR)(0x9B & 0xff));	/* SINGLE RIGHT-POINTING ANGLE QUOTE */
      case 0x0153:
        return((CHAR)(0x9C & 0xff));	/* LATIN SMALL LIGATURE OE */
      case 0x200C:
        return((CHAR)(0x9D & 0xff));	/* ZERO WIDTH NON-JOINER */
      case 0x200D:
        return((CHAR)(0x9E & 0xff));	/* ZERO WIDTH JOINER */
      case 0x00A0:
        return((CHAR)(0xA0 & 0xff));	/* NO-BREAK SPACE */
      case 0x060C:
        return((CHAR)(0xA1 & 0xff));	/* ARABIC COMMA */
      case 0x00A2:
        return((CHAR)(0xA2 & 0xff));	/* CENT SIGN */
      case 0x00A3:
        return((CHAR)(0xA3 & 0xff));	/* POUND SIGN */
      case 0x00A4:
        return((CHAR)(0xA4 & 0xff));	/* CURRENCY SIGN */
      case 0x00A5:
        return((CHAR)(0xA5 & 0xff));	/* YEN SIGN */
      case 0x00A6:
        return((CHAR)(0xA6 & 0xff));	/* BROKEN BAR */
      case 0x00A7:
        return((CHAR)(0xA7 & 0xff));	/* SECTION SIGN */
      case 0x00A8:
        return((CHAR)(0xA8 & 0xff));	/* DIAERESIS */
      case 0x00A9:
        return((CHAR)(0xA9 & 0xff));	/* COPYRIGHT SIGN */
      case 0x00AB:
        return((CHAR)(0xAB & 0xff));	/* LEFT-POINTING DOUBLE ANGLE QUOTE */
      case 0x00AC:
        return((CHAR)(0xAC & 0xff));	/* NOT SIGN */
      case 0x00AD:
        return((CHAR)(0xAD & 0xff));	/* SOFT HYPHEN */
      case 0x00AE:
        return((CHAR)(0xAE & 0xff));	/* REGISTERED SIGN */
      case 0x00AF:
        return((CHAR)(0xAF & 0xff));	/* MACRON */
      case 0x00B0:
        return((CHAR)(0xB0 & 0xff));	/* DEGREE SIGN */
      case 0x00B1:
        return((CHAR)(0xB1 & 0xff));	/* PLUS-MINUS SIGN */
      case 0x00B2:
        return((CHAR)(0xB2 & 0xff));	/* SUPERSCRIPT TWO */
      case 0x00B3:
        return((CHAR)(0xB3 & 0xff));	/* SUPERSCRIPT THREE */
      case 0x00B4:
        return((CHAR)(0xB4 & 0xff));	/* ACUTE ACCENT */
      case 0x00B5:
        return((CHAR)(0xB5 & 0xff));	/* MICRO SIGN */
      case 0x00B6:
        return((CHAR)(0xB6 & 0xff));	/* PILCROW SIGN */
      case 0x00B7:
        return((CHAR)(0xB7 & 0xff));	/* MIDDLE DOT */
      case 0x00B8:
        return((CHAR)(0xB8 & 0xff));	/* CEDILLA */
      case 0x00B9:
        return((CHAR)(0xB9 & 0xff));	/* SUPERSCRIPT ONE */
      case 0x061B:
        return((CHAR)(0xBA & 0xff));	/* ARABIC SEMICOLON */
      case 0x00BB:
        return((CHAR)(0xBB & 0xff));	/* RIGHT-POINTING DOUBLE ANGLE QUOTE */
      case 0x00BC:
        return((CHAR)(0xBC & 0xff));	/* VULGAR FRACTION ONE QUARTER */
      case 0x00BD:
        return((CHAR)(0xBD & 0xff));	/* VULGAR FRACTION ONE HALF */
      case 0x00BE:
        return((CHAR)(0xBE & 0xff));	/* VULGAR FRACTION THREE QUARTERS */
      case 0x061F:
        return((CHAR)(0xBF & 0xff));	/* ARABIC QUESTION MARK */
      case 0x0621:
        return((CHAR)(0xC1 & 0xff));	/* ARABIC LETTER HAMZA */
      case 0x0622:
        return((CHAR)(0xC2 & 0xff));	/* ARABIC LTR. ALEF WITH MADDA ABOVE */
      case 0x0623:
        return((CHAR)(0xC3 & 0xff));	/* ARABIC LTR. ALEF WITH HAMZA ABOVE */
      case 0x0624:
        return((CHAR)(0xC4 & 0xff));	/* ARABIC LTR. WAW WITH HAMZA ABOVE */
      case 0x0625:
        return((CHAR)(0xC5 & 0xff));	/* ARABIC LTR. ALEF WITH HAMZA BELOW */
      case 0x0626:
        return((CHAR)(0xC6 & 0xff));	/* ARABIC LTR. YEH WITH HAMZA ABOVE */
      case 0x0627:
        return((CHAR)(0xC7 & 0xff));	/* ARABIC LTR. ALEF */
      case 0x0628:
        return((CHAR)(0xC8 & 0xff));	/* ARABIC LTR. BEH */
      case 0x0629:
        return((CHAR)(0xC9 & 0xff));	/* ARABIC LETTER TEH MARBUTA */
      case 0x062A:
        return((CHAR)(0xCA & 0xff));	/* ARABIC LETTER TEH */
      case 0x062B:
        return((CHAR)(0xCB & 0xff));	/* ARABIC LETTER THEH */
      case 0x062C:
        return((CHAR)(0xCC & 0xff));	/* ARABIC LETTER JEEM */
      case 0x062D:
        return((CHAR)(0xCD & 0xff));	/* ARABIC LETTER HAH */
      case 0x062E:
        return((CHAR)(0xCE & 0xff));	/* ARABIC LETTER KHAH */
      case 0x062F:
        return((CHAR)(0xCF & 0xff));	/* ARABIC LETTER DAL */
      case 0x0630:
        return((CHAR)(0xD0 & 0xff));	/* ARABIC LETTER THAL */
      case 0x0631:
        return((CHAR)(0xD1 & 0xff));	/* ARABIC LETTER REH */
      case 0x0632:
        return((CHAR)(0xD2 & 0xff));	/* ARABIC LETTER ZAIN */
      case 0x0633:
        return((CHAR)(0xD3 & 0xff));	/* ARABIC LETTER SEEN */
      case 0x0634:
        return((CHAR)(0xD4 & 0xff));	/* ARABIC LETTER SHEEN */
      case 0x0635:
        return((CHAR)(0xD5 & 0xff));	/* ARABIC LETTER SAD */
      case 0x0636:
        return((CHAR)(0xD6 & 0xff));	/* ARABIC LETTER DAD */
      case 0x00D7:
        return((CHAR)(0xD7 & 0xff));	/* MULTIPLICATION SIGN */
      case 0x0637:
        return((CHAR)(0xD8 & 0xff));	/* ARABIC LETTER TAH */
      case 0x0638:
        return((CHAR)(0xD9 & 0xff));	/* ARABIC LETTER ZAH */
      case 0x0639:
        return((CHAR)(0xDA & 0xff));	/* ARABIC LETTER AIN */
      case 0x063A:
        return((CHAR)(0xDB & 0xff));	/* ARABIC LETTER GHAIN */
      case 0x0640:
        return((CHAR)(0xDC & 0xff));	/* ARABIC TATWEEL */
      case 0x0641:
        return((CHAR)(0xDD & 0xff));	/* ARABIC LETTER FEH */
      case 0x0642:
        return((CHAR)(0xDE & 0xff));	/* ARABIC LETTER QAF */
      case 0x0643:
        return((CHAR)(0xDF & 0xff));	/* ARABIC LETTER KAF */
      case 0x00E0:
        return((CHAR)(0xE0 & 0xff));	/* LATIN SMALL LETTER A WITH GRAVE */
      case 0x0644:
        return((CHAR)(0xE1 & 0xff));	/* ARABIC LETTER LAM */
      case 0x00E2:
        return((CHAR)(0xE2 & 0xff));	/* SMALL LETTER A WITH CIRCUMFLEX */
      case 0x0645:
        return((CHAR)(0xE3 & 0xff));	/* ARABIC LETTER MEEM */
      case 0x0646:
        return((CHAR)(0xE4 & 0xff));	/* ARABIC LETTER NOON */
      case 0x0647:
        return((CHAR)(0xE5 & 0xff));	/* ARABIC LETTER HEH */
      case 0x0648:
        return((CHAR)(0xE6 & 0xff));	/* ARABIC LETTER WAW */
      case 0x00E7:
        return((CHAR)(0xE7 & 0xff));	/* LATIN SMALL LETTER C WITH CEDILLA */
      case 0x00E8:
        return((CHAR)(0xE8 & 0xff));	/* LATIN SMALL LETTER E WITH GRAVE */
      case 0x00E9:
        return((CHAR)(0xE9 & 0xff));	/* LATIN SMALL LETTER E WITH ACUTE */
      case 0x00EA:
        return((CHAR)(0xEA & 0xff));	/* SMALL LETTER E WITH CIRCUMFLEX */
      case 0x00EB:
        return((CHAR)(0xEB & 0xff));	/* SMALL LETTER E WITH DIAERESIS */
      case 0x0649:
        return((CHAR)(0xEC & 0xff));	/* ARABIC LETTER ALEF MAKSURA */
      case 0x064A:
        return((CHAR)(0xED & 0xff));	/* ARABIC LETTER YEH */
      case 0x00EE:
        return((CHAR)(0xEE & 0xff));	/* SMALL LETTER I WITH CIRCUMFLEX */
      case 0x00EF:
        return((CHAR)(0xEF & 0xff));	/* SMALL LETTER I WITH DIAERESIS */
      case 0x064B:
        return((CHAR)(0xF0 & 0xff));	/* ARABIC FATHATAN */
      case 0x064C:
        return((CHAR)(0xF1 & 0xff));	/* ARABIC DAMMATAN */
      case 0x064D:
        return((CHAR)(0xF2 & 0xff));	/* ARABIC KASRATAN */
      case 0x064E:
        return((CHAR)(0xF3 & 0xff));	/* ARABIC FATHA */
      case 0x00F4:
        return((CHAR)(0xF4 & 0xff));	/* SMALL LETTER O WITH CIRCUMFLEX */
      case 0x064F:
        return((CHAR)(0xF5 & 0xff));	/* ARABIC DAMMA */
      case 0x0650:
        return((CHAR)(0xF6 & 0xff));	/* ARABIC KASRA */
      case 0x00F7:
        return((CHAR)(0xF7 & 0xff));	/* DIVISION SIGN */
      case 0x0651:
        return((CHAR)(0xF8 & 0xff));	/* ARABIC SHADDA */
      case 0x00F9:
        return((CHAR)(0xF9 & 0xff));	/* LATIN SMALL LETTER U WITH GRAVE */
      case 0x0652:
        return((CHAR)(0xFA & 0xff));	/* ARABIC SUKUN */
      case 0x00FB:
        return((CHAR)(0xFB & 0xff));	/* SMALL LETTER U WITH CIRCUMFLEX */
      case 0x00FC:
        return((CHAR)(0xFC & 0xff));	/* SMALL LETTER U WITH DIAERESIS */
      case 0x200E:
        return((CHAR)(0xFD & 0xff));	/* LEFT-TO-RIGHT MARK */
      case 0x200F:
        return((CHAR)(0xFE & 0xff));	/* RIGHT-TO-LEFT MARK */
      default: return(0x003f);
    }
}

int					/* Windows Code Page 1257 (Latin-4) */
#ifdef CK_ANSIC
tx_cp1257(USHORT c)
#else
tx_cp1257(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x003c: return((CHAR)(0x8b & 0xff));
      case 0x003e: return((CHAR)(0x9b & 0xff));
      case 0x00A0: return((CHAR)(0xa0 & 0xff));
      case 0x00A2: return((CHAR)(0xa2 & 0xff));
      case 0x00A3: return((CHAR)(0xa3 & 0xff));
      case 0x00A4: return((CHAR)(0xa4 & 0xff));
      case 0x00A6: return((CHAR)(0xa6 & 0xff));
      case 0x00A7: return((CHAR)(0xa7 & 0xff));
      case 0x00A9: return((CHAR)(0xa9 & 0xff));
      case 0x00AB: return((CHAR)(0xab & 0xff));
      case 0x00AC: return((CHAR)(0xac & 0xff));
      case 0x00AD: return((CHAR)(0xad & 0xff));
      case 0x00AE: return((CHAR)(0xae & 0xff));
      case 0x00B0: return((CHAR)(0xb0 & 0xff));
      case 0x00B1: return((CHAR)(0xb1 & 0xff));
      case 0x00B2: return((CHAR)(0xb2 & 0xff));
      case 0x00B3: return((CHAR)(0xb3 & 0xff));
      case 0x00B5: return((CHAR)(0xb5 & 0xff));
      case 0x00B6: return((CHAR)(0xb6 & 0xff));
      case 0x00B7: return((CHAR)(0xb7 & 0xff));
      case 0x00B9: return((CHAR)(0xb9 & 0xff));
      case 0x00BB: return((CHAR)(0xbb & 0xff));
      case 0x00BC: return((CHAR)(0xbc & 0xff));
      case 0x00BD: return((CHAR)(0xbd & 0xff));
      case 0x00BE: return((CHAR)(0xbe & 0xff));
      case 0x00C4: return((CHAR)(0xc4 & 0xff));
      case 0x00C5: return((CHAR)(0xc5 & 0xff));
      case 0x00c6: return((CHAR)(0xaf & 0xff));
      case 0x00C9: return((CHAR)(0xc9 & 0xff));
      case 0x00d3: return((CHAR)(0xd3 & 0xff));
      case 0x00D5: return((CHAR)(0xd5 & 0xff));
      case 0x00D6: return((CHAR)(0xd6 & 0xff));
      case 0x00D7: return((CHAR)(0xd7 & 0xff));
      case 0x00d8: return((CHAR)(0xa8 & 0xff));
      case 0x00DC: return((CHAR)(0xdc & 0xff));
      case 0x00DF: return((CHAR)(0xdf & 0xff));
      case 0x00E4: return((CHAR)(0xe4 & 0xff));
      case 0x00E5: return((CHAR)(0xe5 & 0xff));
      case 0x00e6: return((CHAR)(0xbf & 0xff));
      case 0x00E9: return((CHAR)(0xe9 & 0xff));
      case 0x00f3: return((CHAR)(0xf3 & 0xff));
      case 0x00F5: return((CHAR)(0xf5 & 0xff));
      case 0x00F6: return((CHAR)(0xf6 & 0xff));
      case 0x00F7: return((CHAR)(0xf7 & 0xff));
      case 0x00f8: return((CHAR)(0xb8 & 0xff));
      case 0x00fc: return((CHAR)(0xfc & 0xff));
      case 0x0100: return((CHAR)(0xc2 & 0xff));
      case 0x0101: return((CHAR)(0xe2 & 0xff));
      case 0x0104: return((CHAR)(0xc0 & 0xff));
      case 0x0105: return((CHAR)(0xe0 & 0xff));
      case 0x0106: return((CHAR)(0xc3 & 0xff));
      case 0x0107: return((CHAR)(0xe3 & 0xff));
      case 0x010C: return((CHAR)(0xc8 & 0xff));
      case 0x010D: return((CHAR)(0xe8 & 0xff));
      case 0x0112: return((CHAR)(0xc7 & 0xff));
      case 0x0113: return((CHAR)(0xe7 & 0xff));
      case 0x0116: return((CHAR)(0xcb & 0xff));
      case 0x0117: return((CHAR)(0xeb & 0xff));
      case 0x0118: return((CHAR)(0xc6 & 0xff));
      case 0x0119: return((CHAR)(0xe6 & 0xff));
      case 0x0122: return((CHAR)(0xcc & 0xff));
      case 0x0123: return((CHAR)(0xec & 0xff));
      case 0x012a: return((CHAR)(0xce & 0xff));
      case 0x012b: return((CHAR)(0xee & 0xff));
      case 0x012e: return((CHAR)(0xc1 & 0xff));
      case 0x012f: return((CHAR)(0xe1 & 0xff));
      case 0x0136: return((CHAR)(0xcd & 0xff));
      case 0x0137: return((CHAR)(0xed & 0xff));
      case 0x013c: return((CHAR)(0xef & 0xff));
      case 0x0141: return((CHAR)(0xd9 & 0xff));
      case 0x0142: return((CHAR)(0xf9 & 0xff));
      case 0x0143: return((CHAR)(0xd1 & 0xff));
      case 0x0144: return((CHAR)(0xf1 & 0xff));
      case 0x0145: return((CHAR)(0xd2 & 0xff));
      case 0x0146: return((CHAR)(0xf2 & 0xff));
      case 0x014c: return((CHAR)(0xd4 & 0xff));
      case 0x014d: return((CHAR)(0xf4 & 0xff));
      case 0x0156: return((CHAR)(0xaa & 0xff));
      case 0x0157: return((CHAR)(0xba & 0xff));
      case 0x015A: return((CHAR)(0xda & 0xff));
      case 0x015b: return((CHAR)(0xfa & 0xff));
      case 0x0160: return((CHAR)(0xd0 & 0xff));
      case 0x0161: return((CHAR)(0xf0 & 0xff));
      case 0x016a: return((CHAR)(0xdb & 0xff));
      case 0x016b: return((CHAR)(0xfb & 0xff));
      case 0x0172: return((CHAR)(0xd8 & 0xff));
      case 0x0173: return((CHAR)(0xf8 & 0xff));
      case 0x0179: return((CHAR)(0xca & 0xff));
      case 0x017a: return((CHAR)(0xea & 0xff));
      case 0x017b: return((CHAR)(0xdd & 0xff));
      case 0x017c: return((CHAR)(0xfd & 0xff));
      case 0x017d: return((CHAR)(0xde & 0xff));
      case 0x017e: return((CHAR)(0xfe & 0xff));
      case 0x2012: return((CHAR)(0x96 & 0xff));
      case 0x2014: return((CHAR)(0x97 & 0xff));
      case 0x2018: return((CHAR)(0x91 & 0xff));
      case 0x2019: return((CHAR)(0x92 & 0xff));
      case 0x201a: return((CHAR)(0x82 & 0xff));
      case 0x201c: return((CHAR)(0x93 & 0xff));
      case 0x201d: return((CHAR)(0x94 & 0xff));
      case 0x201e: return((CHAR)(0x84 & 0xff));
      case 0x2020: return((CHAR)(0x86 & 0xff));
      case 0x2021: return((CHAR)(0x87 & 0xff));
      case 0x2022: return((CHAR)(0x95 & 0xff));
      case 0x2026: return((CHAR)(0x85 & 0xff));
      case 0x2031: return((CHAR)(0x89 & 0xff));
      case 0x20AC:			/* Euro */
          return((CHAR)(0x80 & 0xff));
      case 0x2122: return((CHAR)(0x99 & 0xff));
      default: return(0x003f);
    }
}

int					/* Windows Code Page 1258 (Viet Nam) */
#ifdef CK_ANSIC
tx_cp1258(USHORT c)
#else
tx_cp1258(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x20AC:
	return((CHAR)(0x80 & 0xff));	/* EURO SIGN */
      case 0x201A:
	return((CHAR)(0x82 & 0xff));	/* SINGLE LOW-9 QUOTATION MARK */
      case 0x0192:
	return((CHAR)(0x83 & 0xff));	/* LATIN SMALL LETTER F WITH HOOK */
      case 0x201E:
	return((CHAR)(0x84 & 0xff));	/* DOUBLE LOW-9 QUOTATION MARK */
      case 0x2026: return((CHAR)(0x85 & 0xff)); /* HORIZONTAL ELLIPSIS */
      case 0x2020: return((CHAR)(0x86 & 0xff)); /* DAGGER */
      case 0x2021: return((CHAR)(0x87 & 0xff)); /* DOUBLE DAGGER */
      case 0x02C6:
	return((CHAR)(0x88 & 0xff));	/* MODIFIER LETTER CIRCUMFLEX ACCENT */
      case 0x2030: return((CHAR)(0x89 & 0xff));	/* PER MILLE SIGN */
      case 0x2039:
	return((CHAR)(0x8B & 0xff));	/* SINGLE LEFT ANGLE QUOTATION MARK */
      case 0x0152: return((CHAR)(0x8C & 0xff));	/* LATIN CAPITAL LIGATURE OE */
      case 0x2018:
	return((CHAR)(0x91 & 0xff));	/* LEFT SINGLE QUOTATION MARK */
      case 0x2019:
	return((CHAR)(0x92 & 0xff));	/* RIGHT SINGLE QUOTATION MARK */
      case 0x201C:
	return((CHAR)(0x93 & 0xff));	/* LEFT DOUBLE QUOTATION MARK */
      case 0x201D:
	return((CHAR)(0x94 & 0xff));	/* RIGHT DOUBLE QUOTATION MARK */
      case 0x2022:
	return((CHAR)(0x95 & 0xff));	/* BULLET */
      case 0x2013:
	return((CHAR)(0x96 & 0xff));	/* EN DASH */
      case 0x2014:
	return((CHAR)(0x97 & 0xff));	/* EM DASH */
      case 0x02DC:
	return((CHAR)(0x98 & 0xff));	/* SMALL TILDE */
      case 0x2122:
	return((CHAR)(0x99 & 0xff));	/* TRADE MARK SIGN */
      case 0x203A:
	/* SINGLE RIGHT-POINTING ANGLE QUOTATION MAR K*/
	return((CHAR)(0x9B & 0xff));
      case 0x0153:
	return((CHAR)(0x9C & 0xff));	/* LATIN SMALL LIGATURE OE */
      case 0x0178:
	/* LATIN CAPITAL LETTER Y WITH DIAERESIS */
	return((CHAR)(0x9F & 0xff));
      case 0x00A0:
	return((CHAR)(0xA0 & 0xff));	/* NO-BREAK SPACE */
      case 0x00A1:
	return((CHAR)(0xA1 & 0xff));	/* INVERTED EXCLAMATION MARK */
      case 0x00A2:
	return((CHAR)(0xA2 & 0xff));	/* CENT SIGN */
      case 0x00A3:
	return((CHAR)(0xA3 & 0xff));	/* POUND SIGN */
      case 0x00A4:
	return((CHAR)(0xA4 & 0xff));	/* CURRENCY SIGN */
      case 0x00A5:
	return((CHAR)(0xA5 & 0xff));	/* YEN SIGN */
      case 0x00A6:
	return((CHAR)(0xA6 & 0xff));	/* BROKEN BAR */
      case 0x00A7:
	return((CHAR)(0xA7 & 0xff));	/* SECTION SIGN */
      case 0x00A8:
	return((CHAR)(0xA8 & 0xff));	/* DIAERESIS */
      case 0x00A9:
	return((CHAR)(0xA9 & 0xff));	/* COPYRIGHT SIGN */
      case 0x00AA:
	return((CHAR)(0xAA & 0xff));	/* FEMININE ORDINAL INDICATOR */
      case 0x00AB:
	/* LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */
	return((CHAR)(0xAB & 0xff));
      case 0x00AC:
	return((CHAR)(0xAC & 0xff));	/* NOT SIGN */
      case 0x00AD:
	return((CHAR)(0xAD & 0xff));	/* SOFT HYPHEN */
      case 0x00AE:
	return((CHAR)(0xAE & 0xff));	/* REGISTERED SIGN */
      case 0x00AF:
	return((CHAR)(0xAF & 0xff));	/* MACRON */
      case 0x00B0:
	return((CHAR)(0xB0 & 0xff));	/* DEGREE SIGN */
      case 0x00B1:
	return((CHAR)(0xB1 & 0xff));	/* PLUS-MINUS SIGN */
      case 0x00B2:
	return((CHAR)(0xB2 & 0xff));	/* SUPERSCRIPT TWO */
      case 0x00B3:
	return((CHAR)(0xB3 & 0xff));	/* SUPERSCRIPT THREE */
      case 0x00B4:
	return((CHAR)(0xB4 & 0xff));	/* ACUTE ACCENT */
      case 0x00B5:
	return((CHAR)(0xB5 & 0xff));	/* MICRO SIGN */
      case 0x00B6:
	return((CHAR)(0xB6 & 0xff));	/* PILCROW SIGN */
      case 0x00B7:
	return((CHAR)(0xB7 & 0xff));	/* MIDDLE DOT */
      case 0x00B8:
	return((CHAR)(0xB8 & 0xff));	/* CEDILLA */
      case 0x00B9:
	return((CHAR)(0xB9 & 0xff));	/* SUPERSCRIPT ONE */
      case 0x00BA:
	return((CHAR)(0xBA & 0xff));	/* MASCULINE ORDINAL INDICATOR */
      case 0x00BB:
	/* RIGHT-POINTING DOUBLE ANGLE QUOTATION MAR K*/
	return((CHAR)(0xBB & 0xff));
      case 0x00BC:
	return((CHAR)(0xBC & 0xff));	/* VULGAR FRACTION ONE QUARTER */
      case 0x00BD:
	return((CHAR)(0xBD & 0xff));	/* VULGAR FRACTION ONE HALF */
      case 0x00BE:
	return((CHAR)(0xBE & 0xff));	/* VULGAR FRACTION THREE QUARTERS */
      case 0x00BF:
	return((CHAR)(0xBF & 0xff));	/* INVERTED QUESTION MARK */
      case 0x00C0:
	return((CHAR)(0xC0 & 0xff));	/* LATIN CAPITAL LETTER A WITH GRAVE */
      case 0x00C1:
	return((CHAR)(0xC1 & 0xff));	/* LATIN CAPITAL LETTER A WITH ACUTE */
      case 0x00C2:
	return((CHAR)(0xC2 & 0xff));	/* A CIRCUMFLEX */
      case 0x0102:
	return((CHAR)(0xC3 & 0xff));	/* LATIN CAPITAL LETTER A WITH BREVE */
      case 0x00C4:
	return((CHAR)(0xC4 & 0xff));	/* A DIAERESIS */
      case 0x00C5:
	return((CHAR)(0xC5 & 0xff));	/* A RING */
      case 0x00C6:
	return((CHAR)(0xC6 & 0xff));	/* LATIN CAPITAL LETTER AE */
      case 0x00C7:
	return((CHAR)(0xC7 & 0xff));	/* C CEDILLA */
      case 0x00C8:
	return((CHAR)(0xC8 & 0xff));	/* E GRAVE */
      case 0x00C9:
	return((CHAR)(0xC9 & 0xff));	/* LATIN CAPITAL LETTER E WITH ACUTE */
      case 0x00CA:
	return((CHAR)(0xCA & 0xff));	/* E WITH CIRCUMFLEX */
      case 0x00CB:
	return((CHAR)(0xCB & 0xff));	/* E WITH DIAERESIS */
      case 0x0300:
	return((CHAR)(0xCC & 0xff));	/* COMBINING GRAVE ACCENT */
      case 0x00CD:
	return((CHAR)(0xCD & 0xff));	/* I WITH ACUTE */
      case 0x00CE:
	return((CHAR)(0xCE & 0xff));	/* I WITH CIRCUMFLEX */
      case 0x00CF:
	return((CHAR)(0xCF & 0xff));	/* I WITH DIAERESIS */
      case 0x0110:
	return((CHAR)(0xD0 & 0xff));	/* D WITH STROKE */
      case 0x00D1:
	return((CHAR)(0xD1 & 0xff));	/* LATIN CAPITAL LETTER N WITH TILDE */
      case 0x0309:
	return((CHAR)(0xD2 & 0xff));	/* COMBINING HOOK ABOVE */
      case 0x00D3:
	return((CHAR)(0xD3 & 0xff));	/* LATIN CAPITAL LETTER O WITH ACUTE */
      case 0x00D4:
	return((CHAR)(0xD4 & 0xff));	/* O WITH CIRCUMFLEX */
      case 0x01A0:
	return((CHAR)(0xD5 & 0xff));	/* LATIN CAPITAL LETTER O WITH HORN */
      case 0x00D6:
	return((CHAR)(0xD6 & 0xff));	/* O WITH DIAERESIS */
      case 0x00D7:
	return((CHAR)(0xD7 & 0xff));	/* MULTIPLICATION SIGN */
      case 0x00D8:
	return((CHAR)(0xD8 & 0xff));	/* O WITH STROKE */
      case 0x00D9:
	return((CHAR)(0xD9 & 0xff));	/* LATIN CAPITAL LETTER U WITH GRAVE */
      case 0x00DA:
	return((CHAR)(0xDA & 0xff));	/* LATIN CAPITAL LETTER U WITH ACUTE */
      case 0x00DB:
	return((CHAR)(0xDB & 0xff));	/* U WITH CIRCUMFLEX */
      case 0x00DC:
	return((CHAR)(0xDC & 0xff));	/* U WITH DIAERESIS */
      case 0x01AF:
	return((CHAR)(0xDD & 0xff));	/* LATIN CAPITAL LETTER U WITH HORN */
      case 0x0303:
	return((CHAR)(0xDE & 0xff));	/* COMBINING TILDE */
      case 0x00DF:
	return((CHAR)(0xDF & 0xff));	/* LATIN SMALL LETTER SHARP S */
      case 0x00E0:
	return((CHAR)(0xE0 & 0xff));	/* LATIN SMALL LETTER A WITH GRAVE */
      case 0x00E1:
	return((CHAR)(0xE1 & 0xff));	/* LATIN SMALL LETTER A WITH ACUTE */
      case 0x00E2:
	return((CHAR)(0xE2 & 0xff));	/* SMALL A WITH CIRCUMFLEX */
      case 0x0103:
	return((CHAR)(0xE3 & 0xff));	/* LATIN SMALL LETTER A WITH BREVE */
      case 0x00E4:
	return((CHAR)(0xE4 & 0xff));	/* SMALL A WITH DIAERESIS */
      case 0x00E5:
	return((CHAR)(0xE5 & 0xff));	/* SMALL A WITH RING ABOVE */
      case 0x00E6:
	return((CHAR)(0xE6 & 0xff));	/* LATIN SMALL LETTER AE */
      case 0x00E7:
	return((CHAR)(0xE7 & 0xff));	/* LATIN SMALL LETTER C WITH CEDILLA */
      case 0x00E8:
	return((CHAR)(0xE8 & 0xff));	/* LATIN SMALL LETTER E WITH GRAVE */
      case 0x00E9:
	return((CHAR)(0xE9 & 0xff));	/* LATIN SMALL LETTER E WITH ACUTE */
      case 0x00EA:
	return((CHAR)(0xEA & 0xff));	/* SMALL E WITH CIRCUMFLEX */
      case 0x00EB:
	return((CHAR)(0xEB & 0xff));	/* SMALL E WITH DIAERESIS */
      case 0x0301:
	return((CHAR)(0xEC & 0xff));	/* COMBINING ACUTE ACCENT */
      case 0x00ED:
	return((CHAR)(0xED & 0xff));	/* LATIN SMALL LETTER I WITH ACUTE */
      case 0x00EE:
	return((CHAR)(0xEE & 0xff));	/* SMALL I WITH CIRCUMFLEX */
      case 0x00EF:
	return((CHAR)(0xEF & 0xff));	/* SMALL I WITH DIAERESIS */
      case 0x0111:
	return((CHAR)(0xF0 & 0xff));	/* LATIN SMALL LETTER D WITH STROKE */
      case 0x00F1:
	return((CHAR)(0xF1 & 0xff));	/* LATIN SMALL LETTER N WITH TILDE */
      case 0x0323:
	return((CHAR)(0xF2 & 0xff));	/* COMBINING DOT BELOW */
      case 0x00F3:
	return((CHAR)(0xF3 & 0xff));	/* LATIN SMALL LETTER O WITH ACUTE */
      case 0x00F4:
	return((CHAR)(0xF4 & 0xff));	/* SMALL O WITH CIRCUMFLEX */
      case 0x01A1:
	return((CHAR)(0xF5 & 0xff));	/* LATIN SMALL LETTER O WITH HORN */
      case 0x00F6:
	return((CHAR)(0xF6 & 0xff));	/* SMALL O WITH DIAERESIS */
      case 0x00F7:
	return((CHAR)(0xF7 & 0xff));	/* DIVISION SIGN */
      case 0x00F8:
	return((CHAR)(0xF8 & 0xff));	/* LATIN SMALL LETTER O WITH STROKE */
      case 0x00F9:
	return((CHAR)(0xF9 & 0xff));	/* LATIN SMALL LETTER U WITH GRAVE */
      case 0x00FA:
	return((CHAR)(0xFA & 0xff));	/* LATIN SMALL LETTER U WITH ACUTE */
      case 0x00FB:
	return((CHAR)(0xFB & 0xff));	/* SMALL U WITH CIRCUMFLEX */
      case 0x00FC:
	return((CHAR)(0xFC & 0xff));	/* SMALL U WITH DIAERESIS */
      case 0x01B0:
	return((CHAR)(0xFD & 0xff));	/* LATIN SMALL LETTER U WITH HORN */
      case 0x20AB:
	return((CHAR)(0xFE & 0xff));	/* DONG SIGN */
      case 0x00FF:
	return((CHAR)(0xFF & 0xff));	/* SMALL Y WITH DIAERESIS */
    default: return(0x003f);
  }
}

int					/* Code Page 037 - EBCDIC (U.S.) */
#ifdef CK_ANSIC
tx_cp37(USHORT c)
#else
tx_cp37(c) USHORT c;
#endif /* CK_ANSIC */
{
    switch (c) {
      case 0x0000:
	return((CHAR)(0x00 & 0xff));	/* NULL */
      case 0x0001:
	return((CHAR)(0x01 & 0xff));	/* START OF HEADING */
      case 0x0002:
	return((CHAR)(0x02 & 0xff));	/* START OF TEXT */
      case 0x0003:
	return((CHAR)(0x03 & 0xff));	/* END OF TEXT */
      case 0x009C:
	return((CHAR)(0x04 & 0xff));	/* CONTROL */
      case 0x0009:
	return((CHAR)(0x05 & 0xff));	/* HORIZONTAL TABULATION */
      case 0x0086:
	return((CHAR)(0x06 & 0xff));	/* CONTROL */
      case 0x007F:
	return((CHAR)(0x07 & 0xff));	/* DELETE */
      case 0x0097:
	return((CHAR)(0x08 & 0xff));	/* CONTROL */
      case 0x008D:
	return((CHAR)(0x09 & 0xff));	/* CONTROL */
      case 0x008E:
	return((CHAR)(0x0A & 0xff));	/* CONTROL */
      case 0x000B:
	return((CHAR)(0x0B & 0xff));	/* VERTICAL TABULATION */
      case 0x000C:
	return((CHAR)(0x0C & 0xff));	/* FORM FEED */
      case 0x000D:
	return((CHAR)(0x0D & 0xff));	/* CARRIAGE RETURN */
      case 0x000E:
	return((CHAR)(0x0E & 0xff));	/* SHIFT OUT */
      case 0x000F:
	return((CHAR)(0x0F & 0xff));	/* SHIFT IN */
      case 0x0010:
	return((CHAR)(0x10 & 0xff));	/* DATA LINK ESCAPE */
      case 0x0011:
	return((CHAR)(0x11 & 0xff));	/* DEVICE CONTROL ONE */
      case 0x0012:
	return((CHAR)(0x12 & 0xff));	/* DEVICE CONTROL TWO */
      case 0x0013:
	return((CHAR)(0x13 & 0xff));	/* DEVICE CONTROL THREE */
      case 0x009D:
	return((CHAR)(0x14 & 0xff));	/* CONTROL */
      case 0x0085:
	return((CHAR)(0x15 & 0xff));	/* CONTROL */
      case 0x0008:
	return((CHAR)(0x16 & 0xff));	/* BACKSPACE */
      case 0x0087:
	return((CHAR)(0x17 & 0xff));	/* CONTROL */
      case 0x0018:
	return((CHAR)(0x18 & 0xff));	/* CANCEL */
      case 0x0019:
	return((CHAR)(0x19 & 0xff));	/* END OF MEDIUM */
      case 0x0092:
	return((CHAR)(0x1A & 0xff));	/* CONTROL */
      case 0x008F:
	return((CHAR)(0x1B & 0xff));	/* CONTROL */
      case 0x001C:
	return((CHAR)(0x1C & 0xff));	/* FILE SEPARATOR */
      case 0x001D:
	return((CHAR)(0x1D & 0xff));	/* GROUP SEPARATOR */
      case 0x001E:
	return((CHAR)(0x1E & 0xff));	/* RECORD SEPARATOR */
      case 0x001F:
	return((CHAR)(0x1F & 0xff));	/* UNIT SEPARATOR */
      case 0x0080:
	return((CHAR)(0x20 & 0xff));	/* CONTROL */
      case 0x0081:
	return((CHAR)(0x21 & 0xff));	/* CONTROL */
      case 0x0082:
	return((CHAR)(0x22 & 0xff));	/* CONTROL */
      case 0x0083:
	return((CHAR)(0x23 & 0xff));	/* CONTROL */
      case 0x0084:
	return((CHAR)(0x24 & 0xff));	/* CONTROL */
      case 0x000A:
	return((CHAR)(0x25 & 0xff));	/* LINE FEED */
      case 0x0017:
	return((CHAR)(0x26 & 0xff));	/* END OF TRANSMISSION BLOCK */
      case 0x001B:
	return((CHAR)(0x27 & 0xff));	/* ESCAPE */
      case 0x0088:
	return((CHAR)(0x28 & 0xff));	/* CONTROL */
      case 0x0089:
	return((CHAR)(0x29 & 0xff));	/* CONTROL */
      case 0x008A:
	return((CHAR)(0x2A & 0xff));	/* CONTROL */
      case 0x008B:
	return((CHAR)(0x2B & 0xff));	/* CONTROL */
      case 0x008C:
	return((CHAR)(0x2C & 0xff));	/* CONTROL */
      case 0x0005:
	return((CHAR)(0x2D & 0xff));	/* ENQUIRY */
      case 0x0006:
	return((CHAR)(0x2E & 0xff));	/* ACKNOWLEDGE */
      case 0x0007:
	return((CHAR)(0x2F & 0xff));	/* BELL */
      case 0x0090:
	return((CHAR)(0x30 & 0xff));	/* CONTROL */
      case 0x0091:
	return((CHAR)(0x31 & 0xff));	/* CONTROL */
      case 0x0016:
	return((CHAR)(0x32 & 0xff));	/* SYNCHRONOUS IDLE */
      case 0x0093:
	return((CHAR)(0x33 & 0xff));	/* CONTROL */
      case 0x0094:
	return((CHAR)(0x34 & 0xff));	/* CONTROL */
      case 0x0095:
	return((CHAR)(0x35 & 0xff));	/* CONTROL */
      case 0x0096:
	return((CHAR)(0x36 & 0xff));	/* CONTROL */
      case 0x0004:
	return((CHAR)(0x37 & 0xff));	/* END OF TRANSMISSION */
      case 0x0098:
	return((CHAR)(0x38 & 0xff));	/* CONTROL */
      case 0x0099:
	return((CHAR)(0x39 & 0xff));	/* CONTROL */
      case 0x009A:
	return((CHAR)(0x3A & 0xff));	/* CONTROL */
      case 0x009B:
	return((CHAR)(0x3B & 0xff));	/* CONTROL */
      case 0x0014:
	return((CHAR)(0x3C & 0xff));	/* DEVICE CONTROL FOUR */
      case 0x0015:
	return((CHAR)(0x3D & 0xff));	/* NEGATIVE ACKNOWLEDGE */
      case 0x009E:
	return((CHAR)(0x3E & 0xff));	/* CONTROL */
      case 0x001A:
	return((CHAR)(0x3F & 0xff));	/* SUBSTITUTE */
      case 0x0020:
	return((CHAR)(0x40 & 0xff));	/* SPACE */
      case 0x00A0:
	return((CHAR)(0x41 & 0xff));	/* NO-BREAK SPACE */
      case 0x00E2:
	return((CHAR)(0x42 & 0xff));	/* SMALL LETTER A WITH CIRCUMFLEX */
      case 0x00E4:
	return((CHAR)(0x43 & 0xff));	/* SMALL LETTER A WITH DIAERESIS */
      case 0x00E0:
	return((CHAR)(0x44 & 0xff));	/* LATIN SMALL LETTER A WITH GRAVE */
      case 0x00E1:
	return((CHAR)(0x45 & 0xff));	/* LATIN SMALL LETTER A WITH ACUTE */
      case 0x00E3:
	return((CHAR)(0x46 & 0xff));	/* LATIN SMALL LETTER A WITH TILDE */
      case 0x00E5:
	return((CHAR)(0x47 & 0xff));	/* SMALL LETTER A WITH RING ABOVE */
      case 0x00E7:
	return((CHAR)(0x48 & 0xff));	/* LATIN SMALL LETTER C WITH CEDILLA */
      case 0x00F1:
	return((CHAR)(0x49 & 0xff));	/* LATIN SMALL LETTER N WITH TILDE */
      case 0x00A2:
	return((CHAR)(0x4A & 0xff));	/* CENT SIGN */
      case 0x002E:
	return((CHAR)(0x4B & 0xff));	/* FULL STOP */
      case 0x003C:
	return((CHAR)(0x4C & 0xff));	/* LESS-THAN SIGN */
      case 0x0028:
	return((CHAR)(0x4D & 0xff));	/* LEFT PARENTHESIS */
      case 0x002B:
	return((CHAR)(0x4E & 0xff));	/* PLUS SIGN */
      case 0x007C:
	return((CHAR)(0x4F & 0xff));	/* VERTICAL LINE */
      case 0x0026:
	return((CHAR)(0x50 & 0xff));	/* AMPERSAND */
      case 0x00E9:
	return((CHAR)(0x51 & 0xff));	/* SMALL LETTER E WITH ACUTE */
      case 0x00EA:
	return((CHAR)(0x52 & 0xff));	/* SMALL LETTER E WITH CIRCUMFLEX */
      case 0x00EB:
	return((CHAR)(0x53 & 0xff));	/* SMALL LETTER E WITH DIAERESIS */
      case 0x00E8:
	return((CHAR)(0x54 & 0xff));	/* LATIN SMALL LETTER E WITH GRAVE */
      case 0x00ED:
	return((CHAR)(0x55 & 0xff));	/* LATIN SMALL LETTER I WITH ACUTE */
      case 0x00EE:
	return((CHAR)(0x56 & 0xff));	/* SMALL LETTER I WITH CIRCUMFLEX */
      case 0x00EF:
	return((CHAR)(0x57 & 0xff));	/* SMALL LETTER I WITH DIAERESIS */
      case 0x00EC:
	return((CHAR)(0x58 & 0xff));	/* LATIN SMALL LETTER I WITH GRAVE */
      case 0x00DF:
	return((CHAR)(0x59 & 0xff));	/* SMALL LETTER SHARP S (GERMAN) */
      case 0x0021:
	return((CHAR)(0x5A & 0xff));	/* EXCLAMATION MARK */
      case 0x0024:
	return((CHAR)(0x5B & 0xff));	/* DOLLAR SIGN */
      case 0x002A:
	return((CHAR)(0x5C & 0xff));	/* ASTERISK */
      case 0x0029:
	return((CHAR)(0x5D & 0xff));	/* RIGHT PARENTHESIS */
      case 0x003B:
	return((CHAR)(0x5E & 0xff));	/* SEMICOLON */
      case 0x00AC:
	return((CHAR)(0x5F & 0xff));	/* NOT SIGN */
      case 0x002D:
	return((CHAR)(0x60 & 0xff));	/* HYPHEN-MINUS */
      case 0x002F:
	return((CHAR)(0x61 & 0xff));	/* SOLIDUS */
      case 0x00C2:
	return((CHAR)(0x62 & 0xff));	/* CAPITAL LETTER A WITH CIRCUMFLEX */
      case 0x00C4:
	return((CHAR)(0x63 & 0xff));	/* CAPITAL LETTER A WITH DIAERESIS */
      case 0x00C0:
	return((CHAR)(0x64 & 0xff));	/* LATIN CAPITAL LETTER A WITH GRAVE */
      case 0x00C1:
	return((CHAR)(0x65 & 0xff));	/* LATIN CAPITAL LETTER A WITH ACUTE */
      case 0x00C3:
	return((CHAR)(0x66 & 0xff));	/* LATIN CAPITAL LETTER A WITH TILDE */
      case 0x00C5:
	return((CHAR)(0x67 & 0xff));	/* CAPITAL LETTER A WITH RING ABOVE */
      case 0x00C7:
	return((CHAR)(0x68 & 0xff));	/* CAPITAL LETTER C WITH CEDILLA */
      case 0x00D1:
	return((CHAR)(0x69 & 0xff));	/* LATIN CAPITAL LETTER N WITH TILDE */
      case 0x00A6:
	return((CHAR)(0x6A & 0xff));	/* BROKEN BAR */
      case 0x002C:
	return((CHAR)(0x6B & 0xff));	/* COMMA */
      case 0x0025:
	return((CHAR)(0x6C & 0xff));	/* PERCENT SIGN */
      case 0x005F:
	return((CHAR)(0x6D & 0xff));	/* LOW LINE */
      case 0x003E:
	return((CHAR)(0x6E & 0xff));	/* GREATER-THAN SIGN */
      case 0x003F:
	return((CHAR)(0x6F & 0xff));	/* QUESTION MARK */
      case 0x00F8:
	return((CHAR)(0x70 & 0xff));	/* LATIN SMALL LETTER O WITH STROKE */
      case 0x00C9:
	return((CHAR)(0x71 & 0xff));	/* LATIN CAPITAL LETTER E WITH ACUTE */
      case 0x00CA:
	/* LATIN CAPITAL LETTER E WITH CIRCUMFLEX */
	return((CHAR)(0x72 & 0xff));
      case 0x00CB:
	/* LATIN CAPITAL LETTER E WITH DIAERESIS */
	return((CHAR)(0x73 & 0xff));
      case 0x00C8:
	return((CHAR)(0x74 & 0xff));	/* LATIN CAPITAL LETTER E WITH GRAVE */
      case 0x00CD:
	return((CHAR)(0x75 & 0xff));	/* LATIN CAPITAL LETTER I WITH ACUTE */
      case 0x00CE:
	/* LATIN CAPITAL LETTER I WITH CIRCUMFLEX */
	return((CHAR)(0x76 & 0xff));
      case 0x00CF:
	/* LATIN CAPITAL LETTER I WITH DIAERESIS */
	return((CHAR)(0x77 & 0xff));
      case 0x00CC:
	return((CHAR)(0x78 & 0xff));	/* LATIN CAPITAL LETTER I WITH GRAVE */
      case 0x0060:
	return((CHAR)(0x79 & 0xff));	/* GRAVE ACCENT */
      case 0x003A:
	return((CHAR)(0x7A & 0xff));	/* COLON */
      case 0x0023:
	return((CHAR)(0x7B & 0xff));	/* NUMBER SIGN */
      case 0x0040:
	return((CHAR)(0x7C & 0xff));	/* COMMERCIAL AT */
      case 0x0027:
	return((CHAR)(0x7D & 0xff));	/* APOSTROPHE */
      case 0x003D:
	return((CHAR)(0x7E & 0xff));	/* EQUALS SIGN */
      case 0x0022:
	return((CHAR)(0x7F & 0xff));	/* QUOTATION MARK */
      case 0x00D8:
	/* LATIN CAPITAL LETTER O WITH STROKE */
	return((CHAR)(0x80 & 0xff));
      case 0x0061:
	return((CHAR)(0x81 & 0xff));	/* LATIN SMALL LETTER A */
      case 0x0062:
	return((CHAR)(0x82 & 0xff));	/* LATIN SMALL LETTER B */
      case 0x0063:
	return((CHAR)(0x83 & 0xff));	/* LATIN SMALL LETTER C */
      case 0x0064:
	return((CHAR)(0x84 & 0xff));	/* LATIN SMALL LETTER D */
      case 0x0065:
	return((CHAR)(0x85 & 0xff));	/* LATIN SMALL LETTER E */
      case 0x0066:
	return((CHAR)(0x86 & 0xff));	/* LATIN SMALL LETTER F */
      case 0x0067:
	return((CHAR)(0x87 & 0xff));	/* LATIN SMALL LETTER G */
      case 0x0068:
	return((CHAR)(0x88 & 0xff));	/* LATIN SMALL LETTER H */
      case 0x0069:
	return((CHAR)(0x89 & 0xff));	/* LATIN SMALL LETTER I */
      case 0x00AB:
	/* LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */
	return((CHAR)(0x8A & 0xff));
      case 0x00BB:
	/* RIGHT-POINTING DOUBLE ANGLE QUOTATION MAR K*/
	return((CHAR)(0x8B & 0xff));
      case 0x00F0:
	/* LATIN SMALL LETTER ETH (ICELANDIC) */
	return((CHAR)(0x8C & 0xff));
      case 0x00FD:
	return((CHAR)(0x8D & 0xff));	/* LATIN SMALL LETTER Y WITH ACUTE */
      case 0x00FE:
	/* LATIN SMALL LETTER THORN (ICELANDIC) */
	return((CHAR)(0x8E & 0xff));
      case 0x00B1:
	return((CHAR)(0x8F & 0xff));	/* PLUS-MINUS SIGN */
      case 0x00B0:
	return((CHAR)(0x90 & 0xff));	/* DEGREE SIGN */
      case 0x006A:
	return((CHAR)(0x91 & 0xff));	/* LATIN SMALL LETTER J */
      case 0x006B:
	return((CHAR)(0x92 & 0xff));	/* LATIN SMALL LETTER K */
      case 0x006C:
	return((CHAR)(0x93 & 0xff));	/* LATIN SMALL LETTER L */
      case 0x006D:
	return((CHAR)(0x94 & 0xff));	/* LATIN SMALL LETTER M */
      case 0x006E:
	return((CHAR)(0x95 & 0xff));	/* LATIN SMALL LETTER N */
      case 0x006F:
	return((CHAR)(0x96 & 0xff));	/* LATIN SMALL LETTER O */
      case 0x0070:
	return((CHAR)(0x97 & 0xff));	/* LATIN SMALL LETTER P */
      case 0x0071:
	return((CHAR)(0x98 & 0xff));	/* LATIN SMALL LETTER Q */
      case 0x0072:
	return((CHAR)(0x99 & 0xff));	/* LATIN SMALL LETTER R */
      case 0x00AA:
	return((CHAR)(0x9A & 0xff));	/* FEMININE ORDINAL INDICATOR */
      case 0x00BA:
	return((CHAR)(0x9B & 0xff));	/* MASCULINE ORDINAL INDICATOR */
      case 0x00E6:
	return((CHAR)(0x9C & 0xff));	/* LATIN SMALL LIGATURE AE */
      case 0x00B8:
	return((CHAR)(0x9D & 0xff));	/* CEDILLA */
      case 0x00C6:
	return((CHAR)(0x9E & 0xff));	/* LATIN CAPITAL LIGATURE AE */
      case 0x00A4:
	return((CHAR)(0x9F & 0xff));	/* CURRENCY SIGN */
      case 0x00B5:
	return((CHAR)(0xA0 & 0xff));	/* MICRO SIGN */
      case 0x007E:
	return((CHAR)(0xA1 & 0xff));	/* TILDE */
      case 0x0073:
	return((CHAR)(0xA2 & 0xff));	/* LATIN SMALL LETTER S */
      case 0x0074:
	return((CHAR)(0xA3 & 0xff));	/* LATIN SMALL LETTER T */
      case 0x0075:
	return((CHAR)(0xA4 & 0xff));	/* LATIN SMALL LETTER U */
      case 0x0076:
	return((CHAR)(0xA5 & 0xff));	/* LATIN SMALL LETTER V */
      case 0x0077:
	return((CHAR)(0xA6 & 0xff));	/* LATIN SMALL LETTER W */
      case 0x0078:
	return((CHAR)(0xA7 & 0xff));	/* LATIN SMALL LETTER X */
      case 0x0079:
	return((CHAR)(0xA8 & 0xff));	/* LATIN SMALL LETTER Y */
      case 0x007A:
	return((CHAR)(0xA9 & 0xff));	/* LATIN SMALL LETTER Z */
      case 0x00A1:
	return((CHAR)(0xAA & 0xff));	/* INVERTED EXCLAMATION MARK */
      case 0x00BF:
	return((CHAR)(0xAB & 0xff));	/* INVERTED QUESTION MARK */
      case 0x00D0:
	/* LATIN CAPITAL LETTER ETH (ICELANDIC) */
	return((CHAR)(0xAC & 0xff));
      case 0x00DD:
	return((CHAR)(0xAD & 0xff));	/* LATIN CAPITAL LETTER Y WITH ACUTE */
      case 0x00DE:
	/* LATIN CAPITAL LETTER THORN (ICELANDIC) */
	return((CHAR)(0xAE & 0xff));
      case 0x00AE:
	return((CHAR)(0xAF & 0xff));	/* REGISTERED SIGN */
      case 0x005E:
	return((CHAR)(0xB0 & 0xff));	/* CIRCUMFLEX ACCENT */
      case 0x00A3:
	return((CHAR)(0xB1 & 0xff));	/* POUND SIGN */
      case 0x00A5:
	return((CHAR)(0xB2 & 0xff));	/* YEN SIGN */
      case 0x00B7:
	return((CHAR)(0xB3 & 0xff));	/* MIDDLE DOT */
      case 0x00A9:
	return((CHAR)(0xB4 & 0xff));	/* COPYRIGHT SIGN */
      case 0x00A7:
	return((CHAR)(0xB5 & 0xff));	/* SECTION SIGN */
      case 0x00B6:
	return((CHAR)(0xB6 & 0xff));	/* PILCROW SIGN */
      case 0x00BC:
	return((CHAR)(0xB7 & 0xff));	/* VULGAR FRACTION ONE QUARTER */
      case 0x00BD:
	return((CHAR)(0xB8 & 0xff));	/* VULGAR FRACTION ONE HALF */
      case 0x00BE:
	return((CHAR)(0xB9 & 0xff));	/* VULGAR FRACTION THREE QUARTERS */
      case 0x005B:
	return((CHAR)(0xBA & 0xff));	/* LEFT SQUARE BRACKET */
      case 0x005D:
	return((CHAR)(0xBB & 0xff));	/* RIGHT SQUARE BRACKET */
      case 0x00AF:
	return((CHAR)(0xBC & 0xff));	/* MACRON */
      case 0x00A8:
	return((CHAR)(0xBD & 0xff));	/* DIAERESIS */
      case 0x00B4:
	return((CHAR)(0xBE & 0xff));	/* ACUTE ACCENT */
      case 0x00D7:
	return((CHAR)(0xBF & 0xff));	/* MULTIPLICATION SIGN */
      case 0x007B:
	return((CHAR)(0xC0 & 0xff));	/* LEFT CURLY BRACKET */
      case 0x0041:
	return((CHAR)(0xC1 & 0xff));	/* LATIN CAPITAL LETTER A */
      case 0x0042:
	return((CHAR)(0xC2 & 0xff));	/* LATIN CAPITAL LETTER B */
      case 0x0043:
	return((CHAR)(0xC3 & 0xff));	/* LATIN CAPITAL LETTER C */
      case 0x0044:
	return((CHAR)(0xC4 & 0xff));	/* LATIN CAPITAL LETTER D */
      case 0x0045:
	return((CHAR)(0xC5 & 0xff));	/* LATIN CAPITAL LETTER E */
      case 0x0046:
	return((CHAR)(0xC6 & 0xff));	/* LATIN CAPITAL LETTER F */
      case 0x0047:
	return((CHAR)(0xC7 & 0xff));	/* LATIN CAPITAL LETTER G */
      case 0x0048:
	return((CHAR)(0xC8 & 0xff));	/* LATIN CAPITAL LETTER H */
      case 0x0049:
	return((CHAR)(0xC9 & 0xff));	/* LATIN CAPITAL LETTER I */
      case 0x00AD:
	return((CHAR)(0xCA & 0xff));	/* SOFT HYPHEN */
      case 0x00F4:
	return((CHAR)(0xCB & 0xff));	/* SMALL LETTER O WITH CIRCUMFLEX */
      case 0x00F6:
	return((CHAR)(0xCC & 0xff));	/* SMALL LETTER O WITH DIAERESIS */
      case 0x00F2:
	return((CHAR)(0xCD & 0xff));	/* LATIN SMALL LETTER O WITH GRAVE */
      case 0x00F3:
	return((CHAR)(0xCE & 0xff));	/* LATIN SMALL LETTER O WITH ACUTE */
      case 0x00F5:
	return((CHAR)(0xCF & 0xff));	/* LATIN SMALL LETTER O WITH TILDE */
      case 0x007D:
	return((CHAR)(0xD0 & 0xff));	/* RIGHT CURLY BRACKET */
      case 0x004A:
	return((CHAR)(0xD1 & 0xff));	/* LATIN CAPITAL LETTER J */
      case 0x004B:
	return((CHAR)(0xD2 & 0xff));	/* LATIN CAPITAL LETTER K */
      case 0x004C:
	return((CHAR)(0xD3 & 0xff));	/* LATIN CAPITAL LETTER L */
      case 0x004D:
	return((CHAR)(0xD4 & 0xff));	/* LATIN CAPITAL LETTER M */
      case 0x004E:
	return((CHAR)(0xD5 & 0xff));	/* LATIN CAPITAL LETTER N */
      case 0x004F:
	return((CHAR)(0xD6 & 0xff));	/* LATIN CAPITAL LETTER O */
      case 0x0050:
	return((CHAR)(0xD7 & 0xff));	/* LATIN CAPITAL LETTER P */
      case 0x0051:
	return((CHAR)(0xD8 & 0xff));	/* LATIN CAPITAL LETTER Q */
      case 0x0052:
	return((CHAR)(0xD9 & 0xff));	/* LATIN CAPITAL LETTER R */
      case 0x00B9:
	return((CHAR)(0xDA & 0xff));	/* SUPERSCRIPT ONE */
      case 0x00FB:
	return((CHAR)(0xDB & 0xff));	/* SMALL LETTER U WITH CIRCUMFLEX */
      case 0x00FC:
	return((CHAR)(0xDC & 0xff));	/* SMALL LETTER U WITH DIAERESIS */
      case 0x00F9:
	return((CHAR)(0xDD & 0xff));	/* SMALL LETTER U WITH GRAVE */
      case 0x00FA:
	return((CHAR)(0xDE & 0xff));	/* SMALL LETTER U WITH ACUTE */
      case 0x00FF:
	return((CHAR)(0xDF & 0xff));	/* SMALL LETTER Y WITH DIAERESIS */
      case 0x005C:
	return((CHAR)(0xE0 & 0xff));	/* REVERSE SOLIDUS */
      case 0x00F7:
	return((CHAR)(0xE1 & 0xff));	/* DIVISION SIGN */
      case 0x0053:
	return((CHAR)(0xE2 & 0xff));	/* LATIN CAPITAL LETTER S */
      case 0x0054:
	return((CHAR)(0xE3 & 0xff));	/* LATIN CAPITAL LETTER T */
      case 0x0055:
	return((CHAR)(0xE4 & 0xff));	/* LATIN CAPITAL LETTER U */
      case 0x0056:
	return((CHAR)(0xE5 & 0xff));	/* LATIN CAPITAL LETTER V */
      case 0x0057:
	return((CHAR)(0xE6 & 0xff));	/* LATIN CAPITAL LETTER W */
      case 0x0058:
	return((CHAR)(0xE7 & 0xff));	/* LATIN CAPITAL LETTER X */
      case 0x0059:
	return((CHAR)(0xE8 & 0xff));	/* LATIN CAPITAL LETTER Y */
      case 0x005A:
	return((CHAR)(0xE9 & 0xff));	/* LATIN CAPITAL LETTER Z */
      case 0x00B2:
	return((CHAR)(0xEA & 0xff));	/* SUPERSCRIPT TWO */
      case 0x00D4:
	return((CHAR)(0xEB & 0xff));	/* CAPITAL LETTER O WITH CIRCUMFLEX */
      case 0x00D6:
	return((CHAR)(0xEC & 0xff));	/* CAPITAL LETTER O WITH DIAERESIS */
      case 0x00D2:
	return((CHAR)(0xED & 0xff));	/* CAPITAL LETTER O WITH GRAVE */
      case 0x00D3:
	return((CHAR)(0xEE & 0xff));	/* CAPITAL LETTER O WITH ACUTE */
      case 0x00D5:
	return((CHAR)(0xEF & 0xff));	/* CAPITAL LETTER O WITH TILDE */
      case 0x0030:
	return((CHAR)(0xF0 & 0xff));	/* DIGIT ZERO */
      case 0x0031:
	return((CHAR)(0xF1 & 0xff));	/* DIGIT ONE */
      case 0x0032:
	return((CHAR)(0xF2 & 0xff));	/* DIGIT TWO */
      case 0x0033:
	return((CHAR)(0xF3 & 0xff));	/* DIGIT THREE */
      case 0x0034:
	return((CHAR)(0xF4 & 0xff));	/* DIGIT FOUR */
      case 0x0035:
	return((CHAR)(0xF5 & 0xff));	/* DIGIT FIVE */
      case 0x0036:
	return((CHAR)(0xF6 & 0xff));	/* DIGIT SIX */
      case 0x0037:
	return((CHAR)(0xF7 & 0xff));	/* DIGIT SEVEN */
      case 0x0038:
	return((CHAR)(0xF8 & 0xff));	/* DIGIT EIGHT */
      case 0x0039:
	return((CHAR)(0xF9 & 0xff));	/* DIGIT NINE */
      case 0x00B3:
	return((CHAR)(0xFA & 0xff));	/* SUPERSCRIPT THREE */
      case 0x00DB:
	return((CHAR)(0xFB & 0xff));	/* CAPITAL LETTER U WITH CIRCUMFLEX */
      case 0x00DC:
	return((CHAR)(0xFC & 0xff));	/* CAPITAL LETTER U WITH DIAERESIS */
      case 0x00D9:
	return((CHAR)(0xFD & 0xff));	/* LATIN CAPITAL LETTER U WITH GRAVE */
      case 0x00DA:
	return((CHAR)(0xFE & 0xff));	/* LATIN CAPITAL LETTER U WITH ACUTE */
      case 0x009F:
	return((CHAR)(0xFF & 0xff));	/* CONTROL */
    default: return(0x003f);
    }
}


int					/* PC Code Page 855 */
#ifdef CK_ANSIC
tx_cp855(USHORT c)
#else
tx_cp855(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x00a4: return((CHAR)(207 & 0xff));
      case 0x00a7: return((CHAR)(253 & 0xff));
      case 0x00ab: return((CHAR)(174 & 0xff));
      case 0x00bb: return((CHAR)(175 & 0xff));
      case 0x0401: return((CHAR)(133 & 0xff));
      case 0x0402: return((CHAR)(129 & 0xff));
      case 0x0403: return((CHAR)(131 & 0xff));
      case 0x0404: return((CHAR)(135 & 0xff));
      case 0x0405: return((CHAR)(137 & 0xff));
      case 0x0406: return((CHAR)(139 & 0xff));
      case 0x0407: return((CHAR)(141 & 0xff));
      case 0x0408: return((CHAR)(143 & 0xff));
      case 0x0409: return((CHAR)(145 & 0xff));
      case 0x040a: return((CHAR)(147 & 0xff));
      case 0x040b: return((CHAR)(149 & 0xff));
      case 0x040c: return((CHAR)(151 & 0xff));
      case 0x040e: return((CHAR)(153 & 0xff));
      case 0x040f: return((CHAR)(155 & 0xff));
      case 0x0410: return((CHAR)(161 & 0xff));
      case 0x0411: return((CHAR)(163 & 0xff));
      case 0x0412: return((CHAR)(236 & 0xff));
      case 0x0413: return((CHAR)(173 & 0xff));
      case 0x0414: return((CHAR)(167 & 0xff));
      case 0x0415: return((CHAR)(169 & 0xff));
      case 0x0416: return((CHAR)(234 & 0xff));
      case 0x0417: return((CHAR)(244 & 0xff));
      case 0x0418: return((CHAR)(184 & 0xff));
      case 0x0419: return((CHAR)(190 & 0xff));
      case 0x041a: return((CHAR)(199 & 0xff));
      case 0x041b: return((CHAR)(209 & 0xff));
      case 0x041c: return((CHAR)(211 & 0xff));
      case 0x041d: return((CHAR)(213 & 0xff));
      case 0x041e: return((CHAR)(215 & 0xff));
      case 0x041f: return((CHAR)(221 & 0xff));
      case 0x0420: return((CHAR)(226 & 0xff));
      case 0x0421: return((CHAR)(228 & 0xff));
      case 0x0422: return((CHAR)(230 & 0xff));
      case 0x0423: return((CHAR)(232 & 0xff));
      case 0x0424: return((CHAR)(171 & 0xff));
      case 0x0425: return((CHAR)(182 & 0xff));
      case 0x0426: return((CHAR)(165 & 0xff));
      case 0x0427: return((CHAR)(252 & 0xff));
      case 0x0428: return((CHAR)(246 & 0xff));
      case 0x0429: return((CHAR)(250 & 0xff));
      case 0x042a: return((CHAR)(159 & 0xff));
      case 0x042b: return((CHAR)(242 & 0xff));
      case 0x042c: return((CHAR)(238 & 0xff));
      case 0x042d: return((CHAR)(248 & 0xff));
      case 0x042e: return((CHAR)(157 & 0xff));
      case 0x042f: return((CHAR)(224 & 0xff));
      case 0x0430: return((CHAR)(160 & 0xff));
      case 0x0431: return((CHAR)(162 & 0xff));
      case 0x0432: return((CHAR)(235 & 0xff));
      case 0x0433: return((CHAR)(172 & 0xff));
      case 0x0434: return((CHAR)(166 & 0xff));
      case 0x0435: return((CHAR)(168 & 0xff));
      case 0x0436: return((CHAR)(233 & 0xff));
      case 0x0437: return((CHAR)(243 & 0xff));
      case 0x0438: return((CHAR)(183 & 0xff));
      case 0x0439: return((CHAR)(189 & 0xff));
      case 0x043a: return((CHAR)(198 & 0xff));
      case 0x043b: return((CHAR)(208 & 0xff));
      case 0x043c: return((CHAR)(210 & 0xff));
      case 0x043d: return((CHAR)(212 & 0xff));
      case 0x043e: return((CHAR)(214 & 0xff));
      case 0x043f: return((CHAR)(216 & 0xff));
      case 0x0440: return((CHAR)(225 & 0xff));
      case 0x0441: return((CHAR)(227 & 0xff));
      case 0x0442: return((CHAR)(229 & 0xff));
      case 0x0443: return((CHAR)(231 & 0xff));
      case 0x0444: return((CHAR)(170 & 0xff));
      case 0x0445: return((CHAR)(181 & 0xff));
      case 0x0446: return((CHAR)(164 & 0xff));
      case 0x0447: return((CHAR)(251 & 0xff));
      case 0x0448: return((CHAR)(245 & 0xff));
      case 0x0449: return((CHAR)(249 & 0xff));
      case 0x044a: return((CHAR)(158 & 0xff));
      case 0x044b: return((CHAR)(241 & 0xff));
      case 0x044c: return((CHAR)(237 & 0xff));
      case 0x044d: return((CHAR)(247 & 0xff));
      case 0x044e: return((CHAR)(156 & 0xff));
      case 0x044f: return((CHAR)(222 & 0xff));
      case 0x0451: return((CHAR)(132 & 0xff));
      case 0x0452: return((CHAR)(128 & 0xff));
      case 0x0453: return((CHAR)(130 & 0xff));
      case 0x0454: return((CHAR)(134 & 0xff));
      case 0x0455: return((CHAR)(136 & 0xff));
      case 0x0456: return((CHAR)(138 & 0xff));
      case 0x0457: return((CHAR)(140 & 0xff));
      case 0x0458: return((CHAR)(142 & 0xff));
      case 0x0459: return((CHAR)(144 & 0xff));
      case 0x045a: return((CHAR)(146 & 0xff));
      case 0x045b: return((CHAR)(148 & 0xff));
      case 0x045c: return((CHAR)(150 & 0xff));
      case 0x045e: return((CHAR)(152 & 0xff));
      case 0x045f: return((CHAR)(154 & 0xff));
      case 0x2116: return((CHAR)(239 & 0xff));
      case 0x2500: return((CHAR)(196 & 0xff));
      case 0x2502: return((CHAR)(179 & 0xff));
      case 0x250c: return((CHAR)(218 & 0xff));
      case 0x2510: return((CHAR)(191 & 0xff));
      case 0x2514: return((CHAR)(192 & 0xff));
      case 0x2518: return((CHAR)(217 & 0xff));
      case 0x251c: return((CHAR)(195 & 0xff));
      case 0x2524: return((CHAR)(180 & 0xff));
      case 0x252c: return((CHAR)(194 & 0xff));
      case 0x2534: return((CHAR)(193 & 0xff));
      case 0x253c: return((CHAR)(197 & 0xff));
      case 0x2550: return((CHAR)(205 & 0xff));
      case 0x2551: return((CHAR)(186 & 0xff));
      case 0x2554: return((CHAR)(201 & 0xff));
      case 0x2557: return((CHAR)(187 & 0xff));
      case 0x255a: return((CHAR)(200 & 0xff));
      case 0x255d: return((CHAR)(188 & 0xff));
      case 0x2560: return((CHAR)(204 & 0xff));
      case 0x2563: return((CHAR)(185 & 0xff));
      case 0x2566: return((CHAR)(203 & 0xff));
      case 0x2569: return((CHAR)(202 & 0xff));
      case 0x256c: return((CHAR)(206 & 0xff));
      case 0x2580: return((CHAR)(223 & 0xff));
      case 0x2584: return((CHAR)(220 & 0xff));
      case 0x2588: return((CHAR)(219 & 0xff));
      case 0x2591: return((CHAR)(176 & 0xff));
      case 0x2592: return((CHAR)(177 & 0xff));
      case 0x2593: return((CHAR)(178 & 0xff));
      case 0x25a0: return((CHAR)(254 & 0xff));
      default: return(tx_cpsub(c));	/* For box characters etc */
    }
}

int					/* PC Code Page 856 */
#ifdef CK_ANSIC
tx_cp856(USHORT c)
#else
tx_cp856(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x00a0: return((CHAR)(0xff & 0xff));
      case 0x00a7: return((CHAR)(0xd6 & 0xff));
      case 0x00b0: return((CHAR)(0xf8 & 0xff));
      case 0x00b1: return((CHAR)(0xf1 & 0xff));
      case 0x00b2: return((CHAR)(0xfd & 0xff));
      case 0x00b5: return((CHAR)(0xe6 & 0xff));
      case 0x00b7: return((CHAR)(0xfa & 0xff));
      case 0x00df: return((CHAR)(0xe1 & 0xff));
      case 0x00f7: return((CHAR)(0xf6 & 0xff));
      case 0x0393: return((CHAR)(0xe2 & 0xff));
      case 0x0398: return((CHAR)(0xe9 & 0xff));
      case 0x03a3: return((CHAR)(0xe4 & 0xff));
      case 0x03a6: return((CHAR)(0xe8 & 0xff));
      case 0x03a9: return((CHAR)(0xea & 0xff));
      case 0x03b1: return((CHAR)(0xe0 & 0xff));
      case 0x03b4: return((CHAR)(0xeb & 0xff));
      case 0x03b5: return((CHAR)(0xee & 0xff));
      case 0x03c0: return((CHAR)(0xe3 & 0xff));
      case 0x03c3: return((CHAR)(0xe5 & 0xff));
      case 0x03c4: return((CHAR)(0xe7 & 0xff));
      case 0x03c6: return((CHAR)(0xed & 0xff));
      case 0x0410: return((CHAR)(0x80 & 0xff));
      case 0x0411: return((CHAR)(0x81 & 0xff));
      case 0x0412: return((CHAR)(0x82 & 0xff));
      case 0x0413: return((CHAR)(0x83 & 0xff));
      case 0x0414: return((CHAR)(0x84 & 0xff));
      case 0x0415: return((CHAR)(0x85 & 0xff));
      case 0x0416: return((CHAR)(0x86 & 0xff));
      case 0x0417: return((CHAR)(0x87 & 0xff));
      case 0x0418: return((CHAR)(0x88 & 0xff));
      case 0x0419: return((CHAR)(0x89 & 0xff));
      case 0x041a: return((CHAR)(0x8a & 0xff));
      case 0x041b: return((CHAR)(0x8b & 0xff));
      case 0x041c: return((CHAR)(0x8c & 0xff));
      case 0x041d: return((CHAR)(0x8d & 0xff));
      case 0x041e: return((CHAR)(0x8e & 0xff));
      case 0x041f: return((CHAR)(0x8f & 0xff));
      case 0x0420: return((CHAR)(0x90 & 0xff));
      case 0x0421: return((CHAR)(0x91 & 0xff));
      case 0x0422: return((CHAR)(0x92 & 0xff));
      case 0x0423: return((CHAR)(0x93 & 0xff));
      case 0x0424: return((CHAR)(0x94 & 0xff));
      case 0x0425: return((CHAR)(0x95 & 0xff));
      case 0x0426: return((CHAR)(0x96 & 0xff));
      case 0x0427: return((CHAR)(0x97 & 0xff));
      case 0x0428: return((CHAR)(0x98 & 0xff));
      case 0x0429: return((CHAR)(0x99 & 0xff));
      case 0x042a: return((CHAR)(0x9a & 0xff));
      case 0x042b: return((CHAR)(0x9b & 0xff));
      case 0x042c: return((CHAR)(0x9c & 0xff));
      case 0x042d: return((CHAR)(0x9d & 0xff));
      case 0x042e: return((CHAR)(0x9e & 0xff));
      case 0x042f: return((CHAR)(0x9f & 0xff));
      case 0x0430: return((CHAR)(0xa0 & 0xff));
      case 0x0431: return((CHAR)(0xa1 & 0xff));
      case 0x0432: return((CHAR)(0xa2 & 0xff));
      case 0x0433: return((CHAR)(0xa3 & 0xff));
      case 0x0434: return((CHAR)(0xa4 & 0xff));
      case 0x0435: return((CHAR)(0xa5 & 0xff));
      case 0x0436: return((CHAR)(0xa6 & 0xff));
      case 0x0437: return((CHAR)(0xa7 & 0xff));
      case 0x0438: return((CHAR)(0xa8 & 0xff));
      case 0x0439: return((CHAR)(0xa9 & 0xff));
      case 0x043a: return((CHAR)(0xaa & 0xff));
      case 0x043b: return((CHAR)(0xab & 0xff));
      case 0x043c: return((CHAR)(0xac & 0xff));
      case 0x043d: return((CHAR)(0xad & 0xff));
      case 0x043e: return((CHAR)(0xae & 0xff));
      case 0x043f: return((CHAR)(0xaf & 0xff));
      case 0x0440: return((CHAR)(0xb0 & 0xff));
      case 0x0441: return((CHAR)(0xb1 & 0xff));
      case 0x0442: return((CHAR)(0xb2 & 0xff));
      case 0x0443: return((CHAR)(0xb3 & 0xff));
      case 0x0444: return((CHAR)(0xb4 & 0xff));
      case 0x0445: return((CHAR)(0xb5 & 0xff));
      case 0x0446: return((CHAR)(0xb6 & 0xff));
      case 0x0447: return((CHAR)(0xb7 & 0xff));
      case 0x0448: return((CHAR)(0xb8 & 0xff));
      case 0x0449: return((CHAR)(0xb9 & 0xff));
      case 0x044a: return((CHAR)(0xba & 0xff));
      case 0x044b: return((CHAR)(0xbb & 0xff));
      case 0x044c: return((CHAR)(0xbc & 0xff));
      case 0x044d: return((CHAR)(0xbd & 0xff));
      case 0x044e: return((CHAR)(0xbe & 0xff));
      case 0x044f: return((CHAR)(0xbf & 0xff));
      case 0x207f: return((CHAR)(0xfc & 0xff));
      case 0x2116: return((CHAR)(0xd5 & 0xff));
      case 0x2219: return((CHAR)(0xf9 & 0xff));
      case 0x221a: return((CHAR)(0xfb & 0xff));
      case 0x221e: return((CHAR)(0xec & 0xff));
      case 0x2229: return((CHAR)(0xef & 0xff));
      case 0x2248: return((CHAR)(0xf7 & 0xff));
      case 0x2261: return((CHAR)(0xf0 & 0xff));
      case 0x2264: return((CHAR)(0xf3 & 0xff));
      case 0x2265: return((CHAR)(0xf2 & 0xff));
      case 0x2320: return((CHAR)(0xf4 & 0xff));
      case 0x2321: return((CHAR)(0xf5 & 0xff));
      case 0x2500: return((CHAR)(0xc4 & 0xff));
      case 0x2502: return((CHAR)(0xd3 & 0xff));
      case 0x250c: return((CHAR)(0xda & 0xff));
      case 0x2510: return((CHAR)(0xcf & 0xff));
      case 0x2514: return((CHAR)(0xc0 & 0xff));
      case 0x2518: return((CHAR)(0xd9 & 0xff));
      case 0x251c: return((CHAR)(0xc3 & 0xff));
      case 0x2524: return((CHAR)(0xd4 & 0xff));
      case 0x252c: return((CHAR)(0xc2 & 0xff));
      case 0x2534: return((CHAR)(0xc1 & 0xff));
      case 0x253c: return((CHAR)(0xc5 & 0xff));
      case 0x2550: return((CHAR)(0xcd & 0xff));
      case 0x2551: return((CHAR)(0xc7 & 0xff));
      case 0x2554: return((CHAR)(0xc9 & 0xff));
      case 0x2557: return((CHAR)(0xd7 & 0xff));
      case 0x255a: return((CHAR)(0xc8 & 0xff));
      case 0x255d: return((CHAR)(0xd8 & 0xff));
      case 0x2560: return((CHAR)(0xcc & 0xff));
      case 0x2563: return((CHAR)(0xc6 & 0xff));
      case 0x2566: return((CHAR)(0xcb & 0xff));
      case 0x2569: return((CHAR)(0xca & 0xff));
      case 0x256c: return((CHAR)(0xce & 0xff));
      case 0x2580: return((CHAR)(0xdf & 0xff));
      case 0x2584: return((CHAR)(0xdc & 0xff));
      case 0x2588: return((CHAR)(0xdb & 0xff));
      case 0x258c: return((CHAR)(0xdd & 0xff));
      case 0x2590: return((CHAR)(0xde & 0xff));
      case 0x2591: return((CHAR)(0xd0 & 0xff));
      case 0x2592: return((CHAR)(0xd1 & 0xff));
      case 0x2593: return((CHAR)(0xd2 & 0xff));
      case 0x25a0: return((CHAR)(0xfe & 0xff));
      default: return(tx_cpsub(c));	/* For box characters etc */
    }
}

int					/* PC Code Page 857 */
#ifdef CK_ANSIC
tx_cp857(USHORT c)
#else
tx_cp857(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x00c7: return((CHAR)(128 & 0xff));
      case 0x00fc: return((CHAR)(129 & 0xff));
      case 0x00e9: return((CHAR)(130 & 0xff));
      case 0x00e2: return((CHAR)(131 & 0xff));
      case 0x00e4: return((CHAR)(132 & 0xff));
      case 0x00e0: return((CHAR)(133 & 0xff));
      case 0x00e5: return((CHAR)(134 & 0xff));
      case 0x00e7: return((CHAR)(135 & 0xff));
      case 0x00ea: return((CHAR)(136 & 0xff));
      case 0x00eb: return((CHAR)(137 & 0xff));
      case 0x00e8: return((CHAR)(138 & 0xff));
      case 0x00ef: return((CHAR)(139 & 0xff));
      case 0x00ee: return((CHAR)(140 & 0xff));
      case 0x0131: return((CHAR)(141 & 0xff));
      case 0x00c4: return((CHAR)(142 & 0xff));
      case 0x00c5: return((CHAR)(143 & 0xff));
      case 0x00c9: return((CHAR)(144 & 0xff));
      case 0x00e6: return((CHAR)(145 & 0xff));
      case 0x00c6: return((CHAR)(146 & 0xff));
      case 0x00f4: return((CHAR)(147 & 0xff));
      case 0x00f6: return((CHAR)(148 & 0xff));
      case 0x00f2: return((CHAR)(149 & 0xff));
      case 0x00fb: return((CHAR)(150 & 0xff));
      case 0x00f9: return((CHAR)(151 & 0xff));
      case 0x0130: return((CHAR)(152 & 0xff));
      case 0x00d6: return((CHAR)(153 & 0xff));
      case 0x00dc: return((CHAR)(154 & 0xff));
      case 0x00f8: return((CHAR)(155 & 0xff));
      case 0x00a3: return((CHAR)(156 & 0xff));
      case 0x00d8: return((CHAR)(157 & 0xff));
      case 0x015e: return((CHAR)(158 & 0xff));
      case 0x015f: return((CHAR)(159 & 0xff));
      case 0x00e1: return((CHAR)(160 & 0xff));
      case 0x00ed: return((CHAR)(161 & 0xff));
      case 0x00f3: return((CHAR)(162 & 0xff));
      case 0x00fa: return((CHAR)(163 & 0xff));
      case 0x00f1: return((CHAR)(164 & 0xff));
      case 0x00d1: return((CHAR)(165 & 0xff));
      case 0x011e: return((CHAR)(166 & 0xff));
      case 0x011f: return((CHAR)(167 & 0xff));
      case 0x00bf: return((CHAR)(168 & 0xff));
      case 0x00ae: return((CHAR)(169 & 0xff));
      case 0x00ac: return((CHAR)(170 & 0xff));
      case 0x00bd: return((CHAR)(171 & 0xff));
      case 0x00bc: return((CHAR)(172 & 0xff));
      case 0x00a1: return((CHAR)(173 & 0xff));
      case 0x00ab: return((CHAR)(174 & 0xff));
      case 0x00bb: return((CHAR)(175 & 0xff));
      case 0x20ac: return((CHAR)(213 & 0xff)); /* Euro */
      case 0x2591: return((CHAR)(176 & 0xff));
      case 0x2592: return((CHAR)(177 & 0xff));
      case 0x2593: return((CHAR)(178 & 0xff));
      case 0x2502: return((CHAR)(179 & 0xff));
      case 0x2524: return((CHAR)(180 & 0xff));
      case 0x00c1: return((CHAR)(181 & 0xff));
      case 0x00c2: return((CHAR)(182 & 0xff));
      case 0x00c0: return((CHAR)(183 & 0xff));
      case 0x00a9: return((CHAR)(184 & 0xff));
      case 0x2563: return((CHAR)(185 & 0xff));
      case 0x2551: return((CHAR)(186 & 0xff));
      case 0x2557: return((CHAR)(187 & 0xff));
      case 0x255d: return((CHAR)(188 & 0xff));
      case 0x00a2: return((CHAR)(189 & 0xff));
      case 0x00a5: return((CHAR)(190 & 0xff));
      case 0x2510: return((CHAR)(191 & 0xff));
      case 0x2514: return((CHAR)(192 & 0xff));
      case 0x2534: return((CHAR)(193 & 0xff));
      case 0x252c: return((CHAR)(194 & 0xff));
      case 0x251c: return((CHAR)(195 & 0xff));
      case 0x2500: return((CHAR)(196 & 0xff));
      case 0x253c: return((CHAR)(197 & 0xff));
      case 0x00e3: return((CHAR)(198 & 0xff));
      case 0x00c3: return((CHAR)(199 & 0xff));
      case 0x255a: return((CHAR)(200 & 0xff));
      case 0x2554: return((CHAR)(201 & 0xff));
      case 0x2569: return((CHAR)(202 & 0xff));
      case 0x2566: return((CHAR)(203 & 0xff));
      case 0x2560: return((CHAR)(204 & 0xff));
      case 0x2550: return((CHAR)(205 & 0xff));
      case 0x256c: return((CHAR)(206 & 0xff));
      case 0x00a4: return((CHAR)(207 & 0xff));
      case 0x00ba: return((CHAR)(208 & 0xff));
      case 0x00aa: return((CHAR)(209 & 0xff));
      case 0x00ca: return((CHAR)(210 & 0xff));
      case 0x00cb: return((CHAR)(211 & 0xff));
      case 0x00c8: return((CHAR)(212 & 0xff));
      case 0x00cd: return((CHAR)(214 & 0xff));
      case 0x00ce: return((CHAR)(215 & 0xff));
      case 0x00cf: return((CHAR)(216 & 0xff));
      case 0x2518: return((CHAR)(217 & 0xff));
      case 0x250c: return((CHAR)(218 & 0xff));
      case 0x2588: return((CHAR)(219 & 0xff));
      case 0x2584: return((CHAR)(220 & 0xff));
      case 0x00a6: return((CHAR)(221 & 0xff));
      case 0x00cc: return((CHAR)(222 & 0xff));
      case 0x2580: return((CHAR)(223 & 0xff));
      case 0x00d3: return((CHAR)(224 & 0xff));
      case 0x00df: return((CHAR)(225 & 0xff));
      case 0x00d4: return((CHAR)(226 & 0xff));
      case 0x00d2: return((CHAR)(227 & 0xff));
      case 0x00f5: return((CHAR)(228 & 0xff));
      case 0x00d5: return((CHAR)(229 & 0xff));
      case 0x00b5: return((CHAR)(230 & 0xff));
      case 0x00d7: return((CHAR)(232 & 0xff));
      case 0x00da: return((CHAR)(233 & 0xff));
      case 0x00db: return((CHAR)(234 & 0xff));
      case 0x00d9: return((CHAR)(235 & 0xff));
      case 0x00ec: return((CHAR)(236 & 0xff));
      case 0x00ff: return((CHAR)(237 & 0xff));
      case 0x00af: return((CHAR)(238 & 0xff));
      case 0x00b4: return((CHAR)(239 & 0xff));
      case 0x00ad: return((CHAR)(240 & 0xff));
      case 0x00b1: return((CHAR)(241 & 0xff));
      case 0x00be: return((CHAR)(243 & 0xff));
      case 0x00b6: return((CHAR)(244 & 0xff));
      case 0x00a7: return((CHAR)(245 & 0xff));
      case 0x00f7: return((CHAR)(246 & 0xff));
      case 0x00b8: return((CHAR)(247 & 0xff));
      case 0x00b0: return((CHAR)(248 & 0xff));
      case 0x00a8: return((CHAR)(249 & 0xff));
      case 0x00b7: return((CHAR)(250 & 0xff));
      case 0x00b9: return((CHAR)(251 & 0xff));
      case 0x00b3: return((CHAR)(252 & 0xff));
      case 0x00b2: return((CHAR)(253 & 0xff));
      case 0x25a0: return((CHAR)(254 & 0xff));
      case 0x00a0: return((CHAR)(255 & 0xff));
      default: return(tx_cpsub(c));	/* For box characters etc */
    }
}

int					/* PC Code Page 862 */
#ifdef CK_ANSIC
tx_cp862(USHORT c)
#else
tx_cp862(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x05d0: return((CHAR)(128 & 0xff));
      case 0x05d1: return((CHAR)(129 & 0xff));
      case 0x05d2: return((CHAR)(130 & 0xff));
      case 0x05d3: return((CHAR)(131 & 0xff));
      case 0x05d4: return((CHAR)(132 & 0xff));
      case 0x05d5: return((CHAR)(133 & 0xff));
      case 0x05d6: return((CHAR)(134 & 0xff));
      case 0x05d7: return((CHAR)(135 & 0xff));
      case 0x05d8: return((CHAR)(136 & 0xff));
      case 0x05d9: return((CHAR)(137 & 0xff));
      case 0x05da: return((CHAR)(138 & 0xff));
      case 0x05db: return((CHAR)(139 & 0xff));
      case 0x05dc: return((CHAR)(140 & 0xff));
      case 0x05dd: return((CHAR)(141 & 0xff));
      case 0x05de: return((CHAR)(142 & 0xff));
      case 0x05df: return((CHAR)(143 & 0xff));
      case 0x05e0: return((CHAR)(144 & 0xff));
      case 0x05e1: return((CHAR)(145 & 0xff));
      case 0x05e2: return((CHAR)(146 & 0xff));
      case 0x05e3: return((CHAR)(147 & 0xff));
      case 0x05e4: return((CHAR)(148 & 0xff));
      case 0x05e5: return((CHAR)(149 & 0xff));
      case 0x05e6: return((CHAR)(150 & 0xff));
      case 0x05e7: return((CHAR)(151 & 0xff));
      case 0x05e8: return((CHAR)(152 & 0xff));
      case 0x05e9: return((CHAR)(153 & 0xff));
      case 0x05ea: return((CHAR)(154 & 0xff));
      case 0x00a2: return((CHAR)(155 & 0xff));
      case 0x00a3: return((CHAR)(156 & 0xff));
      case 0x00a5: return((CHAR)(157 & 0xff));
      case 0x20a7: return((CHAR)(158 & 0xff));
      case 0x0192: return((CHAR)(159 & 0xff));
      case 0x00e1: return((CHAR)(160 & 0xff));
      case 0x00ed: return((CHAR)(161 & 0xff));
      case 0x00f3: return((CHAR)(162 & 0xff));
      case 0x00fa: return((CHAR)(163 & 0xff));
      case 0x00f1: return((CHAR)(164 & 0xff));
      case 0x00d1: return((CHAR)(165 & 0xff));
      case 0x00aa: return((CHAR)(166 & 0xff));
      case 0x00ba: return((CHAR)(167 & 0xff));
      case 0x00bf: return((CHAR)(168 & 0xff));
      case 0x2310: return((CHAR)(169 & 0xff));
      case 0x00ac: return((CHAR)(170 & 0xff));
      case 0x00bd: return((CHAR)(171 & 0xff));
      case 0x00bc: return((CHAR)(172 & 0xff));
      case 0x00a1: return((CHAR)(173 & 0xff));
      case 0x00ab: return((CHAR)(174 & 0xff));
      case 0x00bb: return((CHAR)(175 & 0xff));
      case 0x2591: return((CHAR)(176 & 0xff));
      case 0x2592: return((CHAR)(177 & 0xff));
      case 0x2593: return((CHAR)(178 & 0xff));
      case 0x2502: return((CHAR)(179 & 0xff));
      case 0x2524: return((CHAR)(180 & 0xff));
      case 0x2561: return((CHAR)(181 & 0xff));
      case 0x2562: return((CHAR)(182 & 0xff));
      case 0x2556: return((CHAR)(183 & 0xff));
      case 0x2555: return((CHAR)(184 & 0xff));
      case 0x2563: return((CHAR)(185 & 0xff));
      case 0x2551: return((CHAR)(186 & 0xff));
      case 0x2557: return((CHAR)(187 & 0xff));
      case 0x255d: return((CHAR)(188 & 0xff));
      case 0x255c: return((CHAR)(189 & 0xff));
      case 0x255b: return((CHAR)(190 & 0xff));
      case 0x2510: return((CHAR)(191 & 0xff));
      case 0x2514: return((CHAR)(192 & 0xff));
      case 0x2534: return((CHAR)(193 & 0xff));
      case 0x252c: return((CHAR)(194 & 0xff));
      case 0x251c: return((CHAR)(195 & 0xff));
      case 0x2500: return((CHAR)(196 & 0xff));
      case 0x253c: return((CHAR)(197 & 0xff));
      case 0x255e: return((CHAR)(198 & 0xff));
      case 0x255f: return((CHAR)(199 & 0xff));
      case 0x255a: return((CHAR)(200 & 0xff));
      case 0x2554: return((CHAR)(201 & 0xff));
      case 0x2569: return((CHAR)(202 & 0xff));
      case 0x2566: return((CHAR)(203 & 0xff));
      case 0x2560: return((CHAR)(204 & 0xff));
      case 0x2550: return((CHAR)(205 & 0xff));
      case 0x256c: return((CHAR)(206 & 0xff));
      case 0x2567: return((CHAR)(207 & 0xff));
      case 0x2568: return((CHAR)(208 & 0xff));
      case 0x2564: return((CHAR)(209 & 0xff));
      case 0x2565: return((CHAR)(210 & 0xff));
      case 0x2559: return((CHAR)(211 & 0xff));
      case 0x2558: return((CHAR)(212 & 0xff));
      case 0x2552: return((CHAR)(213 & 0xff));
      case 0x2553: return((CHAR)(214 & 0xff));
      case 0x256b: return((CHAR)(215 & 0xff));
      case 0x256a: return((CHAR)(216 & 0xff));
      case 0x2518: return((CHAR)(217 & 0xff));
      case 0x250c: return((CHAR)(218 & 0xff));
      case 0x2588: return((CHAR)(219 & 0xff));
      case 0x2584: return((CHAR)(220 & 0xff));
      case 0x258c: return((CHAR)(221 & 0xff));
      case 0x2590: return((CHAR)(222 & 0xff));
      case 0x2580: return((CHAR)(223 & 0xff));
      case 0x03b1: return((CHAR)(224 & 0xff));
      case 0x00df: return((CHAR)(225 & 0xff));
      case 0x0393: return((CHAR)(226 & 0xff));
      case 0x03c0: return((CHAR)(227 & 0xff));
      case 0x03a3: return((CHAR)(228 & 0xff));
      case 0x03c3: return((CHAR)(229 & 0xff));
      case 0x00b5: return((CHAR)(230 & 0xff));
      case 0x03c4: return((CHAR)(231 & 0xff));
      case 0x03a6: return((CHAR)(232 & 0xff));
      case 0x0398: return((CHAR)(233 & 0xff));
      case 0x03a9: return((CHAR)(234 & 0xff));
      case 0x03b4: return((CHAR)(235 & 0xff));
      case 0x221e: return((CHAR)(236 & 0xff));
      case 0x03c6: return((CHAR)(237 & 0xff));
      case 0x03b5: return((CHAR)(238 & 0xff));
      case 0x2229: return((CHAR)(239 & 0xff));
      case 0x2261: return((CHAR)(240 & 0xff));
      case 0x00b1: return((CHAR)(241 & 0xff));
      case 0x2265: return((CHAR)(242 & 0xff));
      case 0x2264: return((CHAR)(243 & 0xff));
      case 0x2320: return((CHAR)(244 & 0xff));
      case 0x2321: return((CHAR)(245 & 0xff));
      case 0x00f7: return((CHAR)(246 & 0xff));
      case 0x2248: return((CHAR)(247 & 0xff));
      case 0x00b0: return((CHAR)(248 & 0xff));
      case 0x2219: return((CHAR)(249 & 0xff));
      case 0x00b7: return((CHAR)(250 & 0xff));
      case 0x221a: return((CHAR)(251 & 0xff));
      case 0x207f: return((CHAR)(252 & 0xff));
      case 0x00b2: return((CHAR)(253 & 0xff));
      case 0x25a0: return((CHAR)(254 & 0xff));
      case 0x00a0: return((CHAR)(255 & 0xff));
      default: return(tx_cpsub(c));	/* For box characters etc */
    }
}

int					/* PC Code Page 864 */
#ifdef CK_ANSIC
tx_cp864(USHORT c)
#else
tx_cp864(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x00b0: return((CHAR)0x80 & 0xff);
      case 0x00b7: return((CHAR)0x81 & 0xff);
      case 0x2219: return((CHAR)0x82 & 0xff);
      case 0x221a: return((CHAR)0x83 & 0xff);
      case 0x2592: return((CHAR)0x84 & 0xff);
      case 0x2500: return((CHAR)0x85 & 0xff);
      case 0x2502: return((CHAR)0x86 & 0xff);
      case 0x253c: return((CHAR)0x87 & 0xff);
      case 0x2524: return((CHAR)0x88 & 0xff);
      case 0x252c: return((CHAR)0x89 & 0xff);
      case 0x251c: return((CHAR)0x8a & 0xff);
      case 0x2534: return((CHAR)0x8b & 0xff);
      case 0x2510: return((CHAR)0x8c & 0xff);
      case 0x250c: return((CHAR)0x8d & 0xff);
      case 0x2514: return((CHAR)0x8e & 0xff);
      case 0x2518: return((CHAR)0x8f & 0xff);
      case 0x03b2: return((CHAR)0x90 & 0xff);
      case 0x221e: return((CHAR)0x91 & 0xff);
      case 0x03c6: return((CHAR)0x92 & 0xff);
      case 0x00b1: return((CHAR)0x93 & 0xff);
      case 0x00bd: return((CHAR)0x94 & 0xff);
      case 0x00bc: return((CHAR)0x95 & 0xff);
      case 0x2248: return((CHAR)0x96 & 0xff);
      case 0x00ab: return((CHAR)0x97 & 0xff);
      case 0x00bb: return((CHAR)0x98 & 0xff);
      case 0xfef7: return((CHAR)0x99 & 0xff);
      case 0xfef8: return((CHAR)0x9a & 0xff);
      case 0xfefb: return((CHAR)0x9d & 0xff);
      case 0xfefc: return((CHAR)0x9e & 0xff);
      case 0x00a0: return((CHAR)0xa0 & 0xff);
      case 0x00ad: return((CHAR)0xa1 & 0xff);
      case 0xfe82: return((CHAR)0xa2 & 0xff);
      case 0x00a3: return((CHAR)0xa3 & 0xff);
      case 0x00a4: return((CHAR)0xa4 & 0xff);
      case 0xfe84: return((CHAR)0xa5 & 0xff);
      case 0xfe8e: return((CHAR)0xa8 & 0xff);
      case 0xfe8f: return((CHAR)0xa9 & 0xff);
      case 0xfe95: return((CHAR)0xaa & 0xff);
      case 0xfe99: return((CHAR)0xab & 0xff);
      case 0x060c: return((CHAR)0xac & 0xff);
      case 0xfe9d: return((CHAR)0xad & 0xff);
      case 0xfea1: return((CHAR)0xae & 0xff);
      case 0xfea5: return((CHAR)0xaf & 0xff);
      case 0x0660: return((CHAR)0xb0 & 0xff);
      case 0x0661: return((CHAR)0xb1 & 0xff);
      case 0x0662: return((CHAR)0xb2 & 0xff);
      case 0x0663: return((CHAR)0xb3 & 0xff);
      case 0x0664: return((CHAR)0xb4 & 0xff);
      case 0x0665: return((CHAR)0xb5 & 0xff);
      case 0x0666: return((CHAR)0xb6 & 0xff);
      case 0x0667: return((CHAR)0xb7 & 0xff);
      case 0x0668: return((CHAR)0xb8 & 0xff);
      case 0x0669: return((CHAR)0xb9 & 0xff);
      case 0xfed1: return((CHAR)0xba & 0xff);
      case 0x061b: return((CHAR)0xbb & 0xff);
      case 0xfeb1: return((CHAR)0xbc & 0xff);
      case 0xfeb5: return((CHAR)0xbd & 0xff);
      case 0xfeb9: return((CHAR)0xbe & 0xff);
      case 0x061f: return((CHAR)0xbf & 0xff);
      case 0x00a2: return((CHAR)0xc0 & 0xff);
      case 0xfe80: return((CHAR)0xc1 & 0xff);
      case 0xfe81: return((CHAR)0xc2 & 0xff);
      case 0xfe83: return((CHAR)0xc3 & 0xff);
      case 0xfe85: return((CHAR)0xc4 & 0xff);
      case 0xfeca: return((CHAR)0xc5 & 0xff);
      case 0xfe8b: return((CHAR)0xc6 & 0xff);
      case 0xfe8d: return((CHAR)0xc7 & 0xff);
      case 0xfe91: return((CHAR)0xc8 & 0xff);
      case 0xfe93: return((CHAR)0xc9 & 0xff);
      case 0xfe97: return((CHAR)0xca & 0xff);
      case 0xfe9b: return((CHAR)0xcb & 0xff);
      case 0xfe9f: return((CHAR)0xcc & 0xff);
      case 0xfea3: return((CHAR)0xcd & 0xff);
      case 0xfea7: return((CHAR)0xce & 0xff);
      case 0xfea9: return((CHAR)0xcf & 0xff);
      case 0xfeab: return((CHAR)0xd0 & 0xff);
      case 0xfead: return((CHAR)0xd1 & 0xff);
      case 0xfeaf: return((CHAR)0xd2 & 0xff);
      case 0xfeb3: return((CHAR)0xd3 & 0xff);
      case 0xfeb7: return((CHAR)0xd4 & 0xff);
      case 0xfebb: return((CHAR)0xd5 & 0xff);
      case 0xfebf: return((CHAR)0xd6 & 0xff);
      case 0xfec1: return((CHAR)0xd7 & 0xff);
      case 0xfec5: return((CHAR)0xd8 & 0xff);
      case 0xfecb: return((CHAR)0xd9 & 0xff);
      case 0xfecf: return((CHAR)0xda & 0xff);
      case 0x00a6: return((CHAR)0xdb & 0xff);
      case 0x00ac: return((CHAR)0xdc & 0xff);
      case 0x00f7: return((CHAR)0xdd & 0xff);
      case 0x00d7: return((CHAR)0xde & 0xff);
      case 0xfec9: return((CHAR)0xdf & 0xff);
      case 0x0640: return((CHAR)0xe0 & 0xff);
      case 0xfed3: return((CHAR)0xe1 & 0xff);
      case 0xfed7: return((CHAR)0xe2 & 0xff);
      case 0xfedb: return((CHAR)0xe3 & 0xff);
      case 0xfedf: return((CHAR)0xe4 & 0xff);
      case 0xfee3: return((CHAR)0xe5 & 0xff);
      case 0xfee7: return((CHAR)0xe6 & 0xff);
      case 0xfeeb: return((CHAR)0xe7 & 0xff);
      case 0xfeed: return((CHAR)0xe8 & 0xff);
      case 0xfeef: return((CHAR)0xe9 & 0xff);
      case 0xfef3: return((CHAR)0xea & 0xff);
      case 0xfebd: return((CHAR)0xeb & 0xff);
      case 0xfecc: return((CHAR)0xec & 0xff);
      case 0xfece: return((CHAR)0xed & 0xff);
      case 0xfecd: return((CHAR)0xee & 0xff);
      case 0xfee1: return((CHAR)0xef & 0xff);
      case 0xfe7d: return((CHAR)0xf0 & 0xff);
      case 0x0651: return((CHAR)0xf1 & 0xff);
      case 0xfee5: return((CHAR)0xf2 & 0xff);
      case 0xfee9: return((CHAR)0xf3 & 0xff);
      case 0xfeec: return((CHAR)0xf4 & 0xff);
      case 0xfef0: return((CHAR)0xf5 & 0xff);
      case 0xfef2: return((CHAR)0xf6 & 0xff);
      case 0xfed0: return((CHAR)0xf7 & 0xff);
      case 0xfed5: return((CHAR)0xf8 & 0xff);
      case 0xfef5: return((CHAR)0xf9 & 0xff);
      case 0xfef6: return((CHAR)0xfa & 0xff);
      case 0xfedd: return((CHAR)0xfb & 0xff);
      case 0xfed9: return((CHAR)0xfc & 0xff);
      case 0xfef1: return((CHAR)0xfd & 0xff);
      case 0x25a0: return((CHAR)0xfe & 0xff);
      default: return(tx_cpsub(c));	/* For box characters etc */
    }
}

int					/* PC Code Page 866 */
#ifdef CK_ANSIC
tx_cp866(USHORT c)
#else
tx_cp866(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x00a0: return((CHAR)(255 & 0xff));
      case 0x00a4: return((CHAR)(253 & 0xff));
      case 0x00b0: return((CHAR)(248 & 0xff));
      case 0x00b7: return((CHAR)(250 & 0xff));
      case 0x0401: return((CHAR)(240 & 0xff));
      case 0x0404: return((CHAR)(242 & 0xff));
      case 0x0407: return((CHAR)(244 & 0xff));
      case 0x040e: return((CHAR)(246 & 0xff));
      case 0x0410: return((CHAR)(128 & 0xff));
      case 0x0411: return((CHAR)(129 & 0xff));
      case 0x0412: return((CHAR)(130 & 0xff));
      case 0x0413: return((CHAR)(131 & 0xff));
      case 0x0414: return((CHAR)(132 & 0xff));
      case 0x0415: return((CHAR)(133 & 0xff));
      case 0x0416: return((CHAR)(134 & 0xff));
      case 0x0417: return((CHAR)(135 & 0xff));
      case 0x0418: return((CHAR)(136 & 0xff));
      case 0x0419: return((CHAR)(137 & 0xff));
      case 0x041a: return((CHAR)(138 & 0xff));
      case 0x041b: return((CHAR)(139 & 0xff));
      case 0x041c: return((CHAR)(140 & 0xff));
      case 0x041d: return((CHAR)(141 & 0xff));
      case 0x041e: return((CHAR)(142 & 0xff));
      case 0x041f: return((CHAR)(143 & 0xff));
      case 0x0420: return((CHAR)(144 & 0xff));
      case 0x0421: return((CHAR)(145 & 0xff));
      case 0x0422: return((CHAR)(146 & 0xff));
      case 0x0423: return((CHAR)(147 & 0xff));
      case 0x0424: return((CHAR)(148 & 0xff));
      case 0x0425: return((CHAR)(149 & 0xff));
      case 0x0426: return((CHAR)(150 & 0xff));
      case 0x0427: return((CHAR)(151 & 0xff));
      case 0x0428: return((CHAR)(152 & 0xff));
      case 0x0429: return((CHAR)(153 & 0xff));
      case 0x042a: return((CHAR)(154 & 0xff));
      case 0x042b: return((CHAR)(155 & 0xff));
      case 0x042c: return((CHAR)(156 & 0xff));
      case 0x042d: return((CHAR)(157 & 0xff));
      case 0x042e: return((CHAR)(158 & 0xff));
      case 0x042f: return((CHAR)(159 & 0xff));
      case 0x0430: return((CHAR)(160 & 0xff));
      case 0x0431: return((CHAR)(161 & 0xff));
      case 0x0432: return((CHAR)(162 & 0xff));
      case 0x0433: return((CHAR)(163 & 0xff));
      case 0x0434: return((CHAR)(164 & 0xff));
      case 0x0435: return((CHAR)(165 & 0xff));
      case 0x0436: return((CHAR)(166 & 0xff));
      case 0x0437: return((CHAR)(167 & 0xff));
      case 0x0438: return((CHAR)(168 & 0xff));
      case 0x0439: return((CHAR)(169 & 0xff));
      case 0x043a: return((CHAR)(170 & 0xff));
      case 0x043b: return((CHAR)(171 & 0xff));
      case 0x043c: return((CHAR)(172 & 0xff));
      case 0x043d: return((CHAR)(173 & 0xff));
      case 0x043e: return((CHAR)(174 & 0xff));
      case 0x043f: return((CHAR)(175 & 0xff));
      case 0x0440: return((CHAR)(224 & 0xff));
      case 0x0441: return((CHAR)(225 & 0xff));
      case 0x0442: return((CHAR)(226 & 0xff));
      case 0x0443: return((CHAR)(227 & 0xff));
      case 0x0444: return((CHAR)(228 & 0xff));
      case 0x0445: return((CHAR)(229 & 0xff));
      case 0x0446: return((CHAR)(230 & 0xff));
      case 0x0447: return((CHAR)(231 & 0xff));
      case 0x0448: return((CHAR)(232 & 0xff));
      case 0x0449: return((CHAR)(233 & 0xff));
      case 0x044a: return((CHAR)(234 & 0xff));
      case 0x044b: return((CHAR)(235 & 0xff));
      case 0x044c: return((CHAR)(236 & 0xff));
      case 0x044d: return((CHAR)(237 & 0xff));
      case 0x044e: return((CHAR)(238 & 0xff));
      case 0x044f: return((CHAR)(239 & 0xff));
      case 0x0451: return((CHAR)(241 & 0xff));
      case 0x0454: return((CHAR)(243 & 0xff));
      case 0x0457: return((CHAR)(245 & 0xff));
      case 0x045e: return((CHAR)(247 & 0xff));
      case 0x2116: return((CHAR)(252 & 0xff));
      case 0x2219: return((CHAR)(249 & 0xff));
      case 0x221a: return((CHAR)(251 & 0xff));
      case 0x2500: return((CHAR)(196 & 0xff));
      case 0x2502: return((CHAR)(179 & 0xff));
      case 0x250c: return((CHAR)(218 & 0xff));
      case 0x2510: return((CHAR)(191 & 0xff));
      case 0x2514: return((CHAR)(192 & 0xff));
      case 0x2518: return((CHAR)(217 & 0xff));
      case 0x251c: return((CHAR)(195 & 0xff));
      case 0x2524: return((CHAR)(180 & 0xff));
      case 0x252c: return((CHAR)(194 & 0xff));
      case 0x2534: return((CHAR)(193 & 0xff));
      case 0x253c: return((CHAR)(197 & 0xff));
      case 0x2550: return((CHAR)(205 & 0xff));
      case 0x2551: return((CHAR)(186 & 0xff));
      case 0x2552: return((CHAR)(213 & 0xff));
      case 0x2553: return((CHAR)(214 & 0xff));
      case 0x2554: return((CHAR)(201 & 0xff));
      case 0x2555: return((CHAR)(184 & 0xff));
      case 0x2556: return((CHAR)(183 & 0xff));
      case 0x2557: return((CHAR)(187 & 0xff));
      case 0x2558: return((CHAR)(212 & 0xff));
      case 0x2559: return((CHAR)(211 & 0xff));
      case 0x255a: return((CHAR)(200 & 0xff));
      case 0x255b: return((CHAR)(190 & 0xff));
      case 0x255c: return((CHAR)(189 & 0xff));
      case 0x255d: return((CHAR)(188 & 0xff));
      case 0x255e: return((CHAR)(198 & 0xff));
      case 0x255f: return((CHAR)(199 & 0xff));
      case 0x2560: return((CHAR)(204 & 0xff));
      case 0x2561: return((CHAR)(181 & 0xff));
      case 0x2562: return((CHAR)(182 & 0xff));
      case 0x2563: return((CHAR)(185 & 0xff));
      case 0x2564: return((CHAR)(209 & 0xff));
      case 0x2565: return((CHAR)(210 & 0xff));
      case 0x2566: return((CHAR)(203 & 0xff));
      case 0x2567: return((CHAR)(207 & 0xff));
      case 0x2568: return((CHAR)(208 & 0xff));
      case 0x2569: return((CHAR)(202 & 0xff));
      case 0x256a: return((CHAR)(216 & 0xff));
      case 0x256b: return((CHAR)(215 & 0xff));
      case 0x256c: return((CHAR)(206 & 0xff));
      case 0x2580: return((CHAR)(223 & 0xff));
      case 0x2584: return((CHAR)(220 & 0xff));
      case 0x2588: return((CHAR)(219 & 0xff));
      case 0x258c: return((CHAR)(221 & 0xff));
      case 0x2590: return((CHAR)(222 & 0xff));
      case 0x2591: return((CHAR)(176 & 0xff));
      case 0x2592: return((CHAR)(177 & 0xff));
      case 0x2593: return((CHAR)(178 & 0xff));
      case 0x25a0: return((CHAR)(254 & 0xff));
      default: return(tx_cpsub(c));	/* For box characters etc */
    }
}

int					/* PC Code Page 869 */
#ifdef CK_ANSIC
tx_cp869(USHORT c)
#else
tx_cp869(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x80)			/* Has C1 graphics */
      return((CHAR)(c & 0xff));
    switch (c) {
      case 0x00a0: return((CHAR)(255 & 0xff));
      case 0x00a3: return((CHAR)(156 & 0xff));
      case 0x00a6: return((CHAR)(138 & 0xff));
      case 0x00a7: return((CHAR)(245 & 0xff));
      case 0x00a8: return((CHAR)(249 & 0xff));
      case 0x00a9: return((CHAR)(151 & 0xff));
      case 0x00ab: return((CHAR)(174 & 0xff));
      case 0x00ac: return((CHAR)(137 & 0xff));
      case 0x00ad: return((CHAR)(240 & 0xff));
      case 0x00b0: return((CHAR)(248 & 0xff));
      case 0x00b1: return((CHAR)(241 & 0xff));
      case 0x00b2: return((CHAR)(153 & 0xff));
      case 0x00b3: return((CHAR)(154 & 0xff));
      case 0x00b7: return((CHAR)(136 & 0xff));
      case 0x00bb: return((CHAR)(175 & 0xff));
      case 0x00bd: return((CHAR)(171 & 0xff));
      case 0x0384: return((CHAR)(239 & 0xff));
      case 0x0385: return((CHAR)(247 & 0xff));
      case 0x0386: return((CHAR)(134 & 0xff));
      case 0x0388: return((CHAR)(141 & 0xff));
      case 0x0389: return((CHAR)(143 & 0xff));
      case 0x038a: return((CHAR)(144 & 0xff));
      case 0x038c: return((CHAR)(146 & 0xff));
      case 0x038e: return((CHAR)(149 & 0xff));
      case 0x038f: return((CHAR)(152 & 0xff));
      case 0x0390: return((CHAR)(161 & 0xff));
      case 0x0391: return((CHAR)(164 & 0xff));
      case 0x0392: return((CHAR)(165 & 0xff));
      case 0x0393: return((CHAR)(166 & 0xff));
      case 0x0394: return((CHAR)(167 & 0xff));
      case 0x0395: return((CHAR)(168 & 0xff));
      case 0x0396: return((CHAR)(169 & 0xff));
      case 0x0397: return((CHAR)(170 & 0xff));
      case 0x0398: return((CHAR)(172 & 0xff));
      case 0x0399: return((CHAR)(173 & 0xff));
      case 0x039a: return((CHAR)(181 & 0xff));
      case 0x039b: return((CHAR)(182 & 0xff));
      case 0x039c: return((CHAR)(183 & 0xff));
      case 0x039d: return((CHAR)(184 & 0xff));
      case 0x039e: return((CHAR)(189 & 0xff));
      case 0x039f: return((CHAR)(190 & 0xff));
      case 0x03a0: return((CHAR)(198 & 0xff));
      case 0x03a1: return((CHAR)(199 & 0xff));
      case 0x03a3: return((CHAR)(207 & 0xff));
      case 0x03a4: return((CHAR)(208 & 0xff));
      case 0x03a5: return((CHAR)(209 & 0xff));
      case 0x03a6: return((CHAR)(210 & 0xff));
      case 0x03a7: return((CHAR)(211 & 0xff));
      case 0x03a8: return((CHAR)(212 & 0xff));
      case 0x03a9: return((CHAR)(213 & 0xff));
      case 0x03aa: return((CHAR)(145 & 0xff));
      case 0x03ab: return((CHAR)(150 & 0xff));
      case 0x03ac: return((CHAR)(155 & 0xff));
      case 0x03ad: return((CHAR)(157 & 0xff));
      case 0x03ae: return((CHAR)(158 & 0xff));
      case 0x03af: return((CHAR)(159 & 0xff));
      case 0x03b0: return((CHAR)(252 & 0xff));
      case 0x03b1: return((CHAR)(214 & 0xff));
      case 0x03b2: return((CHAR)(215 & 0xff));
      case 0x03b3: return((CHAR)(216 & 0xff));
      case 0x03b4: return((CHAR)(221 & 0xff));
      case 0x03b5: return((CHAR)(222 & 0xff));
      case 0x03b6: return((CHAR)(224 & 0xff));
      case 0x03b7: return((CHAR)(225 & 0xff));
      case 0x03b8: return((CHAR)(226 & 0xff));
      case 0x03b9: return((CHAR)(227 & 0xff));
      case 0x03ba: return((CHAR)(228 & 0xff));
      case 0x03bb: return((CHAR)(229 & 0xff));
      case 0x03bc: return((CHAR)(230 & 0xff));
      case 0x03bd: return((CHAR)(231 & 0xff));
      case 0x03be: return((CHAR)(232 & 0xff));
      case 0x03bf: return((CHAR)(233 & 0xff));
      case 0x03c0: return((CHAR)(234 & 0xff));
      case 0x03c1: return((CHAR)(235 & 0xff));
      case 0x03c2: return((CHAR)(237 & 0xff));
      case 0x03c3: return((CHAR)(236 & 0xff));
      case 0x03c4: return((CHAR)(238 & 0xff));
      case 0x03c5: return((CHAR)(242 & 0xff));
      case 0x03c6: return((CHAR)(243 & 0xff));
      case 0x03c7: return((CHAR)(244 & 0xff));
      case 0x03c8: return((CHAR)(246 & 0xff));
      case 0x03c9: return((CHAR)(250 & 0xff));
      case 0x03ca: return((CHAR)(160 & 0xff));
      case 0x03cb: return((CHAR)(251 & 0xff));
      case 0x03cc: return((CHAR)(162 & 0xff));
      case 0x03cd: return((CHAR)(163 & 0xff));
      case 0x03ce: return((CHAR)(253 & 0xff));
      case 0x2015: return((CHAR)(142 & 0xff));
      case 0x2018: return((CHAR)(139 & 0xff));
      case 0x2019: return((CHAR)(140 & 0xff));
      case 0x2500: return((CHAR)(196 & 0xff));
      case 0x2502: return((CHAR)(179 & 0xff));
      case 0x250c: return((CHAR)(218 & 0xff));
      case 0x2510: return((CHAR)(191 & 0xff));
      case 0x2514: return((CHAR)(192 & 0xff));
      case 0x2518: return((CHAR)(217 & 0xff));
      case 0x251c: return((CHAR)(195 & 0xff));
      case 0x2524: return((CHAR)(180 & 0xff));
      case 0x252c: return((CHAR)(194 & 0xff));
      case 0x2534: return((CHAR)(193 & 0xff));
      case 0x253c: return((CHAR)(197 & 0xff));
      case 0x2550: return((CHAR)(205 & 0xff));
      case 0x2551: return((CHAR)(186 & 0xff));
      case 0x2554: return((CHAR)(201 & 0xff));
      case 0x2557: return((CHAR)(187 & 0xff));
      case 0x255a: return((CHAR)(200 & 0xff));
      case 0x255d: return((CHAR)(188 & 0xff));
      case 0x2560: return((CHAR)(204 & 0xff));
      case 0x2563: return((CHAR)(185 & 0xff));
      case 0x2566: return((CHAR)(203 & 0xff));
      case 0x2569: return((CHAR)(202 & 0xff));
      case 0x256c: return((CHAR)(206 & 0xff));
      case 0x2580: return((CHAR)(223 & 0xff));
      case 0x2584: return((CHAR)(220 & 0xff));
      case 0x2588: return((CHAR)(219 & 0xff));
      case 0x2591: return((CHAR)(176 & 0xff));
      case 0x2592: return((CHAR)(177 & 0xff));
      case 0x2593: return((CHAR)(178 & 0xff));
      case 0x25a0: return((CHAR)(254 & 0xff));
      default: return(tx_cpsub(c));	/* For box characters etc */
    }
}

int					/* PC Code Page C0 graphics */
#ifdef CK_ANSIC
tx_smiley(USHORT c)
#else
tx_smiley(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c > 0x1f)
      return(-1);
    switch (c) {
      case 0x00a0: return((CHAR)0 & 0x7f);
      case 0x00a7: return((CHAR)21 & 0x7f);
      case 0x00b6: return((CHAR)20 & 0x7f);
      case 0x2022: return((CHAR)7 & 0x7f);
      case 0x203c: return((CHAR)19 & 0x7f);
      case 0x2190: return((CHAR)27 & 0x7f);
      case 0x2191: return((CHAR)24 & 0x7f);
      case 0x2192: return((CHAR)26 & 0x7f);
      case 0x2193: return((CHAR)25 & 0x7f);
      case 0x2194: return((CHAR)29 & 0x7f);
      case 0x2195: return((CHAR)18 & 0x7f);
      case 0x21a8: return((CHAR)23 & 0x7f);
      case 0x2319: return((CHAR)28 & 0x7f);
      case 0x25ac: return((CHAR)22 & 0x7f);
      case 0x25b2: return((CHAR)30 & 0x7f);
      case 0x25ba: return((CHAR)16 & 0x7f);
      case 0x25bc: return((CHAR)31 & 0x7f);
      case 0x25c4: return((CHAR)17 & 0x7f);
      case 0x25d8: return((CHAR)8 & 0x7f);
      case 0x25d9: return((CHAR)10 & 0x7f);
      case 0x25ef: return((CHAR)9 & 0x7f);
      case 0x263a: return((CHAR)1 & 0x7f);
      case 0x263b: return((CHAR)2 & 0x7f);
      case 0x263c: return((CHAR)15 & 0x7f);
      case 0x2640: return((CHAR)12 & 0x7f);
      case 0x2642: return((CHAR)11 & 0x7f);
      case 0x2660: return((CHAR)6 & 0x7f);
      case 0x2663: return((CHAR)5 & 0x7f);
      case 0x2665: return((CHAR)3 & 0x7f);
      case 0x2666: return((CHAR)4 & 0x7f);
      case 0x266a: return((CHAR)13 & 0x7f);
      case 0x266c: return((CHAR)14 & 0x7f);
      default: return(-1);
    }
}

USHORT  /* Kermit font 0xE??? to Unicode substitutions */
#ifdef CK_ANSIC
tx_usub(USHORT c)
#else
tx_usub(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0xE000 || c > 0xEFFF)
      return(c);
    switch (c) {
      case 0xE200: return(0x2524);	/* Extensible Left Brace Middle */
      case 0xE201: return(0x2570);	/* Extensible Left Parenthesis bot */
      case 0xE202: return(0x256d);	/* Extensible left parenthesis top */
      case 0xE203: return(0x2514);	/* Extensible left SB bot */
      case 0xE204: return(0x250c);	/* Extensible left SB top */
      case 0xE205: return(0x251c);	/* Extensible right brace middle */
      case 0xE206: return(0x256f);	/* Extensible right parenthesis bot */
      case 0xE207: return(0x256e);	/* Extensible right parenthesis top */
      case 0xE208: return(0x2518);	/* Extensible right SB bot */
      case 0xE209: return(0x2510);	/* Extensible right SB top */
      case 0xE20C: return(0x03a3);	/* Summation symbol bot */
      case 0xE20D: return(0x03a3);	/* Summation symbol top */
      case 0xE20E: return(0x2510);	/* Right ceiling corner */
      case 0xE20F: return(0x2518);	/* Right floor corner */
      case 0xE300: return(0x2502);	/* V box line, extensible, left */
      case 0xE309: return(0x2502);	/* V box line, extensible, right */
      case 0xE30A: return(0x258c);	/* Diagonal fill, dark, UL */
      case 0xE30B: return(0x2590);	/* Diagonal fill, dark, UR */
      case 0xE311: return(0x2500);	/* H line - Scan 1 */
      case 0xE313: return(0x2500);	/* H line - Scan 3 */
      case 0xE315: return(0x2500);	/* H line - Scan 5 */
      case 0xE317: return(0x2500);	/* H line - Scan 7 */
      case 0xE319: return(0x2500);	/* H line - Scan 9 */
      case 0xE320: return(0x2583);	/* Quadrant LL */
      case 0xE321: return(0x2490);	/* Quadrant LR */
      case 0xE322: return(0x258c);	/* Quadrant UL */
      case 0xE323: return(0x2588);	/* Quadrant UL and LL and LR */
      case 0xE324: return(0x2588);	/* Quadrant UL and LR */
      case 0xE325: return(0x2588);	/* Quadrant UL and LR */
      case 0xE326: return(0x2588);	/* Quadrant UL and UR and LL */
      case 0xE327: return(0x2588);	/* Quadrant UL and UR and LR */
      case 0xE328: return(0x2590);	/* Quadrant UR */
      case 0xE329: return(0x2588);	/* Quadrant UR and LL and LR */
      case 0xE400: return(0x221a);	/* Radical symbol, small */
      case 0xE401: return(0x00bf);	/* Reverse question mark */
      default: return((unsigned)0xfffd);
    }
}

int					/* Unicode to CP437 substitutions */
#ifdef CK_ANSIC
tx_cpsub(USHORT c)
#else
tx_cpsub(c) USHORT c;
#endif /* CK_ANSIC */
{
    int x;
    if (c < 0x0080)			/* ASCII */
      return((CHAR)(c & 0xff));
    if (c >= 0x0080 && c <= 0x0100) {
	switch (c) {			/* Latin-1 */
	  case 0x00A2: return(0x9b);	/* Cent sign */
	  case 0x00A3: return(156);	/* Pound sign */
	  case 0x00AC: return(170);	/* Not symbol */
	  case 0x00B0: return(248);	/* Degree symbol */
	  case 0x00B1: return(241);	/* Plus or minus symbol */
	  case 0x00B2: return(253);	/* Superscript 2 */
	  case 0x00B3: return(51);	/* Superscript 3 */
	  case 0x00B6: return(14);	/* Pilcrow symbol */
	  case 0x00B7: return(250);	/* Center dot, small */
	  case 0x00B9: return(49);	/* Superscript 1 */
	  case 0x00D0: return(68);	/* Eth -> D */
	  case 0x00D7: return(120);	/* Multiplication symbol */
	  case 0x00DE: return(84);	/* Thorn -> T */
	  case 0x00F0: return(100);	/* eth -> eth */
	  case 0x00F7: return(246);	/* Division symbol */
	  case 0x00FE: return(116);	/* thorn -> t */
	  default: return(0x13);
	}
    } else if (c >= 0x0100 && c <= 0x02ff) { /* Latin-2 etc */
	switch (c) {
	  case 0x0103: return(97);	/* a breve */
	  case 0x0105: return(97);	/* a ogonek */
	  case 0x0107:			/* c acute */
	  case 0x010d: return(99);	/* c caron */
	  case 0x010f:			/* d caron */
	  case 0x0111: return(100);	/* d with stroke */
	  case 0x0119:			/* e ogonek */
	  case 0x011b: return(101);	/* e caron */
	  case 0x011f: return(103);	/* g breve */
	  case 0x0130: return(73);	/* Capital I with Dot */
	  case 0x0131: return(105);	/* Dotless i */
	  case 0x0132: return(89);	/* IJ => Y */
	  case 0x0133: return(152);	/* ij -> y diaeresis */
	  case 0x013a:			/* l acute */
	  case 0x013e:			/* l caron */
	  case 0x0142: return(108);	/* l with stroke */
	  case 0x0144:			/* n acute */
	  case 0x0148: return(110);	/* n caron */
	  case 0x0151: return(111);	/* o double acute */
	  case 0x0152: return(79);	/* OE */
	  case 0x0153: return(111);	/* oe */
	  case 0x0155:			/* r acute */
	  case 0x0159: return(114);	/* r caron */
	  case 0x015b:			/* s acute */
	  case 0x015f:			/* s ogonek */
	  case 0x0161: return(115);	/* s caron */
	  case 0x0163:			/* t ogonek */
	  case 0x0165:			/* t caron */
	  case 0x0167: return(116);	/* t with stroke */
	  case 0x016f:			/* u ring */
	  case 0x0171: return(117);	/* u double acute */
	  case 0x017a:			/* z acute */
	  case 0x017c:			/* z dot above */
	  case 0x017e: return(122);	/* z caron */
	  case 0x0192: return(159);	/* Function-of symbol, Script f */
	  case 0x01d0: return(105);	/* i caron */
	  case 0x02c7:			/* caron -> UNK */
	  case 0x02d8: return(0x13);	/* breve -> UNK */
	  case 0x02dd: return(34);	/* Double acute -> Doublequote */
	  default: return(0x13);
	}
    } else if (c >= 0x0300 && c <= 0x03ff) { /* Greek */
	switch (c) {
	  case 0x0393: return(226);	/* Uppercase Greek Gamma */
	  case 0x0398: return(233);	/* Uppercase Greek Theta */
	  case 0x039B: return(235);	/* Uppercase Greek Lambda */
	  case 0x03A0: return(227);	/* Uppercase Greek Pi */
	  case 0x03A3: return(228);	/* Uppercase Greek Sigma */
	  case 0x03A4: return(0xEA);	/* Omega */
	  case 0x03A6: return(232);	/* Uppercase Greek Phi */
	  case 0x03A9: return(234);	/* Uppercase Greek Omega */
	  case 0x03B1: return(0xE0);	/* alpha */
	  case 0x03B2: return(0xE1);	/* beta */
	  case 0x03B3: return(226);	/* Lowercase Greek gamma */
	  case 0x03B4: return(0xEB);	/* delta */
	  case 0x03B5: return(238);	/* Lowercase Greek epsilon */
	  case 0x03B7: return(238);	/* Lowercase Greek eta */
	  case 0x03B8: return(233);	/* Lowercase Greek theta */
	  case 0x03B9: return(105);	/* Lowercase Greek iota */
	  case 0x03BA: return(107);	/* Lowercase Greek kappa */
	  case 0x03BB: return(235);	/* Lowercase Greek lambda */
	  case 0x03BC: return(230);	/* Lowercase Greek mu */
	  case 0x03C0: return(227);	/* Lowercase Greek pi */
	  case 0x03C3: return(229);	/* Lowercase Greek sigma */
	  case 0x03C4: return(231);	/* Lowercase Greek tau */
	  case 0x03C6: return(237);	/* Lowercase Greek phi */
	  case 0x03C7: return(120);	/* Lowercase Greek chi */
	  case 0x03C9: return(234);	/* Lowercase Greek omega */
	  default: return(0x13);
	}
    } else if (c >= 0x2000 && c <= 0x20ff) { /* Sub+Superscripts & Currency */
	switch (c) {
	  case 0x203C: return(0x13);	/* !! */
	  case 0x2070: return(48);	/* Superscript 0 */
	  case 0x2074: return(52);	/* Superscript 4 */
	  case 0x2075: return(53);	/* Superscript 5 */
	  case 0x2076: return(54);	/* Superscript 6 */
	  case 0x2077: return(55);	/* Superscript 7 */
	  case 0x2078: return(56);	/* Superscript 8 */
	  case 0x2079: return(57);	/* Superscript 9 */
	  case 0x207a: return(43);	/* Superscript + */
	  case 0x207b: return(45);	/* Superscript - */
	  case 0x207F: return(252);	/* Superscript n */
	  case 0x2080: return(48);	/* Subscript 0 */
	  case 0x2081: return(49);	/* Subscript 1 */
	  case 0x2082: return(50);	/* Subscript 2 */
	  case 0x2083: return(51);	/* Subscript 3 */
	  case 0x2084: return(52);	/* Subscript 4 */
	  case 0x2085: return(53);	/* Subscript 5 */
	  case 0x2086: return(54);	/* Subscript 6 */
	  case 0x2087: return(55);	/* Subscript 7 */
	  case 0x2088: return(56);	/* Subscript 8 */
	  case 0x2089: return(57);	/* Subscript 9 */
	  case 0x208a: return(43);	/* Subscript + */
	  case 0x208b: return(45);	/* Subscript - */
	  case 0x20a7: return(0x93);	/* Peseta */
	  default:
	    x = tx_punc(c);		/* Various spaces, dashes, etc */
	    return((x < 0) ? 0x13 : x);
	}
    } else if (c >= 0x2100 && c <= 0x21ff) { /* Arrows */
	switch (c) {
	  case 0x2190: return(27);	/* Arrow, left-pointing */
	  case 0x2191: return(24);	/* Arrow, up-pointing */
	  case 0x2192: return(26);	/* Arrow, right-pointing */
	  case 0x2193: return(25);	/* Arrow, down-pointing */
	  case 0x2194: return(0x1d);	/* Arrow, left-right */
	  case 0x2195: return(0x12);	/* Arrow, up-down */
	  case 0x219F: return(0x18);	/* Arrow, up, doublehead */
	  case 0x21A1: return(0x19);	/* Arrow, down, doublehead */
	  case 0x21A8: return(0x17);	/* Arrow, up-down with base */
	  case 0x21D2: return(26);	/* Implies symbol */
	  case 0x21D4: return(29);	/* If and only if symbol */
	  case 0x21E4: return(0x1B);	/* Arrow, left, to bar */
	  case 0x21E5: return(0x1A);	/* Arrow, right, to bar */
	  case 0x21E8: return(0x10);	/* Outline white right arrow */
	  case 0x21E9: return(0x0f);	/* Outline white down arrow */
	  default: return(0x13);
	}
    } else if (c >= 0x2200 && c <= 0x22ff) { /* Math */
	switch (c) {
	  case 0x2202: return(235);	/* Partial differential symbol */
	  case 0x2207: return(31);	/* Nabla, Laplace operator */
	  case 0x2208: return(0x33);	/* (because of QNX misunderstanding) */
	  case 0x221A: return(251);	/* Radical symbol */
	  case 0x221D: return(236);	/* Proportional-to */
	  case 0x221E: return(236);	/* Infinity symbol */
	  case 0x2227: return(30);	/* Logical AND */
	  case 0x2228: return(31);	/* Logical OR */
	  case 0x2229: return(239);	/* Intersection symbol */
	  case 0x222A: return(85);	/* Union symbol */
	  case 0x222B: return(244);	/* Integral symbol */
	  case 0x2234: return(254);	/* Therefore symbol */
	  case 0x223C: return(126);	/* Centered tilde operator */
	  case 0x2243: return(247);	/* Asymptotically equals */
	  case 0x2248: return(247);	/* Almost equal to symbol */
	  case 0x2260: return(88);	/* Not equal symbol */
	  case 0x2261: return(240);	/* Identity symbol */
	  case 0x2264: return(243);	/* Less than or equal symbol */
	  case 0x2265: return(242);	/* Greater than or equal symbol */
	  case 0x2282: return(40);	/* Subset symbol */
	  case 0x2283: return(41);	/* Superset symbol */
	  case 0x22A6: return(0xC3);	/* Assertion symbol */
	  default: return(0x13);
	}
    } else if (c >= 0x2300 && c <= 0x24ff) { /* Tech */
	switch (c) {
	  case 0x2308: return(0xDA);	/* Left ceiling */
	  case 0x2309: return(0xBF);	/* Right ceiling */
	  case 0x230A: return(0xC0);	/* Left floor */
	  case 0x230B: return(0xD9);	/* Right floor */
	  case 0x2319: return(0x1C);	/* Turned Not sign */
	  case 0x2320: return(244);	/* Integral symbol top */
	  case 0x2321: return(245);	/* Integral symbol bot */
	  case 0x2329: return(60);	/* BRA, large left angle bracket */
	  case 0x232A: return(62);	/* KET, large right angle bracket */
	  case 0x2409: return(26);	/* "HT" becomes right arrow */
	  case 0x240A: return(25);	/* "LF" becomes down arrow */
	  case 0x240B: return(23);	/* "VT" becomes up-down arrow */
	  case 0x240C: return(24);	/* "FF" becomes up arrow */
	  case 0x240D: return(27);	/* "CR" becomes left arrow */
	  case 0x2424: return(31);	/* "NL" becomes down triangle */
	  default: return(0x13);
	}
    } else if (c >= 0x2500 && c <= 0x2552) { /* Box drawing */
	switch (c) {
	  case 0x2500: return(196);	/* Center box bar horizontal */
	  case 0x2501: return(0xCD);	/* Bold -> Double */
	  case 0x2502: return(179);	/* Center box bar vertical */
	  case 0x2503: return(0xBA);	/* Bold */
	  case 0x2504: return(45);	/* Dashed line */
	  case 0x2506: return(124);	/* Broken vertical bar */
	  case 0x250C: return(218);	/* UL box corner */
	  case 0x250F: return(0xC9);	/* Bold */
	  case 0x2510: return(191);	/* UR Box Corner */
	  case 0x2513: return(0xBB);	/* Bold */
	  case 0x2514: return(192);	/* LL box corner */
	  case 0x2517: return(0xC8);	/* Bold */
	  case 0x2518: return(217);	/* LR box corner */
	  case 0x251B: return(0xBC);	/* Bold */
	  case 0x251C: return(195);	/* Left middle box side */
	  case 0x2520: return(0xC3);
	  case 0x2523: return(0xCC);	/* Bold */
	  case 0x2524: return(180);	/* Right middle box side */
	  case 0x2528: return(180);
	  case 0x252B: return(0xB9);	/* Bold */
	  case 0x252C: return(194);	/* Middle box top */
	  case 0x252F: return(194);
	  case 0x2533: return(0xCB);	/* Bold */
	  case 0x2534: return(193);	/* Middle box bot */
	  case 0x2537: return(193);
	  case 0x253B: return(0xCA);	/* Bold */
	  case 0x253C: return(197);	/* Box intersection */
	  case 0x253F: return(197);
	  case 0x2542: return(197);
	  case 0x2547: return(197);
	  case 0x2548: return(197);
	  case 0x2549: return(197);
	  case 0x254A: return(197);
	  case 0x254B: return(0xCE);	/* Bold */
	  case 0x2550: return(205);	/* Center box bar horizontal double */
	  case 0x2551: return(186);	/* Center box bar vertical double */
	  case 0x2552: return(213);	/* UL box corner single to double */
	  default: return(0x13);
	}
    } else if (c >= 0x2553 && c <= 0x2579) { /* More box drawing */
	switch (c) {
	  case 0x2553: return(214);	/* UL box corner double to single */
	  case 0x2554: return(201);	/* UL box corner double */
	  case 0x2555: return(184);	/* UR box corner double to single */
	  case 0x2556: return(183);	/* UR box corner single to double */
	  case 0x2557: return(187);	/* UR box corner double */
	  case 0x2558: return(212);	/* LL box corner single to double */
	  case 0x2559: return(211);	/* LL box corner double to single */
	  case 0x255A: return(200);	/* LL box corner double */
	  case 0x255B: return(190);	/* LR box corner double to single */
	  case 0x255C: return(189);	/* LR box corner single to double */
	  case 0x255D: return(188);	/* LR box corner double */
	  case 0x255E: return(198);	/* Left mid box side single to doubl */
	  case 0x255F: return(199);	/* Left mid box side double to singl */
	  case 0x2560: return(204);	/* Left middle box side double */
	  case 0x2561: return(181);	/* Right box side double to single */
	  case 0x2562: return(182);	/* Right box side single to double */
	  case 0x2563: return(185);	/* Right middle box side double */
	  case 0x2564: return(209);	/* Middle box top double to single */
	  case 0x2565: return(210);	/* Middle box top single to double */
	  case 0x2566: return(203);	/* Middle box top double */
	  case 0x2567: return(207);	/* Middle box bot single to double */
	  case 0x2568: return(208);	/* Middle box bot double to single */
	  case 0x2569: return(202);	/* Middle box bot double */
	  case 0x256A: return(216);	/* Box intersection double to single */
	  case 0x256B: return(215);	/* Box intersection single to double */
	  case 0x256C: return(206);	/* Box intersection double */
	  case 0x256D: return(218);	/* UL arc */
	  case 0x256E: return(191);	/* UR arc */
	  case 0x256F: return(217);	/* LR arc */
	  case 0x2570: return(192);	/* LL arc */
	  case 0x2571: return(179);	/* Diagonal line LL to UR */
	  case 0x2572: return(196);	/* Diagonal line UL to LR */
	  case 0x2573: return(88);	/* Diagonal lines crossed */
	  case 0x2575: return(0xb3);	/* High vertical line */
	  case 0x2576: return(45);	/* Short horizontal line */
	  case 0x2577: return(0xb3);	/* Low vertical line */
	  case 0x2579: return(0xb3);	/* High vertical line bold */
	  default: return(0x13);
	}
    } else if (c >= 0x257a && c <= 0x25ff) { /* Still more box drawing */
	switch (c) {
	  case 0x257b: return(0xb3);	/* Low vertical line bold */
	  case 0x2580: return(223);	/* Quadrant UL and UR (top half) */
	  case 0x2581: return(0xc4);	/* Scan line 9 */
	  case 0x2582: return(0xDC);	/* Black blob lower half */
	  case 0x2584: return(220);	/* Quadrant LL and LR (lower half) */
	  case 0x2588: return(219);	/* Fill character dark */
	  case 0x258C: return(221);	/* Quadrant UL and LL (left half) */
	  case 0x258E: return(0xDD);
	  case 0x2590: return(222);	/* Quadrant UR and LR (right half) */
	  case 0x2591: return(176);	/* Fill character light */
	  case 0x2592: return(177);	/* Fill character medium */
	  case 0x2593: return(178);	/* Fill character heavy */
	  case 0x2594: return(0xc4);	/* Scan line 1 */
	  case 0x25A0: return(254);	/* Solid square, center */
	  case 0x25A6: return(177);	/* Blotch */
	  case 0x25AC:			/* Black rectangle */
	  case 0x25AF: return(0x16);	/* White rectangle */
	  case 0x25B2:			/* Triangle, up-pointing */
	  case 0x25B4: return(0x1e);	/* Triangle, up-pointing */
	  case 0x25B6:			/* Triangle, right-pointing, dark */
	  case 0x25B7:			/* Triangle, right-pointing, light */
	  case 0x25B9:			/* Triangle, right-pointing, light */
	  case 0x25BA: return(0x10);	/* Triangle, right-pointing, narrow */
	  case 0x25BC:			/* Triangle, down-pointing */
	  case 0x25BE: return(0x1f);	/* Triangle, down-pointing */
	  case 0x25C0:			/* Triangle, left-pointing, dark */
	  case 0x25C1:			/* Triangle, left-pointing, dark */
	  case 0x25C4: return(0x11);	/* Triangle, left-pointing, narrow */
	  case 0x25C6: return(4);	/* Diamond, center, solid */
	  case 0x25CB: return(0x09);	/* Circle */
	  case 0x25CF: return(249);	/* Center dot, large */
	  case 0x25d8: return(0x08);	/* Inverse bullet */
	  case 0x25d9: return(0x0a);	/* Inverse white circle */
	  case 0x25E2: return(0xD9);	/* Lower right triangle */
	  case 0x25E3: return(0xC0);	/* Lower left triangle */
	  case 0x25E4: return(0xDA);	/* Upper left triangle */
	  case 0x25E5: return(0xBf);	/* Upper right triangle */
	  default: return(0x13);
	}
    } else if (c >= 0x2600) {		/* All the rest */
	switch (c) {
	  case 0x263a: return(0x01);	/* Smiley */
	  case 0x263b: return(0x02);	/* Inverse Smiley */
	  case 0x263c: return(0x0f);	/* White Sun with Rays */
	  case 0x2640: return(0x0c);	/* Male sign */
	  case 0x2642: return(0x0b);	/* Female sign */
	  case 0x2660: return(0x06);	/* Spade */
	  case 0x2663: return(0x05);	/* Club */
	  case 0x2665: return(0x03);	/* Heart */
	  case 0x2666: return(0x04);	/* Diamond, center, solid */
	  case 0x266a: return(0x0d);	/* Quarter note */
	  case 0x266b:			/* Beamed quarter notes */
	  case 0x266c: return(0x0e);	/* Beamed 8th notes */
	  case 0x279e: return(0x1a);	/* Bold right arrow */
	  case 0x27a1: return(0x1a);	/* Heavy black right arrow. */
	  case 0xE200: return(180);	/* Extensible left brace middle */
	  case 0xE201: return(192);	/* Extensible Left parenthesis bot */
	  case 0xE202: return(218);	/* Extensible left parenthesis top */
	  case 0xE203: return(192);	/* Extensible left SB bot */
	  case 0xE204: return(218);	/* Extensible left SB top */
	  case 0xE205: return(195);	/* Extensible right brace middle */
	  case 0xE206: return(217);	/* Extensible right parenthesis bot */
	  case 0xE207: return(191);	/* Extensible right parenthesis top */
	  case 0xE208: return(217);	/* Extensible right SB bot */
	  case 0xE209: return(191);	/* Extensible right SB top */
	  case 0xE20C: return(228);	/* Summation symbol bot */
	  case 0xE20D: return(228);	/* Summation symbol top */
	  case 0xE20E: return(191);	/* Right ceiling corner */
	  case 0xE20F: return(217);	/* Right floor corner */
	  case 0xE300: return(179);	/* V box line, extensible, left */
	  case 0xE309: return(179);	/* V box line, extensible, right */
	  case 0xE30A: return(221);	/* Diagonal fill, dark, UL */
	  case 0xE30B: return(222);	/* Diagonal fill, dark, UR */
	  case 0xE311: return(196);	/* H line - Scan 1 */
	  case 0xE313: return(196);	/* H line - Scan 3 */
	  case 0xE315: return(196);	/* H line - Scan 5 */
	  case 0xE317: return(196);	/* H line - Scan 7 */
	  case 0xE319: return(196);	/* H line - Scan 9 */
	  case 0xE320: return(221);	/* Quadrant LL */
	  case 0xE321: return(222);	/* Quadrant LR */
	  case 0xE322: return(221);	/* Quadrant UL */
	  case 0xE323: return(219);	/* Quadrant UL and LL and LR */
	  case 0xE324: return(219);	/* Quadrant UL and LR */
	  case 0xE325: return(219);	/* Quadrant UL and LR */
	  case 0xE326: return(219);	/* Quadrant UL and UR and LL */
	  case 0xE327: return(219);	/* Quadrant UL and UR and LR */
	  case 0xE328: return(222);	/* Quadrant UR */
	  case 0xE329: return(219);	/* Quadrant UR and LL and LR */
	  case 0xE400: return(251);	/* Radical symbol, small */
	  case 0xE401: return(168);	/* Reverse question mark */
	  case 0xFFFD: return(0x13);	/* !! for unknown */
	  default: return(0x13);
	}
    }
    return(0x13);
}

#ifdef OS2
/*
  Lucida Console is a Unicode font, but it is very sparsely populated.
  Since it is the only monospace Unicode font most people have, we have
  to make reasonable substitutions or else 3/4 of the glyphs will show
  up as blobs on the screen.
*/
USHORT					/* Unicode to Lucida Console */
#ifdef CK_ANSIC
tx_lucidasub(USHORT c)
#else
tx_lucidasub(c) USHORT c;
#endif /* CK_ANSIC */
{
    if (c < 0x0180)			/* Latin-1 and Extended A */
      return(c);

/* For efficiency we try to arrange the sections by frequency of use. */

    if (c >= 0x2500 && c <= 0x257f) {	/* Box drawing */
	if (c >= 0x2550 && c <= 0x256c)
	  return(c);
	switch (c) {
	  /* Themselves */
        case 0x2500:
        case 0x2502:
        case 0x250c:
        case 0x2510:
        case 0x2514:
        case 0x2518:
        case 0x251c:
        case 0x2524:
        case 0x252c:
        case 0x2534:
        case 0x253c:
            return(c);
	  /* Horizontal lines */
        case 0x2501:			/* Bold */
	    return(0x2550);		/* Use double */
        case 0x2504:
        case 0x2505:
        case 0x2508:
        case 0x2509:
        case 0x254c:
        case 0x254d:
        case 0x257c:
        case 0x257e:
            return(0x2500);
	  /* Vertical lines */
        case 0x2503:			/* Bold */
	    return(0x2551);		/* Use double */
        case 0x2506:
        case 0x2507:
        case 0x250a:
        case 0x250b: /* Other */
        case 0x254e:
        case 0x254f:
        case 0x257d:
        case 0x257f:
        case 0x2575:
        case 0x2577:
        case 0x2579:
        case 0x257b:
            return(0x2502);
            /* Upper left box corner */
        case 0x250f:			/* Bold */
	    return(0x2554);		/* Use double */
        case 0x250d: case 0x250e:	/* Other */
	    return(0x250c);
	  /* Upper right box corner */
        case 0x2513:			/* Bold */
	    return(0x2557);
        case 0x2511:
        case 0x2512:	/* Other */
	    return(0x2510);
	  /* Lower left box corner */
        case 0x2517:			/* Bold */
	    return(0x255a);
        case 0x2515:
        case 0x2516:	/* Other */
	    return(0x2514);
	  /* Lower right box corner */
        case 0x251b:			/* Bold */
	    return(0x255d);
        case 0x2519:
        case 0x251a:	/* Other */
	    return(0x2518);
	  /* Vertical and right */
        case 0x2523:			/* Bold */
	    return(0x2560);
        case 0x251d:
        case 0x251e:
        case 0x251f:
        case 0x2520:
        case 0x2521:
        case 0x2522:
            return(0x251c);
	  /* Vertical and left */
        case 0x252b:			/* Bold */
	    return(0x2563);
        case 0x2525:
        case 0x2526:
        case 0x2527:
        case 0x2528:
        case 0x2529:
        case 0x252a:
            return(0x2524);
	  /* Horizontal and down */
	  case 0x2533:			/* Bold */
	    return(0x2566);
        case 0x252d:
        case 0x252e:
        case 0x252f:
        case 0x2530:
        case 0x2531:
        case 0x2532:
            return(0x252c);
            /* Horizontal and up */
        case 0x253b:			/* Bold */
	    return(0x2569);
        case 0x2535: case 0x2536: case 0x2537:
        case 0x2538: case 0x2539: case 0x253a:
            return(0x2534);
	  /* Horizontal and Vertical */
	  case 0x254b:			/* Bold */
	    return(0x256c);
	  case 0x253d: case 0x253e: case 0x253f:
        case 0x2540: case 0x2541: case 0x2542: case 0x2543:
        case 0x2544: case 0x2545: case 0x2546: case 0x2547:
        case 0x2548: case 0x2549: case 0x254a:
            return(0x253c);
	  /* Curved corners */
	  case 0x256d:			/* UL */
	    return(0x250c);
	  case 0x256e:			/* UR */
	    return(0x2510);
	  case 0x256f:			/* LL */
	    return(0x2518);
	  case 0x2570:			/* LR */
	    return(0x2514);
	  case 0x2571:			/* Diagonal */
	    return(0x002f);
	  case 0x2572:			/* Other diagonal */
	    return(0x005c);
	  case 0x2573:			/* Diagonal cross */
	    return(0x00d7);
	  /* Partial horizontal lines */
        case 0x2574: case 0x2576: case 0x2578: case 0x257a:
            return(0x002d);
        default:
            return(0xfffd);
	}
    }
    if (c >= 0x2190 && c <= 0x21ff) {	/* Arrows */
	if (c >= 0x2190 && c <= 0x2195 || c == 0x21a8)
	  return(c);
	switch (c) {
	  /* Left-arrow forms */
        case 0x219e: case 0x21a2: case 0x21a4: case 0x21a9:
        case 0x21bc: case 0x21d0: case 0x21da: case 0x21dc:
        case 0x21e0: case 0x21e4: case 0x21e6: case 0x21c7:
            return(0x2190);
	  /* Right-arrow forms */
        case 0x21a0: case 0x21a3: case 0x21a6: case 0x21aa:
        case 0x21c0: case 0x21c1: case 0x21c9: case 0x21d2:
        case 0x21db: case 0x21dd: case 0x21e2: case 0x21e5:
        case 0x21e8:
            return(0x2192);
	  /* Up-arrow forms */
        case 0x219f: case 0x21a5: case 0x21be: case 0x21bf:
        case 0x21c8: case 0x21d1: case 0x21de: case 0x21e1:
        case 0x21e7: case 0x21ea:
            return(0x2191);
	  /* Down-arrow forms */
        case 0x21a1: case 0x21a7: case 0x21af: case 0x21c2:
        case 0x21ce: case 0x21ca: case 0x21d3: case 0x21df:
        case 0x21e3: case 0x21e9:
            return(0x2193);
	  /* Up-down-arrow forms */
        case 0x21c5: case 0x21d5:
            return(0x2195);
        default:
            return(0xfffd);
	}
    }
    if (c >= 0x2580 && c <= 0x259f) {	/* Block elements */
	switch (c) {
        case 0x2580: case 0x2584: case 0x2588: case 0x258c:
        case 0x2590: case 0x2591: case 0x2592: case 0x2593:
            return(c);
        case 0x2581: case 0x2582: case 0x2583:
        case 0x2585: case 0x2586: case 0x2587:
            return(0x2584);
        case 0x2589: case 0x258a: case 0x258b:
        case 0x258d: case 0x258e: case 0x258f:
	    return(0x258c);
        case 0x2595:
            return(0x2502);
        default:
            return(0xfffd);
	}
    }
    if (c >= 0x2200 && c <= 0x22ff) {	/* Mathematical operators */
	switch (c) {
        case 0x2202: case 0x2206: case 0x220f: case 0x2211: case 0x2212:
        case 0x2219: case 0x2220: case 0x221e: case 0x221f: case 0x2229:
        case 0x222b: case 0x2248: case 0x2260: case 0x2261: case 0x2264:
        case 0x2265:
            return(c);
        default:
            return(0xfffd);
	}
    }
    if (c >= 0x2300 && c <= 0x237f) {	/* Miscellaneous Technical */
	if (c == 0x2302 || c == 0x2310 || c == 0x2320 || c == 0x2321)
	  return(c);
	switch (c) {
	  case 0x2329:			/* BRA */
	    return(0x003c);
	  case 0x232a:			/* KET */
	    return(0x003e);
        default:
              return(0xfffd);
	}
    }
    if (c >= 0x25a0 && c <= 0x25ff) {	/* Geometric shapes */
	switch (c) {
	  /* Themselves */
        case 0x25a0: case 0x25ac: case 0x25b2: case 0x25ba:
        case 0x25bc: case 0x25c4: case 0x25ca: case 0x25cb:
        case 0x25d8: case 0x25d9:
            return(c);
	  /* Squares */
	  case 0x25a1: case 0x25a2: case 0x25a3: case 0x25a4:
	  case 0x25a5: case 0x25a6: case 0x25a7: case 0x25a8:
        case 0x25a9: case 0x25aa: case 0x25ab:
        case 0x25e7: case 0x25e8: case 0x25e9: case 0x25ea: case 0x25eb:
            return(0x25a0);
	  case 0x25ad: case 0x25ae: case 0x25af: /* Rectangles */
        case 0x25b0: case 0x25b1:
            return(0x25ac);
	  case 0x25b3: case 0x25b4: case 0x25b5: /* Upright triangles */
        case 0x25ec: case 0x25ed: case 0x25ee:
            return(0x25b2);
        case 0x25b6: case 0x25b7: case 0x25b8: case 0x25b9: case 0x25bb:
            return(0x25ba);		         /* Right-pointing triangles */
	  case 0x25bd: case 0x25be: case 0x25bf: /* Down-pointing triangles */
	    return(0x25bc);
        case 0x25c0: case 0x25c1: case 0x25c2: case 0x25c3: case 0x25c5:
            return(0x25c4);		         /* Left-pointing triangles */
	  case 0x25c6: case 0x25c7: case 0x25c8: /* Diamonds */
	    return(0x2666);
	  /* Circles */
        case 0x25c9: case 0x25cc: case 0x25cd: case 0x25ce: case 0x25cf:
        case 0x25d0: case 0x25d1: case 0x25d2: case 0x25d3: case 0x25d4:
        case 0x25d5: case 0x25e6: case 0x25ef:
            return(0x25cb);
	  /* Curves and corner triangles */
	  case 0x25dc: case 0x25e4:	/* UL */
	    return(0x250c);
	  case 0x25dd: case 0x25e5:	/* UR */
	    return(0x2510);
	  case 0x25df: case 0x25e3:	/* LL */
	    return(0x2514);
	  case 0x25de: case 0x25e2:	/* LR */
	    return(0x2518);
        default:
            return(0xfffd);
	}
    }
    if (c >= 0x2600 && c <= 0x26ff) {	/* Misc symbols */
	switch (c) {
	  /* Themselves */
        case 0x263a: case 0x263b: case 0x263c: case 0x2640:
        case 0x2642: case 0x2660: case 0x2663: case 0x2665:
        case 0x2666: case 0x266a: case 0x266b:
            return(c);
        default:
            return(0xfffd);
	}
    }
    if (c >= 0x2794 && c <= 0x27be)	/* Right-arrow Dingbats */
      return(0x2192);
    if (c >= 0x2070 && c <= 0x209f) {	/* Super & subscripts */
	if (c == 0x207f)		/* n */
	  return(c);
	else if (c == 0x2070)		/* 0 */
	  return(0x0030);
	else if (c >= 0x2074 && c <= 0x2079)
	  return(c - 0x2040);
	else if (c >= 0x2080 && c <= 0x2089)
	  return(c - 0x2050);
	switch (c) {
        case 0x207a: case 0x208a:
            return(0x002b);
        case 0x207b: case 0x208b:
            return(0x002d);
        case 0x207c: case 0x208c:
            return(0x003d);
        case 0x207d: case 0x208d:
            return(0x0028);
        case 0x207e: case 0x208e:
            return(0x0029);
        default:
            return(0xfffd);
	}
    }
    if (c >= 0x0180 && c <= 0x024f) {	/* Latin Extended B, Part I */
	if (c == 0x0192 || c >= 0x01fa && c <= 0x01ff)
	  return(c);			/* Latin Extended B */
	switch (c) {
        case 0x0180: case 0x0183: case 0x0184: case 0x0185:
            return(0x0062);		/* Lowercase b variants */
        case 0x0181: case 0x0182:
            return(0x0042);		/* Uppercase B variants */
        case 0x0186: case 0x0187:
            return(0x0043);		/* Uppercase C variants */
	  case 0x0189:			/* D with stroke */
	    return(0x00D0);		/* Looks just like Eth */
	  case 0x018a:			/* D with hook */
	    return(0x0044);
	  case 0x018e: case 0x0190:	/* E-like letters */
	    return(0x0045);
	  case 0x018f:			/* e-like letters */
	    return(0x0065);
	  case 0x0191:			/* F-like */
	    return(0x0046);
	  case 0x0193:			/* G-like */
	    return(0x0047);
	  case 0x0194:			/* Latin Capital Gamma */
	    return(0x0393);		/* Use Greek */
	  case 0x0195:			/* Gothic hv */
	    return(0x0068);		/* Use h */
	  case 0x0196:			/* Latin Capital Iota */
	    return(0x0399);		/* Use Greek */
	  case 0x0197:			/* I with bar */
	    return(0x0069);
	  case 0x0198:			/* K with hook */
	    return(0x004B);
	  case 0x0199:			/* k with hook */
	    return(0x006B);
	  case 0x019A:			/* l with bar */
	    return(0x006C);
	  case 0x019B:			/* lambda with bar */
	    return(0x03bb);		/* Use Greek */
	  case 0x019C:			/* Upside down m */
	    return(0x006d);
	  case 0x019D:			/* N with left hook */
	    return(0x004e);
	  case 0x019E:			/* n with long right leg */
	    return(0x006e);
	  case 0x019F: case 0x01a0: case 0x01a2: /* O-like letters */
	    return(0x004f);
	  case 0x01a1: case 0x01a3:	/* o-like */
	    return(0x006f);
	  case 0x01A4:			/* P with hook */
	    return(0x0050);
	  case 0x01A5:			/* p with hook */
	    return(0x0070);
	  case 0x01A6:			/* Old Norse YR */
	    return(0x0052);
	  case 0x01A7:			/* Backwards S */
	    return(0x0053);
	  case 0x01A8: case 0x01AA:	/* s-like letters */
	    return(0x0073);
	  case 0x01A9:			/* Esh */
	    return(0x03a3);		/* Looks just like Sigma */
	  case 0x01AB: case 0x01AD:	/* t-like */
	    return(0x0074);
	  case 0x01AC: case 0x01AE:	/* T-like */
	    return(0x0054);
	  case 0x01AF: case 0x01B1:	/* U-like */
	    return(0x0055);
	  case 0x01B0:			/* u-like */
	    return(0x0075);
	  case 0x01B2:			/* V-like */
	    return(0x0056);
	  case 0x01B3:			/* Y-like */
	    return(0x0059);
	  case 0x01B4:			/* y-like */
	    return(0x0079);
	  case 0x01B5:			/* Z-like */
	    return(0x005a);
	  case 0x01B6:			/* z-like */
	    return(0x007a);
	  case 0x01B7:			/* Yogh */
	    return(0x0033);		/* Use "3" */
	  case 0x01BF:			/* Wynn */
	    return(0x0077);		/* Use "w" */
	  case 0x01CD:			/* A caron */
	    return(0x0041);
	  case 0x01CE:			/* a caron */
	    return(0x0061);
	  case 0x01CF:			/* I caron */
	    return(0x0049);
	  case 0x01D0:			/* i caron */
	    return(0x0069);
	  case 0x01D1:			/* O caron */
	    return(0x004f);
	  case 0x01D2:			/* o caron */
	    return(0x006f);
	  case 0x01D3:			/* U caron */
	    return(0x0055);
	  case 0x01D4:			/* u caron */
	    return(0x0075);
	  /* U diaeresis + other things */
        case 0x01D5: case 0x01D7: case 0x01D9: case 0x01DB:
            return(0x00dc);
	  /* u diaeresis + other things */
        case 0x01D6: case 0x01Da: case 0x01Dc:
            return(0x00fc);

	  /* Fill in more here if anybody asks */

        default:
            return(0xfffd);
	}
    }
    if (c >= 0x1e00 && c <= 0x1eff) {	/* Latin Extended Additional */
	if (c >= 0x1e80 && c <= 0x1e85)
	  return(c);
	else
	  return(0xfffd);
    }
    if (c >= 0x0400 && c <= 0x04ff) {	/* Cyrillic */
	if (c >= 0x0400 && c <= 0x045f || c == 0x0490  || c == 0x0491)
	  return(c);
	else
	  return(0xfffd);
    }
    if (c >= 0x0370 && c <= 0x03ff) {	/* Greek */
	if (c == 0x037e || c >= 0x0384 && c <= 0x03ce)
	  return(c);
	switch (c) {
        case 0x0374: case 0x0375:
            return(0x0027);
        case 0x037a:
            return(0x002c);
	  /* Fill in more here if needed */
        default:
            return(0xfffd);
	}
    }
    if (c >= 0x1f00 && c <= 0x1fff) {	/* Greek Extended */
	/* Fill in if asked */
	return(0xfffd);
    }
    if (c >= 0x20a0 && c <= 0x20cf) {	/* Currency symbols */
	if (c == 0x20a3 || c == 0x20a4 || c == 0x20a7 || c == 0x20ac)
	  return(c);
	else
	  return(0xfffd);
    }
    if (c >= 0x2100 && c <= 0x214f) {	/* Letterlike symbols */
	if (c == 0x2116 || c == 0x2122 || c == 0x2126)
	  return(c);
	else
	  return(0xfffd);
    }
    if (c >= 0x2150 && c <= 0x218f) {	/* Number forms */
	if (c >= 0x215b && c <= 0x215e)	/* Roman numerals etc */
	  return(c);
	else
	  return(0xfffd);
    }
    if (c >= 0x02b0 && c <= 0x02ff) {	/* Spacing modifier letters */
	if (c == 0x02c6 || c == 0x02c7 || c == 0x02c9 ||
	    c >= 0x02d8 && c <= 0x02dd)
	  return(c);
	switch (c) {
        case 0x02b0: case 0x02b1:
            return(0x0068);
        case 0x02b2:
              return(0x006a);
        case 0x02b3: case 0x02b4: case 0x02b5:
            return(0x0072);
        case 0x02b7:
            return(0x0077);
        case 0x02b8:
            return(0x0079);
        case 0x02b9:
            return(0x00b4);
        case 0x02ba:
            return(0x0022);
        case 0x02bb: case 0x02bc: case 0x02bd: case 0x02be: case 0x02bf:
            return(0x0027);
	  case 0x02c2: 	    return(0x003c);
	  case 0x02c3: 	    return(0x003e);
	  case 0x02da: 	    return(0x00b0);
	  case 0x02dc: 	    return(0x007e);
	  default: 	    return(0xfffd);
	}
    }
    if (c >= 0x2000 && c <= 0x206f) {	/* General Punctuation */
	if (c >= 0x2013 && c <= 0x2015 ||
	    c >= 0x2017 && c <= 0x201a ||
	    c >= 0x201c && c <= 0x201e ||
	    c >= 0x2020 && c <= 0x2022 || c == 0x2026 || c == 0x2030 ||
	    c >= 0x2039 && c <= 0x203a || c == 0x203c || c == 0x203e ||
	    c == 0x2044)
	  return(c);
	else if (c == 0x2016)
	  return(0x2551);
	else if (c == 0x2017)
	  return(0x2550);
	else if (c == 0x2044)
	  return(0x002f);
	else
	  return(0xfffd);
    }
    if (c == 0xfb01 || c == 0xfb02)	/* Alphabetic Presentation Forms */
      return(c);
    return(0xfffd);			/* Catch-all */
}
#endif /* OS2 */


/*
  Table of Blah-to-Unicode information structures.
  KEEP THIS IN SYNC WITH THE TX_blah DEFINITIONS in ckcuni.h.
*/
struct x_to_unicode *
txrinfo[MAXTXSETS+1] = {
    &u_ascii,				/*  0 US ISO 646 (ASCII) */
    &u_british,				/*  1 UK ISO 646 */
    &u_fr_canadian,			/*  2 Canadian French NRC */
    NULL,				/*  3 Cuba */
    NULL,				/*  4 Czecho */
    &u_danish,				/*  5 Danish/Norwegian ISO 646 */
    &u_dutch,				/*  6 Dutch NRC */
    &u_finnish,				/*  7 Finnish NRC  */
    &u_french,				/*  8 French ISO 646 */
    &u_german,				/*  9 German ISO 646 */
    &u_hebrew7,				/* 10 Hebrew-7 (DEC) */
    &u_hungarian,			/* 11 Hungarian ISO 646 */
    &u_icelandic,			/* 12 Icelandic NRC */
    &u_italian,				/* 13 Italian ISO 646 */
    &u_jis0201r,			/* 14 Japanese Roman ISO 646 */
    &u_jis0201k,			/* 15 Japanese Katakana */
    &u_koi7,				/* 16 Short KOI */
    &u_danish,				/* 17 Norwegian/Danish ISO 646 */
    &u_portuguese,			/* 18 Portuguese ISO 646 */
    &u_spanish,				/* 19 spanish ISO 646 */
    &u_swedish,				/* 20 Swedish ISO 646 */
    NULL,				/* 21 Swedish ISO 646 for names */
    &u_swiss,				/* 22 Swiss NRC   */
    &u_8859_1,				/* 23 ISO 8859-1  */
    &u_8859_2,				/* 24 ISO 8859-2  */
    &u_8859_3,				/* 25 ISO 8859-3  */
    &u_8859_4,				/* 26 ISO 8859-4  */
    &u_8859_5,				/* 27 ISO 8859-5  */ /* Cyrillic */
    &u_8859_6,				/* 28 ISO 8859-6  */ /* Arabic */
    &u_8859_7,				/* 29 ISO 8859-7  */ /* Greek */
    &u_8859_8,				/* 30 ISO 8859-8  */ /* Hebrew */
    &u_8859_9,				/* 31 ISO 8859-9  */
    &u_8859_10,				/* 32 ISO 8859-10 */
    &u_koi8,				/* 33 KOI-8       */
    NULL,				/* 34 JIS-7       */
    NULL,				/* 35 Shift JIS   */
    NULL,				/* 36 Japanese EUC (JAE) */
    NULL,				/* 37 Japanese DEC Kanji */
    &u_decmcs,				/* 38 DEC MCS */
    &u_nextstep,			/* 39 NeXT    */
    &u_dgi,				/* 40 DGI     */
    &u_maclatin,			/* 41 Macintosh Latin  */
    &u_hproman8,			/* 42 HP Roman 8       */
    &u_cp437,				/* 43 CP437 - Original */
    &u_cp850,				/* 44 CP850 - W Europe */
    &u_cp852,				/* 45 CP852 - E Europe */
    &u_cp857,				/* 46 CP857 - Turkish  */
    &u_cp862,				/* 47 CP862 - Hebrew   */
    &u_cp864,				/* 48 CP864 - Arabic   */
    &u_cp866,				/* 49 CP866 - Cyrillic */
    &u_cp869,				/* 50 CP869 - Greek    */
    &u_decspec,				/* 51 DEC Special Graphics */
    &u_dectech,				/* 52 DEC Technical */
    &u_c0pics,                          /* 53 C0 Pictures */
    &u_c1pics,                          /* 54 C0 Pictures */
    &u_smiley,                          /* 55 IBM C0 Graphics */
    &u_heath19g,			/* 56 Heath 19 Graphics */
    &u_tvig,				/* 57 TVI Graphics */
    &u_wyse_gn,				/* 58 Wyse 60 Graphics Normal */
    &u_wyse_g1,				/* 59 Wyse 60 Graphics 1 */
    &u_wyse_g2,				/* 60 Wyse 60 Graphics 2 */
    &u_wyse_g3,				/* 61 Wyse 60 Graphics 3 */
    &u_elot927,				/* 62 Greek ELOT 927 */
    &u_dgspec,				/* 63 DG Special graphics */
    &u_dgline,				/* 64 DG Line drawing */
    &u_dgword,				/* 65 DG Word processing */
    &u_hpline,				/* 66 HP Line drawing */
    &u_hpmath,				/* 67 HP Math/Technical */
    &u_qnxgrph,				/* 68 QNX Graphics */
    &u_snibrack,			/* 69 SNI Brackets */
    &u_snieuro,				/* 70 SNI Euro */
    &u_snifacet,			/* 71 SNI Facet */
    &u_sniibm,				/* 72 SNI IBM */
    &u_sniblanks,                       /* 73 SNI Blanks */
    &u_cp1252,				/* 74 Windows Latin-1 */
    &u_cp1250,				/* 75 Windows Latin-2 */
    &u_cp1251,				/* 76 Windows Cyrillic */
    &u_cp1253,				/* 77 Windows Greek */
    &u_cp1254,				/* 78 Windows Turkish */
    &u_cp1257,				/* 79 Windows Latin-4 */
    &u_cp856,				/* 80 Cyrillic PC Code Page 856 */
    &u_cp855,			        /* 81 Cyrillic PC Code Page 855 */
    &u_8859_1,                          /* 82 CP819 - Same as 8859-1 */
    &u_8859_2,                          /* 83 CP912 - Same as 8859-2 */
    &u_8859_3,                          /* 84 CP913 - Same as 8859-3 */
    &u_8859_4,                          /* 85 CP914 - Same as 8859-4 */
    &u_8859_5,                          /* 86 CP915 - Same as 8859-5 */
    &u_8859_6,                          /* 87 CP1089 - Same as 8859-6 */
    &u_8859_7,                          /* 88 CP813 - Same as 8859-7 */
    &u_8859_8,                          /* 89 CP916 - Same as 8859-8 */
    &u_8859_9,                          /* 90 CP920 - Same as 8859-9 */
    &u_hproman8,                        /* 91 CP1051 - Same as HP Roman 8 */
    &u_cp858,				/* 92 CP858 - W Europe w/Euro */
    &u_8859_15,                         /* 93 ISO 8859-15 Latin-15 */
    &u_8859_15,                         /* 94 CP923 - Same as 8859-15  */
    &u_8859_7,                          /* 95 ELOT928 - Same as 8859-7 */
    &u_quickdraw,                       /* 96 CP10000 - Apple Quickdraw */
    &u_cp37,                            /* 97 CP37 - U.S. EBCDIC */
    &u_cp1255,                          /* 98 CP1255 - Windows Hebrew */
    &u_cp1256,                          /* 99 CP1256 - Windows Arabic */
    &u_cp1258,                          /* 100 CP1258 - Windows Viet Nam */
    &u_mazovia,				/* 101 Mazovia Polish code page */
    &u_transparent,                     /* 102 Transparent */
    &u_hz1500,				/* 103 Hazeltine 1500/1520 graphics */
    &u_koi8r,				/* 104 KOI8-R */
    &u_koi8u				/* 105 KOI8-U */
};

/*
  Table of Blah-to-Unicode translation functions.
  KEEP THIS IN SYNC WITH THE TX_blah DEFINITITIONS in ckcuni.h.
*/
USHORT
#ifdef CK_ANSIC
(*xl_u[MAXTXSETS+1])(CHAR)
#else
(*xl_u[MAXTXSETS+1])()
#endif /* CK_ANSIC */
= {
    ascii_u,				/*  0 US ISO 646 (ASCII) */
    british_u,				/*  1 UK ISO 646 */
    fr_canadian_u,			/*  2 Canadian French NRC */
    NULL,				/*  3 Cuba */
    NULL,				/*  4 Czecho */
    danish_u,				/*  5 Danish/Norwegian ISO 646 */
    dutch_u,				/*  6 Dutch NRC */
    finnish_u,				/*  7 Finnish NRC  */
    french_u,				/*  8 French ISO 646 */
    german_u,				/*  9 German ISO 646 */
    hebrew7_u,				/* 10 Hebrew-7 (DEC) */
    hungarian_u,			/* 11 Hungarian ISO 646 */
    icelandic_u,			/* 12 Icelandic */
    italian_u,				/* 13 Italian ISO 646 */
    jis0201r_u,				/* 14 Japanese Roman ISO 646 */
    jis0201k_u,				/* 15 Japanese Katakana */
    koi7_u,				/* 16 Short KOI */
    danish_u,				/* 17 Norwegian/Danish ISO 646 */
    portuguese_u,			/* 18 Portuguese ISO 646 */
    spanish_u,				/* 19 spanish ISO 646 */
    swedish_u,				/* 20 Swedish ISO 646 */
    NULL,				/* 21 Swedish ISO 646 for names */
    swiss_u,				/* 22 Swiss NRC   */
    iso_8859_1_u,			/* 23 ISO 8859-1  */
    iso_8859_2_u,			/* 24 ISO 8859-2  */
    iso_8859_3_u,			/* 25 ISO 8859-3  */
    iso_8859_4_u,			/* 26 ISO 8859-4  */
    iso_8859_5_u,			/* 27 ISO 8859-5  */ /* Cyrillic */
    iso_8859_6_u,			/* 28 ISO 8859-6  */ /* Arabic */
    iso_8859_7_u,			/* 29 ISO 8859-7  */ /* Greek */
    iso_8859_8_u,			/* 30 ISO 8859-8  */ /* Hebrew */
    iso_8859_9_u,			/* 31 ISO 8859-9  */ /* Latin-5 */
    iso_8859_10_u,			/* 32 ISO 8859-10 */
    koi8_u,				/* 33 KOI-8       */
    NULL,				/* 34 JIS-7       */
    NULL,				/* 35 Shift JIS   */
    NULL,				/* 36 Japanese EUC (JAE) */
    NULL,				/* 37 Japanese DEC Kanji */
    decmcs_u,				/* 38 DEC MCS */
    nextstep_u,				/* 39 NeXT    */
    dgi_u,				/* 40 DGI     */
    maclatin_u,				/* 41 Macintosh Latin  */
    hproman8_u,				/* 42 HP Roman 8       */
    cp437_u,				/* 43 CP437 - Original */
    cp850_u,				/* 44 CP850 - W Europe */
    cp852_u,				/* 45 CP852 - E Europe */
    cp857_u,				/* 46 CP857 - Turkish  */
    cp862_u,				/* 47 CP862 - Hebrew   */
    cp864_u,				/* 48 CP864 - Arabic   */
    cp866_u,				/* 49 CP866 - Cyrillic */
    cp869_u,				/* 50 CP869 - Greek    */
    decspec_u,				/* 51 DEC Special Graphics */
    dectech_u,				/* 52 DEC Technical */
    c0pics_u,				/* 53 C0 Pictures */
    c1pics_u,				/* 54 C1 Pictures */
    smiley_u,				/* 55 IBM C0 Graphics */
    heath19g_u,				/* 56 Heath 19 graphics */
    tvig_u,				/* 57 TVI graphics */
    wyse_gn_u,				/* 58 Wyse 60 normal-mode graphics */
    wyse_g1_u,				/* 59 Wyse 60 graphics 1 */
    wyse_g2_u,				/* 60 Wyse 60 graphics 2 */
    wyse_g3_u,				/* 61 Wyse 60 graphics 3 */
    elot927_u,				/* 62 Greek ELOT 927 */
    dgspec_u,				/* 63 DG Special graphics */
    dgline_u,				/* 64 DG Line drawing */
    dgword_u,				/* 65 DG Word processing */
    hpline_u,				/* 66 HP Line drawing */
    hpmath_u,				/* 67 HP Math/Technical */
    qnxgrph_u,				/* 68 QNX Graphics */
    snibrack_u,				/* 69 SNI Brackets */
    snieuro_u,				/* 70 SNI Euro */
    snifacet_u,				/* 71 SNI Facet */
    sniibm_u,				/* 72 SNI IBM */
    sniblanks_u,                        /* 73 SNI Blanks */
    cp1252_u,				/* 74 Windows Latin-1 */
    cp1250_u,				/* 75 Windows Latin-2 */
    cp1251_u,				/* 76 Windows Cyrillic */
    cp1253_u,				/* 77 Windows Greek */
    cp1254_u,				/* 78 Windows Turkish */
    cp1257_u,				/* 79 Windows Latin-4 */
    cp856_u,				/* 80 Cyrillic PC Code Page 856 */
    cp855_u, 			        /* 81 Cyrillic PC Code Page 856 */
    iso_8859_1_u,                       /* 82 CP819 - Same as 8859-1 */
    iso_8859_2_u,                       /* 83 CP912 - Same as 8859-2 */
    iso_8859_3_u,                       /* 84 CP913 - Same as 8859-3 */
    iso_8859_4_u,                       /* 85 CP914 - Same as 8859-4 */
    iso_8859_5_u,                       /* 86 CP915 - Same as 8859-5 */
    iso_8859_6_u,                       /* 87 CP1089 - Same as 8859-6 */
    iso_8859_7_u,                       /* 88 CP813 - Same as 8859-7 */
    iso_8859_8_u,                       /* 89 CP916 - Same as 8859-8 */
    iso_8859_9_u,                       /* 90 CP920 - Same as 8859-9 */
    hproman8_u,			        /* 91 CP1051 -Same as HP Roman 8 */
    cp858_u,				/* 92 CP858 - W Europe w/Euro */
    iso_8859_15_u,                      /* 93 ISO 8859-15 Latin 15 */
    iso_8859_15_u,                      /* 94 CP923 - Same as 8859-15 */
    iso_8859_7_u,                       /* 95 ELOT928 - Same as 8859-7 */
    quickdraw_u,                        /* 96 CP10000 - Apple Quickdraw */
    cp37_u,                             /* 97 CP37 - U.S. EBCDIC */
    cp1255_u,                           /* 98 CP1255 - Windows Hebrew */
    cp1256_u,                           /* 99 CP1256 - Windows Arabic */
    cp1258_u,                           /* 100 CP1258 - Windows Viet Nam */
    mazovia_u,				/* 101 Mazovia PC code page */
    ident_u,    			/* 102 Transparent - no translation  */
    hz1500_u,				/* 103 Hazeltine 1500/1520 graphics */
    koi8r_u,				/* 104 KOI8-R */
    koi8u_u				/* 105 KOI8-U */
};
/*
  Table of Unicode-to-Blah translation functions.
  KEEP THIS IN SYNC WITH THE TX_blah DEFINITITIONS in ckcuni.h, and also
  with the tables above.
*/
int
#ifdef CK_ANSIC
(*xl_tx[MAXTXSETS+1])(USHORT)
#else
(*xl_tx[MAXTXSETS+1])()
#endif /* CK_ANSIC */
 = {
    tx_usascii,				/*  0 US ISO 646 (ASCII) */
    tx_british,				/*  1 UK ISO 646 */
    tx_fr_canadian,			/*  2 Canadian French NRC */
    NULL,				/*  3 Cuba */
    NULL,				/*  4 Czecho */
    tx_danish,				/*  5 Danish/Norwegian ISO 646 */
    tx_dutch,				/*  6 Dutch NRC */
    tx_finnish,				/*  7 Finnish NRC  */
    tx_french,				/*  8 French ISO 646 */
    tx_german,				/*  9 German ISO 646 */
    tx_hebrew7,				/* 10 Hebrew-7 (DEC) */
    tx_hungarian,			/* 11 Hungarian ISO 646 */
    tx_icelandic,			/* 12 Icelandic */
    tx_italian,				/* 13 Italian ISO 646 */
    tx_jis0201r,			/* 14 Japanese Roman ISO 646 */
    tx_jis0201k,			/* 15 Japanese Katakana */
    tx_koi7,				/* 16 Short KOI */
    tx_danish,				/* 17 Norwegian/Danish ISO 646 */
    tx_portuguese,			/* 18 Portuguese ISO 646 */
    tx_spanish,				/* 19 spanish ISO 646 */
    tx_swedish,				/* 20 Swedish ISO 646 */
    NULL,				/* 21 Swedish ISO 646 for names */
    tx_swiss,				/* 22 Swiss NRC   */
    tx_ident,				/* 23 ISO 8859-1  */
    tx_8859_2,				/* 24 ISO 8859-2  */
    tx_8859_3,				/* 25 ISO 8859-3  */
    tx_8859_4,				/* 26 ISO 8859-4  */
    tx_8859_5,				/* 27 ISO 8859-5  */ /* Cyrillic */
    tx_8859_6,				/* 28 ISO 8859-6  */ /* Arabic */
    tx_8859_7,				/* 29 ISO 8859-7  */ /* Greek */
    tx_8859_8,				/* 30 ISO 8859-8  */ /* Hebrew */
    tx_8859_9,				/* 31 ISO 8859-9  */ /* Latin-5 */
    tx_8859_10,				/* 32 ISO 8859-10 */ /* Latin-6 */
    tx_koi8,				/* 33 KOI-8       */
    NULL,				/* 34 JIS-7       */
    NULL,				/* 35 Shift JIS   */
    NULL,				/* 36 Japanese EUC (JAE) */
    NULL,				/* 37 Japanese DEC Kanji */
    tx_decmcs,				/* 38 DEC MCS */
    tx_nextstep,			/* 39 NeXT    */
    tx_dgi,				/* 40 DGI     */
    tx_maclatin,			/* 41 Macintosh Latin  */
    tx_hproman8,			/* 42 HP Roman 8       */
    tx_cp437,				/* 43 CP437 - Original */
    tx_cp850,				/* 44 CP850 - W Europe */
    tx_cp852,				/* 45 CP852 - E Europe */
    tx_cp857,				/* 46 CP857 - Turkish  */
    tx_cp862,				/* 47 CP862 - Hebrew   */
    tx_cp866,				/* 48 CP864 - Arabic   */
    tx_cp866,				/* 49 CP866 - Cyrillic */
    tx_cp869,				/* 50 CP869 - Greek    */
    NULL,	/* Display only */	/* 51 DEC Special Graphics */
    NULL,	/* Display only */	/* 52 DEC Technical */
    NULL,       /* Display only */      /* 53 C0 Pictures */
    NULL,       /* Display only */      /* 54 C1 Pictures */
    NULL,       /* Display only */      /* 55 IBM C0 Graphics */
    NULL,       /* Display only */      /* 56 Heath 19 graphics */
    NULL,       /* Display only */      /* 57 TVI graphics */
    NULL,       /* Display only */      /* 58 Wyse 60 normal-mode graphics */
    NULL,       /* Display only */      /* 59 Wyse 60 graphics 1 */
    NULL,       /* Display only */      /* 60 Wyse 60 graphics 2 */
    NULL,       /* Display only */      /* 61 Wyse 60 graphics 3 */
    tx_elot927,				/* 62 Greek ELOT 927 */
    NULL,       /* Display only */      /* 63 DG special graphics */
    NULL,       /* Display only */      /* 64 DG line-drawing */
    NULL,       /* Display only */      /* 65 DG word-processing */
    NULL,       /* Display only */      /* 66 HP line-drawing */
    NULL,       /* Display only */      /* 67 HP math/techical */
    NULL,       /* Display only */      /* 68 QNX Graphics */
    NULL,       /* Display only */      /* 69 SNI Brackets */
    NULL,       /* Display only */      /* 70 SNI Euro */
    NULL,       /* Display only */      /* 71 SNI Facet */
    NULL,       /* Display only */      /* 72 SNI IBM */
    NULL,       /* Display only */      /* 73 SNI Blanks */
    tx_cp1252,				/* 74 Windows Latin-1 */
    tx_cp1250,				/* 75 Windows Latin-2 */
    tx_cp1251,				/* 76 Windows Cyrillic */
    tx_cp1253,				/* 77 Windows Greek */
    tx_cp1254,				/* 78 Windows Turkish */
    tx_cp1257,				/* 79 Windows Latin-4 */
    tx_cp856,				/* 80 Cyrillic PC Code Page 856 */
    tx_cp855,				/* 81 Cyrillic PC Code Page 855 */
    tx_ident,                           /* 82 CP819 - Same as 8859-1 */
    tx_8859_2,                          /* 83 CP912 - Same as 8859-2 */
    tx_8859_3,                          /* 84 CP913 - Same as 8859-3 */
    tx_8859_4,                          /* 85 CP914 - Same as 8859-4 */
    tx_8859_5,                          /* 86 CP915 - Same as 8859-5 */
    tx_8859_6,                          /* 87 CP1089 - Same as 8859-6 */
    tx_8859_7,                          /* 88 CP813 - Same as 8859-7 */
    tx_8859_8,                          /* 89 CP916 - Same as 8859-8 */
    tx_8859_9,                          /* 90 CP920 - Same as 8859-9 */
    tx_hproman8,			/* 91 CP1051 -Same as HP Roman 8 */
    tx_cp858,				/* 92 CP858 - W Europe w/Euro */
    tx_8859_15,                         /* 93 ISO 8859-15 Latin 15 */
    tx_8859_15,                         /* 94 CP923 - Same as Latin 15 */
    tx_8859_7,                          /* 95 ELOT928 - Same as 8859-7 */
    tx_quickdraw,                       /* 96 CP10000 - Apple Quickdraw */
    tx_cp37,                            /* 97 CP37 - U.S. EBCDIC */
    tx_cp1255,                          /* 98 CP1255 - Windows Hebrew */
    tx_cp1256,                          /* 99 CP1256 - Windows Arabic */
    tx_cp1258,                          /* 100 CP1258 - Windows Viet Nam */
    tx_mazovia,				/* 101 Mazovia  PC code page */
    tx_ident,                           /* 102 Transparent - no translation */
    NULL,	/* Display only */	/* 103 Hazeltine 1500/1520 graphics */
    tx_koi8r,				/* 104 KOI8-R */
    tx_koi8u				/* 105 KOI8-U */
};

/*
  Table of FCS-to-Unicode translation functions.
  KEEP THIS IN SYNC WITH THE FC_blah DEFINITITIONS in ckuxla.h.
*/
USHORT
#ifdef CK_ANSIC
(*xl_fcu[MAXFCSETS+1])(CHAR)
#else
(*xl_fcu[MAXFCSETS+1])()
#endif /* CK_ANSIC */
= {
    ascii_u,				/*  0 US ISO 646 (ASCII) */
    british_u,				/*  1 UK ISO 646 */
    dutch_u,				/*  2 Dutch NRC */
    finnish_u,				/*  3 Finnish NRC  */
    french_u,				/*  4 French ISO 646 */
    fr_canadian_u,			/*  5 Canadian French NRC */
    german_u,				/*  6 German ISO 646 */
    hungarian_u,			/*  7 Hungarian ISO 646 */
    italian_u,				/*  8 Italian ISO 646 */
    danish_u,				/*  9 Danish/Norwegian ISO 646 */
    portuguese_u,			/* 10 Portuguese ISO 646 */
    spanish_u,				/* 11 spanish ISO 646 */
    swedish_u,				/* 12 Swedish ISO 646 */
    swiss_u,				/* 13 Swiss NRC   */
    iso_8859_1_u,			/* 14 ISO 8859-1 Latin-1 */
    iso_8859_2_u,			/* 15 ISO 8859-2 Latin-2 */
    decmcs_u,				/* 16 DEC MCS */
    nextstep_u,				/* 17 NeXT */
    cp437_u,				/* 18 CP437 - Original */
    cp850_u,				/* 19 CP850 - W Europe */
    cp852_u,				/* 20 CP852 - E Europe */
    quickdraw_u,                        /* 21 CP10000 - Apple Quickdraw */
    dgi_u,				/* 22 DGI */
    hproman8_u,				/* 23 HP Roman 8 */
    iso_8859_5_u,			/* 24 ISO 8859-5 Cyrillic */
    cp866_u,				/* 25 CP866 - Cyrillic */
    koi7_u,				/* 26 Short KOI */
    koi8_u,				/* 27 KOI-8       */
    NULL,				/* 28 JIS-7 */
    NULL,				/* 29 Shift-JIS */
    NULL,				/* 30 Japanese EUC */
    NULL,				/* 31 DEC Kanji */
    hebrew7_u,				/* 32 Hebrew-7 (DEC) */
    iso_8859_8_u,			/* 33 ISO 8859-8 Hebrew */
    cp862_u,				/* 34 CP862 Hebrew */
    elot927_u,				/* 35 Greek ELOT 927 */
    iso_8859_7_u,			/* 36 ISO 8859-7 Greek */
    cp869_u,				/* 37 CP869 Greek */
    iso_8859_15_u,                      /* 38 ISO 8859-15 Latin-9 */
    cp858_u,				/* 39 CP858 - W Europe w/Euro */
    cp855_u, 			        /* 40 Cyrillic PC Code Page 856 */
    cp1251_u,				/* 41 Windows Cyrillic */
    cp856_u,				/* 42 Bulgarian PC Code Page 856 */
    cp1250_u,				/* 43 Windows Latin-2 */
    mazovia_u,				/* 44 Mazovia PC code page */
    NULL,				/* 45 UCS-2 */
    NULL,				/* 46 UTF-8 */
    koi8r_u,				/* 47 KOI8-R */
    koi8u_u				/* 48 KOI8-U */
};

/*
  Table of Unicode-to-FCS translation functions.
  KEEP THIS IN SYNC WITH THE FC_blah DEFINITITIONS in ckuxla.h.
*/
int
#ifdef CK_ANSIC
(*xl_ufc[MAXFCSETS+1])(USHORT)
#else
(*xl_ufc[MAXFCSETS+1])()
#endif /* CK_ANSIC */
= {
    tx_usascii,				/*  0 US ISO 646 (ASCII) */
    tx_british,				/*  1 UK ISO 646 */
    tx_dutch,				/*  2 Dutch NRC */
    tx_finnish,				/*  3 Finnish NRC  */
    tx_french,				/*  4 French ISO 646 */
    tx_fr_canadian,			/*  5 Canadian French NRC */
    tx_german,				/*  6 German ISO 646 */
    tx_hungarian,			/*  7 Hungarian ISO 646 */
    tx_italian,				/*  8 Italian ISO 646 */
    tx_danish,				/*  9 Danish/Norwegian ISO 646 */
    tx_portuguese,			/* 10 Portuguese ISO 646 */
    tx_spanish,				/* 11 spanish ISO 646 */
    tx_swedish,				/* 12 Swedish ISO 646 */
    tx_swiss,				/* 13 Swiss NRC   */
    tx_ident,				/* 14 ISO 8859-1 Latin-1 */
    tx_8859_2,				/* 15 ISO 8859-2 Latin-2 */
    tx_decmcs,				/* 16 DEC MCS */
    tx_nextstep,			/* 17 NeXT */
    tx_cp437,				/* 18 CP437 - Original */
    tx_cp850,				/* 19 CP850 - W Europe */
    tx_cp852,				/* 20 CP852 - E Europe */
    tx_quickdraw,			/* 21 CP10000 - Apple Quickdraw */
    tx_dgi,				/* 22 DGI */
    tx_hproman8,			/* 23 HP Roman 8 */
    tx_8859_5,				/* 24 ISO 8859-5 Cyrillic */
    tx_cp866,				/* 25 CP866 - Cyrillic */
    tx_koi7,				/* 26 Short KOI */
    tx_koi8,				/* 27 KOI-8       */
    NULL,				/* 28 JIS-7 */
    NULL,				/* 29 Shift-JIS */
    NULL,				/* 30 Japanese EUC */
    NULL,				/* 31 DEC Kanji */
    tx_hebrew7,				/* 32 Hebrew-7 (DEC) */
    tx_8859_8,				/* 33 ISO 8859-8 Hebrew */
    tx_cp862,				/* 34 CP862 Hebrew */
    tx_elot927,				/* 35 Greek ELOT 927 */
    tx_8859_7,				/* 36 ISO 8859-7 Greek */
    tx_cp869,				/* 37 CP869 Greek */
    tx_8859_15,				/* 38 ISO 8859-15 Latin-9 */
    tx_cp858,				/* 39 CP858 - W Europe w/Euro */
    tx_cp855, 			        /* 40 Cyrillic PC Code Page 856 */
    tx_cp1251,				/* 41 Windows Cyrillic */
    tx_cp856,				/* 42 Bulgarian PC Code Page 856 */
    tx_cp1250,				/* 43 Windows Latin-2 */
    tx_mazovia,				/* 44 Mazovia PC code page */
    NULL,				/* 45 UCS-2 */
    NULL,				/* 46 UTF-8 */
    tx_koi8r,				/* 47 KOI8-R */
    tx_koi8u				/* 48 KOI8-U */
};

/*
  Table of TCS-to-Unicode translation functions.
  KEEP THIS IN SYNC WITH THE TC_blah DEFINITIONS in ckuxla.h.
*/
USHORT
#ifdef CK_ANSIC
(*xl_tcu[MAXTCSETS+1])(CHAR)
#else
(*xl_tcu[MAXTCSETS+1])()
#endif /* CK_ANSIC */
= {
    NULL,				/*  0 = Transparent */
    ascii_u,				/*  1 = ASCII */
    iso_8859_1_u,			/*  2 ISO 8859-1 Latin-1 */
    iso_8859_2_u,			/*  3 ISO 8859-2 Latin-2 */
    iso_8859_5_u,			/*  4 ISO 8859-5 Cyrillic */
    NULL,				/*  5 Japanese EUC */
    iso_8859_8_u,			/*  6 ISO 8859-8 Hebrew */
    iso_8859_7_u,			/*  7 ISO 8859-7 Greek */
    iso_8859_15_u,                      /*  8 ISO 8859-15 Latin-9 */
    NULL,				/*  9 UCS-2 */
    NULL				/* 10 UTF-8 */
};


/*
  Table of Unicode-to-TCS translation functions.
  KEEP THIS IN SYNC WITH THE TC_blah DEFINITIONS in ckuxla.h.
*/
int
#ifdef CK_ANSIC
(*xl_utc[MAXTCSETS+1])(USHORT)
#else
(*xl_utc[MAXTCSETS+1])()
#endif /* CK_ANSIC */
= {
    NULL,				/*  0 = Transparent */
    tx_usascii,				/*  1 = ASCII */
    tx_ident,				/*  2 ISO 8859-1 Latin-1 */
    tx_8859_2,				/*  3 ISO 8859-2 Latin-2 */
    tx_8859_5,				/*  4 ISO 8859-5 Cyrillic */
    NULL,				/*  5 Japanese EUC */
    tx_8859_8,				/*  6 ISO 8859-8 Hebrew */
    tx_8859_7,				/*  7 ISO 8859-7 Greek */
    tx_8859_15,				/*  8 ISO 8859-15 Latin-9 */
    NULL,				/*  9 UCS-2 */
    NULL				/* 10 UTF-8 */
};

#ifdef COMMENT
/*
  The UTF8 conversions are based on the ConvertUTF functions written
  by Mark E. Davis, copyright 1994 Taligent, Inc.

  Tables for use in calculating UTF8 conversions.  These contain
  support for ISO-10646 which supports a 31-bit char size.

  NOTE: 0xnnnUL is NOT portable!
*/
ULONG
offsetsFromUTF8[7] = {
#ifdef CK_ANSIC
    0x00000000UL, /* Ignored */
    0x00000000UL, 0x00003080UL, 0x000E2080UL,
    0x03C82080UL, 0xFA082080UL, 0x82082080UL
#else
    0x00000000L, /* Ignored */
    0x00000000L, 0x00003080L, 0x000E2080L,
    0x03C82080L, (unsigned) 0xFA082080L, (unsigned) 0x82082080L
#endif /* CK_ANSIC */
};

CHAR bytesInUTF8[256] = {
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
    2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2, 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
    3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3, 4,4,4,4,4,4,4,4,5,5,5,5,6,6,6,6
};
#endif /* COMMENT */

CHAR firstByteMark[7] = {0x00, 0x00, 0xC0, 0xE0, 0xF0, 0xF8, 0xFC};

/*
  utf8_to_ucs2() takes one UTF-8 byte at a time.  It returns a pointer the
  UCS-2 character if and only if the entire UTF-8 string has been received.
  Return values:
   0: Complete UTF-8 sequence received; ucs2 points to valid ucs2 character.
  >0: UTF-8 sequence incomplete, ignore ucs2 value.
  <0: UTF-8 error, 0xfffd should be inserted BEFORE the ucs2 value.

  NOTE: A negative value is returned only when two return values are indicated,
  e.g. when a UTF-8 sequence is interrupted by an ASCII char.  In this case
  the incomplete UTF-8 sequence must be replaced by 0xfffd, and then the ASCII
  character is kept as-is.  In other error cases, ucs2 is set to 0xfffd and
  the return value is 0.
*/
#define UTFBUFSIZ 16

int
#ifdef CK_ANSIC
utf8_to_ucs2(CHAR ch, USHORT ** ucs2)
#else
utf8_to_ucs2(ch, ucs2) CHAR ch; USHORT ** ucs2;
#endif /* CK_ANSIC */
{
    static USHORT ucs2return = 0;

#ifdef COMMENT
    /* Unicode Consortium sample code works only with well-formed UTF8 */

    int i = 0;
    static int len = 0;
    static CHAR utf8[UTFBUFSIZ] = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
    ULONG ucs4 = 0;

    utf8[len++] = ch;			/* Add char to string to process */

    if (len < bytesInUTF8[utf8[0]])	/* Need more bytes */
      return(bytesInUTF8[utf8[0]] - len);

    switch (len) {			/* Have complete sequence... */
      case 6: ucs4 += utf8[i++]; ucs4 <<= 6; /* (fall-thru is intentional) */
      case 5: ucs4 += utf8[i++]; ucs4 <<= 6;
      case 4: ucs4 += utf8[i++]; ucs4 <<= 6;
      case 3: ucs4 += utf8[i++]; ucs4 <<= 6;
      case 2: ucs4 += utf8[i++]; ucs4 <<= 6;
      case 1: ucs4 += utf8[i++];
    }
    ucs4 -= offsetsFromUTF8[len];
    ucs2return = (USHORT)(ucs4 & 0xFFFF);
#ifdef DEBUG
    /* This shows that our return value is in the prevailing byte order: */
    /* e.g. LE on PC, BE on Sparc. */
    if (deblog) {
	char buf[16];
	union ck_short xx;
	xx.x_short = ucs2return;
	sprintf(buf,"%04X",ucs2return);
	debug(F111,"utf8_to_ucs2 short",buf,ucs2return);
	debug(F101,"utf8_to_ucs2 char[0]","",xx.x_char[0]);
	debug(F101,"utf8_to_ucs2 char[1]","",xx.x_char[1]);
    }
#endif /* DEBUG */
    *ucs2 = &ucs2return;
    len = 0;
    return(0);
#else
    /*
       Robuster code adapted from Thomas Dickey, Xfree86,
       recommended by Markus Kuhn.
    */
    static int utfcount = 0;		/* Position in UTF sequence */
    int utferror = 0;			/* Flag for malformed UTF */
    unsigned c = ch;			/* Input byte */
    int haveucs2 = 0;

    if (ch < 0x80) {			/* ASCII char... */
	if (utfcount > 0)		/* Not legal in UTF-8 sequence */
	  utferror = 1;			/* so flag */
	haveucs2 = 1;
	ucs2return = ch;		/* but also return it */
	utfcount = 0;			/* reset UTF-8 count */
    } else if (ch < 0xc0) {		/* 0x80 <= c < 0xc0... */
	if (utfcount < 1) {		/* Not valid in first position... */
	    utferror = 1;
	} else {			/* Maybe valid */
	    if (ucs2return > 0x03ff) {	/* Value would be > 0xffff */
		utferror = 1;		/* so not valid */
	    } else {			/* OK... */
		ucs2return <<= 6;	/* Shift result */
		ucs2return |= (ch & 0x3f); /* and OR in this byte */
	    }
	    if (--utfcount == 0)
	      haveucs2 = 1;
	}
    } else {				/* c >= 0xc0... */
	if (utfcount > 0)
	  utferror = 1;
	if (c < 0xe0) {
	    utfcount = 1;
	    ucs2return = (c & 0x1f);
	    haveucs2 = 1;
	} else if (c < 0xf0) {
	    utfcount = 2;
	    ucs2return = (c & 0x0f);
	    haveucs2 = 1;
	} else if (c < 0xf8) {
	    utfcount = 3;
	    ucs2return = (c & 0x07);
	    haveucs2 = 1;
	} else if (c < 0xfc) {
	    utfcount = 4;
	    ucs2return = (c & 0x03);
	    haveucs2 = 1;
	} else if (c < 0xfe) {
	    utfcount = 5;
	    ucs2return = (c & 0x01);
	    haveucs2 = 1;
	} else {
	    utferror = 1;
	    utfcount = 0;
	}
    }
    if (haveucs2 == 0 && utferror != 0) {
	haveucs2 = 1;
	ucs2return = 0xfffd;
	utferror = 0;
    }
    if (haveucs2) {
	*ucs2 = &ucs2return;
	if (utferror)
	  utfcount = 0 - utfcount;
	return(utfcount);
    } else {
	if (utfcount == 0)
	  utfcount++;
	return(utfcount);
    }
#endif /* COMMENT */
}

/*
  ucs2_to_utf8() takes one ucs2 character and returns the length and
  and a pointer to an array containing the equivalent utf8 string.
  This code can easily be altered to support UCS4 simply by changing
  the input from USHORT to ULONG.  Returns:
   >0: Number of bytes in the utf8 string.
    0: (or less) Error.
*/

int
#ifdef CK_ANSIC
ucs2_to_utf8(USHORT ucs2, CHAR ** utf8)
#else
ucs2_to_utf8(ucs2, utf8) USHORT ucs2; CHAR ** utf8;
#endif /* CK_ANSIC */
{
    static CHAR utf8return[8]={0,0,0,0,0,0,0,0};
    register CONST ULONG byteMask = 0xBF;
    register CONST ULONG byteMark = 0x80;
    int utf8len = 0;
    int i = 0;

    if (ucs2 < 0x80) {
        utf8len = 1;
	debug(F101,"ucs2_to_utf8 X1","",utf8len);
    } else if (ucs2 < 0x800) {
        utf8len = 2;
	debug(F101,"ucs2_to_utf8 X2","",utf8len);
    } else
#ifdef DO_UCS4
      /* This is always true for UCS-2 but would be needed for UCS-4*/
      /* When ucs2 is USHORT this gives compiler warnings. */
      if (ucs2 <= 0xffff)
#endif /* DO_UCS4 */
    {
        utf8len = 3;
	debug(F101,"ucs2_to_utf8 X3","",utf8len);
    }
#ifdef DO_UCS4
/* The following would be for UCS-4 */
    else if (ucs2 < 0x200000) {
        utf8len = 4;
    } else if (ucs2 < 0x4000000) {
        utf8len = 5;
    } else if (ucs2 <=
#ifdef CK_ANSIC
	       0x7FFFFFFFUL		/* (doesn't really need the "U") */
#else
	       0x7FFFFFFFL
#endif /* CK_ANSIC */
	       ) {			/* 31 bits = max for UCS4 */
        utf8len = 6;
    } else {
        utf8len = 2;
        ucs2 = 0xFFFD;                  /* Replacement for invalid char */
    }
#endif /* DO_UCS4 */
    i = utf8len;                        /* index into utf8return */
    utf8return[i--] = 0;                /* Null terminate the string */

    switch (utf8len) {	                /* code falls through cases! */
      case 6: utf8return[i--] = (ucs2 | byteMark) & byteMask; ucs2 >>= 6;
      case 5: utf8return[i--] = (ucs2 | byteMark) & byteMask; ucs2 >>= 6;
      case 4: utf8return[i--] = (ucs2 | byteMark) & byteMask; ucs2 >>= 6;
      case 3: utf8return[i--] = (ucs2 | byteMark) & byteMask; ucs2 >>= 6;
      case 2: utf8return[i--] = (ucs2 | byteMark) & byteMask; ucs2 >>= 6;
      case 1: utf8return[i--] =  ucs2 | firstByteMark[utf8len];
    }
    debug(F111,"ucs2_to_utf8",utf8return,utf8len);
    *utf8 = utf8return;
    return(utf8len);
}

/*  UTF-8 functions...  */

#ifdef CK_ANSIC
extern int (*xuf)(USHORT);		/* Translation function UCS to FCS */
extern USHORT (*xfu)(CHAR);		/* Translation function FCS to UCS */
#else
extern int (*xuf)();
extern USHORT (*xfu)();
#endif /* CK_ANSIC */

/*  u _ t o _ b  --  UTF-8 to Byte  */
/*
    Converts from UTF-8 to the current terminal or file character set.
    Call with:
      c: a single byte, which is part of a UTF-8 stream.
    Returns:
     -9: Error, with second char to follow (call u_to_b2() to get it).
     -2: UCS line/paragraph end (LS or PS).
     -1: UTF-8 stream is incomplete and more input is required.
     >=0: Byte value of result, possibly the "error" byte (e.g. '?').
    Requires:
      Global (*xuf)() to point to a function that translates from UCS-2 to
      the appropriate term/file character set.
*/
static int savedbyte = 0;

int					/* Call if u_to_b() returns -9 */
u_to_b2() {
    return((unsigned)(savedbyte & 0xff));
}

int					/* UTF-8 to byte */
#ifdef CK_ANSIC
u_to_b(CHAR c)
#else
u_to_b(c) CHAR c;
#endif /* CK_ANSIC */
{
    int x;
    USHORT * ucs2, uc;
    if (!xuf)				/* If no conversion function */
      return(c);			/* don't convert (shouldn't happen). */
    x = utf8_to_ucs2(c,&ucs2);		/* Send for conversion to UCS-2 */
    if (x > 0)				/* Not done yet... */
      return(-1);
    uc = (x < 0) ? 0xfffd : *ucs2;	/* Done, check result */
    if (uc == 0x2028 || uc == 0x2029)	/* LS or PS */
      return(-2);
    return((unsigned)(((*xuf)(uc)) & 0xff)); /* Convert UCS-2 to byte */
}

/*  b _ t o _ u  --  Byte to UTF-8  */
/*
  Converts a byte from the current terminal or file character set to UTF-8.
  Call with:
    c........ The byte to be converted.
    buf...... Pointer to buffer in which to place the result.
    buflen... Length of the result buffer.
    setsize.. The size of the source character set (128 or 256).
  Requires:
    Global (*xfu)() to point to the function to convert the byte to UCS-2.
  Returns:
    -1 if the xfu is NULL; otherwise:
    >0 indicating the length (in bytes) of the UTF-8 string.
  If the translation fails, the Unicode "Replacement Character" is returned
  (0xFFFD translated to UTF-8 == 0xFFBD).
*/
int					/* Byte to UTF-8 */
#ifdef CK_ANSIC
b_to_u(CHAR c, CHAR * buf, int buflen, int setsize)
#else
b_to_u(c, buf, buflen, setsize) CHAR c, * buf; int buflen, setsize;
#endif /* CK_ANSIC */
{
    CHAR * tmp = NULL;
    int i, count = 0;
    USHORT uc;
    if (!xfu) {
	debug(F100,"b_to_u no xfu","",0);
	return(-1);
    }
    uc = c;
    if (((setsize > 128) && (c & 0x80)) || setsize <= 128) {
	if (xfu)			/* FCS-to-UCS function */
	  uc = (*xfu)(c);
    }
    count = ucs2_to_utf8(uc,&tmp);
    if (count < 0) {
	buf[0] = 0xff;			/* == 0xFFFD in UTF-8 */
	buf[1] = 0xbd;
	buf[3] = '\0';
	return(2);
    }
    if (count >= buflen) {
	debug(F101,"WARNING: UTF8 buffer overflow","",count);
	count = buflen - 1;
    }
    for (i = 0; i < count; i++)		/* Copy to result buffer */
      buf[i] = tmp[i];
    buf[i] = '\0';
    return(count);
}

#ifndef OS2
int
isunicode(				/* Tells whether the host we are */
#ifdef CK_ANSIC				/* running on supports Unicode */
	  void				/* display */
#endif /* CK_ANSIC */
	  ) {
    extern int tt_unicode;
#ifdef NT
#ifdef KUI
    return(tt_unicode);
#else /* KUI */
    if (tt_unicode && !isWin95())
      return(1);
    else
      return(0);
#endif /* KUI */
#else /* NT */
    return(0);
#endif /* NT */
}
#endif /* OS2 */
#endif /* UNICODE */
