static char dqs_daemonize_rcsid[]="$Id: dqs_daemonize.c,v 1.3 1998/10/13 15:08:48 green Exp $";

/*----------------------------------------------------
 * dqs_daemonize.c Tom Green Mon Jan 31 10:42:40 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_daemonize.c,v $
 * Revision 1.3  1998/10/13 15:08:48  green
 * Solaris 2.6 support - hopefully, as I don't have access to one...
 *
 * Revision 1.2  1998/10/13 14:23:12  green
 * Patching Solaris defines - shooting in the dark here as I don't have access to
 * a Solaris 2.5 box
 *
 * Revision 1.1.1.1  1998/08/18 14:39:11  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.1.1.1  1997/04/10 15:10:32  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.5  1996/11/20 23:03:30  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.4  1995/07/12  20:13:14  nrl
 * changed direct calls to getpgrp to macro GETPGRP
 *
 * Revision 3.3  1995/07/12  18:47:50  nrl
 * Fixed numerous problmes with Irix 5.3 and 6.0 systems
 *
 * Revision 3.2  1995/05/29  18:08:48  nrl
 * More solaris stuff GAGGHH had to differentiate more cases of
 * solaris2.3 and solaris2.4 stuff
 *
 * Revision 3.1  1994/06/02  13:44:29  green
 * attempt to port to Sloaris...
 * Work In Progress(WIPed)
 *
 * Revision 3.0  1994/03/07  04:13:37  green
 * 3.0 freeze
 *
 * Revision 1.1.1.1  1994/02/01  17:57:39  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/*************************************************************************/
void dqs_daemonize()
     
     /*
       dqs_daemonize - throws ourself into the background and dissassociates
       from any controlling ttys
     */
     
{
  int i,fd;
  double avg[3];
  
  char domname[4000];
  
  DENTER((DQS_EVENT,"dqs_daemonize"));
  
  if (DEBUG_ON|EXT_DEBUG_ON) {
    DEXIT;
    return;
  }
  
  if (fork() != 0) /* 1st child not pgrp leader */ 
    exit(0);
  
  SETPGRP;
#if (defined(__hpux) || defined(_UNICOS) || defined(sun) || defined(solaris) || defined(SOLARIS23_UP) )
  /*   empty */
#else
  if ((fd=open("/dev/tty",O_RDWR))>=0) { /* disassociate contolling tty */
    ioctl(fd,TIOCNOTTY,(char *)NULL);
    close(fd);
  }
#endif
  
  /* shotgun */ 
  
  if (fork() != 0)
    exit(0);
  
#ifdef __sgi
  
  /* clean up socket needed because of IRIX bug     */	
  
  (void) getdomainname(domname, sizeof(domname));
  yp_unbind(domname);
  
#endif     
  
  for (fd=0;fd<NOFILE;fd++)
    close(fd);
  
  /* new descriptors acquired for stdin, stdout, stderr should be 0,1,2 */
  
  i=open("/dev/null",O_RDONLY,0);
  if (i!=0) abort();
  i=open("/dev/null",O_WRONLY,0);
  if (i!=1) abort();
  i=open("/dev/null",O_WRONLY,0);
  if (i!=2) abort();
  
  
  /* since closed all fds we need to force a reassociation of the kmem fd */
  
  
  (void) getloadavg(avg, 3);
  (void) getloadavg(avg, 3);
  
  SETPGRP;
  SETPRIORITY(-10);
  
  me.pid=getpid();
  me.ppid=getppid();
  
  me.pgrp=GETPGRP;
  me.daemonized=TRUE;
  
  
  DEXIT;
  
  return;
  
}
