/* DO_NOT_STRIP_HEADER */

/*----------------------------------------------------
 * stripheader.c Tom Green Sun Dec 12 16:17:30 1993
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 *--------------------------------------------------*/

#define MAINPROGRAM
#include "../SRC/h.h"
#include "../SRC/def.h"
#include "../SRC/dqs.h"
#include "../SRC/struct.h"
#include "../SRC/func.h"
#include "../SRC/globals.h"
#include "../SRC/dqs_errno.h"

int add_header=0;
int do_not_rewrite;
#define ADD_HEADER 1
#define ADD_HEADER_WITH_LOG 2

/**********************************************************************/
main(argc,argv,envp)
int argc;
char **argv;
char **envp;

{

     int i=1;
     int j;
     int has_header=FALSE;
     char c;
     FILE *fp;
     dqs_list_type *head;
     dqs_list_type listel;
     string str;

     DENTER_MAIN((DQS_EVENT,"stripheader"));

     if (!strcmp(argv[1],"-a"))
     {
	  i++;
	  add_header=ADD_HEADER;
     }
     else if (!strcmp(argv[1],"-al"))
     {
          i++;
          add_header=ADD_HEADER_WITH_LOG;
     }

     for (j=i;j<argc;j++)
     {
	  do_not_rewrite=FALSE;
	  has_header=FALSE;
          fp=fopen(argv[j],"r");
          if (!fp)
          {
               ERROR((DQS_EVENT,"error opening %s for reading\n",argv[j]));
               exit(-1);
          }
	  printf("reading %s",argv[j]);
	  head=NULL;
	  bzero(str,sizeof(str));
	  while (fscanf(fp,"%[^\n]",str)!=EOF)
	  {
	       bzero(&listel,sizeof(listel));
	       listel.str0=dqs_string_insert(NULL,str);
	       if (strstr(str,"DO_NOT_STRIP_HEADER"))
	       do_not_rewrite=TRUE;
	       if (strstr(str," *--------------------------------------------------*/"))
	       {
		    printf(" - found delimitor");
		    head=dqs_free_list(head);
	       }
	       else
	       head=dqs_insert(DQS_STR0,TAIL,head,&listel);
               c=getc(fp);
               if (c==EOF)
               break;
               bzero(str,sizeof(str));

	  }
	  fclose(fp);
	  printf(" done\n");
	  write_file(argv[j],head);
	  head=dqs_free_list(head);
	  printf("================================================\n");
     }
}

/**********************************************************************/
int write_file(fname,head)
char *fname;
dqs_list_type *head;

{

     FILE *fp;

     DENTER((DQS_EVENT,"write_file"));
     
     unlink("foobar");
     printf("writing tmpfile \"foobar\"");
     fp=fopen("foobar","w");
     if (!fp)
     {
	  ERROR((DQS_EVENT,"error opening foobar for writing\n"));
	  exit(-1);
     }
     if (add_header)
     write_header(fname,fp);
     while (head)
     {
	  fprintf(fp,"%s\n",head->str0);
	  head=head->next;
     }
     printf(" done--\n");
     
     unlink(fname);
     rename("foobar",fname);

     DEXIT;
     return(0);

}
     
/**********************************************************************/
int write_header(fname,fp)
char *fname;
FILE *fp;

{
     char     *cp;
     string   str;
     u_long32 now;

     DENTER((DQS_EVENT,"write_header"));

     if (do_not_rewrite)
     {
	  ERROR((DQS_EVENT,"\n\"%s\" should not be rewritten\n"));
	  DEXIT;
	  return(0);
     }

     now=dqs_get_gmt();
     strcpy(str,fname);
     cp=strtok(str,".");

     if (strstr(fname,".c") || strstr(fname,".h"))
     {
	  if (add_header==ADD_HEADER_WITH_LOG)
	  fprintf(fp,"static char %s_rcsid[]=\"$Id: stripheader.c,v 1.1.1.1 1998/08/18 14:39:15 green Exp $\";\n\n",cp);
	  fprintf(fp,"/*----------------------------------------------------\n");
	  fprintf(fp," * %s Tom Green %s",fname,ctime((time_t *)&now));
	  fprintf(fp," *\n");
	  fprintf(fp," * Copyright 1993\n");
	  fprintf(fp," *\n");
	  fprintf(fp," * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE\n");
	  fprintf(fp," *            FLORIDA STATE UNIVERSITY\n");
	  fprintf(fp," *\n");
	  fprintf(fp," *\n");
	  fprintf(fp," * SCRI representatives make no claims about the\n");
	  fprintf(fp," * suitability of this software for any purpose.\n");
	  fprintf(fp," * It is provided \"as is\" without express or\n");
	  fprintf(fp," * implied warranty.\n");
	  fprintf(fp," *\n");
	  if (add_header==ADD_HEADER_WITH_LOG)
	  fprintf(fp," * $Log: stripheader.c,v $
	  fprintf(fp," * Revision 1.1.1.1  1998/08/18 14:39:15  green
	  fprintf(fp," * DQS 3.2.0.5 WIP Import
	  fprintf(fp," *
	  fprintf(fp," * Revision 1.1.1.1  1997/04/10 15:10:36  green
	  fprintf(fp," * DQS 3.1.3.4.1 Distribution
	  fprintf(fp," *
	  fprintf(fp," * Revision 3.0  1994/03/07 04:16:30  green
	  fprintf(fp," * 3.0 freeze
	  fprintf(fp," *
 * Revision 1.1.1.1  1994/02/01  17:57:56  green
 * DQS 3.0 ALPHA
 *\n");
	  fprintf(fp," *--------------------------------------------------*/\n");
     }
     else
     {
	  ERROR((DQS_EVENT,"\nUNKNOWN FILE TYPE \"%s\"",fname));
	  DEXITE;
	  exit(-1);
     }

     DEXIT;
     return(0);

}
