#!/usr/bin/perl

###
### Convert MSIIS logfile format into real W3C Extended Format.
###
### Copyright 1999 by Stefan Stapelberg, RENT-A-GURU.
###
### Please feel free to distribute and/or modify according to your needs.
### Don't give Billyboy any change to do pollution on open standards.
###
### --------------------------------------------------------------------------
### Fields on input:
###   time ipnum username method uri-stem uri-query status bytes uagent refURL
###
### Fields on output:
###   ipnum reserved username time method uri proto status bytes uagen refURL
### --------------------------------------------------------------------------

$tz   = "-0800";	# default timezone (not used anyway)
$prot = "HTTP/1.0";	# default protocol
$line = 0;		# line counter

while (<STDIN>) {
	chop;
	$line++;
        ($timestamp,$ipnum,$username,$method,$uri,$uriquery,$status,$bytes,$uagent,$referrer) = split(/ /);
	if ($timestamp !~ /^(\d\d\d\d)-(\d\d)(\d\d)-(\d\d):(\d\d):(\d\d)$/) {
		print STDERR "invalid timestamp at line $line: $timestamp\n";
		next;
	}

	# Now transform the timestamp
	$yr = $1; $mt = $2; $dy = $3;
	$hr = $4; $mn = $5; $sc = $6;
	$mon = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec")[$mt-1];

	# Replace '+' by blanks in the user agent field.
	# Note that blanks in the URI and referrer URL fields are
	# invalid, but sometimes appear due to broken servers.
	$uagent =~ s/\+/ /g;
	#$referrer =~ s/\+/ /g;
        print "$ipnum - $username [$dy/$mon/$yr:$hr:$mn:$sc $tz] \"$method $uri $prot\" $status $bytes $uagent $referrer\n";
}

exit(0);

