/*
** Country codes for http-analyze
**
** Copyright  1996-1999 by Stefan Stapelberg, <stefan@rent-a-guru.de>
**
** $Id: cntrycode.h,v 2.4 1999/10/30 09:39:54 stefan Stab $
**
*/

/*
** Macros for country management.
*/
#define CC_CHR(c1)		((u_long)((c1)-'a'+1))
#define CC_PAIR(c1,c2)		((CC_CHR(c1)<<5L)|CC_CHR(c2))
#define CC_PAIR3(c1,c2,c3)	((CC_PAIR(c1,c2)<<5L)|CC_CHR(c3))
#define CC_PAIR4(c1,c2,c3,c4)	((CC_PAIR3(c1,c2,c3)<<5L)|CC_CHR(c4))
#define CC_PAIR5(c1,c2,c3,c4)	((CC_PAIR4(c1,c2,c3,c4)<<5L)|CC_CHR(c5))

/*
** Default list of all valid top-level domains.
*/
static COUNTRY def_country[] = {
	/* International ISO two-letter country codes */
	{ CC_PAIR('a', 'd'), "Andorra",			NULL, 474, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'e'), "United Arab Emirates",	NULL, 475, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'f'), "Afghanistan",		NULL, 476, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'g'), "Antigua and Barbuda",	NULL, 477, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'i'), "Anguilla",		NULL, 478, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'l'), "Albania",			NULL, 479, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'm'), "Armenia",			NULL, 480, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'n'), "Netherlands Antilles",	NULL, 481, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'o'), "Angola",			NULL, 482, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'q'), "Antarctica",		NULL, 483, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'r'), "Argentina",		NULL, 484, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 's'), "American Samoa",		NULL, 485, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 't'), "Austria",			NULL, 486, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'u'), "Australia",		NULL, 487, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'w'), "Aruba",			NULL, 488, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'z'), "Azerbaijan",		NULL, 489, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'a'), "Bosnia and Herzegovina",	NULL, 490, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'b'), "Barbados",		NULL, 491, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'd'), "Bangladesh",		NULL, 492, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'e'), "Belgium",			NULL, 493, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'f'), "Burkina Faso",		NULL, 494, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'g'), "Bulgaria",		NULL, 495, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'h'), "Bahrain",			NULL, 496, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'i'), "Burundi",			NULL, 497, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'j'), "Benin",			NULL, 498, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'm'), "Bermuda",			NULL, 499, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'n'), "Brunei Darussalam",	NULL, 500, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'o'), "Bolivia",			NULL, 501, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'r'), "Brazil",			NULL, 502, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 's'), "Bahamas",			NULL, 503, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 't'), "Bhutan",			NULL, 504, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'v'), "Bouvet Island",		NULL, 505, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'w'), "Botswana",		NULL, 506, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'y'), "Belarus",			NULL, 507, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'z'), "Belize",			NULL, 508, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'a'), "Canada",			NULL, 509, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'c'), "Cocos (Keeling) Islands", NULL, 510, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'd'), "Democratic Republic of the Congo",NULL, 511, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'f'), "Central African Republic",NULL, 512, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'g'), "Congo",			NULL, 513, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'h'), "Switzerland",		NULL, 514, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'i'), "Cote D'Ivoire (Ivory Coast)",NULL, 515, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'k'), "Cook Islands",		NULL, 516, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'l'), "Chile",			NULL, 517, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'm'), "Cameroon",		NULL, 518, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'n'), "China",			NULL, 519, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'o'), "Colombia",		NULL, 520, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'r'), "Costa Rica",		NULL, 521, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 's'), "Czechoslovakia (former)", NULL, 522, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'u'), "Cuba",			NULL, 523, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'v'), "Cape Verde",		NULL, 524, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'x'), "Christmas Island",	NULL, 525, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'y'), "Cyprus",			NULL, 526, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'z'), "Czech Republic",		NULL, 527, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('d', 'e'), "Germany",			NULL, 528, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('d', 'j'), "Djibouti",		NULL, 529, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('d', 'k'), "Denmark",			NULL, 530, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('d', 'm'), "Dominica",		NULL, 531, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('d', 'o'), "Dominican Republic",	NULL, 532, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('d', 'z'), "Algeria",			NULL, 533, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('e', 'c'), "Ecuador",			NULL, 534, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('e', 'e'), "Estonia",			NULL, 535, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('e', 'g'), "Egypt",			NULL, 536, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('e', 'h'), "Western Sahara",		NULL, 537, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('e', 'r'), "Eritrea",			NULL, 538, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('e', 's'), "Spain",			NULL, 539, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('e', 't'), "Ethiopia",		NULL, 540, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('f', 'i'), "Finland",			NULL, 541, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('f', 'j'), "Fiji",			NULL, 542, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('f', 'k'), "Falkland Islands (Malvinas)",NULL, 543, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('f', 'm'), "Micronesia",		NULL, 544, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('f', 'o'), "Faroe Islands",		NULL, 545, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('f', 'r'), "France",			NULL, 546, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('f', 'x'), "France, Metropolitan",	NULL, 547, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'a'), "Gabon",			NULL, 548, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'b'), "Great Britain (UK)",	NULL, 549, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'd'), "Grenada",			NULL, 550, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'e'), "Georgia",			NULL, 551, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'f'), "French Guiana",		NULL, 552, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'h'), "Ghana",			NULL, 553, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'i'), "Gibraltar",		NULL, 554, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'l'), "Greenland",		NULL, 555, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'm'), "Gambia",			NULL, 556, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'n'), "Guinea",			NULL, 557, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'p'), "Guadeloupe",		NULL, 558, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'q'), "Equatorial Guinea",	NULL, 559, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'r'), "Greece",			NULL, 560, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 's'), "S. Georgia and S. Sandwich Isls.",NULL, 561, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 't'), "Guatemala",		NULL, 562, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'u'), "Guam",			NULL, 563, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'w'), "Guinea-Bissau",		NULL, 564, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'y'), "Guyana",			NULL, 565, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('h', 'k'), "Hong Kong",		NULL, 566, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('h', 'm'), "Heard and McDonald Islands",NULL, 567, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('h', 'n'), "Honduras",		NULL, 568, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('h', 'r'), "Croatia (Hrvatska)",	NULL, 569, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('h', 't'), "Haiti",			NULL, 570, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('h', 'u'), "Hungary",			NULL, 571, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 'd'), "Indonesia",		NULL, 572, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 'e'), "Ireland",			NULL, 573, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 'l'), "Israel",			NULL, 574, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 'n'), "India",			NULL, 575, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 'o'), "British Indian Ocean Territory",NULL, 576, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 'q'), "Iraq",			NULL, 577, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 'r'), "Iran",			NULL, 578, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 's'), "Iceland",			NULL, 579, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 't'), "Italy",			NULL, 580, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('j', 'm'), "Jamaica",			NULL, 581, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('j', 'o'), "Jordan",			NULL, 582, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('j', 'p'), "Japan",			NULL, 583, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'e'), "Kenya",			NULL, 584, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'g'), "Kyrgyzstan",		NULL, 585, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'h'), "Cambodia",		NULL, 586, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'i'), "Kiribati",		NULL, 587, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'm'), "Comoros",			NULL, 588, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'n'), "Saint Kitts and Nevis",	NULL, 589, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'p'), "Korea (North)",		NULL, 590, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'r'), "Korea (South)",		NULL, 591, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'w'), "Kuwait",			NULL, 592, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'y'), "Cayman Islands",		NULL, 593, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'z'), "Kazakhstan",		NULL, 594, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'a'), "Laos",			NULL, 595, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'b'), "Lebanon",			NULL, 596, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'c'), "Saint Lucia",		NULL, 597, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'i'), "Liechtenstein",		NULL, 598, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'k'), "Sri Lanka",		NULL, 599, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'r'), "Liberia",			NULL, 600, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 's'), "Lesotho",			NULL, 601, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 't'), "Lithuania",		NULL, 602, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'u'), "Luxembourg",		NULL, 603, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'v'), "Latvia",			NULL, 604, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'y'), "Libya",			NULL, 605, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'a'), "Morocco",			NULL, 606, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'c'), "Monaco",			NULL, 607, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'd'), "Moldova",			NULL, 608, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'g'), "Madagascar",		NULL, 609, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'h'), "Marshall Islands",	NULL, 610, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'k'), "Macedonia",		NULL, 611, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'l'), "Mali",			NULL, 612, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'm'), "Myanmar",			NULL, 613, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'n'), "Mongolia",		NULL, 614, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'o'), "Macau",			NULL, 615, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'p'), "Northern Mariana Islands",NULL, 616, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'q'), "Martinique",		NULL, 617, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'r'), "Mauritania",		NULL, 618, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 's'), "Montserrat",		NULL, 619, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 't'), "Malta",			NULL, 620, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'u'), "Mauritius",		NULL, 621, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'v'), "Maldives",		NULL, 622, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'w'), "Malawi",			NULL, 623, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'x'), "Mexico",			NULL, 624, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'y'), "Malaysia",		NULL, 625, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'z'), "Mozambique",		NULL, 626, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'a'), "Namibia",			NULL, 627, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'c'), "New Caledonia",		NULL, 628, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'e'), "Niger",			NULL, 629, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'f'), "Norfolk Island",		NULL, 630, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'g'), "Nigeria",			NULL, 631, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'i'), "Nicaragua",		NULL, 632, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'l'), "Netherlands",		NULL, 633, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'o'), "Norway",			NULL, 634, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'p'), "Nepal",			NULL, 635, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'r'), "Nauru",			NULL, 636, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 't'), "Neutral Zone",		NULL, 637, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'u'), "Niue",			NULL, 638, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'z'), "New Zealand (Aotearoa)",	NULL, 639, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('o', 'm'), "Oman",			NULL, 640, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'a'), "Panama",			NULL, 641, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'e'), "Peru",			NULL, 642, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'f'), "French Polynesia",	NULL, 643, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'g'), "Papua New Guinea",	NULL, 644, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'h'), "Philippines",		NULL, 645, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'k'), "Pakistan",		NULL, 646, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'l'), "Poland",			NULL, 647, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'm'), "St. Pierre and Miquelon",	NULL, 648, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'n'), "Pitcairn",		NULL, 649, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'r'), "Puerto Rico",		NULL, 650, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 't'), "Portugal",		NULL, 651, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'w'), "Palau",			NULL, 652, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'y'), "Paraguay",		NULL, 653, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('q', 'a'), "Qatar",			NULL, 654, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('r', 'e'), "Reunion",			NULL, 655, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('r', 'o'), "Romania",			NULL, 656, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('r', 'u'), "Russian Federation",	NULL, 657, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('r', 'w'), "Rwanda",			NULL, 658, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'a'), "Saudi Arabia",		NULL, 659, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'b'), "Solomon Islands",		NULL, 660, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'c'), "Seychelles",		NULL, 661, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'd'), "Sudan",			NULL, 662, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'e'), "Sweden",			NULL, 663, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'g'), "Singapore",		NULL, 664, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'h'), "St. Helena",		NULL, 665, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'i'), "Slovenia",		NULL, 666, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'j'), "Svalbard and Jan Mayen Islands",NULL, 667, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'k'), "Slovak Republic",		NULL, 668, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'l'), "Sierra Leone",		NULL, 669, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'm'), "San Marino",		NULL, 670, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'n'), "Senegal",			NULL, 671, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'o'), "Somalia",			NULL, 672, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'r'), "Suriname",		NULL, 673, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 't'), "Sao Tome and Principe",	NULL, 674, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'u'), "USSR (former)",		NULL, 675, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'v'), "El Salvador",		NULL, 676, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'y'), "Syria",			NULL, 677, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'z'), "Swaziland",		NULL, 678, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'c'), "Turks and Caicos Islands",NULL, 679, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'd'), "Chad",			NULL, 680, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'f'), "French Southern Territories",NULL, 681, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'g'), "Togo",			NULL, 682, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'h'), "Thailand",		NULL, 683, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'j'), "Tajikistan",		NULL, 684, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'k'), "Tokelau",			NULL, 685, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'm'), "Turkmenistan",		NULL, 686, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'n'), "Tunisia",			NULL, 687, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'o'), "Tonga",			NULL, 688, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'p'), "East Timor",		NULL, 689, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'r'), "Turkey",			NULL, 690, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 't'), "Trinidad and Tobago",	NULL, 691, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'v'), "Tuvalu",			NULL, 692, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'w'), "Taiwan",			NULL, 693, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'z'), "Tanzania",		NULL, 694, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('u', 'a'), "Ukraine",			NULL, 695, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('u', 'g'), "Uganda",			NULL, 696, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('u', 'k'), "United Kingdom",		NULL, 697, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('u', 'm'), "US Minor Outlying Islands",NULL, 698, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('u', 's'), "United States",		NULL, 699, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('u', 'y'), "Uruguay",			NULL, 700, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('u', 'z'), "Uzbekistan",		NULL, 701, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('v', 'a'), "Vatican City State (Holy See)",NULL, 702, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('v', 'c'), "Saint Vincent and the Grenadines",NULL, 703, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('v', 'e'), "Venezuela",		NULL, 704, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('v', 'g'), "Virgin Islands (British)",NULL, 705, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('v', 'i'), "Virgin Islands (U.S.)",	NULL, 706, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('v', 'n'), "Viet Nam",		NULL, 707, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('v', 'u'), "Vanuatu",			NULL, 708, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('w', 'f'), "Wallis and Futuna Islands",NULL, 709, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('w', 's'), "Samoa",			NULL, 710, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('y', 'e'), "Yemen",			NULL, 711, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('y', 't'), "Mayotte",			NULL, 712, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('y', 'u'), "Yugoslavia",		NULL, 713, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('z', 'a'), "South Africa",		NULL, 714, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('z', 'm'), "Zambia",			NULL, 715, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('z', 'r'), "Zaire (former)",		NULL, 716, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR('z', 'w'), "Zimbabwe",		NULL, 717, 0L, 0L, 0L, 0L, 0.0 },

	/* well-known TLDs */
	{ CC_PAIR3('n', 'e', 't'), "Network",	 	NULL, 718, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR3('i', 'n', 't'), "International",	NULL, 719, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR3('o', 'r', 'g'), "Non-Profit Organization",NULL, 720, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR3('c', 'o', 'm'), "US Commercial",	NULL, 721, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR3('e', 'd', 'u'), "US Educational",	NULL, 722, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR3('g', 'o', 'v'), "US Government",	NULL, 723, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR3('m', 'i', 'l'), "US Military",  	NULL, 724, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR4('a', 'r', 'p', 'a'), "Old style Arpanet",NULL, 725, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR4('n', 'a', 't', 'o'), "Nato field",	NULL, 726, 0L, 0L, 0L, 0L, 0.0 },

	/* new CORE TLDs */
	{ CC_PAIR3('w', 'e', 'b'), "WWW Provider",	NULL, 727, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR3('r', 'e', 'c'), "Recreation",	NULL, 728, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR3('n', 'o', 'm'), "Personal WWW",	NULL, 729, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR4('f', 'i', 'r', 'm'), "Company/Firm", NULL, 730, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR4('i', 'n', 'f', 'o'), "Information",	NULL, 731, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR4('s', 'h', 'o', 'p'), "Online Shop",	NULL, 732, 0L, 0L, 0L, 0L, 0.0 },
	{ CC_PAIR4('a', 'r', 't', 's'), "Arts",		NULL, 733, 0L, 0L, 0L, 0L, 0.0 }
};
