/*
** config.h	per-site compilation options for http-analyze.
**
** Copyright  1996-1999 by Stefan Stapelberg, <stefan@rent-a-guru.de>
**
** $Id: config.h,v 2.4 1999/10/30 09:39:35 stefan Stab $
**
*/

/*
** Macros for customization
**
** NO_GETHOSTNAME
**	Don't use gethostname(2) to obtain the system name.
**	Normally, http-analyze tries to obtain the server
**	name using gethostname(3), since this function returns
**	the full qualified domain name if the system is set up
**	properly. Define this macro if your system does not
**	have the gethostname function.
**
** NO_UNAME
**	Don't use uname(2) to obtain system name and platform/OS.
**	This functions also returns the system name, but without
**	domain. Define this macro if you have no uname(2) function.
**	neither uname nor gethostname is available, you can still
**	set the server name via the -S command line option.
**
** FAST_CTYPE
**	If defined, use own character classification functions
**	rather than them from the C stdlib. On an Indy our own
**	functions are much faster than the ones from the stdlib.
**
** USE_FGETS
**	Use fgets(3) from the stdlib to read lines. If left
**	undefined, the program uses a highly optimized read
**	function which processes its input in big chunks.
**	The following two macros are significant only if
**	USE_FGETS is left undefined.
**
** USE_STBLKSIZE
**	If stat(2) returns a st_blksize (best I/O block size)
**	field, use it's value for the size of the I/O buffer.
**
** USE_XPGCAT (preferred method)
** USE_SVR4CAT
** USE_MYCAT
**	Use XPG4 or SVR4 message catalogs for language support.
**	Requires setlocale(), and either setcat() and gettxt()
**	for SVR4 MNLS message catalogs or catopen() and catgets()
**	for XPG/4 message catalogs. If you have neither XPG4 nor
**	SVR4 message catalogs, define USE_MYCAT to include an own
**	implementation of catopen/catgets. Leave all three macros
**	undefined to use hard-coded strings in plain english. The
**	function setlocale() is required in any case, but this
**	should be no problem, since setlocale() is part of ANSI-C.
**	
** NO_SYMLINK
**	http-analyze automatically creates required files and
**	buttons by copying or symlinking them from HA_LIBDIR
**	into OutputDir. This macro can be defined for platforms
**	without symlink capabilities. Code to conditionally use
**	symlinks is included if this macro is left unefined (default).
**
** VRML
**	Include code for generation of VRML model.
**	May be set to the following values:
**	  (defined)	include VRML code
**	  OLD_LAYOUT	use old layout (two separate VRML models)
**	Note: The type of the window (extern/intern) is now defined
**	by an option or a configureation setting.
**
** LOGF_DEFAULT
**	Defines the default format of the logfile. Usually
**	set in the config file or via command line option.
**	If left undefined, http-analyze tries to recognize
**	the Common Logfile Format (CLF) and the Extended
**	Logfile Format (ELF) automatically. Therefore you
**	do not need to define this macro.
**
** TIME_STATS
**	If defined, includes code for performance analysis.
**
** OLD_GDLIB
**	If defined, changes image format from PNG back to GIF
**	for linking with older versions of the GD library.
**
**
** Supporting functions in support.c (define the appropriate
** macro to include them):
**
** NEED_GETOPT		include own getopt(3)
** NEED_STRCASECMP	include own strcasecmp(3)
** NEED_STRERROR	include own strerror(3)
** NEED_SNPRINTF	include snprintf(3)
** NEED_VSNPRINTF	include vsnprintf(3)
** NEED_WAITPID		simulate waitpid(2)
*/

/*
** Predefined configurations exist for:
**	IRIX	- SGI IRIX 5.X/6.X
**	SUN	- SunOS 4.x/Solaris 2.x
**	AIX	- IBM AIX 4.2
**	HPUX	- HP/UX 10.20
**	linux	- Linux flavours
**	DEC	- Digital Unix
**	SCO	- SCO 3.2
**	BSD	- BSD flavours such as BSDI, FreeBSD and NetBSD
**	SVR4	- AT&T System V Release 4
**	SVR3	- AT&T System V Release 3
**	WIN32	- Windows 95/98/NT
**
*/

#define VRML		/* Always include a VRML model */
#define NEED_SNPRINTF	/* Include own snprintf() function */
#define NEED_VSNPRINTF	/* Include own vsnprintf() function */

#if defined(IRIX)
# define USE_STBLKSIZE	/* Best block size for I/O depends on file type */
# define USE_XPGCAT	/* Use X/Open message catalogs */
# define FAST_CTYPE	/* Use fast character classification: for ASCII only! */

#elif defined(SUN)
# undef  USE_STBLKSIZE	/* Sun reports 8KB for block size, this sucks */
# define USE_XPGCAT	/* Use X/Open message catalogs */
# define FAST_CTYPE	/* Use fast character classification: for ASCII only! */
# define NEED_GETOPT	/* use own getopt since stdlib don't know `optopt' */
# if defined(NOT_REALLY_ANSI_C)
#  define NEED_STRERROR	/* Need own strerror() function */
# endif

#elif defined(AIX)
# define USE_STBLKSIZE
# define USE_XPGCAT	/* Use X/Open message catalogs */
# define FAST_CTYPE	/* Use fast character classification: for ASCII only! */

#elif defined(HPUX)
# define USE_STBLKSIZE
# define USE_XPGCAT	/* Use X/Open message catalogs */
# define FAST_CTYPE	/* Use fast character classification: for ASCII only! */

#elif defined(linux) || defined(Linux) || defined(LINUX)
# undef  USE_STBLKSIZE	/* Linux reports 4KB for block size, this sucks even more */
# define USE_XPGCAT	/* Use X/Open message catalogs */
# define FAST_CTYPE	/* Use fast character classification: for ASCII only! */

#elif defined(SCO)
# define USE_STBLKSIZE
# define USE_XPGCAT	/* Use X/Open message catalogs */
# define FAST_CTYPE	/* Use fast character classification: for ASCII only! */

#elif defined(BSD)
# define USE_STBLKSIZE
# define USE_XPGCAT	/* Use X/Open message catalogs */
# define FAST_CTYPE	/* Use fast character classification: for ASCII only! */

#elif defined(DEC)
# define USE_STBLKSIZE
# define USE_XPGCAT	/* Use X/Open message catalogs */
# define FAST_CTYPE	/* Use fast character classification: for ASCII only! */

#elif defined(SVR4)
# define USE_STBLKSIZE
# define USE_XPGCAT	/* Use X/Open message catalogs */
# define FAST_CTYPE	/* Use fast character classification: for ASCII only! */

#elif defined(SVR3)
# define USE_FGETS	/* Use fgets() instead of highly optimized native function */
# define USE_MYCAT	/* Use native message catalogs */
# define FAST_CTYPE	/* Use fast character classification: for ASCII only! */
# define NO_GETHOSTNAME	/* No gethostname() available, use uname() */
# define NEED_STRERROR	/* Need own strerror() function */
# define NEED_STRCASECMP /* Need own strcasecmp() function */
# define NEED_WAITPID	/* Need simulation of waitpid() function */

#elif defined(WIN32)
# define NEED_GETOPT	/* Need own getopt() function */
# define NO_SYMLINK	/* Has no symlinks */
# define NO_UNAME	/* Has even no uname() function */
# define USE_MYCAT	/* Use native message catalogs */

/* Note: the NETWARE port is not supported yet */
#elif defined(NETWARE)
# define NEED_GETOPT	/* Need own getopt() function */
# define NO_SYMLINK	/* Has no symlinks */
# define NO_UNAME	/* Has even no uname() function */
# define USE_MYCAT	/* Use native message catalogs */

#elif defined(configure_your_platform_here)
# define FAST_CTYPE	/* Use fast character classification: for ASCII only! */
# define NO_GETHOSTNAME	/* No gethostname() available, use uname() */
# define USE_STBLKSIZE	/* Try this to adapt the I/O size to the file type */
# define USE_XPGCAT	/* Use X/Open message catalogs */

# undef  USE_FGETS
# undef  NO_UNAME
# undef  NEED_GETOPT
# undef  NEED_STRCASECMP
# undef  NEED_STRERROR
# undef  NEED_WAITPID

#else
# error "Define the appropriate platform in the Makefile:"
# error "IRIX/SVR4/SYSV/BSD/HPUX/AIX/DEC/SCO/SUN/linux/WIN32"
#endif

#if !defined(HA_LIBDIR)
# define HA_LIBDIR	"/usr/local/lib/http-analyze"
#endif

#if !defined(WIN32)
# define REGID_FILE	"REGID"
#else
# define REGID_FILE	"SOFTWARE\\Rent-A-Guru\\Http-Analyze2.3"
#endif

/* End of user configuration section. */
