/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io.j2me.http;

import com.sun.cdc.io.ConnectionBase;
import com.sun.cdc.io.DateParser;
import com.sun.cdc.io.j2me.http.HttpStreamConnection;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.StreamConnection;

public class Protocol
extends ConnectionBase
implements HttpConnection {
    private int index;
    protected String url;
    protected String protocol = "http";
    protected String host;
    private String file;
    private String ref;
    private String query;
    protected int port = 80;
    protected int responseCode = -1;
    protected String responseMsg;
    protected Hashtable reqProperties = new Hashtable();
    protected Hashtable headerFields = new Hashtable();
    private String[] headerFieldNames;
    private String[] headerFieldValues;
    protected String method = "GET";
    protected int opens = 0;
    protected int mode;
    protected Socket socket = null;
    protected boolean connected = false;
    protected boolean outputStreamOpened = false;
    protected boolean requested = false;
    private PrivateInputStream in;
    private PrivateOutputStream out;
    private DataInputStream appDataIn;
    private DataOutputStream appDataOut;
    private StreamConnection streamConnection;
    private DataOutputStream streamOutput;
    private DataInputStream streamInput;
    private StringBuffer stringbuffer = new StringBuffer(32);
    private String proxyHost = null;
    private int proxyPort = 80;
    private String http_version = "HTTP/1.1";

    public Protocol() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            String string = System.getProperty("microedition.profiles");
            String string2 = string != null && string.indexOf("MIDP") != -1 ? System.getProperty("com.sun.midp.io.http.proxy") : System.getProperty("com.sun.cdc.io.http.proxy");
            this.parseProxy(string2);
        }
    }

    protected void checkPermission(String string, int n, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(string, n);
        }
    }

    protected void outputStreamPermissionCheck() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.host != null) {
                securityManager.checkConnect(this.host, this.port);
            } else {
                securityManager.checkConnect("localhost", this.port);
            }
        }
    }

    protected void inputStreamPermissionCheck() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.host != null) {
                securityManager.checkConnect(this.host, this.port);
            } else {
                securityManager.checkConnect("localhost", this.port);
            }
        }
    }

    public void open(String string, int n, boolean bl) throws IOException {
        if (this.opens > 0) {
            throw new IOException("already connected");
        }
        ++this.opens;
        if (n != 1 && n != 2 && n != 3) {
            throw new IOException("illegal mode: " + n);
        }
        this.url = string;
        this.mode = n;
        this.parseURL();
        if (this.host.indexOf(47) != -1 || this.host.indexOf(64) != -1 || this.host.indexOf(63) != -1 || this.host.indexOf(59) != -1) {
            throw new IllegalArgumentException("hostname " + this.host + " cannot contain \"?\" , \"@\" , \";\", \":\", or \"/\" character.");
        }
        this.checkPermission(this.host, this.port, this.file);
        try {
            this.streamConnection = this.connectSocket();
            this.connectStream();
        }
        catch (UnknownHostException unknownHostException) {
            throw new ConnectionNotFoundException("Could not find " + this.host + ":" + this.port);
        }
    }

    public void close() throws IOException {
        if (--this.opens == 0 && (this.connected || this.requested)) {
            this.disconnect();
        }
    }

    public InputStream openInputStream() throws IOException {
        this.inputStreamPermissionCheck();
        if (this.opens == 0) {
            throw new IOException("connection is closed");
        }
        if (this.mode != 1 && this.mode != 3) {
            throw new IOException("write-only connection");
        }
        this.connect();
        ++this.opens;
        this.in = new PrivateInputStream();
        return this.in;
    }

    public DataInputStream openDataInputStream() throws IOException {
        if (this.opens == 0) {
            throw new IOException("connection is closed");
        }
        if (this.in == null) {
            this.openInputStream();
        }
        this.appDataIn = new DataInputStream(this.in);
        return this.appDataIn;
    }

    public OutputStream openOutputStream() throws IOException {
        return this.openDataOutputStream();
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        this.outputStreamPermissionCheck();
        if (this.mode != 2 && this.mode != 3) {
            throw new IOException("read-only connection");
        }
        if (this.opens == 0) {
            throw new IOException("connection is closed");
        }
        ++this.opens;
        this.out = new PrivateOutputStream();
        this.outputStreamOpened = true;
        return new DataOutputStream(this.out);
    }

    protected void ensureOpen() throws IOException {
        if (this.opens == 0) {
            throw new IOException("Connection closed");
        }
    }

    public String getURL() {
        return this.protocol + ":" + this.url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host.length() == 0 ? null : this.host;
    }

    public String getFile() {
        return this.file.length() == 0 ? null : this.file;
    }

    public String getRef() {
        return this.ref.length() == 0 ? null : this.ref;
    }

    public String getQuery() {
        return this.query.length() == 0 ? null : this.query;
    }

    public int getPort() {
        return this.port;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public void setRequestMethod(String string) throws IOException {
        this.ensureOpen();
        if (this.connected) {
            throw new IOException("connection already open");
        }
        if (!(string.equals("HEAD") || string.equals("GET") || string.equals("POST"))) {
            throw new IOException("unsupported method: " + string);
        }
        if (this.outputStreamOpened) {
            return;
        }
        this.method = new String(string);
    }

    public String getRequestProperty(String string) {
        return (String)this.reqProperties.get(string);
    }

    public void setRequestProperty(String string, String string2) throws IOException {
        this.ensureOpen();
        if (this.connected) {
            throw new IOException("connection already open");
        }
        if (this.outputStreamOpened) {
            return;
        }
        this.reqProperties.put(string, string2);
    }

    public int getResponseCode() throws IOException {
        this.ensureOpen();
        this.connect();
        return this.responseCode;
    }

    public String getResponseMessage() throws IOException {
        this.ensureOpen();
        this.connect();
        return this.responseMsg;
    }

    public long getLength() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            return -1L;
        }
        try {
            return this.getHeaderFieldInt("content-length", -1);
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public String getType() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            return this.getHeaderField("content-type");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getEncoding() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            return this.getHeaderField("content-encoding");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public long getExpiration() throws IOException {
        return this.getHeaderFieldDate("expires", 0L);
    }

    public long getDate() throws IOException {
        return this.getHeaderFieldDate("date", 0L);
    }

    public long getLastModified() throws IOException {
        return this.getHeaderFieldDate("last-modified", 0L);
    }

    public String getHeaderField(String string) throws IOException {
        this.ensureOpen();
        try {
            this.connect();
        }
        catch (IOException iOException) {
            return null;
        }
        return (String)this.headerFields.get(this.toLowerCase(string));
    }

    public String getHeaderField(int n) throws IOException {
        this.ensureOpen();
        try {
            this.connect();
        }
        catch (IOException iOException) {
            return null;
        }
        if (this.headerFieldValues == null) {
            this.makeHeaderFieldValues();
        }
        if (n >= this.headerFieldValues.length) {
            return null;
        }
        return this.headerFieldValues[n];
    }

    public String getHeaderFieldKey(int n) throws IOException {
        this.ensureOpen();
        try {
            this.connect();
        }
        catch (IOException iOException) {
            return null;
        }
        if (this.headerFieldNames == null) {
            this.makeHeaderFields();
        }
        if (n >= this.headerFieldNames.length) {
            return null;
        }
        return this.headerFieldNames[n];
    }

    private void makeHeaderFields() {
        int n = 0;
        this.headerFieldNames = new String[this.headerFields.size()];
        Enumeration enumeration = this.headerFields.keys();
        while (enumeration.hasMoreElements()) {
            this.headerFieldNames[n++] = (String)enumeration.nextElement();
        }
    }

    private void makeHeaderFieldValues() {
        int n = 0;
        this.headerFieldValues = new String[this.headerFields.size()];
        Enumeration enumeration = this.headerFields.keys();
        while (enumeration.hasMoreElements()) {
            this.headerFieldValues[n++] = (String)this.headerFields.get(enumeration.nextElement());
        }
    }

    public int getHeaderFieldInt(String string, int n) throws IOException {
        this.ensureOpen();
        try {
            this.connect();
        }
        catch (IOException iOException) {
            return n;
        }
        try {
            return Integer.parseInt(this.getHeaderField(string));
        }
        catch (Throwable throwable) {
            return n;
        }
    }

    public long getHeaderFieldDate(String string, long l) throws IOException {
        this.ensureOpen();
        try {
            this.connect();
        }
        catch (IOException iOException) {
            return l;
        }
        try {
            return DateParser.parse(this.getHeaderField(string));
        }
        catch (Throwable throwable) {
            return l;
        }
    }

    protected StreamConnection connectSocket() throws IOException {
        if (this.host.equals("")) {
            throw new IllegalArgumentException("Host not recognized." + this.host);
        }
        HttpStreamConnection httpStreamConnection = null;
        httpStreamConnection = this.proxyHost == null ? new HttpStreamConnection(this.host, this.port) : new HttpStreamConnection(this.proxyHost, this.proxyPort);
        return httpStreamConnection;
    }

    protected void connectStream() throws IOException {
        if (this.streamConnection == null) {
            this.streamConnection = this.connectSocket();
        }
        this.streamOutput = this.streamConnection.openDataOutputStream();
        if (this.getRequestProperty("Content-Length") == null || this.getRequestProperty("Content-Length").equals("0")) {
            this.reqProperties.put("Content-Length", "" + (this.out == null ? 0 : this.out.size()));
        }
        if (this.proxyHost == null) {
            String string = this.method + " " + this.getFile() + (this.getRef() == null ? "" : "#" + this.getRef()) + (this.getQuery() == null ? "" : "?" + this.getQuery()) + " " + this.http_version + "\r\n";
        } else {
            String string = this.method + " " + "http://" + this.host + ":" + this.port + this.getFile() + (this.getRef() == null ? "" : "#" + this.getRef()) + (this.getQuery() == null ? "" : "?" + this.getQuery()) + " " + this.http_version + "\r\n";
        }
        this.requested = true;
    }

    protected void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.streamConnection == null) {
            this.streamConnection = this.connectSocket();
        }
        this.streamOutput = this.streamConnection.openDataOutputStream();
        if (this.getRequestProperty("Content-Length") == null || this.getRequestProperty("Content-Length").equals("0")) {
            this.reqProperties.put("Content-Length", "" + (this.out == null ? 0 : this.out.size()));
        }
        String string = this.proxyHost == null ? this.method + " " + this.getFile() + (this.getRef() == null ? "" : "#" + this.getRef()) + (this.getQuery() == null ? "" : "?" + this.getQuery()) + " " + this.http_version + "\r\n" : this.method + " " + "http://" + this.host + ":" + this.port + (this.getFile() == null ? "/" : this.getFile()) + (this.getRef() == null ? "" : "#" + this.getRef()) + (this.getQuery() == null ? "" : "?" + this.getQuery()) + " " + this.http_version + "\r\n";
        this.streamOutput.write(string.getBytes());
        this.reqProperties.put("Host", this.host + ":" + this.port);
        Enumeration enumeration = this.reqProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = string2 + ": " + this.reqProperties.get(string2) + "\r\n";
            this.streamOutput.write(string3.getBytes());
        }
        this.streamOutput.write("\r\n".getBytes());
        if (this.out != null) {
            this.streamOutput.write(this.out.toByteArray());
        }
        this.streamOutput.flush();
        this.streamInput = this.streamConnection.openDataInputStream();
        this.readResponseMessage(this.streamInput);
        this.readHeaders(this.streamInput);
        this.connected = true;
    }

    private void readResponseMessage(InputStream inputStream) throws IOException {
        block3: {
            int n;
            String string;
            int n2;
            String string2 = this.readLine(inputStream);
            this.responseCode = -1;
            this.responseMsg = null;
            if (string2 != null && (n2 = string2.indexOf(32)) >= 0 && (string = string2.substring(0, n2)).startsWith("HTTP") && string2.length() > n2 && (n = string2.substring(n2 + 1).indexOf(32)) >= 0 && string2.length() > (n += n2 + 1)) {
                try {
                    this.responseCode = Integer.parseInt(string2.substring(n2 + 1, n));
                }
                catch (NumberFormatException numberFormatException) {
                    break block3;
                }
                this.responseMsg = string2.substring(n + 1);
                return;
            }
        }
        throw new InterruptedIOException("malformed response message");
    }

    private void readHeaders(InputStream inputStream) throws IOException {
        String string;
        while ((string = this.readLine(inputStream)) != null && !string.equals("")) {
            int n = string.indexOf(58);
            if (n < 0) {
                throw new IOException("malformed header field");
            }
            String string2 = string.substring(0, n);
            if (string2.length() == 0) {
                throw new IOException("malformed header field");
            }
            String string3 = string.length() <= n + 2 ? "" : string.substring(n + 2);
            this.headerFields.put(this.toLowerCase(string2), string3);
        }
        return;
    }

    private String readLine(InputStream inputStream) {
        this.stringbuffer.setLength(0);
        while (true) {
            int n;
            try {
                while (true) {
                    if ((n = inputStream.read()) < 0) {
                        return null;
                    }
                    if (n == 13) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                return null;
            }
            if (n == 10) break;
            this.stringbuffer.append((char)n);
        }
        return this.stringbuffer.toString();
    }

    protected void disconnect() throws IOException {
        if (this.streamConnection != null) {
            if (this.streamInput != null) {
                this.streamInput.close();
            }
            if (this.streamOutput != null) {
                this.streamOutput.close();
            }
            this.disconnectSocket();
            this.streamConnection = null;
        }
        this.responseCode = -1;
        this.responseMsg = null;
        this.connected = false;
    }

    protected void disconnectSocket() throws IOException {
        if (this.streamConnection != null) {
            this.streamConnection.close();
        }
    }

    private String parseProtocol() throws IOException {
        int n = this.url.indexOf(58);
        if (n <= 0) {
            throw new IOException("malformed URL");
        }
        String string = this.url.substring(0, n);
        if (!string.equals("http")) {
            throw new IOException("protocol must be 'http'");
        }
        this.index = n + 1;
        return string;
    }

    private String parseHostname() throws IOException {
        int n;
        int n2;
        int n3;
        String string = this.url.substring(this.index);
        if (string.startsWith("//")) {
            string = string.substring(2);
            this.index += 2;
        }
        if ((n3 = string.indexOf(58)) < 0) {
            n3 = string.indexOf(47);
        }
        if (n3 < 0) {
            n3 = string.length();
        }
        if ((n2 = string.indexOf("[")) > (n = string.indexOf("]"))) {
            throw new IllegalArgumentException("invalid host name " + string);
        }
        if (n2 == 0 && n > 0) {
            return this.parseIPv6Address(string, n);
        }
        String string2 = string.substring(0, n3);
        this.index += n3;
        return string2;
    }

    private String parseIPv6Address(String string, int n) {
        this.index += n + 1;
        return string.substring(0, n + 1);
    }

    private int parsePort(int n) throws IOException {
        int n2 = n;
        String string = this.url.substring(this.index);
        if (!string.startsWith(":")) {
            return n2;
        }
        string = string.substring(1);
        ++this.index;
        int n3 = string.indexOf(47);
        if (n3 < 0) {
            n3 = string.indexOf(63);
        }
        if (n3 < 0) {
            n3 = string.length();
        }
        try {
            n2 = Integer.parseInt(string.substring(0, n3));
            if (n2 <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("invalid port");
        }
        this.index += n3;
        return n2;
    }

    private String parseFile() throws IOException {
        String string = "";
        String string2 = this.url.substring(this.index);
        if (string2.length() == 0) {
            return string;
        }
        if (!string2.startsWith("/") && !string2.startsWith("?")) {
            throw new IOException("invalid path");
        }
        int n = string2.indexOf(35);
        int n2 = string2.indexOf(63);
        if (n < 0 && n2 < 0) {
            n = string2.length();
        } else if (n < 0 || n2 > 0 && n2 < n) {
            n = n2;
        }
        string = string2.substring(0, n);
        this.index += n;
        return string;
    }

    private String parseRef() throws IOException {
        String string = this.url.substring(this.index);
        if (string.length() == 0 || string.charAt(0) == '?') {
            return "";
        }
        if (!string.startsWith("#")) {
            throw new IOException("invalid ref");
        }
        int n = string.indexOf(63);
        if (n < 0) {
            n = string.length();
        }
        this.index += n;
        return string.substring(1, n);
    }

    private String parseQuery() throws IOException {
        String string = this.url.substring(this.index);
        if (string.length() == 0) {
            return "";
        }
        if (string.startsWith("?")) {
            String string2 = string.substring(1);
            int n = string.indexOf(35);
            if (n > 0) {
                string2 = string.substring(1, n);
                this.index += n;
            }
            return string2;
        }
        return "";
    }

    protected synchronized void parseURL() throws IOException {
        this.index = 0;
        this.host = this.parseHostname();
        this.port = this.protocol.equals("http") ? this.parsePort(80) : this.parsePort(443);
        this.file = this.parseFile();
        this.query = this.parseQuery();
        this.ref = this.parseRef();
    }

    protected synchronized void parseProxy(String string) {
        if (string != null) {
            this.index = 0;
            try {
                this.proxyHost = this.parseHostname();
                this.proxyPort = this.parsePort(80);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String toLowerCase(String string) {
        this.stringbuffer.setLength(0);
        for (int i = 0; i < string.length(); ++i) {
            this.stringbuffer.append(Character.toLowerCase(string.charAt(i)));
        }
        return this.stringbuffer.toString();
    }

    class PrivateOutputStream
    extends OutputStream {
        private ByteArrayOutputStream output = new ByteArrayOutputStream();

        public void write(int n) throws IOException {
            this.output.write(n);
            Protocol.this.reqProperties.put("Content-Length", "" + this.output.size());
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.output.write(byArray, n, n2);
            Protocol.this.reqProperties.put("Content-Length", "" + this.output.size());
        }

        public void write(byte[] byArray) throws IOException {
            String string = Protocol.this.method + " " + Protocol.this.getFile() + (Protocol.this.getRef() == null ? "" : "#" + Protocol.this.getRef()) + (Protocol.this.getQuery() == null ? "" : "?" + Protocol.this.getQuery()) + " " + Protocol.this.http_version + "\r\n";
            this.write(string.getBytes(), 0, string.length());
            Protocol.this.reqProperties.put("Host", Protocol.this.host + ":" + Protocol.this.port);
            Enumeration enumeration = Protocol.this.reqProperties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = string2 + ": " + Protocol.this.reqProperties.get(string2) + "\r\n";
                this.write(string3.getBytes(), 0, string3.length());
            }
            this.write("\r\n".getBytes(), 0, "\r\n".length());
            this.write(byArray, 0, byArray.length);
            Protocol.this.reqProperties.put("Content-Length", "" + this.output.size());
        }

        public void flush() throws IOException {
            if (this.output.size() > 0) {
                Protocol.this.connect();
            }
        }

        public byte[] toByteArray() {
            return this.output.toByteArray();
        }

        public int size() {
            return this.output.size();
        }

        public void close() throws IOException {
            if (Protocol.this.opens == 0) {
                return;
            }
            this.flush();
            if (--Protocol.this.opens == 0 && Protocol.this.connected) {
                Protocol.this.disconnect();
            }
            Protocol.this.outputStreamOpened = false;
        }
    }

    class PrivateInputStream
    extends InputStream {
        int bytesleft;
        boolean chunked;
        boolean eof;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        PrivateInputStream() throws IOException {
            block8: {
                this.bytesleft = 0;
                this.chunked = false;
                this.eof = false;
                String string2 = (String)Protocol.this.headerFields.get("transfer-encoding");
                if (string2 != null && string2.equals("chunked")) {
                    this.chunked = true;
                    this.bytesleft = this.readChunkSize();
                    this.eof = this.bytesleft == 0;
                }
                if (string2 != null) return;
                String string = (String)Protocol.this.headerFields.get("content-length");
                if (string == null) return;
                try {
                    try {
                        this.bytesleft = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.bytesleft = -1;
                        Object var6_5 = null;
                        if (this.bytesleft < 0) {
                            throw new IOException("Bad Content-Length value");
                        }
                        this.eof = this.bytesleft == 0;
                        return;
                    }
                    Object var6_4 = null;
                    if (this.bytesleft >= 0) break block8;
                    throw new IOException("Bad Content-Length value");
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (this.bytesleft < 0) {
                        throw new IOException("Bad Content-Length value");
                    }
                    this.eof = this.bytesleft == 0;
                    throw throwable;
                }
            }
            this.eof = this.bytesleft == 0;
        }

        public int available() throws IOException {
            if (Protocol.this.connected) {
                if (this.bytesleft > 0) {
                    return this.bytesleft;
                }
                return Protocol.this.streamInput.available();
            }
            throw new IOException("connection is not open");
        }

        public int read() throws IOException {
            if (this.eof) {
                return -1;
            }
            if (this.bytesleft <= 0 && this.chunked) {
                this.readCRLF();
                this.bytesleft = this.readChunkSize();
                if (this.bytesleft == 0) {
                    this.eof = true;
                    return -1;
                }
            }
            int n = Protocol.this.streamInput.read();
            --this.bytesleft;
            this.eof = n == -1 || !this.chunked && this.bytesleft == 0;
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.eof) {
                return -1;
            }
            if (this.chunked && this.bytesleft <= 0) {
                this.readCRLF();
                this.bytesleft = this.readChunkSize();
                if (this.bytesleft == 0) {
                    this.eof = true;
                    return -1;
                }
            }
            if (n2 > this.bytesleft) {
                n2 = this.bytesleft;
            }
            if ((n3 = Protocol.this.streamInput.read(byArray, n, n2)) < 0) {
                this.eof = true;
            } else {
                this.bytesleft -= n3;
                this.eof = !this.chunked && this.bytesleft <= 0;
            }
            return n3;
        }

        private int readChunkSize() throws IOException {
            int n = -1;
            try {
                char c;
                int n2;
                String string = Protocol.this.readLine(Protocol.this.streamInput);
                if (string == null) {
                    throw new IOException("No Chunk Size");
                }
                for (n2 = 0; n2 < string.length() && Character.digit(c = string.charAt(n2), 16) != -1; ++n2) {
                }
                n = Integer.parseInt(string.substring(0, n2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Bogus chunk size");
            }
            return n;
        }

        private void readCRLF() throws IOException {
            int n = Protocol.this.streamInput.read();
            if (n != 13) {
                throw new IOException("missing CRLF");
            }
            n = Protocol.this.streamInput.read();
            if (n != 10) {
                throw new IOException("missing CRLF");
            }
        }

        public void close() throws IOException {
            if (--Protocol.this.opens == 0 && Protocol.this.connected) {
                Protocol.this.disconnect();
            }
        }
    }
}

