/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.security.AccessControlContext;
import java.security.AccessController;
import sun.misc.CVM;
import sun.misc.ThreadRegistry;
import sun.security.util.SecurityConstants;

public class Thread
implements Runnable {
    private char[] name;
    private int priority;
    private long eetop;
    private boolean single_step;
    private boolean daemon = false;
    private boolean alive = false;
    private boolean hasStartedOnce = false;
    private boolean stillborn = false;
    private boolean wasInterrupted = false;
    private Object lock = new Object();
    private static Object staticLock = new Object();
    private Runnable target;
    private ThreadGroup group;
    private ClassLoader contextClassLoader;
    private AccessControlContext inheritedAccessControlContext;
    private static int threadInitNumber;
    ThreadLocal.ThreadLocalMap threadLocals = null;
    ThreadLocal.ThreadLocalMap inheritableThreadLocals = null;
    private long stackSize;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static ThreadGroup systemThreadGroup;
    private static ThreadGroup mainThreadGroup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextThreadNum() {
        Object object = staticLock;
        synchronized (object) {
            return threadInitNumber++;
        }
    }

    public static native Thread currentThread();

    private static native void setCurrentThread(Thread var0);

    public static native void yield();

    public static void sleep(long l) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        Thread.sleep0(l);
    }

    private static native void sleep0(long var0) throws InterruptedException;

    public static void sleep(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n >= 500000 || n != 0 && l == 0L) {
            ++l;
        }
        Thread.sleep0(l);
    }

    private void init(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
        if (!CVM.objectInflatePermanently(this.lock)) {
            throw new OutOfMemoryError();
        }
        Thread thread = Thread.currentThread();
        if (thread == null) {
            Thread.setCurrentThread(this);
            thread = this;
        }
        if (threadGroup == null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                threadGroup = securityManager.getThreadGroup();
            }
            if (threadGroup == null) {
                threadGroup = thread.getThreadGroup();
            }
        }
        threadGroup.checkAccess();
        threadGroup.addUnstarted();
        this.group = threadGroup;
        this.daemon = thread.isDaemon();
        this.name = string.toCharArray();
        this.priority = thread.getPriority();
        this.contextClassLoader = thread.contextClassLoader;
        this.inheritedAccessControlContext = AccessController.getContext();
        this.target = runnable;
        this.setPriority(this.priority);
        if (thread.inheritableThreadLocals != null) {
            this.inheritableThreadLocals = ThreadLocal.createInheritedMap(thread.inheritableThreadLocals);
        }
        this.stackSize = l;
    }

    private void init(ThreadGroup threadGroup, Runnable runnable, String string) {
        Thread thread = Thread.currentThread();
        this.init(threadGroup, runnable, string, thread.getPriority());
    }

    public Thread() {
        this.init(null, null, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(Runnable runnable) {
        this.init(null, runnable, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this.init(threadGroup, runnable, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(String string) {
        this.init(null, null, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this.init(threadGroup, null, string, 0L);
    }

    private Thread(ThreadGroup threadGroup, String string, int n, long l) {
        this.eetop = l;
        this.priority = n;
        this.init(threadGroup, null, string, 0L);
    }

    private static void initMainThread(int n, long l) {
        systemThreadGroup = new ThreadGroup();
        mainThreadGroup = new ThreadGroup(systemThreadGroup, "main");
        Thread thread = new Thread(mainThreadGroup, "main", n, l);
        mainThreadGroup.add(thread);
        ThreadRegistry.add(thread);
        thread.alive = true;
    }

    private static Thread initAttachedThread(ThreadGroup threadGroup, String string, int n, long l, boolean bl) {
        if (threadGroup == null) {
            threadGroup = mainThreadGroup;
        }
        if (string == null) {
            string = "Thread-" + Thread.nextThreadNum();
        }
        Thread thread = new Thread(threadGroup, string, n, l);
        thread.daemon = bl;
        ThreadRegistry.add(thread);
        return thread;
    }

    private static Thread initDaemonThread(String string, int n) {
        Thread thread = new Thread(systemThreadGroup, string);
        thread.priority = n;
        thread.daemon = true;
        ThreadRegistry.add(thread);
        return thread;
    }

    private void reinitLVMStartupThread() {
        systemThreadGroup = new ThreadGroup();
        mainThreadGroup = new ThreadGroup(systemThreadGroup, "main");
        if (this.group != null) {
            this.group.remove(this);
        }
        this.group = systemThreadGroup;
        this.group.add(this);
        this.contextClassLoader = null;
        this.inheritedAccessControlContext = null;
        this.threadLocals = null;
        this.inheritableThreadLocals = null;
    }

    public Thread(Runnable runnable, String string) {
        this.init(null, runnable, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        this.init(threadGroup, runnable, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
        this.init(threadGroup, runnable, string, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.alive || this.hasStartedOnce) {
                throw new IllegalThreadStateException();
            }
            if (!this.stillborn) {
                boolean bl;
                block19: {
                    CVM.disableRemoteExceptions();
                    bl = !CVM.maskInterrupts();
                    try {
                        this.hasStartedOnce = true;
                        this.group.add(this);
                        ThreadRegistry.add(this);
                        Object object2 = Thread.currentThread().lock;
                        synchronized (object2) {
                            this.start0(this.priority);
                        }
                        this.alive = true;
                        Object var6_5 = null;
                        if (this.alive) break block19;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (!this.alive) {
                            try {
                                ThreadRegistry.remove(this);
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            try {
                                this.group.remove(this);
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                        }
                        if (bl) {
                            CVM.unmaskInterrupts();
                        }
                        CVM.enableRemoteExceptions();
                        throw throwable;
                    }
                    try {
                        ThreadRegistry.remove(this);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        this.group.remove(this);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (bl) {
                    CVM.unmaskInterrupts();
                }
                CVM.enableRemoteExceptions();
                {
                }
            }
        }
    }

    private native void start0(int var1);

    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exit(Throwable throwable) {
        Thread.setThreadExiting();
        CVM.disableRemoteExceptions();
        CVM.maskInterrupts();
        this.stillborn = true;
        if (this.group != null) {
            if (throwable != null) {
                try {
                    this.group.uncaughtException(this, throwable);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            try {
                this.group.remove(this);
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
            this.group = null;
        }
        this.target = null;
        Object object = this.lock;
        synchronized (object) {
            ThreadRegistry.remove(this);
            this.eetop = 0L;
            this.alive = false;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startup(boolean bl) {
        try {
            try {
                if (!this.stillborn && ThreadRegistry.threadCreationAllowed()) {
                    if (bl) {
                        CVM.setContextArtificial();
                        this.runNative();
                        CVM.postThreadExit();
                    } else {
                        CVM.setDebugEvents(true);
                        this.run();
                        CVM.postThreadExit();
                        CVM.setDebugEvents(false);
                    }
                }
            }
            finally {
                CVM.disableRemoteExceptions();
                CVM.maskInterrupts();
                this.stillborn = true;
            }
        }
        catch (Throwable throwable) {
            this.exit(throwable);
            return;
        }
        this.exit(null);
    }

    private static native void setThreadExiting();

    private native void runNative();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        this.checkAccess();
        Object object = this.lock;
        synchronized (object) {
            this.wasInterrupted = true;
            this.interrupt0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean interrupted() {
        Thread thread = Thread.currentThread();
        Object object = thread.lock;
        synchronized (object) {
            if (thread.wasInterrupted) {
                thread.wasInterrupted = false;
                return thread.isInterrupted(true);
            }
        }
        return false;
    }

    public boolean isInterrupted() {
        return this.wasInterrupted && this.isInterrupted(false);
    }

    private native boolean isInterrupted(boolean var1);

    public void destroy() {
        throw new NoSuchMethodError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAlive() {
        Object object = this.lock;
        synchronized (object) {
            return this.alive;
        }
    }

    public final void setPriority(int n) {
        this.checkAccess();
        if (n > 10 || n < 1) {
            throw new IllegalArgumentException();
        }
        if (n > this.group.getMaxPriority()) {
            n = this.group.getMaxPriority();
        }
        this.priority = n;
        this.setPriority0(this.priority);
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setName(String string) {
        this.checkAccess();
        this.name = string.toCharArray();
    }

    public final String getName() {
        return String.valueOf(this.name);
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().getThreadGroup().enumerate(threadArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void join(long l) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            long l2 = System.currentTimeMillis();
            long l3 = 0L;
            if (l < 0L) {
                throw new IllegalArgumentException("timeout value is negative");
            }
            if (l == 0L) {
                while (this.isAlive()) {
                    this.lock.wait(0L);
                }
            } else {
                long l4;
                while (this.isAlive() && (l4 = l - l3) > 0L) {
                    this.lock.wait(l4);
                    l3 = System.currentTimeMillis() - l2;
                }
            }
        }
    }

    public final void join(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n >= 500000 || n != 0 && l == 0L) {
            ++l;
        }
        this.join(l);
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDaemon(boolean bl) {
        this.checkAccess();
        Object object = this.lock;
        synchronized (object) {
            if (this.alive) {
                throw new IllegalThreadStateException();
            }
            this.daemon = bl;
        }
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    public String toString() {
        ThreadGroup threadGroup = this.getThreadGroup();
        if (threadGroup != null) {
            return "Thread[" + this.getName() + "," + this.getPriority() + "," + threadGroup.getName() + "]";
        }
        return "Thread[" + this.getName() + "," + this.getPriority() + "," + "" + "]";
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader classLoader;
        if (this.contextClassLoader == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && classLoader != this.contextClassLoader && !this.contextClassLoader.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return this.contextClassLoader;
    }

    public void setContextClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        this.contextClassLoader = classLoader;
    }

    public static native boolean holdsLock(Object var0);

    private native void setPriority0(int var1);

    private native void interrupt0();
}

