/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBufferImpl;
import java.nio.FloatBuffer;
import java.nio.FloatBufferImpl;

class HeapFloatBuffer
extends FloatBufferImpl {
    HeapFloatBuffer(int n, float[] fArray, int n2) {
        super(null, n, fArray, n2);
    }

    public boolean isDirect() {
        return false;
    }

    public FloatBuffer slice() {
        return new HeapFloatBuffer(this.limit - this.position, this.array, this.arrayOffset + this.position);
    }

    public float get(int n) {
        return this.array[this.arrayOffset + this.checkIndex(n)];
    }

    final void copyToArray(float[] fArray, int n, int n2) {
        System.arraycopy(this.array, this.arrayOffset + this.position, fArray, n, n2);
    }

    public FloatBuffer put(int n, float f) {
        this.array[this.arrayOffset + this.checkIndex((int)n)] = f;
        return this;
    }

    void copyFromArray(float[] fArray, int n, int n2) {
        System.arraycopy(fArray, n, this.array, this.arrayOffset + this.position, n2);
    }

    void copyToFloatBuffer(int n, FloatBuffer floatBuffer) {
        floatBuffer.copyFromHeapFloatBuffer(this, n);
    }

    void copyFromHeapFloatBuffer(FloatBuffer floatBuffer, int n) {
        System.arraycopy(floatBuffer.array, floatBuffer.arrayOffset + floatBuffer.position, this.array, this.arrayOffset + this.position, n);
    }

    void copyFromByteBufferAsFloatBuffer(FloatBuffer floatBuffer, int n) {
        HeapFloatBuffer.vanillaCopy(floatBuffer, this, n);
    }

    void copyFromDirectFloatBuffer(FloatBuffer floatBuffer, int n) {
        int n2 = floatBuffer.arrayOffset + (floatBuffer.position << 2);
        ByteBufferImpl.memoryToFloatArray(n2, this.array, this.arrayOffset + this.position, n);
    }
}

