/*
 * 
 * Copyright 2001-2004 The Ant-Contrib project
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.sf.antcontrib.cpptasks.sun;
import java.io.File;
import java.util.Vector;

import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.gcc.GccCompatibleCCompiler;
import net.sf.antcontrib.cpptasks.OptimizationEnum;
/**
 * Adapter for the Sun (r) Forte (tm) C compiler
 * 
 * @author Curt Arnold
 * @author Kenneth Russell
 */
public final class ForteCCompiler extends ForteCompiler {
    protected String getForteCompilerName() {
        return "cc";
    }
    protected boolean isCPlusPlus() {
        return false;
    }
    private static final ForteCCompiler instance = new ForteCCompiler();
    /**
     * Gets singleton instance of this class
     */
    public static ForteCCompiler getInstance() {
        return instance;
    }
    /**
     * Private constructor. Use ForteCCompiler.getInstance() to get singleton
     * instance of this class.
     */
    private ForteCCompiler() {
        super("cc");
    }
}
