// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepOffsetAPI_ThruSections_HeaderFile
#define _BRepOffsetAPI_ThruSections_HeaderFile

#ifndef _TopTools_SequenceOfShape_HeaderFile
#include <TopTools_SequenceOfShape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
#ifndef _BRepBuilderAPI_MakeShape_HeaderFile
#include <BRepBuilderAPI_MakeShape.hxx>
#endif
class TopoDS_Wire;
class TopoDS_Vertex;
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes functions to build a loft. This is a shell or a <br>
//! solid passing through a set of sections in a given <br>
//! sequence. Usually sections are wires, but the first and <br>
//! the last sections may be vertices (punctual sections). <br>
class BRepOffsetAPI_ThruSections  : public BRepBuilderAPI_MakeShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Initializes an algorithm for building a shell or a solid <br>
//! passing through a set of sections, where: <br>
//! -          isSolid is set to true if the construction algorithm is <br>
//!   required to build a solid or to false if it is required to build <br>
//!   a shell (the default value), <br>
//! -          ruled is set to true if the faces generated between <br>
//!   the edges of two consecutive wires are ruled surfaces or to <br>
//!   false (the default value) if they are smoothed out by approximation, <br>
//! -          pres3d defines the precision criterion used by the <br>
//!   approximation algorithm; the default value is 1.0e-6. <br>
//!   Use AddWire and AddVertex to define the <br>
//! successive sections of the shell or solid to be built. <br>
Standard_EXPORT BRepOffsetAPI_ThruSections(const Standard_Boolean isSolid = Standard_False,const Standard_Boolean ruled = Standard_False,const Standard_Real pres3d = 1.0e-06);

//! Initializes this algorithm for building a shell or a solid <br>
//! passing through a set of sections, where: <br>
//! - isSolid is set to true if this construction algorithm is <br>
//!   required to build a solid or to false if it is required to <br>
//!   build a shell. false is the default value; <br>
//! - ruled is set to true if the faces generated between the <br>
//!   edges of two consecutive wires are ruled surfaces or <br>
//! to false (the default value) if they are smoothed out by approximation, <br>
//! - pres3d defines the precision criterion used by the <br>
//!   approximation algorithm; the default value is 1.0e-6. <br>
//!   Use AddWire and AddVertex to define the successive <br>
//! sections of the shell or solid to be built. <br>
Standard_EXPORT   void Init(const Standard_Boolean isSolid = Standard_False,const Standard_Boolean ruled = Standard_False,const Standard_Real pres3d = 1.0e-06) ;

//! Adds the wire wire to the set of <br>
//! sections through which the shell or solid is built. <br>
//! Use the Build function to construct the shape. <br>
Standard_EXPORT   void AddWire(const TopoDS_Wire& wire) ;

//! Adds the vertex Vertex (punctual section) to the set of sections <br>
//! through which the shell or solid is built. A vertex may be added to the <br>
//! set of sections only as first or last section. At least one wire <br>
//! must be added to the set of sections by the method AddWire. <br>
//! Use the Build function to construct the shape. <br>
Standard_EXPORT   void AddVertex(const TopoDS_Vertex& aVertex) ;


Standard_EXPORT   void CheckCompatibility(const Standard_Boolean check = Standard_True) ;


Standard_EXPORT virtual  void Build() ;

//! Returns the TopoDS Shape of the bottom of the loft if solid <br>
Standard_EXPORT  const TopoDS_Shape& FirstShape() const;

//! Returns the TopoDS Shape of the top of the loft if solid <br>
Standard_EXPORT  const TopoDS_Shape& LastShape() const;

//! if Ruled <br>
//!            Returns the Face generated by each edge <br>
//!            except the last wire <br>
//!          if smoothed <br>
//!            Returns the Face generated by each edge of the first wire <br>
Standard_EXPORT   TopoDS_Shape GeneratedFace(const TopoDS_Shape& Edge) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void CreateRuled() ;


Standard_EXPORT   void CreateSmoothed() ;


 // Fields PRIVATE
 //
TopTools_SequenceOfShape myWires;
Standard_Boolean myIsSolid;
Standard_Boolean myIsRuled;
Standard_Boolean myWCheck;
Standard_Real myPres3d;
TopoDS_Face myFirst;
TopoDS_Face myLast;
TopTools_DataMapOfShapeShape myGenerated;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
