// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _DrawTrSurf_Surface_HeaderFile
#define _DrawTrSurf_Surface_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_DrawTrSurf_Surface_HeaderFile
#include <Handle_DrawTrSurf_Surface.hxx>
#endif

#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Draw_Color_HeaderFile
#include <Draw_Color.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _DrawTrSurf_Drawable_HeaderFile
#include <DrawTrSurf_Drawable.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Draw_Drawable3D_HeaderFile
#include <Handle_Draw_Drawable3D.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Geom_Surface;
class Draw_Color;
class Draw_Display;
class Draw_Drawable3D;
class Draw_Interpretor;


//!  This class defines a drawable surface. <br>
//! With this class you can draw a general surface from <br>
//! package Geom. <br>
class DrawTrSurf_Surface : public DrawTrSurf_Drawable {

public:
 // Methods PUBLIC
 // 

//! default drawing mode <br>
//!  Just the middle isoparametric curves are drawn. <br>
//!  The boundaries are yellow, the isoparametric curves are blues. <br>
//!  For the discretisation 50 points are computed in each parametric <br>
//!  direction. <br>
Standard_EXPORT DrawTrSurf_Surface(const Handle(Geom_Surface)& S);


Standard_EXPORT DrawTrSurf_Surface(const Handle(Geom_Surface)& S,const Standard_Integer Nu,const Standard_Integer Nv,const Draw_Color& BoundsColor,const Draw_Color& IsosColor,const Standard_Integer Discret,const Standard_Real Deflection,const Standard_Integer DrawMode);

  Draw_Color BoundsColor() const;

//! rub out all the isoparametric curves. <br>
Standard_EXPORT virtual  void ClearIsos() ;


Standard_EXPORT   void DrawOn(Draw_Display& dis) const;

//! Iso = True : Draw the isos, the boundaries, the UVMarker. <br>
//!          Iso = False: Only Draw the boundary and the UVMarker. <br>
Standard_EXPORT   void DrawOn(Draw_Display& dis,const Standard_Boolean Iso) const;

  Handle_Geom_Surface GetSurface() const;

  Draw_Color IsosColor() const;

  void NbIsos(Standard_Integer& Nu,Standard_Integer& Nb) const;

  void SetBoundsColor(const Draw_Color& aColor) ;

  void SetIsosColor(const Draw_Color& aColor) ;

//! change the number of isoparametric curves to be drawn. <br>
Standard_EXPORT virtual  void ShowIsos(const Standard_Integer Nu,const Standard_Integer Nv) ;

//! For variable copy. <br>
Standard_EXPORT virtual  Handle_Draw_Drawable3D Copy() const;

//! For variable dump. <br>
Standard_EXPORT virtual  void Dump(Standard_OStream& S) const;

//! For variable whatis command. <br>
Standard_EXPORT virtual  void Whatis(Draw_Interpretor& I) const;
//Standard_EXPORT ~DrawTrSurf_Surface();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Handle_Geom_Surface surf;
Draw_Color boundsLook;
Draw_Color isosLook;
Standard_Integer nbUIsos;
Standard_Integer nbVIsos;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};


#include <DrawTrSurf_Surface.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
