// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeomInt_IntSS_HeaderFile
#define _GeomInt_IntSS_HeaderFile

#ifndef _IntPatch_Intersection_HeaderFile
#include <IntPatch_Intersection.hxx>
#endif
#ifndef _GeomInt_LineConstructor_HeaderFile
#include <GeomInt_LineConstructor.hxx>
#endif
#ifndef _Handle_GeomAdaptor_HSurface_HeaderFile
#include <Handle_GeomAdaptor_HSurface.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TColGeom_SequenceOfCurve_HeaderFile
#include <TColGeom_SequenceOfCurve.hxx>
#endif
#ifndef _TColGeom2d_SequenceOfCurve_HeaderFile
#include <TColGeom2d_SequenceOfCurve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Handle_Adaptor3d_TopolTool_HeaderFile
#include <Handle_Adaptor3d_TopolTool.hxx>
#endif
class GeomAdaptor_HSurface;
class StdFail_NotDone;
class Standard_OutOfRange;
class Geom_Surface;
class Geom_Curve;
class Geom2d_Curve;
class gp_Pnt2d;
class Adaptor3d_TopolTool;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class GeomInt_IntSS  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT GeomInt_IntSS();

//! performs general intersection of two surfaces just now <br>
Standard_EXPORT GeomInt_IntSS(const Handle(Geom_Surface)& S1,const Handle(Geom_Surface)& S2,const Standard_Real Tol,const Standard_Boolean Approx = Standard_True,const Standard_Boolean ApproxS1 = Standard_False,const Standard_Boolean ApproxS2 = Standard_False);

//! general intersection of two surfaces <br>
Standard_EXPORT   void Perform(const Handle(Geom_Surface)& S1,const Handle(Geom_Surface)& S2,const Standard_Real Tol,const Standard_Boolean Approx = Standard_True,const Standard_Boolean ApproxS1 = Standard_False,const Standard_Boolean ApproxS2 = Standard_False) ;

//! intersection of adapted surfaces <br>
Standard_EXPORT   void Perform(const Handle(GeomAdaptor_HSurface)& HS1,const Handle(GeomAdaptor_HSurface)& HS2,const Standard_Real Tol,const Standard_Boolean Approx = Standard_True,const Standard_Boolean ApproxS1 = Standard_False,const Standard_Boolean ApproxS2 = Standard_False) ;

//! general intersection using a starting point <br>
Standard_EXPORT   void Perform(const Handle(Geom_Surface)& S1,const Handle(Geom_Surface)& S2,const Standard_Real Tol,const Standard_Real U1,const Standard_Real V1,const Standard_Real U2,const Standard_Real V2,const Standard_Boolean Approx = Standard_True,const Standard_Boolean ApproxS1 = Standard_False,const Standard_Boolean ApproxS2 = Standard_False) ;

//! intersection of adapted surfaces using a starting point <br>
Standard_EXPORT   void Perform(const Handle(GeomAdaptor_HSurface)& HS1,const Handle(GeomAdaptor_HSurface)& HS2,const Standard_Real Tol,const Standard_Real U1,const Standard_Real V1,const Standard_Real U2,const Standard_Real V2,const Standard_Boolean Approx = Standard_True,const Standard_Boolean ApproxS1 = Standard_False,const Standard_Boolean ApproxS2 = Standard_False) ;


Standard_EXPORT   Standard_Boolean IsDone() const;


Standard_EXPORT   Standard_Real TolReached3d() const;


Standard_EXPORT   Standard_Real TolReached2d() const;

  Standard_Integer NbLines() const;


Standard_EXPORT  const Handle_Geom_Curve& Line(const Standard_Integer Index) const;


Standard_EXPORT   Standard_Boolean HasLineOnS1(const Standard_Integer Index) const;


Standard_EXPORT  const Handle_Geom2d_Curve& LineOnS1(const Standard_Integer Index) const;


Standard_EXPORT   Standard_Boolean HasLineOnS2(const Standard_Integer Index) const;


Standard_EXPORT  const Handle_Geom2d_Curve& LineOnS2(const Standard_Integer Index) const;

  Standard_Integer NbBoundaries() const;


Standard_EXPORT  const Handle_Geom_Curve& Boundary(const Standard_Integer Index) const;

  Standard_Integer NbPoints() const;

  gp_Pnt Point(const Standard_Integer Index) const;


Standard_EXPORT   gp_Pnt2d Pnt2d(const Standard_Integer Index,const Standard_Boolean OnFirst) const;


Standard_EXPORT   void SetTolFixTangents(const Standard_Real aTolCheck,const Standard_Real aTolAngCheck) ;


Standard_EXPORT   void TolFixTangents(Standard_Real& aTolCheck,Standard_Real& aTolAngCheck) ;





protected:

 // Methods PROTECTED
 // 


Standard_EXPORT   void InternalPerform(const Standard_Real Tol,const Standard_Boolean Approx,const Standard_Boolean ApproxS1,const Standard_Boolean ApproxS2,const Standard_Boolean useStart,const Standard_Real U1,const Standard_Real V1,const Standard_Real U2,const Standard_Real V2) ;


Standard_EXPORT   void MakeCurve(const Standard_Integer Ind,const Handle(Adaptor3d_TopolTool)& D1,const Handle(Adaptor3d_TopolTool)& D2,const Standard_Real Tol,const Standard_Boolean Approx,const Standard_Boolean Approx1,const Standard_Boolean Approx2) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
IntPatch_Intersection myIntersector;
GeomInt_LineConstructor myLConstruct;
Handle_GeomAdaptor_HSurface myHS1;
Handle_GeomAdaptor_HSurface myHS2;
Standard_Integer myNbrestr;
TColGeom_SequenceOfCurve sline;
TColGeom2d_SequenceOfCurve slineS1;
TColGeom2d_SequenceOfCurve slineS2;
Standard_Real myTolReached2d;
Standard_Real myTolReached3d;
Standard_Real myTolCheck;
Standard_Real myTolAngCheck;


};


#include <GeomInt_IntSS.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
