// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Graphic2d_ViewMapping_HeaderFile
#define _Graphic2d_ViewMapping_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Graphic2d_ViewMapping_HeaderFile
#include <Handle_Graphic2d_ViewMapping.hxx>
#endif

#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Quantity_Factor_HeaderFile
#include <Quantity_Factor.hxx>
#endif


//! A ViewMapping defines a square region of the model <br>
//!	    space from an origin point and a size in meters. <br>
//!	    This square region is called the "map from". <br>
class Graphic2d_ViewMapping : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates a view mapping with the following default <br>
//!	    values : <br>
//!		XCenter	= 0. <br>
//!		YCenter	= 0. <br>
//!		Size	= 1. <br>
Standard_EXPORT Graphic2d_ViewMapping();

//! Sets new values for the view mapping <me>. <br>
Standard_EXPORT   void SetViewMapping(const Quantity_Length aXCenter,const Quantity_Length aYCenter,const Quantity_Length aSize) ;

//! Sets new values for the view mapping center. <br>
Standard_EXPORT   void SetCenter(const Quantity_Length aXCenter,const Quantity_Length aYCenter) ;

//! Sets new value for the view mapping size. <br>
Standard_EXPORT   void SetSize(const Quantity_Length aSize) ;

//! Saves the current mapping which will be the <br>
//!	    reference value for the reset of the mapping <br>
//!	    done by the ViewmappingReset method. <br>
Standard_EXPORT   void SetViewMappingDefault() ;

//! Sets the value of the mapping to be the same as <br>
//!	    the mapping saved by the SetViewMappingDefault method. <br>
Standard_EXPORT   void ViewMappingReset() ;

//! Returns the current mapping of the view <me>. <br>
Standard_EXPORT   void ViewMapping(Quantity_Length& XCenter,Quantity_Length& YCenter,Quantity_Length& Size) const;

//! Returns the current center of the view <me>. <br>
Standard_EXPORT   void Center(Quantity_Length& XCenter,Quantity_Length& YCenter) const;

//! Returns the current reset mapping of the view <me>. <br>
Standard_EXPORT   void ViewMappingDefault(Quantity_Length& XCenter,Quantity_Length& YCenter,Quantity_Length& Size) const;

//! Returns the zoom factor (CurrentSize/InitialSize). <br>
Standard_EXPORT   Quantity_Factor Zoom() const;
//Standard_EXPORT ~Graphic2d_ViewMapping();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Quantity_Length myXCenter;
Quantity_Length myYCenter;
Quantity_Length mySize;
Quantity_Length myInitialXCenter;
Quantity_Length myInitialYCenter;
Quantity_Length myInitialSize;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
