// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntCurve_PConic_HeaderFile
#define _IntCurve_PConic_HeaderFile

#ifndef _gp_Ax22d_HeaderFile
#include <gp_Ax22d.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _GeomAbs_CurveType_HeaderFile
#include <GeomAbs_CurveType.hxx>
#endif
class gp_Elips2d;
class gp_Circ2d;
class gp_Parab2d;
class gp_Hypr2d;
class gp_Lin2d;
class gp_Ax22d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class represents a conic from gp as a <br>
//!          parametric curve ( in order to be used by the <br>
//!          class PConicTool from IntCurve). <br>
class IntCurve_PConic  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT IntCurve_PConic(const IntCurve_PConic& PC);


Standard_EXPORT IntCurve_PConic(const gp_Elips2d& E);


Standard_EXPORT IntCurve_PConic(const gp_Circ2d& C);


Standard_EXPORT IntCurve_PConic(const gp_Parab2d& P);


Standard_EXPORT IntCurve_PConic(const gp_Hypr2d& H);


Standard_EXPORT IntCurve_PConic(const gp_Lin2d& L);

//! EpsX is a internal tolerance used in math <br>
//!          algorithms, usually about 1e-10 <br>
//!          (See FunctionAllRoots for more details) <br>
Standard_EXPORT   void SetEpsX(const Standard_Real EpsDist) ;

//! Accuracy is the number of samples used to <br>
//!          approximate the parametric curve on its domain. <br>
Standard_EXPORT   void SetAccuracy(const Standard_Integer Nb) ;

  Standard_Integer Accuracy() const;

  Standard_Real EpsX() const;
//! The Conics are manipulated as objects which only <br>
//!          depend on three parameters : Axis and two Real from Standards. <br>
//!          Type Curve is used to select the correct Conic. <br>
  GeomAbs_CurveType TypeCurve() const;

 const gp_Ax22d& Axis2() const;

  Standard_Real Param1() const;

  Standard_Real Param2() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Ax22d axe;
Standard_Real prm1;
Standard_Real prm2;
Standard_Real TheEpsX;
Standard_Integer TheAccuracy;
GeomAbs_CurveType type;


};


#include <IntCurve_PConic.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
