// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Intf_Tool_HeaderFile
#define _Intf_Tool_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_OutOfRange;
class gp_Lin2d;
class Bnd_Box2d;
class gp_Hypr2d;
class gp_Parab2d;
class gp_Lin;
class Bnd_Box;
class gp_Hypr;
class gp_Parab;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides services to create box for infinites <br>
//!          lines in a given contexte. <br>
class Intf_Tool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Intf_Tool();


Standard_EXPORT   void Lin2dBox(const gp_Lin2d& theLin2d,const Bnd_Box2d& bounding,Bnd_Box2d& boxLin) ;


Standard_EXPORT   void Hypr2dBox(const gp_Hypr2d& theHypr2d,const Bnd_Box2d& bounding,Bnd_Box2d& boxHypr) ;


Standard_EXPORT   void Parab2dBox(const gp_Parab2d& theParab2d,const Bnd_Box2d& bounding,Bnd_Box2d& boxHypr) ;


Standard_EXPORT   void LinBox(const gp_Lin& theLin,const Bnd_Box& bounding,Bnd_Box& boxLin) ;


Standard_EXPORT   void HyprBox(const gp_Hypr& theHypr,const Bnd_Box& bounding,Bnd_Box& boxHypr) ;


Standard_EXPORT   void ParabBox(const gp_Parab& theParab,const Bnd_Box& bounding,Bnd_Box& boxHypr) ;


Standard_EXPORT   Standard_Integer NbSegments() const;


Standard_EXPORT   Standard_Real BeginParam(const Standard_Integer SegmentNum) const;


Standard_EXPORT   Standard_Real EndParam(const Standard_Integer SegmentNum) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Standard_Integer Inters2d(const gp_Hypr2d& theCurve,const Bnd_Box2d& Domain) ;


Standard_EXPORT   Standard_Integer Inters2d(const gp_Parab2d& theCurve,const Bnd_Box2d& Domain) ;


Standard_EXPORT   Standard_Integer Inters3d(const gp_Hypr& theCurve,const Bnd_Box& Domain) ;


Standard_EXPORT   Standard_Integer Inters3d(const gp_Parab& theCurve,const Bnd_Box& Domain) ;


 // Fields PRIVATE
 //
Standard_Integer nbSeg;
Standard_Real beginOnCurve[6];
Standard_Real endOnCurve[6];


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
