// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _StepData_FieldList_HeaderFile
#define _StepData_FieldList_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_OutOfRange;
class StepData_Field;
class Interface_EntityIterator;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes a list of fields, in a general way <br>
//!           This basic class is for a null size list <br>
//!           Subclasses are for 1, N (fixed) or Dynamic sizes <br>
class StepData_FieldList  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a FieldList of 0 Field <br>
Standard_EXPORT StepData_FieldList();

//! Returns the count of fields. Here, returns 0 <br>
Standard_EXPORT virtual  Standard_Integer NbFields() const;

//! Returns the field n0 <num> between 1 and NbFields (read only) <br>
Standard_EXPORT virtual const StepData_Field& Field(const Standard_Integer num) const;

//! Returns the field n0 <num> between 1 and NbFields, in order to <br>
//!           modify its content <br>
Standard_EXPORT virtual  StepData_Field& CField(const Standard_Integer num) ;

//! Fills an iterator with the entities shared by <me> <br>
Standard_EXPORT   void FillShared(Interface_EntityIterator& iter) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
