// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_FRPR_HeaderFile
#define _math_FRPR_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _math_Vector_HeaderFile
#include <math_Vector.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _math_Status_HeaderFile
#include <math_Status.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Standard_DimensionError;
class StdFail_NotDone;
class math_MultipleVarFunctionWithGradient;
class math_Vector;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! this class implements the Fletcher-Reeves-Polak_Ribiere minimization <br>
//! algorithm of a function of multiple variables. <br>
//! Knowledge of the function's gradient is required. <br>
class math_FRPR  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//!	  Computes FRPR minimization function F from input vector <br>
//! StartingPoint. The solution F = Fi is found when 2.0 * <br>
//! abs(Fi - Fi-1) <= Tolerance * (abs(Fi) + abs(Fi-1) + <br>
//! ZEPS). The maximum number of iterations allowed is given <br>
//! by NbIterations. <br>
Standard_EXPORT math_FRPR(math_MultipleVarFunctionWithGradient& F,const math_Vector& StartingPoint,const Standard_Real Tolerance,const Standard_Integer NbIterations = 200,const Standard_Real ZEPS = 1.0e-12);

//! Purpose <br>
//! Initializes the computation of the minimum of F. <br>
//! Warning <br>
//! A call to the Perform method must be made after this <br>
//! initialization to compute the minimum of the function. <br>
Standard_EXPORT math_FRPR(math_MultipleVarFunctionWithGradient& F,const Standard_Real Tolerance,const Standard_Integer NbIterations = 200,const Standard_Real ZEPS = 1.0e-12);


Standard_EXPORT virtual  void Delete() ;
Standard_EXPORT virtual ~math_FRPR(){Delete();}

//! Use this method after a call to the initialization constructor <br>
//! to compute the minimum of function F. <br>
//! Warning <br>
//! The initialization constructor must have been called before <br>
//! the Perform method is called <br>
Standard_EXPORT   void Perform(math_MultipleVarFunctionWithGradient& F,const math_Vector& StartingPoint) ;


//! The solution F = Fi is found when : <br>
//!   2.0 * abs(Fi - Fi-1) <= Tolerance * (abs(Fi) + abs(Fi-1)) + ZEPS. <br>
//! The maximum number of iterations allowed is given by NbIterations. <br>
Standard_EXPORT virtual  Standard_Boolean IsSolutionReached(math_MultipleVarFunctionWithGradient& F) ;
//! Returns true if the computations are successful, otherwise returns false. <br>
  Standard_Boolean IsDone() const;
//! returns the location vector of the minimum. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
 const math_Vector& Location() const;
//! outputs the location vector of the minimum in Loc. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
//! Exception DimensionError is raised if the range of Loc is not <br>
//! equal to the range of the StartingPoint. <br>
  void Location(math_Vector& Loc) const;
//! returns the value of the minimum. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
  Standard_Real Minimum() const;
//! returns the gradient vector at the minimum. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
 const math_Vector& Gradient() const;
//! outputs the gradient vector at the minimum in Grad. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
//! Exception DimensionError is raised if the range of Grad is not <br>
//! equal to the range of the StartingPoint. <br>
  void Gradient(math_Vector& Grad) const;
//! returns the number of iterations really done during the <br>
//! computation of the minimum. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
  Standard_Integer NbIterations() const;

//! Prints on the stream o information on the current state <br>
//!          of the object. <br>
//!          Is used to redefine the operator <<. <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
math_Vector TheLocation;
math_Vector TheGradient;
Standard_Real TheMinimum;
Standard_Real PreviousMinimum;
Standard_Real XTol;
Standard_Real EPSZ;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean Done;
Standard_Integer Iter;
Standard_Integer State;
math_Status TheStatus;
Standard_Integer Itermax;


};


#include <math_FRPR.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
