// File:	StepToGeom_MakeBoundedCurve2d.cxx
// Created:	Wed Aug  4 11:08:11 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>
//:n6 abv 15.02.99: S4132: adding translation of polyline
//:p0 abv 19.02.99: management of 'done' flag improved

#include <StepToGeom_MakeBoundedCurve2d.ixx>
#include <StdFail_NotDone.hxx>
#include <StepToGeom_MakeBoundedCurve2d.hxx>
#include <StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve.hxx>
#include <StepGeom_BSplineCurveWithKnots.hxx>
#include <StepGeom_TrimmedCurve.hxx>
#include <StepToGeom_MakeTrimmedCurve2d.hxx>
#include <StepToGeom_MakeBSplineCurve2d.hxx>
#include <StepGeom_Polyline.hxx>
#include <StepToGeom_MakePolyline2d.hxx>

//=============================================================================
// Creation d' une BoundedCurve de Geom a partir d' une BoundedCurve de Step
//=============================================================================

StepToGeom_MakeBoundedCurve2d::StepToGeom_MakeBoundedCurve2d( const Handle(StepGeom_BoundedCurve)& C)
{
  done = Standard_False;
  
  if (C->IsKind(STANDARD_TYPE(StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve))) {
    Handle(StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve)
      Bspli = Handle(StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve)::DownCast(C);
    StepToGeom_MakeBSplineCurve2d MkCurve2d(Bspli);
    if ( MkCurve2d.IsDone() ) theBoundedCurve = MkCurve2d.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_BSplineCurveWithKnots))) {
    Handle(StepGeom_BSplineCurveWithKnots)
      Bspli = Handle(StepGeom_BSplineCurveWithKnots)::DownCast(C);
    StepToGeom_MakeBSplineCurve2d MkCurve2d(Bspli);
    if ( MkCurve2d.IsDone() ) theBoundedCurve = MkCurve2d.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_TrimmedCurve))) {
    Handle(StepGeom_TrimmedCurve) TC = Handle(StepGeom_TrimmedCurve)::DownCast(C);
    StepToGeom_MakeTrimmedCurve2d MkTrimmed(TC);
    if ( MkTrimmed.IsDone() ) theBoundedCurve = MkTrimmed.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_Polyline))) { //:n6 abv 15 Feb 99
    Handle(StepGeom_Polyline) PL = Handle(StepGeom_Polyline)::DownCast(C);
    StepToGeom_MakePolyline2d MkPL(PL);
    if ( MkPL.IsDone() ) theBoundedCurve = MkPL.Value();
  }
  done = ! theBoundedCurve.IsNull();
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom2d_BoundedCurve) &
      StepToGeom_MakeBoundedCurve2d::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theBoundedCurve;
}
