#include "petsc.h"
#include "petscfix.h"
/* solve.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "slepceps.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssolve_ EPSSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssolve_ epssolve
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetiterationnumber_ EPSGETITERATIONNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetiterationnumber_ epsgetiterationnumber
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetoperationcounters_ EPSGETOPERATIONCOUNTERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetoperationcounters_ epsgetoperationcounters
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetconverged_ EPSGETCONVERGED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetconverged_ epsgetconverged
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetinvariantsubspace_ EPSGETINVARIANTSUBSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetinvariantsubspace_ epsgetinvariantsubspace
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetleftinvariantsubspace_ EPSGETLEFTINVARIANTSUBSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetleftinvariantsubspace_ epsgetleftinvariantsubspace
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgeteigenpair_ EPSGETEIGENPAIR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgeteigenpair_ epsgeteigenpair
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetvalue_ EPSGETVALUE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetvalue_ epsgetvalue
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetrightvector_ EPSGETRIGHTVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetrightvector_ epsgetrightvector
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetleftvector_ EPSGETLEFTVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetleftvector_ epsgetleftvector
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgeterrorestimate_ EPSGETERRORESTIMATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgeterrorestimate_ epsgeterrorestimate
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgeterrorestimateleft_ EPSGETERRORESTIMATELEFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgeterrorestimateleft_ epsgeterrorestimateleft
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epscomputeresidualnorm_ EPSCOMPUTERESIDUALNORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epscomputeresidualnorm_ epscomputeresidualnorm
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epscomputeresidualnormleft_ EPSCOMPUTERESIDUALNORMLEFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epscomputeresidualnormleft_ epscomputeresidualnormleft
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epscomputerelativeerror_ EPSCOMPUTERELATIVEERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epscomputerelativeerror_ epscomputerelativeerror
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epscomputerelativeerrorleft_ EPSCOMPUTERELATIVEERRORLEFT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epscomputerelativeerrorleft_ epscomputerelativeerrorleft
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssorteigenvalues_ EPSSORTEIGENVALUES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssorteigenvalues_ epssorteigenvalues
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetstartvector_ EPSGETSTARTVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetstartvector_ epsgetstartvector
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetleftstartvector_ EPSGETLEFTSTARTVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetleftstartvector_ epsgetleftstartvector
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  epssolve_(EPS *eps, int *__ierr ){
*__ierr = EPSSolve(*eps);
}
void PETSC_STDCALL  epsgetiterationnumber_(EPS *eps,int *its, int *__ierr ){
*__ierr = EPSGetIterationNumber(*eps,its);
}
void PETSC_STDCALL  epsgetoperationcounters_(EPS *eps,int* ops,int* dots,int* lits, int *__ierr ){
*__ierr = EPSGetOperationCounters(*eps,ops,dots,lits);
}
void PETSC_STDCALL  epsgetconverged_(EPS *eps,int *nconv, int *__ierr ){
*__ierr = EPSGetConverged(*eps,nconv);
}
void PETSC_STDCALL  epsgetinvariantsubspace_(EPS *eps,Vec *v, int *__ierr ){
*__ierr = EPSGetInvariantSubspace(*eps,v);
}
void PETSC_STDCALL  epsgetleftinvariantsubspace_(EPS *eps,Vec *v, int *__ierr ){
*__ierr = EPSGetLeftInvariantSubspace(*eps,v);
}
void PETSC_STDCALL  epsgeteigenpair_(EPS *eps,int *i,PetscScalar *eigr,PetscScalar *eigi,Vec Vr,Vec Vi, int *__ierr ){
*__ierr = EPSGetEigenpair(*eps,*i,eigr,eigi,
	(Vec)PetscToPointer((Vr) ),
	(Vec)PetscToPointer((Vi) ));
}
void PETSC_STDCALL  epsgetvalue_(EPS *eps,int *i,PetscScalar *eigr,PetscScalar *eigi, int *__ierr ){
*__ierr = EPSGetValue(*eps,*i,eigr,eigi);
}
void PETSC_STDCALL  epsgetrightvector_(EPS *eps,int *i,Vec Vr,Vec Vi, int *__ierr ){
*__ierr = EPSGetRightVector(*eps,*i,
	(Vec)PetscToPointer((Vr) ),
	(Vec)PetscToPointer((Vi) ));
}
void PETSC_STDCALL  epsgetleftvector_(EPS *eps,int *i,Vec Wr,Vec Wi, int *__ierr ){
*__ierr = EPSGetLeftVector(*eps,*i,
	(Vec)PetscToPointer((Wr) ),
	(Vec)PetscToPointer((Wi) ));
}
void PETSC_STDCALL  epsgeterrorestimate_(EPS *eps,int *i,PetscReal *errest, int *__ierr ){
*__ierr = EPSGetErrorEstimate(*eps,*i,errest);
}
void PETSC_STDCALL  epsgeterrorestimateleft_(EPS *eps,int *i,PetscReal *errest, int *__ierr ){
*__ierr = EPSGetErrorEstimateLeft(*eps,*i,errest);
}
void PETSC_STDCALL  epscomputeresidualnorm_(EPS *eps,int *i,PetscReal *norm, int *__ierr ){
*__ierr = EPSComputeResidualNorm(*eps,*i,norm);
}
void PETSC_STDCALL  epscomputeresidualnormleft_(EPS *eps,int *i,PetscReal *norm, int *__ierr ){
*__ierr = EPSComputeResidualNormLeft(*eps,*i,norm);
}
void PETSC_STDCALL  epscomputerelativeerror_(EPS *eps,int *i,PetscReal *error, int *__ierr ){
*__ierr = EPSComputeRelativeError(*eps,*i,error);
}
void PETSC_STDCALL  epscomputerelativeerrorleft_(EPS *eps,int *i,PetscReal *error, int *__ierr ){
*__ierr = EPSComputeRelativeErrorLeft(*eps,*i,error);
}
void PETSC_STDCALL  epssorteigenvalues_(int *n,PetscScalar *eig,PetscScalar *eigi,EPSWhich *which,int *nev,int *permout, int *__ierr ){
*__ierr = EPSSortEigenvalues(*n,eig,eigi,*which,*nev,permout);
}
void PETSC_STDCALL  epsgetstartvector_(EPS *eps,int *i,Vec vec,PetscTruth *breakdown, int *__ierr ){
*__ierr = EPSGetStartVector(*eps,*i,
	(Vec)PetscToPointer((vec) ),breakdown);
}
void PETSC_STDCALL  epsgetleftstartvector_(EPS *eps,int *i,Vec vec, int *__ierr ){
*__ierr = EPSGetLeftStartVector(*eps,*i,
	(Vec)PetscToPointer((vec) ));
}
#if defined(__cplusplus)
}
#endif
