/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "FileSystemBackgroundRequestHandler.h"
#include "FileSystemMocks.h"
#include "gtest/gtest.h"
#include "mozilla/SpinEventLoopUntil.h"
#include "mozilla/dom/FileSystemManager.h"
#include "mozilla/dom/FileSystemManagerChild.h"
#include "mozilla/dom/PFileSystemManager.h"

namespace mozilla::dom::fs::test {

class TestFileSystemBackgroundRequestHandler : public ::testing::Test {
 protected:
  void SetUp() override {
    // TODO: Fix the test to not depend on CreateFileSystemManagerParent
    // failure because of the pref set to false.
    nsCOMPtr<nsIPrefBranch> prefs = do_GetService(NS_PREFSERVICE_CONTRACTID);
    prefs->SetBoolPref("dom.fs.enabled", false);

    mFileSystemManagerChild = MakeAndAddRef<TestFileSystemManagerChild>();
  }

  void TearDown() override {
    nsCOMPtr<nsIPrefBranch> prefs = do_GetService(NS_PREFSERVICE_CONTRACTID);
    prefs->SetBoolPref("dom.fs.enabled", true);
  }

  RefPtr<FileSystemBackgroundRequestHandler>
  GetFileSystemBackgroundRequestHandler() {
    return MakeRefPtr<FileSystemBackgroundRequestHandler>(
        new TestFileSystemChildFactory(mFileSystemManagerChild));
  }

  mozilla::ipc::PrincipalInfo mPrincipalInfo = GetPrincipalInfo();
  RefPtr<TestFileSystemManagerChild> mFileSystemManagerChild;
};

TEST_F(TestFileSystemBackgroundRequestHandler,
       isCreateFileSystemManagerChildSuccessful) {
  EXPECT_CALL(*mFileSystemManagerChild, Shutdown())
      .WillOnce([fileSystemManagerChild =
                     static_cast<void*>(mFileSystemManagerChild.get())]() {
        static_cast<TestFileSystemManagerChild*>(fileSystemManagerChild)
            ->FileSystemManagerChild::Shutdown();
      });

  bool done = false;
  auto testable = GetFileSystemBackgroundRequestHandler();
  testable->CreateFileSystemManagerChild(mPrincipalInfo)
      ->Then(GetCurrentSerialEventTarget(), __func__,
             [&done](const FileSystemManagerChild::ActorPromise::
                         ResolveOrRejectValue&) { done = true; });
  // MozPromise should be rejected
  SpinEventLoopUntil("Promise is fulfilled or timeout"_ns,
                     [&done]() { return done; });
}

}  // namespace mozilla::dom::fs::test
