//
// File: test_hyperscore.cpp
// Created by: Olivier Langella
// Created on: 13/3/2015
//
/*******************************************************************************
 * Copyright (c) 2015 Olivier Langella <Olivier.Langella@moulon.inra.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contributors:
 *     Olivier Langella <Olivier.Langella@moulon.inra.fr> - initial API and
 *implementation
 ******************************************************************************/

// ./tests/pappsotree/catch2-only-pappsotree [Fasta] -s
#include <catch2/catch_test_macros.hpp>

#include <iostream>
#include <pappsomspp/core/fasta/fastareader.h>
#include <pappsomspp/core/fasta/fastafileindexer.h>
#include <pappsomspp/core/exception/exceptionoutofrange.h>
#include <QFileInfo>
// #include "common.h"
#include "tests/tests-config.h"

using namespace std;
// using namespace pwiz::msdata;

class FastaSeq : public pappso::FastaHandlerInterface
{
  public:
  const QString &
  getDescription() const
  {
    return description;
  };
  const QString &
  getSequence() const
  {
    return sequence;
  };
  void
  setSequence(const QString &description_in,
              const QString &sequence_in) override
  {
    std::cout << std::endl
              << "begin description=" << description_in.toStdString();
    std::cout << std::endl << "sequence=" << sequence_in.toStdString();
    std::cout << std::endl << "end" << std::endl;
    description = description_in;
    sequence    = sequence_in;
  };

  private:
  QString description;
  QString sequence;
};


TEST_CASE("Fasta reader test suite.", "[Fasta]")
{
  // Set the debugging message formatting pattern.
  qSetMessagePattern(QString("%{file}@%{line}, %{function}(): %{message}"));


  SECTION("..:: Test Fasta big file indexer ::..", "[FastaBigIndexer]")
  {
    FastaSeq seq;
    std::cout << std::endl
              << "..:: Test Fasta big file indexer ::.." << std::endl;
    QFileInfo file2("/gorgone/pappso/moulon/database/Genome_Z_mays_5a.fasta");
    pappso::FastaFileIndexer big_fasta_file_indexer(file2);
    big_fasta_file_indexer.getSequenceByIndex(seq, 12);

    std::cout << std::endl << seq.getDescription().toStdString() << std::endl;

    // GRMZM2G147579_P01
    // GRMZM2G147579_P01 NP_001159186 hypothetical protein LOC100304271
    // seq=translation; coord=5:217415249..217417029:-1;
    // parent_transcript=GRMZM2G147579_T01; parent_gene=GRMZM2G147579

    REQUIRE(seq.getDescription() ==
            "GRMZM2G147579_P01 NP_001159186 hypothetical protein LOC100304271 "
            "seq=translation; coord=5:217415249..217417029:-1; "
            "parent_transcript=GRMZM2G147579_T01; parent_gene=GRMZM2G147579");
  }


}

