/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.expr.path;

import jd.xml.xpath.XPathContext;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.expr.ExpressionVisitor;
import jd.xml.xpath.expr.path.LocationStep;
import jd.xml.xpath.expr.path.SimpleLocationStep;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xpath.model.walk.ModelWalker;
import jd.xml.xpath.object.XMutableNodeSet;
import jd.xml.xpath.object.XNodeSet;
import jd.xml.xpath.object.XNodeSetFactory;

public class FilteredLocationStep
extends LocationStep {
    private Expression filter_;
    private boolean isUniqueFilter_;
    private boolean useProximityFilter_;

    public static FilteredLocationStep create(SimpleLocationStep simpleLocationStep, Expression expression) {
        if (!expression.hasContextDependencies(2)) {
            boolean bl = expression.isUniqueFilter();
            if (simpleLocationStep.getAxis().isForwardAxis()) {
                return new FilteredLocationStep(simpleLocationStep, expression, bl, false);
            }
            if (bl) {
                return new FilteredLocationStep(simpleLocationStep, expression, true, true);
            }
            if (!FilteredLocationStep.isPositionFilter(expression)) {
                return new FilteredLocationStep(simpleLocationStep, expression, false, false);
            }
        }
        return null;
    }

    private static boolean isPositionFilter(Expression expression) {
        if (expression.hasContextDependencies(4)) {
            return true;
        }
        int n = expression.getResultType();
        return n == 1 || n == 4;
    }

    private FilteredLocationStep(SimpleLocationStep simpleLocationStep, Expression expression, boolean bl, boolean bl2) {
        super(simpleLocationStep.getAxis(), simpleLocationStep.getNodeTest());
        this.filter_ = expression;
        this.isUniqueFilter_ = bl;
        this.useProximityFilter_ = bl2;
    }

    public int getMaxResultSize() {
        return this.isUniqueFilter_ ? 1 : super.getMaxResultSize();
    }

    public XNodeSet toNodeSet(XPathContext xPathContext, int n) {
        XMutableNodeSet xMutableNodeSet = XNodeSetFactory.create(n, this.maxAxisResultSize_);
        this.getNodes(xPathContext, xMutableNodeSet);
        return xMutableNodeSet;
    }

    public void getNodes(XPathContext xPathContext, XMutableNodeSet xMutableNodeSet) {
        XPathNode xPathNode = xPathContext.getNode();
        xPathContext.startNewState();
        xPathContext.setNode(xPathNode);
        ModelWalker modelWalker = this.useProximityFilter_ ? this.axis_.getProximityModelWalker() : this.axis_.getModelWalker();
        boolean bl = this.isUniqueFilter_ || xMutableNodeSet.getOrdering() == 4;
        int n = this.axis_.getPrincipalNodeType();
        int n2 = 0;
        XPathNode xPathNode2 = modelWalker.gotoFirstNode(xPathNode);
        while (xPathNode2 != null) {
            if (this.nodeTest_.accept(xPathNode2, n)) {
                xPathContext.setNode(xPathNode2);
                xPathContext.setPosition(++n2);
                if (this.filter_.matchesFilter(xPathContext)) {
                    xMutableNodeSet.addNode(xPathNode2);
                    if (bl) break;
                }
            }
            xPathNode2 = modelWalker.gotoNextNode(xPathNode2);
        }
        xPathContext.restoreState();
    }

    public int getContextDependencies() {
        return super.getContextDependencies() | this.filter_.getContextDependencies();
    }

    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.locationStep(this, this.axis_, this.nodeTest_, this.filter_, this.useProximityFilter_, this.isUniqueFilter_);
    }
}

