/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.result;

import jd.xml.xpath.model.NamespaceContext;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.format.OutputFormat;
import jd.xml.xslt.result.NamespaceSupport;
import jd.xml.xslt.result.ResultBuilder;
import jd.xml.xslt.result.ResultLevel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomResultBuilder
extends ResultBuilder {
    private boolean addNamespaceAttributes_;
    private DomLevel level_;
    private Document document_;
    private Node resultRoot_;
    private Node currentNode_;
    private StringBuffer text_ = new StringBuffer();
    private NamespaceSupport nsSupport_;

    public DomResultBuilder(Document document) {
        this(document, document);
    }

    public DomResultBuilder(Document document, Node node) {
        super(null);
        this.document_ = document;
        this.resultRoot_ = this.currentNode_ = node;
    }

    public Node getResultRoot() {
        return this.resultRoot_;
    }

    public void startDocument(OutputFormat outputFormat) {
        this.level_ = new DomLevel();
        this.level_.level = -1;
        this.nsSupport_ = new NamespaceSupport();
    }

    public void endDocument() {
        this.flush();
    }

    public void startElement(String string, String string2, NamespaceContext namespaceContext, boolean bl) {
        this.flush();
        this.nsSupport_.startElement(string, namespaceContext, this.level_.namespaceContext);
        this.addNamespaceAttributes_ = true;
        this.level_ = (DomLevel)this.level_.increase();
        this.level_.namespaceContext = namespaceContext;
        this.level_.isCDataSectionElement = bl;
        Element element = this.document_.createElementNS(string, string2);
        this.currentNode_.appendChild(element);
        this.currentNode_ = element;
    }

    public void endElement() {
        this.flush();
        this.currentNode_ = this.currentNode_.getParentNode();
        this.level_ = (DomLevel)this.level_.decrease();
        this.nsSupport_.endElement();
    }

    public void addNamespace(String string, String string2, boolean bl) {
        if (bl) {
            if (this.currentNode_.getNodeType() != 1) {
                return;
            }
            if (this.currentNode_.getAttributes().getLength() != 0) {
                return;
            }
        }
        this.nsSupport_.addDeclaration(string, string2, !bl);
    }

    public String getNamespacePrefix(String string) {
        return this.nsSupport_.getPrefix(string);
    }

    public void addAttribute(String string, String string2, String string3, String string4) {
        if (this.currentNode_.getNodeType() != 1) {
            throw new XsltException("cannot add an attribute or namespace to node " + this.currentNode_);
        }
        if (string3 != null) {
            string = this.nsSupport_.adjustAttributeName(string, string2, string3);
        }
        ((Element)this.currentNode_).setAttribute(string, string4);
    }

    public void addComment(String string) {
        this.flush();
        this.currentNode_.appendChild(this.document_.createComment(string));
    }

    public void addProcessingInstruction(String string, String string2) {
        this.flush();
        this.currentNode_.appendChild(this.document_.createProcessingInstruction(string, string2));
    }

    public void addText(String string) {
        if (string != null && string.length() > 0) {
            this.text_.append(string);
        }
    }

    public void addTextUnescaped(String string) {
        this.addText(string);
    }

    private void flush() {
        if (this.addNamespaceAttributes_) {
            this.addNamespaceAttributes_ = false;
            NamespaceSupport.Declaration declaration = this.nsSupport_.getElementDeclarations();
            while (declaration != null) {
                ((Element)this.currentNode_).setAttribute(declaration.getName(), declaration.uri);
                declaration = declaration.next;
            }
        }
        if (this.text_.length() > 0) {
            if (this.level_.isCDataSectionElement) {
                this.currentNode_.appendChild(this.document_.createCDATASection(this.text_.toString()));
            } else {
                this.currentNode_.appendChild(this.document_.createTextNode(this.text_.toString()));
            }
            this.text_.setLength(0);
        }
    }

    public ResultBuilder getSubResultBuilder(String string, OutputFormat outputFormat) {
        Document document = this.document_.getImplementation().createDocument(null, string, null);
        return new DomResultBuilder(document);
    }

    private static class DomLevel
    extends ResultLevel {
        public NamespaceContext namespaceContext;
        public boolean isCDataSectionElement;

        private DomLevel() {
        }

        public ResultLevel create() {
            return new DomLevel();
        }
    }
}

