/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.tool;

import alt.jiapi.file.Attribute;
import alt.jiapi.file.ClassFile;
import alt.jiapi.file.Method;
import java.io.FileOutputStream;
import java.util.List;

public class ClassTool {
    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.out.println("ClassTool <file.class> remove-attribute <name>");
            System.exit(0);
        }
        ClassTool ct = new ClassTool();
        ClassFile cf = ClassFile.parse(args[0]);
        if ("remove-attribute".equals(args[1])) {
            if (args.length == 3) {
                ct.removeAttribute(cf, args[2]);
            } else {
                ct.removeAttribute(cf, args[2], args[3]);
            }
        }
        byte[] bytes = cf.toBytes();
        FileOutputStream fos = new FileOutputStream(args[0]);
        fos.write(bytes);
    }

    public void removeAttribute(ClassFile cf, String name) {
        List attrs = cf.getAttributes();
        boolean found = false;
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute a = (Attribute)attrs.get(i);
            if (!name.equals(a.getName())) continue;
            attrs.remove(i);
            found = true;
            break;
        }
        if (!found) {
            System.out.println("ERROR: Could not find class attribute " + name);
        }
    }

    public void removeAttribute(ClassFile cf, String method, String name) {
        Method m = this.findMethod(method, cf.getMethods());
        if (m == null) {
            System.out.println("ERROR: Could not find method " + method);
            return;
        }
        List attrs = m.getAttributes();
        boolean found = false;
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute a = (Attribute)attrs.get(i);
            if (!name.equals(a.getName())) continue;
            attrs.remove(i);
            found = true;
            break;
        }
        if (!found) {
            System.out.println("ERROR: Could not find method attribute " + name);
        }
    }

    private Method findMethod(String name, List il) {
        for (Method m : il) {
            if (!name.equals(m.getName())) continue;
            return m;
        }
        return null;
    }
}

